require '_h2ph_pre.ph';

unless(defined(&_MACHINE_PARAM_H_)) {
    eval 'sub _MACHINE_PARAM_H_ () {1;}' unless defined(&_MACHINE_PARAM_H_);
    if(defined(&_KERNEL)) {
	unless(defined(&_LOCORE)) {
	    require 'machine/cpu.ph';
	}
    }
    eval 'sub _MACHINE () { &mvme88k;}' unless defined(&_MACHINE);
    eval 'sub MACHINE () {"mvme88k";}' unless defined(&MACHINE);
    eval 'sub _MACHINE_ARCH () { &m88k;}' unless defined(&_MACHINE_ARCH);
    eval 'sub MACHINE_ARCH () {"m88k";}' unless defined(&MACHINE_ARCH);
    eval 'sub MID_MACHINE () { &MID_M88K;}' unless defined(&MID_MACHINE);
    eval 'sub OLD_MID_MACHINE () {151;}' unless defined(&OLD_MID_MACHINE);
    eval 'sub ALIGNBYTES () {15;}' unless defined(&ALIGNBYTES);
    eval 'sub ALIGN {
        local($p) = @_;
	    eval q(((($p) +  &ALIGNBYTES) & ~ &ALIGNBYTES));
    }' unless defined(&ALIGN);
    eval 'sub ALIGNED_POINTER {
        local($p,$t) = @_;
	    eval q((((($p)) & ($sizeof{$t}-1)) == 0));
    }' unless defined(&ALIGNED_POINTER);
    eval 'sub NBPG () {(1<<  &PGSHIFT);}' unless defined(&NBPG);
    eval 'sub PGOFSET () {( &NBPG-1);}' unless defined(&PGOFSET);
    eval 'sub PGSHIFT () {12;}' unless defined(&PGSHIFT);
    eval 'sub PAGE_SHIFT () {12;}' unless defined(&PAGE_SHIFT);
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    eval 'sub NPTEPG () {( &PAGE_SIZE / ($sizeof{ &pt_entry_t}));}' unless defined(&NPTEPG);
    eval 'sub KERNBASE () {0x;}' unless defined(&KERNBASE);
    eval 'sub KERNTEXTOFF () {0x10000;}' unless defined(&KERNTEXTOFF);
    eval 'sub DEV_BSHIFT () {9;}' unless defined(&DEV_BSHIFT);
    eval 'sub DEV_BSIZE () {(1<<  &DEV_BSHIFT);}' unless defined(&DEV_BSIZE);
    eval 'sub BLKDEV_IOSIZE () {2048;}' unless defined(&BLKDEV_IOSIZE);
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
    eval 'sub SSIZE () {1;}' unless defined(&SSIZE);
    eval 'sub SINCR () {1;}' unless defined(&SINCR);
    eval 'sub UPAGES () {8;}' unless defined(&UPAGES);
    eval 'sub USPACE () {( &UPAGES *  &NBPG);}' unless defined(&USPACE);
    eval 'sub UADDR () {0xeee00000;}' unless defined(&UADDR);
    eval 'sub UVPN () {( &UADDR>> &PGSHIFT);}' unless defined(&UVPN);
    eval 'sub KERNELSTACK () {( &UADDR+ &UPAGES* &NBPG);}' unless defined(&KERNELSTACK);
    eval 'sub PHYSIO_MAP_START () {0xeef00000;}' unless defined(&PHYSIO_MAP_START);
    eval 'sub PHYSIO_MAP_SIZE () {0x100000;}' unless defined(&PHYSIO_MAP_SIZE);
    eval 'sub IOMAP_MAP_START () {0xef000000;}' unless defined(&IOMAP_MAP_START);
    eval 'sub IOMAP_SIZE () {0x18f0000;}' unless defined(&IOMAP_SIZE);
    eval 'sub NIOPMAP () {32;}' unless defined(&NIOPMAP);
    eval 'sub MSIZE () {256;}' unless defined(&MSIZE);
    eval 'sub MCLSHIFT () {11;}' unless defined(&MCLSHIFT);
    eval 'sub MCLBYTES () {(1<<  &MCLSHIFT);}' unless defined(&MCLBYTES);
    eval 'sub MCLOFSET () {( &MCLBYTES - 1);}' unless defined(&MCLOFSET);
    unless(defined(&NMBCLUSTERS)) {
	if(defined(&GATEWAY)) {
	    eval 'sub NMBCLUSTERS () {1024;}' unless defined(&NMBCLUSTERS);
	} else {
	    eval 'sub NMBCLUSTERS () {512;}' unless defined(&NMBCLUSTERS);
	}
    }
    eval 'sub NKMEMPAGES_MIN_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MIN_DEFAULT);
    eval 'sub NKMEMPAGES_MAX_DEFAULT () {((4* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
    eval 'sub MSGBUFSIZE () { &PAGE_SIZE;}' unless defined(&MSGBUFSIZE);
    eval 'sub ctod {
        local($x) = @_;
	    eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&ctod);
    eval 'sub dtoc {
        local($x) = @_;
	    eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }' unless defined(&dtoc);
    eval 'sub ctob {
        local($x) = @_;
	    eval q((($x) <<  &PGSHIFT));
    }' unless defined(&ctob);
    eval 'sub btoc {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }' unless defined(&btoc);
    eval 'sub btodb {
        local($x) = @_;
	    eval q((($x) >>  &DEV_BSHIFT));
    }' unless defined(&btodb);
    eval 'sub dbtob {
        local($x) = @_;
	    eval q((($x) <<  &DEV_BSHIFT));
    }' unless defined(&dbtob);
    eval 'sub bdbtofsb {
        local($bn) = @_;
	    eval q((($bn) / ( &BLKDEV_IOSIZE/ &DEV_BSIZE)));
    }' unless defined(&bdbtofsb);
    require 'machine/intr.ph';
    if(defined(&_KERNEL)) {
	eval 'sub DELAY {
	    local($x) = @_;
    	    eval q( &delay($x));
	}' unless defined(&DELAY);
    }
    eval 'sub BRD_187 () {0x187;}' unless defined(&BRD_187);
    eval 'sub BRD_188 () {0x188;}' unless defined(&BRD_188);
    eval 'sub BRD_197 () {0x197;}' unless defined(&BRD_197);
    eval 'sub BRD_8120 () {0x8120;}' unless defined(&BRD_8120);
    eval 'sub CPU_88100 () {0x100;}' unless defined(&CPU_88100);
    eval 'sub CPU_88110 () {0x110;}' unless defined(&CPU_88110);
    eval 'sub MOD_LE () {0x1;}' unless defined(&MOD_LE);
    eval 'sub MOD_SP () {0x2;}' unless defined(&MOD_SP);
    eval 'sub MOD_DP () {0x3;}' unless defined(&MOD_DP);
}
1;
