require '_h2ph_pre.ph';

unless(defined(&_MACHINE_MMU_H_)) {
    eval 'sub _MACHINE_MMU_H_ () {1;}' unless defined(&_MACHINE_MMU_H_);
    eval 'sub SDT_BITS () {10;}' unless defined(&SDT_BITS);
    eval 'sub PDT_BITS () {10;}' unless defined(&PDT_BITS);
    eval 'sub PG_BITS () { &PAGE_SHIFT;}' unless defined(&PG_BITS);
    eval 'sub PG_FRAME () {0xfffff000;}' unless defined(&PG_FRAME);
    eval 'sub PG_SHIFT () { &PG_BITS;}' unless defined(&PG_SHIFT);
    eval 'sub PG_PFNUM {
        local($x) = @_;
	    eval q(((($x) &  &PG_FRAME) >>  &PG_SHIFT));
    }' unless defined(&PG_PFNUM);
    eval 'sub CACHE_DFL () {0x;}' unless defined(&CACHE_DFL);
    eval 'sub CACHE_INH () {0x40;}' unless defined(&CACHE_INH);
    eval 'sub CACHE_GLOBAL () {0x80;}' unless defined(&CACHE_GLOBAL);
    eval 'sub CACHE_WT () {0x200;}' unless defined(&CACHE_WT);
    eval 'sub CACHE_MASK () {(~( &CACHE_INH |  &CACHE_GLOBAL |  &CACHE_WT));}' unless defined(&CACHE_MASK);
    eval 'sub PATC_ENTRIES () {56;}' unless defined(&PATC_ENTRIES);
    eval 'sub SDT_ENTRY_NULL () {( 0);}' unless defined(&SDT_ENTRY_NULL);
    eval 'sub SG_V () {0x1;}' unless defined(&SG_V);
    eval 'sub SG_NV () {0x;}' unless defined(&SG_NV);
    eval 'sub SG_PROT () {0x4;}' unless defined(&SG_PROT);
    eval 'sub SG_RO () {0x4;}' unless defined(&SG_RO);
    eval 'sub SG_RW () {0x;}' unless defined(&SG_RW);
    eval 'sub SG_SO () {0x100;}' unless defined(&SG_SO);
    eval 'sub SDT_VALID {
        local($sdt) = @_;
	    eval q((*($sdt) &  &SG_V));
    }' unless defined(&SDT_VALID);
    eval 'sub SDT_SUP {
        local($sdt) = @_;
	    eval q((*($sdt) &  &SG_SO));
    }' unless defined(&SDT_SUP);
    eval 'sub SDT_WP {
        local($sdt) = @_;
	    eval q((*($sdt) &  &SG_PROT));
    }' unless defined(&SDT_WP);
    eval 'sub PT_ENTRY_NULL () {( 0);}' unless defined(&PT_ENTRY_NULL);
    eval 'sub PG_V () {0x1;}' unless defined(&PG_V);
    eval 'sub PG_NV () {0x;}' unless defined(&PG_NV);
    eval 'sub PG_PROT () {0x4;}' unless defined(&PG_PROT);
    eval 'sub PG_U () {0x8;}' unless defined(&PG_U);
    eval 'sub PG_M () {0x10;}' unless defined(&PG_M);
    eval 'sub PG_RO () {0x4;}' unless defined(&PG_RO);
    eval 'sub PG_RW () {0x;}' unless defined(&PG_RW);
    eval 'sub PG_SO () {0x100;}' unless defined(&PG_SO);
    eval 'sub PG_W () {0x20;}' unless defined(&PG_W);
    eval 'sub PG_U0 () {0x400;}' unless defined(&PG_U0);
    eval 'sub PG_U1 () {0x800;}' unless defined(&PG_U1);
    eval 'sub PDT_VALID {
        local($pte) = @_;
	    eval q((*($pte) &  &PG_V));
    }' unless defined(&PDT_VALID);
    eval 'sub PDT_SUP {
        local($pte) = @_;
	    eval q((*($pte) &  &PG_SO));
    }' unless defined(&PDT_SUP);
    eval 'sub PDT_WP {
        local($pte) = @_;
	    eval q((*($pte) &  &PG_PROT));
    }' unless defined(&PDT_WP);
    eval 'sub IND_V () {0x1;}' unless defined(&IND_V);
    eval 'sub IND_NV () {0x;}' unless defined(&IND_NV);
    eval 'sub IND_MASKED () {0x2;}' unless defined(&IND_MASKED);
    eval 'sub IND_UNMASKED () {0x3;}' unless defined(&IND_UNMASKED);
    eval 'sub IND_MASK () {0x3;}' unless defined(&IND_MASK);
    eval 'sub IND_FRAME () {0xfffffffc;}' unless defined(&IND_FRAME);
    eval 'sub IND_SHIFT () {2;}' unless defined(&IND_SHIFT);
    eval 'sub IND_PDA {
        local($x) = @_;
	    eval q((($x) &  &IND_FRAME >>  &IND_SHIFT));
    }' unless defined(&IND_PDA);
    eval 'sub SDT_ENTRIES () {(1<<( &SDT_BITS));}' unless defined(&SDT_ENTRIES);
    eval 'sub PDT_ENTRIES () {(1<<( &PDT_BITS));}' unless defined(&PDT_ENTRIES);
    eval 'sub SDT_SIZE () {($sizeof{ &sdt_entry_t} *  &SDT_ENTRIES);}' unless defined(&SDT_SIZE);
    eval 'sub PDT_SIZE () {($sizeof{ &pt_entry_t} *  &PDT_ENTRIES);}' unless defined(&PDT_SIZE);
    eval 'sub SDT_SHIFT () {( &PDT_BITS +  &PG_BITS);}' unless defined(&SDT_SHIFT);
    eval 'sub PDT_SHIFT () {( &PG_BITS);}' unless defined(&PDT_SHIFT);
    eval 'sub SDT_MASK () {(((1<< &SDT_BITS)-1) <<  &SDT_SHIFT);}' unless defined(&SDT_MASK);
    eval 'sub PDT_MASK () {(((1<< &PDT_BITS)-1) <<  &PDT_SHIFT);}' unless defined(&PDT_MASK);
    eval 'sub SDT_NEXT {
        local($va) = @_;
	    eval q(((($va) + (1<< &SDT_SHIFT)) &  &SDT_MASK));
    }' unless defined(&SDT_NEXT);
    eval 'sub PDT_NEXT {
        local($va) = @_;
	    eval q(((($va) + (1<< &PDT_SHIFT)) & ( &SDT_MASK| &PDT_MASK)));
    }' unless defined(&PDT_NEXT);
    eval 'sub SDTIDX {
        local($va) = @_;
	    eval q(((($va) &  &SDT_MASK) >>  &SDT_SHIFT));
    }' unless defined(&SDTIDX);
    eval 'sub PDTIDX {
        local($va) = @_;
	    eval q(((($va) &  &PDT_MASK) >>  &PDT_SHIFT));
    }' unless defined(&PDTIDX);
    eval 'sub SDTENT {
        local($map, $va) = @_;
	    eval q(((($map)-> &pm_stab +  &SDTIDX($va))));
    }' unless defined(&SDTENT);
    eval 'sub LOG2_PDT_SIZE () {( &PDT_BITS + 2);}' unless defined(&LOG2_PDT_SIZE);
    eval 'sub LOG2_PDT_TABLE_GROUP_SIZE () {( &PAGE_SHIFT -  &LOG2_PDT_SIZE);}' unless defined(&LOG2_PDT_TABLE_GROUP_SIZE);
    eval 'sub PDT_TABLE_GROUP_SIZE () {(1<<  &LOG2_PDT_TABLE_GROUP_SIZE);}' unless defined(&PDT_TABLE_GROUP_SIZE);
    eval 'sub PT_FREE {
        local($tbl) = @_;
	    eval q( &uvm_km_free( &kernel_map, $tbl,  &PAGE_SIZE));
    }' unless defined(&PT_FREE);
    eval 'sub PDT_VA_SPACE () {( &PDT_ENTRIES *  &PAGE_SIZE);}' unless defined(&PDT_VA_SPACE);
    eval 'sub PDT_TABLE_GROUP_VA_SPACE () {( &PDT_VA_SPACE *  &PDT_TABLE_GROUP_SIZE);}' unless defined(&PDT_TABLE_GROUP_VA_SPACE);
    eval 'sub USER_SDT_ENTRIES () { &SDTIDX( &VM_MIN_KERNEL_ADDRESS);}' unless defined(&USER_SDT_ENTRIES);
    eval 'sub KERNEL_SDT_ENTRIES () {( &SDT_ENTRIES -  &USER_SDT_ENTRIES);}' unless defined(&KERNEL_SDT_ENTRIES);
    eval 'sub BATC_BLKSHIFT () {19;}' unless defined(&BATC_BLKSHIFT);
    eval 'sub BATC_BLKBYTES () {(1<<  &BATC_BLKSHIFT);}' unless defined(&BATC_BLKBYTES);
    eval 'sub BATC_BLKMASK () {( &BATC_BLKBYTES-1);}' unless defined(&BATC_BLKMASK);
    eval 'sub BATC_MAX () {8;}' unless defined(&BATC_MAX);
    eval 'sub BATC_BLK_ALIGNED {
        local($x) = @_;
	    eval q((($x &  &BATC_BLKMASK) == 0));
    }' unless defined(&BATC_BLK_ALIGNED);
    eval 'sub M88K_BTOBLK {
        local($x) = @_;
	    eval q(($x >>  &BATC_BLKSHIFT));
    }' unless defined(&M88K_BTOBLK);
    eval 'sub DMA_CACHE_SYNC () {0x1;}' unless defined(&DMA_CACHE_SYNC);
    eval 'sub DMA_CACHE_SYNC_INVAL () {0x2;}' unless defined(&DMA_CACHE_SYNC_INVAL);
    eval 'sub DMA_CACHE_INV () {0x3;}' unless defined(&DMA_CACHE_INV);
    eval 'sub PAGE_ALIGNED {
        local($ad) = @_;
	    eval q(((($ad) &  &PAGE_MASK) == 0));
    }' unless defined(&PAGE_ALIGNED);
    eval 'sub CHECK_PAGE_ALIGN {
        local($ad,$who) = @_;
	    eval q( &if (! &PAGE_ALIGNED($ad))  &printf(\\"%s: addr  %x not page aligned.\\\\n\\", $who, $ad));
    }' unless defined(&CHECK_PAGE_ALIGN);
    eval 'sub kvtopte {
        local($va) = @_;
	    eval q((( &PG_PFNUM(*( &kmapva +  &SDTIDX($va) +  &SDT_ENTRIES)) <<  &PDT_SHIFT) +  &PDTIDX($va)));
    }' unless defined(&kvtopte);
}
1;
