require '_h2ph_pre.ph';

unless(defined(&_MACHINE_CMMU_H_)) {
    eval 'sub _MACHINE_CMMU_H_ () {1;}' unless defined(&_MACHINE_CMMU_H_);
    require 'machine/mmu.ph';
    eval 'sub AREA_D_WT () {0x200;}' unless defined(&AREA_D_WT);
    eval 'sub AREA_D_G () {0x80;}' unless defined(&AREA_D_G);
    eval 'sub AREA_D_CI () {0x40;}' unless defined(&AREA_D_CI);
    eval 'sub AREA_D_TE () {0x1;}' unless defined(&AREA_D_TE);
    eval 'sub SEG_D_WT () {0x200;}' unless defined(&SEG_D_WT);
    eval 'sub SEG_D_SP () {0x100;}' unless defined(&SEG_D_SP);
    eval 'sub SEG_D_G () {0x80;}' unless defined(&SEG_D_G);
    eval 'sub SEG_D_CI () {0x40;}' unless defined(&SEG_D_CI);
    eval 'sub SEG_D_WP () {0x4;}' unless defined(&SEG_D_WP);
    eval 'sub SEG_D_V () {0x1;}' unless defined(&SEG_D_V);
    eval 'sub FLUSH_KERNEL () {1;}' unless defined(&FLUSH_KERNEL);
    eval 'sub FLUSH_USER () {0;}' unless defined(&FLUSH_USER);
    eval 'sub FLUSH_ALL () {(( &vm_offset_t)~0);}' unless defined(&FLUSH_ALL);
    unless(defined(&_LOCORE)) {
	eval 'sub CMMU_LOCK () { &simple_lock( &cmmu_cpu_lock);}' unless defined(&CMMU_LOCK);
	eval 'sub CMMU_UNLOCK () { &simple_unlock( &cmmu_cpu_lock);}' unless defined(&CMMU_UNLOCK);
	if(defined(&DDB)) {
	}
	eval 'sub cmmu_init () {( ($cmmu->{cmmu_init_func}));}' unless defined(&cmmu_init);
	eval 'sub show_apr {
	    local($ap) = @_;
    	    eval q(( ($cmmu->{show_apr_func}))($ap));
	}' unless defined(&show_apr);
	eval 'sub setup_board_config () {( ($cmmu->{setup_board_config_func}));}' unless defined(&setup_board_config);
	eval 'sub setup_cmmu_config () {( ($cmmu->{setup_cmmu_config_func}));}' unless defined(&setup_cmmu_config);
	eval 'sub cmmu_dump_config () {( ($cmmu->{cmmu_dump_config_func}));}' unless defined(&cmmu_dump_config);
	eval 'sub cpu_configuration_print {
	    local($a) = @_;
    	    eval q(( ($cmmu->{cpu_configuration_print_func}))($a));
	}' unless defined(&cpu_configuration_print);
	eval 'sub cmmu_shutdown_now () {( ($cmmu->{cmmu_shutdown_now_func}));}' unless defined(&cmmu_shutdown_now);
	eval 'sub cmmu_parity_enable () {( ($cmmu->{cmmu_parity_enable_func}));}' unless defined(&cmmu_parity_enable);
	eval 'sub cmmu_cpu_number () {( ($cmmu->{cmmu_cpu_number_func}));}' unless defined(&cmmu_cpu_number);
	eval 'sub cmmu_get_idr {
	    local($a) = @_;
    	    eval q(( ($cmmu->{cmmu_get_idr_func}))($a));
	}' unless defined(&cmmu_get_idr);
	eval 'sub cmmu_set_sapr {
	    local($a) = @_;
    	    eval q(( ($cmmu->{cmmu_set_sapr_func}))($a));
	}' unless defined(&cmmu_set_sapr);
	eval 'sub cmmu_remote_set_sapr {
	    local($a, $b) = @_;
    	    eval q(( ($cmmu->{cmmu_remote_set_sapr_func}))($a, $b));
	}' unless defined(&cmmu_remote_set_sapr);
	eval 'sub cmmu_set_uapr {
	    local($a) = @_;
    	    eval q(( ($cmmu->{cmmu_set_uapr_func}))($a));
	}' unless defined(&cmmu_set_uapr);
	eval 'sub cmmu_set_batc_entry {
	    local($a, $b, $c, $d) = @_;
    	    eval q(( ($cmmu->{cmmu_set_batc_entry_func}))($a, $b, $c, $d));
	}' unless defined(&cmmu_set_batc_entry);
	eval 'sub cmmu_set_pair_batc_entry {
	    local($a, $b, $c) = @_;
    	    eval q(( ($cmmu->{cmmu_set_pair_batc_entry_func}))($a, $b, $c));
	}' unless defined(&cmmu_set_pair_batc_entry);
	eval 'sub cmmu_flush_remote_tlb {
	    local($a, $b, $c, $d) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_remote_tlb_func}))($a, $b, $c, $d));
	}' unless defined(&cmmu_flush_remote_tlb);
	eval 'sub cmmu_flush_tlb {
	    local($a, $b, $c) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_tlb_func}))($a, $b, $c));
	}' unless defined(&cmmu_flush_tlb);
	eval 'sub cmmu_pmap_activate {
	    local($a, $b, $c, $d) = @_;
    	    eval q(( ($cmmu->{cmmu_pmap_activate_func}))($a, $b, $c, $d));
	}' unless defined(&cmmu_pmap_activate);
	eval 'sub cmmu_flush_remote_cache {
	    local($a, $b, $c) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_remote_cache_func}))($a, $b, $c));
	}' unless defined(&cmmu_flush_remote_cache);
	eval 'sub cmmu_flush_cache {
	    local($a, $b) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_cache_func}))($a, $b));
	}' unless defined(&cmmu_flush_cache);
	eval 'sub cmmu_flush_remote_inst_cache {
	    local($a, $b, $c) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_remote_inst_cache_func}))($a, $b, $c));
	}' unless defined(&cmmu_flush_remote_inst_cache);
	eval 'sub cmmu_flush_inst_cache {
	    local($a, $b) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_inst_cache_func}))($a, $b));
	}' unless defined(&cmmu_flush_inst_cache);
	eval 'sub cmmu_flush_remote_data_cache {
	    local($a, $b, $c) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_remote_data_cache_func}))($a, $b, $c));
	}' unless defined(&cmmu_flush_remote_data_cache);
	eval 'sub cmmu_flush_data_cache {
	    local($a, $b) = @_;
    	    eval q(( ($cmmu->{cmmu_flush_data_cache_func}))($a, $b));
	}' unless defined(&cmmu_flush_data_cache);
	eval 'sub dma_cachectl {
	    local($a, $b, $c) = @_;
    	    eval q(( ($cmmu->{dma_cachectl_func}))($a, $b, $c));
	}' unless defined(&dma_cachectl);
	if(defined(&DDB)) {
	    eval 'sub cmmu_get_by_mode {
	        local($a, $b) = @_;
    		eval q(( ($cmmu->{cmmu_get_by_mode_func}))($a, $b));
	    }' unless defined(&cmmu_get_by_mode);
	    eval 'sub cmmu_show_translation {
	        local($a, $b, $c, $d) = @_;
    		eval q(( ($cmmu->{cmmu_show_translation_func}))($a, $b, $c, $d));
	    }' unless defined(&cmmu_show_translation);
	    eval 'sub cmmu_cache_state {
	        local($a, $b) = @_;
    		eval q(( ($cmmu->{cmmu_cache_state_func}))($a, $b));
	    }' unless defined(&cmmu_cache_state);
	    eval 'sub show_cmmu_info {
	        local($a) = @_;
    		eval q(( ($cmmu->{show_cmmu_info_func}))($a));
	    }' unless defined(&show_cmmu_info);
	}
    }
    if(defined(&M88100)) {
	require 'machine/m8820x.ph';
    }
    if(defined(&M88110)) {
	require 'machine/m88110.ph';
	require 'machine/m88410.ph';
    }
}
1;
