require '_h2ph_pre.ph';

unless(defined(&__NCURSES_H)) {
    eval 'sub __NCURSES_H () {1;}' unless defined(&__NCURSES_H);
    eval 'sub CURSES () {1;}' unless defined(&CURSES);
    eval 'sub CURSES_H () {1;}' unless defined(&CURSES_H);
    eval 'sub NCURSES_VERSION_MAJOR () {5;}' unless defined(&NCURSES_VERSION_MAJOR);
    eval 'sub NCURSES_VERSION_MINOR () {2;}' unless defined(&NCURSES_VERSION_MINOR);
    eval 'sub NCURSES_VERSION_PATCH () {20010224;}' unless defined(&NCURSES_VERSION_PATCH);
    undef(&NCURSES_VERSION) if defined(&NCURSES_VERSION);
    eval 'sub NCURSES_VERSION () {"5.2";}' unless defined(&NCURSES_VERSION);
    if(!defined( &NCURSES_IMPEXP)) {
	eval 'sub NCURSES_IMPEXP () {1;}' unless defined(&NCURSES_IMPEXP);
    }
    if(!defined( &NCURSES_API)) {
	eval 'sub NCURSES_API () {1;}' unless defined(&NCURSES_API);
    }
    if(!defined( &NCURSES_EXPORT)) {
	eval 'sub NCURSES_EXPORT {
	    local($type) = @_;
    	    eval q( &NCURSES_IMPEXP $type  &NCURSES_API);
	}' unless defined(&NCURSES_EXPORT);
    }
    if(!defined( &NCURSES_EXPORT_VAR)) {
	eval 'sub NCURSES_EXPORT_VAR {
	    local($type) = @_;
    	    eval q( &NCURSES_IMPEXP $type);
	}' unless defined(&NCURSES_EXPORT_VAR);
    }
    if(defined(&NCURSES_NOMACROS)) {
	eval 'sub NCURSES_ATTR_T () { &attr_t;}' unless defined(&NCURSES_ATTR_T);
    }
    unless(defined(&NCURSES_ATTR_T)) {
	eval 'sub NCURSES_ATTR_T () {\'int\';}' unless defined(&NCURSES_ATTR_T);
    }
    undef(&NCURSES_CONST) if defined(&NCURSES_CONST);
    eval 'sub NCURSES_CONST () {1;}' unless defined(&NCURSES_CONST);
    undef(&NCURSES_COLOR_T) if defined(&NCURSES_COLOR_T);
    eval 'sub NCURSES_COLOR_T () {\'short\';}' unless defined(&NCURSES_COLOR_T);
    undef(&NCURSES_SIZE_T) if defined(&NCURSES_SIZE_T);
    eval 'sub NCURSES_SIZE_T () {\'short\';}' unless defined(&NCURSES_SIZE_T);
    require 'stdio.ph';
    require 'unctrl.ph';
    require 'stdarg.ph';
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
	require 'stddef.ph';
    }
    undef(&TRUE) if defined(&TRUE);
    eval 'sub TRUE () {1;}' unless defined(&TRUE);
    undef(&FALSE) if defined(&FALSE);
    eval 'sub FALSE () {0;}' unless defined(&FALSE);
    if(!defined( &__cplusplus)) {
	undef(&bool) if defined(&bool);
    }
    if(defined(&__cplusplus)) {
    }
    eval 'sub WA_ATTRIBUTES () { &A_ATTRIBUTES;}' unless defined(&WA_ATTRIBUTES);
    eval 'sub WA_NORMAL () { &A_NORMAL;}' unless defined(&WA_NORMAL);
    eval 'sub WA_STANDOUT () { &A_STANDOUT;}' unless defined(&WA_STANDOUT);
    eval 'sub WA_UNDERLINE () { &A_UNDERLINE;}' unless defined(&WA_UNDERLINE);
    eval 'sub WA_REVERSE () { &A_REVERSE;}' unless defined(&WA_REVERSE);
    eval 'sub WA_BLINK () { &A_BLINK;}' unless defined(&WA_BLINK);
    eval 'sub WA_DIM () { &A_DIM;}' unless defined(&WA_DIM);
    eval 'sub WA_BOLD () { &A_BOLD;}' unless defined(&WA_BOLD);
    eval 'sub WA_ALTCHARSET () { &A_ALTCHARSET;}' unless defined(&WA_ALTCHARSET);
    eval 'sub WA_INVIS () { &A_INVIS;}' unless defined(&WA_INVIS);
    eval 'sub WA_PROTECT () { &A_PROTECT;}' unless defined(&WA_PROTECT);
    eval 'sub WA_HORIZONTAL () { &A_HORIZONTAL;}' unless defined(&WA_HORIZONTAL);
    eval 'sub WA_LEFT () { &A_LEFT;}' unless defined(&WA_LEFT);
    eval 'sub WA_LOW () { &A_LOW;}' unless defined(&WA_LOW);
    eval 'sub WA_RIGHT () { &A_RIGHT;}' unless defined(&WA_RIGHT);
    eval 'sub WA_TOP () { &A_TOP;}' unless defined(&WA_TOP);
    eval 'sub WA_VERTICAL () { &A_VERTICAL;}' unless defined(&WA_VERTICAL);
    eval 'sub COLOR_BLACK () {0;}' unless defined(&COLOR_BLACK);
    eval 'sub COLOR_RED () {1;}' unless defined(&COLOR_RED);
    eval 'sub COLOR_GREEN () {2;}' unless defined(&COLOR_GREEN);
    eval 'sub COLOR_YELLOW () {3;}' unless defined(&COLOR_YELLOW);
    eval 'sub COLOR_BLUE () {4;}' unless defined(&COLOR_BLUE);
    eval 'sub COLOR_MAGENTA () {5;}' unless defined(&COLOR_MAGENTA);
    eval 'sub COLOR_CYAN () {6;}' unless defined(&COLOR_CYAN);
    eval 'sub COLOR_WHITE () {7;}' unless defined(&COLOR_WHITE);
    eval 'sub ACS_ULCORNER () {( $acs_map[ord(\'l\')]);}' unless defined(&ACS_ULCORNER);
    eval 'sub ACS_LLCORNER () {( $acs_map[ord(\'m\')]);}' unless defined(&ACS_LLCORNER);
    eval 'sub ACS_URCORNER () {( $acs_map[ord(\'k\')]);}' unless defined(&ACS_URCORNER);
    eval 'sub ACS_LRCORNER () {( $acs_map[ord(\'j\')]);}' unless defined(&ACS_LRCORNER);
    eval 'sub ACS_LTEE () {( $acs_map[ord(\'t\')]);}' unless defined(&ACS_LTEE);
    eval 'sub ACS_RTEE () {( $acs_map[ord(\'u\')]);}' unless defined(&ACS_RTEE);
    eval 'sub ACS_BTEE () {( $acs_map[ord(\'v\')]);}' unless defined(&ACS_BTEE);
    eval 'sub ACS_TTEE () {( $acs_map[ord(\'w\')]);}' unless defined(&ACS_TTEE);
    eval 'sub ACS_HLINE () {( $acs_map[ord(\'q\')]);}' unless defined(&ACS_HLINE);
    eval 'sub ACS_VLINE () {( $acs_map[ord(\'x\')]);}' unless defined(&ACS_VLINE);
    eval 'sub ACS_PLUS () {( $acs_map[ord(\'n\')]);}' unless defined(&ACS_PLUS);
    eval 'sub ACS_S1 () {( $acs_map[ord(\'o\')]);}' unless defined(&ACS_S1);
    eval 'sub ACS_S9 () {( $acs_map[ord(\'s\')]);}' unless defined(&ACS_S9);
    eval 'sub ACS_DIAMOND () {( $acs_map[ord(\'`\')]);}' unless defined(&ACS_DIAMOND);
    eval 'sub ACS_CKBOARD () {( $acs_map[ord(\'a\')]);}' unless defined(&ACS_CKBOARD);
    eval 'sub ACS_DEGREE () {( $acs_map[ord(\'f\')]);}' unless defined(&ACS_DEGREE);
    eval 'sub ACS_PLMINUS () {( $acs_map[ord(\'g\')]);}' unless defined(&ACS_PLMINUS);
    eval 'sub ACS_BULLET () {( $acs_map[ord(\'~\')]);}' unless defined(&ACS_BULLET);
    eval 'sub ACS_LARROW () {( $acs_map[ord(\',\')]);}' unless defined(&ACS_LARROW);
    eval 'sub ACS_RARROW () {( $acs_map[ord(\'+\')]);}' unless defined(&ACS_RARROW);
    eval 'sub ACS_DARROW () {( $acs_map[ord(\'.\')]);}' unless defined(&ACS_DARROW);
    eval 'sub ACS_UARROW () {( $acs_map[ord(\'-\')]);}' unless defined(&ACS_UARROW);
    eval 'sub ACS_BOARD () {( $acs_map[ord(\'h\')]);}' unless defined(&ACS_BOARD);
    eval 'sub ACS_LANTERN () {( $acs_map[ord(\'i\')]);}' unless defined(&ACS_LANTERN);
    eval 'sub ACS_BLOCK () {( $acs_map[ord(\'0\')]);}' unless defined(&ACS_BLOCK);
    eval 'sub ACS_S3 () {( $acs_map[ord(\'p\')]);}' unless defined(&ACS_S3);
    eval 'sub ACS_S7 () {( $acs_map[ord(\'r\')]);}' unless defined(&ACS_S7);
    eval 'sub ACS_LEQUAL () {( $acs_map[ord(\'y\')]);}' unless defined(&ACS_LEQUAL);
    eval 'sub ACS_GEQUAL () {( $acs_map[ord(\'z\')]);}' unless defined(&ACS_GEQUAL);
    eval 'sub ACS_PI () {( $acs_map[ord(\'{\')]);}' unless defined(&ACS_PI);
    eval 'sub ACS_NEQUAL () {( $acs_map[ord(\'|\')]);}' unless defined(&ACS_NEQUAL);
    eval 'sub ACS_STERLING () {( $acs_map[ord(\'}\')]);}' unless defined(&ACS_STERLING);
    eval 'sub ACS_BSSB () { &ACS_ULCORNER;}' unless defined(&ACS_BSSB);
    eval 'sub ACS_SSBB () { &ACS_LLCORNER;}' unless defined(&ACS_SSBB);
    eval 'sub ACS_BBSS () { &ACS_URCORNER;}' unless defined(&ACS_BBSS);
    eval 'sub ACS_SBBS () { &ACS_LRCORNER;}' unless defined(&ACS_SBBS);
    eval 'sub ACS_SBSS () { &ACS_RTEE;}' unless defined(&ACS_SBSS);
    eval 'sub ACS_SSSB () { &ACS_LTEE;}' unless defined(&ACS_SSSB);
    eval 'sub ACS_SSBS () { &ACS_BTEE;}' unless defined(&ACS_SSBS);
    eval 'sub ACS_BSSS () { &ACS_TTEE;}' unless defined(&ACS_BSSS);
    eval 'sub ACS_BSBS () { &ACS_HLINE;}' unless defined(&ACS_BSBS);
    eval 'sub ACS_SBSB () { &ACS_VLINE;}' unless defined(&ACS_SBSB);
    eval 'sub ACS_SSSS () { &ACS_PLUS;}' unless defined(&ACS_SSSS);
    if(!defined( &ERR) || (((defined(&ERR) ? &ERR : 0)) != -1)) {
	eval 'sub ERR () {(-1);}' unless defined(&ERR);
    }
    if(!defined( &OK) || (((defined(&OK) ? &OK : 0)) != 0)) {
	eval 'sub OK () {(0);}' unless defined(&OK);
    }
    eval 'sub _SUBWIN () {0x1;}' unless defined(&_SUBWIN);
    eval 'sub _ENDLINE () {0x2;}' unless defined(&_ENDLINE);
    eval 'sub _FULLWIN () {0x4;}' unless defined(&_FULLWIN);
    eval 'sub _SCROLLWIN () {0x8;}' unless defined(&_SCROLLWIN);
    eval 'sub _ISPAD () {0x10;}' unless defined(&_ISPAD);
    eval 'sub _HASMOVED () {0x20;}' unless defined(&_HASMOVED);
    eval 'sub _WRAPPED () {0x40;}' unless defined(&_WRAPPED);
    eval 'sub _NOCHANGE () {-1;}' unless defined(&_NOCHANGE);
    eval 'sub _NEWINDEX () {-1;}' unless defined(&_NEWINDEX);
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
	unless(defined(&_WCHAR_T)) {
	}
	unless(defined(&_WINT_T)) {
	}
	eval 'sub CCHARW_MAX () {5;}' unless defined(&CCHARW_MAX);
    }
    if(!defined( &__GNUC__)  && !defined( &__attribute__)) {
	eval 'sub __attribute__ {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&__attribute__);
    }
    if(defined(&__cplusplus)) {
	undef(&GCC_NORETURN) if defined(&GCC_NORETURN);
	undef(&GCC_PRINTF) if defined(&GCC_PRINTF);
	undef(&GCC_SCANF) if defined(&GCC_SCANF);
	undef(&GCC_UNUSED) if defined(&GCC_UNUSED);
    }
    if(defined(&GCC_PRINTF)) {
	eval 'sub GCC_PRINTFLIKE {
	    local($fmt,$var) = @_;
    	    eval q( &__attribute__(( &__format__( &printf,$fmt,$var))));
	}' unless defined(&GCC_PRINTFLIKE);
    } else {
	eval 'sub GCC_PRINTFLIKE {
	    local($fmt,$var) = @_;
    	    eval q();
	}' unless defined(&GCC_PRINTFLIKE);
    }
    if(defined(&GCC_SCANF)) {
	eval 'sub GCC_SCANFLIKE {
	    local($fmt,$var) = @_;
    	    eval q( &__attribute__(( &__format__( &scanf,$fmt,$var))));
	}' unless defined(&GCC_SCANFLIKE);
    } else {
	eval 'sub GCC_SCANFLIKE {
	    local($fmt,$var) = @_;
    	    eval q();
	}' unless defined(&GCC_SCANFLIKE);
    }
    unless(defined(&GCC_NORETURN)) {
	eval 'sub GCC_NORETURN () {1;}' unless defined(&GCC_NORETURN);
    }
    unless(defined(&GCC_UNUSED)) {
	eval 'sub GCC_UNUSED () {1;}' unless defined(&GCC_UNUSED);
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    if(defined(&_XOPEN_SOURCE_EXTENDED)) {
    }
    eval 'sub NCURSES_BITS {
        local($mask,$shift) = @_;
	    eval q((($mask) << (($shift) + 8)));
    }' unless defined(&NCURSES_BITS);
    eval 'sub A_NORMAL () {0;}' unless defined(&A_NORMAL);
    eval 'sub A_ATTRIBUTES () { &NCURSES_BITS(~(1 - 1),0);}' unless defined(&A_ATTRIBUTES);
    eval 'sub A_CHARTEXT () {( &NCURSES_BITS(1,0) - 1);}' unless defined(&A_CHARTEXT);
    eval 'sub A_COLOR () { &NCURSES_BITS(((1) << 8) - 1,0);}' unless defined(&A_COLOR);
    eval 'sub A_STANDOUT () { &NCURSES_BITS(1,8);}' unless defined(&A_STANDOUT);
    eval 'sub A_UNDERLINE () { &NCURSES_BITS(1,9);}' unless defined(&A_UNDERLINE);
    eval 'sub A_REVERSE () { &NCURSES_BITS(1,10);}' unless defined(&A_REVERSE);
    eval 'sub A_BLINK () { &NCURSES_BITS(1,11);}' unless defined(&A_BLINK);
    eval 'sub A_DIM () { &NCURSES_BITS(1,12);}' unless defined(&A_DIM);
    eval 'sub A_BOLD () { &NCURSES_BITS(1,13);}' unless defined(&A_BOLD);
    eval 'sub A_ALTCHARSET () { &NCURSES_BITS(1,14);}' unless defined(&A_ALTCHARSET);
    eval 'sub A_INVIS () { &NCURSES_BITS(1,15);}' unless defined(&A_INVIS);
    if(((16+ 8) < 32)) {
	eval 'sub A_PROTECT () { &NCURSES_BITS(1,16);}' unless defined(&A_PROTECT);
	eval 'sub A_HORIZONTAL () { &NCURSES_BITS(1,17);}' unless defined(&A_HORIZONTAL);
	eval 'sub A_LEFT () { &NCURSES_BITS(1,18);}' unless defined(&A_LEFT);
	eval 'sub A_LOW () { &NCURSES_BITS(1,19);}' unless defined(&A_LOW);
	eval 'sub A_RIGHT () { &NCURSES_BITS(1,20);}' unless defined(&A_RIGHT);
	eval 'sub A_TOP () { &NCURSES_BITS(1,21);}' unless defined(&A_TOP);
	eval 'sub A_VERTICAL () { &NCURSES_BITS(1,22);}' unless defined(&A_VERTICAL);
    } else {
	eval 'sub A_PROTECT () {0;}' unless defined(&A_PROTECT);
	eval 'sub A_HORIZONTAL () {0;}' unless defined(&A_HORIZONTAL);
	eval 'sub A_LEFT () {0;}' unless defined(&A_LEFT);
	eval 'sub A_LOW () {0;}' unless defined(&A_LOW);
	eval 'sub A_RIGHT () {0;}' unless defined(&A_RIGHT);
	eval 'sub A_TOP () {0;}' unless defined(&A_TOP);
	eval 'sub A_VERTICAL () {0;}' unless defined(&A_VERTICAL);
    }
    eval 'sub COLOR_PAIR {
        local($n) = @_;
	    eval q( &NCURSES_BITS($n, 0));
    }' unless defined(&COLOR_PAIR);
    eval 'sub PAIR_NUMBER {
        local($a) = @_;
	    eval q(((($a) &  &A_COLOR) >> 8));
    }' unless defined(&PAIR_NUMBER);
    eval 'sub wgetstr {
        local($w, $s) = @_;
	    eval q( &wgetnstr($w, $s, -1));
    }' unless defined(&wgetstr);
    eval 'sub getnstr {
        local($s, $n) = @_;
	    eval q( &wgetnstr( &stdscr, $s, $n));
    }' unless defined(&getnstr);
    eval 'sub setterm {
        local($term) = @_;
	    eval q( &setupterm($term, 1, 0));
    }' unless defined(&setterm);
    eval 'sub fixterm () {
        eval q( &reset_prog_mode());
    }' unless defined(&fixterm);
    eval 'sub resetterm () {
        eval q( &reset_shell_mode());
    }' unless defined(&resetterm);
    eval 'sub saveterm () {
        eval q( &def_prog_mode());
    }' unless defined(&saveterm);
    eval 'sub crmode () {
        eval q( &cbreak());
    }' unless defined(&crmode);
    eval 'sub nocrmode () {
        eval q( &nocbreak());
    }' unless defined(&nocrmode);
    eval 'sub gettmode () {
        eval q();
    }' unless defined(&gettmode);
    eval 'sub getyx {
        local($win,$y,$x) = @_;
	    eval q(($y = ($win)?($win)-> &_cury: &ERR, $x = ($win)?($win)-> &_curx: &ERR));
    }' unless defined(&getyx);
    eval 'sub getbegyx {
        local($win,$y,$x) = @_;
	    eval q(($y = ($win)?($win)-> &_begy: &ERR, $x = ($win)?($win)-> &_begx: &ERR));
    }' unless defined(&getbegyx);
    eval 'sub getmaxyx {
        local($win,$y,$x) = @_;
	    eval q(($y = ($win)?(($win)-> &_maxy + 1): &ERR, $x = ($win)?(($win)-> &_maxx + 1): &ERR));
    }' unless defined(&getmaxyx);
    eval 'sub getparyx {
        local($win,$y,$x) = @_;
	    eval q(($y = ($win)?($win)-> &_pary: &ERR, $x = ($win)?($win)-> &_parx: &ERR));
    }' unless defined(&getparyx);
    eval 'sub getsyx {
        local($y,$x) = @_;
	    eval q( &do {  &if( ($newscr->{_leaveok})) ($y)=($x)=-1;  &else  &getyx( &newscr,($y),($x)); }  &while(0));
    }' unless defined(&getsyx);
    eval 'sub setsyx {
        local($y,$x) = @_;
	    eval q( &do {  &if(($y)==-1 && ($x)==-1)  ($newscr->{_leaveok})= &TRUE;  &else { ($newscr->{_leaveok})= &FALSE; &wmove( &newscr,($y),($x));} }  &while(0));
    }' unless defined(&setsyx);
    eval 'sub getattrs {
        local($win) = @_;
	    eval q((($win)?($win)-> &_attrs: &A_NORMAL));
    }' unless defined(&getattrs);
    eval 'sub getcurx {
        local($win) = @_;
	    eval q((($win)?($win)-> &_curx: &ERR));
    }' unless defined(&getcurx);
    eval 'sub getcury {
        local($win) = @_;
	    eval q((($win)?($win)-> &_cury: &ERR));
    }' unless defined(&getcury);
    eval 'sub getbegx {
        local($win) = @_;
	    eval q((($win)?($win)-> &_begx: &ERR));
    }' unless defined(&getbegx);
    eval 'sub getbegy {
        local($win) = @_;
	    eval q((($win)?($win)-> &_begy: &ERR));
    }' unless defined(&getbegy);
    eval 'sub getmaxx {
        local($win) = @_;
	    eval q((($win)?(($win)-> &_maxx + 1): &ERR));
    }' unless defined(&getmaxx);
    eval 'sub getmaxy {
        local($win) = @_;
	    eval q((($win)?(($win)-> &_maxy + 1): &ERR));
    }' unless defined(&getmaxy);
    eval 'sub getparx {
        local($win) = @_;
	    eval q((($win)?($win)-> &_parx: &ERR));
    }' unless defined(&getparx);
    eval 'sub getpary {
        local($win) = @_;
	    eval q((($win)?($win)-> &_pary: &ERR));
    }' unless defined(&getpary);
    eval 'sub wstandout {
        local($win) = @_;
	    eval q(( &wattrset($win, &A_STANDOUT)));
    }' unless defined(&wstandout);
    eval 'sub wstandend {
        local($win) = @_;
	    eval q(( &wattrset($win, &A_NORMAL)));
    }' unless defined(&wstandend);
    eval 'sub wattr_set {
        local($win,$a,$p,$opts) = @_;
	    eval q((($win)-> &_attrs = ((($a) & ~ &A_COLOR) |  &COLOR_PAIR($p)),  &OK));
    }' unless defined(&wattr_set);
    eval 'sub wattron {
        local($win,$at) = @_;
	    eval q( &wattr_on($win, $at, 0));
    }' unless defined(&wattron);
    eval 'sub wattroff {
        local($win,$at) = @_;
	    eval q( &wattr_off($win, $at, 0));
    }' unless defined(&wattroff);
    eval 'sub wattrset {
        local($win,$at) = @_;
	    eval q((($win)-> &_attrs = ($at)));
    }' unless defined(&wattrset);
    eval 'sub scroll {
        local($win) = @_;
	    eval q( &wscrl($win,1));
    }' unless defined(&scroll);
    eval 'sub touchwin {
        local($win) = @_;
	    eval q( &wtouchln(($win), 0,  &getmaxy($win), 1));
    }' unless defined(&touchwin);
    eval 'sub touchline {
        local($win, $s, $c) = @_;
	    eval q( &wtouchln(($win), $s, $c, 1));
    }' unless defined(&touchline);
    eval 'sub untouchwin {
        local($win) = @_;
	    eval q( &wtouchln(($win), 0,  &getmaxy($win), 0));
    }' unless defined(&untouchwin);
    eval 'sub box {
        local($win, $v, $h) = @_;
	    eval q( &wborder($win, $v, $v, $h, $h, 0, 0, 0, 0));
    }' unless defined(&box);
    eval 'sub border {
        local($ls, $rs, $ts, $bs, $tl, $tr, $bl, $br) = @_;
	    eval q( &wborder( &stdscr, $ls, $rs, $ts, $bs, $tl, $tr, $bl, $br));
    }' unless defined(&border);
    eval 'sub hline {
        local($ch, $n) = @_;
	    eval q( &whline( &stdscr, $ch, $n));
    }' unless defined(&hline);
    eval 'sub vline {
        local($ch, $n) = @_;
	    eval q( &wvline( &stdscr, $ch, $n));
    }' unless defined(&vline);
    eval 'sub winstr {
        local($w, $s) = @_;
	    eval q( &winnstr($w, $s, -1));
    }' unless defined(&winstr);
    eval 'sub winchstr {
        local($w, $s) = @_;
	    eval q( &winchnstr($w, $s, -1));
    }' unless defined(&winchstr);
    eval 'sub winsstr {
        local($w, $s) = @_;
	    eval q( &winsnstr($w, $s, -1));
    }' unless defined(&winsstr);
    eval 'sub redrawwin {
        local($win) = @_;
	    eval q( &wredrawln($win, 0, ($win)-> &_maxy+1));
    }' unless defined(&redrawwin);
    eval 'sub waddstr {
        local($win,$str) = @_;
	    eval q( &waddnstr($win,$str,-1));
    }' unless defined(&waddstr);
    eval 'sub waddchstr {
        local($win,$str) = @_;
	    eval q( &waddchnstr($win,$str,-1));
    }' unless defined(&waddchstr);
    eval 'sub addch {
        local($ch) = @_;
	    eval q( &waddch( &stdscr,$ch));
    }' unless defined(&addch);
    eval 'sub addchnstr {
        local($str,$n) = @_;
	    eval q( &waddchnstr( &stdscr,$str,$n));
    }' unless defined(&addchnstr);
    eval 'sub addchstr {
        local($str) = @_;
	    eval q( &waddchstr( &stdscr,$str));
    }' unless defined(&addchstr);
    eval 'sub addnstr {
        local($str,$n) = @_;
	    eval q( &waddnstr( &stdscr,$str,$n));
    }' unless defined(&addnstr);
    eval 'sub addstr {
        local($str) = @_;
	    eval q( &waddnstr( &stdscr,$str,-1));
    }' unless defined(&addstr);
    eval 'sub attroff {
        local($at) = @_;
	    eval q( &wattroff( &stdscr,$at));
    }' unless defined(&attroff);
    eval 'sub attron {
        local($at) = @_;
	    eval q( &wattron( &stdscr,$at));
    }' unless defined(&attron);
    eval 'sub attrset {
        local($at) = @_;
	    eval q( &wattrset( &stdscr,$at));
    }' unless defined(&attrset);
    eval 'sub bkgd {
        local($ch) = @_;
	    eval q( &wbkgd( &stdscr,$ch));
    }' unless defined(&bkgd);
    eval 'sub bkgdset {
        local($ch) = @_;
	    eval q( &wbkgdset( &stdscr,$ch));
    }' unless defined(&bkgdset);
    eval 'sub clear () {
        eval q( &wclear( &stdscr));
    }' unless defined(&clear);
    eval 'sub clrtobot () {
        eval q( &wclrtobot( &stdscr));
    }' unless defined(&clrtobot);
    eval 'sub clrtoeol () {
        eval q( &wclrtoeol( &stdscr));
    }' unless defined(&clrtoeol);
    eval 'sub color_set {
        local($c,$o) = @_;
	    eval q( &wcolor_set( &stdscr,$c,$o));
    }' unless defined(&color_set);
    eval 'sub delch () {
        eval q( &wdelch( &stdscr));
    }' unless defined(&delch);
    eval 'sub deleteln () {
        eval q( &winsdelln( &stdscr,-1));
    }' unless defined(&deleteln);
    eval 'sub echochar {
        local($c) = @_;
	    eval q( &wechochar( &stdscr,$c));
    }' unless defined(&echochar);
    eval 'sub erase () {
        eval q( &werase( &stdscr));
    }' unless defined(&erase);
    eval 'sub getch () {
        eval q( &wgetch( &stdscr));
    }' unless defined(&getch);
    eval 'sub getstr {
        local($str) = @_;
	    eval q( &wgetstr( &stdscr,$str));
    }' unless defined(&getstr);
    eval 'sub inch () {
        eval q( &winch( &stdscr));
    }' unless defined(&inch);
    eval 'sub inchnstr {
        local($s,$n) = @_;
	    eval q( &winchnstr( &stdscr,$s,$n));
    }' unless defined(&inchnstr);
    eval 'sub inchstr {
        local($s) = @_;
	    eval q( &winchstr( &stdscr,$s));
    }' unless defined(&inchstr);
    eval 'sub innstr {
        local($s,$n) = @_;
	    eval q( &winnstr( &stdscr,$s,$n));
    }' unless defined(&innstr);
    eval 'sub insch {
        local($c) = @_;
	    eval q( &winsch( &stdscr,$c));
    }' unless defined(&insch);
    eval 'sub insdelln {
        local($n) = @_;
	    eval q( &winsdelln( &stdscr,$n));
    }' unless defined(&insdelln);
    eval 'sub insertln () {
        eval q( &winsdelln( &stdscr,1));
    }' unless defined(&insertln);
    eval 'sub insnstr {
        local($s,$n) = @_;
	    eval q( &winsnstr( &stdscr,$s,$n));
    }' unless defined(&insnstr);
    eval 'sub insstr {
        local($s) = @_;
	    eval q( &winsstr( &stdscr,$s));
    }' unless defined(&insstr);
    eval 'sub instr {
        local($s) = @_;
	    eval q( &winstr( &stdscr,$s));
    }' unless defined(&instr);
    eval 'sub move {
        local($y,$x) = @_;
	    eval q( &wmove( &stdscr,$y,$x));
    }' unless defined(&move);
    eval 'sub refresh () {
        eval q( &wrefresh( &stdscr));
    }' unless defined(&refresh);
    eval 'sub scrl {
        local($n) = @_;
	    eval q( &wscrl( &stdscr,$n));
    }' unless defined(&scrl);
    eval 'sub setscrreg {
        local($t,$b) = @_;
	    eval q( &wsetscrreg( &stdscr,$t,$b));
    }' unless defined(&setscrreg);
    eval 'sub standend () {
        eval q( &wstandend( &stdscr));
    }' unless defined(&standend);
    eval 'sub standout () {
        eval q( &wstandout( &stdscr));
    }' unless defined(&standout);
    eval 'sub timeout {
        local($delay) = @_;
	    eval q( &wtimeout( &stdscr,$delay));
    }' unless defined(&timeout);
    eval 'sub wdeleteln {
        local($win) = @_;
	    eval q( &winsdelln($win,-1));
    }' unless defined(&wdeleteln);
    eval 'sub winsertln {
        local($win) = @_;
	    eval q( &winsdelln($win,1));
    }' unless defined(&winsertln);
    eval 'sub mvwaddch {
        local($win,$y,$x,$ch) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddch($win,$ch)));
    }' unless defined(&mvwaddch);
    eval 'sub mvwaddchnstr {
        local($win,$y,$x,$str,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddchnstr($win,$str,$n)));
    }' unless defined(&mvwaddchnstr);
    eval 'sub mvwaddchstr {
        local($win,$y,$x,$str) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddchnstr($win,$str,-1)));
    }' unless defined(&mvwaddchstr);
    eval 'sub mvwaddnstr {
        local($win,$y,$x,$str,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddnstr($win,$str,$n)));
    }' unless defined(&mvwaddnstr);
    eval 'sub mvwaddstr {
        local($win,$y,$x,$str) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddnstr($win,$str,-1)));
    }' unless defined(&mvwaddstr);
    eval 'sub mvwdelch {
        local($win,$y,$x) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wdelch($win)));
    }' unless defined(&mvwdelch);
    eval 'sub mvwgetch {
        local($win,$y,$x) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wgetch($win)));
    }' unless defined(&mvwgetch);
    eval 'sub mvwgetnstr {
        local($win,$y,$x,$str,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wgetnstr($win,$str,$n)));
    }' unless defined(&mvwgetnstr);
    eval 'sub mvwgetstr {
        local($win,$y,$x,$str) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wgetstr($win,$str)));
    }' unless defined(&mvwgetstr);
    eval 'sub mvwhline {
        local($win,$y,$x,$c,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &whline($win,$c,$n)));
    }' unless defined(&mvwhline);
    eval 'sub mvwinch {
        local($win,$y,$x) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winch($win)));
    }' unless defined(&mvwinch);
    eval 'sub mvwinchnstr {
        local($win,$y,$x,$s,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winchnstr($win,$s,$n)));
    }' unless defined(&mvwinchnstr);
    eval 'sub mvwinchstr {
        local($win,$y,$x,$s) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winchstr($win,$s)));
    }' unless defined(&mvwinchstr);
    eval 'sub mvwinnstr {
        local($win,$y,$x,$s,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winnstr($win,$s,$n)));
    }' unless defined(&mvwinnstr);
    eval 'sub mvwinsch {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winsch($win,$c)));
    }' unless defined(&mvwinsch);
    eval 'sub mvwinsnstr {
        local($win,$y,$x,$s,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winsnstr($win,$s,$n)));
    }' unless defined(&mvwinsnstr);
    eval 'sub mvwinsstr {
        local($win,$y,$x,$s) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winsstr($win,$s)));
    }' unless defined(&mvwinsstr);
    eval 'sub mvwinstr {
        local($win,$y,$x,$s) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winstr($win,$s)));
    }' unless defined(&mvwinstr);
    eval 'sub mvwvline {
        local($win,$y,$x,$c,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wvline($win,$c,$n)));
    }' unless defined(&mvwvline);
    eval 'sub mvaddch {
        local($y,$x,$ch) = @_;
	    eval q( &mvwaddch( &stdscr,$y,$x,$ch));
    }' unless defined(&mvaddch);
    eval 'sub mvaddchnstr {
        local($y,$x,$str,$n) = @_;
	    eval q( &mvwaddchnstr( &stdscr,$y,$x,$str,$n));
    }' unless defined(&mvaddchnstr);
    eval 'sub mvaddchstr {
        local($y,$x,$str) = @_;
	    eval q( &mvwaddchstr( &stdscr,$y,$x,$str));
    }' unless defined(&mvaddchstr);
    eval 'sub mvaddnstr {
        local($y,$x,$str,$n) = @_;
	    eval q( &mvwaddnstr( &stdscr,$y,$x,$str,$n));
    }' unless defined(&mvaddnstr);
    eval 'sub mvaddstr {
        local($y,$x,$str) = @_;
	    eval q( &mvwaddstr( &stdscr,$y,$x,$str));
    }' unless defined(&mvaddstr);
    eval 'sub mvdelch {
        local($y,$x) = @_;
	    eval q( &mvwdelch( &stdscr,$y,$x));
    }' unless defined(&mvdelch);
    eval 'sub mvgetch {
        local($y,$x) = @_;
	    eval q( &mvwgetch( &stdscr,$y,$x));
    }' unless defined(&mvgetch);
    eval 'sub mvgetnstr {
        local($y,$x,$str,$n) = @_;
	    eval q( &mvwgetnstr( &stdscr,$y,$x,$str,$n));
    }' unless defined(&mvgetnstr);
    eval 'sub mvgetstr {
        local($y,$x,$str) = @_;
	    eval q( &mvwgetstr( &stdscr,$y,$x,$str));
    }' unless defined(&mvgetstr);
    eval 'sub mvhline {
        local($y,$x,$c,$n) = @_;
	    eval q( &mvwhline( &stdscr,$y,$x,$c,$n));
    }' unless defined(&mvhline);
    eval 'sub mvinch {
        local($y,$x) = @_;
	    eval q( &mvwinch( &stdscr,$y,$x));
    }' unless defined(&mvinch);
    eval 'sub mvinchnstr {
        local($y,$x,$s,$n) = @_;
	    eval q( &mvwinchnstr( &stdscr,$y,$x,$s,$n));
    }' unless defined(&mvinchnstr);
    eval 'sub mvinchstr {
        local($y,$x,$s) = @_;
	    eval q( &mvwinchstr( &stdscr,$y,$x,$s));
    }' unless defined(&mvinchstr);
    eval 'sub mvinnstr {
        local($y,$x,$s,$n) = @_;
	    eval q( &mvwinnstr( &stdscr,$y,$x,$s,$n));
    }' unless defined(&mvinnstr);
    eval 'sub mvinsch {
        local($y,$x,$c) = @_;
	    eval q( &mvwinsch( &stdscr,$y,$x,$c));
    }' unless defined(&mvinsch);
    eval 'sub mvinsnstr {
        local($y,$x,$s,$n) = @_;
	    eval q( &mvwinsnstr( &stdscr,$y,$x,$s,$n));
    }' unless defined(&mvinsnstr);
    eval 'sub mvinsstr {
        local($y,$x,$s) = @_;
	    eval q( &mvwinsstr( &stdscr,$y,$x,$s));
    }' unless defined(&mvinsstr);
    eval 'sub mvinstr {
        local($y,$x,$s) = @_;
	    eval q( &mvwinstr( &stdscr,$y,$x,$s));
    }' unless defined(&mvinstr);
    eval 'sub mvvline {
        local($y,$x,$c,$n) = @_;
	    eval q( &mvwvline( &stdscr,$y,$x,$c,$n));
    }' unless defined(&mvvline);
    eval 'sub add_wch {
        local($c) = @_;
	    eval q( &wadd_wch( &stdscr,$c));
    }' unless defined(&add_wch);
    eval 'sub addnwstr {
        local($wstr,$n) = @_;
	    eval q( &waddnwstr( &stdscr,$wstr,$n));
    }' unless defined(&addnwstr);
    eval 'sub addwstr {
        local($wstr,$n) = @_;
	    eval q( &waddnwstr( &stdscr,$wstr,-1));
    }' unless defined(&addwstr);
    eval 'sub attr_get {
        local($a,$pair,$opts) = @_;
	    eval q( &wattr_get( &stdscr,$a,$pair,$opts));
    }' unless defined(&attr_get);
    eval 'sub attr_off {
        local($a,$opts) = @_;
	    eval q( &wattr_off( &stdscr,$a,$opts));
    }' unless defined(&attr_off);
    eval 'sub attr_on {
        local($a,$opts) = @_;
	    eval q( &wattr_on( &stdscr,$a,$opts));
    }' unless defined(&attr_on);
    eval 'sub attr_set {
        local($a,$pair,$opts) = @_;
	    eval q( &wattr_set( &stdscr,$a,$pair,$opts));
    }' unless defined(&attr_set);
    eval 'sub box_set {
        local($w,$v,$h) = @_;
	    eval q( &wborder_set($w,$v,$v,$h,$h,0,0,0,0));
    }' unless defined(&box_set);
    eval 'sub chgat {
        local($n,$a,$c,$o) = @_;
	    eval q( &wchgat( &stdscr,$n,$a,$c,$o));
    }' unless defined(&chgat);
    eval 'sub echo_wchar {
        local($c) = @_;
	    eval q( &wecho_wchar( &stdscr,$c));
    }' unless defined(&echo_wchar);
    eval 'sub getbkgd {
        local($win) = @_;
	    eval q((($win)-> &_bkgd));
    }' unless defined(&getbkgd);
    eval 'sub get_wch {
        local($c) = @_;
	    eval q( &wget_wch( &stdscr,$c));
    }' unless defined(&get_wch);
    eval 'sub get_wstr {
        local($t) = @_;
	    eval q( &wgetn_wstr( &stdscr,$t,-1));
    }' unless defined(&get_wstr);
    eval 'sub getn_wstr {
        local($t,$n) = @_;
	    eval q( &wgetn_wstr( &stdscr,$t,$n));
    }' unless defined(&getn_wstr);
    eval 'sub hline_set {
        local($c,$n) = @_;
	    eval q( &whline_set( &stdscr,$c,$n));
    }' unless defined(&hline_set);
    eval 'sub in_wch {
        local($c) = @_;
	    eval q( &win_wch( &stdscr,$c));
    }' unless defined(&in_wch);
    eval 'sub in_wchnstr {
        local($c,$n) = @_;
	    eval q( &win_wchnstr( &stdscr,$c,$n));
    }' unless defined(&in_wchnstr);
    eval 'sub in_wchstr {
        local($c) = @_;
	    eval q( &win_wchnstr( &stdscr,$c,-1));
    }' unless defined(&in_wchstr);
    eval 'sub innwstr {
        local($c,$n) = @_;
	    eval q( &winnwstr( &stdscr,$c,$n));
    }' unless defined(&innwstr);
    eval 'sub ins_nwstr {
        local($t,$n) = @_;
	    eval q( &wins_nwstr( &stdscr,$t,$n));
    }' unless defined(&ins_nwstr);
    eval 'sub ins_wch {
        local($c) = @_;
	    eval q( &wins_wch( &stdscr,$c));
    }' unless defined(&ins_wch);
    eval 'sub ins_wstr {
        local($t) = @_;
	    eval q( &wins_nwstr( &stdscr,$t,-1));
    }' unless defined(&ins_wstr);
    eval 'sub inwstr {
        local($c) = @_;
	    eval q( &winnwstr( &stdscr,$c,-1));
    }' unless defined(&inwstr);
    eval 'sub mvadd_wch {
        local($y,$x,$c) = @_;
	    eval q( &mvwadd_wch( &stdscr,$y,$x,$c));
    }' unless defined(&mvadd_wch);
    eval 'sub mvaddnwstr {
        local($y,$x,$wstr,$n) = @_;
	    eval q( &mvwaddnwstr( &stdscr,$y,$x,$wstr,$n));
    }' unless defined(&mvaddnwstr);
    eval 'sub mvaddwstr {
        local($y,$x,$wstr,$n) = @_;
	    eval q( &mvwaddnwstr( &stdscr,$y,$x,$wstr,-1));
    }' unless defined(&mvaddwstr);
    eval 'sub mvchgat {
        local($y,$x,$n,$a,$c,$o) = @_;
	    eval q( &mvwchgat( &stdscr,$y,$x,$n,$a,$c,$o));
    }' unless defined(&mvchgat);
    eval 'sub mvget_wch {
        local($y,$x,$c) = @_;
	    eval q( &mvwget_wch( &stdscr,$y,$x,$c));
    }' unless defined(&mvget_wch);
    eval 'sub mvget_wstr {
        local($y,$x,$t) = @_;
	    eval q( &mvwgetn_wstr( &stdscr,$y,$x,$t,-1));
    }' unless defined(&mvget_wstr);
    eval 'sub mvgetn_wstr {
        local($y,$x,$t,$n) = @_;
	    eval q( &mvwgetn_wstr( &stdscr,$y,$x,$t,$n));
    }' unless defined(&mvgetn_wstr);
    eval 'sub mvhline_set {
        local($y,$x,$c,$n) = @_;
	    eval q( &mvwhline_set( &stdscr,$y,$x,$c,$n));
    }' unless defined(&mvhline_set);
    eval 'sub mvin_wch {
        local($y,$x,$c) = @_;
	    eval q( &mvwin_wch( &stdscr,$y,$x,$c));
    }' unless defined(&mvin_wch);
    eval 'sub mvin_wchnstr {
        local($y,$x,$c,$n) = @_;
	    eval q( &mvwin_wchnstr( &stdscr,$y,$x,$c,$n));
    }' unless defined(&mvin_wchnstr);
    eval 'sub mvin_wchstr {
        local($y,$x,$c) = @_;
	    eval q( &mvwin_wchnstr( &stdscr,$y,$x,$c,-1));
    }' unless defined(&mvin_wchstr);
    eval 'sub mvinnwstr {
        local($y,$x,$c,$n) = @_;
	    eval q( &mvwinnwstr( &stdscr,$y,$x,$c,$n));
    }' unless defined(&mvinnwstr);
    eval 'sub mvins_nwstr {
        local($y,$x,$t,$n) = @_;
	    eval q( &mvwins_nwstr( &stdscr,$y,$x,$t,$n));
    }' unless defined(&mvins_nwstr);
    eval 'sub mvins_wch {
        local($y,$x,$c) = @_;
	    eval q( &mvwins_wch( &stdscr,$y,$x,$c));
    }' unless defined(&mvins_wch);
    eval 'sub mvins_wstr {
        local($y,$x,$t) = @_;
	    eval q( &mvwins_nwstr( &stdscr,$y,$x,$t,-1));
    }' unless defined(&mvins_wstr);
    eval 'sub mvinwstr {
        local($y,$x,$c) = @_;
	    eval q( &mvwinnwstr( &stdscr,$y,$x,$c,-1));
    }' unless defined(&mvinwstr);
    eval 'sub mvvline_set {
        local($y,$x,$c,$n) = @_;
	    eval q( &mvwvline_set( &stdscr,$y,$x,$c,$n));
    }' unless defined(&mvvline_set);
    eval 'sub mvwadd_wch {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wadd_wch( &stdscr,$c)));
    }' unless defined(&mvwadd_wch);
    eval 'sub mvwaddnwstr {
        local($win,$y,$x,$wstr,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddnwstr( &stdscr,$wstr,$n)));
    }' unless defined(&mvwaddnwstr);
    eval 'sub mvwaddwstr {
        local($win,$y,$x,$wstr,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &waddnwstr( &stdscr,$wstr,-1)));
    }' unless defined(&mvwaddwstr);
    eval 'sub mvwchgat {
        local($win,$y,$x,$n,$a,$c,$o) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wchgat($win,$n,$a,$c,$o)));
    }' unless defined(&mvwchgat);
    eval 'sub mvwget_wch {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wget_wch($win,$c)));
    }' unless defined(&mvwget_wch);
    eval 'sub mvwget_wstr {
        local($win,$y,$x,$t) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wgetn_wstr($win,$t,-1)));
    }' unless defined(&mvwget_wstr);
    eval 'sub mvwgetn_wstr {
        local($win,$y,$x,$t,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wgetn_wstr($win,$t,$n)));
    }' unless defined(&mvwgetn_wstr);
    eval 'sub mvwhline_set {
        local($win,$y,$x,$c,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &whline_set($win,$c,$n)));
    }' unless defined(&mvwhline_set);
    eval 'sub mvwin_wch {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &win_wch($win,$c)));
    }' unless defined(&mvwin_wch);
    eval 'sub mvwin_wchnstr {
        local($win,$y,$x,$c,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &win_wchnstr( &stdscr,$c,$n)));
    }' unless defined(&mvwin_wchnstr);
    eval 'sub mvwin_wchstr {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &win_wchnstr( &stdscr,$c,-1)));
    }' unless defined(&mvwin_wchstr);
    eval 'sub mvwinnwstr {
        local($win,$y,$x,$c,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winnwstr( &stdscr,$c,$n)));
    }' unless defined(&mvwinnwstr);
    eval 'sub mvwins_nwstr {
        local($win,$y,$x,$t,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wins_nwstr( &stdscr,$t,$n)));
    }' unless defined(&mvwins_nwstr);
    eval 'sub mvwins_wch {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wins_wch( &stdscr,$c)));
    }' unless defined(&mvwins_wch);
    eval 'sub mvwins_wstr {
        local($win,$y,$x,$t) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wins_nwstr( &stdscr,$t,-1)));
    }' unless defined(&mvwins_wstr);
    eval 'sub mvwinwstr {
        local($win,$y,$x,$c) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &winnwstr( &stdscr,$c,-1)));
    }' unless defined(&mvwinwstr);
    eval 'sub mvwvline_set {
        local($win,$y,$x,$c,$n) = @_;
	    eval q(( &wmove($win,$y,$x) ==  &ERR ?  &ERR :  &wvline_set($win,$c,$n)));
    }' unless defined(&mvwvline_set);
    eval 'sub slk_attr_off {
        local($a,$v) = @_;
	    eval q((($v) ?  &ERR :  &slk_attroff($a)));
    }' unless defined(&slk_attr_off);
    eval 'sub slk_attr_on {
        local($a,$v) = @_;
	    eval q((($v) ?  &ERR :  &slk_attron($a)));
    }' unless defined(&slk_attr_on);
    eval 'sub vid_attr {
        local($a,$pair,$opts) = @_;
	    eval q( &vidattr($a));
    }' unless defined(&vid_attr);
    eval 'sub vline_set {
        local($c,$n) = @_;
	    eval q( &wvline_set( &stdscr,$c,$n));
    }' unless defined(&vline_set);
    eval 'sub waddwstr {
        local($win,$wstr,$n) = @_;
	    eval q( &waddnwstr($win,$wstr,-1));
    }' unless defined(&waddwstr);
    eval 'sub wattr_get {
        local($win,$a,$p,$opts) = @_;
	    eval q((( != 0 && (* = -> &_attrs)), (($p) != 0 && (*($p) =  &PAIR_NUMBER(($win)-> &_attrs))),  &OK));
    }' unless defined(&wattr_get);
    eval 'sub wget_wstr {
        local($w,$t) = @_;
	    eval q( &wgetn_wstr($w,$t,-1));
    }' unless defined(&wget_wstr);
    eval 'sub win_wchstr {
        local($w,$c) = @_;
	    eval q( &win_wchnstr($w,$c,-1));
    }' unless defined(&win_wchstr);
    eval 'sub wins_wstr {
        local($w,$t) = @_;
	    eval q( &wins_nwstr($w,$t,-1));
    }' unless defined(&wins_wstr);
    eval 'sub winwstr {
        local($w,$c) = @_;
	    eval q( &winnwstr($w,$c,-1));
    }' unless defined(&winwstr);
    eval 'sub vw_printw () { &vwprintw;}' unless defined(&vw_printw);
    eval 'sub vw_scanw () { &vwscanw;}' unless defined(&vw_scanw);
    eval 'sub KEY_CODE_YES () {0400;}' unless defined(&KEY_CODE_YES);
    eval 'sub KEY_MIN () {0401;}' unless defined(&KEY_MIN);
    eval 'sub KEY_BREAK () {0401;}' unless defined(&KEY_BREAK);
    eval 'sub KEY_DOWN () {0402;}' unless defined(&KEY_DOWN);
    eval 'sub KEY_UP () {0403;}' unless defined(&KEY_UP);
    eval 'sub KEY_LEFT () {0404;}' unless defined(&KEY_LEFT);
    eval 'sub KEY_RIGHT () {0405;}' unless defined(&KEY_RIGHT);
    eval 'sub KEY_HOME () {0406;}' unless defined(&KEY_HOME);
    eval 'sub KEY_BACKSPACE () {0407;}' unless defined(&KEY_BACKSPACE);
    eval 'sub KEY_F0 () {0410;}' unless defined(&KEY_F0);
    eval 'sub KEY_F {
        local($n) = @_;
	    eval q(( &KEY_F0+($n)));
    }' unless defined(&KEY_F);
    eval 'sub KEY_DL () {0510;}' unless defined(&KEY_DL);
    eval 'sub KEY_IL () {0511;}' unless defined(&KEY_IL);
    eval 'sub KEY_DC () {0512;}' unless defined(&KEY_DC);
    eval 'sub KEY_IC () {0513;}' unless defined(&KEY_IC);
    eval 'sub KEY_EIC () {0514;}' unless defined(&KEY_EIC);
    eval 'sub KEY_CLEAR () {0515;}' unless defined(&KEY_CLEAR);
    eval 'sub KEY_EOS () {0516;}' unless defined(&KEY_EOS);
    eval 'sub KEY_EOL () {0517;}' unless defined(&KEY_EOL);
    eval 'sub KEY_SF () {0520;}' unless defined(&KEY_SF);
    eval 'sub KEY_SR () {0521;}' unless defined(&KEY_SR);
    eval 'sub KEY_NPAGE () {0522;}' unless defined(&KEY_NPAGE);
    eval 'sub KEY_PPAGE () {0523;}' unless defined(&KEY_PPAGE);
    eval 'sub KEY_STAB () {0524;}' unless defined(&KEY_STAB);
    eval 'sub KEY_CTAB () {0525;}' unless defined(&KEY_CTAB);
    eval 'sub KEY_CATAB () {0526;}' unless defined(&KEY_CATAB);
    eval 'sub KEY_ENTER () {0527;}' unless defined(&KEY_ENTER);
    eval 'sub KEY_SRESET () {0530;}' unless defined(&KEY_SRESET);
    eval 'sub KEY_RESET () {0531;}' unless defined(&KEY_RESET);
    eval 'sub KEY_PRINT () {0532;}' unless defined(&KEY_PRINT);
    eval 'sub KEY_LL () {0533;}' unless defined(&KEY_LL);
    eval 'sub KEY_A1 () {0534;}' unless defined(&KEY_A1);
    eval 'sub KEY_A3 () {0535;}' unless defined(&KEY_A3);
    eval 'sub KEY_B2 () {0536;}' unless defined(&KEY_B2);
    eval 'sub KEY_C1 () {0537;}' unless defined(&KEY_C1);
    eval 'sub KEY_C3 () {0540;}' unless defined(&KEY_C3);
    eval 'sub KEY_BTAB () {0541;}' unless defined(&KEY_BTAB);
    eval 'sub KEY_BEG () {0542;}' unless defined(&KEY_BEG);
    eval 'sub KEY_CANCEL () {0543;}' unless defined(&KEY_CANCEL);
    eval 'sub KEY_CLOSE () {0544;}' unless defined(&KEY_CLOSE);
    eval 'sub KEY_COMMAND () {0545;}' unless defined(&KEY_COMMAND);
    eval 'sub KEY_COPY () {0546;}' unless defined(&KEY_COPY);
    eval 'sub KEY_CREATE () {0547;}' unless defined(&KEY_CREATE);
    eval 'sub KEY_END () {0550;}' unless defined(&KEY_END);
    eval 'sub KEY_EXIT () {0551;}' unless defined(&KEY_EXIT);
    eval 'sub KEY_FIND () {0552;}' unless defined(&KEY_FIND);
    eval 'sub KEY_HELP () {0553;}' unless defined(&KEY_HELP);
    eval 'sub KEY_MARK () {0554;}' unless defined(&KEY_MARK);
    eval 'sub KEY_MESSAGE () {0555;}' unless defined(&KEY_MESSAGE);
    eval 'sub KEY_MOVE () {0556;}' unless defined(&KEY_MOVE);
    eval 'sub KEY_NEXT () {0557;}' unless defined(&KEY_NEXT);
    eval 'sub KEY_OPEN () {0560;}' unless defined(&KEY_OPEN);
    eval 'sub KEY_OPTIONS () {0561;}' unless defined(&KEY_OPTIONS);
    eval 'sub KEY_PREVIOUS () {0562;}' unless defined(&KEY_PREVIOUS);
    eval 'sub KEY_REDO () {0563;}' unless defined(&KEY_REDO);
    eval 'sub KEY_REFERENCE () {0564;}' unless defined(&KEY_REFERENCE);
    eval 'sub KEY_REFRESH () {0565;}' unless defined(&KEY_REFRESH);
    eval 'sub KEY_REPLACE () {0566;}' unless defined(&KEY_REPLACE);
    eval 'sub KEY_RESTART () {0567;}' unless defined(&KEY_RESTART);
    eval 'sub KEY_RESUME () {0570;}' unless defined(&KEY_RESUME);
    eval 'sub KEY_SAVE () {0571;}' unless defined(&KEY_SAVE);
    eval 'sub KEY_SBEG () {0572;}' unless defined(&KEY_SBEG);
    eval 'sub KEY_SCANCEL () {0573;}' unless defined(&KEY_SCANCEL);
    eval 'sub KEY_SCOMMAND () {0574;}' unless defined(&KEY_SCOMMAND);
    eval 'sub KEY_SCOPY () {0575;}' unless defined(&KEY_SCOPY);
    eval 'sub KEY_SCREATE () {0576;}' unless defined(&KEY_SCREATE);
    eval 'sub KEY_SDC () {0577;}' unless defined(&KEY_SDC);
    eval 'sub KEY_SDL () {0600;}' unless defined(&KEY_SDL);
    eval 'sub KEY_SELECT () {0601;}' unless defined(&KEY_SELECT);
    eval 'sub KEY_SEND () {0602;}' unless defined(&KEY_SEND);
    eval 'sub KEY_SEOL () {0603;}' unless defined(&KEY_SEOL);
    eval 'sub KEY_SEXIT () {0604;}' unless defined(&KEY_SEXIT);
    eval 'sub KEY_SFIND () {0605;}' unless defined(&KEY_SFIND);
    eval 'sub KEY_SHELP () {0606;}' unless defined(&KEY_SHELP);
    eval 'sub KEY_SHOME () {0607;}' unless defined(&KEY_SHOME);
    eval 'sub KEY_SIC () {0610;}' unless defined(&KEY_SIC);
    eval 'sub KEY_SLEFT () {0611;}' unless defined(&KEY_SLEFT);
    eval 'sub KEY_SMESSAGE () {0612;}' unless defined(&KEY_SMESSAGE);
    eval 'sub KEY_SMOVE () {0613;}' unless defined(&KEY_SMOVE);
    eval 'sub KEY_SNEXT () {0614;}' unless defined(&KEY_SNEXT);
    eval 'sub KEY_SOPTIONS () {0615;}' unless defined(&KEY_SOPTIONS);
    eval 'sub KEY_SPREVIOUS () {0616;}' unless defined(&KEY_SPREVIOUS);
    eval 'sub KEY_SPRINT () {0617;}' unless defined(&KEY_SPRINT);
    eval 'sub KEY_SREDO () {0620;}' unless defined(&KEY_SREDO);
    eval 'sub KEY_SREPLACE () {0621;}' unless defined(&KEY_SREPLACE);
    eval 'sub KEY_SRIGHT () {0622;}' unless defined(&KEY_SRIGHT);
    eval 'sub KEY_SRSUME () {0623;}' unless defined(&KEY_SRSUME);
    eval 'sub KEY_SSAVE () {0624;}' unless defined(&KEY_SSAVE);
    eval 'sub KEY_SSUSPEND () {0625;}' unless defined(&KEY_SSUSPEND);
    eval 'sub KEY_SUNDO () {0626;}' unless defined(&KEY_SUNDO);
    eval 'sub KEY_SUSPEND () {0627;}' unless defined(&KEY_SUSPEND);
    eval 'sub KEY_UNDO () {0630;}' unless defined(&KEY_UNDO);
    eval 'sub KEY_MOUSE () {0631;}' unless defined(&KEY_MOUSE);
    eval 'sub KEY_RESIZE () {0632;}' unless defined(&KEY_RESIZE);
    eval 'sub KEY_MAX () {0777;}' unless defined(&KEY_MAX);
    eval 'sub NCURSES_MOUSE_VERSION () {1;}' unless defined(&NCURSES_MOUSE_VERSION);
    eval 'sub BUTTON1_RELEASED () {000000000001;}' unless defined(&BUTTON1_RELEASED);
    eval 'sub BUTTON1_PRESSED () {000000000002;}' unless defined(&BUTTON1_PRESSED);
    eval 'sub BUTTON1_CLICKED () {000000000004;}' unless defined(&BUTTON1_CLICKED);
    eval 'sub BUTTON1_DOUBLE_CLICKED () {000000000010;}' unless defined(&BUTTON1_DOUBLE_CLICKED);
    eval 'sub BUTTON1_TRIPLE_CLICKED () {000000000020;}' unless defined(&BUTTON1_TRIPLE_CLICKED);
    eval 'sub BUTTON1_RESERVED_EVENT () {000000000040;}' unless defined(&BUTTON1_RESERVED_EVENT);
    eval 'sub BUTTON2_RELEASED () {000000000100;}' unless defined(&BUTTON2_RELEASED);
    eval 'sub BUTTON2_PRESSED () {000000000200;}' unless defined(&BUTTON2_PRESSED);
    eval 'sub BUTTON2_CLICKED () {000000000400;}' unless defined(&BUTTON2_CLICKED);
    eval 'sub BUTTON2_DOUBLE_CLICKED () {000000001000;}' unless defined(&BUTTON2_DOUBLE_CLICKED);
    eval 'sub BUTTON2_TRIPLE_CLICKED () {000000002000;}' unless defined(&BUTTON2_TRIPLE_CLICKED);
    eval 'sub BUTTON2_RESERVED_EVENT () {000000004000;}' unless defined(&BUTTON2_RESERVED_EVENT);
    eval 'sub BUTTON3_RELEASED () {000000010000;}' unless defined(&BUTTON3_RELEASED);
    eval 'sub BUTTON3_PRESSED () {000000020000;}' unless defined(&BUTTON3_PRESSED);
    eval 'sub BUTTON3_CLICKED () {000000040000;}' unless defined(&BUTTON3_CLICKED);
    eval 'sub BUTTON3_DOUBLE_CLICKED () {000000100000;}' unless defined(&BUTTON3_DOUBLE_CLICKED);
    eval 'sub BUTTON3_TRIPLE_CLICKED () {000000200000;}' unless defined(&BUTTON3_TRIPLE_CLICKED);
    eval 'sub BUTTON3_RESERVED_EVENT () {000000400000;}' unless defined(&BUTTON3_RESERVED_EVENT);
    eval 'sub BUTTON4_RELEASED () {000001000000;}' unless defined(&BUTTON4_RELEASED);
    eval 'sub BUTTON4_PRESSED () {000002000000;}' unless defined(&BUTTON4_PRESSED);
    eval 'sub BUTTON4_CLICKED () {000004000000;}' unless defined(&BUTTON4_CLICKED);
    eval 'sub BUTTON4_DOUBLE_CLICKED () {000010000000;}' unless defined(&BUTTON4_DOUBLE_CLICKED);
    eval 'sub BUTTON4_TRIPLE_CLICKED () {000020000000;}' unless defined(&BUTTON4_TRIPLE_CLICKED);
    eval 'sub BUTTON4_RESERVED_EVENT () {000040000000;}' unless defined(&BUTTON4_RESERVED_EVENT);
    eval 'sub BUTTON_CTRL () {000100000000;}' unless defined(&BUTTON_CTRL);
    eval 'sub BUTTON_SHIFT () {000200000000;}' unless defined(&BUTTON_SHIFT);
    eval 'sub BUTTON_ALT () {000400000000;}' unless defined(&BUTTON_ALT);
    eval 'sub ALL_MOUSE_EVENTS () {000777777777;}' unless defined(&ALL_MOUSE_EVENTS);
    eval 'sub REPORT_MOUSE_POSITION () {001000000000;}' unless defined(&REPORT_MOUSE_POSITION);
    eval 'sub BUTTON_RELEASE {
        local($e, $x) = @_;
	    eval q((($e) & (001<< (6* (($x) - 1)))));
    }' unless defined(&BUTTON_RELEASE);
    eval 'sub BUTTON_PRESS {
        local($e, $x) = @_;
	    eval q((($e) & (002<< (6* (($x) - 1)))));
    }' unless defined(&BUTTON_PRESS);
    eval 'sub BUTTON_CLICK {
        local($e, $x) = @_;
	    eval q((($e) & (004<< (6* (($x) - 1)))));
    }' unless defined(&BUTTON_CLICK);
    eval 'sub BUTTON_DOUBLE_CLICK {
        local($e, $x) = @_;
	    eval q((($e) & (010<< (6* (($x) - 1)))));
    }' unless defined(&BUTTON_DOUBLE_CLICK);
    eval 'sub BUTTON_TRIPLE_CLICK {
        local($e, $x) = @_;
	    eval q((($e) & (020<< (6* (($x) - 1)))));
    }' unless defined(&BUTTON_TRIPLE_CLICK);
    eval 'sub BUTTON_RESERVED_EVENT {
        local($e, $x) = @_;
	    eval q((($e) & (040<< (6* (($x) - 1)))));
    }' unless defined(&BUTTON_RESERVED_EVENT);
    eval 'sub mouse_trafo {
        local($y,$x,$to_screen) = @_;
	    eval q( &wmouse_trafo( &stdscr,$y,$x,$to_screen));
    }' unless defined(&mouse_trafo);
    eval 'sub TRACE_DISABLE () {0x;}' unless defined(&TRACE_DISABLE);
    eval 'sub TRACE_TIMES () {0x1;}' unless defined(&TRACE_TIMES);
    eval 'sub TRACE_TPUTS () {0x2;}' unless defined(&TRACE_TPUTS);
    eval 'sub TRACE_UPDATE () {0x4;}' unless defined(&TRACE_UPDATE);
    eval 'sub TRACE_MOVE () {0x8;}' unless defined(&TRACE_MOVE);
    eval 'sub TRACE_CHARPUT () {0x10;}' unless defined(&TRACE_CHARPUT);
    eval 'sub TRACE_ORDINARY () {0x1f;}' unless defined(&TRACE_ORDINARY);
    eval 'sub TRACE_CALLS () {0x20;}' unless defined(&TRACE_CALLS);
    eval 'sub TRACE_VIRTPUT () {0x40;}' unless defined(&TRACE_VIRTPUT);
    eval 'sub TRACE_IEVENT () {0x80;}' unless defined(&TRACE_IEVENT);
    eval 'sub TRACE_BITS () {0x100;}' unless defined(&TRACE_BITS);
    eval 'sub TRACE_ICALLS () {0x200;}' unless defined(&TRACE_ICALLS);
    eval 'sub TRACE_CCALLS () {0x400;}' unless defined(&TRACE_CCALLS);
    eval 'sub TRACE_DATABASE () {0x800;}' unless defined(&TRACE_DATABASE);
    eval 'sub TRACE_ATTRS () {0x1000;}' unless defined(&TRACE_ATTRS);
    eval 'sub TRACE_MAXIMUM () {0xffff;}' unless defined(&TRACE_MAXIMUM);
    if(defined( &TRACE) || defined( &NCURSES_TEST)) {
	eval 'sub OPTIMIZE_MVCUR () {0x1;}' unless defined(&OPTIMIZE_MVCUR);
	eval 'sub OPTIMIZE_HASHMAP () {0x2;}' unless defined(&OPTIMIZE_HASHMAP);
	eval 'sub OPTIMIZE_SCROLL () {0x4;}' unless defined(&OPTIMIZE_SCROLL);
	eval 'sub OPTIMIZE_ALL () {0xff;}' unless defined(&OPTIMIZE_ALL);
    }
    if(defined(&__cplusplus)) {
	undef(&box) if defined(&box);
	undef(&clear) if defined(&clear);
	undef(&erase) if defined(&erase);
	undef(&move) if defined(&move);
	undef(&refresh) if defined(&refresh);
    }
}
1;
