require '_h2ph_pre.ph';

if(defined( &__NetBSD__)) {
    require 'sys/callout.ph';
}
unless(defined(&USBD_RESTART_MAX)) {
    sub USBD_RESTART_MAX () {	5;}
}
unless(defined(&USBREV_UNKNOWN)) {
    sub USBREV_UNKNOWN () {	0;}
}
unless(defined(&USBREV_PRE_1_0)) {
    sub USBREV_PRE_1_0 () {	1;}
}
unless(defined(&USBREV_1_0)) {
    sub USBREV_1_0 () {	2;}
}
unless(defined(&USBREV_1_1)) {
    sub USBREV_1_1 () {	3;}
}
unless(defined(&USBREV_2_0)) {
    sub USBREV_2_0 () {	4;}
}
unless(defined(&USBREV_STR)) {
    sub USBREV_STR () {	{ "unknown", "pre 1.0", "1.0", "1.1", "2.0" };}
}
if(defined(&USB_USE_SOFTINTR)) {
    if(defined(&__HAVE_GENERIC_SOFT_INTERRUPTS)) {
    } else {
    }
}
if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
}
unless(defined(&USBD_NOLANG)) {
    sub USBD_NOLANG () {	(-1);}
}
if(defined(&DIAGNOSTIC)) {
    eval 'sub XFER_FREE () {0x46524545;}' unless defined(&XFER_FREE);
    eval 'sub XFER_BUSY () {0x42555359;}' unless defined(&XFER_BUSY);
    eval 'sub XFER_ONQU () {0x4f4e5155;}' unless defined(&XFER_ONQU);
}
unless(defined(&URQ_REQUEST)) {
    sub URQ_REQUEST () {	0x1;}
}
unless(defined(&URQ_AUTO_DMABUF)) {
    sub URQ_AUTO_DMABUF () {	0x10;}
}
unless(defined(&URQ_DEV_DMABUF)) {
    sub URQ_DEV_DMABUF () {	0x20;}
}
if(defined(&USB_DEBUG)) {
}
if(defined( &DIAGNOSTIC)  && 0) {
    eval 'sub SPLUSBCHECK () { &do { \'int\'  &_s =  &splusb(),  &_su =  &splusb();  &if (! &cold  &&  &_s !=  &_su)  &printf("SPLUSBCHECK failed 0x%x!=0x%x, %s:%d\\n",  &_s,  &_su,  &__FILE__,  &__LINE__);  &splx( &_s); }  &while (0);}' unless defined(&SPLUSBCHECK);
} else {
    eval 'sub SPLUSBCHECK () {1;}' unless defined(&SPLUSBCHECK);
}
if(defined( &__NetBSD__)) {
    require 'locators.ph';
}
 elsif(defined( &__FreeBSD__) || defined( &__OpenBSD__)) {
    eval 'sub UHUBCF_PORT_DEFAULT () {-1;}' unless defined(&UHUBCF_PORT_DEFAULT);
    eval 'sub UHUBCF_CONFIGURATION_DEFAULT () {-1;}' unless defined(&UHUBCF_CONFIGURATION_DEFAULT);
    eval 'sub UHUBCF_INTERFACE_DEFAULT () {-1;}' unless defined(&UHUBCF_INTERFACE_DEFAULT);
    eval 'sub UHUBCF_VENDOR_DEFAULT () {-1;}' unless defined(&UHUBCF_VENDOR_DEFAULT);
    eval 'sub UHUBCF_PRODUCT_DEFAULT () {-1;}' unless defined(&UHUBCF_PRODUCT_DEFAULT);
    eval 'sub UHUBCF_RELEASE_DEFAULT () {-1;}' unless defined(&UHUBCF_RELEASE_DEFAULT);
}
if(defined ( &__OpenBSD__)) {
    eval 'sub UHUBCF_PORT () {0;}' unless defined(&UHUBCF_PORT);
    eval 'sub UHUBCF_CONFIGURATION () {1;}' unless defined(&UHUBCF_CONFIGURATION);
    eval 'sub UHUBCF_INTERFACE () {2;}' unless defined(&UHUBCF_INTERFACE);
    eval 'sub UHUBCF_VENDOR () {3;}' unless defined(&UHUBCF_VENDOR);
    eval 'sub UHUBCF_PRODUCT () {4;}' unless defined(&UHUBCF_PRODUCT);
    eval 'sub UHUBCF_RELEASE () {5;}' unless defined(&UHUBCF_RELEASE);
}
unless(defined(&uhubcf_port)) {
    sub uhubcf_port () {	 $cf_loc[ &UHUBCF_PORT];}
}
unless(defined(&uhubcf_configuration)) {
    sub uhubcf_configuration () {	 $cf_loc[ &UHUBCF_CONFIGURATION];}
}
unless(defined(&uhubcf_interface)) {
    sub uhubcf_interface () {	 $cf_loc[ &UHUBCF_INTERFACE];}
}
unless(defined(&uhubcf_vendor)) {
    sub uhubcf_vendor () {	 $cf_loc[ &UHUBCF_VENDOR];}
}
unless(defined(&uhubcf_product)) {
    sub uhubcf_product () {	 $cf_loc[ &UHUBCF_PRODUCT];}
}
unless(defined(&uhubcf_release)) {
    sub uhubcf_release () {	 $cf_loc[ &UHUBCF_RELEASE];}
}
unless(defined(&UHUB_UNK_PORT)) {
    sub UHUB_UNK_PORT () {	 &UHUBCF_PORT_DEFAULT;}
}
unless(defined(&UHUB_UNK_CONFIGURATION)) {
    sub UHUB_UNK_CONFIGURATION () {	 &UHUBCF_CONFIGURATION_DEFAULT;}
}
unless(defined(&UHUB_UNK_INTERFACE)) {
    sub UHUB_UNK_INTERFACE () {	 &UHUBCF_INTERFACE_DEFAULT;}
}
unless(defined(&UHUB_UNK_VENDOR)) {
    sub UHUB_UNK_VENDOR () {	 &UHUBCF_VENDOR_DEFAULT;}
}
unless(defined(&UHUB_UNK_PRODUCT)) {
    sub UHUB_UNK_PRODUCT () {	 &UHUBCF_PRODUCT_DEFAULT;}
}
unless(defined(&UHUB_UNK_RELEASE)) {
    sub UHUB_UNK_RELEASE () {	 &UHUBCF_RELEASE_DEFAULT;}
}
1;
