require '_h2ph_pre.ph';

unless(defined(&_USB_PORT_H)) {
    eval 'sub _USB_PORT_H () {1;}' unless defined(&_USB_PORT_H);
    if(defined( &__NetBSD__)) {
	require 'opt_usbverbose.ph';
	if(defined( &_KERNEL)) {
	    require 'sys/mallocvar.ph';
	}
	eval 'sub USB_USE_SOFTINTR () {1;}' unless defined(&USB_USE_SOFTINTR);
	if(defined(&USB_DEBUG)) {
	    eval 'sub UKBD_DEBUG () {1;}' unless defined(&UKBD_DEBUG);
	    eval 'sub UHIDEV_DEBUG () {1;}' unless defined(&UHIDEV_DEBUG);
	    eval 'sub UHID_DEBUG () {1;}' unless defined(&UHID_DEBUG);
	    eval 'sub OHCI_DEBUG () {1;}' unless defined(&OHCI_DEBUG);
	    eval 'sub UGEN_DEBUG () {1;}' unless defined(&UGEN_DEBUG);
	    eval 'sub UHCI_DEBUG () {1;}' unless defined(&UHCI_DEBUG);
	    eval 'sub UHUB_DEBUG () {1;}' unless defined(&UHUB_DEBUG);
	    eval 'sub ULPT_DEBUG () {1;}' unless defined(&ULPT_DEBUG);
	    eval 'sub UCOM_DEBUG () {1;}' unless defined(&UCOM_DEBUG);
	    eval 'sub UPLCOM_DEBUG () {1;}' unless defined(&UPLCOM_DEBUG);
	    eval 'sub UMCT_DEBUG () {1;}' unless defined(&UMCT_DEBUG);
	    eval 'sub UMODEM_DEBUG () {1;}' unless defined(&UMODEM_DEBUG);
	    eval 'sub UAUDIO_DEBUG () {1;}' unless defined(&UAUDIO_DEBUG);
	    eval 'sub AUE_DEBUG () {1;}' unless defined(&AUE_DEBUG);
	    eval 'sub CUE_DEBUG () {1;}' unless defined(&CUE_DEBUG);
	    eval 'sub KUE_DEBUG () {1;}' unless defined(&KUE_DEBUG);
	    eval 'sub URL_DEBUG () {1;}' unless defined(&URL_DEBUG);
	    eval 'sub UMASS_DEBUG () {1;}' unless defined(&UMASS_DEBUG);
	    eval 'sub UVISOR_DEBUG () {1;}' unless defined(&UVISOR_DEBUG);
	    eval 'sub UPL_DEBUG () {1;}' unless defined(&UPL_DEBUG);
	    eval 'sub UZCOM_DEBUG () {1;}' unless defined(&UZCOM_DEBUG);
	    eval 'sub URIO_DEBUG () {1;}' unless defined(&URIO_DEBUG);
	    eval 'sub UFTDI_DEBUG () {1;}' unless defined(&UFTDI_DEBUG);
	    eval 'sub USCANNER_DEBUG () {1;}' unless defined(&USCANNER_DEBUG);
	    eval 'sub USSCANNER_DEBUG () {1;}' unless defined(&USSCANNER_DEBUG);
	    eval 'sub UIRDA_DEBUG () {1;}' unless defined(&UIRDA_DEBUG);
	    eval 'sub USTIR_DEBUG () {1;}' unless defined(&USTIR_DEBUG);
	    eval 'sub UISDATA_DEBUG () {1;}' unless defined(&UISDATA_DEBUG);
	    eval 'sub UDSBR_DEBUG () {1;}' unless defined(&UDSBR_DEBUG);
	    eval 'sub UBT_DEBUG () {1;}' unless defined(&UBT_DEBUG);
	    eval 'sub UAX_DEBUG () {1;}' unless defined(&UAX_DEBUG);
	    eval 'sub Static () {1;}' unless defined(&Static);
	} else {
	    eval 'sub Static () { &static;}' unless defined(&Static);
	}
	eval 'sub SCSI_MODE_SENSE () { &MODE_SENSE;}' unless defined(&SCSI_MODE_SENSE);
	eval 'sub UMASS_ATAPISTR () {"atapibus";}' unless defined(&UMASS_ATAPISTR);
	eval 'sub USBBASEDEVICE () {\'struct device\';}' unless defined(&USBBASEDEVICE);
	eval 'sub USBDEV {
	    local($bdev) = @_;
    	    eval q((($bdev)));
	}' unless defined(&USBDEV);
	eval 'sub USBDEVNAME {
	    local($bdev) = @_;
    	    eval q((($bdev). &dv_xname));
	}' unless defined(&USBDEVNAME);
	eval 'sub USBDEVUNIT {
	    local($bdev) = @_;
    	    eval q((($bdev). &dv_unit));
	}' unless defined(&USBDEVUNIT);
	eval 'sub USBDEVPTRNAME {
	    local($bdevptr) = @_;
    	    eval q((($bdevptr)-> &dv_xname));
	}' unless defined(&USBDEVPTRNAME);
	eval 'sub USBGETSOFTC {
	    local($d) = @_;
    	    eval q((($d)));
	}' unless defined(&USBGETSOFTC);
	eval 'sub DECLARE_USB_DMA_T () {\'struct usb_dma_block\';  &typedef \'struct struct\' { \'struct usb_dma_block\' * &block; \'u_int\'  &offs; }  &usb_dma_t;}' unless defined(&DECLARE_USB_DMA_T);
	eval 'sub usb_callout_init {
	    local($h) = @_;
    	    eval q( &callout_init(($h)));
	}' unless defined(&usb_callout_init);
	eval 'sub usb_callout {
	    local($h, $t, $f, $d) = @_;
    	    eval q( &callout_reset(($h), ($t), ($f), ($d)));
	}' unless defined(&usb_callout);
	eval 'sub usb_callout_pending {
	    local($h) = @_;
    	    eval q( &callout_pending(($h)));
	}' unless defined(&usb_callout_pending);
	eval 'sub usb_uncallout {
	    local($h, $f, $d) = @_;
    	    eval q( &callout_stop(($h)));
	}' unless defined(&usb_uncallout);
	eval 'sub usb_lockmgr {
	    local($l, $f, $sl, $p) = @_;
    	    eval q( &lockmgr(($l), ($f), ($sl)));
	}' unless defined(&usb_lockmgr);
	eval 'sub usb_kthread_create1 () { &kthread_create1;}' unless defined(&usb_kthread_create1);
	eval 'sub usb_kthread_create () { &kthread_create;}' unless defined(&usb_kthread_create);
	eval 'sub Ether_ifattach () { &ether_ifattach;}' unless defined(&Ether_ifattach);
	eval 'sub IF_INPUT {
	    local($ifp, $m) = @_;
    	    eval q((*($ifp)-> &if_input)(($ifp), ($m)));
	}' unless defined(&IF_INPUT);
	eval 'sub logprintf () { &printf;}' unless defined(&logprintf);
	eval 'sub USB_DNAME {
	    local($dname) = @_;
    	    eval q($dname);
	}' unless defined(&USB_DNAME);
	eval 'sub USB_DECLARE_DRIVER {
	    local($dname) = @_;
    	    eval q(\'int\'  &__CONCAT($dname, &_match)(\'struct device\' *, \'struct cfdata\' *,  &void *);  &void  &__CONCAT($dname, &_attach)(\'struct device\' *, \'struct device\' *,  &void *); \'int\'  &__CONCAT($dname, &_detach)(\'struct device\' *, \'int\'); \'int\'  &__CONCAT($dname, &_activate)(\'struct device\' *,  &enum  &devact);  &extern \'struct cfdriver\'  &__CONCAT($dname, &_cd);  &CFATTACH_DECL( &USB_DNAME($dname), $sizeof{ &struct ___CONCAT($dname, &_softc)},  &___CONCAT($dname, &_match),  &___CONCAT($dname, &_attach),  &___CONCAT($dname, &_detach),  &___CONCAT($dname, &_activate)));
	}' unless defined(&USB_DECLARE_DRIVER);
	eval 'sub USB_MATCH {
	    local($dname) = @_;
    	    eval q(\'int\'  &__CONCAT($dname, &_match)(\'struct device\' * &parent, \'struct cfdata\' * &match,  &void * &aux));
	}' unless defined(&USB_MATCH);
	eval 'sub USB_MATCH_START {
	    local($dname, $uaa) = @_;
    	    eval q(\'struct usb_attach_arg\' *$uaa =  &aux);
	}' unless defined(&USB_MATCH_START);
	eval 'sub USB_ATTACH {
	    local($dname) = @_;
    	    eval q( &void  &__CONCAT($dname, &_attach)(\'struct device\' * &parent, \'struct device\' * &self,  &void * &aux));
	}' unless defined(&USB_ATTACH);
	eval 'sub USB_ATTACH_START {
	    local($dname, $sc, $uaa) = @_;
    	    eval q( &struct __CONCAT($dname, &_softc) *$sc = ( &struct __CONCAT($dname, &_softc) *) &self; \'struct usb_attach_arg\' *$uaa =  &aux);
	}' unless defined(&USB_ATTACH_START);
	eval 'sub USB_ATTACH_ERROR_RETURN () { &return;}' unless defined(&USB_ATTACH_ERROR_RETURN);
	eval 'sub USB_ATTACH_SUCCESS_RETURN () { &return;}' unless defined(&USB_ATTACH_SUCCESS_RETURN);
	eval 'sub USB_ATTACH_SETUP () { &printf("\\n");}' unless defined(&USB_ATTACH_SETUP);
	eval 'sub USB_DETACH {
	    local($dname) = @_;
    	    eval q(\'int\'  &__CONCAT($dname, &_detach)(\'struct device\' * &self, \'int\'  &flags));
	}' unless defined(&USB_DETACH);
	eval 'sub USB_DETACH_START {
	    local($dname, $sc) = @_;
    	    eval q( &struct __CONCAT($dname, &_softc) *$sc = ( &struct __CONCAT($dname, &_softc) *) &self);
	}' unless defined(&USB_DETACH_START);
	eval 'sub USB_GET_SC_OPEN {
	    local($dname, $unit, $sc) = @_;
    	    eval q( &if ($unit >=  &__CONCAT($dname, &_cd). &cd_ndevs)  &return ( &ENXIO); $sc =  &__CONCAT($dname, &_cd). $cd_devs[$unit];  &if ($sc ==  &NULL)  &return ( &ENXIO));
	}' unless defined(&USB_GET_SC_OPEN);
	eval 'sub USB_GET_SC {
	    local($dname, $unit, $sc) = @_;
    	    eval q($sc =  &__CONCAT($dname, &_cd). $cd_devs[$unit]);
	}' unless defined(&USB_GET_SC);
	eval 'sub USB_DO_ATTACH {
	    local($dev, $bdev, $parent, $args, $print, $sub) = @_;
    	    eval q(( &config_found_sm($parent, $args, $print, $sub)));
	}' unless defined(&USB_DO_ATTACH);
    }
 elsif(defined( &__OpenBSD__)) {
	require 'sys/timeout.ph';
	eval 'sub USB_USE_SOFTINTR () {1;}' unless defined(&USB_USE_SOFTINTR);
	if(defined(&USB_DEBUG)) {
	    eval 'sub UKBD_DEBUG () {1;}' unless defined(&UKBD_DEBUG);
	    eval 'sub UHIDEV_DEBUG () {1;}' unless defined(&UHIDEV_DEBUG);
	    eval 'sub UHID_DEBUG () {1;}' unless defined(&UHID_DEBUG);
	    eval 'sub OHCI_DEBUG () {1;}' unless defined(&OHCI_DEBUG);
	    eval 'sub UGEN_DEBUG () {1;}' unless defined(&UGEN_DEBUG);
	    eval 'sub UHCI_DEBUG () {1;}' unless defined(&UHCI_DEBUG);
	    eval 'sub UHUB_DEBUG () {1;}' unless defined(&UHUB_DEBUG);
	    eval 'sub ULPT_DEBUG () {1;}' unless defined(&ULPT_DEBUG);
	    eval 'sub UCOM_DEBUG () {1;}' unless defined(&UCOM_DEBUG);
	    eval 'sub UPLCOM_DEBUG () {1;}' unless defined(&UPLCOM_DEBUG);
	    eval 'sub UMCT_DEBUG () {1;}' unless defined(&UMCT_DEBUG);
	    eval 'sub UMODEM_DEBUG () {1;}' unless defined(&UMODEM_DEBUG);
	    eval 'sub UAUDIO_DEBUG () {1;}' unless defined(&UAUDIO_DEBUG);
	    eval 'sub AUE_DEBUG () {1;}' unless defined(&AUE_DEBUG);
	    eval 'sub CUE_DEBUG () {1;}' unless defined(&CUE_DEBUG);
	    eval 'sub KUE_DEBUG () {1;}' unless defined(&KUE_DEBUG);
	    eval 'sub UMASS_DEBUG () {1;}' unless defined(&UMASS_DEBUG);
	    eval 'sub UVISOR_DEBUG () {1;}' unless defined(&UVISOR_DEBUG);
	    eval 'sub UPL_DEBUG () {1;}' unless defined(&UPL_DEBUG);
	    eval 'sub UZCOM_DEBUG () {1;}' unless defined(&UZCOM_DEBUG);
	    eval 'sub URIO_DEBUG () {1;}' unless defined(&URIO_DEBUG);
	    eval 'sub UFTDI_DEBUG () {1;}' unless defined(&UFTDI_DEBUG);
	    eval 'sub USCANNER_DEBUG () {1;}' unless defined(&USCANNER_DEBUG);
	    eval 'sub USSCANNER_DEBUG () {1;}' unless defined(&USSCANNER_DEBUG);
	    eval 'sub UISDATA_DEBUG () {1;}' unless defined(&UISDATA_DEBUG);
	    eval 'sub UDSBR_DEBUG () {1;}' unless defined(&UDSBR_DEBUG);
	}
	eval 'sub Static () {1;}' unless defined(&Static);
	eval 'sub UMASS_ATAPISTR () {"atapiscsi";}' unless defined(&UMASS_ATAPISTR);
	eval 'sub PQUIRK_FORCELUNS () { &SDEV_FORCELUNS;}' unless defined(&PQUIRK_FORCELUNS);
	eval 'sub PQUIRK_NOMODESENSE () { &SDEV_NOMODESENSE;}' unless defined(&PQUIRK_NOMODESENSE);
	eval 'sub PQUIRK_NOTUR () { &ADEV_NOTUR;}' unless defined(&PQUIRK_NOTUR);
	eval 'sub PQUIRK_NODOORLOCK () { &ADEV_NODOORLOCK;}' unless defined(&PQUIRK_NODOORLOCK);
	eval 'sub PQUIRK_NOSENSE () { &ADEV_NOSENSE;}' unless defined(&PQUIRK_NOSENSE);
	eval 'sub PQUIRK_ONLYBIG () { &SDEV_ONLYBIG;}' unless defined(&PQUIRK_ONLYBIG);
	eval 'sub PQUIRK_NOBIGMODESENSE () {0;}' unless defined(&PQUIRK_NOBIGMODESENSE);
	eval 'sub sel_klist () { &si_note;}' unless defined(&sel_klist);
	eval 'sub UCOMBUSCF_PORTNO () {-1;}' unless defined(&UCOMBUSCF_PORTNO);
	eval 'sub UCOMBUSCF_PORTNO_DEFAULT () {-1;}' unless defined(&UCOMBUSCF_PORTNO_DEFAULT);
	eval 'sub UHIDBUSCF_REPORTID () {-1;}' unless defined(&UHIDBUSCF_REPORTID);
	eval 'sub UHIDBUSCF_REPORTID_DEFAULT () {-1;}' unless defined(&UHIDBUSCF_REPORTID_DEFAULT);
	eval 'sub bswap32 {
	    local($x) = @_;
    	    eval q( &swap32($x));
	}' unless defined(&bswap32);
	eval 'sub bswap16 {
	    local($x) = @_;
    	    eval q( &swap16($x));
	}' unless defined(&bswap16);
	eval 'sub mstohz {
	    local($ms) = @_;
    	    eval q((($ms) *  &hz / 1000));
	}' unless defined(&mstohz);
	if(defined( &letoh32)) {
	    eval 'sub le32toh {
	        local($x) = @_;
    		eval q( &letoh32($x));
	    }' unless defined(&le32toh);
	    eval 'sub le16toh {
	        local($x) = @_;
    		eval q( &letoh16($x));
	    }' unless defined(&le16toh);
	}
	eval 'sub sel_klist () { &si_note;}' unless defined(&sel_klist);
	eval 'sub usb_kthread_create1 () { &kthread_create;}' unless defined(&usb_kthread_create1);
	eval 'sub usb_kthread_create () { &kthread_create_deferred;}' unless defined(&usb_kthread_create);
	eval 'sub config_pending_incr () {
	    eval q();
	}' unless defined(&config_pending_incr);
	eval 'sub config_pending_decr () {
	    eval q();
	}' unless defined(&config_pending_decr);
	eval 'sub Ether_ifattach {
	    local($ifp, $eaddr) = @_;
    	    eval q( &ether_ifattach($ifp));
	}' unless defined(&Ether_ifattach);
	eval 'sub if_deactivate {
	    local($x) = @_;
    	    eval q();
	}' unless defined(&if_deactivate);
	eval 'sub IF_INPUT {
	    local($ifp, $m) = @_;
    	    eval q( &ether_input_mbuf(($ifp), ($m)));
	}' unless defined(&IF_INPUT);
	eval 'sub usbpoll () { &usbselect;}' unless defined(&usbpoll);
	eval 'sub uhidpoll () { &uhidselect;}' unless defined(&uhidpoll);
	eval 'sub ugenpoll () { &ugenselect;}' unless defined(&ugenpoll);
	eval 'sub uriopoll () { &urioselect;}' unless defined(&uriopoll);
	eval 'sub uscannerpoll () { &uscannerselect;}' unless defined(&uscannerpoll);
	eval 'sub logprintf () { &printf;}' unless defined(&logprintf);
	eval 'sub swap_bytes_change_sign16_le () { &swap_bytes_change_sign16;}' unless defined(&swap_bytes_change_sign16_le);
	eval 'sub change_sign16_swap_bytes_le () { &change_sign16_swap_bytes;}' unless defined(&change_sign16_swap_bytes_le);
	eval 'sub change_sign16_le () { &change_sign16;}' unless defined(&change_sign16_le);
	eval 'sub ulinear8_to_slinear16_le () { &ulinear8_to_linear16_le;}' unless defined(&ulinear8_to_slinear16_le);
	eval 'sub ulinear8_to_slinear16_be () { &ulinear8_to_linear16_be;}' unless defined(&ulinear8_to_slinear16_be);
	eval 'sub slinear16_to_ulinear8_le () { &linear16_to_ulinear8_le;}' unless defined(&slinear16_to_ulinear8_le);
	eval 'sub slinear16_to_ulinear8_be () { &linear16_to_ulinear8_be;}' unless defined(&slinear16_to_ulinear8_be);
	eval 'sub realloc () { &usb_realloc;}' unless defined(&realloc);
	eval 'sub USBBASEDEVICE () {\'struct device\';}' unless defined(&USBBASEDEVICE);
	eval 'sub USBDEV {
	    local($bdev) = @_;
    	    eval q((($bdev)));
	}' unless defined(&USBDEV);
	eval 'sub USBDEVNAME {
	    local($bdev) = @_;
    	    eval q((($bdev). &dv_xname));
	}' unless defined(&USBDEVNAME);
	eval 'sub USBDEVUNIT {
	    local($bdev) = @_;
    	    eval q((($bdev). &dv_unit));
	}' unless defined(&USBDEVUNIT);
	eval 'sub USBDEVPTRNAME {
	    local($bdevptr) = @_;
    	    eval q((($bdevptr)-> &dv_xname));
	}' unless defined(&USBDEVPTRNAME);
	eval 'sub USBGETSOFTC {
	    local($d) = @_;
    	    eval q((($d)));
	}' unless defined(&USBGETSOFTC);
	eval 'sub DECLARE_USB_DMA_T () {\'struct usb_dma_block\';  &typedef \'struct struct\' { \'struct usb_dma_block\' * &block; \'u_int\'  &offs; }  &usb_dma_t;}' unless defined(&DECLARE_USB_DMA_T);
	eval 'sub usb_callout_init {
	    local($h) = @_;
    	    eval q( &timeout_set(($h),  &NULL,  &NULL));
	}' unless defined(&usb_callout_init);
	eval 'sub usb_callout {
	    local($h, $t, $f, $d) = @_;
    	    eval q( &do {  &timeout_del(($h));  &timeout_set(($h), ($f), ($d));  &timeout_add(($h), ($t)); }  &while (0));
	}' unless defined(&usb_callout);
	eval 'sub usb_callout_pending {
	    local($h) = @_;
    	    eval q( &timeout_pending(($h)));
	}' unless defined(&usb_callout_pending);
	eval 'sub usb_uncallout {
	    local($h, $f, $d) = @_;
    	    eval q( &timeout_del(($h)));
	}' unless defined(&usb_uncallout);
	eval 'sub usb_lockmgr {
	    local($l, $f, $sl, $p) = @_;
    	    eval q( &lockmgr(($l), ($f), ($sl), ($p)));
	}' unless defined(&usb_lockmgr);
	eval 'sub USB_DECLARE_DRIVER {
	    local($dname) = @_;
    	    eval q(\'int\'  &__CONCAT($dname, &_match)(\'struct device\' *,  &void *,  &void *);  &void  &__CONCAT($dname, &_attach)(\'struct device\' *, \'struct device\' *,  &void *); \'int\'  &__CONCAT($dname, &_detach)(\'struct device\' *, \'int\'); \'int\'  &__CONCAT($dname, &_activate)(\'struct device\' *,  &enum  &devact); \'struct cfdriver\'  &__CONCAT($dname, &_cd) = {  &NULL, $dname,  &DV_DULL };  &const \'struct cfattach\'  &__CONCAT($dname, &_ca) = { $sizeof{ &struct __CONCAT($dname, &_softc)},  &__CONCAT($dname, &_match),  &__CONCAT($dname, &_attach),  &__CONCAT($dname, &_detach),  &__CONCAT($dname, &_activate), });
	}' unless defined(&USB_DECLARE_DRIVER);
	eval 'sub USB_MATCH {
	    local($dname) = @_;
    	    eval q(\'int\'  &__CONCAT($dname, &_match)( &parent,  &match,  &aux) \'struct device\' * &parent;  &void * &match;  &void * &aux;);
	}' unless defined(&USB_MATCH);
	eval 'sub USB_MATCH_START {
	    local($dname, $uaa) = @_;
    	    eval q(\'struct usb_attach_arg\' *$uaa =  &aux);
	}' unless defined(&USB_MATCH_START);
	eval 'sub USB_ATTACH {
	    local($dname) = @_;
    	    eval q( &void  &__CONCAT($dname, &_attach)( &parent,  &self,  &aux) \'struct device\' * &parent; \'struct device\' * &self;  &void * &aux;);
	}' unless defined(&USB_ATTACH);
	eval 'sub USB_ATTACH_START {
	    local($dname, $sc, $uaa) = @_;
    	    eval q( &struct __CONCAT($dname, &_softc) *$sc = ( &struct __CONCAT($dname, &_softc) *) &self; \'struct usb_attach_arg\' *$uaa =  &aux);
	}' unless defined(&USB_ATTACH_START);
	eval 'sub USB_ATTACH_ERROR_RETURN () { &return;}' unless defined(&USB_ATTACH_ERROR_RETURN);
	eval 'sub USB_ATTACH_SUCCESS_RETURN () { &return;}' unless defined(&USB_ATTACH_SUCCESS_RETURN);
	eval 'sub USB_ATTACH_SETUP () { &printf("\\n");}' unless defined(&USB_ATTACH_SETUP);
	eval 'sub USB_DETACH {
	    local($dname) = @_;
    	    eval q(\'int\'  &__CONCAT($dname, &_detach)( &self,  &flags) \'struct device\' * &self; \'int\'  &flags;);
	}' unless defined(&USB_DETACH);
	eval 'sub USB_DETACH_START {
	    local($dname, $sc) = @_;
    	    eval q( &struct __CONCAT($dname, &_softc) *$sc = ( &struct __CONCAT($dname, &_softc) *) &self);
	}' unless defined(&USB_DETACH_START);
	eval 'sub USB_GET_SC_OPEN {
	    local($dname, $unit, $sc) = @_;
    	    eval q( &if ($unit >=  &__CONCAT($dname, &_cd). &cd_ndevs)  &return ( &ENXIO); $sc =  &__CONCAT($dname, &_cd). $cd_devs[$unit];  &if ($sc ==  &NULL)  &return ( &ENXIO));
	}' unless defined(&USB_GET_SC_OPEN);
	eval 'sub USB_GET_SC {
	    local($dname, $unit, $sc) = @_;
    	    eval q($sc =  &__CONCAT($dname, &_cd). $cd_devs[$unit]);
	}' unless defined(&USB_GET_SC);
	eval 'sub USB_DO_ATTACH {
	    local($dev, $bdev, $parent, $args, $print, $sub) = @_;
    	    eval q(( &config_found_sm($parent, $args, $print, $sub)));
	}' unless defined(&USB_DO_ATTACH);
    }
 elsif(defined( &__FreeBSD__)) {
	require 'opt_usb.ph';
	if(defined( &_KERNEL)) {
	    require 'sys/malloc.ph';
	}
	eval 'sub Static () {1;}' unless defined(&Static);
	eval 'sub USBVERBOSE () {1;}' unless defined(&USBVERBOSE);
	eval 'sub device_ptr_t () { &device_t;}' unless defined(&device_ptr_t);
	eval 'sub USBBASEDEVICE () { &device_t;}' unless defined(&USBBASEDEVICE);
	eval 'sub USBDEV {
	    local($bdev) = @_;
    	    eval q(($bdev));
	}' unless defined(&USBDEV);
	eval 'sub USBDEVNAME {
	    local($bdev) = @_;
    	    eval q( &device_get_nameunit($bdev));
	}' unless defined(&USBDEVNAME);
	eval 'sub USBDEVUNIT {
	    local($bdev) = @_;
    	    eval q( &device_get_unit($bdev));
	}' unless defined(&USBDEVUNIT);
	eval 'sub USBDEVPTRNAME {
	    local($bdev) = @_;
    	    eval q( &device_get_nameunit($bdev));
	}' unless defined(&USBDEVPTRNAME);
	eval 'sub USBGETSOFTC {
	    local($bdev) = @_;
    	    eval q(( &device_get_softc($bdev)));
	}' unless defined(&USBGETSOFTC);
	eval 'sub DECLARE_USB_DMA_T () { &typedef  &void *  &usb_dma_t;}' unless defined(&DECLARE_USB_DMA_T);
	eval 'sub memcpy {
	    local($d, $s, $l) = @_;
    	    eval q( &bcopy(($s),($d),($l)));
	}' unless defined(&memcpy);
	eval 'sub memset {
	    local($d, $v, $l) = @_;
    	    eval q( &bzero(($d),($l)));
	}' unless defined(&memset);
	eval 'sub bswap32 {
	    local($x) = @_;
    	    eval q( &swap32($x));
	}' unless defined(&bswap32);
	eval 'sub kthread_create1 {
	    local($f, $s, $p, $a0, $a1) = @_;
    	    eval q( &kthread_create(($f), ($s), ($p),  &RFHIGHPID, ($a0), ($a1)));
	}' unless defined(&kthread_create1);
	eval 'sub usb_callout_init {
	    local($h) = @_;
    	    eval q( &callout_handle_init(($h)));
	}' unless defined(&usb_callout_init);
	eval 'sub usb_callout {
	    local($h, $t, $f, $d) = @_;
    	    eval q((($h) =  &timeout(($f), ($d), ($t))));
	}' unless defined(&usb_callout);
	eval 'sub usb_uncallout {
	    local($h, $f, $d) = @_;
    	    eval q( &uncallout(($f), ($d), ($h)));
	}' unless defined(&usb_uncallout);
	eval 'sub clalloc {
	    local($p, $s, $x) = @_;
    	    eval q(( &clist_alloc_cblocks(($p), ($s), ($s)), 0));
	}' unless defined(&clalloc);
	eval 'sub clfree {
	    local($p) = @_;
    	    eval q( &clist_free_cblocks(($p)));
	}' unless defined(&clfree);
	eval 'sub powerhook_establish {
	    local($fn, $sc) = @_;
    	    eval q(($fn));
	}' unless defined(&powerhook_establish);
	eval 'sub powerhook_disestablish {
	    local($hdl) = @_;
    	    eval q();
	}' unless defined(&powerhook_disestablish);
	eval 'sub PWR_RESUME () {0;}' unless defined(&PWR_RESUME);
	eval 'sub config_detach {
	    local($dev, $flag) = @_;
    	    eval q( &device_delete_child( &device_get_parent($dev), $dev));
	}' unless defined(&config_detach);
	eval 'sub USB_DECLARE_DRIVER_INIT {
	    local($dname, $init) = @_;
    	    eval q( &Static  &device_probe_t  &__CONCAT($dname, &_match);  &Static  &device_attach_t  &__CONCAT($dname, &_attach);  &Static  &device_detach_t  &__CONCAT($dname, &_detach);  &Static  &devclass_t  &__CONCAT($dname, &_devclass);  &Static  &device_method_t  &__CONCAT($dname, &_methods)[] = {  &DEVMETHOD( &device_probe,  &__CONCAT($dname, &_match)),  &DEVMETHOD( &device_attach,  &__CONCAT($dname, &_attach)),  &DEVMETHOD( &device_detach,  &__CONCAT($dname, &_detach)), $init, {0,0} };  &Static  &driver_t  &__CONCAT($dname, &_driver) = { $dname,  &__CONCAT($dname, &_methods), $sizeof{ &struct __CONCAT($dname, &_softc)} });
	}' unless defined(&USB_DECLARE_DRIVER_INIT);
	eval 'sub METHODS_NONE () {{0,0};}' unless defined(&METHODS_NONE);
	eval 'sub USB_DECLARE_DRIVER {
	    local($dname) = @_;
    	    eval q( &USB_DECLARE_DRIVER_INIT($dname,  &METHODS_NONE));
	}' unless defined(&USB_DECLARE_DRIVER);
	eval 'sub USB_MATCH {
	    local($dname) = @_;
    	    eval q( &Static \'int\'  &__CONCAT($dname, &_match)( &device_t  &self));
	}' unless defined(&USB_MATCH);
	eval 'sub USB_MATCH_START {
	    local($dname, $uaa) = @_;
    	    eval q(\'struct usb_attach_arg\' *$uaa =  &device_get_ivars( &self));
	}' unless defined(&USB_MATCH_START);
	eval 'sub USB_ATTACH {
	    local($dname) = @_;
    	    eval q( &Static \'int\'  &__CONCAT($dname, &_attach)( &device_t  &self));
	}' unless defined(&USB_ATTACH);
	eval 'sub USB_ATTACH_START {
	    local($dname, $sc, $uaa) = @_;
    	    eval q( &struct __CONCAT($dname, &_softc) *$sc =  &device_get_softc( &self); \'struct usb_attach_arg\' *$uaa =  &device_get_ivars( &self));
	}' unless defined(&USB_ATTACH_START);
	eval 'sub USB_ATTACH_ERROR_RETURN () { &return  &ENXIO;}' unless defined(&USB_ATTACH_ERROR_RETURN);
	eval 'sub USB_ATTACH_SUCCESS_RETURN () { &return 0;}' unless defined(&USB_ATTACH_SUCCESS_RETURN);
	eval 'sub USB_ATTACH_SETUP () { ($sc->{sc_dev}) =  &self;  &device_set_desc_copy( &self,  &devinfo);}' unless defined(&USB_ATTACH_SETUP);
	eval 'sub USB_DETACH {
	    local($dname) = @_;
    	    eval q( &Static \'int\'  &__CONCAT($dname, &_detach)( &device_t  &self));
	}' unless defined(&USB_DETACH);
	eval 'sub USB_DETACH_START {
	    local($dname, $sc) = @_;
    	    eval q( &struct __CONCAT($dname, &_softc) *$sc =  &device_get_softc( &self));
	}' unless defined(&USB_DETACH_START);
	eval 'sub USB_GET_SC_OPEN {
	    local($dname, $unit, $sc) = @_;
    	    eval q($sc =  &devclass_get_softc( &__CONCAT($dname, &_devclass), $unit);  &if ($sc ==  &NULL)  &return ( &ENXIO));
	}' unless defined(&USB_GET_SC_OPEN);
	eval 'sub USB_GET_SC {
	    local($dname, $unit, $sc) = @_;
    	    eval q($sc =  &devclass_get_softc( &__CONCAT($dname, &_devclass), $unit));
	}' unless defined(&USB_GET_SC);
	eval 'sub USB_DO_ATTACH {
	    local($dev, $bdev, $parent, $args, $print, $sub) = @_;
    	    eval q(( &device_probe_and_attach(($bdev)) == 0? ($bdev) : 0));
	}' unless defined(&USB_DO_ATTACH);
	eval 'sub SIMPLEQ_REMOVE_HEAD () { &STAILQ_REMOVE_HEAD;}' unless defined(&SIMPLEQ_REMOVE_HEAD);
	eval 'sub SIMPLEQ_INSERT_HEAD () { &STAILQ_INSERT_HEAD;}' unless defined(&SIMPLEQ_INSERT_HEAD);
	eval 'sub SIMPLEQ_INSERT_TAIL () { &STAILQ_INSERT_TAIL;}' unless defined(&SIMPLEQ_INSERT_TAIL);
	eval 'sub SIMPLEQ_NEXT () { &STAILQ_NEXT;}' unless defined(&SIMPLEQ_NEXT);
	eval 'sub SIMPLEQ_FIRST () { &STAILQ_FIRST;}' unless defined(&SIMPLEQ_FIRST);
	eval 'sub SIMPLEQ_HEAD () { &STAILQ_HEAD;}' unless defined(&SIMPLEQ_HEAD);
	eval 'sub SIMPLEQ_INIT () { &STAILQ_INIT;}' unless defined(&SIMPLEQ_INIT);
	eval 'sub SIMPLEQ_HEAD_INITIALIZER () { &STAILQ_HEAD_INITIALIZER;}' unless defined(&SIMPLEQ_HEAD_INITIALIZER);
	eval 'sub SIMPLEQ_ENTRY () { &STAILQ_ENTRY;}' unless defined(&SIMPLEQ_ENTRY);
	require 'sys/syslog.ph';
	eval 'sub logprintf () { &printf;}' unless defined(&logprintf);
    }
}
1;
