require '_h2ph_pre.ph';

unless(defined(&XM_DEVICEID)) {
    sub XM_DEVICEID () {	0xe0ae20;}
}
unless(defined(&XM_XAQTI_OUI)) {
    sub XM_XAQTI_OUI () {	0xe0ae;}
}
unless(defined(&XM_XMAC_REV)) {
    sub XM_XMAC_REV {
	local($x) = @_;
	eval q(((($x) & 0xe0) >> 5));
    }
}
unless(defined(&XM_XMAC_REV_B2)) {
    sub XM_XMAC_REV_B2 () {	0x;}
}
unless(defined(&XM_XMAC_REV_C1)) {
    sub XM_XMAC_REV_C1 () {	0x1;}
}
unless(defined(&XM_MMUCMD)) {
    sub XM_MMUCMD () {	0x;}
}
unless(defined(&XM_POFF)) {
    sub XM_POFF () {	0x8;}
}
unless(defined(&XM_BURST)) {
    sub XM_BURST () {	0xc;}
}
unless(defined(&XM_VLAN_TAGLEV1)) {
    sub XM_VLAN_TAGLEV1 () {	0x10;}
}
unless(defined(&XM_VLAN_TAGLEV2)) {
    sub XM_VLAN_TAGLEV2 () {	0x14;}
}
unless(defined(&XM_TXCMD)) {
    sub XM_TXCMD () {	0x20;}
}
unless(defined(&XM_TX_RETRYLIMIT)) {
    sub XM_TX_RETRYLIMIT () {	0x24;}
}
unless(defined(&XM_TX_SLOTTIME)) {
    sub XM_TX_SLOTTIME () {	0x28;}
}
unless(defined(&XM_TX_IPG)) {
    sub XM_TX_IPG () {	0x3c;}
}
unless(defined(&XM_RXCMD)) {
    sub XM_RXCMD () {	0x30;}
}
unless(defined(&XM_PHY_ADDR)) {
    sub XM_PHY_ADDR () {	0x34;}
}
unless(defined(&XM_PHY_DATA)) {
    sub XM_PHY_DATA () {	0x38;}
}
unless(defined(&XM_GPIO)) {
    sub XM_GPIO () {	0x40;}
}
unless(defined(&XM_IMR)) {
    sub XM_IMR () {	0x44;}
}
unless(defined(&XM_ISR)) {
    sub XM_ISR () {	0x48;}
}
unless(defined(&XM_HWCFG)) {
    sub XM_HWCFG () {	0x4c;}
}
unless(defined(&XM_TX_LOWAT)) {
    sub XM_TX_LOWAT () {	0x60;}
}
unless(defined(&XM_TX_HIWAT)) {
    sub XM_TX_HIWAT () {	0x62;}
}
unless(defined(&XM_TX_REQTHRESH_LO)) {
    sub XM_TX_REQTHRESH_LO () {	0x64;}
}
unless(defined(&XM_TX_REQTHRESH_HI)) {
    sub XM_TX_REQTHRESH_HI () {	0x66;}
}
unless(defined(&XM_TX_REQTHRESH)) {
    sub XM_TX_REQTHRESH () {	 &XM_TX_REQTHRESH_LO;}
}
unless(defined(&XM_PAUSEDST0)) {
    sub XM_PAUSEDST0 () {	0x68;}
}
unless(defined(&XM_PAUSEDST1)) {
    sub XM_PAUSEDST1 () {	0x6a;}
}
unless(defined(&XM_PAUSEDST2)) {
    sub XM_PAUSEDST2 () {	0x6c;}
}
unless(defined(&XM_CTLPARM_LO)) {
    sub XM_CTLPARM_LO () {	0x70;}
}
unless(defined(&XM_CTLPARM_HI)) {
    sub XM_CTLPARM_HI () {	0x72;}
}
unless(defined(&XM_CTLPARM)) {
    sub XM_CTLPARM () {	 &XM_CTLPARM_LO;}
}
unless(defined(&XM_OPCODE_PAUSE_TIMER)) {
    sub XM_OPCODE_PAUSE_TIMER () {	0x74;}
}
unless(defined(&XM_TXSTAT_LIFO)) {
    sub XM_TXSTAT_LIFO () {	0x78;}
}
unless(defined(&XM_RXFILT_BASE)) {
    sub XM_RXFILT_BASE () {	0x80;}
}
unless(defined(&XM_RXFILT_END)) {
    sub XM_RXFILT_END () {	0x107;}
}
unless(defined(&XM_RXFILT_MAX)) {
    sub XM_RXFILT_MAX () {	16;}
}
unless(defined(&XM_RXFILT_ENTRY)) {
    sub XM_RXFILT_ENTRY {
	local($ent) = @_;
	eval q(( &XM_RXFILT_BASE + (($ent * 8))));
    }
}
unless(defined(&XM_PAR0)) {
    sub XM_PAR0 () {	0x108;}
}
unless(defined(&XM_PAR1)) {
    sub XM_PAR1 () {	0x10a;}
}
unless(defined(&XM_PAR2)) {
    sub XM_PAR2 () {	0x10c;}
}
unless(defined(&XM_MAR0)) {
    sub XM_MAR0 () {	0x110;}
}
unless(defined(&XM_MAR1)) {
    sub XM_MAR1 () {	0x112;}
}
unless(defined(&XM_MAR2)) {
    sub XM_MAR2 () {	0x114;}
}
unless(defined(&XM_MAR3)) {
    sub XM_MAR3 () {	0x116;}
}
unless(defined(&XM_RX_LOWAT)) {
    sub XM_RX_LOWAT () {	0x118;}
}
unless(defined(&XM_RX_HIWAT)) {
    sub XM_RX_HIWAT () {	0x11a;}
}
unless(defined(&XM_RX_REQTHRESH_LO)) {
    sub XM_RX_REQTHRESH_LO () {	0x11c;}
}
unless(defined(&XM_RX_REQTHRESH_HI)) {
    sub XM_RX_REQTHRESH_HI () {	0x11e;}
}
unless(defined(&XM_RX_REQTHRESH)) {
    sub XM_RX_REQTHRESH () {	 &XM_RX_REQTHRESH_LO;}
}
unless(defined(&XM_DEVID_LO)) {
    sub XM_DEVID_LO () {	0x120;}
}
unless(defined(&XM_DEVID_HI)) {
    sub XM_DEVID_HI () {	0x122;}
}
unless(defined(&XM_DEVID)) {
    sub XM_DEVID () {	 &XM_DEVID_LO;}
}
unless(defined(&XM_MODE_LO)) {
    sub XM_MODE_LO () {	0x124;}
}
unless(defined(&XM_MODE_HI)) {
    sub XM_MODE_HI () {	0x126;}
}
unless(defined(&XM_MODE)) {
    sub XM_MODE () {	 &XM_MODE_LO;}
}
unless(defined(&XM_LASTSRC0)) {
    sub XM_LASTSRC0 () {	0x128;}
}
unless(defined(&XM_LASTSRC1)) {
    sub XM_LASTSRC1 () {	0x12a;}
}
unless(defined(&XM_LASTSRC2)) {
    sub XM_LASTSRC2 () {	0x12c;}
}
unless(defined(&XM_TSTAMP_READ)) {
    sub XM_TSTAMP_READ () {	0x130;}
}
unless(defined(&XM_TSTAMP_LOAD)) {
    sub XM_TSTAMP_LOAD () {	0x134;}
}
unless(defined(&XM_STATS_CMD)) {
    sub XM_STATS_CMD () {	0x200;}
}
unless(defined(&XM_RXCNT_EVENT_LO)) {
    sub XM_RXCNT_EVENT_LO () {	0x204;}
}
unless(defined(&XM_RXCNT_EVENT_HI)) {
    sub XM_RXCNT_EVENT_HI () {	0x206;}
}
unless(defined(&XM_RXCNT_EVENT)) {
    sub XM_RXCNT_EVENT () {	 &XM_RXCNT_EVENT_LO;}
}
unless(defined(&XM_TXCNT_EVENT_LO)) {
    sub XM_TXCNT_EVENT_LO () {	0x208;}
}
unless(defined(&XM_TXCNT_EVENT_HI)) {
    sub XM_TXCNT_EVENT_HI () {	0x20a;}
}
unless(defined(&XM_TXCNT_EVENT)) {
    sub XM_TXCNT_EVENT () {	 &XM_TXCNT_EVENT_LO;}
}
unless(defined(&XM_RXCNT_EVMASK_LO)) {
    sub XM_RXCNT_EVMASK_LO () {	0x20c;}
}
unless(defined(&XM_RXCNT_EVMASK_HI)) {
    sub XM_RXCNT_EVMASK_HI () {	0x20e;}
}
unless(defined(&XM_RXCNT_EVMASK)) {
    sub XM_RXCNT_EVMASK () {	 &XM_RXCNT_EVMASK_LO;}
}
unless(defined(&XM_TXCNT_EVMASK_LO)) {
    sub XM_TXCNT_EVMASK_LO () {	0x210;}
}
unless(defined(&XM_TXCNT_EVMASK_HI)) {
    sub XM_TXCNT_EVMASK_HI () {	0x212;}
}
unless(defined(&XM_TXCNT_EVMASK)) {
    sub XM_TXCNT_EVMASK () {	 &XM_TXCNT_EVMASK_LO;}
}
unless(defined(&XM_STATCMD_CLR_TX)) {
    sub XM_STATCMD_CLR_TX () {	0x1;}
}
unless(defined(&XM_STATCMD_CLR_RX)) {
    sub XM_STATCMD_CLR_RX () {	0x2;}
}
unless(defined(&XM_STATCMD_COPY_TX)) {
    sub XM_STATCMD_COPY_TX () {	0x4;}
}
unless(defined(&XM_STATCMD_COPY_RX)) {
    sub XM_STATCMD_COPY_RX () {	0x8;}
}
unless(defined(&XM_STATCMD_SNAP_TX)) {
    sub XM_STATCMD_SNAP_TX () {	0x10;}
}
unless(defined(&XM_STATCMD_SNAP_RX)) {
    sub XM_STATCMD_SNAP_RX () {	0x20;}
}
unless(defined(&XM_TXSTATS_PKTSOK)) {
    sub XM_TXSTATS_PKTSOK () {	0x280;}
}
unless(defined(&XM_TXSTATS_BYTESOK_HI)) {
    sub XM_TXSTATS_BYTESOK_HI () {	0x284;}
}
unless(defined(&XM_TXSTATS_BYTESOK_LO)) {
    sub XM_TXSTATS_BYTESOK_LO () {	0x288;}
}
unless(defined(&XM_TXSTATS_BCASTSOK)) {
    sub XM_TXSTATS_BCASTSOK () {	0x28c;}
}
unless(defined(&XM_TXSTATS_MCASTSOK)) {
    sub XM_TXSTATS_MCASTSOK () {	0x290;}
}
unless(defined(&XM_TXSTATS_UCASTSOK)) {
    sub XM_TXSTATS_UCASTSOK () {	0x294;}
}
unless(defined(&XM_TXSTATS_GIANTS)) {
    sub XM_TXSTATS_GIANTS () {	0x298;}
}
unless(defined(&XM_TXSTATS_BURSTCNT)) {
    sub XM_TXSTATS_BURSTCNT () {	0x29c;}
}
unless(defined(&XM_TXSTATS_PAUSEPKTS)) {
    sub XM_TXSTATS_PAUSEPKTS () {	0x2a0;}
}
unless(defined(&XM_TXSTATS_MACCTLPKTS)) {
    sub XM_TXSTATS_MACCTLPKTS () {	0x2a4;}
}
unless(defined(&XM_TXSTATS_SINGLECOLS)) {
    sub XM_TXSTATS_SINGLECOLS () {	0x2a8;}
}
unless(defined(&XM_TXSTATS_MULTICOLS)) {
    sub XM_TXSTATS_MULTICOLS () {	0x2ac;}
}
unless(defined(&XM_TXSTATS_EXCESSCOLS)) {
    sub XM_TXSTATS_EXCESSCOLS () {	0x2b0;}
}
unless(defined(&XM_TXSTATS_LATECOLS)) {
    sub XM_TXSTATS_LATECOLS () {	0x2b4;}
}
unless(defined(&XM_TXSTATS_DEFER)) {
    sub XM_TXSTATS_DEFER () {	0x2b8;}
}
unless(defined(&XM_TXSTATS_EXCESSDEFER)) {
    sub XM_TXSTATS_EXCESSDEFER () {	0x2bc;}
}
unless(defined(&XM_TXSTATS_UNDERRUN)) {
    sub XM_TXSTATS_UNDERRUN () {	0x2c0;}
}
unless(defined(&XM_TXSTATS_CARRIERSENSE)) {
    sub XM_TXSTATS_CARRIERSENSE () {	0x2c4;}
}
unless(defined(&XM_TXSTATS_UTILIZATION)) {
    sub XM_TXSTATS_UTILIZATION () {	0x2c8;}
}
unless(defined(&XM_TXSTATS_64)) {
    sub XM_TXSTATS_64 () {	0x2d0;}
}
unless(defined(&XM_TXSTATS_65_127)) {
    sub XM_TXSTATS_65_127 () {	0x2d4;}
}
unless(defined(&XM_TXSTATS_128_255)) {
    sub XM_TXSTATS_128_255 () {	0x2d8;}
}
unless(defined(&XM_TXSTATS_256_511)) {
    sub XM_TXSTATS_256_511 () {	0x2dc;}
}
unless(defined(&XM_TXSTATS_512_1023)) {
    sub XM_TXSTATS_512_1023 () {	0x2e0;}
}
unless(defined(&XM_TXSTATS_1024_MAX)) {
    sub XM_TXSTATS_1024_MAX () {	0x2e4;}
}
unless(defined(&XM_RXSTATS_PKTSOK)) {
    sub XM_RXSTATS_PKTSOK () {	0x300;}
}
unless(defined(&XM_RXSTATS_BYTESOK_HI)) {
    sub XM_RXSTATS_BYTESOK_HI () {	0x304;}
}
unless(defined(&XM_RXSTATS_BYTESOK_LO)) {
    sub XM_RXSTATS_BYTESOK_LO () {	0x308;}
}
unless(defined(&XM_RXSTATS_BCASTSOK)) {
    sub XM_RXSTATS_BCASTSOK () {	0x30c;}
}
unless(defined(&XM_RXSTATS_MCASTSOK)) {
    sub XM_RXSTATS_MCASTSOK () {	0x310;}
}
unless(defined(&XM_RXSTATS_UCASTSOK)) {
    sub XM_RXSTATS_UCASTSOK () {	0x314;}
}
unless(defined(&XM_RXSTATS_PAUSEPKTS)) {
    sub XM_RXSTATS_PAUSEPKTS () {	0x318;}
}
unless(defined(&XM_RXSTATS_MACCTLPKTS)) {
    sub XM_RXSTATS_MACCTLPKTS () {	0x31c;}
}
unless(defined(&XM_RXSTATS_BADPAUSEPKTS)) {
    sub XM_RXSTATS_BADPAUSEPKTS () {	0x320;}
}
unless(defined(&XM_RXSTATS_BADMACCTLPKTS)) {
    sub XM_RXSTATS_BADMACCTLPKTS () {	0x324;}
}
unless(defined(&XM_RXSTATS_BURSTCNT)) {
    sub XM_RXSTATS_BURSTCNT () {	0x328;}
}
unless(defined(&XM_RXSTATS_MISSEDPKTS)) {
    sub XM_RXSTATS_MISSEDPKTS () {	0x32c;}
}
unless(defined(&XM_RXSTATS_FRAMEERRS)) {
    sub XM_RXSTATS_FRAMEERRS () {	0x330;}
}
unless(defined(&XM_RXSTATS_OVERRUN)) {
    sub XM_RXSTATS_OVERRUN () {	0x334;}
}
unless(defined(&XM_RXSTATS_JABBER)) {
    sub XM_RXSTATS_JABBER () {	0x338;}
}
unless(defined(&XM_RXSTATS_CARRLOSS)) {
    sub XM_RXSTATS_CARRLOSS () {	0x33c;}
}
unless(defined(&XM_RXSTATS_INRNGLENERR)) {
    sub XM_RXSTATS_INRNGLENERR () {	0x340;}
}
unless(defined(&XM_RXSTATS_SYMERR)) {
    sub XM_RXSTATS_SYMERR () {	0x344;}
}
unless(defined(&XM_RXSTATS_SHORTEVENT)) {
    sub XM_RXSTATS_SHORTEVENT () {	0x348;}
}
unless(defined(&XM_RXSTATS_RUNTS)) {
    sub XM_RXSTATS_RUNTS () {	0x34c;}
}
unless(defined(&XM_RXSTATS_GIANTS)) {
    sub XM_RXSTATS_GIANTS () {	0x350;}
}
unless(defined(&XM_RXSTATS_CRCERRS)) {
    sub XM_RXSTATS_CRCERRS () {	0x354;}
}
unless(defined(&XM_RXSTATS_CEXTERRS)) {
    sub XM_RXSTATS_CEXTERRS () {	0x35c;}
}
unless(defined(&XM_RXSTATS_UTILIZATION)) {
    sub XM_RXSTATS_UTILIZATION () {	0x360;}
}
unless(defined(&XM_RXSTATS_64)) {
    sub XM_RXSTATS_64 () {	0x368;}
}
unless(defined(&XM_RXSTATS_65_127)) {
    sub XM_RXSTATS_65_127 () {	0x36c;}
}
unless(defined(&XM_RXSTATS_128_255)) {
    sub XM_RXSTATS_128_255 () {	0x370;}
}
unless(defined(&XM_RXSTATS_256_511)) {
    sub XM_RXSTATS_256_511 () {	0x374;}
}
unless(defined(&XM_RXSTATS_512_1023)) {
    sub XM_RXSTATS_512_1023 () {	0x378;}
}
unless(defined(&XM_RXSTATS_1024_MAX)) {
    sub XM_RXSTATS_1024_MAX () {	0x37c;}
}
unless(defined(&XM_MMUCMD_TX_ENB)) {
    sub XM_MMUCMD_TX_ENB () {	0x1;}
}
unless(defined(&XM_MMUCMD_RX_ENB)) {
    sub XM_MMUCMD_RX_ENB () {	0x2;}
}
unless(defined(&XM_MMUCMD_GMIILOOP)) {
    sub XM_MMUCMD_GMIILOOP () {	0x4;}
}
unless(defined(&XM_MMUCMD_RATECTL)) {
    sub XM_MMUCMD_RATECTL () {	0x8;}
}
unless(defined(&XM_MMUCMD_GMIIFDX)) {
    sub XM_MMUCMD_GMIIFDX () {	0x10;}
}
unless(defined(&XM_MMUCMD_NO_MGMT_PRMB)) {
    sub XM_MMUCMD_NO_MGMT_PRMB () {	0x20;}
}
unless(defined(&XM_MMUCMD_SIMCOL)) {
    sub XM_MMUCMD_SIMCOL () {	0x40;}
}
unless(defined(&XM_MMUCMD_FORCETX)) {
    sub XM_MMUCMD_FORCETX () {	0x80;}
}
unless(defined(&XM_MMUCMD_LOOPENB)) {
    sub XM_MMUCMD_LOOPENB () {	0x200;}
}
unless(defined(&XM_MMUCMD_IGNPAUSE)) {
    sub XM_MMUCMD_IGNPAUSE () {	0x400;}
}
unless(defined(&XM_MMUCMD_PHYBUSY)) {
    sub XM_MMUCMD_PHYBUSY () {	0x800;}
}
unless(defined(&XM_MMUCMD_PHYDATARDY)) {
    sub XM_MMUCMD_PHYDATARDY () {	0x1000;}
}
unless(defined(&XM_TXCMD_AUTOPAD)) {
    sub XM_TXCMD_AUTOPAD () {	0x1;}
}
unless(defined(&XM_TXCMD_NOCRC)) {
    sub XM_TXCMD_NOCRC () {	0x2;}
}
unless(defined(&XM_TXCMD_NOPREAMBLE)) {
    sub XM_TXCMD_NOPREAMBLE () {	0x4;}
}
unless(defined(&XM_TXCMD_NOGIGAMODE)) {
    sub XM_TXCMD_NOGIGAMODE () {	0x8;}
}
unless(defined(&XM_TXCMD_SAMPLELINE)) {
    sub XM_TXCMD_SAMPLELINE () {	0x10;}
}
unless(defined(&XM_TXCMD_ENCBYPASS)) {
    sub XM_TXCMD_ENCBYPASS () {	0x20;}
}
unless(defined(&XM_TXCMD_XMITBK2BK)) {
    sub XM_TXCMD_XMITBK2BK () {	0x40;}
}
unless(defined(&XM_TXCMD_FAIRSHARE)) {
    sub XM_TXCMD_FAIRSHARE () {	0x80;}
}
unless(defined(&XM_RXCMD_DISABLE_CEXT)) {
    sub XM_RXCMD_DISABLE_CEXT () {	0x1;}
}
unless(defined(&XM_RXCMD_STRIPPAD)) {
    sub XM_RXCMD_STRIPPAD () {	0x2;}
}
unless(defined(&XM_RXCMD_SAMPLELINE)) {
    sub XM_RXCMD_SAMPLELINE () {	0x4;}
}
unless(defined(&XM_RXCMD_SELFRX)) {
    sub XM_RXCMD_SELFRX () {	0x8;}
}
unless(defined(&XM_RXCMD_STRIPFCS)) {
    sub XM_RXCMD_STRIPFCS () {	0x10;}
}
unless(defined(&XM_RXCMD_TRANSPARENT)) {
    sub XM_RXCMD_TRANSPARENT () {	0x20;}
}
unless(defined(&XM_RXCMD_IPGCAPTURE)) {
    sub XM_RXCMD_IPGCAPTURE () {	0x40;}
}
unless(defined(&XM_RXCMD_BIGPKTOK)) {
    sub XM_RXCMD_BIGPKTOK () {	0x80;}
}
unless(defined(&XM_RXCMD_LENERROK)) {
    sub XM_RXCMD_LENERROK () {	0x100;}
}
unless(defined(&XM_GPIO_GP0_SET)) {
    sub XM_GPIO_GP0_SET () {	0x1;}
}
unless(defined(&XM_GPIO_RESETSTATS)) {
    sub XM_GPIO_RESETSTATS () {	0x4;}
}
unless(defined(&XM_GPIO_RESETMAC)) {
    sub XM_GPIO_RESETMAC () {	0x8;}
}
unless(defined(&XM_GPIO_FORCEINT)) {
    sub XM_GPIO_FORCEINT () {	0x20;}
}
unless(defined(&XM_GPIO_ANEGINPROG)) {
    sub XM_GPIO_ANEGINPROG () {	0x40;}
}
unless(defined(&XM_IMR_RX_EOF)) {
    sub XM_IMR_RX_EOF () {	0x1;}
}
unless(defined(&XM_IMR_TX_EOF)) {
    sub XM_IMR_TX_EOF () {	0x2;}
}
unless(defined(&XM_IMR_TX_UNDERRUN)) {
    sub XM_IMR_TX_UNDERRUN () {	0x4;}
}
unless(defined(&XM_IMR_RX_OVERRUN)) {
    sub XM_IMR_RX_OVERRUN () {	0x8;}
}
unless(defined(&XM_IMR_TX_STATS_OFLOW)) {
    sub XM_IMR_TX_STATS_OFLOW () {	0x10;}
}
unless(defined(&XM_IMR_RX_STATS_OFLOW)) {
    sub XM_IMR_RX_STATS_OFLOW () {	0x20;}
}
unless(defined(&XM_IMR_TSTAMP_OFLOW)) {
    sub XM_IMR_TSTAMP_OFLOW () {	0x40;}
}
unless(defined(&XM_IMR_AUTONEG_DONE)) {
    sub XM_IMR_AUTONEG_DONE () {	0x80;}
}
unless(defined(&XM_IMR_NEXTPAGE_RDY)) {
    sub XM_IMR_NEXTPAGE_RDY () {	0x100;}
}
unless(defined(&XM_IMR_PAGE_RECEIVED)) {
    sub XM_IMR_PAGE_RECEIVED () {	0x200;}
}
unless(defined(&XM_IMR_LP_REQCFG)) {
    sub XM_IMR_LP_REQCFG () {	0x400;}
}
unless(defined(&XM_IMR_GP0_SET)) {
    sub XM_IMR_GP0_SET () {	0x800;}
}
unless(defined(&XM_IMR_FORCEINTR)) {
    sub XM_IMR_FORCEINTR () {	0x1000;}
}
unless(defined(&XM_IMR_TX_ABORT)) {
    sub XM_IMR_TX_ABORT () {	0x2000;}
}
unless(defined(&XM_IMR_LINKEVENT)) {
    sub XM_IMR_LINKEVENT () {	0x4000;}
}
unless(defined(&XM_INTRS)) {
    sub XM_INTRS () {	(~( &XM_IMR_GP0_SET| &XM_IMR_AUTONEG_DONE| &XM_IMR_TX_UNDERRUN));}
}
unless(defined(&XM_ISR_RX_EOF)) {
    sub XM_ISR_RX_EOF () {	0x1;}
}
unless(defined(&XM_ISR_TX_EOF)) {
    sub XM_ISR_TX_EOF () {	0x2;}
}
unless(defined(&XM_ISR_TX_UNDERRUN)) {
    sub XM_ISR_TX_UNDERRUN () {	0x4;}
}
unless(defined(&XM_ISR_RX_OVERRUN)) {
    sub XM_ISR_RX_OVERRUN () {	0x8;}
}
unless(defined(&XM_ISR_TX_STATS_OFLOW)) {
    sub XM_ISR_TX_STATS_OFLOW () {	0x10;}
}
unless(defined(&XM_ISR_RX_STATS_OFLOW)) {
    sub XM_ISR_RX_STATS_OFLOW () {	0x20;}
}
unless(defined(&XM_ISR_TSTAMP_OFLOW)) {
    sub XM_ISR_TSTAMP_OFLOW () {	0x40;}
}
unless(defined(&XM_ISR_AUTONEG_DONE)) {
    sub XM_ISR_AUTONEG_DONE () {	0x80;}
}
unless(defined(&XM_ISR_NEXTPAGE_RDY)) {
    sub XM_ISR_NEXTPAGE_RDY () {	0x100;}
}
unless(defined(&XM_ISR_PAGE_RECEIVED)) {
    sub XM_ISR_PAGE_RECEIVED () {	0x200;}
}
unless(defined(&XM_ISR_LP_REQCFG)) {
    sub XM_ISR_LP_REQCFG () {	0x400;}
}
unless(defined(&XM_ISR_GP0_SET)) {
    sub XM_ISR_GP0_SET () {	0x800;}
}
unless(defined(&XM_ISR_FORCEINTR)) {
    sub XM_ISR_FORCEINTR () {	0x1000;}
}
unless(defined(&XM_ISR_TX_ABORT)) {
    sub XM_ISR_TX_ABORT () {	0x2000;}
}
unless(defined(&XM_ISR_LINKEVENT)) {
    sub XM_ISR_LINKEVENT () {	0x4000;}
}
unless(defined(&XM_HWCFG_GENEOP)) {
    sub XM_HWCFG_GENEOP () {	0x8;}
}
unless(defined(&XM_HWCFG_SIGSTATCKH)) {
    sub XM_HWCFG_SIGSTATCKH () {	0x4;}
}
unless(defined(&XM_HWCFG_GMIIMODE)) {
    sub XM_HWCFG_GMIIMODE () {	0x1;}
}
unless(defined(&XM_MODE_FLUSH_RXFIFO)) {
    sub XM_MODE_FLUSH_RXFIFO () {	0x1;}
}
unless(defined(&XM_MODE_FLUSH_TXFIFO)) {
    sub XM_MODE_FLUSH_TXFIFO () {	0x2;}
}
unless(defined(&XM_MODE_BIGENDIAN)) {
    sub XM_MODE_BIGENDIAN () {	0x4;}
}
unless(defined(&XM_MODE_RX_PROMISC)) {
    sub XM_MODE_RX_PROMISC () {	0x8;}
}
unless(defined(&XM_MODE_RX_NOBROAD)) {
    sub XM_MODE_RX_NOBROAD () {	0x10;}
}
unless(defined(&XM_MODE_RX_NOMULTI)) {
    sub XM_MODE_RX_NOMULTI () {	0x20;}
}
unless(defined(&XM_MODE_RX_NOUNI)) {
    sub XM_MODE_RX_NOUNI () {	0x40;}
}
unless(defined(&XM_MODE_RX_BADFRAMES)) {
    sub XM_MODE_RX_BADFRAMES () {	0x80;}
}
unless(defined(&XM_MODE_RX_CRCERRS)) {
    sub XM_MODE_RX_CRCERRS () {	0x100;}
}
unless(defined(&XM_MODE_RX_GIANTS)) {
    sub XM_MODE_RX_GIANTS () {	0x200;}
}
unless(defined(&XM_MODE_RX_INRANGELEN)) {
    sub XM_MODE_RX_INRANGELEN () {	0x400;}
}
unless(defined(&XM_MODE_RX_RUNTS)) {
    sub XM_MODE_RX_RUNTS () {	0x800;}
}
unless(defined(&XM_MODE_RX_MACCTL)) {
    sub XM_MODE_RX_MACCTL () {	0x1000;}
}
unless(defined(&XM_MODE_RX_USE_PERFECT)) {
    sub XM_MODE_RX_USE_PERFECT () {	0x2000;}
}
unless(defined(&XM_MODE_RX_USE_STATION)) {
    sub XM_MODE_RX_USE_STATION () {	0x4000;}
}
unless(defined(&XM_MODE_RX_USE_HASH)) {
    sub XM_MODE_RX_USE_HASH () {	0x8000;}
}
unless(defined(&XM_MODE_RX_ADDRPAIR)) {
    sub XM_MODE_RX_ADDRPAIR () {	0x10000;}
}
unless(defined(&XM_MODE_PAUSEONHI)) {
    sub XM_MODE_PAUSEONHI () {	0x20000;}
}
unless(defined(&XM_MODE_PAUSEONLO)) {
    sub XM_MODE_PAUSEONLO () {	0x40000;}
}
unless(defined(&XM_MODE_TIMESTAMP)) {
    sub XM_MODE_TIMESTAMP () {	0x80000;}
}
unless(defined(&XM_MODE_SENDPAUSE)) {
    sub XM_MODE_SENDPAUSE () {	0x100000;}
}
unless(defined(&XM_MODE_SENDCONTINUOUS)) {
    sub XM_MODE_SENDCONTINUOUS () {	0x200000;}
}
unless(defined(&XM_MODE_LE_STATUSWORD)) {
    sub XM_MODE_LE_STATUSWORD () {	0x400000;}
}
unless(defined(&XM_MODE_AUTOFIFOPAUSE)) {
    sub XM_MODE_AUTOFIFOPAUSE () {	0x800000;}
}
unless(defined(&XM_MODE_EXPAUSEGEN)) {
    sub XM_MODE_EXPAUSEGEN () {	0x2000000;}
}
unless(defined(&XM_MODE_RX_INVERSE)) {
    sub XM_MODE_RX_INVERSE () {	0x4000000;}
}
unless(defined(&XM_RXSTAT_MACCTL)) {
    sub XM_RXSTAT_MACCTL () {	0x1;}
}
unless(defined(&XM_RXSTAT_ERRFRAME)) {
    sub XM_RXSTAT_ERRFRAME () {	0x2;}
}
unless(defined(&XM_RXSTAT_CRCERR)) {
    sub XM_RXSTAT_CRCERR () {	0x4;}
}
unless(defined(&XM_RXSTAT_GIANT)) {
    sub XM_RXSTAT_GIANT () {	0x8;}
}
unless(defined(&XM_RXSTAT_RUNT)) {
    sub XM_RXSTAT_RUNT () {	0x10;}
}
unless(defined(&XM_RXSTAT_FRAMEERR)) {
    sub XM_RXSTAT_FRAMEERR () {	0x20;}
}
unless(defined(&XM_RXSTAT_INRANGEERR)) {
    sub XM_RXSTAT_INRANGEERR () {	0x40;}
}
unless(defined(&XM_RXSTAT_CARRIERERR)) {
    sub XM_RXSTAT_CARRIERERR () {	0x80;}
}
unless(defined(&XM_RXSTAT_COLLERR)) {
    sub XM_RXSTAT_COLLERR () {	0x100;}
}
unless(defined(&XM_RXSTAT_802_3)) {
    sub XM_RXSTAT_802_3 () {	0x200;}
}
unless(defined(&XM_RXSTAT_CARREXTERR)) {
    sub XM_RXSTAT_CARREXTERR () {	0x400;}
}
unless(defined(&XM_RXSTAT_BURSTMODE)) {
    sub XM_RXSTAT_BURSTMODE () {	0x800;}
}
unless(defined(&XM_RXSTAT_UNICAST)) {
    sub XM_RXSTAT_UNICAST () {	0x2000;}
}
unless(defined(&XM_RXSTAT_MULTICAST)) {
    sub XM_RXSTAT_MULTICAST () {	0x4000;}
}
unless(defined(&XM_RXSTAT_BROADCAST)) {
    sub XM_RXSTAT_BROADCAST () {	0x8000;}
}
unless(defined(&XM_RXSTAT_VLAN_LEV1)) {
    sub XM_RXSTAT_VLAN_LEV1 () {	0x10000;}
}
unless(defined(&XM_RXSTAT_VLAN_LEV2)) {
    sub XM_RXSTAT_VLAN_LEV2 () {	0x20000;}
}
unless(defined(&XM_RXSTAT_LEN)) {
    sub XM_RXSTAT_LEN () {	0xfffc0000;}
}
unless(defined(&XM_PHY_BMCR)) {
    sub XM_PHY_BMCR () {	0x;}
}
unless(defined(&XM_PHY_BMSR)) {
    sub XM_PHY_BMSR () {	0x1;}
}
unless(defined(&XM_PHY_VENID)) {
    sub XM_PHY_VENID () {	0x2;}
}
unless(defined(&XM_PHY_DEVID)) {
    sub XM_PHY_DEVID () {	0x3;}
}
unless(defined(&XM_PHY_ANAR)) {
    sub XM_PHY_ANAR () {	0x4;}
}
unless(defined(&XM_PHY_LPAR)) {
    sub XM_PHY_LPAR () {	0x5;}
}
unless(defined(&XM_PHY_ANEXP)) {
    sub XM_PHY_ANEXP () {	0x6;}
}
unless(defined(&XM_PHY_NEXTP)) {
    sub XM_PHY_NEXTP () {	0x7;}
}
unless(defined(&XM_PHY_LPNEXTP)) {
    sub XM_PHY_LPNEXTP () {	0x8;}
}
unless(defined(&XM_PHY_EXTSTS)) {
    sub XM_PHY_EXTSTS () {	0xf;}
}
unless(defined(&XM_PHY_RESAB)) {
    sub XM_PHY_RESAB () {	0x10;}
}
unless(defined(&XM_BMCR_DUPLEX)) {
    sub XM_BMCR_DUPLEX () {	0x100;}
}
unless(defined(&XM_BMCR_RENEGOTIATE)) {
    sub XM_BMCR_RENEGOTIATE () {	0x200;}
}
unless(defined(&XM_BMCR_AUTONEGENBL)) {
    sub XM_BMCR_AUTONEGENBL () {	0x1000;}
}
unless(defined(&XM_BMCR_LOOPBACK)) {
    sub XM_BMCR_LOOPBACK () {	0x4000;}
}
unless(defined(&XM_BMCR_RESET)) {
    sub XM_BMCR_RESET () {	0x8000;}
}
unless(defined(&XM_BMSR_EXTCAP)) {
    sub XM_BMSR_EXTCAP () {	0x1;}
}
unless(defined(&XM_BMSR_LINKSTAT)) {
    sub XM_BMSR_LINKSTAT () {	0x4;}
}
unless(defined(&XM_BMSR_AUTONEGABLE)) {
    sub XM_BMSR_AUTONEGABLE () {	0x8;}
}
unless(defined(&XM_BMSR_REMFAULT)) {
    sub XM_BMSR_REMFAULT () {	0x10;}
}
unless(defined(&XM_BMSR_AUTONEGDONE)) {
    sub XM_BMSR_AUTONEGDONE () {	0x20;}
}
unless(defined(&XM_BMSR_EXTSTAT)) {
    sub XM_BMSR_EXTSTAT () {	0x100;}
}
unless(defined(&XM_VENID_XAQTI)) {
    sub XM_VENID_XAQTI () {	0xd14c;}
}
unless(defined(&XM_DEVID_XMAC)) {
    sub XM_DEVID_XMAC () {	0x2;}
}
unless(defined(&XM_ANAR_FULLDUPLEX)) {
    sub XM_ANAR_FULLDUPLEX () {	0x20;}
}
unless(defined(&XM_ANAR_HALFDUPLEX)) {
    sub XM_ANAR_HALFDUPLEX () {	0x40;}
}
unless(defined(&XM_ANAR_PAUSEBITS)) {
    sub XM_ANAR_PAUSEBITS () {	0x180;}
}
unless(defined(&XM_ANAR_REMFAULTBITS)) {
    sub XM_ANAR_REMFAULTBITS () {	0x1800;}
}
unless(defined(&XM_ANAR_ACK)) {
    sub XM_ANAR_ACK () {	0x4000;}
}
unless(defined(&XM_ANAR_NEXTPAGE)) {
    sub XM_ANAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&XM_LPAR_FULLDUPLEX)) {
    sub XM_LPAR_FULLDUPLEX () {	0x20;}
}
unless(defined(&XM_LPAR_HALFDUPLEX)) {
    sub XM_LPAR_HALFDUPLEX () {	0x40;}
}
unless(defined(&XM_LPAR_PAUSEBITS)) {
    sub XM_LPAR_PAUSEBITS () {	0x180;}
}
unless(defined(&XM_LPAR_REMFAULTBITS)) {
    sub XM_LPAR_REMFAULTBITS () {	0x1800;}
}
unless(defined(&XM_LPAR_ACK)) {
    sub XM_LPAR_ACK () {	0x4000;}
}
unless(defined(&XM_LPAR_NEXTPAGE)) {
    sub XM_LPAR_NEXTPAGE () {	0x8000;}
}
unless(defined(&XM_PAUSE_NOPAUSE)) {
    sub XM_PAUSE_NOPAUSE () {	0x;}
}
unless(defined(&XM_PAUSE_SYMPAUSE)) {
    sub XM_PAUSE_SYMPAUSE () {	0x80;}
}
unless(defined(&XM_PAUSE_ASYMPAUSE)) {
    sub XM_PAUSE_ASYMPAUSE () {	0x100;}
}
unless(defined(&XM_PAUSE_BOTH)) {
    sub XM_PAUSE_BOTH () {	0x180;}
}
unless(defined(&XM_REMFAULT_LINKOK)) {
    sub XM_REMFAULT_LINKOK () {	0x;}
}
unless(defined(&XM_REMFAULT_LINKFAIL)) {
    sub XM_REMFAULT_LINKFAIL () {	0x800;}
}
unless(defined(&XM_REMFAULT_OFFLINE)) {
    sub XM_REMFAULT_OFFLINE () {	0x1000;}
}
unless(defined(&XM_REMFAULT_ANEGERR)) {
    sub XM_REMFAULT_ANEGERR () {	0x1800;}
}
unless(defined(&XM_ANEXP_GOTPAGE)) {
    sub XM_ANEXP_GOTPAGE () {	0x2;}
}
unless(defined(&XM_ANEXP_NEXTPAGE_SELF)) {
    sub XM_ANEXP_NEXTPAGE_SELF () {	0x4;}
}
unless(defined(&XM_ANEXP_NEXTPAGE_LP)) {
    sub XM_ANEXP_NEXTPAGE_LP () {	0x8;}
}
unless(defined(&XM_NEXTP_MESSAGE)) {
    sub XM_NEXTP_MESSAGE () {	0x7ff;}
}
unless(defined(&XM_NEXTP_TOGGLE)) {
    sub XM_NEXTP_TOGGLE () {	0x800;}
}
unless(defined(&XM_NEXTP_ACK2)) {
    sub XM_NEXTP_ACK2 () {	0x1000;}
}
unless(defined(&XM_NEXTP_MPAGE)) {
    sub XM_NEXTP_MPAGE () {	0x2000;}
}
unless(defined(&XM_NEXTP_ACK1)) {
    sub XM_NEXTP_ACK1 () {	0x4000;}
}
unless(defined(&XM_NEXTP_NPAGE)) {
    sub XM_NEXTP_NPAGE () {	0x8000;}
}
unless(defined(&XM_LPNEXTP_MESSAGE)) {
    sub XM_LPNEXTP_MESSAGE () {	0x7ff;}
}
unless(defined(&XM_LPNEXTP_TOGGLE)) {
    sub XM_LPNEXTP_TOGGLE () {	0x800;}
}
unless(defined(&XM_LPNEXTP_ACK2)) {
    sub XM_LPNEXTP_ACK2 () {	0x1000;}
}
unless(defined(&XM_LPNEXTP_MPAGE)) {
    sub XM_LPNEXTP_MPAGE () {	0x2000;}
}
unless(defined(&XM_LPNEXTP_ACK1)) {
    sub XM_LPNEXTP_ACK1 () {	0x4000;}
}
unless(defined(&XM_LPNEXTP_NPAGE)) {
    sub XM_LPNEXTP_NPAGE () {	0x8000;}
}
unless(defined(&XM_EXTSTS_HALFDUPLEX)) {
    sub XM_EXTSTS_HALFDUPLEX () {	0x4000;}
}
unless(defined(&XM_EXTSTS_FULLDUPLEX)) {
    sub XM_EXTSTS_FULLDUPLEX () {	0x8000;}
}
unless(defined(&XM_RESAB_PAUSEMISMATCH)) {
    sub XM_RESAB_PAUSEMISMATCH () {	0x8;}
}
unless(defined(&XM_RESAB_ABLMISMATCH)) {
    sub XM_RESAB_ABLMISMATCH () {	0x10;}
}
unless(defined(&XM_RESAB_FDMODESEL)) {
    sub XM_RESAB_FDMODESEL () {	0x20;}
}
unless(defined(&XM_RESAB_HDMODESEL)) {
    sub XM_RESAB_HDMODESEL () {	0x40;}
}
unless(defined(&XM_RESAB_PAUSEBITS)) {
    sub XM_RESAB_PAUSEBITS () {	0x180;}
}
1;
