require '_h2ph_pre.ph';

unless(defined(&PPB_REG_BASE0)) {
    sub PPB_REG_BASE0 () {	0x10;}
}
unless(defined(&PPB_REG_BASE1)) {
    sub PPB_REG_BASE1 () {	0x14;}
}
unless(defined(&PPB_REG_BUSINFO)) {
    sub PPB_REG_BUSINFO () {	0x18;}
}
unless(defined(&PPB_REG_IOSTATUS)) {
    sub PPB_REG_IOSTATUS () {	0x1c;}
}
unless(defined(&PPB_REG_MEM)) {
    sub PPB_REG_MEM () {	0x20;}
}
unless(defined(&PPB_REG_PREFMEM)) {
    sub PPB_REG_PREFMEM () {	0x24;}
}
unless(defined(&PPB_REG_PREFBASE_HI32)) {
    sub PPB_REG_PREFBASE_HI32 () {	0x28;}
}
unless(defined(&PPB_REG_PREFLIM_HI32)) {
    sub PPB_REG_PREFLIM_HI32 () {	0x2c;}
}
unless(defined(&PPB_REG_IO_HI)) {
    sub PPB_REG_IO_HI () {	0x30;}
}
unless(defined(&PPB_REG_BRIDGECONTROL)) {
    sub PPB_REG_BRIDGECONTROL () {	0x3c;}
}
unless(defined(&PPB_BUSINFO_PRIMARY)) {
    sub PPB_BUSINFO_PRIMARY {
	local($bir) = @_;
	eval q((($bir >> 0) & 0xff));
    }
}
unless(defined(&PPB_BUSINFO_SECONDARY)) {
    sub PPB_BUSINFO_SECONDARY {
	local($bir) = @_;
	eval q((($bir >> 8) & 0xff));
    }
}
unless(defined(&PPB_BUSINFO_SUBORDINATE)) {
    sub PPB_BUSINFO_SUBORDINATE {
	local($bir) = @_;
	eval q((($bir >> 16) & 0xff));
    }
}
unless(defined(&PPB_BUSINFO_SECLAT)) {
    sub PPB_BUSINFO_SECLAT {
	local($bir) = @_;
	eval q((($bir >> 24) & 0xff));
    }
}
unless(defined(&PPB_INTERRUPT_SWIZZLE)) {
    sub PPB_INTERRUPT_SWIZZLE {
	local($pin, $device) = @_;
	eval q((((($pin) + ($device) - 1) % 4) + 1));
    }
}
unless(defined(&PPB_IOBASE_SHIFT)) {
    sub PPB_IOBASE_SHIFT () {	0;}
}
unless(defined(&PPB_IOLIMIT_SHIFT)) {
    sub PPB_IOLIMIT_SHIFT () {	8;}
}
unless(defined(&PPB_IO_MASK)) {
    sub PPB_IO_MASK () {	0xf000;}
}
unless(defined(&PPB_IO_MIN)) {
    sub PPB_IO_MIN () {	4096;}
}
unless(defined(&PPB_MEMBASE_SHIFT)) {
    sub PPB_MEMBASE_SHIFT () {	0;}
}
unless(defined(&PPB_MEMLIMIT_SHIFT)) {
    sub PPB_MEMLIMIT_SHIFT () {	16;}
}
unless(defined(&PPB_MEM_MASK)) {
    sub PPB_MEM_MASK () {	0xfff00000;}
}
unless(defined(&PPB_MEM_SHIFT)) {
    sub PPB_MEM_SHIFT () {	16;}
}
unless(defined(&PPB_MEM_MIN)) {
    sub PPB_MEM_MIN () {	0x100000;}
}
unless(defined(&PPB_BC_BITBASE)) {
    sub PPB_BC_BITBASE () {	16;}
}
unless(defined(&PPB_BC_PARITYERRORRESPONSE_ENABLE)) {
    sub PPB_BC_PARITYERRORRESPONSE_ENABLE () {	(1 << (0+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_SERR_ENABLE)) {
    sub PPB_BC_SERR_ENABLE () {	(1 << (1+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_ISA_ENABLE)) {
    sub PPB_BC_ISA_ENABLE () {	(1 << (2+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_VGA_ENABLE)) {
    sub PPB_BC_VGA_ENABLE () {	(1 << (3+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_MASTER_ABORT_MODE)) {
    sub PPB_BC_MASTER_ABORT_MODE () {	(1 << (5+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_SECONDARY_RESET)) {
    sub PPB_BC_SECONDARY_RESET () {	(1 << (6+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_FAST_B2B_ENABLE)) {
    sub PPB_BC_FAST_B2B_ENABLE () {	(1 << (7+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_PRIMARY_DISCARD_TIMEOUT)) {
    sub PPB_BC_PRIMARY_DISCARD_TIMEOUT () {	(1 << (8+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_SECONDARY_DISCARD_TIMEOUT)) {
    sub PPB_BC_SECONDARY_DISCARD_TIMEOUT () {	(1 << (9+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_DISCARD_TIMER_STATUS)) {
    sub PPB_BC_DISCARD_TIMER_STATUS () {	(1 << (10+  &PPB_BC_BITBASE));}
}
unless(defined(&PPB_BC_DISCARD_TIMER_SERR_ENABLE)) {
    sub PPB_BC_DISCARD_TIMER_SERR_ENABLE () {	(1 << (11+  &PPB_BC_BITBASE));}
}
1;
