require '_h2ph_pre.ph';

require 'sys/timeout.ph';
unless(defined(&WDC_OPTION_PROBE_VERBOSE)) {
    sub WDC_OPTION_PROBE_VERBOSE () {	0x10000;}
}
unless(defined(&WDCF_ACTIVE)) {
    sub WDCF_ACTIVE () {	0x1;}
}
unless(defined(&WDCF_ONESLAVE)) {
    sub WDCF_ONESLAVE () {	0x2;}
}
unless(defined(&WDCF_IRQ_WAIT)) {
    sub WDCF_IRQ_WAIT () {	0x10;}
}
unless(defined(&WDCF_VERBOSE_PROBE)) {
    sub WDCF_VERBOSE_PROBE () {	0x40;}
}
unless(defined(&_WDC_REGMASK)) {
    sub _WDC_REGMASK () {	7;}
}
unless(defined(&_WDC_AUX)) {
    sub _WDC_AUX () {	8;}
}
unless(defined(&_WDC_RDONLY)) {
    sub _WDC_RDONLY () {	16;}
}
unless(defined(&_WDC_WRONLY)) {
    sub _WDC_WRONLY () {	32;}
}
eval("sub wdr_error () { _WDC_RDONLY|1; }") unless defined(&wdr_error);
eval("sub wdr_precomp () { _WDC_WRONLY|1; }") unless defined(&wdr_precomp);
eval("sub wdr_features () { _WDC_WRONLY|1; }") unless defined(&wdr_features);
eval("sub wdr_seccnt () { 2; }") unless defined(&wdr_seccnt);
eval("sub wdr_ireason () { 2; }") unless defined(&wdr_ireason);
eval("sub wdr_sector () { 3; }") unless defined(&wdr_sector);
eval("sub wdr_lba_lo () { 3; }") unless defined(&wdr_lba_lo);
eval("sub wdr_cyl_lo () { 4; }") unless defined(&wdr_cyl_lo);
eval("sub wdr_lba_mi () { 4; }") unless defined(&wdr_lba_mi);
eval("sub wdr_cyl_hi () { 5; }") unless defined(&wdr_cyl_hi);
eval("sub wdr_lba_hi () { 5; }") unless defined(&wdr_lba_hi);
eval("sub wdr_sdh () { 6; }") unless defined(&wdr_sdh);
eval("sub wdr_status () { _WDC_RDONLY|7; }") unless defined(&wdr_status);
eval("sub wdr_command () { _WDC_WRONLY|7; }") unless defined(&wdr_command);
eval("sub wdr_altsts () { _WDC_RDONLY|_WDC_AUX; }") unless defined(&wdr_altsts);
eval("sub wdr_ctlr () { _WDC_WRONLY|_WDC_AUX; }") unless defined(&wdr_ctlr);
unless(defined(&CHP_READ_REG)) {
    sub CHP_READ_REG {
	local($chp, $a) = @_;
	eval q((($chp)-> ($_vtbl->{read_reg}))($chp, $a));
    }
}
unless(defined(&CHP_WRITE_REG)) {
    sub CHP_WRITE_REG {
	local($chp, $a, $b) = @_;
	eval q((($chp)-> ($_vtbl->{write_reg}))($chp, $a, $b));
    }
}
unless(defined(&CHP_READ_RAW_MULTI_2)) {
    sub CHP_READ_RAW_MULTI_2 {
	local($chp, $a, $b) = @_;
	eval q((($chp)-> ($_vtbl->{read_raw_multi_2}))($chp, $a, $b));
    }
}
unless(defined(&CHP_WRITE_RAW_MULTI_2)) {
    sub CHP_WRITE_RAW_MULTI_2 {
	local($chp, $a, $b) = @_;
	eval q((($chp)-> ($_vtbl->{write_raw_multi_2}))($chp, $a, $b));
    }
}
unless(defined(&CHP_READ_RAW_MULTI_4)) {
    sub CHP_READ_RAW_MULTI_4 {
	local($chp, $a, $b) = @_;
	eval q((($chp)-> ($_vtbl->{read_raw_multi_4}))($chp, $a, $b));
    }
}
unless(defined(&CHP_WRITE_RAW_MULTI_4)) {
    sub CHP_WRITE_RAW_MULTI_4 {
	local($chp, $a, $b) = @_;
	eval q((($chp)-> ($_vtbl->{write_raw_multi_4}))($chp, $a, $b));
    }
}
unless(defined(&WDC_CAPABILITY_DATA16)) {
    sub WDC_CAPABILITY_DATA16 () {	0x1;}
}
unless(defined(&WDC_CAPABILITY_DATA32)) {
    sub WDC_CAPABILITY_DATA32 () {	0x2;}
}
unless(defined(&WDC_CAPABILITY_MODE)) {
    sub WDC_CAPABILITY_MODE () {	0x4;}
}
unless(defined(&WDC_CAPABILITY_DMA)) {
    sub WDC_CAPABILITY_DMA () {	0x8;}
}
unless(defined(&WDC_CAPABILITY_UDMA)) {
    sub WDC_CAPABILITY_UDMA () {	0x10;}
}
unless(defined(&WDC_CAPABILITY_HWLOCK)) {
    sub WDC_CAPABILITY_HWLOCK () {	0x20;}
}
unless(defined(&WDC_CAPABILITY_ATA_NOSTREAM)) {
    sub WDC_CAPABILITY_ATA_NOSTREAM () {	0x40;}
}
unless(defined(&WDC_CAPABILITY_ATAPI_NOSTREAM)) {
    sub WDC_CAPABILITY_ATAPI_NOSTREAM () {	0x80;}
}
unless(defined(&WDC_CAPABILITY_NO_EXTRA_RESETS)) {
    sub WDC_CAPABILITY_NO_EXTRA_RESETS () {	0x100;}
}
unless(defined(&WDC_CAPABILITY_PREATA)) {
    sub WDC_CAPABILITY_PREATA () {	0x200;}
}
unless(defined(&WDC_CAPABILITY_IRQACK)) {
    sub WDC_CAPABILITY_IRQACK () {	0x400;}
}
unless(defined(&WDC_CAPABILITY_SINGLE_DRIVE)) {
    sub WDC_CAPABILITY_SINGLE_DRIVE () {	0x800;}
}
unless(defined(&WDC_CAPABILITY_NO_ATAPI_DMA)) {
    sub WDC_CAPABILITY_NO_ATAPI_DMA () {	0x1000;}
}
if(0) {
}
unless(defined(&WDC_DMA_READ)) {
    sub WDC_DMA_READ () {	0x1;}
}
unless(defined(&WDC_DMA_IRQW)) {
    sub WDC_DMA_IRQW () {	0x2;}
}
unless(defined(&WDC_DMA_LBA48)) {
    sub WDC_DMA_LBA48 () {	0x4;}
}
unless(defined(&WDC_DMAST_NOIRQ)) {
    sub WDC_DMAST_NOIRQ () {	0x1;}
}
unless(defined(&WDC_DMAST_ERR)) {
    sub WDC_DMAST_ERR () {	0x2;}
}
unless(defined(&WDC_DMAST_UNDER)) {
    sub WDC_DMAST_UNDER () {	0x4;}
}
unless(defined(&C_ATAPI)) {
    sub C_ATAPI () {	0x2;}
}
unless(defined(&C_TIMEOU)) {
    sub C_TIMEOU () {	0x4;}
}
unless(defined(&C_NEEDDONE)) {
    sub C_NEEDDONE () {	0x10;}
}
unless(defined(&C_POLL)) {
    sub C_POLL () {	0x20;}
}
unless(defined(&C_DMA)) {
    sub C_DMA () {	0x40;}
}
unless(defined(&C_SENSE)) {
    sub C_SENSE () {	0x80;}
}
unless(defined(&C_MEDIA_ACCESS)) {
    sub C_MEDIA_ACCESS () {	0x100;}
}
unless(defined(&C_POLL_MACHINE)) {
    sub C_POLL_MACHINE () {	0x200;}
}
unless(defined(&WDC_CANSLEEP)) {
    sub WDC_CANSLEEP () {	0x;}
}
unless(defined(&WDC_NOSLEEP)) {
    sub WDC_NOSLEEP () {	0x1;}
}
unless(defined(&VERBOSE)) {
    sub VERBOSE () {	1;}
}
unless(defined(&SILENT)) {
    sub SILENT () {	0;}
}
unless(defined(&wdcwait)) {
    sub wdcwait {
	local($chp, $status, $mask, $timeout) = @_;
	eval q((( &wdc_wait_for_status(($chp), ($status), ($mask), ($timeout)) >= 0) ? 0: -1));
    }
}
unless(defined(&wait_for_drq)) {
    sub wait_for_drq {
	local($chp, $timeout) = @_;
	eval q( &wdcwait(($chp),  &WDCS_DRQ,  &WDCS_DRQ, ($timeout)));
    }
}
unless(defined(&wait_for_unbusy)) {
    sub wait_for_unbusy {
	local($chp, $timeout) = @_;
	eval q( &wdcwait(($chp), 0, 0, ($timeout)));
    }
}
unless(defined(&wait_for_ready)) {
    sub wait_for_ready {
	local($chp, $timeout) = @_;
	eval q( &wdcwait(($chp),  &WDCS_DRDY,  &WDCS_DRDY, ($timeout)));
    }
}
unless(defined(&WDC_RESET_WAIT)) {
    sub WDC_RESET_WAIT () {	31000;}
}
1;
