require '_h2ph_pre.ph';

unless(defined(&RL_IDR0)) {
    sub RL_IDR0 () {	0x;}
}
unless(defined(&RL_IDR1)) {
    sub RL_IDR1 () {	0x1;}
}
unless(defined(&RL_IDR2)) {
    sub RL_IDR2 () {	0x2;}
}
unless(defined(&RL_IDR3)) {
    sub RL_IDR3 () {	0x3;}
}
unless(defined(&RL_IDR4)) {
    sub RL_IDR4 () {	0x4;}
}
unless(defined(&RL_IDR5)) {
    sub RL_IDR5 () {	0x5;}
}
unless(defined(&RL_MAR0)) {
    sub RL_MAR0 () {	0x8;}
}
unless(defined(&RL_MAR1)) {
    sub RL_MAR1 () {	0x9;}
}
unless(defined(&RL_MAR2)) {
    sub RL_MAR2 () {	0xa;}
}
unless(defined(&RL_MAR3)) {
    sub RL_MAR3 () {	0xb;}
}
unless(defined(&RL_MAR4)) {
    sub RL_MAR4 () {	0xc;}
}
unless(defined(&RL_MAR5)) {
    sub RL_MAR5 () {	0xd;}
}
unless(defined(&RL_MAR6)) {
    sub RL_MAR6 () {	0xe;}
}
unless(defined(&RL_MAR7)) {
    sub RL_MAR7 () {	0xf;}
}
unless(defined(&RL_TXSTAT0)) {
    sub RL_TXSTAT0 () {	0x10;}
}
unless(defined(&RL_TXSTAT1)) {
    sub RL_TXSTAT1 () {	0x14;}
}
unless(defined(&RL_TXSTAT2)) {
    sub RL_TXSTAT2 () {	0x18;}
}
unless(defined(&RL_TXSTAT3)) {
    sub RL_TXSTAT3 () {	0x1c;}
}
unless(defined(&RL_TXADDR0)) {
    sub RL_TXADDR0 () {	0x20;}
}
unless(defined(&RL_TXADDR1)) {
    sub RL_TXADDR1 () {	0x24;}
}
unless(defined(&RL_TXADDR2)) {
    sub RL_TXADDR2 () {	0x28;}
}
unless(defined(&RL_TXADDR3)) {
    sub RL_TXADDR3 () {	0x2c;}
}
unless(defined(&RL_RXADDR)) {
    sub RL_RXADDR () {	0x30;}
}
unless(defined(&RL_RX_EARLY_BYTES)) {
    sub RL_RX_EARLY_BYTES () {	0x34;}
}
unless(defined(&RL_RX_EARLY_STAT)) {
    sub RL_RX_EARLY_STAT () {	0x36;}
}
unless(defined(&RL_COMMAND)) {
    sub RL_COMMAND () {	0x37;}
}
unless(defined(&RL_CURRXADDR)) {
    sub RL_CURRXADDR () {	0x38;}
}
unless(defined(&RL_CURRXBUF)) {
    sub RL_CURRXBUF () {	0x3a;}
}
unless(defined(&RL_IMR)) {
    sub RL_IMR () {	0x3c;}
}
unless(defined(&RL_ISR)) {
    sub RL_ISR () {	0x3e;}
}
unless(defined(&RL_TXCFG)) {
    sub RL_TXCFG () {	0x40;}
}
unless(defined(&RL_RXCFG)) {
    sub RL_RXCFG () {	0x44;}
}
unless(defined(&RL_TIMERCNT)) {
    sub RL_TIMERCNT () {	0x48;}
}
unless(defined(&RL_MISSEDPKT)) {
    sub RL_MISSEDPKT () {	0x4c;}
}
unless(defined(&RL_EECMD)) {
    sub RL_EECMD () {	0x50;}
}
unless(defined(&RL_CFG0)) {
    sub RL_CFG0 () {	0x51;}
}
unless(defined(&RL_CFG1)) {
    sub RL_CFG1 () {	0x52;}
}
unless(defined(&RL_MEDIASTAT)) {
    sub RL_MEDIASTAT () {	0x58;}
}
unless(defined(&RL_MII)) {
    sub RL_MII () {	0x5a;}
}
unless(defined(&RL_HALTCLK)) {
    sub RL_HALTCLK () {	0x5b;}
}
unless(defined(&RL_MULTIINTR)) {
    sub RL_MULTIINTR () {	0x5c;}
}
unless(defined(&RL_PCIREV)) {
    sub RL_PCIREV () {	0x5e;}
}
unless(defined(&RL_TXSTAT_ALL)) {
    sub RL_TXSTAT_ALL () {	0x60;}
}
unless(defined(&RL_BMCR)) {
    sub RL_BMCR () {	0x62;}
}
unless(defined(&RL_BMSR)) {
    sub RL_BMSR () {	0x64;}
}
unless(defined(&RL_ANAR)) {
    sub RL_ANAR () {	0x66;}
}
unless(defined(&RL_LPAR)) {
    sub RL_LPAR () {	0x68;}
}
unless(defined(&RL_ANER)) {
    sub RL_ANER () {	0x6a;}
}
unless(defined(&RL_DISCCNT)) {
    sub RL_DISCCNT () {	0x6c;}
}
unless(defined(&RL_FALSECAR)) {
    sub RL_FALSECAR () {	0x6e;}
}
unless(defined(&RL_NWAYTST)) {
    sub RL_NWAYTST () {	0x70;}
}
unless(defined(&RL_RX_ER)) {
    sub RL_RX_ER () {	0x72;}
}
unless(defined(&RL_CSCFG)) {
    sub RL_CSCFG () {	0x74;}
}
unless(defined(&RL_TXCFG_CLRABRT)) {
    sub RL_TXCFG_CLRABRT () {	0x1;}
}
unless(defined(&RL_TXCFG_MAXDMA)) {
    sub RL_TXCFG_MAXDMA () {	0x700;}
}
unless(defined(&RL_TXCFG_CRCAPPEND)) {
    sub RL_TXCFG_CRCAPPEND () {	0x10000;}
}
unless(defined(&RL_TXCFG_LOOPBKTST)) {
    sub RL_TXCFG_LOOPBKTST () {	0x60000;}
}
unless(defined(&RL_TXCFG_IFG)) {
    sub RL_TXCFG_IFG () {	0x3000000;}
}
unless(defined(&RL_TXDMA_16BYTES)) {
    sub RL_TXDMA_16BYTES () {	0x;}
}
unless(defined(&RL_TXDMA_32BYTES)) {
    sub RL_TXDMA_32BYTES () {	0x100;}
}
unless(defined(&RL_TXDMA_64BYTES)) {
    sub RL_TXDMA_64BYTES () {	0x200;}
}
unless(defined(&RL_TXDMA_128BYTES)) {
    sub RL_TXDMA_128BYTES () {	0x300;}
}
unless(defined(&RL_TXDMA_256BYTES)) {
    sub RL_TXDMA_256BYTES () {	0x400;}
}
unless(defined(&RL_TXDMA_512BYTES)) {
    sub RL_TXDMA_512BYTES () {	0x500;}
}
unless(defined(&RL_TXDMA_1024BYTES)) {
    sub RL_TXDMA_1024BYTES () {	0x600;}
}
unless(defined(&RL_TXDMA_2048BYTES)) {
    sub RL_TXDMA_2048BYTES () {	0x700;}
}
unless(defined(&RL_TXSTAT_LENMASK)) {
    sub RL_TXSTAT_LENMASK () {	0x1fff;}
}
unless(defined(&RL_TXSTAT_OWN)) {
    sub RL_TXSTAT_OWN () {	0x2000;}
}
unless(defined(&RL_TXSTAT_TX_UNDERRUN)) {
    sub RL_TXSTAT_TX_UNDERRUN () {	0x4000;}
}
unless(defined(&RL_TXSTAT_TX_OK)) {
    sub RL_TXSTAT_TX_OK () {	0x8000;}
}
unless(defined(&RL_TXSTAT_EARLY_THRESH)) {
    sub RL_TXSTAT_EARLY_THRESH () {	0x3f0000;}
}
unless(defined(&RL_TXSTAT_COLLCNT)) {
    sub RL_TXSTAT_COLLCNT () {	0xf000000;}
}
unless(defined(&RL_TXSTAT_CARR_HBEAT)) {
    sub RL_TXSTAT_CARR_HBEAT () {	0x10000000;}
}
unless(defined(&RL_TXSTAT_OUTOFWIN)) {
    sub RL_TXSTAT_OUTOFWIN () {	0x20000000;}
}
unless(defined(&RL_TXSTAT_TXABRT)) {
    sub RL_TXSTAT_TXABRT () {	0x40000000;}
}
unless(defined(&RL_TXSTAT_CARRLOSS)) {
    sub RL_TXSTAT_CARRLOSS () {	0x80000000;}
}
unless(defined(&RL_ISR_RX_OK)) {
    sub RL_ISR_RX_OK () {	0x1;}
}
unless(defined(&RL_ISR_RX_ERR)) {
    sub RL_ISR_RX_ERR () {	0x2;}
}
unless(defined(&RL_ISR_TX_OK)) {
    sub RL_ISR_TX_OK () {	0x4;}
}
unless(defined(&RL_ISR_TX_ERR)) {
    sub RL_ISR_TX_ERR () {	0x8;}
}
unless(defined(&RL_ISR_RX_OVERRUN)) {
    sub RL_ISR_RX_OVERRUN () {	0x10;}
}
unless(defined(&RL_ISR_PKT_UNDERRUN)) {
    sub RL_ISR_PKT_UNDERRUN () {	0x20;}
}
unless(defined(&RL_ISR_FIFO_OFLOW)) {
    sub RL_ISR_FIFO_OFLOW () {	0x40;}
}
unless(defined(&RL_ISR_PCS_TIMEOUT)) {
    sub RL_ISR_PCS_TIMEOUT () {	0x4000;}
}
unless(defined(&RL_ISR_SYSTEM_ERR)) {
    sub RL_ISR_SYSTEM_ERR () {	0x8000;}
}
unless(defined(&RL_INTRS)) {
    sub RL_INTRS () {	( &RL_ISR_TX_OK| &RL_ISR_RX_OK| &RL_ISR_RX_ERR| &RL_ISR_TX_ERR|  &RL_ISR_RX_OVERRUN| &RL_ISR_PKT_UNDERRUN| &RL_ISR_FIFO_OFLOW|  &RL_ISR_PCS_TIMEOUT| &RL_ISR_SYSTEM_ERR);}
}
unless(defined(&RL_MEDIASTAT_RXPAUSE)) {
    sub RL_MEDIASTAT_RXPAUSE () {	0x1;}
}
unless(defined(&RL_MEDIASTAT_TXPAUSE)) {
    sub RL_MEDIASTAT_TXPAUSE () {	0x2;}
}
unless(defined(&RL_MEDIASTAT_LINK)) {
    sub RL_MEDIASTAT_LINK () {	0x4;}
}
unless(defined(&RL_MEDIASTAT_SPEED10)) {
    sub RL_MEDIASTAT_SPEED10 () {	0x8;}
}
unless(defined(&RL_MEDIASTAT_RXFLOWCTL)) {
    sub RL_MEDIASTAT_RXFLOWCTL () {	0x40;}
}
unless(defined(&RL_MEDIASTAT_TXFLOWCTL)) {
    sub RL_MEDIASTAT_TXFLOWCTL () {	0x80;}
}
unless(defined(&RL_RXCFG_RX_ALLPHYS)) {
    sub RL_RXCFG_RX_ALLPHYS () {	0x1;}
}
unless(defined(&RL_RXCFG_RX_INDIV)) {
    sub RL_RXCFG_RX_INDIV () {	0x2;}
}
unless(defined(&RL_RXCFG_RX_MULTI)) {
    sub RL_RXCFG_RX_MULTI () {	0x4;}
}
unless(defined(&RL_RXCFG_RX_BROAD)) {
    sub RL_RXCFG_RX_BROAD () {	0x8;}
}
unless(defined(&RL_RXCFG_RX_RUNT)) {
    sub RL_RXCFG_RX_RUNT () {	0x10;}
}
unless(defined(&RL_RXCFG_RX_ERRPKT)) {
    sub RL_RXCFG_RX_ERRPKT () {	0x20;}
}
unless(defined(&RL_RXCFG_WRAP)) {
    sub RL_RXCFG_WRAP () {	0x80;}
}
unless(defined(&RL_RXCFG_MAXDMA)) {
    sub RL_RXCFG_MAXDMA () {	0x700;}
}
unless(defined(&RL_RXCFG_BURSZ)) {
    sub RL_RXCFG_BURSZ () {	0x1800;}
}
unless(defined(&RL_RXCFG_FIFOTHRESH)) {
    sub RL_RXCFG_FIFOTHRESH () {	0xe000;}
}
unless(defined(&RL_RXCFG_EARLYTHRESH)) {
    sub RL_RXCFG_EARLYTHRESH () {	0x7000000;}
}
unless(defined(&RL_RXDMA_16BYTES)) {
    sub RL_RXDMA_16BYTES () {	0x;}
}
unless(defined(&RL_RXDMA_32BYTES)) {
    sub RL_RXDMA_32BYTES () {	0x100;}
}
unless(defined(&RL_RXDMA_64BYTES)) {
    sub RL_RXDMA_64BYTES () {	0x200;}
}
unless(defined(&RL_RXDMA_128BYTES)) {
    sub RL_RXDMA_128BYTES () {	0x300;}
}
unless(defined(&RL_RXDMA_256BYTES)) {
    sub RL_RXDMA_256BYTES () {	0x400;}
}
unless(defined(&RL_RXDMA_512BYTES)) {
    sub RL_RXDMA_512BYTES () {	0x500;}
}
unless(defined(&RL_RXDMA_1024BYTES)) {
    sub RL_RXDMA_1024BYTES () {	0x600;}
}
unless(defined(&RL_RXDMA_UNLIMITED)) {
    sub RL_RXDMA_UNLIMITED () {	0x700;}
}
unless(defined(&RL_RXBUF_8)) {
    sub RL_RXBUF_8 () {	0x;}
}
unless(defined(&RL_RXBUF_16)) {
    sub RL_RXBUF_16 () {	0x800;}
}
unless(defined(&RL_RXBUF_32)) {
    sub RL_RXBUF_32 () {	0x1000;}
}
unless(defined(&RL_RXBUF_64)) {
    sub RL_RXBUF_64 () {	0x1800;}
}
unless(defined(&RL_RXFIFO_16BYTES)) {
    sub RL_RXFIFO_16BYTES () {	0x;}
}
unless(defined(&RL_RXFIFO_32BYTES)) {
    sub RL_RXFIFO_32BYTES () {	0x2000;}
}
unless(defined(&RL_RXFIFO_64BYTES)) {
    sub RL_RXFIFO_64BYTES () {	0x4000;}
}
unless(defined(&RL_RXFIFO_128BYTES)) {
    sub RL_RXFIFO_128BYTES () {	0x6000;}
}
unless(defined(&RL_RXFIFO_256BYTES)) {
    sub RL_RXFIFO_256BYTES () {	0x8000;}
}
unless(defined(&RL_RXFIFO_512BYTES)) {
    sub RL_RXFIFO_512BYTES () {	0xa000;}
}
unless(defined(&RL_RXFIFO_1024BYTES)) {
    sub RL_RXFIFO_1024BYTES () {	0xc000;}
}
unless(defined(&RL_RXFIFO_NOTHRESH)) {
    sub RL_RXFIFO_NOTHRESH () {	0xe000;}
}
unless(defined(&RL_RXSTAT_RXOK)) {
    sub RL_RXSTAT_RXOK () {	0x1;}
}
unless(defined(&RL_RXSTAT_ALIGNERR)) {
    sub RL_RXSTAT_ALIGNERR () {	0x2;}
}
unless(defined(&RL_RXSTAT_CRCERR)) {
    sub RL_RXSTAT_CRCERR () {	0x4;}
}
unless(defined(&RL_RXSTAT_GIANT)) {
    sub RL_RXSTAT_GIANT () {	0x8;}
}
unless(defined(&RL_RXSTAT_RUNT)) {
    sub RL_RXSTAT_RUNT () {	0x10;}
}
unless(defined(&RL_RXSTAT_BADSYM)) {
    sub RL_RXSTAT_BADSYM () {	0x20;}
}
unless(defined(&RL_RXSTAT_BROAD)) {
    sub RL_RXSTAT_BROAD () {	0x2000;}
}
unless(defined(&RL_RXSTAT_INDIV)) {
    sub RL_RXSTAT_INDIV () {	0x4000;}
}
unless(defined(&RL_RXSTAT_MULTI)) {
    sub RL_RXSTAT_MULTI () {	0x8000;}
}
unless(defined(&RL_RXSTAT_LENMASK)) {
    sub RL_RXSTAT_LENMASK () {	0xffff0000;}
}
unless(defined(&RL_RXSTAT_UNFINISHED)) {
    sub RL_RXSTAT_UNFINISHED () {	0xfff0;}
}
unless(defined(&RL_CMD_EMPTY_RXBUF)) {
    sub RL_CMD_EMPTY_RXBUF () {	0x1;}
}
unless(defined(&RL_CMD_TX_ENB)) {
    sub RL_CMD_TX_ENB () {	0x4;}
}
unless(defined(&RL_CMD_RX_ENB)) {
    sub RL_CMD_RX_ENB () {	0x8;}
}
unless(defined(&RL_CMD_RESET)) {
    sub RL_CMD_RESET () {	0x10;}
}
unless(defined(&RL_EE_DATAOUT)) {
    sub RL_EE_DATAOUT () {	0x1;}
}
unless(defined(&RL_EE_DATAIN)) {
    sub RL_EE_DATAIN () {	0x2;}
}
unless(defined(&RL_EE_CLK)) {
    sub RL_EE_CLK () {	0x4;}
}
unless(defined(&RL_EE_SEL)) {
    sub RL_EE_SEL () {	0x8;}
}
unless(defined(&RL_EE_MODE)) {
    sub RL_EE_MODE () {	(0x40|0x80);}
}
unless(defined(&RL_EEMODE_OFF)) {
    sub RL_EEMODE_OFF () {	0x;}
}
unless(defined(&RL_EEMODE_AUTOLOAD)) {
    sub RL_EEMODE_AUTOLOAD () {	0x40;}
}
unless(defined(&RL_EEMODE_PROGRAM)) {
    sub RL_EEMODE_PROGRAM () {	0x80;}
}
unless(defined(&RL_EEMODE_WRITECFG)) {
    sub RL_EEMODE_WRITECFG () {	(0x80|0x40);}
}
unless(defined(&RL_EECMD_WRITE)) {
    sub RL_EECMD_WRITE () {	0x5;}
}
unless(defined(&RL_EECMD_READ)) {
    sub RL_EECMD_READ () {	0x6;}
}
unless(defined(&RL_EECMD_ERASE)) {
    sub RL_EECMD_ERASE () {	0x7;}
}
unless(defined(&RL_EECMD_LEN)) {
    sub RL_EECMD_LEN () {	4;}
}
unless(defined(&RL_EEADDR_LEN0)) {
    sub RL_EEADDR_LEN0 () {	6;}
}
unless(defined(&RL_EEADDR_LEN1)) {
    sub RL_EEADDR_LEN1 () {	8;}
}
unless(defined(&RL_EE_ID)) {
    sub RL_EE_ID () {	0x;}
}
unless(defined(&RL_EE_PCI_VID)) {
    sub RL_EE_PCI_VID () {	0x1;}
}
unless(defined(&RL_EE_PCI_DID)) {
    sub RL_EE_PCI_DID () {	0x2;}
}
unless(defined(&RL_EE_EADDR)) {
    sub RL_EE_EADDR () {	0x7;}
}
unless(defined(&RL_MII_CLK)) {
    sub RL_MII_CLK () {	0x1;}
}
unless(defined(&RL_MII_DATAIN)) {
    sub RL_MII_DATAIN () {	0x2;}
}
unless(defined(&RL_MII_DATAOUT)) {
    sub RL_MII_DATAOUT () {	0x4;}
}
unless(defined(&RL_MII_DIR)) {
    sub RL_MII_DIR () {	0x80;}
}
unless(defined(&RL_CFG0_ROM0)) {
    sub RL_CFG0_ROM0 () {	0x1;}
}
unless(defined(&RL_CFG0_ROM1)) {
    sub RL_CFG0_ROM1 () {	0x2;}
}
unless(defined(&RL_CFG0_ROM2)) {
    sub RL_CFG0_ROM2 () {	0x4;}
}
unless(defined(&RL_CFG0_PL0)) {
    sub RL_CFG0_PL0 () {	0x8;}
}
unless(defined(&RL_CFG0_PL1)) {
    sub RL_CFG0_PL1 () {	0x10;}
}
unless(defined(&RL_CFG0_10MBPS)) {
    sub RL_CFG0_10MBPS () {	0x20;}
}
unless(defined(&RL_CFG0_PCS)) {
    sub RL_CFG0_PCS () {	0x40;}
}
unless(defined(&RL_CFG0_SCR)) {
    sub RL_CFG0_SCR () {	0x80;}
}
unless(defined(&RL_CFG1_PWRDWN)) {
    sub RL_CFG1_PWRDWN () {	0x1;}
}
unless(defined(&RL_CFG1_SLEEP)) {
    sub RL_CFG1_SLEEP () {	0x2;}
}
unless(defined(&RL_CFG1_IOMAP)) {
    sub RL_CFG1_IOMAP () {	0x4;}
}
unless(defined(&RL_CFG1_MEMMAP)) {
    sub RL_CFG1_MEMMAP () {	0x8;}
}
unless(defined(&RL_CFG1_RSVD)) {
    sub RL_CFG1_RSVD () {	0x10;}
}
unless(defined(&RL_CFG1_DRVLOAD)) {
    sub RL_CFG1_DRVLOAD () {	0x20;}
}
unless(defined(&RL_CFG1_LED0)) {
    sub RL_CFG1_LED0 () {	0x40;}
}
unless(defined(&RL_CFG1_FULLDUPLEX)) {
    sub RL_CFG1_FULLDUPLEX () {	0x40;}
}
unless(defined(&RL_CFG1_LED1)) {
    sub RL_CFG1_LED1 () {	0x80;}
}
unless(defined(&RL_RX_BUF_SZ)) {
    sub RL_RX_BUF_SZ () {	 &RL_RXBUF_64;}
}
unless(defined(&RL_RXBUFLEN)) {
    sub RL_RXBUFLEN () {	(1<< (( &RL_RX_BUF_SZ >> 11) + 13));}
}
unless(defined(&RL_TX_LIST_CNT)) {
    sub RL_TX_LIST_CNT () {	4;}
}
unless(defined(&RL_MIN_FRAMELEN)) {
    sub RL_MIN_FRAMELEN () {	60;}
}
unless(defined(&RL_TXTHRESH)) {
    sub RL_TXTHRESH {
	local($x) = @_;
	eval q((($x) << 11));
    }
}
unless(defined(&RL_TX_THRESH_INIT)) {
    sub RL_TX_THRESH_INIT () {	96;}
}
unless(defined(&RL_RX_FIFOTHRESH)) {
    sub RL_RX_FIFOTHRESH () {	 &RL_RXFIFO_256BYTES;}
}
unless(defined(&RL_RX_MAXDMA)) {
    sub RL_RX_MAXDMA () {	 &RL_RXDMA_UNLIMITED;}
}
unless(defined(&RL_TX_MAXDMA)) {
    sub RL_TX_MAXDMA () {	 &RL_TXDMA_2048BYTES;}
}
unless(defined(&RL_RXCFG_CONFIG)) {
    sub RL_RXCFG_CONFIG () {	( &RL_RX_FIFOTHRESH| &RL_RX_MAXDMA| &RL_RX_BUF_SZ);}
}
unless(defined(&RL_TXCFG_CONFIG)) {
    sub RL_TXCFG_CONFIG () {	( &RL_TXCFG_IFG| &RL_TX_MAXDMA);}
}
unless(defined(&RL_ETHER_ALIGN)) {
    sub RL_ETHER_ALIGN () {	2;}
}
unless(defined(&RL_INC)) {
    sub RL_INC {
	local($x) = @_;
	eval q(($x = ($x + 1) %  &RL_TX_LIST_CNT));
    }
}
unless(defined(&RL_CUR_TXADDR)) {
    sub RL_CUR_TXADDR {
	local($x) = @_;
	eval q((( ($x->{rl_cdata}->{cur_tx}) * 4) +  &RL_TXADDR0));
    }
}
unless(defined(&RL_CUR_TXSTAT)) {
    sub RL_CUR_TXSTAT {
	local($x) = @_;
	eval q((( ($x->{rl_cdata}->{cur_tx}) * 4) +  &RL_TXSTAT0));
    }
}
unless(defined(&RL_CUR_TXMBUF)) {
    sub RL_CUR_TXMBUF {
	local($x) = @_;
	eval q(( ($x->{rl_cdata}->{rl_tx_chain[$x}->{rl_cdata}->{cur_tx]})));
    }
}
unless(defined(&RL_LAST_TXADDR)) {
    sub RL_LAST_TXADDR {
	local($x) = @_;
	eval q((( ($x->{rl_cdata}->{last_tx}) * 4) +  &RL_TXADDR0));
    }
}
unless(defined(&RL_LAST_TXSTAT)) {
    sub RL_LAST_TXSTAT {
	local($x) = @_;
	eval q((( ($x->{rl_cdata}->{last_tx}) * 4) +  &RL_TXSTAT0));
    }
}
unless(defined(&RL_LAST_TXMBUF)) {
    sub RL_LAST_TXMBUF {
	local($x) = @_;
	eval q(( ($x->{rl_cdata}->{rl_tx_chain[$x}->{rl_cdata}->{last_tx]})));
    }
}
unless(defined(&RL_MII_STARTDELIM)) {
    sub RL_MII_STARTDELIM () {	0x1;}
}
unless(defined(&RL_MII_READOP)) {
    sub RL_MII_READOP () {	0x2;}
}
unless(defined(&RL_MII_WRITEOP)) {
    sub RL_MII_WRITEOP () {	0x1;}
}
unless(defined(&RL_MII_TURNAROUND)) {
    sub RL_MII_TURNAROUND () {	0x2;}
}
unless(defined(&RL_8129)) {
    sub RL_8129 () {	1;}
}
unless(defined(&RL_8139)) {
    sub RL_8139 () {	2;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $csr, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{rl_btag}),  ($sc->{rl_bhandle}), $csr, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $csr, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{rl_btag}),  ($sc->{rl_bhandle}), $csr, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $csr, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{rl_btag}),  ($sc->{rl_bhandle}), $csr, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $csr) = @_;
	eval q( &bus_space_read_4( ($sc->{rl_btag}),  ($sc->{rl_bhandle}), $csr));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $csr) = @_;
	eval q( &bus_space_read_2( ($sc->{rl_btag}),  ($sc->{rl_bhandle}), $csr));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $csr) = @_;
	eval q( &bus_space_read_1( ($sc->{rl_btag}),  ($sc->{rl_bhandle}), $csr));
    }
}
unless(defined(&RL_TIMEOUT)) {
    sub RL_TIMEOUT () {	1000;}
}
unless(defined(&RT_VENDORID)) {
    sub RT_VENDORID () {	0x10ec;}
}
unless(defined(&RT_DEVICEID_8129)) {
    sub RT_DEVICEID_8129 () {	0x8129;}
}
unless(defined(&RT_DEVICEID_8139)) {
    sub RT_DEVICEID_8139 () {	0x8139;}
}
unless(defined(&ACCTON_VENDORID)) {
    sub ACCTON_VENDORID () {	0x1113;}
}
unless(defined(&ACCTON_DEVICEID_5030)) {
    sub ACCTON_DEVICEID_5030 () {	0x1211;}
}
unless(defined(&DELTA_VENDORID)) {
    sub DELTA_VENDORID () {	0x1500;}
}
unless(defined(&DELTA_DEVICEID_8139)) {
    sub DELTA_DEVICEID_8139 () {	0x1360;}
}
unless(defined(&ADDTRON_VENDORID)) {
    sub ADDTRON_VENDORID () {	0x4033;}
}
unless(defined(&ADDTRON_DEVICEID_8139)) {
    sub ADDTRON_DEVICEID_8139 () {	0x1360;}
}
unless(defined(&DLINK_VENDORID)) {
    sub DLINK_VENDORID () {	0x1186;}
}
unless(defined(&DLINK_DEVICEID_8139)) {
    sub DLINK_DEVICEID_8139 () {	0x1300;}
}
unless(defined(&RL_PCI_VENDOR_ID)) {
    sub RL_PCI_VENDOR_ID () {	0x;}
}
unless(defined(&RL_PCI_DEVICE_ID)) {
    sub RL_PCI_DEVICE_ID () {	0x2;}
}
unless(defined(&RL_PCI_COMMAND)) {
    sub RL_PCI_COMMAND () {	0x4;}
}
unless(defined(&RL_PCI_STATUS)) {
    sub RL_PCI_STATUS () {	0x6;}
}
unless(defined(&RL_PCI_CLASSCODE)) {
    sub RL_PCI_CLASSCODE () {	0x9;}
}
unless(defined(&RL_PCI_LATENCY_TIMER)) {
    sub RL_PCI_LATENCY_TIMER () {	0xd;}
}
unless(defined(&RL_PCI_HEADER_TYPE)) {
    sub RL_PCI_HEADER_TYPE () {	0xe;}
}
unless(defined(&RL_PCI_LOIO)) {
    sub RL_PCI_LOIO () {	0x10;}
}
unless(defined(&RL_PCI_LOMEM)) {
    sub RL_PCI_LOMEM () {	0x14;}
}
unless(defined(&RL_PCI_BIOSROM)) {
    sub RL_PCI_BIOSROM () {	0x30;}
}
unless(defined(&RL_PCI_INTLINE)) {
    sub RL_PCI_INTLINE () {	0x3c;}
}
unless(defined(&RL_PCI_INTPIN)) {
    sub RL_PCI_INTPIN () {	0x3d;}
}
unless(defined(&RL_PCI_MINGNT)) {
    sub RL_PCI_MINGNT () {	0x3e;}
}
unless(defined(&RL_PCI_MINLAT)) {
    sub RL_PCI_MINLAT () {	0xf;}
}
unless(defined(&RL_PCI_RESETOPT)) {
    sub RL_PCI_RESETOPT () {	0x48;}
}
unless(defined(&RL_PCI_EEPROM_DATA)) {
    sub RL_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&RL_PCI_CAPID)) {
    sub RL_PCI_CAPID () {	0x50;}
}
unless(defined(&RL_PCI_NEXTPTR)) {
    sub RL_PCI_NEXTPTR () {	0x51;}
}
unless(defined(&RL_PCI_PWRMGMTCAP)) {
    sub RL_PCI_PWRMGMTCAP () {	0x52;}
}
unless(defined(&RL_PCI_PWRMGMTCTRL)) {
    sub RL_PCI_PWRMGMTCTRL () {	0x54;}
}
unless(defined(&RL_PSTATE_MASK)) {
    sub RL_PSTATE_MASK () {	0x3;}
}
unless(defined(&RL_PSTATE_D0)) {
    sub RL_PSTATE_D0 () {	0x;}
}
unless(defined(&RL_PSTATE_D1)) {
    sub RL_PSTATE_D1 () {	0x2;}
}
unless(defined(&RL_PSTATE_D2)) {
    sub RL_PSTATE_D2 () {	0x2;}
}
unless(defined(&RL_PSTATE_D3)) {
    sub RL_PSTATE_D3 () {	0x3;}
}
unless(defined(&RL_PME_EN)) {
    sub RL_PME_EN () {	0x10;}
}
unless(defined(&RL_PME_STATUS)) {
    sub RL_PME_STATUS () {	0x8000;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
1;
