require '_h2ph_pre.ph';

require 'sys/timeout.ph';
unless(defined(&NCR53C9X_DEBUG)) {
    sub NCR53C9X_DEBUG () {	1;}
}
unless(defined(&NCR_NTARG)) {
    sub NCR_NTARG () {	8;}
}
unless(defined(&NCR_NLUN)) {
    sub NCR_NLUN () {	8;}
}
unless(defined(&NCR_ABORT_TIMEOUT)) {
    sub NCR_ABORT_TIMEOUT () {	2000;}
}
unless(defined(&NCR_SENSE_TIMEOUT)) {
    sub NCR_SENSE_TIMEOUT () {	1000;}
}
unless(defined(&FREQTOCCF)) {
    sub FREQTOCCF {
	local($freq) = @_;
	eval q(((($freq + 4) / 5)));
    }
}
unless(defined(&NCR_VARIANT_ESP100)) {
    sub NCR_VARIANT_ESP100 () {	0;}
}
unless(defined(&NCR_VARIANT_ESP100A)) {
    sub NCR_VARIANT_ESP100A () {	1;}
}
unless(defined(&NCR_VARIANT_ESP200)) {
    sub NCR_VARIANT_ESP200 () {	2;}
}
unless(defined(&NCR_VARIANT_NCR53C94)) {
    sub NCR_VARIANT_NCR53C94 () {	3;}
}
unless(defined(&NCR_VARIANT_NCR53C96)) {
    sub NCR_VARIANT_NCR53C96 () {	4;}
}
unless(defined(&NCR_VARIANT_ESP406)) {
    sub NCR_VARIANT_ESP406 () {	5;}
}
unless(defined(&NCR_VARIANT_FAS408)) {
    sub NCR_VARIANT_FAS408 () {	6;}
}
unless(defined(&NCR_VARIANT_FAS216)) {
    sub NCR_VARIANT_FAS216 () {	7;}
}
unless(defined(&NCR_VARIANT_AM53C974)) {
    sub NCR_VARIANT_AM53C974 () {	8;}
}
unless(defined(&NCR_VARIANT_FAS366)) {
    sub NCR_VARIANT_FAS366 () {	9;}
}
unless(defined(&NCR_VARIANT_MAX)) {
    sub NCR_VARIANT_MAX () {	10;}
}
unless(defined(&ECB_ALLOC)) {
    sub ECB_ALLOC () {	0x1;}
}
unless(defined(&ECB_READY)) {
    sub ECB_READY () {	0x2;}
}
unless(defined(&ECB_SENSE)) {
    sub ECB_SENSE () {	0x4;}
}
unless(defined(&ECB_ABORT)) {
    sub ECB_ABORT () {	0x40;}
}
unless(defined(&ECB_RESET)) {
    sub ECB_RESET () {	0x80;}
}
unless(defined(&ECB_TENTATIVE_DONE)) {
    sub ECB_TENTATIVE_DONE () {	0x100;}
}
if((defined(&NCR53C9X_DEBUG) ? &NCR53C9X_DEBUG : 0) > 1) {
}
if((defined(&NCR53C9X_DEBUG) ? &NCR53C9X_DEBUG : 0) > 1) {
    eval 'sub ECB_TRACE {
        local($ecb, $msg, $a, $b) = @_;
	    eval q( &do {  &const \'char\' * &f = \\"[\\" $msg \\"]\\"; \'int\'  &n =  &strlen(($ecb)-> &trace);  &if ( &n < ($sizeof{($ecb)-> &trace}-100))  &snprintf(($ecb)-> &trace +  &n, $sizeof{($ecb)-> &trace} -  &n,  &f, $a, $b); }  &while(0));
    }' unless defined(&ECB_TRACE);
} else {
    eval 'sub ECB_TRACE {
        local($ecb, $msg, $a, $b) = @_;
	    eval q();
    }' unless defined(&ECB_TRACE);
}
unless(defined(&T_NEED_TO_RESET)) {
    sub T_NEED_TO_RESET () {	0x1;}
}
unless(defined(&T_NEGOTIATE)) {
    sub T_NEGOTIATE () {	0x2;}
}
unless(defined(&T_BUSY)) {
    sub T_BUSY () {	0x4;}
}
unless(defined(&T_SYNCMODE)) {
    sub T_SYNCMODE () {	0x8;}
}
unless(defined(&T_SYNCHOFF)) {
    sub T_SYNCHOFF () {	0x10;}
}
unless(defined(&T_RSELECTOFF)) {
    sub T_RSELECTOFF () {	0x20;}
}
unless(defined(&T_TAG)) {
    sub T_TAG () {	0x40;}
}
unless(defined(&T_WIDE)) {
    sub T_WIDE () {	0x80;}
}
unless(defined(&TINFO_LUN)) {
    sub TINFO_LUN {
	local($t, $l) = @_;
	eval q(((( <  &NCR_NLUN)  && ((-> $lun[]) !=  &NULL)) ? (-> $lun[]) :  &ncr53c9x_lunsearch(, ($l))));
    }
}
unless(defined(&LOGLINE)) {
    sub LOGLINE {
	local($p) = @_;
	eval q();
    }
}
unless(defined(&NCR_SHOWECBS)) {
    sub NCR_SHOWECBS () {	0x1;}
}
unless(defined(&NCR_SHOWINTS)) {
    sub NCR_SHOWINTS () {	0x2;}
}
unless(defined(&NCR_SHOWCMDS)) {
    sub NCR_SHOWCMDS () {	0x4;}
}
unless(defined(&NCR_SHOWMISC)) {
    sub NCR_SHOWMISC () {	0x8;}
}
unless(defined(&NCR_SHOWTRAC)) {
    sub NCR_SHOWTRAC () {	0x10;}
}
unless(defined(&NCR_SHOWSTART)) {
    sub NCR_SHOWSTART () {	0x20;}
}
unless(defined(&NCR_SHOWPHASE)) {
    sub NCR_SHOWPHASE () {	0x40;}
}
unless(defined(&NCR_SHOWDMA)) {
    sub NCR_SHOWDMA () {	0x80;}
}
unless(defined(&NCR_SHOWCCMDS)) {
    sub NCR_SHOWCCMDS () {	0x100;}
}
unless(defined(&NCR_SHOWMSGS)) {
    sub NCR_SHOWMSGS () {	0x200;}
}
if(defined(&NCR53C9X_DEBUG)) {
    eval 'sub NCR_ECBS {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWECBS)  &printf $str;}  &while (0));
    }' unless defined(&NCR_ECBS);
    eval 'sub NCR_MISC {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWMISC)  &printf $str;}  &while (0));
    }' unless defined(&NCR_MISC);
    eval 'sub NCR_INTS {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWINTS)  &printf $str;}  &while (0));
    }' unless defined(&NCR_INTS);
    eval 'sub NCR_TRACE {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWTRAC)  &printf $str;}  &while (0));
    }' unless defined(&NCR_TRACE);
    eval 'sub NCR_CMDS {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWCMDS)  &printf $str;}  &while (0));
    }' unless defined(&NCR_CMDS);
    eval 'sub NCR_START {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWSTART)  &printf $str;} &while (0));
    }' unless defined(&NCR_START);
    eval 'sub NCR_PHASE {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWPHASE)  &printf $str;} &while (0));
    }' unless defined(&NCR_PHASE);
    eval 'sub NCR_DMA {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWDMA)  &printf $str;} &while (0));
    }' unless defined(&NCR_DMA);
    eval 'sub NCR_MSGS {
        local($str) = @_;
	    eval q( &do { &if ( &ncr53c9x_debug &  &NCR_SHOWMSGS)  &printf $str;} &while (0));
    }' unless defined(&NCR_MSGS);
} else {
    eval 'sub NCR_ECBS {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_ECBS);
    eval 'sub NCR_MISC {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_MISC);
    eval 'sub NCR_INTS {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_INTS);
    eval 'sub NCR_TRACE {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_TRACE);
    eval 'sub NCR_CMDS {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_CMDS);
    eval 'sub NCR_START {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_START);
    eval 'sub NCR_PHASE {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_PHASE);
    eval 'sub NCR_DMA {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_DMA);
    eval 'sub NCR_MSGS {
        local($str) = @_;
	    eval q();
    }' unless defined(&NCR_MSGS);
}
unless(defined(&NCR_MAX_MSG_LEN)) {
    sub NCR_MAX_MSG_LEN () {	8;}
}
unless(defined(&NCR_IDLE)) {
    sub NCR_IDLE () {	1;}
}
unless(defined(&NCR_SELECTING)) {
    sub NCR_SELECTING () {	2;}
}
unless(defined(&NCR_RESELECTED)) {
    sub NCR_RESELECTED () {	3;}
}
unless(defined(&NCR_IDENTIFIED)) {
    sub NCR_IDENTIFIED () {	4;}
}
unless(defined(&NCR_CONNECTED)) {
    sub NCR_CONNECTED () {	5;}
}
unless(defined(&NCR_DISCONNECT)) {
    sub NCR_DISCONNECT () {	6;}
}
unless(defined(&NCR_CMDCOMPLETE)) {
    sub NCR_CMDCOMPLETE () {	7;}
}
unless(defined(&NCR_CLEANING)) {
    sub NCR_CLEANING () {	8;}
}
unless(defined(&NCR_SBR)) {
    sub NCR_SBR () {	9;}
}
unless(defined(&NCR_DROP_MSGI)) {
    sub NCR_DROP_MSGI () {	0x1;}
}
unless(defined(&NCR_ABORTING)) {
    sub NCR_ABORTING () {	0x2;}
}
unless(defined(&NCR_DOINGDMA)) {
    sub NCR_DOINGDMA () {	0x4;}
}
unless(defined(&NCR_SYNCHNEGO)) {
    sub NCR_SYNCHNEGO () {	0x8;}
}
unless(defined(&NCR_ICCS)) {
    sub NCR_ICCS () {	0x10;}
}
unless(defined(&NCR_WAITI)) {
    sub NCR_WAITI () {	0x20;}
}
unless(defined(&NCR_ATN)) {
    sub NCR_ATN () {	0x40;}
}
unless(defined(&NCR_EXPECT_ILLCMD)) {
    sub NCR_EXPECT_ILLCMD () {	0x80;}
}
unless(defined(&NCR_F_HASCFG3)) {
    sub NCR_F_HASCFG3 () {	0x1;}
}
unless(defined(&NCR_F_FASTSCSI)) {
    sub NCR_F_FASTSCSI () {	0x2;}
}
unless(defined(&NCR_F_DMASELECT)) {
    sub NCR_F_DMASELECT () {	0x4;}
}
unless(defined(&NCR_F_SELATN3)) {
    sub NCR_F_SELATN3 () {	0x8;}
}
unless(defined(&SEND_DEV_RESET)) {
    sub SEND_DEV_RESET () {	0x1;}
}
unless(defined(&SEND_PARITY_ERROR)) {
    sub SEND_PARITY_ERROR () {	0x2;}
}
unless(defined(&SEND_INIT_DET_ERR)) {
    sub SEND_INIT_DET_ERR () {	0x4;}
}
unless(defined(&SEND_REJECT)) {
    sub SEND_REJECT () {	0x8;}
}
unless(defined(&SEND_IDENTIFY)) {
    sub SEND_IDENTIFY () {	0x10;}
}
unless(defined(&SEND_ABORT)) {
    sub SEND_ABORT () {	0x20;}
}
unless(defined(&SEND_WDTR)) {
    sub SEND_WDTR () {	0x40;}
}
unless(defined(&SEND_SDTR)) {
    sub SEND_SDTR () {	0x80;}
}
unless(defined(&SEND_TAG)) {
    sub SEND_TAG () {	0x100;}
}
unless(defined(&ST_MASK)) {
    sub ST_MASK () {	0x3e;}
}
unless(defined(&IOI)) {
    sub IOI () {	0x1;}
}
unless(defined(&CDI)) {
    sub CDI () {	0x2;}
}
unless(defined(&MSGI)) {
    sub MSGI () {	0x4;}
}
unless(defined(&DATA_OUT_PHASE)) {
    sub DATA_OUT_PHASE () {	(0);}
}
unless(defined(&DATA_IN_PHASE)) {
    sub DATA_IN_PHASE () {	( &IOI);}
}
unless(defined(&COMMAND_PHASE)) {
    sub COMMAND_PHASE () {	( &CDI);}
}
unless(defined(&STATUS_PHASE)) {
    sub STATUS_PHASE () {	( &CDI| &IOI);}
}
unless(defined(&MESSAGE_OUT_PHASE)) {
    sub MESSAGE_OUT_PHASE () {	( &MSGI| &CDI);}
}
unless(defined(&MESSAGE_IN_PHASE)) {
    sub MESSAGE_IN_PHASE () {	( &MSGI| &CDI| &IOI);}
}
unless(defined(&PHASE_MASK)) {
    sub PHASE_MASK () {	( &MSGI| &CDI| &IOI);}
}
unless(defined(&BUSFREE_PHASE)) {
    sub BUSFREE_PHASE () {	0x100;}
}
unless(defined(&INVALID_PHASE)) {
    sub INVALID_PHASE () {	0x101;}
}
unless(defined(&PSEUDO_PHASE)) {
    sub PSEUDO_PHASE () {	0x100;}
}
unless(defined(&NCR_READ_REG)) {
    sub NCR_READ_REG {
	local($sc, $reg) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_read_reg}))(($sc), ($reg)));
    }
}
unless(defined(&NCR_WRITE_REG)) {
    sub NCR_WRITE_REG {
	local($sc, $reg, $val) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_write_reg}))(($sc), ($reg), ($val)));
    }
}
if(defined(&NCR53C9X_DEBUG)) {
    eval 'sub NCRCMD {
        local($sc, $cmd) = @_;
	    eval q( &do {  &if ( &ncr53c9x_debug &  &NCR_SHOWCCMDS)  &printf(\\"<cmd:0x%x %d>\\", $cmd,  &__LINE__);  ($sc->{sc_lastcmd}) = $cmd;  &NCR_WRITE_REG($sc,  &NCR_CMD, $cmd); }  &while (0));
    }' unless defined(&NCRCMD);
} else {
    eval 'sub NCRCMD {
        local($sc, $cmd) = @_;
	    eval q( &NCR_WRITE_REG($sc,  &NCR_CMD, $cmd));
    }' unless defined(&NCRCMD);
}
unless(defined(&NCRDMA_ISINTR)) {
    sub NCRDMA_ISINTR {
	local($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_isintr}))(($sc)));
    }
}
unless(defined(&NCRDMA_RESET)) {
    sub NCRDMA_RESET {
	local($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_reset}))(($sc)));
    }
}
unless(defined(&NCRDMA_INTR)) {
    sub NCRDMA_INTR {
	local($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_intr}))(($sc)));
    }
}
unless(defined(&NCRDMA_SETUP)) {
    sub NCRDMA_SETUP {
	local($sc, $addr, $len, $datain, $dmasize) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_setup}))(($sc), ($addr), ($len), ($datain), ($dmasize)));
    }
}
unless(defined(&NCRDMA_GO)) {
    sub NCRDMA_GO {
	local($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_go}))(($sc)));
    }
}
unless(defined(&NCRDMA_ISACTIVE)) {
    sub NCRDMA_ISACTIVE {
	local($sc) = @_;
	eval q((*($sc)-> ($sc_glue->{gl_dma_isactive}))(($sc)));
    }
}
unless(defined(&ncr53c9x_cpb2stp)) {
    sub ncr53c9x_cpb2stp {
	local($sc, $cpb) = @_;
	eval q(((250* ($cpb)) / ($sc)-> &sc_freq));
    }
}
1;
