require '_h2ph_pre.ph';

unless(defined(&COMMAND_REG)) {
    sub COMMAND_REG () {	0;}
}
unless(defined(&MC_SETUP_CMD)) {
    sub MC_SETUP_CMD () {	0x3;}
}
unless(defined(&XMT_CMD)) {
    sub XMT_CMD () {	0x4;}
}
unless(defined(&TDR_CMD)) {
    sub TDR_CMD () {	0x5;}
}
unless(defined(&DUMP_CMD)) {
    sub DUMP_CMD () {	0x6;}
}
unless(defined(&DIAG_CMD)) {
    sub DIAG_CMD () {	0x7;}
}
unless(defined(&RCV_ENABLE_CMD)) {
    sub RCV_ENABLE_CMD () {	0x8;}
}
unless(defined(&RCV_DISABLE_CMD)) {
    sub RCV_DISABLE_CMD () {	0xa;}
}
unless(defined(&RCV_STOP_CMD)) {
    sub RCV_STOP_CMD () {	0xb;}
}
unless(defined(&RESET_CMD)) {
    sub RESET_CMD () {	0xe;}
}
unless(defined(&TRISTATE_CMD)) {
    sub TRISTATE_CMD () {	0x16;}
}
unless(defined(&NO_TRISTATE_CMD)) {
    sub NO_TRISTATE_CMD () {	0x17;}
}
unless(defined(&POWER_DOWN_CMD)) {
    sub POWER_DOWN_CMD () {	0x18;}
}
unless(defined(&SLEEP_MODE_CMD)) {
    sub SLEEP_MODE_CMD () {	0x19;}
}
unless(defined(&NEGOTIATE_CMD)) {
    sub NEGOTIATE_CMD () {	0x1a;}
}
unless(defined(&RESUME_XMT_CMD)) {
    sub RESUME_XMT_CMD () {	0x1c;}
}
unless(defined(&SEL_RESET_CMD)) {
    sub SEL_RESET_CMD () {	0x1e;}
}
unless(defined(&BANK_SEL)) {
    sub BANK_SEL {
	local($n) = @_;
	eval q(($n<<6));
    }
}
unless(defined(&STATUS_REG)) {
    sub STATUS_REG () {	1;}
}
unless(defined(&RX_STP_INT)) {
    sub RX_STP_INT () {	0x1;}
}
unless(defined(&RX_INT)) {
    sub RX_INT () {	0x2;}
}
unless(defined(&TX_INT)) {
    sub TX_INT () {	0x4;}
}
unless(defined(&EXEC_INT)) {
    sub EXEC_INT () {	0x8;}
}
unless(defined(&EXEC_STATUS)) {
    sub EXEC_STATUS () {	0x30;}
}
unless(defined(&ID_REG)) {
    sub ID_REG () {	2;}
}
unless(defined(&ID_REG_MASK)) {
    sub ID_REG_MASK () {	0x2c;}
}
unless(defined(&ID_REG_SIG)) {
    sub ID_REG_SIG () {	0x24;}
}
unless(defined(&R_ROBIN_BITS)) {
    sub R_ROBIN_BITS () {	0xc0;}
}
unless(defined(&R_ROBIN_SHIFT)) {
    sub R_ROBIN_SHIFT () {	6;}
}
unless(defined(&AUTO_ENABLE)) {
    sub AUTO_ENABLE () {	0x10;}
}
unless(defined(&INT_MASK_REG)) {
    sub INT_MASK_REG () {	3;}
}
unless(defined(&RX_STOP_BIT)) {
    sub RX_STOP_BIT () {	0x1;}
}
unless(defined(&RX_BIT)) {
    sub RX_BIT () {	0x2;}
}
unless(defined(&TX_BIT)) {
    sub TX_BIT () {	0x4;}
}
unless(defined(&EXEC_BIT)) {
    sub EXEC_BIT () {	0x8;}
}
unless(defined(&ALL_INTS)) {
    sub ALL_INTS () {	0xf;}
}
unless(defined(&RCV_START_LOW)) {
    sub RCV_START_LOW () {	4;}
}
unless(defined(&RCV_START_HIGH)) {
    sub RCV_START_HIGH () {	5;}
}
unless(defined(&RCV_STOP_LOW)) {
    sub RCV_STOP_LOW () {	6;}
}
unless(defined(&RCV_STOP_HIGH)) {
    sub RCV_STOP_HIGH () {	7;}
}
unless(defined(&XMT_ADDR_REG)) {
    sub XMT_ADDR_REG () {	0xa;}
}
unless(defined(&HOST_ADDR_REG)) {
    sub HOST_ADDR_REG () {	0xc;}
}
unless(defined(&MEM_PORT_REG)) {
    sub MEM_PORT_REG () {	0xe;}
}
unless(defined(&REG1)) {
    sub REG1 () {	1;}
}
unless(defined(&WORD_WIDTH)) {
    sub WORD_WIDTH () {	0x2;}
}
unless(defined(&INT_ENABLE)) {
    sub INT_ENABLE () {	0x80;}
}
unless(defined(&INT_NO_REG)) {
    sub INT_NO_REG () {	2;}
}
unless(defined(&RCV_LOWER_LIMIT_REG)) {
    sub RCV_LOWER_LIMIT_REG () {	8;}
}
unless(defined(&RCV_UPPER_LIMIT_REG)) {
    sub RCV_UPPER_LIMIT_REG () {	9;}
}
unless(defined(&XMT_LOWER_LIMIT_REG)) {
    sub XMT_LOWER_LIMIT_REG () {	10;}
}
unless(defined(&XMT_UPPER_LIMIT_REG)) {
    sub XMT_UPPER_LIMIT_REG () {	11;}
}
unless(defined(&XMT_CHAIN_INT)) {
    sub XMT_CHAIN_INT () {	0x20;}
}
unless(defined(&XMT_CHAIN_ERRSTOP)) {
    sub XMT_CHAIN_ERRSTOP () {	0x40;}
}
unless(defined(&RCV_DISCARD_BAD)) {
    sub RCV_DISCARD_BAD () {	0x80;}
}
unless(defined(&RECV_MODES_REG)) {
    sub RECV_MODES_REG () {	2;}
}
unless(defined(&PROMISC_MODE)) {
    sub PROMISC_MODE () {	0x1;}
}
unless(defined(&NO_RX_CRC)) {
    sub NO_RX_CRC () {	0x4;}
}
unless(defined(&NO_ADD_INS)) {
    sub NO_ADD_INS () {	0x10;}
}
unless(defined(&MULTI_IA)) {
    sub MULTI_IA () {	0x20;}
}
unless(defined(&MATCH_ID)) {
    sub MATCH_ID () {	( &NO_ADD_INS |  &NO_RX_CRC | 0x2);}
}
unless(defined(&MATCH_ALL)) {
    sub MATCH_ALL () {	( &NO_ADD_INS |  &NO_RX_CRC | 0x1);}
}
unless(defined(&MATCH_BRDCST)) {
    sub MATCH_BRDCST () {	( &NO_ADD_INS |  &NO_RX_CRC);}
}
unless(defined(&MEDIA_SELECT)) {
    sub MEDIA_SELECT () {	3;}
}
unless(defined(&TPE_BIT)) {
    sub TPE_BIT () {	0x4;}
}
unless(defined(&BNC_BIT)) {
    sub BNC_BIT () {	0x20;}
}
unless(defined(&TEST_MODE_MASK)) {
    sub TEST_MODE_MASK () {	0x3f;}
}
unless(defined(&I_ADD)) {
    sub I_ADD {
	local($n) = @_;
	eval q(($n+4));
    }
}
unless(defined(&EEPROM_REG)) {
    sub EEPROM_REG () {	10;}
}
unless(defined(&EEDO)) {
    sub EEDO () {	8;}
}
unless(defined(&EEDI)) {
    sub EEDI () {	4;}
}
unless(defined(&EECS)) {
    sub EECS () {	2;}
}
unless(defined(&EESK)) {
    sub EESK () {	1;}
}
unless(defined(&EEPPW0)) {
    sub EEPPW0 () {	0;}
}
unless(defined(&EEPP_BusWidth)) {
    sub EEPP_BusWidth () {	0x4;}
}
unless(defined(&EEPP_FlashAdrs)) {
    sub EEPP_FlashAdrs () {	0x38;}
}
unless(defined(&EEPP_FLASHTRANSFORM)) {
    sub EEPP_FLASHTRANSFORM () {	{-1, -1, 0xc8000, 0xcc000, 0xd0000, 0xd4000, 0xd8000, 0xdc000};}
}
unless(defined(&EEPP_AutoIO)) {
    sub EEPP_AutoIO () {	0x40;}
}
unless(defined(&EEPP_IOMapping)) {
    sub EEPP_IOMapping () {	0xfc00;}
}
unless(defined(&EEPPW1)) {
    sub EEPPW1 () {	1;}
}
unless(defined(&EEPP_Int)) {
    sub EEPP_Int () {	0x7;}
}
unless(defined(&EEPP_INTMAP)) {
    sub EEPP_INTMAP () {	{3, 5, 9, 10, 11, -1, -1, -1};}
}
unless(defined(&EEPP_RINTMAP)) {
    sub EEPP_RINTMAP () {	{0xff, 0xff, 0x2, 0x, 0xff, 0x1, 0xff, 0xff, 0xff, 0x2, 0x3, 0x4 };}
}
unless(defined(&EEPP_LinkInteg)) {
    sub EEPP_LinkInteg () {	0x8;}
}
unless(defined(&EEPP_PolarCorr)) {
    sub EEPP_PolarCorr () {	0x10;}
}
unless(defined(&EEPP_AuiTpe)) {
    sub EEPP_AuiTpe () {	0x20;}
}
unless(defined(&EEPP_Jabber)) {
    sub EEPP_Jabber () {	0x40;}
}
unless(defined(&EEPP_AutoPort)) {
    sub EEPP_AutoPort () {	0x80;}
}
unless(defined(&EEPP_SmOut)) {
    sub EEPP_SmOut () {	0x100;}
}
unless(defined(&EEPP_BootFls)) {
    sub EEPP_BootFls () {	0x200;}
}
unless(defined(&EEPP_DramSize)) {
    sub EEPP_DramSize () {	0x1000;}
}
unless(defined(&EEPP_AltReady)) {
    sub EEPP_AltReady () {	0x2000;}
}
unless(defined(&EEPPEther2)) {
    sub EEPPEther2 () {	2;}
}
unless(defined(&EEPPEther1)) {
    sub EEPPEther1 () {	3;}
}
unless(defined(&EEPPEther0)) {
    sub EEPPEther0 () {	4;}
}
unless(defined(&EEPPEther2a)) {
    sub EEPPEther2a () {	0x3c;}
}
unless(defined(&EEPPEther1a)) {
    sub EEPPEther1a () {	0x3d;}
}
unless(defined(&EEPPEther0a)) {
    sub EEPPEther0a () {	0x3e;}
}
unless(defined(&EEPPW5)) {
    sub EEPPW5 () {	5;}
}
unless(defined(&EEPP_BncTpe)) {
    sub EEPP_BncTpe () {	0x1;}
}
unless(defined(&EEPP_RomSlct)) {
    sub EEPP_RomSlct () {	0x6;}
}
unless(defined(&EEPP_NumConn)) {
    sub EEPP_NumConn () {	0x8;}
}
unless(defined(&EEPW6)) {
    sub EEPW6 () {	6;}
}
unless(defined(&EEPP_BoardRev)) {
    sub EEPP_BoardRev () {	0xff;}
}
unless(defined(&EEPP_LENGTH)) {
    sub EEPP_LENGTH () {	0x40;}
}
unless(defined(&EEPP_CHKSUM)) {
    sub EEPP_CHKSUM () {	0xbaba;}
}
unless(defined(&I595_XMT_HDRLEN)) {
    sub I595_XMT_HDRLEN () {	8;}
}
unless(defined(&CMD_MASK)) {
    sub CMD_MASK () {	0x1f;}
}
unless(defined(&TX_DONE)) {
    sub TX_DONE () {	0x80;}
}
unless(defined(&CHAIN)) {
    sub CHAIN () {	0x8000;}
}
unless(defined(&XMT_STATUS)) {
    sub XMT_STATUS () {	0x2;}
}
unless(defined(&XMT_CHAIN)) {
    sub XMT_CHAIN () {	0x4;}
}
unless(defined(&XMT_COUNT)) {
    sub XMT_COUNT () {	0x6;}
}
unless(defined(&I595_RCV_HDRLEN)) {
    sub I595_RCV_HDRLEN () {	8;}
}
unless(defined(&RCV_DONE)) {
    sub RCV_DONE () {	0x8;}
}
unless(defined(&RX_OK)) {
    sub RX_OK () {	0x2000;}
}
unless(defined(&RX_ERR)) {
    sub RX_ERR () {	0xd81;}
}
1;
