require '_h2ph_pre.ph';

unless(defined(&_MACHINE_PMAP_H_)) {
    eval 'sub _MACHINE_PMAP_H_ () {1;}' unless defined(&_MACHINE_PMAP_H_);
    require 'machine/pte.ph';
    require 'uvm/uvm_pglist.ph';
    require 'uvm/uvm_object.ph';
    eval 'sub pm_lock () { ($pm_obj->{vmobjlock});}' unless defined(&pm_lock);
    eval 'sub HPPA_MAX_PID () {0xfffa;}' unless defined(&HPPA_MAX_PID);
    eval 'sub HPPA_SID_MAX () {0x7ffd;}' unless defined(&HPPA_SID_MAX);
    eval 'sub HPPA_SID_KERNEL () {0;}' unless defined(&HPPA_SID_KERNEL);
    eval 'sub HPPA_PID_KERNEL () {2;}' unless defined(&HPPA_PID_KERNEL);
    eval 'sub KERNEL_ACCESS_ID () {1;}' unless defined(&KERNEL_ACCESS_ID);
    eval 'sub KERNEL_TEXT_PROT () {( &TLB_AR_KRX | ( &KERNEL_ACCESS_ID << 1));}' unless defined(&KERNEL_TEXT_PROT);
    eval 'sub KERNEL_DATA_PROT () {( &TLB_AR_KRW | ( &KERNEL_ACCESS_ID << 1));}' unless defined(&KERNEL_DATA_PROT);
    if(defined(&_KERNEL)) {
	if(defined( &HP7100LC_CPU) || defined( &HP7300LC_CPU)) {
	}
	eval 'sub PMAP_MAP_POOLPAGE {
	    local($pg) = @_;
    	    eval q(( &VM_PAGE_TO_PHYS($pg)));
	}' unless defined(&PMAP_MAP_POOLPAGE);
	eval 'sub PMAP_UNMAP_POOLPAGE {
	    local($va) = @_;
    	    eval q( &PHYS_TO_VM_PAGE(($va)));
	}' unless defined(&PMAP_UNMAP_POOLPAGE);
	eval 'sub PMAP_PREFER {
	    local($o,$h) = @_;
    	    eval q( &do {  &vaddr_t  &pmap_prefer_hint;  &pmap_prefer_hint = (*($h) &  &HPPA_PGAMASK) | (($o) &  &HPPA_PGAOFF);  &if ( &pmap_prefer_hint < *($h))  &pmap_prefer_hint +=  &HPPA_PGALIAS; *($h) =  &pmap_prefer_hint; }  &while(0));
	}' unless defined(&PMAP_PREFER);
	eval 'sub pmap_sid2pid {
	    local($s) = @_;
    	    eval q(((($s) + 1) << 1));
	}' unless defined(&pmap_sid2pid);
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub pmap_resident_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_update {
	    local($pm) = @_;
    	    eval q(($pm));
	}' unless defined(&pmap_update);
	eval 'sub pmap_copy {
	    local($dpmap,$spmap,$da,$len,$sa) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_clear_modify {
	    local($pg) = @_;
    	    eval q( &pmap_changebit($pg, 0,  &PTE_PROT( &TLB_DIRTY)));
	}' unless defined(&pmap_clear_modify);
	eval 'sub pmap_clear_reference {
	    local($pg) = @_;
    	    eval q( &pmap_changebit($pg,  &PTE_PROT( &TLB_REFTRAP), 0));
	}' unless defined(&pmap_clear_reference);
	eval 'sub pmap_is_modified {
	    local($pg) = @_;
    	    eval q( &pmap_testbit($pg,  &PTE_PROT( &TLB_DIRTY)));
	}' unless defined(&pmap_is_modified);
	eval 'sub pmap_is_referenced {
	    local($pg) = @_;
    	    eval q( &pmap_testbit($pg,  &PTE_PROT( &TLB_REFTRAP)));
	}' unless defined(&pmap_is_referenced);
	eval 'sub pmap_phys_address {
	    local($ppn) = @_;
    	    eval q((($ppn) <<  &PAGE_SHIFT));
	}' unless defined(&pmap_phys_address);
    }
}
1;
