require '_h2ph_pre.ph';

unless(defined(&_HPPA_LOADFILE_MACHDEP_H_)) {
    eval 'sub _HPPA_LOADFILE_MACHDEP_H_ () {1;}' unless defined(&_HPPA_LOADFILE_MACHDEP_H_);
    eval 'sub BOOT_ELF () {1;}' unless defined(&BOOT_ELF);
    eval 'sub LOAD_KERNEL () { &LOAD_ALL;}' unless defined(&LOAD_KERNEL);
    eval 'sub COUNT_KERNEL () { &COUNT_ALL;}' unless defined(&COUNT_KERNEL);
    if(defined(&_STANDALONE)) {
	eval 'sub LOADADDR {
	    local($a) = @_;
    	    eval q((($a) +  &offset));
	}' unless defined(&LOADADDR);
	eval 'sub ALIGNENTRY {
	    local($a) = @_;
    	    eval q(0);
	}' unless defined(&ALIGNENTRY);
	eval 'sub READ {
	    local($f, $b, $c) = @_;
    	    eval q( &pread(,  &LOADADDR($b), ($c)));
	}' unless defined(&READ);
	eval 'sub BCOPY {
	    local($s, $d, $c) = @_;
    	    eval q( &vpbcopy(,  &LOADADDR($d), ($c)));
	}' unless defined(&BCOPY);
	eval 'sub BZERO {
	    local($d, $c) = @_;
    	    eval q( &pbzero( &LOADADDR($d), ($c)));
	}' unless defined(&BZERO);
	eval 'sub WARN {
	    local($a) = @_;
    	    eval q(( &printf $a,  &printf(( &errno ? \\": %s\\\\n\\" : \\"\\\\n\\"),  &strerror( &errno))));
	}' unless defined(&WARN);
	eval 'sub PROGRESS {
	    local($a) = @_;
    	    eval q(  &printf $a);
	}' unless defined(&PROGRESS);
	eval 'sub ALLOC {
	    local($a) = @_;
    	    eval q( &alloc($a));
	}' unless defined(&ALLOC);
	eval 'sub FREE {
	    local($a, $b) = @_;
    	    eval q( &free($a, $b));
	}' unless defined(&FREE);
	eval 'sub vpbcopy () { &bcopy;}' unless defined(&vpbcopy);
	eval 'sub pbzero () { &bzero;}' unless defined(&pbzero);
	eval 'sub pread () { &read;}' unless defined(&pread);
    } else {
	eval 'sub LOADADDR {
	    local($a) = @_;
    	    eval q(((($a)) +  &offset));
	}' unless defined(&LOADADDR);
	eval 'sub ALIGNENTRY {
	    local($a) = @_;
    	    eval q((($a)));
	}' unless defined(&ALIGNENTRY);
	eval 'sub READ {
	    local($f, $b, $c) = @_;
    	    eval q( &read(,  &LOADADDR($b), ($c)));
	}' unless defined(&READ);
	eval 'sub BCOPY {
	    local($s, $d, $c) = @_;
    	    eval q( &memcpy( &LOADADDR, ($s), ($c)));
	}' unless defined(&BCOPY);
	eval 'sub BZERO {
	    local($d, $c) = @_;
    	    eval q( &memset( &LOADADDR($d), 0, ($c)));
	}' unless defined(&BZERO);
	eval 'sub WARN {
	    local($a) = @_;
    	    eval q( &warn $a);
	}' unless defined(&WARN);
	eval 'sub PROGRESS {
	    local($a) = @_;
    	    eval q();
	}' unless defined(&PROGRESS);
	eval 'sub ALLOC {
	    local($a) = @_;
    	    eval q( &malloc($a));
	}' unless defined(&ALLOC);
	eval 'sub FREE {
	    local($a, $b) = @_;
    	    eval q( &free($a));
	}' unless defined(&FREE);
    }
}
1;
