require '_h2ph_pre.ph';

unless(defined(&_MACHINE_INTR_H_)) {
    eval 'sub _MACHINE_INTR_H_ () {1;}' unless defined(&_MACHINE_INTR_H_);
    require 'machine/psl.ph';
    eval 'sub CPU_NINTS () {32;}' unless defined(&CPU_NINTS);
    eval 'sub CPU_INTITMR () {0x80000000;}' unless defined(&CPU_INTITMR);
    eval 'sub NIPL () {16;}' unless defined(&NIPL);
    eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_SOFTCLOCK () {1;}' unless defined(&IPL_SOFTCLOCK);
    eval 'sub IPL_SOFTNET () {2;}' unless defined(&IPL_SOFTNET);
    eval 'sub IPL_BIO () {3;}' unless defined(&IPL_BIO);
    eval 'sub IPL_NET () {4;}' unless defined(&IPL_NET);
    eval 'sub IPL_SOFTTTY () {5;}' unless defined(&IPL_SOFTTTY);
    eval 'sub IPL_TTY () {6;}' unless defined(&IPL_TTY);
    eval 'sub IPL_VM () {7;}' unless defined(&IPL_VM);
    eval 'sub IPL_IMP () { &IPL_VM;}' unless defined(&IPL_IMP);
    eval 'sub IPL_AUDIO () {8;}' unless defined(&IPL_AUDIO);
    eval 'sub IPL_CLOCK () {9;}' unless defined(&IPL_CLOCK);
    eval 'sub IPL_STATCLOCK () {10;}' unless defined(&IPL_STATCLOCK);
    eval 'sub IPL_HIGH () {10;}' unless defined(&IPL_HIGH);
    eval 'sub IPL_NESTED () {11;}' unless defined(&IPL_NESTED);
    eval 'sub IST_NONE () {0;}' unless defined(&IST_NONE);
    eval 'sub IST_PULSE () {1;}' unless defined(&IST_PULSE);
    eval 'sub IST_EDGE () {2;}' unless defined(&IST_EDGE);
    eval 'sub IST_LEVEL () {3;}' unless defined(&IST_LEVEL);
    if(!defined( &_LOCORE)  && defined( &_KERNEL)) {
	if(defined(&DIAGNOSTIC)) {
	    eval 'sub splassert {
	        local($__wantipl) = @_;
    		eval q( &do {  &if ( &__predict_false( &splassert_ctl > 0)) {  &splassert_check($__wantipl,  &__func__); } }  &while (0));
	    }' unless defined(&splassert);
	} else {
	    eval 'sub splassert {
	        local($__wantipl) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&splassert);
	}
	eval 'sub spllowersoftclock () {
	    eval q( &spllower( &IPL_SOFTCLOCK));
	}' unless defined(&spllowersoftclock);
	eval 'sub splsoftclock () {
	    eval q( &splraise( &IPL_SOFTCLOCK));
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splraise( &IPL_SOFTNET));
	}' unless defined(&splsoftnet);
	eval 'sub splbio () {
	    eval q( &splraise( &IPL_BIO));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &splraise( &IPL_NET));
	}' unless defined(&splnet);
	eval 'sub splsofttty () {
	    eval q( &splraise( &IPL_SOFTTTY));
	}' unless defined(&splsofttty);
	eval 'sub spltty () {
	    eval q( &splraise( &IPL_TTY));
	}' unless defined(&spltty);
	eval 'sub splvm () {
	    eval q( &splimp());
	}' unless defined(&splvm);
	eval 'sub splimp () {
	    eval q( &splraise( &IPL_IMP));
	}' unless defined(&splimp);
	eval 'sub splaudio () {
	    eval q( &splraise( &IPL_AUDIO));
	}' unless defined(&splaudio);
	eval 'sub splclock () {
	    eval q( &splraise( &IPL_CLOCK));
	}' unless defined(&splclock);
	eval 'sub splhigh () {
	    eval q( &splraise( &IPL_HIGH));
	}' unless defined(&splhigh);
	eval 'sub splstatclock () {
	    eval q( &splhigh());
	}' unless defined(&splstatclock);
	eval 'sub spl0 () {
	    eval q( &spllower( &IPL_NONE));
	}' unless defined(&spl0);
	eval 'sub SOFTINT_MASK () {((1<< ( &IPL_SOFTCLOCK - 1)) | (1<< ( &IPL_SOFTNET - 1)) | (1<< ( &IPL_SOFTTTY - 1)));}' unless defined(&SOFTINT_MASK);
	eval 'sub setsoftast () {
	    eval q(( &astpending = 1));
	}' unless defined(&setsoftast);
	eval 'sub setsoftclock () {
	    eval q( &softintr(1<< ( &IPL_SOFTCLOCK - 1)));
	}' unless defined(&setsoftclock);
	eval 'sub setsoftnet () {
	    eval q( &softintr(1<< ( &IPL_SOFTNET - 1)));
	}' unless defined(&setsoftnet);
	eval 'sub setsofttty () {
	    eval q( &softintr(1<< ( &IPL_SOFTTTY - 1)));
	}' unless defined(&setsofttty);
    }
}
1;
