require '_h2ph_pre.ph';

unless(defined(&ARIA_IRQ_VALID)) {
    sub ARIA_IRQ_VALID {
	local($irq) = @_;
	eval q((($irq) == 10|| ($irq) == 11|| ($irq) == 12));
    }
}
unless(defined(&ARIA_DRQ_VALID)) {
    sub ARIA_DRQ_VALID {
	local($chan) = @_;
	eval q((($chan) == 5|| ($chan) == 6));
    }
}
unless(defined(&ARIA_BASE_VALID)) {
    sub ARIA_BASE_VALID {
	local($base) = @_;
	eval q((($base) == 0x290 || ($base) == 0x280 || ($base) == 0x2a0 || ($base) == 0x2b0));
    }
}
unless(defined(&ARIADSP_NPORT)) {
    sub ARIADSP_NPORT () {	8;}
}
unless(defined(&ARIADSP_DSPDATA)) {
    sub ARIADSP_DSPDATA () {	0;}
}
unless(defined(&ARIADSP_WRITE)) {
    sub ARIADSP_WRITE () {	0;}
}
unless(defined(&ARIADSP_STATUS)) {
    sub ARIADSP_STATUS () {	2;}
}
unless(defined(&ARIADSP_CONTROL)) {
    sub ARIADSP_CONTROL () {	2;}
}
unless(defined(&ARIADSP_DMAADDRESS)) {
    sub ARIADSP_DMAADDRESS () {	4;}
}
unless(defined(&ARIADSP_DMADATA)) {
    sub ARIADSP_DMADATA () {	6;}
}
unless(defined(&ARIAA_HARDWARE_A)) {
    sub ARIAA_HARDWARE_A () {	0x6050;}
}
unless(defined(&ARIAA_MODEL_A)) {
    sub ARIAA_MODEL_A () {	0x60c3;}
}
unless(defined(&ARIAA_PLAY_FIFO_A)) {
    sub ARIAA_PLAY_FIFO_A () {	0x6100;}
}
unless(defined(&ARIAA_REC_FIFO_A)) {
    sub ARIAA_REC_FIFO_A () {	0x6101;}
}
unless(defined(&ARIAA_TASK_A)) {
    sub ARIAA_TASK_A () {	0x6102;}
}
unless(defined(&ARIAR_PROMETHEUS_KLUDGE)) {
    sub ARIAR_PROMETHEUS_KLUDGE () {	0x1;}
}
unless(defined(&ARIAR_NPOLL)) {
    sub ARIAR_NPOLL () {	30000;}
}
unless(defined(&ARIAR_OPEN_PLAY)) {
    sub ARIAR_OPEN_PLAY () {	0x2;}
}
unless(defined(&ARIAR_OPEN_RECORD)) {
    sub ARIAR_OPEN_RECORD () {	0x1;}
}
unless(defined(&ARIAR_PLAY_CHAN)) {
    sub ARIAR_PLAY_CHAN () {	1;}
}
unless(defined(&ARIAR_RECORD_CHAN)) {
    sub ARIAR_RECORD_CHAN () {	0;}
}
unless(defined(&ARIAR_BUSY)) {
    sub ARIAR_BUSY () {	0x8000;}
}
unless(defined(&ARIAR_ARIA_SYNTH)) {
    sub ARIAR_ARIA_SYNTH () {	0x80;}
}
unless(defined(&ARIAR_SR22K)) {
    sub ARIAR_SR22K () {	0x40;}
}
unless(defined(&ARIAR_DSPINTWR)) {
    sub ARIAR_DSPINTWR () {	0x8;}
}
unless(defined(&ARIAR_PCINTWR)) {
    sub ARIAR_PCINTWR () {	0x2;}
}
unless(defined(&ARIADSPC_SYSINIT)) {
    sub ARIADSPC_SYSINIT () {	0x;}
}
unless(defined(&ARIADSPC_FORMAT)) {
    sub ARIADSPC_FORMAT () {	0x3;}
}
unless(defined(&ARIADSPC_MASTERVOLUME)) {
    sub ARIADSPC_MASTERVOLUME () {	0x4;}
}
unless(defined(&ARIADSPC_BLOCKSIZE)) {
    sub ARIADSPC_BLOCKSIZE () {	0x5;}
}
unless(defined(&ARIADSPC_MODE)) {
    sub ARIADSPC_MODE () {	0x6;}
}
unless(defined(&ARIADSPC_CDVOLUME)) {
    sub ARIADSPC_CDVOLUME () {	0x7;}
}
unless(defined(&ARIADSPC_MICVOLUME)) {
    sub ARIADSPC_MICVOLUME () {	0x8;}
}
unless(defined(&ARIADSPC_MIXERCONFIG)) {
    sub ARIADSPC_MIXERCONFIG () {	0x9;}
}
unless(defined(&ARIADSPC_FORCEINTR)) {
    sub ARIADSPC_FORCEINTR () {	0xa;}
}
unless(defined(&ARIADSPC_TRANSCOMPLETE)) {
    sub ARIADSPC_TRANSCOMPLETE () {	0x10;}
}
unless(defined(&ARIADSPC_START_PLAY)) {
    sub ARIADSPC_START_PLAY () {	0x11;}
}
unless(defined(&ARIADSPC_STOP_PLAY)) {
    sub ARIADSPC_STOP_PLAY () {	0x12;}
}
unless(defined(&ARIADSPC_CHAN_VOL)) {
    sub ARIADSPC_CHAN_VOL () {	0x13;}
}
unless(defined(&ARIADSPC_CHAN_PAN)) {
    sub ARIADSPC_CHAN_PAN () {	0x14;}
}
unless(defined(&ARIADSPC_START_REC)) {
    sub ARIADSPC_START_REC () {	0x15;}
}
unless(defined(&ARIADSPC_STOP_REC)) {
    sub ARIADSPC_STOP_REC () {	0x16;}
}
unless(defined(&ARIADSPC_DAPVOL)) {
    sub ARIADSPC_DAPVOL () {	0x17;}
}
unless(defined(&ARIADSPC_ADCSOURCE)) {
    sub ARIADSPC_ADCSOURCE () {	0x30;}
}
unless(defined(&ARIADSPC_ADCCONTROL)) {
    sub ARIADSPC_ADCCONTROL () {	0x31;}
}
unless(defined(&ARIADSPC_INPMONMODE)) {
    sub ARIADSPC_INPMONMODE () {	0x32;}
}
unless(defined(&ARIADSPC_MASMONMODE)) {
    sub ARIADSPC_MASMONMODE () {	0x33;}
}
unless(defined(&ARIADSPC_MIXERVOL)) {
    sub ARIADSPC_MIXERVOL () {	0x34;}
}
unless(defined(&ARIADSPC_TONE)) {
    sub ARIADSPC_TONE () {	0x35;}
}
unless(defined(&ARIADSPC_TERM)) {
    sub ARIADSPC_TERM () {	0xffff;}
}
unless(defined(&ARIAV_MODE_NO_SYNTH)) {
    sub ARIAV_MODE_NO_SYNTH () {	0x;}
}
unless(defined(&ARIAMIX_MIC_LVL)) {
    sub ARIAMIX_MIC_LVL () {	0;}
}
unless(defined(&ARIAMIX_LINE_IN_LVL)) {
    sub ARIAMIX_LINE_IN_LVL () {	1;}
}
unless(defined(&ARIAMIX_CD_LVL)) {
    sub ARIAMIX_CD_LVL () {	2;}
}
unless(defined(&ARIAMIX_DAC_LVL)) {
    sub ARIAMIX_DAC_LVL () {	3;}
}
unless(defined(&ARIAMIX_TEL_LVL)) {
    sub ARIAMIX_TEL_LVL () {	4;}
}
unless(defined(&ARIAMIX_AUX_LVL)) {
    sub ARIAMIX_AUX_LVL () {	5;}
}
unless(defined(&ARIAMIX_MASTER_LVL)) {
    sub ARIAMIX_MASTER_LVL () {	6;}
}
unless(defined(&ARIAMIX_MASTER_TREBLE)) {
    sub ARIAMIX_MASTER_TREBLE () {	7;}
}
unless(defined(&ARIAMIX_MASTER_BASS)) {
    sub ARIAMIX_MASTER_BASS () {	8;}
}
unless(defined(&ARIAMIX_RECORD_SOURCE)) {
    sub ARIAMIX_RECORD_SOURCE () {	9;}
}
unless(defined(&ARIAMIX_MIC_MUTE)) {
    sub ARIAMIX_MIC_MUTE () {	10;}
}
unless(defined(&ARIAMIX_LINE_IN_MUTE)) {
    sub ARIAMIX_LINE_IN_MUTE () {	11;}
}
unless(defined(&ARIAMIX_CD_MUTE)) {
    sub ARIAMIX_CD_MUTE () {	12;}
}
unless(defined(&ARIAMIX_DAC_MUTE)) {
    sub ARIAMIX_DAC_MUTE () {	13;}
}
unless(defined(&ARIAMIX_TEL_MUTE)) {
    sub ARIAMIX_TEL_MUTE () {	14;}
}
unless(defined(&ARIAMIX_AUX_MUTE)) {
    sub ARIAMIX_AUX_MUTE () {	15;}
}
unless(defined(&ARIAMIX_OUT_LVL)) {
    sub ARIAMIX_OUT_LVL () {	16;}
}
unless(defined(&ARIAMIX_OUTPUT_CLASS)) {
    sub ARIAMIX_OUTPUT_CLASS () {	17;}
}
unless(defined(&ARIAMIX_INPUT_CLASS)) {
    sub ARIAMIX_INPUT_CLASS () {	18;}
}
unless(defined(&ARIAMIX_RECORD_CLASS)) {
    sub ARIAMIX_RECORD_CLASS () {	19;}
}
unless(defined(&ARIAMIX_EQ_CLASS)) {
    sub ARIAMIX_EQ_CLASS () {	20;}
}
1;
