require '_h2ph_pre.ph';

unless(defined(&RLN_REG_DATA)) {
    sub RLN_REG_DATA () {	0;}
}
unless(defined(&RLN_REG_STATUS)) {
    sub RLN_REG_STATUS () {	2;}
}
unless(defined(&RLN_REG_CONTROL)) {
    sub RLN_REG_CONTROL () {	4;}
}
unless(defined(&RLN_REG_EOI)) {
    sub RLN_REG_EOI () {	5;}
}
unless(defined(&RLN_REG_INTSEL)) {
    sub RLN_REG_INTSEL () {	6;}
}
unless(defined(&RLN_NPORTS)) {
    sub RLN_NPORTS () {	8;}
}
unless(defined(&_rln_regacc_delay)) {
    sub _rln_regacc_delay () {
	eval q( &bus_space_read_1( &I386_BUS_SPACE_IO, 0, 0x61));
    }
}
unless(defined(&rln_data_write_1)) {
    sub rln_data_write_1 {
	local($sc, $value) = @_;
	eval q( &_rln_register_write_1($sc,  &RLN_REG_DATA, ($value)));
    }
}
unless(defined(&rln_data_read_1)) {
    sub rln_data_read_1 {
	local($sc) = @_;
	eval q( &_rln_register_read_1($sc,  &RLN_REG_DATA));
    }
}
unless(defined(&rln_data_write_multi_1)) {
    sub rln_data_write_multi_1 {
	local($sc, $buf, $len) = @_;
	eval q( &bus_space_write_multi_1(($sc)-> &sc_iot, ($sc)-> &sc_ioh,  &RLN_REG_DATA, ($buf), ($len)));
    }
}
unless(defined(&rln_data_read_multi_1)) {
    sub rln_data_read_multi_1 {
	local($sc, $buf, $len) = @_;
	eval q( &bus_space_read_multi_1(($sc)-> &sc_iot, ($sc)-> &sc_ioh,  &RLN_REG_DATA, ($buf), ($len)));
    }
}
unless(defined(&rln_data_write_2)) {
    sub rln_data_write_2 {
	local($sc, $value) = @_;
	eval q( &_rln_register_write_2($sc,  &RLN_REG_DATA, ($value)));
    }
}
unless(defined(&rln_data_read_2)) {
    sub rln_data_read_2 {
	local($sc) = @_;
	eval q( &_rln_register_read_2($sc,  &RLN_REG_DATA));
    }
}
unless(defined(&rln_data_write_multi_2)) {
    sub rln_data_write_multi_2 {
	local($sc, $buf, $len) = @_;
	eval q( &bus_space_write_multi_2(($sc)-> &sc_iot, ($sc)-> &sc_ioh,  &RLN_REG_DATA, ($buf), ($len)));
    }
}
unless(defined(&rln_data_read_multi_2)) {
    sub rln_data_read_multi_2 {
	local($sc, $buf, $len) = @_;
	eval q( &bus_space_read_multi_2(($sc)-> &sc_iot, ($sc)-> &sc_ioh,  &RLN_REG_DATA, ($buf), ($len)));
    }
}
unless(defined(&RLN_STATUS_CLRNAK)) {
    sub RLN_STATUS_CLRNAK () {	0x8;}
}
unless(defined(&RLN_STATUS_WAKEUP)) {
    sub RLN_STATUS_WAKEUP () {	0x80;}
}
unless(defined(&RLN_STATUS_TX_IDLE)) {
    sub RLN_STATUS_TX_IDLE () {	0x;}
}
unless(defined(&RLN_STATUS_TX_HILEN_AVAIL)) {
    sub RLN_STATUS_TX_HILEN_AVAIL () {	0x1;}
}
unless(defined(&RLN_STATUS_TX_HILEN_ACCEPT)) {
    sub RLN_STATUS_TX_HILEN_ACCEPT () {	0x2;}
}
unless(defined(&RLN_STATUS_TX_XFR_COMPLETE)) {
    sub RLN_STATUS_TX_XFR_COMPLETE () {	0x3;}
}
unless(defined(&RLN_STATUS_TX_XFR)) {
    sub RLN_STATUS_TX_XFR () {	0x4;}
}
unless(defined(&RLN_STATUS_TX_ERROR)) {
    sub RLN_STATUS_TX_ERROR () {	0x5;}
}
unless(defined(&RLN_STATUS_TX_LOLEN_AVAIL)) {
    sub RLN_STATUS_TX_LOLEN_AVAIL () {	0x6;}
}
unless(defined(&RLN_STATUS_TX_LOLEN_ACCEPT)) {
    sub RLN_STATUS_TX_LOLEN_ACCEPT () {	0x7;}
}
unless(defined(&RLN_STATUS_TX_MASK)) {
    sub RLN_STATUS_TX_MASK () {	0xf;}
}
unless(defined(&RLN_STATUS_RX_IDLE)) {
    sub RLN_STATUS_RX_IDLE () {	0x;}
}
unless(defined(&RLN_STATUS_RX_HILEN_AVAIL)) {
    sub RLN_STATUS_RX_HILEN_AVAIL () {	0x10;}
}
unless(defined(&RLN_STATUS_RX_HILEN_ACCEPT)) {
    sub RLN_STATUS_RX_HILEN_ACCEPT () {	0x20;}
}
unless(defined(&RLN_STATUS_RX_XFR_COMPLETE)) {
    sub RLN_STATUS_RX_XFR_COMPLETE () {	0x30;}
}
unless(defined(&RLN_STATUS_RX_XFR)) {
    sub RLN_STATUS_RX_XFR () {	0x40;}
}
unless(defined(&RLN_STATUS_RX_ERROR)) {
    sub RLN_STATUS_RX_ERROR () {	0x50;}
}
unless(defined(&RLN_STATUS_RX_LOLEN_AVAIL)) {
    sub RLN_STATUS_RX_LOLEN_AVAIL () {	0x60;}
}
unless(defined(&RLN_STATUS_RX_LOLEN_ACCEPT)) {
    sub RLN_STATUS_RX_LOLEN_ACCEPT () {	0x70;}
}
unless(defined(&RLN_STATUS_RX_MASK)) {
    sub RLN_STATUS_RX_MASK () {	0x70;}
}
unless(defined(&rln_status_write)) {
    sub rln_status_write {
	local($sc, $value) = @_;
	eval q( &_rln_register_write_1($sc,  &RLN_REG_STATUS, ($value)));
    }
}
unless(defined(&rln_status_set)) {
    sub rln_status_set {
	local($sc, $bits) = @_;
	eval q( &rln_status_write($sc, ($sc)-> &sc_status |= ($bits)));
    }
}
unless(defined(&rln_status_clear)) {
    sub rln_status_clear {
	local($sc, $bits) = @_;
	eval q( &rln_status_write($sc, ($sc)-> &sc_status &= ~($bits)));
    }
}
unless(defined(&_rln_status_setmask)) {
    sub _rln_status_setmask {
	local($sc, $mask, $bits) = @_;
	eval q( &do { 'int'  &_s;  &_s =  &splhigh(); ($sc)-> &sc_status = (($sc)-> &sc_status & ($mask)) | ($bits);  &rln_status_write($sc, ($sc)-> &sc_status);  &splx( &_s); }  &while (0););
    }
}
unless(defined(&rln_status_rx_write)) {
    sub rln_status_rx_write {
	local($sc, $state) = @_;
	eval q( &_rln_status_setmask(($sc), ~ &RLN_STATUS_RX_MASK, $state));
    }
}
unless(defined(&rln_status_tx_write)) {
    sub rln_status_tx_write {
	local($sc, $state) = @_;
	eval q( &_rln_status_setmask(($sc), ~ &RLN_STATUS_TX_MASK, $state));
    }
}
unless(defined(&rln_status_read)) {
    sub rln_status_read {
	local($sc) = @_;
	eval q( &_rln_register_read_1($sc,  &RLN_REG_STATUS));
    }
}
unless(defined(&rln_status_rx_read)) {
    sub rln_status_rx_read {
	local($sc) = @_;
	eval q(( &rln_status_read($sc) & ~ &RLN_STATUS_TX_MASK));
    }
}
unless(defined(&rln_status_tx_read)) {
    sub rln_status_tx_read {
	local($sc) = @_;
	eval q(( &rln_status_read($sc) & ~ &RLN_STATUS_RX_MASK));
    }
}
unless(defined(&rln_status_tx_int)) {
    sub rln_status_tx_int {
	local($sc) = @_;
	eval q( &do { 'int'  &_s =  &splhigh();  &rln_control_clear($sc,  &RLN_CONTROL_TXINT);  &rln_control_set($sc,  &RLN_CONTROL_TXINT);  &splx( &_s); }  &while (0));
    }
}
unless(defined(&rln_status_rx_int)) {
    sub rln_status_rx_int {
	local($sc) = @_;
	eval q( &do { 'int'  &_s =  &splhigh();  &rln_control_clear($sc,  &RLN_CONTROL_RXINT);  &rln_control_set($sc,  &RLN_CONTROL_RXINT);  &splx( &_s); }  &while (0));
    }
}
unless(defined(&RLN_CONTROL_RXINT)) {
    sub RLN_CONTROL_RXINT () {	0x1;}
}
unless(defined(&RLN_CONTROL_TXINT)) {
    sub RLN_CONTROL_TXINT () {	0x2;}
}
unless(defined(&RLN_CONTROL_BIT2)) {
    sub RLN_CONTROL_BIT2 () {	0x4;}
}
unless(defined(&RLN_CONTROL_BIT3)) {
    sub RLN_CONTROL_BIT3 () {	0x8;}
}
unless(defined(&RLN_CONTROL_RESET)) {
    sub RLN_CONTROL_RESET () {	0x10;}
}
unless(defined(&RLN_CONTROL_16BIT)) {
    sub RLN_CONTROL_16BIT () {	0x20;}
}
unless(defined(&RLN_CONTROL_MASK)) {
    sub RLN_CONTROL_MASK () {	0x3f;}
}
unless(defined(&rln_control_write)) {
    sub rln_control_write {
	local($sc, $value) = @_;
	eval q( &_rln_register_write_1($sc,  &RLN_REG_CONTROL, ($sc)-> &sc_control = ($value)));
    }
}
unless(defined(&rln_control_read)) {
    sub rln_control_read {
	local($sc) = @_;
	eval q( &_rln_register_read_1($sc,  &RLN_REG_CONTROL));
    }
}
unless(defined(&rln_control_set)) {
    sub rln_control_set {
	local($sc, $bits) = @_;
	eval q( &rln_control_write($sc, ($sc)-> &sc_control | ($bits)));
    }
}
unless(defined(&rln_control_clear)) {
    sub rln_control_clear {
	local($sc, $bits) = @_;
	eval q( &rln_control_write($sc, ($sc)-> &sc_control & ~($bits)));
    }
}
unless(defined(&rln_control_outofstandby)) {
    sub rln_control_outofstandby {
	local($sc) = @_;
	eval q( &do {  &rln_control_write($sc, ($sc)-> &sc_control |  &RLN_CONTROL_RESET);  &DELAY(30000);  &rln_control_write($sc, ($sc)-> &sc_control); }  &while (0));
    }
}
unless(defined(&RLN_INTSEL_IRQMASK)) {
    sub RLN_INTSEL_IRQMASK () {	0x7;}
}
unless(defined(&RLN_INTSEL_ENABLE)) {
    sub RLN_INTSEL_ENABLE () {	0x10;}
}
unless(defined(&RLN_INTSEL_BIT7)) {
    sub RLN_INTSEL_BIT7 () {	0x80;}
}
unless(defined(&rln_intsel_disable)) {
    sub rln_intsel_disable {
	local($sc) = @_;
	eval q( &do { 'int'  &_s;  &_s =  &splhigh();  &_rln_register_write_1($sc,  &RLN_REG_INTSEL, ($sc)-> &sc_intsel &= ~ &RLN_INTSEL_ENABLE);  &splx( &_s); }  &while (0));
    }
}
unless(defined(&rln_intsel_enable)) {
    sub rln_intsel_enable {
	local($sc) = @_;
	eval q( &do { 'int'  &_s;  &_s =  &splhigh();  &_rln_register_write_1($sc,  &RLN_REG_INTSEL, ($sc)-> &sc_intsel |=  &RLN_INTSEL_ENABLE);  &splx( &_s); }  &while (0));
    }
}
unless(defined(&rln_intsel_write)) {
    sub rln_intsel_write {
	local($sc, $value) = @_;
	eval q( &_rln_register_write_1($sc,  &RLN_REG_INTSEL, ($sc)-> &sc_intsel |= ($value)));
    }
}
unless(defined(&rln_eoi)) {
    sub rln_eoi {
	local($sc) = @_;
	eval q(  &_rln_register_read_1($sc,  &RLN_REG_EOI));
    }
}
1;
