require '_h2ph_pre.ph';

unless(defined(&_NET_PFVAR_H_)) {
    eval 'sub _NET_PFVAR_H_ () {1;}' unless defined(&_NET_PFVAR_H_);
    require 'sys/types.ph';
    require 'sys/queue.ph';
    require 'sys/tree.ph';
    require 'net/radix.ph';
    require 'netinet/ip_ipsp.ph';
    require 'netinet/tcp_fsm.ph';
    eval 'sub PF_TCPS_PROXY_SRC () {(( &TCP_NSTATES)+0);}' unless defined(&PF_TCPS_PROXY_SRC);
    eval 'sub PF_TCPS_PROXY_DST () {(( &TCP_NSTATES)+1);}' unless defined(&PF_TCPS_PROXY_DST);
    eval("sub PF_INOUT () { 0; }") unless defined(&PF_INOUT);
    eval("sub PF_IN () { 1; }") unless defined(&PF_IN);
    eval("sub PF_OUT () { 2; }") unless defined(&PF_OUT);
    eval("sub PF_PASS () { 0; }") unless defined(&PF_PASS);
    eval("sub PF_DROP () { 1; }") unless defined(&PF_DROP);
    eval("sub PF_SCRUB () { 2; }") unless defined(&PF_SCRUB);
    eval("sub PF_NAT () { 3; }") unless defined(&PF_NAT);
    eval("sub PF_NONAT () { 4; }") unless defined(&PF_NONAT);
    eval("sub PF_BINAT () { 5; }") unless defined(&PF_BINAT);
    eval("sub PF_NOBINAT () { 6; }") unless defined(&PF_NOBINAT);
    eval("sub PF_RDR () { 7; }") unless defined(&PF_RDR);
    eval("sub PF_NORDR () { 8; }") unless defined(&PF_NORDR);
    eval("sub PF_SYNPROXY_DROP () { 9; }") unless defined(&PF_SYNPROXY_DROP);
    eval("sub PF_RULESET_SCRUB () { 0; }") unless defined(&PF_RULESET_SCRUB);
    eval("sub PF_RULESET_FILTER () { 1; }") unless defined(&PF_RULESET_FILTER);
    eval("sub PF_RULESET_NAT () { 2; }") unless defined(&PF_RULESET_NAT);
    eval("sub PF_RULESET_BINAT () { 3; }") unless defined(&PF_RULESET_BINAT);
    eval("sub PF_RULESET_RDR () { 4; }") unless defined(&PF_RULESET_RDR);
    eval("sub PF_RULESET_MAX () { 5; }") unless defined(&PF_RULESET_MAX);
    eval("sub PF_OP_NONE () { 0; }") unless defined(&PF_OP_NONE);
    eval("sub PF_OP_IRG () { 1; }") unless defined(&PF_OP_IRG);
    eval("sub PF_OP_EQ () { 2; }") unless defined(&PF_OP_EQ);
    eval("sub PF_OP_NE () { 3; }") unless defined(&PF_OP_NE);
    eval("sub PF_OP_LT () { 4; }") unless defined(&PF_OP_LT);
    eval("sub PF_OP_LE () { 5; }") unless defined(&PF_OP_LE);
    eval("sub PF_OP_GT () { 6; }") unless defined(&PF_OP_GT);
    eval("sub PF_OP_GE () { 7; }") unless defined(&PF_OP_GE);
    eval("sub PF_OP_XRG () { 8; }") unless defined(&PF_OP_XRG);
    eval("sub PF_OP_RRG () { 9; }") unless defined(&PF_OP_RRG);
    eval("sub PF_DEBUG_NONE () { 0; }") unless defined(&PF_DEBUG_NONE);
    eval("sub PF_DEBUG_URGENT () { 1; }") unless defined(&PF_DEBUG_URGENT);
    eval("sub PF_DEBUG_MISC () { 2; }") unless defined(&PF_DEBUG_MISC);
    eval("sub PF_DEBUG_NOISY () { 3; }") unless defined(&PF_DEBUG_NOISY);
    eval("sub PF_CHANGE_NONE () { 0; }") unless defined(&PF_CHANGE_NONE);
    eval("sub PF_CHANGE_ADD_HEAD () { 1; }") unless defined(&PF_CHANGE_ADD_HEAD);
    eval("sub PF_CHANGE_ADD_TAIL () { 2; }") unless defined(&PF_CHANGE_ADD_TAIL);
    eval("sub PF_CHANGE_ADD_BEFORE () { 3; }") unless defined(&PF_CHANGE_ADD_BEFORE);
    eval("sub PF_CHANGE_ADD_AFTER () { 4; }") unless defined(&PF_CHANGE_ADD_AFTER);
    eval("sub PF_CHANGE_REMOVE () { 5; }") unless defined(&PF_CHANGE_REMOVE);
    eval("sub PF_CHANGE_GET_TICKET () { 6; }") unless defined(&PF_CHANGE_GET_TICKET);
    eval("sub PFTM_TCP_FIRST_PACKET () { 0; }") unless defined(&PFTM_TCP_FIRST_PACKET);
    eval("sub PFTM_TCP_OPENING () { 1; }") unless defined(&PFTM_TCP_OPENING);
    eval("sub PFTM_TCP_ESTABLISHED () { 2; }") unless defined(&PFTM_TCP_ESTABLISHED);
    eval("sub PFTM_TCP_CLOSING () { 3; }") unless defined(&PFTM_TCP_CLOSING);
    eval("sub PFTM_TCP_FIN_WAIT () { 4; }") unless defined(&PFTM_TCP_FIN_WAIT);
    eval("sub PFTM_TCP_CLOSED () { 5; }") unless defined(&PFTM_TCP_CLOSED);
    eval("sub PFTM_UDP_FIRST_PACKET () { 6; }") unless defined(&PFTM_UDP_FIRST_PACKET);
    eval("sub PFTM_UDP_SINGLE () { 7; }") unless defined(&PFTM_UDP_SINGLE);
    eval("sub PFTM_UDP_MULTIPLE () { 8; }") unless defined(&PFTM_UDP_MULTIPLE);
    eval("sub PFTM_ICMP_FIRST_PACKET () { 9; }") unless defined(&PFTM_ICMP_FIRST_PACKET);
    eval("sub PFTM_ICMP_ERROR_REPLY () { 10; }") unless defined(&PFTM_ICMP_ERROR_REPLY);
    eval("sub PFTM_OTHER_FIRST_PACKET () { 11; }") unless defined(&PFTM_OTHER_FIRST_PACKET);
    eval("sub PFTM_OTHER_SINGLE () { 12; }") unless defined(&PFTM_OTHER_SINGLE);
    eval("sub PFTM_OTHER_MULTIPLE () { 13; }") unless defined(&PFTM_OTHER_MULTIPLE);
    eval("sub PFTM_FRAG () { 14; }") unless defined(&PFTM_FRAG);
    eval("sub PFTM_INTERVAL () { 15; }") unless defined(&PFTM_INTERVAL);
    eval("sub PFTM_ADAPTIVE_START () { 16; }") unless defined(&PFTM_ADAPTIVE_START);
    eval("sub PFTM_ADAPTIVE_END () { 17; }") unless defined(&PFTM_ADAPTIVE_END);
    eval("sub PFTM_MAX () { 18; }") unless defined(&PFTM_MAX);
    eval("sub PFTM_PURGE () { 19; }") unless defined(&PFTM_PURGE);
    eval("sub PFTM_UNTIL_PACKET () { 20; }") unless defined(&PFTM_UNTIL_PACKET);
    eval("sub PF_NOPFROUTE () { 0; }") unless defined(&PF_NOPFROUTE);
    eval("sub PF_FASTROUTE () { 1; }") unless defined(&PF_FASTROUTE);
    eval("sub PF_ROUTETO () { 2; }") unless defined(&PF_ROUTETO);
    eval("sub PF_DUPTO () { 3; }") unless defined(&PF_DUPTO);
    eval("sub PF_REPLYTO () { 4; }") unless defined(&PF_REPLYTO);
    eval("sub PF_LIMIT_STATES () { 0; }") unless defined(&PF_LIMIT_STATES);
    eval("sub PF_LIMIT_FRAGS () { 1; }") unless defined(&PF_LIMIT_FRAGS);
    eval("sub PF_LIMIT_MAX () { 2; }") unless defined(&PF_LIMIT_MAX);
    eval 'sub PF_POOL_IDMASK () {0xf;}' unless defined(&PF_POOL_IDMASK);
    eval("sub PF_POOL_NONE () { 0; }") unless defined(&PF_POOL_NONE);
    eval("sub PF_POOL_BITMASK () { 1; }") unless defined(&PF_POOL_BITMASK);
    eval("sub PF_POOL_RANDOM () { 2; }") unless defined(&PF_POOL_RANDOM);
    eval("sub PF_POOL_SRCHASH () { 3; }") unless defined(&PF_POOL_SRCHASH);
    eval("sub PF_POOL_ROUNDROBIN () { 4; }") unless defined(&PF_POOL_ROUNDROBIN);
    eval("sub PF_ADDR_ADDRMASK () { 0; }") unless defined(&PF_ADDR_ADDRMASK);
    eval("sub PF_ADDR_NOROUTE () { 1; }") unless defined(&PF_ADDR_NOROUTE);
    eval("sub PF_ADDR_DYNIFTL () { 2; }") unless defined(&PF_ADDR_DYNIFTL);
    eval("sub PF_ADDR_TABLE () { 3; }") unless defined(&PF_ADDR_TABLE);
    eval 'sub PF_POOL_TYPEMASK () {0xf;}' unless defined(&PF_POOL_TYPEMASK);
    eval 'sub PF_WSCALE_FLAG () {0x80;}' unless defined(&PF_WSCALE_FLAG);
    eval 'sub PF_WSCALE_MASK () {0xf;}' unless defined(&PF_WSCALE_MASK);
    eval 'sub v4 () { ($pfa->{v4});}' unless defined(&v4);
    eval 'sub v6 () { ($pfa->{v6});}' unless defined(&v6);
    eval 'sub addr8 () { ($pfa->{addr8});}' unless defined(&addr8);
    eval 'sub addr16 () { ($pfa->{addr16});}' unless defined(&addr16);
    eval 'sub addr32 () { ($pfa->{addr32});}' unless defined(&addr32);
    eval 'sub PF_TABLE_NAME_SIZE () {32;}' unless defined(&PF_TABLE_NAME_SIZE);
    if(defined(&_KERNEL)) {
	if(defined(&INET)) {
	    unless(defined(&INET6)) {
		eval 'sub PF_INET_ONLY () {1;}' unless defined(&PF_INET_ONLY);
	    }
	}
	if(defined(&INET6)) {
	    unless(defined(&INET)) {
		eval 'sub PF_INET6_ONLY () {1;}' unless defined(&PF_INET6_ONLY);
	    }
	}
	if(defined(&INET)) {
	    if(defined(&INET6)) {
		eval 'sub PF_INET_INET6 () {1;}' unless defined(&PF_INET_INET6);
	    }
	}
    } else {
	eval 'sub PF_INET_INET6 () {1;}' unless defined(&PF_INET_INET6);
    }
    if(defined(&PF_INET_INET6)) {
	eval 'sub PF_AEQ {
	    local($a, $b, $c) = @_;
    	    eval q((($c ==  &AF_INET  && ($a)-> $addr32[0] == ($b)-> $addr32[0]) || (($a)-> $addr32[3] == ($b)-> $addr32[3]  && ($a)-> $addr32[2] == ($b)-> $addr32[2]  && ($a)-> $addr32[1] == ($b)-> $addr32[1]  && ($a)-> $addr32[0] == ($b)-> $addr32[0])));
	}' unless defined(&PF_AEQ);
	eval 'sub PF_ANEQ {
	    local($a, $b, $c) = @_;
    	    eval q((($c ==  &AF_INET  && ($a)-> $addr32[0] != ($b)-> $addr32[0]) || (($a)-> $addr32[3] != ($b)-> $addr32[3] || ($a)-> $addr32[2] != ($b)-> $addr32[2] || ($a)-> $addr32[1] != ($b)-> $addr32[1] || ($a)-> $addr32[0] != ($b)-> $addr32[0])));
	}' unless defined(&PF_ANEQ);
	eval 'sub PF_AZERO {
	    local($a, $c) = @_;
    	    eval q((($c ==  &AF_INET  && !($a)-> $addr32[0]) || (!($a)-> $addr32[0]  && !($a)-> $addr32[1]  && !($a)-> $addr32[2]  && !($a)-> $addr32[3] )));
	}' unless defined(&PF_AZERO);
	eval 'sub PF_MATCHA {
	    local($n, $a, $m, $b, $f) = @_;
    	    eval q( &pf_match_addr($n, $a, $m, $b, $f));
	}' unless defined(&PF_MATCHA);
	eval 'sub PF_ACPY {
	    local($a, $b, $f) = @_;
    	    eval q( &pf_addrcpy($a, $b, $f));
	}' unless defined(&PF_ACPY);
	eval 'sub PF_AINC {
	    local($a, $f) = @_;
    	    eval q( &pf_addr_inc($a, $f));
	}' unless defined(&PF_AINC);
	eval 'sub PF_POOLMASK {
	    local($a, $b, $c, $d, $f) = @_;
    	    eval q( &pf_poolmask($a, $b, $c, $d, $f));
	}' unless defined(&PF_POOLMASK);
    } else {
	if(defined(&PF_INET6_ONLY)) {
	    eval 'sub PF_AEQ {
	        local($a, $b, $c) = @_;
    		eval q((($a)-> $addr32[3] == ($b)-> $addr32[3]  && ($a)-> $addr32[2] == ($b)-> $addr32[2]  && ($a)-> $addr32[1] == ($b)-> $addr32[1]  && ($a)-> $addr32[0] == ($b)-> $addr32[0]));
	    }' unless defined(&PF_AEQ);
	    eval 'sub PF_ANEQ {
	        local($a, $b, $c) = @_;
    		eval q((($a)-> $addr32[3] != ($b)-> $addr32[3] || ($a)-> $addr32[2] != ($b)-> $addr32[2] || ($a)-> $addr32[1] != ($b)-> $addr32[1] || ($a)-> $addr32[0] != ($b)-> $addr32[0]));
	    }' unless defined(&PF_ANEQ);
	    eval 'sub PF_AZERO {
	        local($a, $c) = @_;
    		eval q((!($a)-> $addr32[0]  && !($a)-> $addr32[1]  && !($a)-> $addr32[2]  && !($a)-> $addr32[3] ));
	    }' unless defined(&PF_AZERO);
	    eval 'sub PF_MATCHA {
	        local($n, $a, $m, $b, $f) = @_;
    		eval q( &pf_match_addr($n, $a, $m, $b, $f));
	    }' unless defined(&PF_MATCHA);
	    eval 'sub PF_ACPY {
	        local($a, $b, $f) = @_;
    		eval q( &pf_addrcpy($a, $b, $f));
	    }' unless defined(&PF_ACPY);
	    eval 'sub PF_AINC {
	        local($a, $f) = @_;
    		eval q( &pf_addr_inc($a, $f));
	    }' unless defined(&PF_AINC);
	    eval 'sub PF_POOLMASK {
	        local($a, $b, $c, $d, $f) = @_;
    		eval q( &pf_poolmask($a, $b, $c, $d, $f));
	    }' unless defined(&PF_POOLMASK);
	} else {
	    if(defined(&PF_INET_ONLY)) {
		eval 'sub PF_AEQ {
		    local($a, $b, $c) = @_;
    		    eval q((($a)-> $addr32[0] == ($b)-> $addr32[0]));
		}' unless defined(&PF_AEQ);
		eval 'sub PF_ANEQ {
		    local($a, $b, $c) = @_;
    		    eval q((($a)-> $addr32[0] != ($b)-> $addr32[0]));
		}' unless defined(&PF_ANEQ);
		eval 'sub PF_AZERO {
		    local($a, $c) = @_;
    		    eval q((!($a)-> $addr32[0]));
		}' unless defined(&PF_AZERO);
		eval 'sub PF_MATCHA {
		    local($n, $a, $m, $b, $f) = @_;
    		    eval q( &pf_match_addr($n, $a, $m, $b, $f));
		}' unless defined(&PF_MATCHA);
		eval 'sub PF_ACPY {
		    local($a, $b, $f) = @_;
    		    eval q(($a)-> ($v4->{s_addr}) = ($b)-> ($v4->{s_addr}));
		}' unless defined(&PF_ACPY);
		eval 'sub PF_AINC {
		    local($a, $f) = @_;
    		    eval q( &do { ($a)-> $addr32[0] =  &htonl( &ntohl(($a)-> $addr32[0]) + 1); }  &while (0));
		}' unless defined(&PF_AINC);
		eval 'sub PF_POOLMASK {
		    local($a, $b, $c, $d, $f) = @_;
    		    eval q( &do { ($a)-> $addr32[0] = (($b)-> $addr32[0] & ($c)-> $addr32[0]) | ((($c)-> $addr32[0] ^ 0xffffffff ) & ($d)-> $addr32[0]); }  &while (0));
		}' unless defined(&PF_POOLMASK);
	    }
	}
    }
    eval 'sub PF_MISMATCHAW {
        local($aw, $x, $af, $not) = @_;
	    eval q(( ((($aw)-> &type ==  &PF_ADDR_NOROUTE  &&  &pf_routable(($x), ($af))) || (($aw)-> &type ==  &PF_ADDR_TABLE  && ! &pfr_match_addr(($aw)-> ($p->{tbl}), ($x), ($af))) || (($aw)-> &type ==  &PF_ADDR_DYNIFTL  && (($aw)-> ($p->{dyn}->{undefined}) || (! &PF_AZERO(($aw)-> ($v->{a}->{mask}), ($af))  && ! &PF_MATCHA(0, ($aw)-> ($v->{a}->{addr}), ($aw)-> ($v->{a}->{mask}), ($x), ($af))))) || (($aw)-> &type ==  &PF_ADDR_ADDRMASK  && ! &PF_AZERO(($aw)-> ($v->{a}->{mask}), ($af))  && ! &PF_MATCHA(0, ($aw)-> ($v->{a}->{addr}), ($aw)-> ($v->{a}->{mask}), ($x), ($af)))) != ($not) ));
    }' unless defined(&PF_MISMATCHAW);
    eval 'sub key8 () { ($pfk->{key8});}' unless defined(&key8);
    eval 'sub key16 () { ($pfk->{key16});}' unless defined(&key16);
    eval 'sub key32 () { ($pfk->{key32});}' unless defined(&key32);
    eval 'sub PF_OSFP_ANY () {(0);}' unless defined(&PF_OSFP_ANY);
    eval 'sub PF_OSFP_UNKNOWN () {(( &pf_osfp_t)-1);}' unless defined(&PF_OSFP_UNKNOWN);
    eval 'sub PF_OSFP_NOMATCH () {(( &pf_osfp_t)-2);}' unless defined(&PF_OSFP_NOMATCH);
    eval 'sub PF_OSFP_EXPANDED () {0x1;}' unless defined(&PF_OSFP_EXPANDED);
    eval 'sub PF_OSFP_GENERIC () {0x2;}' unless defined(&PF_OSFP_GENERIC);
    eval 'sub PF_OSFP_NODETAIL () {0x4;}' unless defined(&PF_OSFP_NODETAIL);
    eval 'sub PF_OSFP_LEN () {32;}' unless defined(&PF_OSFP_LEN);
    eval 'sub PF_OSFP_ENTRY_EQ {
        local($a, $b) = @_;
	    eval q((($a)-> &fp_os == ($b)-> &fp_os  &&  &memcmp(($a)-> &fp_class_nm, ($b)-> &fp_class_nm,  &PF_OSFP_LEN) == 0 &&  &memcmp(($a)-> &fp_version_nm, ($b)-> &fp_version_nm,  &PF_OSFP_LEN) == 0 &&  &memcmp(($a)-> &fp_subtype_nm, ($b)-> &fp_subtype_nm,  &PF_OSFP_LEN) == 0));
    }' unless defined(&PF_OSFP_ENTRY_EQ);
    eval 'sub _FP_RESERVED_BIT () {1;}' unless defined(&_FP_RESERVED_BIT);
    eval 'sub _FP_UNUSED_BITS () {1;}' unless defined(&_FP_UNUSED_BITS);
    eval 'sub _FP_CLASS_BITS () {10;}' unless defined(&_FP_CLASS_BITS);
    eval 'sub _FP_VERSION_BITS () {10;}' unless defined(&_FP_VERSION_BITS);
    eval 'sub _FP_SUBTYPE_BITS () {10;}' unless defined(&_FP_SUBTYPE_BITS);
    eval 'sub PF_OSFP_UNPACK {
        local($osfp, $class, $version, $subtype) = @_;
	    eval q( &do { ($class) = (($osfp) >> ( &_FP_VERSION_BITS+ &_FP_SUBTYPE_BITS)) & ((1<<  &_FP_CLASS_BITS) - 1); ($version) = (($osfp) >>  &_FP_SUBTYPE_BITS) & ((1<<  &_FP_VERSION_BITS) - 1); ($subtype) = ($osfp) & ((1<<  &_FP_SUBTYPE_BITS) - 1); }  &while(0));
    }' unless defined(&PF_OSFP_UNPACK);
    eval 'sub PF_OSFP_PACK {
        local($osfp, $class, $version, $subtype) = @_;
	    eval q( &do { ($osfp) = (($class) & ((1<<  &_FP_CLASS_BITS) - 1)) << ( &_FP_VERSION_BITS +  &_FP_SUBTYPE_BITS); ($osfp) |= (($version) & ((1<<  &_FP_VERSION_BITS) - 1)) <<  &_FP_SUBTYPE_BITS; ($osfp) |= ($subtype) & ((1<<  &_FP_SUBTYPE_BITS) - 1); }  &while(0));
    }' unless defined(&PF_OSFP_PACK);
    eval 'sub PF_OSFP_WSIZE_MOD () {0x1;}' unless defined(&PF_OSFP_WSIZE_MOD);
    eval 'sub PF_OSFP_WSIZE_DC () {0x2;}' unless defined(&PF_OSFP_WSIZE_DC);
    eval 'sub PF_OSFP_WSIZE_MSS () {0x4;}' unless defined(&PF_OSFP_WSIZE_MSS);
    eval 'sub PF_OSFP_WSIZE_MTU () {0x8;}' unless defined(&PF_OSFP_WSIZE_MTU);
    eval 'sub PF_OSFP_PSIZE_MOD () {0x10;}' unless defined(&PF_OSFP_PSIZE_MOD);
    eval 'sub PF_OSFP_PSIZE_DC () {0x20;}' unless defined(&PF_OSFP_PSIZE_DC);
    eval 'sub PF_OSFP_WSCALE () {0x40;}' unless defined(&PF_OSFP_WSCALE);
    eval 'sub PF_OSFP_WSCALE_MOD () {0x80;}' unless defined(&PF_OSFP_WSCALE_MOD);
    eval 'sub PF_OSFP_WSCALE_DC () {0x100;}' unless defined(&PF_OSFP_WSCALE_DC);
    eval 'sub PF_OSFP_MSS () {0x200;}' unless defined(&PF_OSFP_MSS);
    eval 'sub PF_OSFP_MSS_MOD () {0x400;}' unless defined(&PF_OSFP_MSS_MOD);
    eval 'sub PF_OSFP_MSS_DC () {0x800;}' unless defined(&PF_OSFP_MSS_DC);
    eval 'sub PF_OSFP_DF () {0x1000;}' unless defined(&PF_OSFP_DF);
    eval 'sub PF_OSFP_TS0 () {0x2000;}' unless defined(&PF_OSFP_TS0);
    eval 'sub PF_OSFP_MAXTTL_OFFSET () {40;}' unless defined(&PF_OSFP_MAXTTL_OFFSET);
    eval 'sub PF_OSFP_TCPOPT_NOP () {0x;}' unless defined(&PF_OSFP_TCPOPT_NOP);
    eval 'sub PF_OSFP_TCPOPT_WSCALE () {0x1;}' unless defined(&PF_OSFP_TCPOPT_WSCALE);
    eval 'sub PF_OSFP_TCPOPT_MSS () {0x2;}' unless defined(&PF_OSFP_TCPOPT_MSS);
    eval 'sub PF_OSFP_TCPOPT_SACK () {0x3;}' unless defined(&PF_OSFP_TCPOPT_SACK);
    eval 'sub PF_OSFP_TCPOPT_TS () {0x4;}' unless defined(&PF_OSFP_TCPOPT_TS);
    eval 'sub PF_OSFP_TCPOPT_BITS () {3;}' unless defined(&PF_OSFP_TCPOPT_BITS);
    eval 'sub PF_OSFP_MAX_OPTS () {($sizeof{(0)-> &fp_tcpopts} * 8) /  &PF_OSFP_TCPOPT_BITS;}' unless defined(&PF_OSFP_MAX_OPTS);
    eval 'sub PF_SKIP_IFP () {0;}' unless defined(&PF_SKIP_IFP);
    eval 'sub PF_SKIP_DIR () {1;}' unless defined(&PF_SKIP_DIR);
    eval 'sub PF_SKIP_AF () {2;}' unless defined(&PF_SKIP_AF);
    eval 'sub PF_SKIP_PROTO () {3;}' unless defined(&PF_SKIP_PROTO);
    eval 'sub PF_SKIP_SRC_ADDR () {4;}' unless defined(&PF_SKIP_SRC_ADDR);
    eval 'sub PF_SKIP_SRC_PORT () {5;}' unless defined(&PF_SKIP_SRC_PORT);
    eval 'sub PF_SKIP_DST_ADDR () {6;}' unless defined(&PF_SKIP_DST_ADDR);
    eval 'sub PF_SKIP_DST_PORT () {7;}' unless defined(&PF_SKIP_DST_PORT);
    eval 'sub PF_SKIP_COUNT () {8;}' unless defined(&PF_SKIP_COUNT);
    eval 'sub PF_RULE_LABEL_SIZE () {64;}' unless defined(&PF_RULE_LABEL_SIZE);
    eval 'sub PF_QNAME_SIZE () {16;}' unless defined(&PF_QNAME_SIZE);
    eval 'sub PF_ANCHOR_NAME_SIZE () {16;}' unless defined(&PF_ANCHOR_NAME_SIZE);
    eval 'sub PF_TAG_NAME_SIZE () {16;}' unless defined(&PF_TAG_NAME_SIZE);
    eval 'sub PF_STATE_NORMAL () {0x1;}' unless defined(&PF_STATE_NORMAL);
    eval 'sub PF_STATE_MODULATE () {0x2;}' unless defined(&PF_STATE_MODULATE);
    eval 'sub PF_STATE_SYNPROXY () {0x3;}' unless defined(&PF_STATE_SYNPROXY);
    eval 'sub PFRULE_DROP () {0x;}' unless defined(&PFRULE_DROP);
    eval 'sub PFRULE_RETURNRST () {0x1;}' unless defined(&PFRULE_RETURNRST);
    eval 'sub PFRULE_FRAGMENT () {0x2;}' unless defined(&PFRULE_FRAGMENT);
    eval 'sub PFRULE_RETURNICMP () {0x4;}' unless defined(&PFRULE_RETURNICMP);
    eval 'sub PFRULE_RETURN () {0x8;}' unless defined(&PFRULE_RETURN);
    eval 'sub PFRULE_NODF () {0x100;}' unless defined(&PFRULE_NODF);
    eval 'sub PFRULE_FRAGCROP () {0x200;}' unless defined(&PFRULE_FRAGCROP);
    eval 'sub PFRULE_FRAGDROP () {0x400;}' unless defined(&PFRULE_FRAGDROP);
    eval 'sub PFRULE_RANDOMID () {0x800;}' unless defined(&PFRULE_RANDOMID);
    eval 'sub PFRULE_REASSEMBLE_TCP () {0x1000;}' unless defined(&PFRULE_REASSEMBLE_TCP);
    eval 'sub PFSTATE_HIWAT () {10000;}' unless defined(&PFSTATE_HIWAT);
    eval 'sub PFSS_TIMESTAMP () {0x1;}' unless defined(&PFSS_TIMESTAMP);
    eval 'sub PF_RULESET_NAME_SIZE () {16;}' unless defined(&PF_RULESET_NAME_SIZE);
    eval 'sub PFR_TFLAG_PERSIST () {0x1;}' unless defined(&PFR_TFLAG_PERSIST);
    eval 'sub PFR_TFLAG_CONST () {0x2;}' unless defined(&PFR_TFLAG_CONST);
    eval 'sub PFR_TFLAG_ACTIVE () {0x4;}' unless defined(&PFR_TFLAG_ACTIVE);
    eval 'sub PFR_TFLAG_INACTIVE () {0x8;}' unless defined(&PFR_TFLAG_INACTIVE);
    eval 'sub PFR_TFLAG_REFERENCED () {0x10;}' unless defined(&PFR_TFLAG_REFERENCED);
    eval 'sub PFR_TFLAG_REFDANCHOR () {0x20;}' unless defined(&PFR_TFLAG_REFDANCHOR);
    eval 'sub PFR_TFLAG_USRMASK () {0x3;}' unless defined(&PFR_TFLAG_USRMASK);
    eval 'sub PFR_TFLAG_SETMASK () {0x3c;}' unless defined(&PFR_TFLAG_SETMASK);
    eval 'sub PFR_TFLAG_ALLMASK () {0x3f;}' unless defined(&PFR_TFLAG_ALLMASK);
    eval("sub PFR_FB_NONE () { 0; }") unless defined(&PFR_FB_NONE);
    eval("sub PFR_FB_MATCH () { 1; }") unless defined(&PFR_FB_MATCH);
    eval("sub PFR_FB_ADDED () { 2; }") unless defined(&PFR_FB_ADDED);
    eval("sub PFR_FB_DELETED () { 3; }") unless defined(&PFR_FB_DELETED);
    eval("sub PFR_FB_CHANGED () { 4; }") unless defined(&PFR_FB_CHANGED);
    eval("sub PFR_FB_CLEARED () { 5; }") unless defined(&PFR_FB_CLEARED);
    eval("sub PFR_FB_DUPLICATE () { 6; }") unless defined(&PFR_FB_DUPLICATE);
    eval("sub PFR_FB_NOTMATCH () { 7; }") unless defined(&PFR_FB_NOTMATCH);
    eval("sub PFR_FB_CONFLICT () { 8; }") unless defined(&PFR_FB_CONFLICT);
    eval("sub PFR_FB_MAX () { 9; }") unless defined(&PFR_FB_MAX);
    eval 'sub pfra_ip4addr () { ($pfra_u->{_pfra_ip4addr});}' unless defined(&pfra_ip4addr);
    eval 'sub pfra_ip6addr () { ($pfra_u->{_pfra_ip6addr});}' unless defined(&pfra_ip6addr);
    eval("sub PFR_DIR_IN () { 0; }") unless defined(&PFR_DIR_IN);
    eval("sub PFR_DIR_OUT () { 1; }") unless defined(&PFR_DIR_OUT);
    eval("sub PFR_DIR_MAX () { 2; }") unless defined(&PFR_DIR_MAX);
    eval("sub PFR_OP_BLOCK () { 0; }") unless defined(&PFR_OP_BLOCK);
    eval("sub PFR_OP_PASS () { 1; }") unless defined(&PFR_OP_PASS);
    eval("sub PFR_OP_ADDR_MAX () { 2; }") unless defined(&PFR_OP_ADDR_MAX);
    eval("sub PFR_OP_TABLE_MAX () { 3; }") unless defined(&PFR_OP_TABLE_MAX);
    eval 'sub PFR_OP_XPASS () { &PFR_OP_ADDR_MAX;}' unless defined(&PFR_OP_XPASS);
    eval("sub PFR_REFCNT_RULE () { 0; }") unless defined(&PFR_REFCNT_RULE);
    eval("sub PFR_REFCNT_ANCHOR () { 1; }") unless defined(&PFR_REFCNT_ANCHOR);
    eval("sub PFR_REFCNT_MAX () { 2; }") unless defined(&PFR_REFCNT_MAX);
    eval 'sub pfrts_name () { ($pfrts_t->{pfrt_name});}' unless defined(&pfrts_name);
    eval 'sub pfrts_flags () { ($pfrts_t->{pfrt_flags});}' unless defined(&pfrts_flags);
    eval 'sub pfrkt_t () { ($pfrkt_ts->{pfrts_t});}' unless defined(&pfrkt_t);
    eval 'sub pfrkt_name () { ($pfrkt_t->{pfrt_name});}' unless defined(&pfrkt_name);
    eval 'sub pfrkt_anchor () { ($pfrkt_t->{pfrt_anchor});}' unless defined(&pfrkt_anchor);
    eval 'sub pfrkt_ruleset () { ($pfrkt_t->{pfrt_ruleset});}' unless defined(&pfrkt_ruleset);
    eval 'sub pfrkt_flags () { ($pfrkt_t->{pfrt_flags});}' unless defined(&pfrkt_flags);
    eval 'sub pfrkt_cnt () { ($pfrkt_ts->{pfrts_cnt});}' unless defined(&pfrkt_cnt);
    eval 'sub pfrkt_refcnt () { ($pfrkt_ts->{pfrts_refcnt});}' unless defined(&pfrkt_refcnt);
    eval 'sub pfrkt_packets () { ($pfrkt_ts->{pfrts_packets});}' unless defined(&pfrkt_packets);
    eval 'sub pfrkt_bytes () { ($pfrkt_ts->{pfrts_bytes});}' unless defined(&pfrkt_bytes);
    eval 'sub pfrkt_match () { ($pfrkt_ts->{pfrts_match});}' unless defined(&pfrkt_match);
    eval 'sub pfrkt_nomatch () { ($pfrkt_ts->{pfrts_nomatch});}' unless defined(&pfrkt_nomatch);
    eval 'sub pfrkt_tzero () { ($pfrkt_ts->{pfrts_tzero});}' unless defined(&pfrkt_tzero);
    if(defined(&INET6)) {
    }
    eval 'sub PFDESC_TCP_NORM () {0x1;}' unless defined(&PFDESC_TCP_NORM);
    eval 'sub PF_DPORT_RANGE () {0x1;}' unless defined(&PF_DPORT_RANGE);
    eval 'sub PF_RPORT_RANGE () {0x2;}' unless defined(&PF_RPORT_RANGE);
    eval 'sub PFRES_MATCH () {0;}' unless defined(&PFRES_MATCH);
    eval 'sub PFRES_BADOFF () {1;}' unless defined(&PFRES_BADOFF);
    eval 'sub PFRES_FRAG () {2;}' unless defined(&PFRES_FRAG);
    eval 'sub PFRES_SHORT () {3;}' unless defined(&PFRES_SHORT);
    eval 'sub PFRES_NORM () {4;}' unless defined(&PFRES_NORM);
    eval 'sub PFRES_MEMORY () {5;}' unless defined(&PFRES_MEMORY);
    eval 'sub PFRES_MAX () {6;}' unless defined(&PFRES_MAX);
    eval 'sub PFRES_NAMES () {{ "match", "bad-offset", "fragment", "short", "normalize", "memory",  &NULL };}' unless defined(&PFRES_NAMES);
    eval 'sub PFUDPS_NO_TRAFFIC () {0;}' unless defined(&PFUDPS_NO_TRAFFIC);
    eval 'sub PFUDPS_SINGLE () {1;}' unless defined(&PFUDPS_SINGLE);
    eval 'sub PFUDPS_MULTIPLE () {2;}' unless defined(&PFUDPS_MULTIPLE);
    eval 'sub PFUDPS_NSTATES () {3;}' unless defined(&PFUDPS_NSTATES);
    eval 'sub PFUDPS_NAMES () {{ "NO_TRAFFIC", "SINGLE", "MULTIPLE",  &NULL };}' unless defined(&PFUDPS_NAMES);
    eval 'sub PFOTHERS_NO_TRAFFIC () {0;}' unless defined(&PFOTHERS_NO_TRAFFIC);
    eval 'sub PFOTHERS_SINGLE () {1;}' unless defined(&PFOTHERS_SINGLE);
    eval 'sub PFOTHERS_MULTIPLE () {2;}' unless defined(&PFOTHERS_MULTIPLE);
    eval 'sub PFOTHERS_NSTATES () {3;}' unless defined(&PFOTHERS_NSTATES);
    eval 'sub PFOTHERS_NAMES () {{ "NO_TRAFFIC", "SINGLE", "MULTIPLE",  &NULL };}' unless defined(&PFOTHERS_NAMES);
    eval 'sub FCNT_STATE_SEARCH () {0;}' unless defined(&FCNT_STATE_SEARCH);
    eval 'sub FCNT_STATE_INSERT () {1;}' unless defined(&FCNT_STATE_INSERT);
    eval 'sub FCNT_STATE_REMOVALS () {2;}' unless defined(&FCNT_STATE_REMOVALS);
    eval 'sub FCNT_MAX () {3;}' unless defined(&FCNT_MAX);
    eval 'sub ACTION_SET {
        local($a, $x) = @_;
	    eval q( &do {  &if (($a) !=  &NULL) *($a) = ($x); }  &while (0));
    }' unless defined(&ACTION_SET);
    eval 'sub REASON_SET {
        local($a, $x) = @_;
	    eval q( &do {  &if (($a) !=  &NULL) *($a) = ($x);  &if ($x <  &PFRES_MAX)  ($pf_status->{counters[$x]})++; }  &while (0));
    }' unless defined(&REASON_SET);
    eval 'sub PFFRAG_FRENT_HIWAT () {5000;}' unless defined(&PFFRAG_FRENT_HIWAT);
    eval 'sub PFFRAG_FRAG_HIWAT () {1000;}' unless defined(&PFFRAG_FRAG_HIWAT);
    eval 'sub PFFRAG_FRCENT_HIWAT () {50000;}' unless defined(&PFFRAG_FRCENT_HIWAT);
    eval 'sub PFFRAG_FRCACHE_HIWAT () {10000;}' unless defined(&PFFRAG_FRCACHE_HIWAT);
    eval 'sub ps_buf () { ($ps_u->{psu_buf});}' unless defined(&ps_buf);
    eval 'sub ps_states () { ($ps_u->{psu_states});}' unless defined(&ps_states);
    eval 'sub PFR_FLAG_ATOMIC () {0x1;}' unless defined(&PFR_FLAG_ATOMIC);
    eval 'sub PFR_FLAG_DUMMY () {0x2;}' unless defined(&PFR_FLAG_DUMMY);
    eval 'sub PFR_FLAG_FEEDBACK () {0x4;}' unless defined(&PFR_FLAG_FEEDBACK);
    eval 'sub PFR_FLAG_CLSTATS () {0x8;}' unless defined(&PFR_FLAG_CLSTATS);
    eval 'sub PFR_FLAG_ADDRSTOO () {0x10;}' unless defined(&PFR_FLAG_ADDRSTOO);
    eval 'sub PFR_FLAG_REPLACE () {0x20;}' unless defined(&PFR_FLAG_REPLACE);
    eval 'sub PFR_FLAG_ALLRSETS () {0x40;}' unless defined(&PFR_FLAG_ALLRSETS);
    eval 'sub PFR_FLAG_ALLMASK () {0x7f;}' unless defined(&PFR_FLAG_ALLMASK);
    eval 'sub pfrio_exists () { &pfrio_nadd;}' unless defined(&pfrio_exists);
    eval 'sub pfrio_nzero () { &pfrio_nadd;}' unless defined(&pfrio_nzero);
    eval 'sub pfrio_nmatch () { &pfrio_nadd;}' unless defined(&pfrio_nmatch);
    eval 'sub pfrio_naddr () { &pfrio_size2;}' unless defined(&pfrio_naddr);
    eval 'sub pfrio_setflag () { &pfrio_size2;}' unless defined(&pfrio_setflag);
    eval 'sub pfrio_clrflag () { &pfrio_nadd;}' unless defined(&pfrio_clrflag);
    eval 'sub DIOCSTART () { &_IO (ord(\'D\'), 1);}' unless defined(&DIOCSTART);
    eval 'sub DIOCSTOP () { &_IO (ord(\'D\'), 2);}' unless defined(&DIOCSTOP);
    eval 'sub DIOCBEGINRULES () { &_IOWR(ord(\'D\'), 3, \'struct pfioc_rule\');}' unless defined(&DIOCBEGINRULES);
    eval 'sub DIOCADDRULE () { &_IOWR(ord(\'D\'), 4, \'struct pfioc_rule\');}' unless defined(&DIOCADDRULE);
    eval 'sub DIOCCOMMITRULES () { &_IOWR(ord(\'D\'), 5, \'struct pfioc_rule\');}' unless defined(&DIOCCOMMITRULES);
    eval 'sub DIOCGETRULES () { &_IOWR(ord(\'D\'), 6, \'struct pfioc_rule\');}' unless defined(&DIOCGETRULES);
    eval 'sub DIOCGETRULE () { &_IOWR(ord(\'D\'), 7, \'struct pfioc_rule\');}' unless defined(&DIOCGETRULE);
    eval 'sub DIOCCLRSTATES () { &_IO (ord(\'D\'), 18);}' unless defined(&DIOCCLRSTATES);
    eval 'sub DIOCGETSTATE () { &_IOWR(ord(\'D\'), 19, \'struct pfioc_state\');}' unless defined(&DIOCGETSTATE);
    eval 'sub DIOCSETSTATUSIF () { &_IOWR(ord(\'D\'), 20, \'struct pfioc_if\');}' unless defined(&DIOCSETSTATUSIF);
    eval 'sub DIOCGETSTATUS () { &_IOWR(ord(\'D\'), 21, \'struct pf_status\');}' unless defined(&DIOCGETSTATUS);
    eval 'sub DIOCCLRSTATUS () { &_IO (ord(\'D\'), 22);}' unless defined(&DIOCCLRSTATUS);
    eval 'sub DIOCNATLOOK () { &_IOWR(ord(\'D\'), 23, \'struct pfioc_natlook\');}' unless defined(&DIOCNATLOOK);
    eval 'sub DIOCSETDEBUG () { &_IOWR(ord(\'D\'), 24,  &u_int32_t);}' unless defined(&DIOCSETDEBUG);
    eval 'sub DIOCGETSTATES () { &_IOWR(ord(\'D\'), 25, \'struct pfioc_states\');}' unless defined(&DIOCGETSTATES);
    eval 'sub DIOCCHANGERULE () { &_IOWR(ord(\'D\'), 26, \'struct pfioc_rule\');}' unless defined(&DIOCCHANGERULE);
    eval 'sub DIOCSETTIMEOUT () { &_IOWR(ord(\'D\'), 29, \'struct pfioc_tm\');}' unless defined(&DIOCSETTIMEOUT);
    eval 'sub DIOCGETTIMEOUT () { &_IOWR(ord(\'D\'), 30, \'struct pfioc_tm\');}' unless defined(&DIOCGETTIMEOUT);
    eval 'sub DIOCADDSTATE () { &_IOWR(ord(\'D\'), 37, \'struct pfioc_state\');}' unless defined(&DIOCADDSTATE);
    eval 'sub DIOCCLRRULECTRS () { &_IO (ord(\'D\'), 38);}' unless defined(&DIOCCLRRULECTRS);
    eval 'sub DIOCGETLIMIT () { &_IOWR(ord(\'D\'), 39, \'struct pfioc_limit\');}' unless defined(&DIOCGETLIMIT);
    eval 'sub DIOCSETLIMIT () { &_IOWR(ord(\'D\'), 40, \'struct pfioc_limit\');}' unless defined(&DIOCSETLIMIT);
    eval 'sub DIOCKILLSTATES () { &_IOWR(ord(\'D\'), 41, \'struct pfioc_state_kill\');}' unless defined(&DIOCKILLSTATES);
    eval 'sub DIOCSTARTALTQ () { &_IO (ord(\'D\'), 42);}' unless defined(&DIOCSTARTALTQ);
    eval 'sub DIOCSTOPALTQ () { &_IO (ord(\'D\'), 43);}' unless defined(&DIOCSTOPALTQ);
    eval 'sub DIOCBEGINALTQS () { &_IOWR(ord(\'D\'), 44,  &u_int32_t);}' unless defined(&DIOCBEGINALTQS);
    eval 'sub DIOCADDALTQ () { &_IOWR(ord(\'D\'), 45, \'struct pfioc_altq\');}' unless defined(&DIOCADDALTQ);
    eval 'sub DIOCCOMMITALTQS () { &_IOWR(ord(\'D\'), 46,  &u_int32_t);}' unless defined(&DIOCCOMMITALTQS);
    eval 'sub DIOCGETALTQS () { &_IOWR(ord(\'D\'), 47, \'struct pfioc_altq\');}' unless defined(&DIOCGETALTQS);
    eval 'sub DIOCGETALTQ () { &_IOWR(ord(\'D\'), 48, \'struct pfioc_altq\');}' unless defined(&DIOCGETALTQ);
    eval 'sub DIOCCHANGEALTQ () { &_IOWR(ord(\'D\'), 49, \'struct pfioc_altq\');}' unless defined(&DIOCCHANGEALTQ);
    eval 'sub DIOCGETQSTATS () { &_IOWR(ord(\'D\'), 50, \'struct pfioc_qstats\');}' unless defined(&DIOCGETQSTATS);
    eval 'sub DIOCBEGINADDRS () { &_IOWR(ord(\'D\'), 51, \'struct pfioc_pooladdr\');}' unless defined(&DIOCBEGINADDRS);
    eval 'sub DIOCADDADDR () { &_IOWR(ord(\'D\'), 52, \'struct pfioc_pooladdr\');}' unless defined(&DIOCADDADDR);
    eval 'sub DIOCGETADDRS () { &_IOWR(ord(\'D\'), 53, \'struct pfioc_pooladdr\');}' unless defined(&DIOCGETADDRS);
    eval 'sub DIOCGETADDR () { &_IOWR(ord(\'D\'), 54, \'struct pfioc_pooladdr\');}' unless defined(&DIOCGETADDR);
    eval 'sub DIOCCHANGEADDR () { &_IOWR(ord(\'D\'), 55, \'struct pfioc_pooladdr\');}' unless defined(&DIOCCHANGEADDR);
    eval 'sub DIOCGETANCHORS () { &_IOWR(ord(\'D\'), 56, \'struct pfioc_anchor\');}' unless defined(&DIOCGETANCHORS);
    eval 'sub DIOCGETANCHOR () { &_IOWR(ord(\'D\'), 57, \'struct pfioc_anchor\');}' unless defined(&DIOCGETANCHOR);
    eval 'sub DIOCGETRULESETS () { &_IOWR(ord(\'D\'), 58, \'struct pfioc_ruleset\');}' unless defined(&DIOCGETRULESETS);
    eval 'sub DIOCGETRULESET () { &_IOWR(ord(\'D\'), 59, \'struct pfioc_ruleset\');}' unless defined(&DIOCGETRULESET);
    eval 'sub DIOCRCLRTABLES () { &_IOWR(ord(\'D\'), 60, \'struct pfioc_table\');}' unless defined(&DIOCRCLRTABLES);
    eval 'sub DIOCRADDTABLES () { &_IOWR(ord(\'D\'), 61, \'struct pfioc_table\');}' unless defined(&DIOCRADDTABLES);
    eval 'sub DIOCRDELTABLES () { &_IOWR(ord(\'D\'), 62, \'struct pfioc_table\');}' unless defined(&DIOCRDELTABLES);
    eval 'sub DIOCRGETTABLES () { &_IOWR(ord(\'D\'), 63, \'struct pfioc_table\');}' unless defined(&DIOCRGETTABLES);
    eval 'sub DIOCRGETTSTATS () { &_IOWR(ord(\'D\'), 64, \'struct pfioc_table\');}' unless defined(&DIOCRGETTSTATS);
    eval 'sub DIOCRCLRTSTATS () { &_IOWR(ord(\'D\'), 65, \'struct pfioc_table\');}' unless defined(&DIOCRCLRTSTATS);
    eval 'sub DIOCRCLRADDRS () { &_IOWR(ord(\'D\'), 66, \'struct pfioc_table\');}' unless defined(&DIOCRCLRADDRS);
    eval 'sub DIOCRADDADDRS () { &_IOWR(ord(\'D\'), 67, \'struct pfioc_table\');}' unless defined(&DIOCRADDADDRS);
    eval 'sub DIOCRDELADDRS () { &_IOWR(ord(\'D\'), 68, \'struct pfioc_table\');}' unless defined(&DIOCRDELADDRS);
    eval 'sub DIOCRSETADDRS () { &_IOWR(ord(\'D\'), 69, \'struct pfioc_table\');}' unless defined(&DIOCRSETADDRS);
    eval 'sub DIOCRGETADDRS () { &_IOWR(ord(\'D\'), 70, \'struct pfioc_table\');}' unless defined(&DIOCRGETADDRS);
    eval 'sub DIOCRGETASTATS () { &_IOWR(ord(\'D\'), 71, \'struct pfioc_table\');}' unless defined(&DIOCRGETASTATS);
    eval 'sub DIOCRCLRASTATS () { &_IOWR(ord(\'D\'), 72, \'struct pfioc_table\');}' unless defined(&DIOCRCLRASTATS);
    eval 'sub DIOCRTSTADDRS () { &_IOWR(ord(\'D\'), 73, \'struct pfioc_table\');}' unless defined(&DIOCRTSTADDRS);
    eval 'sub DIOCRSETTFLAGS () { &_IOWR(ord(\'D\'), 74, \'struct pfioc_table\');}' unless defined(&DIOCRSETTFLAGS);
    eval 'sub DIOCRINABEGIN () { &_IOWR(ord(\'D\'), 75, \'struct pfioc_table\');}' unless defined(&DIOCRINABEGIN);
    eval 'sub DIOCRINACOMMIT () { &_IOWR(ord(\'D\'), 76, \'struct pfioc_table\');}' unless defined(&DIOCRINACOMMIT);
    eval 'sub DIOCRINADEFINE () { &_IOWR(ord(\'D\'), 77, \'struct pfioc_table\');}' unless defined(&DIOCRINADEFINE);
    eval 'sub DIOCOSFPFLUSH () { &_IO(ord(\'D\'), 78);}' unless defined(&DIOCOSFPFLUSH);
    eval 'sub DIOCOSFPADD () { &_IOWR(ord(\'D\'), 79, \'struct pf_osfp_ioctl\');}' unless defined(&DIOCOSFPADD);
    eval 'sub DIOCOSFPGET () { &_IOWR(ord(\'D\'), 80, \'struct pf_osfp_ioctl\');}' unless defined(&DIOCOSFPGET);
    if(defined(&_KERNEL)) {
	if(defined(&INET)) {
	}
	if(defined(&INET6)) {
	}
    }
    if(defined(&_KERNEL)) {
    }
}
1;
