require '_h2ph_pre.ph';

unless(defined(&_PDQREG_H)) {
    eval 'sub _PDQREG_H () {1;}' unless defined(&_PDQREG_H);
    if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
	require 'stddef.ph';
	if(defined( &PDQTEST)  && !defined( &PDQ_NDEBUG)) {
	    require 'assert.ph';
	    eval 'sub PDQ_ASSERT () { &assert;}' unless defined(&PDQ_ASSERT);
	} else {
	    eval 'sub PDQ_ASSERT {
	        local($x) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&PDQ_ASSERT);
	}
    } else {
	if(defined(&PDQ_NDEBUG)) {
	    eval 'sub PDQ_ASSERT {
	        local($e) = @_;
    		eval q((0));
	    }' unless defined(&PDQ_ASSERT);
	} else {
	    if(defined(&__STDC__)) {
		eval 'sub PDQ_ASSERT {
		    local($e) = @_;
    		    eval q(( ? 0:  &__assert(\\"PDQ \\",  &__FILE__,  &__LINE__, $e)));
		}' unless defined(&PDQ_ASSERT);
	    } else {
		eval 'sub PDQ_ASSERT {
		    local($e) = @_;
    		    eval q(( ? 0:  &__assert(\\"PDQ \\",  &__FILE__,  &__LINE__, \\"e\\")));
		}' unless defined(&PDQ_ASSERT);
	    }
	}
    }
    eval 'sub PDQ_RING_SIZE {
        local($array) = @_;
	    eval q((($sizeof{$array} / $sizeof{$array->[0]})));
    }' unless defined(&PDQ_RING_SIZE);
    eval 'sub PDQ_ARRAY_SIZE {
        local($array) = @_;
	    eval q((($sizeof{$array} / $sizeof{$array->[0]})));
    }' unless defined(&PDQ_ARRAY_SIZE);
    eval 'sub PDQ_RING_MASK {
        local($array) = @_;
	    eval q(( &PDQ_RING_SIZE($array) - 1));
    }' unless defined(&PDQ_RING_MASK);
    eval 'sub PDQ_BITMASK {
        local($n) = @_;
	    eval q((1 << ($n)));
    }' unless defined(&PDQ_BITMASK);
    eval 'sub PDQ_FDDI_MAX () {4495;}' unless defined(&PDQ_FDDI_MAX);
    eval 'sub PDQ_FDDI_LLC_MIN () {20;}' unless defined(&PDQ_FDDI_LLC_MIN);
    eval 'sub PDQ_FDDI_SMT_MIN () {37;}' unless defined(&PDQ_FDDI_SMT_MIN);
    eval 'sub PDQ_FDDI_SMT () {0x40;}' unless defined(&PDQ_FDDI_SMT);
    eval 'sub PDQ_FDDI_LLC_ASYNC () {0x50;}' unless defined(&PDQ_FDDI_LLC_ASYNC);
    eval 'sub PDQ_FDDI_LLC_SYNC () {0xd0;}' unless defined(&PDQ_FDDI_LLC_SYNC);
    eval 'sub PDQ_FDDI_IMP_ASYNC () {0x60;}' unless defined(&PDQ_FDDI_IMP_ASYNC);
    eval 'sub PDQ_FDDI_IMP_SYNC () {0xe0;}' unless defined(&PDQ_FDDI_IMP_SYNC);
    eval 'sub PDQ_FDDIFC_C () {0x80;}' unless defined(&PDQ_FDDIFC_C);
    eval 'sub PDQ_FDDIFC_L () {0x40;}' unless defined(&PDQ_FDDIFC_L);
    eval 'sub PDQ_FDDIFC_F () {0x30;}' unless defined(&PDQ_FDDIFC_F);
    eval 'sub PDQ_FDDIFC_Z () {0xf;}' unless defined(&PDQ_FDDIFC_Z);
    eval 'sub PDQ_FDDI_PH0 () {0x20;}' unless defined(&PDQ_FDDI_PH0);
    eval 'sub PDQ_FDDI_PH1 () {0x38;}' unless defined(&PDQ_FDDI_PH1);
    eval 'sub PDQ_FDDI_PH2 () {0x;}' unless defined(&PDQ_FDDI_PH2);
    eval("sub PDQS_RESET () { 0; }") unless defined(&PDQS_RESET);
    eval("sub PDQS_UPGRADE () { 1; }") unless defined(&PDQS_UPGRADE);
    eval("sub PDQS_DMA_UNAVAILABLE () { 2; }") unless defined(&PDQS_DMA_UNAVAILABLE);
    eval("sub PDQS_DMA_AVAILABLE () { 3; }") unless defined(&PDQS_DMA_AVAILABLE);
    eval("sub PDQS_LINK_AVAILABLE () { 4; }") unless defined(&PDQS_LINK_AVAILABLE);
    eval("sub PDQS_LINK_UNAVAILABLE () { 5; }") unless defined(&PDQS_LINK_UNAVAILABLE);
    eval("sub PDQS_HALTED () { 6; }") unless defined(&PDQS_HALTED);
    eval("sub PDQS_RING_MEMBER () { 7; }") unless defined(&PDQS_RING_MEMBER);
    eval 'sub PDQ_PFI_MODE_DMA_ENABLE () {0x1;}' unless defined(&PDQ_PFI_MODE_DMA_ENABLE);
    eval 'sub PDQ_PFI_MODE_PFI_PCI_INTR () {0x2;}' unless defined(&PDQ_PFI_MODE_PFI_PCI_INTR);
    eval 'sub PDQ_PFI_MODE_PDQ_PCI_INTR () {0x4;}' unless defined(&PDQ_PFI_MODE_PDQ_PCI_INTR);
    eval 'sub PDQ_PFI_STATUS_PDQ_INTR () {0x10;}' unless defined(&PDQ_PFI_STATUS_PDQ_INTR);
    eval 'sub PDQ_PFI_STATUS_DMA_ABORT () {0x8;}' unless defined(&PDQ_PFI_STATUS_DMA_ABORT);
    eval 'sub PDQ_EISA_BURST_HOLDOFF () {0x40;}' unless defined(&PDQ_EISA_BURST_HOLDOFF);
    eval 'sub PDQ_EISA_SLOT_ID () {0xc80;}' unless defined(&PDQ_EISA_SLOT_ID);
    eval 'sub PDQ_EISA_SLOT_CTRL () {0xc84;}' unless defined(&PDQ_EISA_SLOT_CTRL);
    eval 'sub PDQ_EISA_MEM_ADD_CMP_0 () {0xc85;}' unless defined(&PDQ_EISA_MEM_ADD_CMP_0);
    eval 'sub PDQ_EISA_MEM_ADD_CMP_1 () {0xc86;}' unless defined(&PDQ_EISA_MEM_ADD_CMP_1);
    eval 'sub PDQ_EISA_MEM_ADD_CMP_2 () {0xc87;}' unless defined(&PDQ_EISA_MEM_ADD_CMP_2);
    eval 'sub PDQ_EISA_MEM_ADD_HI_CMP_0 () {0xc88;}' unless defined(&PDQ_EISA_MEM_ADD_HI_CMP_0);
    eval 'sub PDQ_EISA_MEM_ADD_HI_CMP_1 () {0xc89;}' unless defined(&PDQ_EISA_MEM_ADD_HI_CMP_1);
    eval 'sub PDQ_EISA_MEM_ADD_HI_CMP_2 () {0xc8a;}' unless defined(&PDQ_EISA_MEM_ADD_HI_CMP_2);
    eval 'sub PDQ_EISA_MEM_ADD_MASK_0 () {0xc8b;}' unless defined(&PDQ_EISA_MEM_ADD_MASK_0);
    eval 'sub PDQ_EISA_MEM_ADD_MASK_1 () {0xc8c;}' unless defined(&PDQ_EISA_MEM_ADD_MASK_1);
    eval 'sub PDQ_EISA_MEM_ADD_MASK_2 () {0xc8d;}' unless defined(&PDQ_EISA_MEM_ADD_MASK_2);
    eval 'sub PDQ_EISA_MEM_ADD_LO_CMP_0 () {0xc8e;}' unless defined(&PDQ_EISA_MEM_ADD_LO_CMP_0);
    eval 'sub PDQ_EISA_MEM_ADD_LO_CMP_1 () {0xc8f;}' unless defined(&PDQ_EISA_MEM_ADD_LO_CMP_1);
    eval 'sub PDQ_EISA_MEM_ADD_LO_CMP_2 () {0xc90;}' unless defined(&PDQ_EISA_MEM_ADD_LO_CMP_2);
    eval 'sub PDQ_EISA_IO_CMP_0_0 () {0xc91;}' unless defined(&PDQ_EISA_IO_CMP_0_0);
    eval 'sub PDQ_EISA_IO_CMP_0_1 () {0xc92;}' unless defined(&PDQ_EISA_IO_CMP_0_1);
    eval 'sub PDQ_EISA_IO_CMP_1_0 () {0xc93;}' unless defined(&PDQ_EISA_IO_CMP_1_0);
    eval 'sub PDQ_EISA_IO_CMP_1_1 () {0xc94;}' unless defined(&PDQ_EISA_IO_CMP_1_1);
    eval 'sub PDQ_EISA_IO_CMP_2_0 () {0xc95;}' unless defined(&PDQ_EISA_IO_CMP_2_0);
    eval 'sub PDQ_EISA_IO_CMP_2_1 () {0xc96;}' unless defined(&PDQ_EISA_IO_CMP_2_1);
    eval 'sub PDQ_EISA_IO_CMP_3_0 () {0xc97;}' unless defined(&PDQ_EISA_IO_CMP_3_0);
    eval 'sub PDQ_EISA_IO_CMP_3_1 () {0xc98;}' unless defined(&PDQ_EISA_IO_CMP_3_1);
    eval 'sub PDQ_EISA_IO_ADD_MASK_0_0 () {0xc99;}' unless defined(&PDQ_EISA_IO_ADD_MASK_0_0);
    eval 'sub PDQ_EISA_IO_ADD_MASK_0_1 () {0xc9a;}' unless defined(&PDQ_EISA_IO_ADD_MASK_0_1);
    eval 'sub PDQ_EISA_IO_ADD_MASK_1_0 () {0xc9b;}' unless defined(&PDQ_EISA_IO_ADD_MASK_1_0);
    eval 'sub PDQ_EISA_IO_ADD_MASK_1_1 () {0xc9c;}' unless defined(&PDQ_EISA_IO_ADD_MASK_1_1);
    eval 'sub PDQ_EISA_IO_ADD_MASK_2_0 () {0xc9d;}' unless defined(&PDQ_EISA_IO_ADD_MASK_2_0);
    eval 'sub PDQ_EISA_IO_ADD_MASK_2_1 () {0xc9e;}' unless defined(&PDQ_EISA_IO_ADD_MASK_2_1);
    eval 'sub PDQ_EISA_IO_ADD_MASK_3_0 () {0xc9f;}' unless defined(&PDQ_EISA_IO_ADD_MASK_3_0);
    eval 'sub PDQ_EISA_IO_ADD_MASK_3_1 () {0xca0;}' unless defined(&PDQ_EISA_IO_ADD_MASK_3_1);
    eval 'sub PDQ_EISA_MOD_CONFIG_1 () {0xca1;}' unless defined(&PDQ_EISA_MOD_CONFIG_1);
    eval 'sub PDQ_EISA_MOD_CONFIG_2 () {0xca2;}' unless defined(&PDQ_EISA_MOD_CONFIG_2);
    eval 'sub PDQ_EISA_MOD_CONFIG_3 () {0xca3;}' unless defined(&PDQ_EISA_MOD_CONFIG_3);
    eval 'sub PDQ_EISA_MOD_CONFIG_4 () {0xca4;}' unless defined(&PDQ_EISA_MOD_CONFIG_4);
    eval 'sub PDQ_EISA_MOD_CONFIG_5 () {0xca5;}' unless defined(&PDQ_EISA_MOD_CONFIG_5);
    eval 'sub PDQ_EISA_MOD_CONFIG_6 () {0xca6;}' unless defined(&PDQ_EISA_MOD_CONFIG_6);
    eval 'sub PDQ_EISA_MOD_CONFIG_7 () {0xca7;}' unless defined(&PDQ_EISA_MOD_CONFIG_7);
    eval 'sub PDQ_EISA_DIP_SWITCH () {0xca8;}' unless defined(&PDQ_EISA_DIP_SWITCH);
    eval 'sub PDQ_EISA_IO_CONFIG_STAT_0 () {0xca9;}' unless defined(&PDQ_EISA_IO_CONFIG_STAT_0);
    eval 'sub PDQ_EISA_IO_CONFIG_STAT_1 () {0xcaa;}' unless defined(&PDQ_EISA_IO_CONFIG_STAT_1);
    eval 'sub PDQ_EISA_DMA_CONFIG () {0xcab;}' unless defined(&PDQ_EISA_DMA_CONFIG);
    eval 'sub PDQ_EISA_INPUT_PORT () {0xcac;}' unless defined(&PDQ_EISA_INPUT_PORT);
    eval 'sub PDQ_EISA_OUTPUT_PORT () {0xcad;}' unless defined(&PDQ_EISA_OUTPUT_PORT);
    eval 'sub PDQ_EISA_FUNCTION_CTRL () {0xcae;}' unless defined(&PDQ_EISA_FUNCTION_CTRL);
    eval 'sub PDQ_TC_CSR_OFFSET () {0x100000;}' unless defined(&PDQ_TC_CSR_OFFSET);
    eval 'sub PDQ_TC_CSR_SPACE () {0x40;}' unless defined(&PDQ_TC_CSR_SPACE);
    eval 'sub PDQ_FBUS_CSR_OFFSET () {0x200000;}' unless defined(&PDQ_FBUS_CSR_OFFSET);
    eval 'sub PDQ_FBUS_CSR_SPACE () {0x80;}' unless defined(&PDQ_FBUS_CSR_SPACE);
    eval 'sub PDQ_PRESET_SKIP_SELFTEST () {0x4;}' unless defined(&PDQ_PRESET_SKIP_SELFTEST);
    eval 'sub PDQ_PRESET_SOFT_RESET () {0x2;}' unless defined(&PDQ_PRESET_SOFT_RESET);
    eval 'sub PDQ_PRESET_UPGRADE () {0x1;}' unless defined(&PDQ_PRESET_UPGRADE);
    eval 'sub PDQ_PCTL_CMD_ERROR () {0x8000;}' unless defined(&PDQ_PCTL_CMD_ERROR);
    eval 'sub PDQ_PCTL_FLASH_BLAST () {0x4000;}' unless defined(&PDQ_PCTL_FLASH_BLAST);
    eval 'sub PDQ_PCTL_HALT () {0x2000;}' unless defined(&PDQ_PCTL_HALT);
    eval 'sub PDQ_PCTL_COPY_DATA () {0x1000;}' unless defined(&PDQ_PCTL_COPY_DATA);
    eval 'sub PDQ_PCTL_ERROR_LOG_START () {0x800;}' unless defined(&PDQ_PCTL_ERROR_LOG_START);
    eval 'sub PDQ_PCTL_ERROR_LOG_READ () {0x400;}' unless defined(&PDQ_PCTL_ERROR_LOG_READ);
    eval 'sub PDQ_PCTL_XMT_DATA_FLUSH_DONE () {0x200;}' unless defined(&PDQ_PCTL_XMT_DATA_FLUSH_DONE);
    eval 'sub PDQ_PCTL_DMA_INIT () {0x100;}' unless defined(&PDQ_PCTL_DMA_INIT);
    eval 'sub PDQ_DMA_INIT_LW_BSWAP_DATA () {0x2;}' unless defined(&PDQ_DMA_INIT_LW_BSWAP_DATA);
    eval 'sub PDQ_DMA_INIT_LW_BSWAP_LITERAL () {0x1;}' unless defined(&PDQ_DMA_INIT_LW_BSWAP_LITERAL);
    eval 'sub PDQ_PCTL_INIT_START () {0x80;}' unless defined(&PDQ_PCTL_INIT_START);
    eval 'sub PDQ_PCTL_CONSUMER_BLOCK () {0x40;}' unless defined(&PDQ_PCTL_CONSUMER_BLOCK);
    eval 'sub PDQ_PCTL_DMA_UNINIT () {0x20;}' unless defined(&PDQ_PCTL_DMA_UNINIT);
    eval 'sub PDQ_PCTL_RING_MEMBER () {0x10;}' unless defined(&PDQ_PCTL_RING_MEMBER);
    eval 'sub PDQ_PCTL_MLA_READ () {0x8;}' unless defined(&PDQ_PCTL_MLA_READ);
    eval 'sub PDQ_PCTL_FW_REV_READ () {0x4;}' unless defined(&PDQ_PCTL_FW_REV_READ);
    eval 'sub PDQ_PCTL_DEVICE_SPECIFIC () {0x2;}' unless defined(&PDQ_PCTL_DEVICE_SPECIFIC);
    eval 'sub PDQ_PCTL_SUB_CMD () {0x1;}' unless defined(&PDQ_PCTL_SUB_CMD);
    eval("sub PDQ_SUB_CMD_LINK_UNINIT () { 1; }") unless defined(&PDQ_SUB_CMD_LINK_UNINIT);
    eval("sub PDQ_SUB_CMD_DMA_BURST_SIZE_SET () { 2; }") unless defined(&PDQ_SUB_CMD_DMA_BURST_SIZE_SET);
    eval("sub PDQ_SUB_CMD_PDQ_REV_GET () { 4; }") unless defined(&PDQ_SUB_CMD_PDQ_REV_GET);
    eval("sub PDQ_DMA_BURST_4LW () { 0; }") unless defined(&PDQ_DMA_BURST_4LW);
    eval("sub PDQ_DMA_BURST_8LW () { 1; }") unless defined(&PDQ_DMA_BURST_8LW);
    eval("sub PDQ_DMA_BURST_16LW () { 2; }") unless defined(&PDQ_DMA_BURST_16LW);
    eval("sub PDQ_DMA_BURST_32LW () { 3; }") unless defined(&PDQ_DMA_BURST_32LW);
    eval("sub PDQ_CHIP_REV_A_B_OR_C () { 0; }") unless defined(&PDQ_CHIP_REV_A_B_OR_C);
    eval("sub PDQ_CHIP_REV_D () { 2; }") unless defined(&PDQ_CHIP_REV_D);
    eval("sub PDQ_CHIP_REV_E () { 4; }") unless defined(&PDQ_CHIP_REV_E);
    eval 'sub PDQ_PSTS_RCV_DATA_PENDING () {0x80000000;}' unless defined(&PDQ_PSTS_RCV_DATA_PENDING);
    eval 'sub PDQ_PSTS_XMT_DATA_PENDING () {0x40000000;}' unless defined(&PDQ_PSTS_XMT_DATA_PENDING);
    eval 'sub PDQ_PSTS_HOST_SMT_PENDING () {0x20000000;}' unless defined(&PDQ_PSTS_HOST_SMT_PENDING);
    eval 'sub PDQ_PSTS_UNSOL_PENDING () {0x10000000;}' unless defined(&PDQ_PSTS_UNSOL_PENDING);
    eval 'sub PDQ_PSTS_CMD_RSP_PENDING () {0x8000000;}' unless defined(&PDQ_PSTS_CMD_RSP_PENDING);
    eval 'sub PDQ_PSTS_CMD_REQ_PENDING () {0x4000000;}' unless defined(&PDQ_PSTS_CMD_REQ_PENDING);
    eval 'sub PDQ_PSTS_TYPE_0_PENDING () {0x2000000;}' unless defined(&PDQ_PSTS_TYPE_0_PENDING);
    eval 'sub PDQ_PSTS_INTR_PENDING () {0xfe000000;}' unless defined(&PDQ_PSTS_INTR_PENDING);
    eval 'sub PDQ_PSTS_ADAPTER_STATE {
        local($sts) = @_;
	    eval q(( ((($sts) >> 8) & 0x7)));
    }' unless defined(&PDQ_PSTS_ADAPTER_STATE);
    eval 'sub PDQ_PSTS_HALT_ID {
        local($sts) = @_;
	    eval q(( (($sts) & 0xff)));
    }' unless defined(&PDQ_PSTS_HALT_ID);
    eval 'sub PDQ_HOST_INT_TX_ENABLE () {0x80000000;}' unless defined(&PDQ_HOST_INT_TX_ENABLE);
    eval 'sub PDQ_HOST_INT_RX_ENABLE () {0x40000000;}' unless defined(&PDQ_HOST_INT_RX_ENABLE);
    eval 'sub PDQ_HOST_INT_UNSOL_ENABLE () {0x20000000;}' unless defined(&PDQ_HOST_INT_UNSOL_ENABLE);
    eval 'sub PDQ_HOST_INT_HOST_SMT_ENABLE () {0x10000000;}' unless defined(&PDQ_HOST_INT_HOST_SMT_ENABLE);
    eval 'sub PDQ_HOST_INT_CMD_RSP_ENABLE () {0x8000000;}' unless defined(&PDQ_HOST_INT_CMD_RSP_ENABLE);
    eval 'sub PDQ_HOST_INT_CMD_RQST_ENABLE () {0x4000000;}' unless defined(&PDQ_HOST_INT_CMD_RQST_ENABLE);
    eval 'sub PDQ_HOST_INT_1MS () {0x80;}' unless defined(&PDQ_HOST_INT_1MS);
    eval 'sub PDQ_HOST_INT_20MS () {0x40;}' unless defined(&PDQ_HOST_INT_20MS);
    eval 'sub PDQ_HOST_INT_CSR_CMD_DONE () {0x20;}' unless defined(&PDQ_HOST_INT_CSR_CMD_DONE);
    eval 'sub PDQ_HOST_INT_STATE_CHANGE () {0x10;}' unless defined(&PDQ_HOST_INT_STATE_CHANGE);
    eval 'sub PDQ_HOST_INT_XMT_DATA_FLUSH () {0x8;}' unless defined(&PDQ_HOST_INT_XMT_DATA_FLUSH);
    eval 'sub PDQ_HOST_INT_NXM () {0x4;}' unless defined(&PDQ_HOST_INT_NXM);
    eval 'sub PDQ_HOST_INT_PM_PARITY_ERROR () {0x2;}' unless defined(&PDQ_HOST_INT_PM_PARITY_ERROR);
    eval 'sub PDQ_HOST_INT_HOST_BUS_PARITY_ERROR () {0x1;}' unless defined(&PDQ_HOST_INT_HOST_BUS_PARITY_ERROR);
    eval 'sub PDQ_HOST_INT_FATAL_ERROR () {0x7;}' unless defined(&PDQ_HOST_INT_FATAL_ERROR);
    eval("sub PDQH_SELFTEST_TIMEOUT () { 0; }") unless defined(&PDQH_SELFTEST_TIMEOUT);
    eval("sub PDQH_HOST_BUS_PARITY_ERROR () { 1; }") unless defined(&PDQH_HOST_BUS_PARITY_ERROR);
    eval("sub PDQH_HOST_DIRECTED_HALT () { 2; }") unless defined(&PDQH_HOST_DIRECTED_HALT);
    eval("sub PDQH_SOFTWARE_FAULT () { 3; }") unless defined(&PDQH_SOFTWARE_FAULT);
    eval("sub PDQH_HARDWARE_FAULT () { 4; }") unless defined(&PDQH_HARDWARE_FAULT);
    eval("sub PDQH_PC_TRACE_PATH_TEST () { 5; }") unless defined(&PDQH_PC_TRACE_PATH_TEST);
    eval("sub PDQH_DMA_ERROR () { 6; }") unless defined(&PDQH_DMA_ERROR);
    eval("sub PDQH_IMAGE_CRC_ERROR () { 7; }") unless defined(&PDQH_IMAGE_CRC_ERROR);
    eval("sub PDQH_ADAPTER_PROCESSOR_ERROR () { 8; }") unless defined(&PDQH_ADAPTER_PROCESSOR_ERROR);
    eval("sub PDQH_MAX () { 9; }") unless defined(&PDQH_MAX);
    if(defined( &BYTE_ORDER)  && (defined(&BYTE_ORDER) ? &BYTE_ORDER : 0) == (defined(&BIG_ENDIAN) ? &BIG_ENDIAN : 0)) {
	eval 'sub PDQ_BITFIELD2 {
	    local($a, $b) = @_;
    	    eval q($b, $a);
	}' unless defined(&PDQ_BITFIELD2);
	eval 'sub PDQ_BITFIELD3 {
	    local($a, $b, $c) = @_;
    	    eval q($c, $b, $a);
	}' unless defined(&PDQ_BITFIELD3);
	eval 'sub PDQ_BITFIELD4 {
	    local($a, $b, $c, $d) = @_;
    	    eval q($d, $c, $b, $a);
	}' unless defined(&PDQ_BITFIELD4);
	eval 'sub PDQ_BITFIELD5 {
	    local($a, $b, $c, $d, $e) = @_;
    	    eval q($e, $d, $c, $b, $a);
	}' unless defined(&PDQ_BITFIELD5);
	eval 'sub PDQ_BITFIELD12 {
	    local($a, $b, $c, $d, $e, $f, $g, $h, $i, $j, $k, $l) = @_;
    	    eval q($l, $k, $j, $i, $h, $g, $f, $e, $d, $c, $b, $a);
	}' unless defined(&PDQ_BITFIELD12);
    } else {
	eval 'sub PDQ_BITFIELD2 {
	    local($a, $b) = @_;
    	    eval q($a, $b);
	}' unless defined(&PDQ_BITFIELD2);
	eval 'sub PDQ_BITFIELD3 {
	    local($a, $b, $c) = @_;
    	    eval q($a, $b, $c);
	}' unless defined(&PDQ_BITFIELD3);
	eval 'sub PDQ_BITFIELD4 {
	    local($a, $b, $c, $d) = @_;
    	    eval q($a, $b, $c, $d);
	}' unless defined(&PDQ_BITFIELD4);
	eval 'sub PDQ_BITFIELD5 {
	    local($a, $b, $c, $d, $e) = @_;
    	    eval q($a, $b, $c, $d, $e);
	}' unless defined(&PDQ_BITFIELD5);
	eval 'sub PDQ_BITFIELD12 {
	    local($a, $b, $c, $d, $e, $f, $g, $h, $i, $j, $k, $l) = @_;
    	    eval q($a, $b, $c, $d, $e, $f, $g, $h, $i, $j, $k, $l);
	}' unless defined(&PDQ_BITFIELD12);
    }
    if(defined( &__alpha) || defined( &__alpha__)) {
    } else {
    }
    eval 'sub PDQ_SIZE_UNSOLICITED_EVENT () {512;}' unless defined(&PDQ_SIZE_UNSOLICITED_EVENT);
    eval 'sub PDQ_NUM_UNSOLICITED_EVENTS () {( &PDQ_OS_PAGESIZE /  &PDQ_SIZE_UNSOLICITED_EVENT);}' unless defined(&PDQ_NUM_UNSOLICITED_EVENTS);
    eval 'sub PDQ_RX_FC_OFFSET () {($sizeof{ &pdq_rxstatus_t} + 3);}' unless defined(&PDQ_RX_FC_OFFSET);
    eval 'sub PDQ_RX_SEGCNT () {(( &PDQ_FDDI_MAX +  &PDQ_OS_DATABUF_SIZE - 1) /  &PDQ_OS_DATABUF_SIZE);}' unless defined(&PDQ_RX_SEGCNT);
    eval 'sub PDQ_DO_TYPE2_PRODUCER {
        local($pdq) = @_;
	    eval q( &PDQ_CSR_WRITE(($pdq)-> &pdq_csrs,  &csr_type_2_producer, (($pdq)-> ($pdq_rx_info->{rx_producer}) << 0) | (($pdq)-> ($pdq_tx_info->{tx_producer}) << 8) | (($pdq)-> ($pdq_rx_info->{rx_completion}) << 16) | (($pdq)-> ($pdq_tx_info->{tx_completion}) << 24)));
    }' unless defined(&PDQ_DO_TYPE2_PRODUCER);
    eval 'sub PDQ_DO_HOST_SMT_PRODUCER {
        local($pdq) = @_;
	    eval q( &PDQ_CSR_WRITE(($pdq)-> &pdq_csrs,  &csr_host_smt_producer, (($pdq)-> ($pdq_host_smt_info->{rx_producer})  << 0) | (($pdq)-> ($pdq_host_smt_info->{rx_completion}) << 8)));
    }' unless defined(&PDQ_DO_HOST_SMT_PRODUCER);
    eval 'sub PDQ_ADVANCE {
        local($n, $a, $m) = @_;
	    eval q((($n) = (($n) + ($a)) & ($m)));
    }' unless defined(&PDQ_ADVANCE);
    eval 'sub PDQ_PROMISC () {0x1;}' unless defined(&PDQ_PROMISC);
    eval 'sub PDQ_ALLMULTI () {0x2;}' unless defined(&PDQ_ALLMULTI);
    eval 'sub PDQ_PASS_SMT () {0x4;}' unless defined(&PDQ_PASS_SMT);
    eval 'sub PDQ_RUNNING () {0x8;}' unless defined(&PDQ_RUNNING);
    eval 'sub PDQ_PRINTCHARS () {0x10;}' unless defined(&PDQ_PRINTCHARS);
    eval 'sub PDQ_TXOK () {0x20;}' unless defined(&PDQ_TXOK);
    eval("sub PDQC_START () { 0; }") unless defined(&PDQC_START);
    eval("sub PDQC_FILTER_SET () { 1; }") unless defined(&PDQC_FILTER_SET);
    eval("sub PDQC_FILTER_GET () { 2; }") unless defined(&PDQC_FILTER_GET);
    eval("sub PDQC_CHARS_SET () { 3; }") unless defined(&PDQC_CHARS_SET);
    eval("sub PDQC_STATUS_CHARS_GET () { 4; }") unless defined(&PDQC_STATUS_CHARS_GET);
    eval("sub PDQC_COUNTERS_GET () { 5; }") unless defined(&PDQC_COUNTERS_GET);
    eval("sub PDQC_COUNTERS_SET () { 6; }") unless defined(&PDQC_COUNTERS_SET);
    eval("sub PDQC_ADDR_FILTER_SET () { 7; }") unless defined(&PDQC_ADDR_FILTER_SET);
    eval("sub PDQC_ADDR_FILTER_GET () { 8; }") unless defined(&PDQC_ADDR_FILTER_GET);
    eval("sub PDQC_ERROR_LOG_CLEAR () { 9; }") unless defined(&PDQC_ERROR_LOG_CLEAR);
    eval("sub PDQC_ERROR_LOG_GET () { 10; }") unless defined(&PDQC_ERROR_LOG_GET);
    eval("sub PDQC_FDDI_MIB_GET () { 11; }") unless defined(&PDQC_FDDI_MIB_GET);
    eval("sub PDQC_DEC_EXT_MIB_GET () { 12; }") unless defined(&PDQC_DEC_EXT_MIB_GET);
    eval("sub PDQC_DEV_SPECIFIC_GET () { 13; }") unless defined(&PDQC_DEV_SPECIFIC_GET);
    eval("sub PDQC_SNMP_SET () { 14; }") unless defined(&PDQC_SNMP_SET);
    eval("sub PDQC_SMT_MIB_GET () { 16; }") unless defined(&PDQC_SMT_MIB_GET);
    eval("sub PDQC_SMT_MIB_SET () { 17; }") unless defined(&PDQC_SMT_MIB_SET);
    eval("sub PDQR_SUCCESS () { 0; }") unless defined(&PDQR_SUCCESS);
    eval("sub PDQR_FAILURE () { 1; }") unless defined(&PDQR_FAILURE);
    eval("sub PDQR_WARNING () { 2; }") unless defined(&PDQR_WARNING);
    eval("sub PDQR_LOOP_MODE_BAD () { 3; }") unless defined(&PDQR_LOOP_MODE_BAD);
    eval("sub PDQR_ITEM_CODE_BAD () { 4; }") unless defined(&PDQR_ITEM_CODE_BAD);
    eval("sub PDQR_TVX_BAD () { 5; }") unless defined(&PDQR_TVX_BAD);
    eval("sub PDQR_TREQ_BAD () { 6; }") unless defined(&PDQR_TREQ_BAD);
    eval("sub PDQR_RESTRICTED_TOKEN_BAD () { 7; }") unless defined(&PDQR_RESTRICTED_TOKEN_BAD);
    eval("sub PDQR_NO_EOL () { 12; }") unless defined(&PDQR_NO_EOL);
    eval("sub PDQR_FILTER_STATE_BAD () { 13; }") unless defined(&PDQR_FILTER_STATE_BAD);
    eval("sub PDQR_CMD_TYPE_BAD () { 14; }") unless defined(&PDQR_CMD_TYPE_BAD);
    eval("sub PDQR_ADAPTER_STATE_BAD () { 15; }") unless defined(&PDQR_ADAPTER_STATE_BAD);
    eval("sub PDQR_RING_PURGER_BAD () { 16; }") unless defined(&PDQR_RING_PURGER_BAD);
    eval("sub PDQR_LEM_THRESHOLD_BAD () { 17; }") unless defined(&PDQR_LEM_THRESHOLD_BAD);
    eval("sub PDQR_LOOP_NOT_SUPPORTED () { 18; }") unless defined(&PDQR_LOOP_NOT_SUPPORTED);
    eval("sub PDQR_FLUSH_TIME_BAD () { 19; }") unless defined(&PDQR_FLUSH_TIME_BAD);
    eval("sub PDQR_NOT_YET_IMPLEMENTED () { 20; }") unless defined(&PDQR_NOT_YET_IMPLEMENTED);
    eval("sub PDQR_CONFIG_POLICY_BAD () { 21; }") unless defined(&PDQR_CONFIG_POLICY_BAD);
    eval("sub PDQR_STATION_ACTION_BAD () { 22; }") unless defined(&PDQR_STATION_ACTION_BAD);
    eval("sub PDQR_MAC_ACTION_BAD () { 23; }") unless defined(&PDQR_MAC_ACTION_BAD);
    eval("sub PDQR_CON_POLICIES_BAD () { 24; }") unless defined(&PDQR_CON_POLICIES_BAD);
    eval("sub PDQR_MAC_LOOP_TIME_BAD () { 25; }") unless defined(&PDQR_MAC_LOOP_TIME_BAD);
    eval("sub PDQR_TB_MAX_BAD () { 26; }") unless defined(&PDQR_TB_MAX_BAD);
    eval("sub PDQR_LER_CUTOFF_BAD () { 27; }") unless defined(&PDQR_LER_CUTOFF_BAD);
    eval("sub PDQR_LER_ALARM_BAD () { 28; }") unless defined(&PDQR_LER_ALARM_BAD);
    eval("sub PDQR_MAC_PATHS_REQ_BAD () { 29; }") unless defined(&PDQR_MAC_PATHS_REQ_BAD);
    eval("sub PDQR_MAC_T_REQ_BAD () { 30; }") unless defined(&PDQR_MAC_T_REQ_BAD);
    eval("sub PDQR_EMAC_RING_PURGER_BAD () { 31; }") unless defined(&PDQR_EMAC_RING_PURGER_BAD);
    eval("sub PDQR_EMAC_RTOKEN_TIMOUT_AD () { 32; }") unless defined(&PDQR_EMAC_RTOKEN_TIMOUT_AD);
    eval("sub PDQR_NO_SUCH_ENTRY () { 33; }") unless defined(&PDQR_NO_SUCH_ENTRY);
    eval("sub PDQR_T_NOTIFY_BAD () { 34; }") unless defined(&PDQR_T_NOTIFY_BAD);
    eval("sub PDQR_TR_MAX_EXP_BAD () { 35; }") unless defined(&PDQR_TR_MAX_EXP_BAD);
    eval("sub PDQR_FRAME_ERR_THRESHOLD_BAD () { 36; }") unless defined(&PDQR_FRAME_ERR_THRESHOLD_BAD);
    eval("sub PDQR_MAX_TREQ_BAD () { 37; }") unless defined(&PDQR_MAX_TREQ_BAD);
    eval("sub PDQR_FULL_DUPLEX_ENABLE_BAD () { 38; }") unless defined(&PDQR_FULL_DUPLEX_ENABLE_BAD);
    eval("sub PDQR_ITEM_INDEX_BAD () { 39; }") unless defined(&PDQR_ITEM_INDEX_BAD);
    eval("sub PDQI_EOL () { 0; }") unless defined(&PDQI_EOL);
    eval("sub PDQI_T_REQ () { 1; }") unless defined(&PDQI_T_REQ);
    eval("sub PDQI_TVX () { 2; }") unless defined(&PDQI_TVX);
    eval("sub PDQI_RESTRICTED_TOKEN () { 3; }") unless defined(&PDQI_RESTRICTED_TOKEN);
    eval("sub PDQI_LEM_THRESHOLD () { 4; }") unless defined(&PDQI_LEM_THRESHOLD);
    eval("sub PDQI_RING_PURGER () { 5; }") unless defined(&PDQI_RING_PURGER);
    eval("sub PDQI_COUNTER_INTERVAL () { 6; }") unless defined(&PDQI_COUNTER_INTERVAL);
    eval("sub PDQI_IND_GROUP_PROM () { 7; }") unless defined(&PDQI_IND_GROUP_PROM);
    eval("sub PDQI_GROUP_PROM () { 8; }") unless defined(&PDQI_GROUP_PROM);
    eval("sub PDQI_BROADCAST () { 9; }") unless defined(&PDQI_BROADCAST);
    eval("sub PDQI_SMT_PROM () { 10; }") unless defined(&PDQI_SMT_PROM);
    eval("sub PDQI_SMT_USER () { 11; }") unless defined(&PDQI_SMT_USER);
    eval("sub PDQI_RESERVED () { 12; }") unless defined(&PDQI_RESERVED);
    eval("sub PDQI_IMPLEMENTOR () { 13; }") unless defined(&PDQI_IMPLEMENTOR);
    eval("sub PDQI_LOOPBACK_MODE () { 14; }") unless defined(&PDQI_LOOPBACK_MODE);
    eval("sub PDQI_SMT_CONFIG_POLICY () { 16; }") unless defined(&PDQI_SMT_CONFIG_POLICY);
    eval("sub PDQI_SMT_CONNECTION_POLICY () { 17; }") unless defined(&PDQI_SMT_CONNECTION_POLICY);
    eval("sub PDQI_SMT_T_NOTIFY () { 18; }") unless defined(&PDQI_SMT_T_NOTIFY);
    eval("sub PDQI_SMT_STATION_ACTION () { 19; }") unless defined(&PDQI_SMT_STATION_ACTION);
    eval("sub PDQI_MAC_PATHS_REQUESTED () { 21; }") unless defined(&PDQI_MAC_PATHS_REQUESTED);
    eval("sub PDQI_MAC_ACTION () { 23; }") unless defined(&PDQI_MAC_ACTION);
    eval("sub PDQI_PORT_CONNECTION_POLICIES () { 24; }") unless defined(&PDQI_PORT_CONNECTION_POLICIES);
    eval("sub PDQI_PORT_PATHS_REQUESTED () { 25; }") unless defined(&PDQI_PORT_PATHS_REQUESTED);
    eval("sub PDQI_PORT_MAC_LOOP_TIME () { 26; }") unless defined(&PDQI_PORT_MAC_LOOP_TIME);
    eval("sub PDQI_PORT_TB_MAX () { 27; }") unless defined(&PDQI_PORT_TB_MAX);
    eval("sub PDQI_PORT_LER_CUTOFF () { 28; }") unless defined(&PDQI_PORT_LER_CUTOFF);
    eval("sub PDQI_PORT_LER_ALARM () { 29; }") unless defined(&PDQI_PORT_LER_ALARM);
    eval("sub PDQI_PORT_ACTION () { 30; }") unless defined(&PDQI_PORT_ACTION);
    eval("sub PDQI_FLUSH_TIME () { 32; }") unless defined(&PDQI_FLUSH_TIME);
    eval("sub PDQI_SMT_USER_DATA () { 33; }") unless defined(&PDQI_SMT_USER_DATA);
    eval("sub PDQI_SMT_STATUS_REPORT_POLICY () { 34; }") unless defined(&PDQI_SMT_STATUS_REPORT_POLICY);
    eval("sub PDQI_SMT_TRACE_MAX_EXPIRATION () { 35; }") unless defined(&PDQI_SMT_TRACE_MAX_EXPIRATION);
    eval("sub PDQI_MAC_FRAME_ERR_THRESHOLD () { 36; }") unless defined(&PDQI_MAC_FRAME_ERR_THRESHOLD);
    eval("sub PDQI_MAC_UNIT_DATA_ENABLE () { 37; }") unless defined(&PDQI_MAC_UNIT_DATA_ENABLE);
    eval("sub PDQI_PATH_TVX_LOWER_BOUND () { 38; }") unless defined(&PDQI_PATH_TVX_LOWER_BOUND);
    eval("sub PDQI_PATH_TMAX_LOWER_BOUND () { 39; }") unless defined(&PDQI_PATH_TMAX_LOWER_BOUND);
    eval("sub PDQI_PATH_MAX_TREQ () { 40; }") unless defined(&PDQI_PATH_MAX_TREQ);
    eval("sub PDQI_MAC_TREQ () { 41; }") unless defined(&PDQI_MAC_TREQ);
    eval("sub PDQI_EMAC_RING_PURGER () { 42; }") unless defined(&PDQI_EMAC_RING_PURGER);
    eval("sub PDQI_EMAC_RTOKEN_TIMEOUT () { 43; }") unless defined(&PDQI_EMAC_RTOKEN_TIMEOUT);
    eval("sub PDQI_FULL_DUPLEX_ENABLE () { 44; }") unless defined(&PDQI_FULL_DUPLEX_ENABLE);
    eval("sub PDQ_FALSE () { 0; }") unless defined(&PDQ_FALSE);
    eval("sub PDQ_TRUE () { 1; }") unless defined(&PDQ_TRUE);
    eval("sub PDQ_FILTER_BLOCK () { 0; }") unless defined(&PDQ_FILTER_BLOCK);
    eval("sub PDQ_FILTER_PASS () { 1; }") unless defined(&PDQ_FILTER_PASS);
    eval("sub PDQ_STATION_TYPE_SAS () { 0; }") unless defined(&PDQ_STATION_TYPE_SAS);
    eval("sub PDQ_STATION_TYPE_DAC () { 1; }") unless defined(&PDQ_STATION_TYPE_DAC);
    eval("sub PDQ_STATION_TYPE_SAC () { 2; }") unless defined(&PDQ_STATION_TYPE_SAC);
    eval("sub PDQ_STATION_TYPE_NAC () { 3; }") unless defined(&PDQ_STATION_TYPE_NAC);
    eval("sub PDQ_STATION_TYPE_DAS () { 4; }") unless defined(&PDQ_STATION_TYPE_DAS);
    eval("sub PDQ_STATION_STATE_OFF () { 0; }") unless defined(&PDQ_STATION_STATE_OFF);
    eval("sub PDQ_STATION_STATE_ON () { 1; }") unless defined(&PDQ_STATION_STATE_ON);
    eval("sub PDQ_STATION_STATE_LOOPBACK () { 2; }") unless defined(&PDQ_STATION_STATE_LOOPBACK);
    eval("sub PDQ_LINK_STATE_OFF_READY () { 1; }") unless defined(&PDQ_LINK_STATE_OFF_READY);
    eval("sub PDQ_LINK_STATE_OFF_FAULT_RECOVERY () { 2; }") unless defined(&PDQ_LINK_STATE_OFF_FAULT_RECOVERY);
    eval("sub PDQ_LINK_STATE_ON_RING_INIT () { 3; }") unless defined(&PDQ_LINK_STATE_ON_RING_INIT);
    eval("sub PDQ_LINK_STATE_ON_RING_RUN () { 4; }") unless defined(&PDQ_LINK_STATE_ON_RING_RUN);
    eval("sub PDQ_LINK_STATE_BROKEN () { 5; }") unless defined(&PDQ_LINK_STATE_BROKEN);
    eval("sub PDQ_DA_TEST_STATE_UNKNOWN () { 0; }") unless defined(&PDQ_DA_TEST_STATE_UNKNOWN);
    eval("sub PDQ_DA_TEST_STATE_SUCCESS () { 1; }") unless defined(&PDQ_DA_TEST_STATE_SUCCESS);
    eval("sub PDQ_DA_TEST_STATE_DUPLICATE () { 2; }") unless defined(&PDQ_DA_TEST_STATE_DUPLICATE);
    eval("sub PDQ_RING_PURGER_STATE_OFF () { 0; }") unless defined(&PDQ_RING_PURGER_STATE_OFF);
    eval("sub PDQ_RING_PURGER_STATE_CANDIDATE () { 1; }") unless defined(&PDQ_RING_PURGER_STATE_CANDIDATE);
    eval("sub PDQ_RING_PURGER_STATE_NON_PURGER () { 2; }") unless defined(&PDQ_RING_PURGER_STATE_NON_PURGER);
    eval("sub PDQ_RING_PURGER_STATE_PURGER () { 3; }") unless defined(&PDQ_RING_PURGER_STATE_PURGER);
    eval("sub PDQ_FRAME_STRING_MODE_SA_MATCH () { 0; }") unless defined(&PDQ_FRAME_STRING_MODE_SA_MATCH);
    eval("sub PDQ_FRAME_STRING_MODE_FCI_STRIP () { 1; }") unless defined(&PDQ_FRAME_STRING_MODE_FCI_STRIP);
    eval("sub PDQ_RING_ERROR_REASON_NO_ERROR () { 0; }") unless defined(&PDQ_RING_ERROR_REASON_NO_ERROR);
    eval("sub PDQ_RING_ERROR_REASON_RING_INIT_INITIATED () { 5; }") unless defined(&PDQ_RING_ERROR_REASON_RING_INIT_INITIATED);
    eval("sub PDQ_RING_ERROR_REASON_RING_INIT_RECEIVED () { 6; }") unless defined(&PDQ_RING_ERROR_REASON_RING_INIT_RECEIVED);
    eval("sub PDQ_RING_ERROR_REASON_RING_BEACONING_INITIATED () { 7; }") unless defined(&PDQ_RING_ERROR_REASON_RING_BEACONING_INITIATED);
    eval("sub PDQ_RING_ERROR_REASON_DUPLICATE_ADDRESS_DETECTED () { 8; }") unless defined(&PDQ_RING_ERROR_REASON_DUPLICATE_ADDRESS_DETECTED);
    eval("sub PDQ_RING_ERROR_REASON_DUPLICATE_TOKEN_DETECTED () { 9; }") unless defined(&PDQ_RING_ERROR_REASON_DUPLICATE_TOKEN_DETECTED);
    eval("sub PDQ_RING_ERROR_REASON_RING_PURGER_ERROR () { 10; }") unless defined(&PDQ_RING_ERROR_REASON_RING_PURGER_ERROR);
    eval("sub PDQ_RING_ERROR_REASON_FCI_STRIP_ERROR () { 11; }") unless defined(&PDQ_RING_ERROR_REASON_FCI_STRIP_ERROR);
    eval("sub PDQ_RING_ERROR_REASON_RING_OP_OSCILLATION () { 12; }") unless defined(&PDQ_RING_ERROR_REASON_RING_OP_OSCILLATION);
    eval("sub PDQ_RING_ERROR_REASON_DIRECTED_BEACON_RECEVIED () { 13; }") unless defined(&PDQ_RING_ERROR_REASON_DIRECTED_BEACON_RECEVIED);
    eval("sub PDQ_RING_ERROR_REASON_PC_TRACE_INITIATED () { 14; }") unless defined(&PDQ_RING_ERROR_REASON_PC_TRACE_INITIATED);
    eval("sub PDQ_RING_ERROR_REASON_PC_TRACE_RECEVIED () { 15; }") unless defined(&PDQ_RING_ERROR_REASON_PC_TRACE_RECEVIED);
    eval("sub PDQ_STATION_MODE_NORMAL () { 0; }") unless defined(&PDQ_STATION_MODE_NORMAL);
    eval("sub PDQ_STATION_MODE_INTERNAL_LOOPBACK () { 1; }") unless defined(&PDQ_STATION_MODE_INTERNAL_LOOPBACK);
    eval("sub PDQ_PHY_TYPE_A () { 0; }") unless defined(&PDQ_PHY_TYPE_A);
    eval("sub PDQ_PHY_TYPE_B () { 1; }") unless defined(&PDQ_PHY_TYPE_B);
    eval("sub PDQ_PHY_TYPE_S () { 2; }") unless defined(&PDQ_PHY_TYPE_S);
    eval("sub PDQ_PHY_TYPE_M () { 3; }") unless defined(&PDQ_PHY_TYPE_M);
    eval("sub PDQ_PHY_TYPE_UNKNOWN () { 4; }") unless defined(&PDQ_PHY_TYPE_UNKNOWN);
    eval("sub PDQ_PMD_TYPE_ANSI_MUTLI_MODE () { 0; }") unless defined(&PDQ_PMD_TYPE_ANSI_MUTLI_MODE);
    eval("sub PDQ_PMD_TYPE_ANSI_SINGLE_MODE_TYPE_1 () { 1; }") unless defined(&PDQ_PMD_TYPE_ANSI_SINGLE_MODE_TYPE_1);
    eval("sub PDQ_PMD_TYPE_ANSI_SIGNLE_MODE_TYPE_2 () { 2; }") unless defined(&PDQ_PMD_TYPE_ANSI_SIGNLE_MODE_TYPE_2);
    eval("sub PDQ_PMD_TYPE_ANSI_SONET () { 3; }") unless defined(&PDQ_PMD_TYPE_ANSI_SONET);
    eval("sub PDQ_PMD_TYPE_LOW_POWER () { 100; }") unless defined(&PDQ_PMD_TYPE_LOW_POWER);
    eval("sub PDQ_PMD_TYPE_THINWIRE () { 101; }") unless defined(&PDQ_PMD_TYPE_THINWIRE);
    eval("sub PDQ_PMD_TYPE_SHIELDED_TWISTED_PAIR () { 102; }") unless defined(&PDQ_PMD_TYPE_SHIELDED_TWISTED_PAIR);
    eval("sub PDQ_PMD_TYPE_UNSHIELDED_TWISTED_PAIR () { 103; }") unless defined(&PDQ_PMD_TYPE_UNSHIELDED_TWISTED_PAIR);
    eval("sub PDQ_PMD_CLASS_ANSI_MULTI_MODE () { 0; }") unless defined(&PDQ_PMD_CLASS_ANSI_MULTI_MODE);
    eval("sub PDQ_PMD_CLASS_SINGLE_MODE_TYPE_1 () { 1; }") unless defined(&PDQ_PMD_CLASS_SINGLE_MODE_TYPE_1);
    eval("sub PDQ_PMD_CLASS_SINGLE_MODE_TYPE_2 () { 2; }") unless defined(&PDQ_PMD_CLASS_SINGLE_MODE_TYPE_2);
    eval("sub PDQ_PMD_CLASS_SONET () { 3; }") unless defined(&PDQ_PMD_CLASS_SONET);
    eval("sub PDQ_PMD_CLASS_LOW_COST_POWER_FIBER () { 4; }") unless defined(&PDQ_PMD_CLASS_LOW_COST_POWER_FIBER);
    eval("sub PDQ_PMD_CLASS_TWISTED_PAIR () { 5; }") unless defined(&PDQ_PMD_CLASS_TWISTED_PAIR);
    eval("sub PDQ_PMD_CLASS_UNKNOWN () { 6; }") unless defined(&PDQ_PMD_CLASS_UNKNOWN);
    eval("sub PDQ_PMD_CLASS_UNSPECIFIED () { 7; }") unless defined(&PDQ_PMD_CLASS_UNSPECIFIED);
    eval("sub PDQ_PHY_STATE_INTERNAL_LOOPBACK () { 0; }") unless defined(&PDQ_PHY_STATE_INTERNAL_LOOPBACK);
    eval("sub PDQ_PHY_STATE_BROKEN () { 1; }") unless defined(&PDQ_PHY_STATE_BROKEN);
    eval("sub PDQ_PHY_STATE_OFF_READY () { 2; }") unless defined(&PDQ_PHY_STATE_OFF_READY);
    eval("sub PDQ_PHY_STATE_WAITING () { 3; }") unless defined(&PDQ_PHY_STATE_WAITING);
    eval("sub PDQ_PHY_STATE_STARTING () { 4; }") unless defined(&PDQ_PHY_STATE_STARTING);
    eval("sub PDQ_PHY_STATE_FAILED () { 5; }") unless defined(&PDQ_PHY_STATE_FAILED);
    eval("sub PDQ_PHY_STATE_WATCH () { 6; }") unless defined(&PDQ_PHY_STATE_WATCH);
    eval("sub PDQ_PHY_STATE_INUSE () { 7; }") unless defined(&PDQ_PHY_STATE_INUSE);
    eval("sub PDQ_REJECT_REASON_NONE () { 0; }") unless defined(&PDQ_REJECT_REASON_NONE);
    eval("sub PDQ_REJECT_REASON_LOCAL_LCT () { 1; }") unless defined(&PDQ_REJECT_REASON_LOCAL_LCT);
    eval("sub PDQ_REJECT_REASON_REMOTE_LCT () { 2; }") unless defined(&PDQ_REJECT_REASON_REMOTE_LCT);
    eval("sub PDQ_REJECT_REASON_LCT_BOTH_SIDES () { 3; }") unless defined(&PDQ_REJECT_REASON_LCT_BOTH_SIDES);
    eval("sub PDQ_REJECT_REASON_LEM_REJECT () { 4; }") unless defined(&PDQ_REJECT_REASON_LEM_REJECT);
    eval("sub PDQ_REJECT_REASON_TOPOLOGY_ERROR () { 5; }") unless defined(&PDQ_REJECT_REASON_TOPOLOGY_ERROR);
    eval("sub PDQ_REJECT_REASON_NOISE_REJECT () { 6; }") unless defined(&PDQ_REJECT_REASON_NOISE_REJECT);
    eval("sub PDQ_REJECT_REASON_REMOTE_REJECT () { 7; }") unless defined(&PDQ_REJECT_REASON_REMOTE_REJECT);
    eval("sub PDQ_REJECT_REASON_TRACE_IN_PROGRESS () { 8; }") unless defined(&PDQ_REJECT_REASON_TRACE_IN_PROGRESS);
    eval("sub PDQ_REJECT_REASON_TRACE_RECEIVED_DISABLED () { 9; }") unless defined(&PDQ_REJECT_REASON_TRACE_RECEIVED_DISABLED);
    eval("sub PDQ_REJECT_REASON_STANDBY () { 10; }") unless defined(&PDQ_REJECT_REASON_STANDBY);
    eval("sub PDQ_REJECT_REASON_LCT_PROTOCOL_ERROR () { 11; }") unless defined(&PDQ_REJECT_REASON_LCT_PROTOCOL_ERROR);
    eval("sub PDQ_BROKEN_REASON_NONE () { 0; }") unless defined(&PDQ_BROKEN_REASON_NONE);
    eval("sub PDQ_RI_REASON_TVX_EXPIRED () { 0; }") unless defined(&PDQ_RI_REASON_TVX_EXPIRED);
    eval("sub PDQ_RI_REASON_TRT_EXPIRED () { 1; }") unless defined(&PDQ_RI_REASON_TRT_EXPIRED);
    eval("sub PDQ_RI_REASON_RING_PURGER_ELECTION_ATTEMPT_LIMIT_EXCEEDED () { 2; }") unless defined(&PDQ_RI_REASON_RING_PURGER_ELECTION_ATTEMPT_LIMIT_EXCEEDED);
    eval("sub PDQ_RI_REASON_PURGE_ERROR_LIMIT_EXCEEDED () { 3; }") unless defined(&PDQ_RI_REASON_PURGE_ERROR_LIMIT_EXCEEDED);
    eval("sub PDQ_RI_REASON_RESTRICTED_TOKEN_TIMEOUT () { 4; }") unless defined(&PDQ_RI_REASON_RESTRICTED_TOKEN_TIMEOUT);
    eval("sub PDQ_LCT_DIRECTION_LOCAL_LCT () { 0; }") unless defined(&PDQ_LCT_DIRECTION_LOCAL_LCT);
    eval("sub PDQ_LCT_DIRECTION_REMOTE_LCT () { 1; }") unless defined(&PDQ_LCT_DIRECTION_REMOTE_LCT);
    eval("sub PDQ_LCT_DIRECTION_LCT_BOTH_SIDES () { 2; }") unless defined(&PDQ_LCT_DIRECTION_LCT_BOTH_SIDES);
    eval("sub PDQ_PORT_A () { 0; }") unless defined(&PDQ_PORT_A);
    eval("sub PDQ_PORT_B () { 1; }") unless defined(&PDQ_PORT_B);
    eval 'sub PDQ_SIZE_RESPONSE_FILTER_GET () {0x28;}' unless defined(&PDQ_SIZE_RESPONSE_FILTER_GET);
    eval 'sub PDQ_SIZE_CMD_ADDR_FILTER_SET () {0x1f4;}' unless defined(&PDQ_SIZE_CMD_ADDR_FILTER_SET);
    eval 'sub PDQ_SIZE_RESPONSE_ADDR_FILTER_GET () {0x1fc;}' unless defined(&PDQ_SIZE_RESPONSE_ADDR_FILTER_GET);
    eval 'sub PDQ_SIZE_RESPONSE_STATUS_CHARS_GET () {0xf0;}' unless defined(&PDQ_SIZE_RESPONSE_STATUS_CHARS_GET);
    eval 'sub PDQ_SIZE_RESPONSE_FDDI_MIB_GET () {0x17c;}' unless defined(&PDQ_SIZE_RESPONSE_FDDI_MIB_GET);
    eval("sub PDQ_FDX_STATE_IDLE () { 0; }") unless defined(&PDQ_FDX_STATE_IDLE);
    eval("sub PDQ_FDX_STATE_REQUEST () { 1; }") unless defined(&PDQ_FDX_STATE_REQUEST);
    eval("sub PDQ_FDX_STATE_CONFIRM () { 2; }") unless defined(&PDQ_FDX_STATE_CONFIRM);
    eval("sub PDQ_FDX_STATE_OPERATION () { 3; }") unless defined(&PDQ_FDX_STATE_OPERATION);
    eval 'sub PDQ_SIZE_RESPONSE_DEC_EXT_MIB_GET () {0x50;}' unless defined(&PDQ_SIZE_RESPONSE_DEC_EXT_MIB_GET);
    eval("sub PDQ_CALLER_ID_NONE () { 0; }") unless defined(&PDQ_CALLER_ID_NONE);
    eval("sub PDQ_CALLER_ID_SELFTEST () { 1; }") unless defined(&PDQ_CALLER_ID_SELFTEST);
    eval("sub PDQ_CALLER_ID_MFG () { 2; }") unless defined(&PDQ_CALLER_ID_MFG);
    eval("sub PDQ_CALLER_ID_FIRMWARE () { 5; }") unless defined(&PDQ_CALLER_ID_FIRMWARE);
    eval("sub PDQ_CALLER_ID_CONSOLE () { 8; }") unless defined(&PDQ_CALLER_ID_CONSOLE);
    eval("sub PDQ_UNSOLICITED_EVENT () { 0; }") unless defined(&PDQ_UNSOLICITED_EVENT);
    eval("sub PDQ_UNSOLICITED_COUNTERS () { 1; }") unless defined(&PDQ_UNSOLICITED_COUNTERS);
    eval("sub PDQ_ENTITY_STATION () { 0; }") unless defined(&PDQ_ENTITY_STATION);
    eval("sub PDQ_ENTITY_LINK () { 1; }") unless defined(&PDQ_ENTITY_LINK);
    eval("sub PDQ_ENTITY_PHY_PORT () { 2; }") unless defined(&PDQ_ENTITY_PHY_PORT);
    eval("sub PDQ_STATION_EVENT_TRACE_RECEIVED () { 1; }") unless defined(&PDQ_STATION_EVENT_TRACE_RECEIVED);
    eval("sub PDQ_STATION_EVENT_ARGUMENT_REASON () { 0; }") unless defined(&PDQ_STATION_EVENT_ARGUMENT_REASON);
    eval("sub PDQ_STATION_EVENT_ARGUMENT_EOL () { 0xFF; }") unless defined(&PDQ_STATION_EVENT_ARGUMENT_EOL);
    eval("sub PDQ_LINK_EVENT_TRANSMIT_UNDERRUN () { 0; }") unless defined(&PDQ_LINK_EVENT_TRANSMIT_UNDERRUN);
    eval("sub PDQ_LINK_EVENT_TRANSMIT_FAILED () { 1; }") unless defined(&PDQ_LINK_EVENT_TRANSMIT_FAILED);
    eval("sub PDQ_LINK_EVENT_BLOCK_CHECK_ERROR () { 2; }") unless defined(&PDQ_LINK_EVENT_BLOCK_CHECK_ERROR);
    eval("sub PDQ_LINK_EVENT_FRAME_STATUS_ERROR () { 3; }") unless defined(&PDQ_LINK_EVENT_FRAME_STATUS_ERROR);
    eval("sub PDQ_LINK_EVENT_PDU_LENGTH_ERROR () { 4; }") unless defined(&PDQ_LINK_EVENT_PDU_LENGTH_ERROR);
    eval("sub PDQ_LINK_EVENT_RECEIVE_DATA_OVERRUN () { 7; }") unless defined(&PDQ_LINK_EVENT_RECEIVE_DATA_OVERRUN);
    eval("sub PDQ_LINK_EVENT_NO_USER_BUFFER () { 9; }") unless defined(&PDQ_LINK_EVENT_NO_USER_BUFFER);
    eval("sub PDQ_LINK_EVENT_RING_INITIALIZATION_INITIATED () { 10; }") unless defined(&PDQ_LINK_EVENT_RING_INITIALIZATION_INITIATED);
    eval("sub PDQ_LINK_EVENT_RING_INITIALIZATION_RECEIVED () { 11; }") unless defined(&PDQ_LINK_EVENT_RING_INITIALIZATION_RECEIVED);
    eval("sub PDQ_LINK_EVENT_RING_BEACON_INITIATED () { 12; }") unless defined(&PDQ_LINK_EVENT_RING_BEACON_INITIATED);
    eval("sub PDQ_LINK_EVENT_DUPLICATE_ADDRESS_FAILURE () { 13; }") unless defined(&PDQ_LINK_EVENT_DUPLICATE_ADDRESS_FAILURE);
    eval("sub PDQ_LINK_EVENT_DUPLICATE_TOKEN_DETECTED () { 14; }") unless defined(&PDQ_LINK_EVENT_DUPLICATE_TOKEN_DETECTED);
    eval("sub PDQ_LINK_EVENT_RING_PURGE_ERROR () { 15; }") unless defined(&PDQ_LINK_EVENT_RING_PURGE_ERROR);
    eval("sub PDQ_LINK_EVENT_FCI_STRIP_ERROR () { 16; }") unless defined(&PDQ_LINK_EVENT_FCI_STRIP_ERROR);
    eval("sub PDQ_LINK_EVENT_TRACE_INITIATED () { 17; }") unless defined(&PDQ_LINK_EVENT_TRACE_INITIATED);
    eval("sub PDQ_LINK_EVENT_DIRECTED_BEACON_RECEIVED () { 18; }") unless defined(&PDQ_LINK_EVENT_DIRECTED_BEACON_RECEIVED);
    eval("sub PDQ_LINK_EVENT_ARGUMENT_REASON () { 0; }") unless defined(&PDQ_LINK_EVENT_ARGUMENT_REASON);
    eval("sub PDQ_LINK_EVENT_ARGUMENT_DATA_LINK_HEADER () { 1; }") unless defined(&PDQ_LINK_EVENT_ARGUMENT_DATA_LINK_HEADER);
    eval("sub PDQ_LINK_EVENT_ARGUMENT_SOURCE () { 2; }") unless defined(&PDQ_LINK_EVENT_ARGUMENT_SOURCE);
    eval("sub PDQ_LINK_EVENT_ARGUMENT_UPSTREAM_NEIGHBOR () { 3; }") unless defined(&PDQ_LINK_EVENT_ARGUMENT_UPSTREAM_NEIGHBOR);
    eval("sub PDQ_LINK_EVENT_ARGUMENT_EOL () { 0xFF; }") unless defined(&PDQ_LINK_EVENT_ARGUMENT_EOL);
    eval("sub PDQ_PHY_EVENT_LEM_ERROR_MONITOR_REJECT () { 0; }") unless defined(&PDQ_PHY_EVENT_LEM_ERROR_MONITOR_REJECT);
    eval("sub PDQ_PHY_EVENT_ELASTICITY_BUFFER_ERROR () { 1; }") unless defined(&PDQ_PHY_EVENT_ELASTICITY_BUFFER_ERROR);
    eval("sub PDQ_PHY_EVENT_LINK_CONFIDENCE_TEST_REJECT () { 2; }") unless defined(&PDQ_PHY_EVENT_LINK_CONFIDENCE_TEST_REJECT);
    eval("sub PDQ_PHY_EVENT_ARGUMENT_DIRECTION () { 0; }") unless defined(&PDQ_PHY_EVENT_ARGUMENT_DIRECTION);
    eval("sub PDQ_PHY_EVENT_ARGUMENT_EOL () { 0xFF; }") unless defined(&PDQ_PHY_EVENT_ARGUMENT_EOL);
}
1;
