dnl $KTH: check-man.m4,v 1.3 2000/11/30 01:47:17 joda Exp $
dnl check how to format manual pages
dnl

AC_DEFUN(rk_CHECK_MAN,
[AC_PATH_PROG(NROFF, nroff)
AC_PATH_PROG(GROFF, groff)
AC_CACHE_CHECK(how to format man pages,ac_cv_sys_man_format,
[cat > conftest.1 << END
.Dd January 1, 1970
.Dt CONFTEST 1
.Sh NAME
.Nm conftest
.Nd
foobar
END

if test "$NROFF" ; then
	for i in "-mdoc" "-mandoc"; do
		if "$NROFF" $i conftest.1 2> /dev/null | \
			grep Jan > /dev/null 2>&1 ; then
			ac_cv_sys_man_format="$NROFF $i"
			break
		fi
	done
fi
if test "$ac_cv_sys_man_format" = "" -a "$GROFF" ; then
	for i in "-mdoc" "-mandoc"; do
		if "$GROFF" -Tascii $i conftest.1 2> /dev/null | \
			grep Jan > /dev/null 2>&1 ; then
			ac_cv_sys_man_format="$GROFF -Tascii $i"
			break
		fi
	done
fi
if test "$ac_cv_sys_man_format"; then
	ac_cv_sys_man_format="$ac_cv_sys_man_format \[$]< > \[$]@"
fi
])
if test "$ac_cv_sys_man_format"; then
	CATMAN="$ac_cv_sys_man_format"
	AC_SUBST(CATMAN)
fi
AM_CONDITIONAL(CATMAN, test "$CATMAN")
AC_CACHE_CHECK(extension of pre-formatted manual pages,ac_cv_sys_catman_ext,
[if grep _suffix /etc/man.conf > /dev/null 2>&1; then
	ac_cv_sys_catman_ext=0
else
	ac_cv_sys_catman_ext=number
fi
])
if test "$ac_cv_sys_catman_ext" = number; then
	CATMANEXT='$$section'
else
	CATMANEXT=0
fi
AC_SUBST(CATMANEXT)
])