require '_h2ph_pre.ph';

unless(defined(&PDC2xx_STATE)) {
    sub PDC2xx_STATE () {	0x50;}
}
unless(defined(&PDC2xx_STATE_IDERAID)) {
    sub PDC2xx_STATE_IDERAID () {	0x0001;}
}
unless(defined(&PDC2xx_STATE_NATIVE)) {
    sub PDC2xx_STATE_NATIVE () {	0x0080;}
}
unless(defined(&PDC246_STATE_SHIPID)) {
    sub PDC246_STATE_SHIPID () {	0x8000;}
}
unless(defined(&PDC246_STATE_IOCHRDY)) {
    sub PDC246_STATE_IOCHRDY () {	0x0400;}
}
unless(defined(&PDC246_STATE_LBA)) {
    sub PDC246_STATE_LBA {
	local($channel) = @_;
	eval q((0x0100 << ($channel)));
    }
}
unless(defined(&PDC246_STATE_ISAIRQ)) {
    sub PDC246_STATE_ISAIRQ () {	0x0008;}
}
unless(defined(&PDC246_STATE_EN)) {
    sub PDC246_STATE_EN {
	local($channel) = @_;
	eval q((0x0002 << ($channel)));
    }
}
unless(defined(&PDC262_STATE_EN)) {
    sub PDC262_STATE_EN {
	local($chan) = @_;
	eval q((0x1000 << ($chan)));
    }
}
unless(defined(&PDC262_STATE_80P)) {
    sub PDC262_STATE_80P {
	local($chan) = @_;
	eval q((0x0400 << ($chan)));
    }
}
unless(defined(&PDC2xx_TIM)) {
    sub PDC2xx_TIM {
	local($channel, $drive) = @_;
	eval q((0x60 + 4* ($drive) + 8* ($channel)));
    }
}
unless(defined(&PDC2xx_TIM_SET_PA)) {
    sub PDC2xx_TIM_SET_PA {
	local($r, $x) = @_;
	eval q(((($r) & 0xfffffff0) | (($x) & 0xf)));
    }
}
unless(defined(&PDC2xx_TIM_SET_PB)) {
    sub PDC2xx_TIM_SET_PB {
	local($r, $x) = @_;
	eval q(((($r) & 0xffffe0ff) | ((($x) & 0x1f) << 8)));
    }
}
unless(defined(&PDC2xx_TIM_SET_MB)) {
    sub PDC2xx_TIM_SET_MB {
	local($r, $x) = @_;
	eval q(((($r) & 0xffff1fff) | ((($x) & 0x7) << 13)));
    }
}
unless(defined(&PDC2xx_TIM_SET_MC)) {
    sub PDC2xx_TIM_SET_MC {
	local($r, $x) = @_;
	eval q(((($r) & 0xfff0ffff) | ((($x) & 0xf) << 16)));
    }
}
unless(defined(&PDC2xx_TIM_PRE)) {
    sub PDC2xx_TIM_PRE () {	0x00000010;}
}
unless(defined(&PDC2xx_TIM_IORDY)) {
    sub PDC2xx_TIM_IORDY () {	0x00000020;}
}
unless(defined(&PDC2xx_TIM_ERRDY)) {
    sub PDC2xx_TIM_ERRDY () {	0x00000040;}
}
unless(defined(&PDC2xx_TIM_SYNC)) {
    sub PDC2xx_TIM_SYNC () {	0x00000080;}
}
unless(defined(&PDC2xx_TIM_DMAW)) {
    sub PDC2xx_TIM_DMAW () {	0x00100000;}
}
unless(defined(&PDC2xx_TIM_DMAR)) {
    sub PDC2xx_TIM_DMAR () {	0x00200000;}
}
unless(defined(&PDC2xx_TIM_IORDYp)) {
    sub PDC2xx_TIM_IORDYp () {	0x00400000;}
}
unless(defined(&PDC2xx_TIM_DMARQp)) {
    sub PDC2xx_TIM_DMARQp () {	0x00800000;}
}
unless(defined(&PDC262_U66)) {
    sub PDC262_U66 () {	0x11;}
}
unless(defined(&PDC262_U66_EN)) {
    sub PDC262_U66_EN {
	local($chan) = @_;
	eval q((0x2 << (($chan) *2)));
    }
}
unless(defined(&PDC2xx_PM)) {
    sub PDC2xx_PM () {	0x1a;}
}
unless(defined(&PDC2xx_SM)) {
    sub PDC2xx_SM () {	0x1b;}
}
unless(defined(&PDC2xx_SCR)) {
    sub PDC2xx_SCR () {	0x1c;}
}
unless(defined(&PDC2xx_SCR_SET_GEN)) {
    sub PDC2xx_SCR_SET_GEN {
	local($r,$x) = @_;
	eval q(((($r) & 0xffffff00) | (($x) & 0xff)));
    }
}
unless(defined(&PDC2xx_SCR_EMPTY)) {
    sub PDC2xx_SCR_EMPTY {
	local($channel) = @_;
	eval q((0x00000100 << (4* $channel)));
    }
}
unless(defined(&PDC2xx_SCR_FULL)) {
    sub PDC2xx_SCR_FULL {
	local($channel) = @_;
	eval q((0x00000200 << (4* $channel)));
    }
}
unless(defined(&PDC2xx_SCR_INT)) {
    sub PDC2xx_SCR_INT {
	local($channel) = @_;
	eval q((0x00000400 << (4* $channel)));
    }
}
unless(defined(&PDC2xx_SCR_ERR)) {
    sub PDC2xx_SCR_ERR {
	local($channel) = @_;
	eval q((0x00000800 << (4* $channel)));
    }
}
unless(defined(&PDC2xx_SCR_SET_I2C)) {
    sub PDC2xx_SCR_SET_I2C {
	local($r,$x) = @_;
	eval q(((($r) & 0xfff0ffff) | ((($x) & 0xf) << 16)));
    }
}
unless(defined(&PDC2xx_SCR_SET_POLL)) {
    sub PDC2xx_SCR_SET_POLL {
	local($r,$x) = @_;
	eval q(((($r) & 0xff0fffff) | ((($x) & 0xf) << 20)));
    }
}
unless(defined(&PDC2xx_SCR_DMA)) {
    sub PDC2xx_SCR_DMA () {	0x01000000;}
}
unless(defined(&PDC2xx_SCR_IORDY)) {
    sub PDC2xx_SCR_IORDY () {	0x02000000;}
}
unless(defined(&PDC2xx_SCR_G2FD)) {
    sub PDC2xx_SCR_G2FD () {	0x04000000;}
}
unless(defined(&PDC2xx_SCR_FLOAT)) {
    sub PDC2xx_SCR_FLOAT () {	0x08000000;}
}
unless(defined(&PDC2xx_SCR_RSET)) {
    sub PDC2xx_SCR_RSET () {	0x10000000;}
}
unless(defined(&PDC2xx_SCR_TST)) {
    sub PDC2xx_SCR_TST () {	0x20000000;}
}
unless(defined(&PDC262_SCR_GEN_LAT)) {
    sub PDC262_SCR_GEN_LAT () {	0x20;}
}
unless(defined(&PDC262_ATAPI)) {
    sub PDC262_ATAPI {
	local($chan) = @_;
	eval q((0x20 + (4* ($chan))));
    }
}
unless(defined(&PDC262_ATAPI_WC_MASK)) {
    sub PDC262_ATAPI_WC_MASK () {	0x00000fff;}
}
unless(defined(&PDC262_ATAPI_DMA_READ)) {
    sub PDC262_ATAPI_DMA_READ () {	0x00001000;}
}
unless(defined(&PDC262_ATAPI_DMA_WRITE)) {
    sub PDC262_ATAPI_DMA_WRITE () {	0x00002000;}
}
unless(defined(&PDC262_ATAPI_UDMA)) {
    sub PDC262_ATAPI_UDMA () {	0x00004000;}
}
unless(defined(&PDC268_REG0)) {
    sub PDC268_REG0 () {	0x1;}
}
unless(defined(&PDC268_REG1)) {
    sub PDC268_REG1 () {	0x3;}
}
1;
