require '_h2ph_pre.ph';

unless(defined(&_AIC7XXX_OPENBSD_H_)) {
    eval 'sub _AIC7XXX_OPENBSD_H_ () {1;}' unless defined(&_AIC7XXX_OPENBSD_H_);
    require 'pci.ph';
    require 'sys/param.ph';
    require 'sys/systm.ph';
    require 'sys/kernel.ph';
    require 'sys/device.ph';
    require 'machine/bus.ph';
    require 'machine/intr.ph';
    require 'dev/pci/pcivar.ph';
    require 'sys/malloc.ph';
    require 'sys/buf.ph';
    require 'sys/proc.ph';
    require 'sys/queue.ph';
    require 'scsi/scsi_all.ph';
    require 'scsi/scsi_message.ph';
    require 'scsi/scsi_debug.ph';
    require 'scsi/scsiconf.ph';
    require 'uvm/uvm_extern.ph';
    eval 'sub AHC_SHOWSENSE () {0x01;}' unless defined(&AHC_SHOWSENSE);
    eval 'sub AHC_SHOWMISC () {0x02;}' unless defined(&AHC_SHOWMISC);
    eval 'sub AHC_SHOWCMDS () {0x04;}' unless defined(&AHC_SHOWCMDS);
    if((defined(&NPCI) ? &NPCI : 0) > 0) {
	eval 'sub AHC_PCI_CONFIG () {1;}' unless defined(&AHC_PCI_CONFIG);
    }
    if(0) {
	eval 'sub AHC_DEBUG () { &AHC_SHOWSENSE |  &AHC_SHOWMISC |  &AHC_SHOWCMDS;}' unless defined(&AHC_DEBUG);
    }
    if(defined(&DEBUG)) {
	eval 'sub bootverbose () {1;}' unless defined(&bootverbose);
    } else {
	eval 'sub bootverbose () {0;}' unless defined(&bootverbose);
    }
    eval 'sub SCSI_IS_SCSIBUS_B {
        local($ahc, $sc_link) = @_;
	    eval q((($sc_link)-> &scsibus == ($ahc)-> ($platform_data->{sc_link_b}->{scsibus})));
    }' unless defined(&SCSI_IS_SCSIBUS_B);
    eval 'sub SCSI_SCSI_ID {
        local($ahc, $sc_link) = @_;
	    eval q(( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ?  ($ahc->{our_id_b}) :  ($ahc->{our_id})));
    }' unless defined(&SCSI_SCSI_ID);
    eval 'sub SCSI_CHANNEL {
        local($ahc, $sc_link) = @_;
	    eval q(( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ? ord(\'B\' : \'A\')));
    }' unless defined(&SCSI_CHANNEL);
    eval 'sub BUILD_SCSIID {
        local($ahc, $sc_link, $target_id, $our_id) = @_;
	    eval q((((($target_id) <<  &TID_SHIFT) &  &TID) | ($our_id) | ( &SCSI_IS_SCSIBUS_B($ahc, $sc_link) ?  &TWIN_CHNLB : 0)));
    }' unless defined(&BUILD_SCSIID);
    eval 'sub XS_SCSI_ID {
        local($xs) = @_;
	    eval q((($xs)-> ($sc_link->{target})));
    }' unless defined(&XS_SCSI_ID);
    eval 'sub XS_LUN {
        local($xs) = @_;
	    eval q((($xs)-> ($sc_link->{lun})));
    }' unless defined(&XS_LUN);
    eval 'sub XS_TCL {
        local($xs) = @_;
	    eval q( &BUILD_TCL( &XS_SCSI_ID($xs),  &XS_LUN($xs)));
    }' unless defined(&XS_TCL);
    unless(defined(&offsetof)) {
	eval 'sub offsetof {
	    local($type, $member) = @_;
    	    eval q((((0)->$member)));
	}' unless defined(&offsetof);
    }
    eval 'sub CAM_DIR_IN () { &SCSI_DATA_IN;}' unless defined(&CAM_DIR_IN);
    eval 'sub AC_TRANSFER_NEG () {0;}' unless defined(&AC_TRANSFER_NEG);
    eval 'sub AC_SENT_BDR () {0;}' unless defined(&AC_SENT_BDR);
    eval 'sub AC_BUS_RESET () {0;}' unless defined(&AC_BUS_RESET);
    eval 'sub CAM_BUS_WILDCARD () {(~0);}' unless defined(&CAM_BUS_WILDCARD);
    eval 'sub CAM_TARGET_WILDCARD () {(~0);}' unless defined(&CAM_TARGET_WILDCARD);
    eval 'sub CAM_LUN_WILDCARD () {(~0);}' unless defined(&CAM_LUN_WILDCARD);
    unless(defined(&MSG_SIMPLE_TASK)) {
	eval 'sub MSG_SIMPLE_TASK () { &MSG_SIMPLE_Q_TAG;}' unless defined(&MSG_SIMPLE_TASK);
    }
    unless(defined(&MSG_ORDERED_TASK)) {
	eval 'sub MSG_ORDERED_TASK () { &MSG_ORDERED_Q_TAG;}' unless defined(&MSG_ORDERED_TASK);
    }
    eval 'sub MSG_EXT_PPR_QAS_REQ () { &MSG_EXT_PPR_PROT_QAS;}' unless defined(&MSG_EXT_PPR_QAS_REQ);
    eval 'sub MSG_EXT_PPR_DT_REQ () { &MSG_EXT_PPR_PROT_DT;}' unless defined(&MSG_EXT_PPR_DT_REQ);
    eval 'sub MSG_EXT_PPR_IU_REQ () { &MSG_EXT_PPR_PROT_IUS;}' unless defined(&MSG_EXT_PPR_IU_REQ);
    eval 'sub BUS_SPACE_MAXSIZE_24BIT () {0xffffff;}' unless defined(&BUS_SPACE_MAXSIZE_24BIT);
    eval 'sub BUS_SPACE_MAXSIZE_32BIT () {0xffffffff;}' unless defined(&BUS_SPACE_MAXSIZE_32BIT);
    eval 'sub BUS_SPACE_MAXSIZE () {(64* 1024);}' unless defined(&BUS_SPACE_MAXSIZE);
    eval 'sub BUS_SPACE_MAXADDR_24BIT () {0xffffff;}' unless defined(&BUS_SPACE_MAXADDR_24BIT);
    eval 'sub BUS_SPACE_MAXADDR_32BIT () {0xffffffff;}' unless defined(&BUS_SPACE_MAXADDR_32BIT);
    eval 'sub BUS_SPACE_MAXADDR () {0xffffffff;}' unless defined(&BUS_SPACE_MAXADDR);
    eval("sub CAM_REQ_INPROG () { 0; }") unless defined(&CAM_REQ_INPROG);
    eval("sub CAM_REQ_CMP () { 1; }") unless defined(&CAM_REQ_CMP);
    eval("sub CAM_REQ_ABORTED () { 2; }") unless defined(&CAM_REQ_ABORTED);
    eval("sub CAM_UA_ABORT () { 3; }") unless defined(&CAM_UA_ABORT);
    eval("sub CAM_REQ_CMP_ERR () { 4; }") unless defined(&CAM_REQ_CMP_ERR);
    eval("sub CAM_BUSY () { 5; }") unless defined(&CAM_BUSY);
    eval("sub CAM_REQ_INVALID () { 6; }") unless defined(&CAM_REQ_INVALID);
    eval("sub CAM_PATH_INVALID () { 7; }") unless defined(&CAM_PATH_INVALID);
    eval("sub CAM_DEV_NOT_THERE () { 8; }") unless defined(&CAM_DEV_NOT_THERE);
    eval("sub CAM_UA_TERMIO () { 9; }") unless defined(&CAM_UA_TERMIO);
    eval("sub CAM_SEL_TIMEOUT () { 10; }") unless defined(&CAM_SEL_TIMEOUT);
    eval("sub CAM_CMD_TIMEOUT () { 11; }") unless defined(&CAM_CMD_TIMEOUT);
    eval("sub CAM_SCSI_STATUS_ERROR () { 12; }") unless defined(&CAM_SCSI_STATUS_ERROR);
    eval("sub CAM_MSG_REJECT_REC () { 13; }") unless defined(&CAM_MSG_REJECT_REC);
    eval("sub CAM_SCSI_BUS_RESET () { 14; }") unless defined(&CAM_SCSI_BUS_RESET);
    eval("sub CAM_UNCOR_PARITY () { 15; }") unless defined(&CAM_UNCOR_PARITY);
    eval("sub CAM_AUTOSENSE_FAIL () { 0x10; }") unless defined(&CAM_AUTOSENSE_FAIL);
    eval("sub CAM_NO_HBA () { 1; }") unless defined(&CAM_NO_HBA);
    eval("sub CAM_DATA_RUN_ERR () { 2; }") unless defined(&CAM_DATA_RUN_ERR);
    eval("sub CAM_UNEXP_BUSFREE () { 3; }") unless defined(&CAM_UNEXP_BUSFREE);
    eval("sub CAM_SEQUENCE_FAIL () { 4; }") unless defined(&CAM_SEQUENCE_FAIL);
    eval("sub CAM_CCB_LEN_ERR () { 5; }") unless defined(&CAM_CCB_LEN_ERR);
    eval("sub CAM_PROVIDE_FAIL () { 6; }") unless defined(&CAM_PROVIDE_FAIL);
    eval("sub CAM_BDR_SENT () { 7; }") unless defined(&CAM_BDR_SENT);
    eval("sub CAM_REQ_TERMIO () { 8; }") unless defined(&CAM_REQ_TERMIO);
    eval("sub CAM_UNREC_HBA_ERROR () { 9; }") unless defined(&CAM_UNREC_HBA_ERROR);
    eval("sub CAM_REQ_TOO_BIG () { 10; }") unless defined(&CAM_REQ_TOO_BIG);
    eval("sub CAM_REQUEUE_REQ () { 11; }") unless defined(&CAM_REQUEUE_REQ);
    eval("sub CAM_IDE () { 0x33; }") unless defined(&CAM_IDE);
    eval("sub CAM_RESRC_UNAVAIL () { 1; }") unless defined(&CAM_RESRC_UNAVAIL);
    eval("sub CAM_UNACKED_EVENT () { 2; }") unless defined(&CAM_UNACKED_EVENT);
    eval("sub CAM_MESSAGE_RECV () { 3; }") unless defined(&CAM_MESSAGE_RECV);
    eval("sub CAM_INVALID_CDB () { 4; }") unless defined(&CAM_INVALID_CDB);
    eval("sub CAM_LUN_INVALID () { 5; }") unless defined(&CAM_LUN_INVALID);
    eval("sub CAM_TID_INVALID () { 6; }") unless defined(&CAM_TID_INVALID);
    eval("sub CAM_FUNC_NOTAVAIL () { 7; }") unless defined(&CAM_FUNC_NOTAVAIL);
    eval("sub CAM_NO_NEXUS () { 8; }") unless defined(&CAM_NO_NEXUS);
    eval("sub CAM_IID_INVALID () { 9; }") unless defined(&CAM_IID_INVALID);
    eval("sub CAM_CDB_RECVD () { 10; }") unless defined(&CAM_CDB_RECVD);
    eval("sub CAM_LUN_ALRDY_ENA () { 11; }") unless defined(&CAM_LUN_ALRDY_ENA);
    eval("sub CAM_SCSI_BUSY () { 12; }") unless defined(&CAM_SCSI_BUSY);
    eval("sub CAM_DEV_QFRZN () { 0x40; }") unless defined(&CAM_DEV_QFRZN);
    eval("sub CAM_AUTOSNS_VALID () { 0x80; }") unless defined(&CAM_AUTOSNS_VALID);
    eval("sub CAM_RELEASE_SIMQ () { 0x100; }") unless defined(&CAM_RELEASE_SIMQ);
    eval("sub CAM_SIM_QUEUED () { 0x200; }") unless defined(&CAM_SIM_QUEUED);
    eval("sub CAM_STATUS_MASK () { 0x3F; }") unless defined(&CAM_STATUS_MASK);
    eval("sub CAM_SENT_SENSE () { 0x40000000; }") unless defined(&CAM_SENT_SENSE);
    eval 'sub SCSI_STATUS_CHECK_COND () { &SCSI_CHECK;}' unless defined(&SCSI_STATUS_CHECK_COND);
    eval 'sub SCSI_STATUS_CMD_TERMINATED () { &SCSI_TERMINATED;}' unless defined(&SCSI_STATUS_CMD_TERMINATED);
    eval 'sub SCSI_STATUS_OK () { &SCSI_OK;}' unless defined(&SCSI_STATUS_OK);
    eval 'sub SCSI_REV_2 () { &SC_SCSI_2;}' unless defined(&SCSI_REV_2);
    eval 'sub ahc_dmamap_sync {
        local($ahc, $dma_tag, $dmamap, $offset, $len, $op) = @_;
	    eval q( &bus_dmamap_sync($dma_tag, $dmamap, $offset, $len, $op));
    }' unless defined(&ahc_dmamap_sync);
    eval 'sub AHC_NSEG () {( &roundup( &btoc( &MAXPHYS) + 1, 16));}' unless defined(&AHC_NSEG);
    if(defined(&AHC_TARGET_MODE)) {
	undef(&AHC_TARGET_MODE) if defined(&AHC_TARGET_MODE);
    }
    require 'dev/ic/aic7xxx.ph';
    eval 'sub shared_data_seg () { ($platform_data->{pshared_data_seg});}' unless defined(&shared_data_seg);
    eval 'sub shared_data_nseg () { ($platform_data->{pshared_data_nseg});}' unless defined(&shared_data_nseg);
    eval 'sub shared_data_size () { ($platform_data->{pshared_data_size});}' unless defined(&shared_data_size);
    eval("sub SCB_FREEZE_QUEUE () { 0x0001; }") unless defined(&SCB_FREEZE_QUEUE);
    eval("sub SCB_REQUEUE () { 0x0002; }") unless defined(&SCB_REQUEUE);
    unless(defined(&ISABUS_DMA_32BIT)) {
	eval 'sub ISABUS_DMA_32BIT () { &BUS_DMA_BUS1;}' unless defined(&ISABUS_DMA_32BIT);
    }
    eval 'sub ahc_htobe16 {
        local($x) = @_;
	    eval q( &htobe16($x));
    }' unless defined(&ahc_htobe16);
    eval 'sub ahc_htobe32 {
        local($x) = @_;
	    eval q( &htobe32($x));
    }' unless defined(&ahc_htobe32);
    eval 'sub ahc_htobe64 {
        local($x) = @_;
	    eval q( &htobe64($x));
    }' unless defined(&ahc_htobe64);
    eval 'sub ahc_htole16 {
        local($x) = @_;
	    eval q( &htole16($x));
    }' unless defined(&ahc_htole16);
    eval 'sub ahc_htole32 {
        local($x) = @_;
	    eval q( &htole32($x));
    }' unless defined(&ahc_htole32);
    eval 'sub ahc_htole64 {
        local($x) = @_;
	    eval q( &htole64($x));
    }' unless defined(&ahc_htole64);
    eval 'sub ahc_be16toh {
        local($x) = @_;
	    eval q( &betoh16($x));
    }' unless defined(&ahc_be16toh);
    eval 'sub ahc_be32toh {
        local($x) = @_;
	    eval q( &betoh32($x));
    }' unless defined(&ahc_be32toh);
    eval 'sub ahc_be64toh {
        local($x) = @_;
	    eval q( &betoh64($x));
    }' unless defined(&ahc_be64toh);
    eval 'sub ahc_le16toh {
        local($x) = @_;
	    eval q( &letoh16($x));
    }' unless defined(&ahc_le16toh);
    eval 'sub ahc_le32toh {
        local($x) = @_;
	    eval q( &letoh32($x));
    }' unless defined(&ahc_le32toh);
    eval 'sub ahc_le64toh {
        local($x) = @_;
	    eval q( &letoh64($x));
    }' unless defined(&ahc_le64toh);
    eval 'sub ahc_inb {
        local($ahc, $port) = @_;
	    eval q( &bus_space_read_1(($ahc)-> &tag, ($ahc)-> &bsh, $port));
    }' unless defined(&ahc_inb);
    eval 'sub ahc_outb {
        local($ahc, $port, $value) = @_;
	    eval q( &bus_space_write_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $value));
    }' unless defined(&ahc_outb);
    eval 'sub ahc_outsb {
        local($ahc, $port, $valp, $count) = @_;
	    eval q( &bus_space_write_multi_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $valp, $count));
    }' unless defined(&ahc_outsb);
    eval 'sub ahc_insb {
        local($ahc, $port, $valp, $count) = @_;
	    eval q( &bus_space_read_multi_1(($ahc)-> &tag, ($ahc)-> &bsh, $port, $valp, $count));
    }' unless defined(&ahc_insb);
    if(defined(&AHC_INLINES)) {
    } else {
	eval 'sub ahc_lockinit {
	    local($ahc) = @_;
    	    eval q(;);
	}' unless defined(&ahc_lockinit);
	eval 'sub ahc_lock {
	    local($ahc, $flags) = @_;
    	    eval q(*($flags) =  &splbio());
	}' unless defined(&ahc_lock);
	eval 'sub ahc_unlock {
	    local($ahc, $flags) = @_;
    	    eval q( &splx(*($flags)));
	}' unless defined(&ahc_unlock);
	eval 'sub ahc_done_lockinit {
	    local($ahc) = @_;
    	    eval q(;);
	}' unless defined(&ahc_done_lockinit);
	eval 'sub ahc_done_lock {
	    local($ahc, $flags) = @_;
    	    eval q(;);
	}' unless defined(&ahc_done_lock);
	eval 'sub ahc_done_unlock {
	    local($ahc, $flags) = @_;
    	    eval q(;);
	}' unless defined(&ahc_done_unlock);
    }
    eval 'sub ahc_delay () { &delay;}' unless defined(&ahc_delay);
    if(defined(&AHC_INLINES)) {
    } else {
    }
    if(defined(&AHC_INLINES)) {
    }
    if(defined(&AHC_INLINE)) {
    }
    if(defined(&AHC_INLINE)) {
    }
    if(defined(&AHC_PCI_CONFIG)) {
    }
}
1;
