require '_h2ph_pre.ph';

unless(defined(&_HP300_INTR_H_)) {
    eval 'sub _HP300_INTR_H_ () {1;}' unless defined(&_HP300_INTR_H_);
    require 'machine/psl.ph';
    if(defined(&_HP300_INTR_H_PRIVATE)) {
	require 'sys/queue.ph';
	eval 'sub ISRLOC () {0x18;}' unless defined(&ISRLOC);
	eval 'sub NISR () {8;}' unless defined(&NISR);
    }
    eval 'sub IPL_NONE () {0;}' unless defined(&IPL_NONE);
    eval 'sub IPL_BIO () {1;}' unless defined(&IPL_BIO);
    eval 'sub IPL_NET () {2;}' unless defined(&IPL_NET);
    eval 'sub IPL_TTY () {3;}' unless defined(&IPL_TTY);
    eval 'sub IPL_TTYNOBUF () {4;}' unless defined(&IPL_TTYNOBUF);
    eval 'sub IPL_CLOCK () {5;}' unless defined(&IPL_CLOCK);
    eval 'sub IPL_HIGH () {6;}' unless defined(&IPL_HIGH);
    eval 'sub PSLTOIPL {
        local($x) = @_;
	    eval q(((($x) >> 8) & 0xf));
    }' unless defined(&PSLTOIPL);
    eval 'sub IPLTOPSL {
        local($x) = @_;
	    eval q((((($x) & 0xf) << 8) |  &PSL_S));
    }' unless defined(&IPLTOPSL);
    if(defined(&_KERNEL)) {
	eval 'sub splassert {
	    local($wantipl) = @_;
    	    eval q();
	}' unless defined(&splassert);
	eval 'sub _spl {
	    local($s) = @_;
    	    eval q(({  &register \'int\'  &_spl_r;  &__asm  &__volatile (\\"clrl %0; movew sr,%0; movew %1,sr\\" : \\"=&d\\" ( &_spl_r) : \\"di\\" ($s));  &_spl_r; }));
	}' unless defined(&_spl);
	eval 'sub _splraise {
	    local($s) = @_;
    	    eval q(({ \'int\'  &_spl_r;  &__asm  &__volatile (\\"								clrl	d0					;			movw	sr,d0					;			movl	d0,%0					;			andw	#0x700,d0				;			movw	%1,d1					;			andw	#0x700,d1				;			cmpw	d0,d1					;			jle	1f					;			movw	%1,sr					;		    1:\\" : \\"=&d\\" ( &_spl_r) : \\"di\\" ($s) : \\"d0\\", \\"d1\\");  &_spl_r; }));
	}' unless defined(&_splraise);
	eval 'sub spl1 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL1));
	}' unless defined(&spl1);
	eval 'sub spl2 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL2));
	}' unless defined(&spl2);
	eval 'sub spl3 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL3));
	}' unless defined(&spl3);
	eval 'sub spl4 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL4));
	}' unless defined(&spl4);
	eval 'sub spl5 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL5));
	}' unless defined(&spl5);
	eval 'sub spl6 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL6));
	}' unless defined(&spl6);
	eval 'sub spl7 () {
	    eval q( &_spl( &PSL_S| &PSL_IPL7));
	}' unless defined(&spl7);
	eval 'sub splhil () {
	    eval q( &_splraise( &PSL_S| &PSL_IPL1));
	}' unless defined(&splhil);
	eval 'sub splkbd () {
	    eval q( &splhil());
	}' unless defined(&splkbd);
	eval 'sub splsoft () {
	    eval q( &spl1());
	}' unless defined(&splsoft);
	eval 'sub spllowersoftclock () {
	    eval q( &splsoft());
	}' unless defined(&spllowersoftclock);
	eval 'sub splsoftclock () {
	    eval q( &splsoft());
	}' unless defined(&splsoftclock);
	eval 'sub splsoftnet () {
	    eval q( &splsoft());
	}' unless defined(&splsoftnet);
	eval 'sub splbio () {
	    eval q( &_splraise( &hp300_bioipl));
	}' unless defined(&splbio);
	eval 'sub splnet () {
	    eval q( &_splraise( &hp300_netipl));
	}' unless defined(&splnet);
	eval 'sub spltty () {
	    eval q( &_splraise( &hp300_ttyipl));
	}' unless defined(&spltty);
	eval 'sub splimp () {
	    eval q( &_splraise( &hp300_impipl));
	}' unless defined(&splimp);
	eval 'sub splclock () {
	    eval q( &spl6());
	}' unless defined(&splclock);
	eval 'sub splstatclock () {
	    eval q( &spl6());
	}' unless defined(&splstatclock);
	eval 'sub splvm () {
	    eval q( &splimp());
	}' unless defined(&splvm);
	eval 'sub splhigh () {
	    eval q( &spl7());
	}' unless defined(&splhigh);
	eval 'sub splx {
	    local($s) = @_;
    	    eval q((($s) &  &PSL_IPL ?  &_spl(($s)) :  &spl0()));
	}' unless defined(&splx);
	eval 'sub SIR_NET () {0x01;}' unless defined(&SIR_NET);
	eval 'sub SIR_CLOCK () {0x02;}' unless defined(&SIR_CLOCK);
	eval 'sub siron {
	    local($mask) = @_;
    	    eval q( &__asm  &__volatile ( \\"orb %0,_ssir\\" : : \\"i\\" (($mask))));
	}' unless defined(&siron);
	eval 'sub siroff {
	    local($mask) = @_;
    	    eval q( &__asm  &__volatile ( \\"andb %0,_ssir\\" : : \\"ir\\" (~($mask))););
	}' unless defined(&siroff);
	eval 'sub setsoftnet () {
	    eval q( &siron( &SIR_NET));
	}' unless defined(&setsoftnet);
	eval 'sub setsoftclock () {
	    eval q( &siron( &SIR_CLOCK));
	}' unless defined(&setsoftclock);
    }
}
1;
