require '_h2ph_pre.ph';

unless(defined(&TCDS_SCSI0_OFFSET)) {
    sub TCDS_SCSI0_OFFSET () {	0x080000;}
}
unless(defined(&TCDS_SCSI1_OFFSET)) {
    sub TCDS_SCSI1_OFFSET () {	0x080100;}
}
unless(defined(&TCDS_EEPROM)) {
    sub TCDS_EEPROM () {	0x000000;}
}
unless(defined(&TCDS_EEPROM_IDS)) {
    sub TCDS_EEPROM_IDS () {	0x000008;}
}
unless(defined(&TCDS_CIR)) {
    sub TCDS_CIR () {	0x040000;}
}
unless(defined(&TCDS_CIR_GPO_0)) {
    sub TCDS_CIR_GPO_0 () {	0x00000001;}
}
unless(defined(&TCDS_CIR_GPO_1)) {
    sub TCDS_CIR_GPO_1 () {	0x00000002;}
}
unless(defined(&TCDS_CIR_GPO_2)) {
    sub TCDS_CIR_GPO_2 () {	0x00000004;}
}
unless(defined(&TCDS_CIR_STD)) {
    sub TCDS_CIR_STD () {	0x00000008;}
}
unless(defined(&TCDS_CIR_GPI_0)) {
    sub TCDS_CIR_GPI_0 () {	0x00000010;}
}
unless(defined(&TCDS_CIR_GPI_1)) {
    sub TCDS_CIR_GPI_1 () {	0x00000020;}
}
unless(defined(&TCDS_CIR_GPI_2)) {
    sub TCDS_CIR_GPI_2 () {	0x00000040;}
}
unless(defined(&TCDS_CIR_GPI_3)) {
    sub TCDS_CIR_GPI_3 () {	0x00000080;}
}
unless(defined(&TCDS_CIR_SCSI0_DMAENA)) {
    sub TCDS_CIR_SCSI0_DMAENA () {	0x00000100;}
}
unless(defined(&TCDS_CIR_SCSI1_DMAENA)) {
    sub TCDS_CIR_SCSI1_DMAENA () {	0x00000200;}
}
unless(defined(&TCDS_CIR_SCSI0_RESET)) {
    sub TCDS_CIR_SCSI0_RESET () {	0x00000400;}
}
unless(defined(&TCDS_CIR_SCSI1_RESET)) {
    sub TCDS_CIR_SCSI1_RESET () {	0x00000800;}
}
unless(defined(&TCDS_CIR_SCSI0_DMA_TEST)) {
    sub TCDS_CIR_SCSI0_DMA_TEST () {	0x00001000;}
}
unless(defined(&TCDS_CIR_SCSI1_DMA_TEST)) {
    sub TCDS_CIR_SCSI1_DMA_TEST () {	0x00002000;}
}
unless(defined(&TCDS_CIR_DB_PAR)) {
    sub TCDS_CIR_DB_PAR () {	0x00004000;}
}
unless(defined(&TCDS_CIR_TC_PAR)) {
    sub TCDS_CIR_TC_PAR () {	0x00008000;}
}
unless(defined(&TCDS_CIR_ALLCONTROL)) {
    sub TCDS_CIR_ALLCONTROL () {	0x0000ffff;}
}
unless(defined(&TCDS_CIR_SCSI0_DREQ)) {
    sub TCDS_CIR_SCSI0_DREQ () {	0x00010000;}
}
unless(defined(&TCDS_CIR_SCSI1_DREQ)) {
    sub TCDS_CIR_SCSI1_DREQ () {	0x00020000;}
}
unless(defined(&TCDS_CIR_SCSI0_INT)) {
    sub TCDS_CIR_SCSI0_INT () {	0x00040000;}
}
unless(defined(&TCDS_CIR_SCSI1_INT)) {
    sub TCDS_CIR_SCSI1_INT () {	0x00080000;}
}
unless(defined(&TCDS_CIR_SCSI0_PREFETCH)) {
    sub TCDS_CIR_SCSI0_PREFETCH () {	0x00100000;}
}
unless(defined(&TCDS_CIR_SCSI1_PREFETCH)) {
    sub TCDS_CIR_SCSI1_PREFETCH () {	0x00200000;}
}
unless(defined(&TCDS_CIR_SCSI0_DMA)) {
    sub TCDS_CIR_SCSI0_DMA () {	0x00400000;}
}
unless(defined(&TCDS_CIR_SCSI1_DMA)) {
    sub TCDS_CIR_SCSI1_DMA () {	0x00800000;}
}
unless(defined(&TCDS_CIR_SCSI0_DB)) {
    sub TCDS_CIR_SCSI0_DB () {	0x01000000;}
}
unless(defined(&TCDS_CIR_SCSI1_DB)) {
    sub TCDS_CIR_SCSI1_DB () {	0x02000000;}
}
unless(defined(&TCDS_CIR_SCSI0_DMAB_PAR)) {
    sub TCDS_CIR_SCSI0_DMAB_PAR () {	0x04000000;}
}
unless(defined(&TCDS_CIR_SCSI1_DMAB_PAR)) {
    sub TCDS_CIR_SCSI1_DMAB_PAR () {	0x08000000;}
}
unless(defined(&TCDS_CIR_SCSI0_DMAR_PAR)) {
    sub TCDS_CIR_SCSI0_DMAR_PAR () {	0x10000000;}
}
unless(defined(&TCDS_CIR_SCSI1_DMAR_PAR)) {
    sub TCDS_CIR_SCSI1_DMAR_PAR () {	0x20000000;}
}
unless(defined(&TCDS_CIR_TCIOW_PAR)) {
    sub TCDS_CIR_TCIOW_PAR () {	0x40000000;}
}
unless(defined(&TCDS_CIR_TCIOA_PAR)) {
    sub TCDS_CIR_TCIOA_PAR () {	0x80000000;}
}
unless(defined(&TCDS_CIR_ALLINTR)) {
    sub TCDS_CIR_ALLINTR () {	0xffff0000;}
}
unless(defined(&TCDS_CIR_CLR)) {
    sub TCDS_CIR_CLR {
	local($c, $b) = @_;
	eval q($c = (($c |  &TCDS_CIR_ALLINTR) & ~$b));
    }
}
unless(defined(&TCDS_CIR_SET)) {
    sub TCDS_CIR_SET {
	local($c, $b) = @_;
	eval q($c = (($c |  &TCDS_CIR_ALLINTR) | $b));
    }
}
unless(defined(&TCDS_IMER_SCSI0_MASK)) {
    sub TCDS_IMER_SCSI0_MASK () {	0x04;}
}
unless(defined(&TCDS_IMER_SCSI1_MASK)) {
    sub TCDS_IMER_SCSI1_MASK () {	0x08;}
}
unless(defined(&TCDS_IMER_SCSI0_ENB)) {
    sub TCDS_IMER_SCSI0_ENB () {	( &TCDS_IMER_SCSI0_MASK << 16);}
}
unless(defined(&TCDS_IMER_SCSI1_ENB)) {
    sub TCDS_IMER_SCSI1_ENB () {	( &TCDS_IMER_SCSI1_MASK << 16);}
}
unless(defined(&TCDS_IMER)) {
    sub TCDS_IMER () {	0x040004;}
}
unless(defined(&TCDS_SCSI0_DMA_ADDR)) {
    sub TCDS_SCSI0_DMA_ADDR () {	0x041000;}
}
unless(defined(&TCDS_SCSI0_DMA_INTR)) {
    sub TCDS_SCSI0_DMA_INTR () {	0x041004;}
}
unless(defined(&TCDS_SCSI0_DMA_DUD0)) {
    sub TCDS_SCSI0_DMA_DUD0 () {	0x041008;}
}
unless(defined(&TCDS_SCSI0_DMA_DUD1)) {
    sub TCDS_SCSI0_DMA_DUD1 () {	0x04100c;}
}
unless(defined(&TCDS_SCSI1_DMA_ADDR)) {
    sub TCDS_SCSI1_DMA_ADDR () {	0x041100;}
}
unless(defined(&TCDS_SCSI1_DMA_INTR)) {
    sub TCDS_SCSI1_DMA_INTR () {	0x041104;}
}
unless(defined(&TCDS_SCSI1_DMA_DUD0)) {
    sub TCDS_SCSI1_DMA_DUD0 () {	0x041108;}
}
unless(defined(&TCDS_SCSI1_DMA_DUD1)) {
    sub TCDS_SCSI1_DMA_DUD1 () {	0x04110c;}
}
unless(defined(&TCDS_DIC_ADDRMASK)) {
    sub TCDS_DIC_ADDRMASK () {	0x03;}
}
unless(defined(&TCDS_DIC_READ_PREFETCH)) {
    sub TCDS_DIC_READ_PREFETCH () {	0x40;}
}
unless(defined(&TCDS_DIC_WRITE)) {
    sub TCDS_DIC_WRITE () {	0x80;}
}
unless(defined(&TCDS_DUD0_VALID00)) {
    sub TCDS_DUD0_VALID00 () {	0x00000001;}
}
unless(defined(&TCDS_DUD0_VALID01)) {
    sub TCDS_DUD0_VALID01 () {	0x00000002;}
}
unless(defined(&TCDS_DUD0_VALID10)) {
    sub TCDS_DUD0_VALID10 () {	0x00000004;}
}
unless(defined(&TCDS_DUD0_VALID11)) {
    sub TCDS_DUD0_VALID11 () {	0x00000008;}
}
unless(defined(&TCDS_DUD0_VALIDBITS)) {
    sub TCDS_DUD0_VALIDBITS () {	0x0000000f;}
}
unless(defined(&TCDS_DUD1_VALID00)) {
    sub TCDS_DUD1_VALID00 () {	0x01000000;}
}
unless(defined(&TCDS_DUD1_VALID01)) {
    sub TCDS_DUD1_VALID01 () {	0x02000000;}
}
unless(defined(&TCDS_DUD1_VALID10)) {
    sub TCDS_DUD1_VALID10 () {	0x04000000;}
}
unless(defined(&TCDS_DUD1_VALID11)) {
    sub TCDS_DUD1_VALID11 () {	0x08000000;}
}
unless(defined(&TCDS_DUD1_VALIDBITS)) {
    sub TCDS_DUD1_VALIDBITS () {	0x0f000000;}
}
unless(defined(&TCDS_DUD_BYTE00)) {
    sub TCDS_DUD_BYTE00 () {	0x000000ff;}
}
unless(defined(&TCDS_DUD_BYTE01)) {
    sub TCDS_DUD_BYTE01 () {	0x0000ff00;}
}
unless(defined(&TCDS_DUD_BYTE10)) {
    sub TCDS_DUD_BYTE10 () {	0x00ff0000;}
}
unless(defined(&TCDS_DUD_BYTE11)) {
    sub TCDS_DUD_BYTE11 () {	0xff000000;}
}
if(0) {
    eval 'sub KN15AA_SYS_SCSI () {0x1d0000000;}' unless defined(&KN15AA_SYS_SCSI);
    eval 'sub KN15AA_REG_SCSI_CIR () {( &KN15AA_SYS_SCSI + 0x80000);}' unless defined(&KN15AA_REG_SCSI_CIR);
    eval 'sub SCSI_CIR_AIOPAR () {0x80000000;}' unless defined(&SCSI_CIR_AIOPAR);
    eval 'sub SCSI_CIR_WDIOPAR () {0x40000000;}' unless defined(&SCSI_CIR_WDIOPAR);
    eval 'sub SCSI_CIR_DMARPAR1 () {0x20000000;}' unless defined(&SCSI_CIR_DMARPAR1);
    eval 'sub SCSI_CIR_DMARPAR0 () {0x10000000;}' unless defined(&SCSI_CIR_DMARPAR0);
    eval 'sub SCSI_CIR_DMABUFPAR1 () {0x08000000;}' unless defined(&SCSI_CIR_DMABUFPAR1);
    eval 'sub SCSI_CIR_DMABUFPAR0 () {0x04000000;}' unless defined(&SCSI_CIR_DMABUFPAR0);
    eval 'sub SCSI_CIR_DBPAR1 () {0x02000000;}' unless defined(&SCSI_CIR_DBPAR1);
    eval 'sub SCSI_CIR_DBPAR0 () {0x01000000;}' unless defined(&SCSI_CIR_DBPAR0);
    eval 'sub SCSI_CIR_DMAERR1 () {0x00800000;}' unless defined(&SCSI_CIR_DMAERR1);
    eval 'sub SCSI_CIR_DMAERR0 () {0x00400000;}' unless defined(&SCSI_CIR_DMAERR0);
    if((defined(&fmm50) ? &fmm50 : 0)) {
	eval 'sub SCSI_CIR_xxx0 () {0x00200000;}' unless defined(&SCSI_CIR_xxx0);
	eval 'sub SCSI_CIR_xxx1 () {0x00100000;}' unless defined(&SCSI_CIR_xxx1);
    } else {
	eval 'sub SCSI_CIR_PREF1 () {0x00200000;}' unless defined(&SCSI_CIR_PREF1);
	eval 'sub SCSI_CIR_PREF0 () {0x00100000;}' unless defined(&SCSI_CIR_PREF0);
    }
    eval 'sub SCSI_CIR_53C94_INT1 () {0x00080000;}' unless defined(&SCSI_CIR_53C94_INT1);
    eval 'sub SCSI_CIR_53C94_INT0 () {0x00040000;}' unless defined(&SCSI_CIR_53C94_INT0);
    eval 'sub SCSI_CIR_53C94_DREQ1 () {0x00020000;}' unless defined(&SCSI_CIR_53C94_DREQ1);
    eval 'sub SCSI_CIR_53C94_DREQ0 () {0x00010000;}' unless defined(&SCSI_CIR_53C94_DREQ0);
    eval 'sub SCSI_CIR_TC_PAR_TEST () {0x00008000;}' unless defined(&SCSI_CIR_TC_PAR_TEST);
    eval 'sub SCSI_CIR_DB_PAR_TEST () {0x00004000;}' unless defined(&SCSI_CIR_DB_PAR_TEST);
    eval 'sub SCSI_CIR_DBUF_PAR_TEST1 () {0x00002000;}' unless defined(&SCSI_CIR_DBUF_PAR_TEST1);
    eval 'sub SCSI_CIR_DBUF_PAR_TEST0 () {0x00001000;}' unless defined(&SCSI_CIR_DBUF_PAR_TEST0);
    eval 'sub SCSI_CIR_RESET1 () {0x00000800;}' unless defined(&SCSI_CIR_RESET1);
    eval 'sub SCSI_CIR_RESET0 () {0x00000400;}' unless defined(&SCSI_CIR_RESET0);
    eval 'sub SCSI_CIR_DMAENA1 () {0x00000200;}' unless defined(&SCSI_CIR_DMAENA1);
    eval 'sub SCSI_CIR_DMAENA0 () {0x00000100;}' unless defined(&SCSI_CIR_DMAENA0);
    eval 'sub SCSI_CIR_GPI3 () {0x00000080;}' unless defined(&SCSI_CIR_GPI3);
    eval 'sub SCSI_CIR_GPI2 () {0x00000040;}' unless defined(&SCSI_CIR_GPI2);
    eval 'sub SCSI_CIR_GPI1 () {0x00000020;}' unless defined(&SCSI_CIR_GPI1);
    eval 'sub SCSI_CIR_GPI0 () {0x00000010;}' unless defined(&SCSI_CIR_GPI0);
    eval 'sub SCSI_CIR_TXDIS () {0x00000008;}' unless defined(&SCSI_CIR_TXDIS);
    eval 'sub SCSI_CIR_GPO2 () {0x00000004;}' unless defined(&SCSI_CIR_GPO2);
    eval 'sub SCSI_CIR_GPO1 () {0x00000002;}' unless defined(&SCSI_CIR_GPO1);
    eval 'sub SCSI_CIR_GPO0 () {0x00000001;}' unless defined(&SCSI_CIR_GPO0);
    eval 'sub SCSI_CIR_ERROR () {( &SCSI_CIR_AIOPAR |  &SCSI_CIR_WDIOPAR |  &SCSI_CIR_DMARPAR1 |  &SCSI_CIR_DMARPAR0 |  &SCSI_CIR_DMABUFPAR1 |  &SCSI_CIR_DMABUFPAR0 |  &SCSI_CIR_DBPAR1 | &SCSI_CIR_DBPAR0 |  &SCSI_CIR_DMAERR1 |  &SCSI_CIR_DMAERR0 );}' unless defined(&SCSI_CIR_ERROR);
    eval 'sub KN15AA_REG_SCSI_DMAPTR0 () {( &KN15AA_SYS_SCSI + 0x82000);}' unless defined(&KN15AA_REG_SCSI_DMAPTR0);
    eval 'sub KN15AA_REG_SCSI_DMAPTR1 () {( &KN15AA_SYS_SCSI + 0x82200);}' unless defined(&KN15AA_REG_SCSI_DMAPTR1);
    eval 'sub KN15AA_REG_SCSI_DIC0 () {( &KN15AA_SYS_SCSI + 0x82008);}' unless defined(&KN15AA_REG_SCSI_DIC0);
    eval 'sub KN15AA_REG_SCSI_DIC1 () {( &KN15AA_SYS_SCSI + 0x82208);}' unless defined(&KN15AA_REG_SCSI_DIC1);
    eval 'sub SCSI_DIC_DMADIR () {0x00000080;}' unless defined(&SCSI_DIC_DMADIR);
    eval 'sub SCSI_DIC_PREFENA () {0x00000040;}' unless defined(&SCSI_DIC_PREFENA);
    eval 'sub SCSI_DIC_DMAADDR1 () {0x00000002;}' unless defined(&SCSI_DIC_DMAADDR1);
    eval 'sub SCSI_DIC_DMAADDR0 () {0x00000001;}' unless defined(&SCSI_DIC_DMAADDR0);
    eval 'sub SCSI_DIC_ADDR_MASK () {( &SCSI_DIC_DMAADDR0 | &SCSI_DIC_DMAADDR1);}' unless defined(&SCSI_DIC_ADDR_MASK);
    eval 'sub KN15AA_REG_SCSI_94REG0 () {( &KN15AA_SYS_SCSI + 0x100000);}' unless defined(&KN15AA_REG_SCSI_94REG0);
    eval 'sub KN15AA_REG_SCSI_94REG1 () {( &KN15AA_SYS_SCSI + 0x100200);}' unless defined(&KN15AA_REG_SCSI_94REG1);
    eval 'sub KN15AA_REG_SCSI_IMER () {( &KN15AA_SYS_SCSI + 0x80008);}' unless defined(&KN15AA_REG_SCSI_IMER);
    eval 'sub KN15AA_REG_SCSI_DUDB0 () {( &KN15AA_SYS_SCSI + 0x82010);}' unless defined(&KN15AA_REG_SCSI_DUDB0);
    eval 'sub KN15AA_REG_SCSI_DUDB1 () {( &KN15AA_SYS_SCSI + 0x82210);}' unless defined(&KN15AA_REG_SCSI_DUDB1);
    eval 'sub SCSI_DUDB_MASK01 () {0x00000001;}' unless defined(&SCSI_DUDB_MASK01);
    eval 'sub SCSI_DUDB_MASK10 () {0x00000002;}' unless defined(&SCSI_DUDB_MASK10);
    eval 'sub SCSI_DUDB_MASK11 () {0x00000004;}' unless defined(&SCSI_DUDB_MASK11);
    eval 'sub KN15AA_REG_SCSI_DUDE0 () {( &KN15AA_SYS_SCSI + 0x82018);}' unless defined(&KN15AA_REG_SCSI_DUDE0);
    eval 'sub KN15AA_REG_SCSI_DUDE1 () {( &KN15AA_SYS_SCSI + 0x82218);}' unless defined(&KN15AA_REG_SCSI_DUDE1);
    eval 'sub SCSI_DUDE_MASK00 () {0x1000000;}' unless defined(&SCSI_DUDE_MASK00);
    eval 'sub SCSI_DUDE_MASK01 () {0x2000000;}' unless defined(&SCSI_DUDE_MASK01);
    eval 'sub SCSI_DUDE_MASK10 () {0x4000000;}' unless defined(&SCSI_DUDE_MASK10);
    eval 'sub SCSI_CIR () { &ALPHA_PHYS_TO_K0SEG( &KN15AA_REG_SCSI_CIR);}' unless defined(&SCSI_CIR);
    eval 'sub SCSI_IMER () { &ALPHA_PHYS_TO_K0SEG( &KN15AA_REG_SCSI_IMER);}' unless defined(&SCSI_IMER);
}
1;
