require '_h2ph_pre.ph';

unless(defined(&PMAP_H)) {
    eval 'sub PMAP_H () {1;}' unless defined(&PMAP_H);
    require 'machine/types.ph';
    require 'machine/pte.ph';
    require 'machine/mtpr.ph';
    require 'machine/pcb.ph';
    eval 'sub LTOHPS () {( &PGSHIFT -  &VAX_PGSHIFT);}' unless defined(&LTOHPS);
    eval 'sub LTOHPN () {(1<<  &LTOHPS);}' unless defined(&LTOHPN);
    eval 'sub USRPTSIZE () {(( &MAXTSIZ +  &MAXDSIZ +  &MAXSSIZ +  &MMAPSPACE) /  &VAX_NBPG);}' unless defined(&USRPTSIZE);
    eval 'sub NPTEPGS () {( &USRPTSIZE / ($sizeof{\'struct pte\'} *  &LTOHPN));}' unless defined(&NPTEPGS);
    eval 'sub ROUND_PAGE {
        local($x) = @_;
	    eval q(((($x) +  &PGOFSET) & ~ &PGOFSET));
    }' unless defined(&ROUND_PAGE);
    eval 'sub TRUNC_PAGE {
        local($x) = @_;
	    eval q((($x) & ~ &PGOFSET));
    }' unless defined(&TRUNC_PAGE);
    eval 'sub MAPVIRT {
        local($ptr, $count) = @_;
	    eval q($ptr =  &virtual_avail;  &virtual_avail += ($count) *  &VAX_NBPG;);
    }' unless defined(&MAPVIRT);
    eval 'sub MAPPHYS {
        local($ptr, $count, $perm) = @_;
	    eval q($ptr =  &avail_start +  &KERNBASE;  &avail_start += ($count) *  &VAX_NBPG;);
    }' unless defined(&MAPPHYS);
    if(defined(&_KERNEL)) {
	eval 'sub pmap_kernel () {
	    eval q(( &kernel_pmap_store));
	}' unless defined(&pmap_kernel);
	eval 'sub PMAP_MAP_POOLPAGE {
	    local($pa) = @_;
    	    eval q((($pa) |  &KERNBASE));
	}' unless defined(&PMAP_MAP_POOLPAGE);
	eval 'sub PMAP_UNMAP_POOLPAGE {
	    local($va) = @_;
    	    eval q((($va) & ~ &KERNBASE));
	}' unless defined(&PMAP_UNMAP_POOLPAGE);
	eval 'sub PMAP_STEAL_MEMORY () {1;}' unless defined(&PMAP_STEAL_MEMORY);
	eval 'sub pmap_phys_address {
	    local($phys) = @_;
    	    eval q((($phys) <<  &PGSHIFT));
	}' unless defined(&pmap_phys_address);
	eval 'sub pmap_copy {
	    local($a,$b,$c,$d,$e) = @_;
    	    eval q();
	}' unless defined(&pmap_copy);
	eval 'sub pmap_update {
	    local($pm) = @_;
    	    eval q();
	}' unless defined(&pmap_update);
	eval 'sub pmap_collect {
	    local($pmap) = @_;
    	    eval q();
	}' unless defined(&pmap_collect);
	eval 'sub pmap_remove {
	    local($pmap, $start, $slut) = @_;
    	    eval q( &pmap_protect($pmap, $start, $slut, 0));
	}' unless defined(&pmap_remove);
	eval 'sub pmap_resident_count {
	    local($pmap) = @_;
    	    eval q((($pmap)-> ($pm_stats->{resident_count})));
	}' unless defined(&pmap_resident_count);
	eval 'sub pmap_deactivate {
	    local($p) = @_;
    	    eval q();
	}' unless defined(&pmap_deactivate);
	eval 'sub pmap_reference {
	    local($pmap) = @_;
    	    eval q(($pmap)-> &ref_count++);
	}' unless defined(&pmap_reference);
	eval 'sub pmap_copy_page {
	    local($src, $dst) = @_;
    	    eval q( &__asm__(\\"addl3 $0x80000000,%0,r0;addl3 $0x80000000,%1,r1;		    movc3 $4096,(r0),(r1)\\" :: \\"r\\"($src),\\"r\\"($dst):\\"r0\\",\\"r1\\",\\"r2\\",\\"r3\\",\\"r4\\",\\"r5\\"););
	}' unless defined(&pmap_copy_page);
	eval 'sub pmap_zero_page {
	    local($phys) = @_;
    	    eval q( &__asm__(\\"addl3 $0x80000000,%0,r0;movc5 $0,(r0),$0,$4096,(r0)\\" :: \\"r\\"($phys): \\"r0\\",\\"r1\\",\\"r2\\",\\"r3\\",\\"r4\\",\\"r5\\"););
	}' unless defined(&pmap_zero_page);
    }
}
1;
