require '_h2ph_pre.ph';

unless(defined(&ASI_LITTLE)) {
    sub ASI_LITTLE () {	0x08;}
}
unless(defined(&ASI_NUCLEUS)) {
    sub ASI_NUCLEUS () {	0x04;}
}
unless(defined(&ASI_NUCLEUS_LITTLE)) {
    sub ASI_NUCLEUS_LITTLE () {	0x0c;}
}
unless(defined(&ASI_AS_IF_USER_PRIMARY)) {
    sub ASI_AS_IF_USER_PRIMARY () {	0x10;}
}
unless(defined(&ASI_AS_IF_USER_SECONDARY)) {
    sub ASI_AS_IF_USER_SECONDARY () {	0x11;}
}
unless(defined(&ASI_PHYS_CACHED)) {
    sub ASI_PHYS_CACHED () {	0x14;}
}
unless(defined(&ASI_PHYS_NON_CACHED)) {
    sub ASI_PHYS_NON_CACHED () {	0x15;}
}
unless(defined(&ASI_AS_IF_USER_PRIMARY_LITTLE)) {
    sub ASI_AS_IF_USER_PRIMARY_LITTLE () {	0x18;}
}
unless(defined(&ASI_AS_IF_USER_SECONDARY_LITTIE)) {
    sub ASI_AS_IF_USER_SECONDARY_LITTIE () {	0x19;}
}
unless(defined(&ASI_PHYS_CACHED_LITTLE)) {
    sub ASI_PHYS_CACHED_LITTLE () {	0x1c;}
}
unless(defined(&ASI_PHYS_NON_CACHED_LITTLE)) {
    sub ASI_PHYS_NON_CACHED_LITTLE () {	0x1d;}
}
unless(defined(&ASI_NUCLEUS_QUAD_LDD)) {
    sub ASI_NUCLEUS_QUAD_LDD () {	0x24;}
}
unless(defined(&ASI_NUCLEUS_QUAD_LDD_LITTLE)) {
    sub ASI_NUCLEUS_QUAD_LDD_LITTLE () {	0x2c;}
}
unless(defined(&ASI_FLUSH_D_PAGE_PRIMARY)) {
    sub ASI_FLUSH_D_PAGE_PRIMARY () {	0x38;}
}
unless(defined(&ASI_FLUSH_D_PAGE_SECONDARY)) {
    sub ASI_FLUSH_D_PAGE_SECONDARY () {	0x39;}
}
unless(defined(&ASI_FLUSH_D_CTX_PRIMARY)) {
    sub ASI_FLUSH_D_CTX_PRIMARY () {	0x3a;}
}
unless(defined(&ASI_FLUSH_D_CTX_SECONDARY)) {
    sub ASI_FLUSH_D_CTX_SECONDARY () {	0x3b;}
}
unless(defined(&ASI_LSU_CONTROL_REGISTER)) {
    sub ASI_LSU_CONTROL_REGISTER () {	0x45;}
}
unless(defined(&ASI_DCACHE_DATA)) {
    sub ASI_DCACHE_DATA () {	0x46;}
}
unless(defined(&ASI_DCACHE_TAG)) {
    sub ASI_DCACHE_TAG () {	0x47;}
}
unless(defined(&ASI_INTR_DISPATCH_STATUS)) {
    sub ASI_INTR_DISPATCH_STATUS () {	0x48;}
}
unless(defined(&ASI_INTR_RECEIVE)) {
    sub ASI_INTR_RECEIVE () {	0x49;}
}
unless(defined(&ASI_MID_REG)) {
    sub ASI_MID_REG () {	0x4a;}
}
unless(defined(&ASI_ERROR_EN_REG)) {
    sub ASI_ERROR_EN_REG () {	0x4b;}
}
unless(defined(&ASI_AFSR)) {
    sub ASI_AFSR () {	0x4c;}
}
unless(defined(&ASI_AFAR)) {
    sub ASI_AFAR () {	0x4d;}
}
unless(defined(&ASI_ICACHE_DATA)) {
    sub ASI_ICACHE_DATA () {	0x66;}
}
unless(defined(&ASI_ICACHE_TAG)) {
    sub ASI_ICACHE_TAG () {	0x67;}
}
unless(defined(&ASI_FLUSH_I_PAGE_PRIMARY)) {
    sub ASI_FLUSH_I_PAGE_PRIMARY () {	0x68;}
}
unless(defined(&ASI_FLUSH_I_PAGE_SECONDARY)) {
    sub ASI_FLUSH_I_PAGE_SECONDARY () {	0x69;}
}
unless(defined(&ASI_FLUSH_I_CTX_PRIMARY)) {
    sub ASI_FLUSH_I_CTX_PRIMARY () {	0x6a;}
}
unless(defined(&ASI_FLUSH_I_CTX_SECONDARY)) {
    sub ASI_FLUSH_I_CTX_SECONDARY () {	0x6b;}
}
unless(defined(&ASI_BLOCK_AS_IF_USER_PRIMARY)) {
    sub ASI_BLOCK_AS_IF_USER_PRIMARY () {	0x70;}
}
unless(defined(&ASI_BLOCK_AS_IF_USER_SECONDARY)) {
    sub ASI_BLOCK_AS_IF_USER_SECONDARY () {	0x71;}
}
unless(defined(&ASI_ECACHE_DIAG)) {
    sub ASI_ECACHE_DIAG () {	0x76;}
}
unless(defined(&ASI_DATAPATH_ERR_REG_WRITE)) {
    sub ASI_DATAPATH_ERR_REG_WRITE () {	0x77;}
}
unless(defined(&ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE)) {
    sub ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE () {	0x78;}
}
unless(defined(&ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE)) {
    sub ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE () {	0x79;}
}
unless(defined(&ASI_INTERRUPT_RECEIVE_DATA)) {
    sub ASI_INTERRUPT_RECEIVE_DATA () {	0x7f;}
}
unless(defined(&ASI_DATAPATH_ERR_REG_READ)) {
    sub ASI_DATAPATH_ERR_REG_READ () {	0x7f;}
}
unless(defined(&ASI_PRIMARY)) {
    sub ASI_PRIMARY () {	0x80;}
}
unless(defined(&ASI_SECONDARY)) {
    sub ASI_SECONDARY () {	0x81;}
}
unless(defined(&ASI_PRIMARY_NOFAULT)) {
    sub ASI_PRIMARY_NOFAULT () {	0x82;}
}
unless(defined(&ASI_SECONDARY_NOFAULT)) {
    sub ASI_SECONDARY_NOFAULT () {	0x83;}
}
unless(defined(&ASI_PRIMARY_LITTLE)) {
    sub ASI_PRIMARY_LITTLE () {	0x88;}
}
unless(defined(&ASI_SECONDARY_LITTLE)) {
    sub ASI_SECONDARY_LITTLE () {	0x89;}
}
unless(defined(&ASI_PRIMARY_NOFAULT_LITTLE)) {
    sub ASI_PRIMARY_NOFAULT_LITTLE () {	0x8a;}
}
unless(defined(&ASI_SECONDARY_NOFAULT_LITTLE)) {
    sub ASI_SECONDARY_NOFAULT_LITTLE () {	0x8b;}
}
unless(defined(&ASI_PST8_PRIMARY)) {
    sub ASI_PST8_PRIMARY () {	0xc0;}
}
unless(defined(&ASI_PST8_SECONDARY)) {
    sub ASI_PST8_SECONDARY () {	0xc1;}
}
unless(defined(&ASI_PST16_PRIMARY)) {
    sub ASI_PST16_PRIMARY () {	0xc2;}
}
unless(defined(&ASI_PST16_SECONDARY)) {
    sub ASI_PST16_SECONDARY () {	0xc3;}
}
unless(defined(&ASI_PST32_PRIMARY)) {
    sub ASI_PST32_PRIMARY () {	0xc4;}
}
unless(defined(&ASI_PST32_SECONDARY)) {
    sub ASI_PST32_SECONDARY () {	0xc5;}
}
unless(defined(&ASI_PST8_PRIMARY_LITTLE)) {
    sub ASI_PST8_PRIMARY_LITTLE () {	0xc8;}
}
unless(defined(&ASI_PST8_SECONDARY_LITTLE)) {
    sub ASI_PST8_SECONDARY_LITTLE () {	0xc9;}
}
unless(defined(&ASI_PST16_PRIMARY_LITTLE)) {
    sub ASI_PST16_PRIMARY_LITTLE () {	0xca;}
}
unless(defined(&ASI_PST16_SECONDARY_LITTLE)) {
    sub ASI_PST16_SECONDARY_LITTLE () {	0xcb;}
}
unless(defined(&ASI_PST32_PRIMARY_LITTLE)) {
    sub ASI_PST32_PRIMARY_LITTLE () {	0xcc;}
}
unless(defined(&ASI_PST32_SECONDARY_LITTLE)) {
    sub ASI_PST32_SECONDARY_LITTLE () {	0xcd;}
}
unless(defined(&ASI_FL8_PRIMARY)) {
    sub ASI_FL8_PRIMARY () {	0xd0;}
}
unless(defined(&ASI_FL8_SECONDARY)) {
    sub ASI_FL8_SECONDARY () {	0xd1;}
}
unless(defined(&ASI_FL16_PRIMARY)) {
    sub ASI_FL16_PRIMARY () {	0xd2;}
}
unless(defined(&ASI_FL16_SECONDARY)) {
    sub ASI_FL16_SECONDARY () {	0xd3;}
}
unless(defined(&ASI_FL8_PRIMARY_LITTLE)) {
    sub ASI_FL8_PRIMARY_LITTLE () {	0xd8;}
}
unless(defined(&ASI_FL8_SECONDARY_LITTLE)) {
    sub ASI_FL8_SECONDARY_LITTLE () {	0xd9;}
}
unless(defined(&ASI_FL16_PRIMARY_LITTLE)) {
    sub ASI_FL16_PRIMARY_LITTLE () {	0xda;}
}
unless(defined(&ASI_FL16_SECONDARY_LITTLE)) {
    sub ASI_FL16_SECONDARY_LITTLE () {	0xdb;}
}
unless(defined(&ASI_BLOCK_COMMIT_PRIMARY)) {
    sub ASI_BLOCK_COMMIT_PRIMARY () {	0xe0;}
}
unless(defined(&ASI_BLOCK_COMMIT_SECONDARY)) {
    sub ASI_BLOCK_COMMIT_SECONDARY () {	0xe1;}
}
unless(defined(&ASI_BLOCK_PRIMARY)) {
    sub ASI_BLOCK_PRIMARY () {	0xf0;}
}
unless(defined(&ASI_BLOCK_SECONDARY)) {
    sub ASI_BLOCK_SECONDARY () {	0xf1;}
}
unless(defined(&ASI_BLOCK_PRIMARY_LITTLE)) {
    sub ASI_BLOCK_PRIMARY_LITTLE () {	0xf8;}
}
unless(defined(&ASI_BLOCK_SECONDARY_LITTLE)) {
    sub ASI_BLOCK_SECONDARY_LITTLE () {	0xf9;}
}
unless(defined(&ASI_N)) {
    sub ASI_N () {	 &ASI_NUCLEUS;}
}
unless(defined(&ASI_NL)) {
    sub ASI_NL () {	 &ASI_NUCLEUS_LITTLE;}
}
unless(defined(&ASI_AIUP)) {
    sub ASI_AIUP () {	 &ASI_AS_IF_USER_PRIMARY;}
}
unless(defined(&ASI_AIUS)) {
    sub ASI_AIUS () {	 &ASI_AS_IF_USER_SECONDARY;}
}
unless(defined(&ASI_AIUPL)) {
    sub ASI_AIUPL () {	 &ASI_AS_IF_USER_PRIMARY_LITTLE;}
}
unless(defined(&ASI_AIUSL)) {
    sub ASI_AIUSL () {	 &ASI_AS_IF_USER_SECONDARY_LITTLE;}
}
unless(defined(&ASI_P)) {
    sub ASI_P () {	 &ASI_PRIMARY;}
}
unless(defined(&ASI_S)) {
    sub ASI_S () {	 &ASI_SECONDARY;}
}
unless(defined(&ASI_PNF)) {
    sub ASI_PNF () {	 &ASI_PRIMARY_NOFAULT;}
}
unless(defined(&ASI_SNF)) {
    sub ASI_SNF () {	 &ASI_SECONDARY_NOFAULT;}
}
unless(defined(&ASI_PL)) {
    sub ASI_PL () {	 &ASI_PRIMARY_LITTLE;}
}
unless(defined(&ASI_SL)) {
    sub ASI_SL () {	 &ASI_SECONDARY_LITTLE;}
}
unless(defined(&ASI_PNFL)) {
    sub ASI_PNFL () {	 &ASI_PRIMARY_NOFAULT_LITTLE;}
}
unless(defined(&ASI_SNFL)) {
    sub ASI_SNFL () {	 &ASI_SECONDARY_NOFAULT_LITTLE;}
}
unless(defined(&ASI_FL8_P)) {
    sub ASI_FL8_P () {	 &ASI_FL8_PRIMARY;}
}
unless(defined(&ASI_FL8_S)) {
    sub ASI_FL8_S () {	 &ASI_FL8_SECONDARY;}
}
unless(defined(&ASI_FL16_P)) {
    sub ASI_FL16_P () {	 &ASI_FL16_PRIMARY;}
}
unless(defined(&ASI_FL16_S)) {
    sub ASI_FL16_S () {	 &ASI_FL16_SECONDARY;}
}
unless(defined(&ASI_FL8_PL)) {
    sub ASI_FL8_PL () {	 &ASI_FL8_PRIMARY_LITTLE;}
}
unless(defined(&ASI_FL8_SL)) {
    sub ASI_FL8_SL () {	 &ASI_FL8_SECONDARY_LITTLE;}
}
unless(defined(&ASI_FL16_PL)) {
    sub ASI_FL16_PL () {	 &ASI_FL16_PRIMARY_LITTLE;}
}
unless(defined(&ASI_FL16_SL)) {
    sub ASI_FL16_SL () {	 &ASI_FL16_SECONDARY_LITTLE;}
}
unless(defined(&ASI_BLK_AIUP)) {
    sub ASI_BLK_AIUP () {	 &ASI_BLOCK_AS_IF_USER_PRIMARY;}
}
unless(defined(&ASI_BLK_AIUPL)) {
    sub ASI_BLK_AIUPL () {	 &ASI_BLOCK_AS_IF_USER_PRIMARY_LITTLE;}
}
unless(defined(&ASI_BLK_AIUS)) {
    sub ASI_BLK_AIUS () {	 &ASI_BLOCK_AS_IF_USER_SECONDARY;}
}
unless(defined(&ASI_BLK_AIUSL)) {
    sub ASI_BLK_AIUSL () {	 &ASI_BLOCK_AS_IF_USER_SECONDARY_LITTLE;}
}
unless(defined(&ASI_BLK_COMMIT_P)) {
    sub ASI_BLK_COMMIT_P () {	 &ASI_BLOCK_COMMIT_PRIMARY;}
}
unless(defined(&ASI_BLK_COMMIT_PRIMARY)) {
    sub ASI_BLK_COMMIT_PRIMARY () {	 &ASI_BLOCK_COMMIT_PRIMARY;}
}
unless(defined(&ASI_BLK_COMMIT_S)) {
    sub ASI_BLK_COMMIT_S () {	 &ASI_BLOCK_COMMIT_SECONDARY;}
}
unless(defined(&ASI_BLK_COMMIT_SECONDARY)) {
    sub ASI_BLK_COMMIT_SECONDARY () {	 &ASI_BLOCK_COMMIT_SECONDARY;}
}
unless(defined(&ASI_BLK_P)) {
    sub ASI_BLK_P () {	 &ASI_BLOCK_PRIMARY;}
}
unless(defined(&ASI_BLK_PL)) {
    sub ASI_BLK_PL () {	 &ASI_BLOCK_PRIMARY_LITTLE;}
}
unless(defined(&ASI_BLK_S)) {
    sub ASI_BLK_S () {	 &ASI_BLOCK_SECONDARY;}
}
unless(defined(&ASI_BLK_SL)) {
    sub ASI_BLK_SL () {	 &ASI_BLOCK_SECONDARY_LITTLE;}
}
unless(defined(&ASI_PRIMARY_NO_FAULT)) {
    sub ASI_PRIMARY_NO_FAULT () {	 &ASI_PRIMARY_NOFAULT;}
}
unless(defined(&ASI_PRIMARY_NO_FAULT_LITTLE)) {
    sub ASI_PRIMARY_NO_FAULT_LITTLE () {	 &ASI_PRIMARY_NOFAULT_LITTLE;}
}
unless(defined(&ASI_SECONDARY_NO_FAULT)) {
    sub ASI_SECONDARY_NO_FAULT () {	 &ASI_SECONDARY_NOFAULT;}
}
unless(defined(&ASI_SECONDARY_NO_FAULT_LITTLE)) {
    sub ASI_SECONDARY_NO_FAULT_LITTLE () {	 &ASI_SECONDARY_NOFAULT_LITTLE;}
}
unless(defined(&PHYS_ASI)) {
    sub PHYS_ASI {
	local($x) = @_;
	eval q(((($x) | 0x08) == 0x1c));
    }
}
unless(defined(&LITTLE_ASI)) {
    sub LITTLE_ASI {
	local($x) = @_;
	eval q((($x) &  &ASI_LITTLE));
    }
}
unless(defined(&TICK_NPT)) {
    sub TICK_NPT () {	0x8000000000000000;}
}
unless(defined(&TICK_TICKS)) {
    sub TICK_TICKS () {	0x7fffffffffffffff;}
}
unless(defined(&UPA_CR_MID)) {
    sub UPA_CR_MID {
	local($x) = @_;
	eval q(((($x)>>17)&0x1f));
    }
}
unless(defined(&CPU_UPAID)) {
    sub CPU_UPAID () {	 &UPA_CR_MID( &ldxa(0,  &ASI_MID_REG));}
}
unless(defined(&ASI_MCCR)) {
    sub ASI_MCCR () {	 &ASI_LSU_CONTROL_REGISTER;}
}
unless(defined(&MCCR)) {
    sub MCCR () {	0x00;}
}
unless(defined(&MCCR_DMMU_EN)) {
    sub MCCR_DMMU_EN () {	0x08;}
}
unless(defined(&MCCR_IMMU_EN)) {
    sub MCCR_IMMU_EN () {	0x04;}
}
unless(defined(&MCCR_DCACHE_EN)) {
    sub MCCR_DCACHE_EN () {	0x02;}
}
unless(defined(&MCCR_ICACHE_EN)) {
    sub MCCR_ICACHE_EN () {	0x01;}
}
unless(defined(&ASI_DMMU)) {
    sub ASI_DMMU () {	0x58;}
}
unless(defined(&ASI_IMMU)) {
    sub ASI_IMMU () {	0x50;}
}
unless(defined(&ASI_IMMU_8KPTR)) {
    sub ASI_IMMU_8KPTR () {	0x51;}
}
unless(defined(&ASI_IMMU_64KPTR)) {
    sub ASI_IMMU_64KPTR () {	0x52;}
}
unless(defined(&ASI_IMMU_DATA_IN)) {
    sub ASI_IMMU_DATA_IN () {	0x54;}
}
unless(defined(&ASI_IMMU_TLB_DATA)) {
    sub ASI_IMMU_TLB_DATA () {	0x55;}
}
unless(defined(&ASI_IMMU_TLB_TAG)) {
    sub ASI_IMMU_TLB_TAG () {	0x56;}
}
unless(defined(&ASI_DMMU_8KPTR)) {
    sub ASI_DMMU_8KPTR () {	0x59;}
}
unless(defined(&ASI_DMMU_64KPTR)) {
    sub ASI_DMMU_64KPTR () {	0x5a;}
}
unless(defined(&ASI_DMMU_DATA_IN)) {
    sub ASI_DMMU_DATA_IN () {	0x5c;}
}
unless(defined(&ASI_DMMU_TLB_DATA)) {
    sub ASI_DMMU_TLB_DATA () {	0x5d;}
}
unless(defined(&ASI_DMMU_TLB_TAG)) {
    sub ASI_DMMU_TLB_TAG () {	0x5e;}
}
unless(defined(&TSB_TAG_TARGET)) {
    sub TSB_TAG_TARGET () {	0x0;}
}
unless(defined(&TLB_DATA_IN)) {
    sub TLB_DATA_IN () {	0x0;}
}
unless(defined(&CTX_PRIMARY)) {
    sub CTX_PRIMARY () {	0x08;}
}
unless(defined(&CTX_SECONDARY)) {
    sub CTX_SECONDARY () {	0x10;}
}
unless(defined(&SFSR)) {
    sub SFSR () {	0x18;}
}
unless(defined(&SFAR)) {
    sub SFAR () {	0x20;}
}
unless(defined(&TSB)) {
    sub TSB () {	0x28;}
}
unless(defined(&TLB_TAG_ACCESS)) {
    sub TLB_TAG_ACCESS () {	0x30;}
}
unless(defined(&VIRTUAL_WATCHPOINT)) {
    sub VIRTUAL_WATCHPOINT () {	0x38;}
}
unless(defined(&PHYSICAL_WATCHPOINT)) {
    sub PHYSICAL_WATCHPOINT () {	0x40;}
}
unless(defined(&TAG_TARGET_VA_MASK)) {
    sub TAG_TARGET_VA_MASK () {	0x03ffffffffffffffff;}
}
unless(defined(&TAG_TARGET_VA)) {
    sub TAG_TARGET_VA {
	local($x) = @_;
	eval q(((($x)<<22) &TAG_TARGET_VA_MASK));
    }
}
unless(defined(&TAG_TARGET_CONTEXT)) {
    sub TAG_TARGET_CONTEXT {
	local($x) = @_;
	eval q((($x)>>48));
    }
}
unless(defined(&TAG_TARGET)) {
    sub TAG_TARGET {
	local($c,$v) = @_;
	eval q(((<<48)|(($v) &TAG_TARGET_VA_MASK)));
    }
}
unless(defined(&SFSR_ASI)) {
    sub SFSR_ASI {
	local($x) = @_;
	eval q((($x)>>16));
    }
}
unless(defined(&SFSR_FT_VA_OOR_2)) {
    sub SFSR_FT_VA_OOR_2 () {	0x02000;}
}
unless(defined(&SFSR_FT_VA_OOR_1)) {
    sub SFSR_FT_VA_OOR_1 () {	0x01000;}
}
unless(defined(&SFSR_FT_NFO)) {
    sub SFSR_FT_NFO () {	0x00800;}
}
unless(defined(&SFSR_ILL_ASI)) {
    sub SFSR_ILL_ASI () {	0x00400;}
}
unless(defined(&SFSR_FT_IO_ATOMIC)) {
    sub SFSR_FT_IO_ATOMIC () {	0x00200;}
}
unless(defined(&SFSR_FT_ILL_NF)) {
    sub SFSR_FT_ILL_NF () {	0x00100;}
}
unless(defined(&SFSR_FT_PRIV)) {
    sub SFSR_FT_PRIV () {	0x00080;}
}
unless(defined(&SFSR_FT_E)) {
    sub SFSR_FT_E () {	0x00040;}
}
unless(defined(&SFSR_CTXT)) {
    sub SFSR_CTXT {
	local($x) = @_;
	eval q(((($x)>>4)&0x3));
    }
}
unless(defined(&SFSR_CTXT_IS_PRIM)) {
    sub SFSR_CTXT_IS_PRIM {
	local($x) = @_;
	eval q(( &SFSR_CTXT($x)==0x00));
    }
}
unless(defined(&SFSR_CTXT_IS_SECOND)) {
    sub SFSR_CTXT_IS_SECOND {
	local($x) = @_;
	eval q(( &SFSR_CTXT($x)==0x01));
    }
}
unless(defined(&SFSR_CTXT_IS_NUCLEUS)) {
    sub SFSR_CTXT_IS_NUCLEUS {
	local($x) = @_;
	eval q(( &SFSR_CTXT($x)==0x02));
    }
}
unless(defined(&SFSR_PRIV)) {
    sub SFSR_PRIV () {	0x00008;}
}
unless(defined(&SFSR_W)) {
    sub SFSR_W () {	0x00004;}
}
unless(defined(&SFSR_OW)) {
    sub SFSR_OW () {	0x00002;}
}
unless(defined(&SFSR_FV)) {
    sub SFSR_FV () {	0x00001;}
}
unless(defined(&SFSR_FT)) {
    sub SFSR_FT () {	( &SFSR_FT_VA_OOR_2| &SFSR_FT_VA_OOR_1| &SFSR_FT_NFO| &SFSR_ILL_ASI| &SFSR_FT_IO_ATOMIC| &SFSR_FT_ILL_NF| &SFSR_FT_PRIV);}
}
unless(defined(&SFSR_BITS)) {
    sub SFSR_BITS () {	"\20\16VAT\15VAD\14NFO\13ASI\12A\11NF\10PRIV\7E\6NUCLEUS\5SECONDCTX\4PRIV\3W\2OW\1FV";}
}
unless(defined(&ASFR_ME)) {
    sub ASFR_ME () {	0x100000000;}
}
unless(defined(&ASFR_PRIV)) {
    sub ASFR_PRIV () {	0x080000000;}
}
unless(defined(&ASFR_ISAP)) {
    sub ASFR_ISAP () {	0x040000000;}
}
unless(defined(&ASFR_ETP)) {
    sub ASFR_ETP () {	0x020000000;}
}
unless(defined(&ASFR_IVUE)) {
    sub ASFR_IVUE () {	0x010000000;}
}
unless(defined(&ASFR_TO)) {
    sub ASFR_TO () {	0x008000000;}
}
unless(defined(&ASFR_BERR)) {
    sub ASFR_BERR () {	0x004000000;}
}
unless(defined(&ASFR_LDP)) {
    sub ASFR_LDP () {	0x002000000;}
}
unless(defined(&ASFR_CP)) {
    sub ASFR_CP () {	0x001000000;}
}
unless(defined(&ASFR_WP)) {
    sub ASFR_WP () {	0x000800000;}
}
unless(defined(&ASFR_EDP)) {
    sub ASFR_EDP () {	0x000400000;}
}
unless(defined(&ASFR_UE)) {
    sub ASFR_UE () {	0x000200000;}
}
unless(defined(&ASFR_CE)) {
    sub ASFR_CE () {	0x000100000;}
}
unless(defined(&ASFR_ETS)) {
    sub ASFR_ETS () {	0x0000f0000;}
}
unless(defined(&ASFT_P_SYND)) {
    sub ASFT_P_SYND () {	0x00000ffff;}
}
unless(defined(&AFSR_BITS)) {
    sub AFSR_BITS () {	"\20" "\20ME\37PRIV\36ISAP\35ETP\34IVUE\33TO\32BERR\31LDP\30CP\27WP\26EDP" "\25UE\24CE";}
}
unless(defined(&TSB_SIZE_512)) {
    sub TSB_SIZE_512 () {	0x0;}
}
unless(defined(&TSB_SIZE_1K)) {
    sub TSB_SIZE_1K () {	0x01;}
}
unless(defined(&TSB_SIZE_2K)) {
    sub TSB_SIZE_2K () {	0x02;}
}
unless(defined(&TSB_SIZE_4K)) {
    sub TSB_SIZE_4K () {	0x03;}
}
unless(defined(&TSB_SIZE_8K)) {
    sub TSB_SIZE_8K () {	0x04;}
}
unless(defined(&TSB_SIZE_16K)) {
    sub TSB_SIZE_16K () {	0x05;}
}
unless(defined(&TSB_SIZE_32K)) {
    sub TSB_SIZE_32K () {	0x06;}
}
unless(defined(&TSB_SIZE_64K)) {
    sub TSB_SIZE_64K () {	0x07;}
}
unless(defined(&TSB_SPLIT)) {
    sub TSB_SPLIT () {	0x1000;}
}
unless(defined(&TSB_BASE)) {
    sub TSB_BASE () {	0xffffffffffffe000;}
}
unless(defined(&TLB_TAG_ACCESS_VA)) {
    sub TLB_TAG_ACCESS_VA () {	0xffffffffffffe000;}
}
unless(defined(&TLB_TAG_ACCESS_CTX)) {
    sub TLB_TAG_ACCESS_CTX () {	0x0000000000001fff;}
}
unless(defined(&ASI_IMMU_DEMAP)) {
    sub ASI_IMMU_DEMAP () {	0x57;}
}
unless(defined(&ASI_DMMU_DEMAP)) {
    sub ASI_DMMU_DEMAP () {	0x5f;}
}
unless(defined(&DEMAP_PAGE_NUCLEUS)) {
    sub DEMAP_PAGE_NUCLEUS () {	((0x02)<<4);}
}
unless(defined(&DEMAP_PAGE_PRIMARY)) {
    sub DEMAP_PAGE_PRIMARY () {	((0x00)<<4);}
}
unless(defined(&DEMAP_PAGE_SECONDARY)) {
    sub DEMAP_PAGE_SECONDARY () {	((0x01)<<4);}
}
unless(defined(&DEMAP_CTX_NUCLEUS)) {
    sub DEMAP_CTX_NUCLEUS () {	((0x06)<<4);}
}
unless(defined(&DEMAP_CTX_PRIMARY)) {
    sub DEMAP_CTX_PRIMARY () {	((0x04)<<4);}
}
unless(defined(&DEMAP_CTX_SECONDARY)) {
    sub DEMAP_CTX_SECONDARY () {	((0x05)<<4);}
}
unless(defined(&ASI_IRSR)) {
    sub ASI_IRSR () {	0x49;}
}
unless(defined(&IRSR)) {
    sub IRSR () {	0x00;}
}
unless(defined(&IRSR_BUSY)) {
    sub IRSR_BUSY () {	0x020;}
}
unless(defined(&IRSR_MID)) {
    sub IRSR_MID {
	local($x) = @_;
	eval q(($x&0x1f));
    }
}
unless(defined(&ASI_IRDR)) {
    sub ASI_IRDR () {	0x7f;}
}
unless(defined(&IRDR_0H)) {
    sub IRDR_0H () {	0x40;}
}
unless(defined(&IRDR_0L)) {
    sub IRDR_0L () {	0x48;}
}
unless(defined(&IRDR_1H)) {
    sub IRDR_1H () {	0x50;}
}
unless(defined(&IRDR_1L)) {
    sub IRDR_1L () {	0x58;}
}
unless(defined(&IRDR_2H)) {
    sub IRDR_2H () {	0x60;}
}
unless(defined(&IRDR_2L)) {
    sub IRDR_2L () {	0x68;}
}
unless(defined(&IRDR_3H)) {
    sub IRDR_3H () {	0x70;}
}
unless(defined(&IRDR_3L)) {
    sub IRDR_3L () {	0x78;}
}
unless(defined(&SET_SOFTINT)) {
    sub SET_SOFTINT () {	% &asr20;}
}
unless(defined(&CLEAR_SOFTINT)) {
    sub CLEAR_SOFTINT () {	% &asr21;}
}
unless(defined(&SOFTINT)) {
    sub SOFTINT () {	% &asr22;}
}
unless(defined(&TICK_CMPR)) {
    sub TICK_CMPR () {	% &asr23;}
}
unless(defined(&TICK_INT)) {
    sub TICK_INT () {	0x01;}
}
unless(defined(&SOFTINT1)) {
    sub SOFTINT1 () {	(0x1<<1);}
}
unless(defined(&SOFTINT2)) {
    sub SOFTINT2 () {	(0x1<<2);}
}
unless(defined(&SOFTINT3)) {
    sub SOFTINT3 () {	(0x1<<3);}
}
unless(defined(&SOFTINT4)) {
    sub SOFTINT4 () {	(0x1<<4);}
}
unless(defined(&SOFTINT5)) {
    sub SOFTINT5 () {	(0x1<<5);}
}
unless(defined(&SOFTINT6)) {
    sub SOFTINT6 () {	(0x1<<6);}
}
unless(defined(&SOFTINT7)) {
    sub SOFTINT7 () {	(0x1<<7);}
}
unless(defined(&SOFTINT8)) {
    sub SOFTINT8 () {	(0x1<<8);}
}
unless(defined(&SOFTINT9)) {
    sub SOFTINT9 () {	(0x1<<9);}
}
unless(defined(&SOFTINT10)) {
    sub SOFTINT10 () {	(0x1<<10);}
}
unless(defined(&SOFTINT11)) {
    sub SOFTINT11 () {	(0x1<<11);}
}
unless(defined(&SOFTINT12)) {
    sub SOFTINT12 () {	(0x1<<12);}
}
unless(defined(&SOFTINT13)) {
    sub SOFTINT13 () {	(0x1<<13);}
}
unless(defined(&SOFTINT14)) {
    sub SOFTINT14 () {	(0x1<<14);}
}
unless(defined(&SOFTINT15)) {
    sub SOFTINT15 () {	(0x1<<15);}
}
unless(defined(&ASR_IDSR)) {
    sub ASR_IDSR () {	0x48;}
}
unless(defined(&IDSR)) {
    sub IDSR () {	0x00;}
}
unless(defined(&IDSR_NACK)) {
    sub IDSR_NACK () {	0x02;}
}
unless(defined(&IDSR_BUSY)) {
    sub IDSR_BUSY () {	0x01;}
}
unless(defined(&ASI_INTERRUPT_DISPATCH)) {
    sub ASI_INTERRUPT_DISPATCH () {	0x77;}
}
unless(defined(&IDCR)) {
    sub IDCR {
	local($x) = @_;
	eval q(((($x)<<14)&0x70));
    }
}
unless(defined(&IDDR_0H)) {
    sub IDDR_0H () {	0x40;}
}
unless(defined(&IDDR_0L)) {
    sub IDDR_0L () {	0x48;}
}
unless(defined(&IDDR_1H)) {
    sub IDDR_1H () {	0x50;}
}
unless(defined(&IDDR_1L)) {
    sub IDDR_1L () {	0x58;}
}
unless(defined(&IDDR_2H)) {
    sub IDDR_2H () {	0x60;}
}
unless(defined(&IDDR_2L)) {
    sub IDDR_2L () {	0x68;}
}
unless(defined(&IDDR_3H)) {
    sub IDDR_3H () {	0x70;}
}
unless(defined(&IDDR_3L)) {
    sub IDDR_3L () {	0x78;}
}
unless(defined(&ASI_AFAR)) {
    sub ASI_AFAR () {	0x4d;}
}
unless(defined(&AFAR)) {
    sub AFAR () {	0x00;}
}
unless(defined(&ASI_AFSR)) {
    sub ASI_AFSR () {	0x4c;}
}
unless(defined(&AFSR)) {
    sub AFSR () {	0x00;}
}
unless(defined(&ASI_P_EER)) {
    sub ASI_P_EER () {	0x4b;}
}
unless(defined(&P_EER)) {
    sub P_EER () {	0x00;}
}
unless(defined(&P_EER_ISAPEN)) {
    sub P_EER_ISAPEN () {	0x04;}
}
unless(defined(&P_EER_NCEEN)) {
    sub P_EER_NCEEN () {	0x02;}
}
unless(defined(&P_EER_CEEN)) {
    sub P_EER_CEEN () {	0x01;}
}
unless(defined(&ASI_DATAPATH_READ)) {
    sub ASI_DATAPATH_READ () {	0x7f;}
}
unless(defined(&ASI_DATAPATH_WRITE)) {
    sub ASI_DATAPATH_WRITE () {	0x77;}
}
unless(defined(&P_DPER_0)) {
    sub P_DPER_0 () {	0x00;}
}
unless(defined(&P_DPER_1)) {
    sub P_DPER_1 () {	0x18;}
}
unless(defined(&P_DCR_0)) {
    sub P_DCR_0 () {	0x20;}
}
unless(defined(&P_DCR_1)) {
    sub P_DCR_1 () {	0x38;}
}
unless(defined(&_LOCORE)) {
    if(0) {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(defined(&__arch64__)) {
    } else {
    }
    if(0) {
	if(defined(&__arch64__)) {
	} else {
	    if(defined(&__notyet)) {
	    }
	}
    }
    eval 'sub flush {
        local($loc) = @_;
	    eval q(({  &__asm  &__volatile(\\"flush %0\\" : : \\"r\\" (($loc))); }));
    }' unless defined(&flush);
    if(0) {
	eval 'sub flushline {
	    local($loc) = @_;
    	    eval q(({  &stxa(($loc)(~0x1f), ( &ASI_DCACHE_TAG), 0);  &membar_sync(); }));
	}' unless defined(&flushline);
    } else {
	eval 'sub flushline {
	    local($loc) = @_;
    	    eval q();
	}' unless defined(&flushline);
    }
    eval 'sub dcenable () {
        eval q(({ \'int\'  &res;  &__asm  &__volatile(\\"ldxa [%%g0] %1,%0; or %0,%2,%0; stxa %0,[%%g0] %1; membar #Sync\\" : \\"r\\" ( &res) : \\"n\\" ( &ASI_MCCR), \\"n\\" ( &MCCR_DCACHE_EN)); }));
    }' unless defined(&dcenable);
    eval 'sub dcdisable () {
        eval q(({ \'int\'  &res;  &__asm  &__volatile(\\"ldxa [%%g0] %1,%0; andn %0,%2,%0; stxa %0,[%%g0] %1; membar #Sync\\" : \\"r\\" ( &res) : \\"n\\" ( &ASI_MCCR), \\"n\\" ( &MCCR_DCACHE_EN)); }));
    }' unless defined(&dcdisable);
    eval 'sub membar_storestore () {
        eval q( &__asm  &__volatile(\\"membar #StoreStore\\" : :));
    }' unless defined(&membar_storestore);
    eval 'sub membar_loadstore () {
        eval q( &__asm  &__volatile(\\"membar #LoadStore\\" : :));
    }' unless defined(&membar_loadstore);
    eval 'sub membar_storeload () {
        eval q( &__asm  &__volatile(\\"membar #StoreLoad\\" : :));
    }' unless defined(&membar_storeload);
    eval 'sub membar_loadload () {
        eval q( &__asm  &__volatile(\\"membar #LoadLoad\\" : :));
    }' unless defined(&membar_loadload);
    eval 'sub membar_sync () {
        eval q( &__asm  &__volatile(\\"membar #Sync\\" : :));
    }' unless defined(&membar_sync);
    eval 'sub membar_memissue () {
        eval q( &__asm  &__volatile(\\"membar #MemIssue\\" : :));
    }' unless defined(&membar_memissue);
    eval 'sub membar_lookaside () {
        eval q( &__asm  &__volatile(\\"membar #Lookaside\\" : :));
    }' unless defined(&membar_lookaside);
    if(defined(&__arch64__)) {
	eval 'sub tick () {
	    eval q(({  &register \'u_long _tick_tmp\';  &__asm  &__volatile(\\"rdpr %%tick, %0\\" : \\"=r\\" ( &_tick_tmp) :);  &_tick_tmp; }));
	}' unless defined(&tick);
    } else {
	eval 'sub tick () {
	    eval q(({  &register \'u_int\'  &_tick_hi = 0,  &_tick_lo = 0;  &__asm  &__volatile(\\"rdpr %%tick, %0; srl %0,0,%1; srlx %0,32,%0 \\" : \\"=r\\" , \\"=r\\" : ); (<<32)|( &_tick_lo); }));
	}' unless defined(&tick);
    }
}
1;
