require '_h2ph_pre.ph';

unless(defined(&_SPARC_BUS_H_)) {
    eval 'sub _SPARC_BUS_H_ () {1;}' unless defined(&_SPARC_BUS_H_);
    require 'machine/types.ph';
    require 'machine/ctlreg.ph';
    eval 'sub __HAS_NEW_BUS_DMAMAP_SYNC () {1;}' unless defined(&__HAS_NEW_BUS_DMAMAP_SYNC);
    eval 'sub BSDB_ACCESS () {0x01;}' unless defined(&BSDB_ACCESS);
    eval 'sub BSDB_MAP () {0x02;}' unless defined(&BSDB_MAP);
    eval("sub UPA_BUS_SPACE () { 0; }") unless defined(&UPA_BUS_SPACE);
    eval("sub SBUS_BUS_SPACE () { 1; }") unless defined(&SBUS_BUS_SPACE);
    eval("sub PCI_CONFIG_BUS_SPACE () { 2; }") unless defined(&PCI_CONFIG_BUS_SPACE);
    eval("sub PCI_IO_BUS_SPACE () { 3; }") unless defined(&PCI_IO_BUS_SPACE);
    eval("sub PCI_MEMORY_BUS_SPACE () { 4; }") unless defined(&PCI_MEMORY_BUS_SPACE);
    eval("sub LAST_BUS_SPACE () { 5; }") unless defined(&LAST_BUS_SPACE);
    eval 'sub SPARC_BUS_SPACE () { &UPA_BUS_SPACE;}' unless defined(&SPARC_BUS_SPACE);
    eval 'sub __BUS_SPACE_HAS_STREAM_METHODS () {1;}' unless defined(&__BUS_SPACE_HAS_STREAM_METHODS);
    eval 'sub BUS_ADDR_IOSPACE {
        local($x) = @_;
	    eval q((($x)>>32));
    }' unless defined(&BUS_ADDR_IOSPACE);
    eval 'sub BUS_ADDR_PADDR {
        local($x) = @_;
	    eval q((($x)&0xffffffff));
    }' unless defined(&BUS_ADDR_PADDR);
    eval 'sub BUS_ADDR {
        local($io, $pa) = @_;
	    eval q(((($io)<<32)|($pa)));
    }' unless defined(&BUS_ADDR);
    if(0) {
    }
    eval 'sub _BS_CALL {
        local($t,$f) = @_;
	    eval q( &while ( ($t->{f}) ==  &NULL) $t =  ($t->{parent});  &return (*($t)->$f));
    }' unless defined(&_BS_CALL);
    if(1) {
	eval 'sub bus_space_vaddr {
	    local($t, $h) = @_;
    	    eval q(($h));
	}' unless defined(&bus_space_vaddr);
    } else {
    }
    eval 'sub BUS_SPACE_MAP_CACHEABLE () {0x0001;}' unless defined(&BUS_SPACE_MAP_CACHEABLE);
    eval 'sub BUS_SPACE_MAP_LINEAR () {0x0002;}' unless defined(&BUS_SPACE_MAP_LINEAR);
    eval 'sub BUS_SPACE_MAP_READONLY () {0x0004;}' unless defined(&BUS_SPACE_MAP_READONLY);
    eval 'sub BUS_SPACE_MAP_PREFETCHABLE () {0x0008;}' unless defined(&BUS_SPACE_MAP_PREFETCHABLE);
    eval 'sub BUS_SPACE_MAP_BUS1 () {0x0100;}' unless defined(&BUS_SPACE_MAP_BUS1);
    eval 'sub BUS_SPACE_MAP_BUS2 () {0x0200;}' unless defined(&BUS_SPACE_MAP_BUS2);
    eval 'sub BUS_SPACE_MAP_BUS3 () {0x0400;}' unless defined(&BUS_SPACE_MAP_BUS3);
    eval 'sub BUS_SPACE_MAP_BUS4 () {0x0800;}' unless defined(&BUS_SPACE_MAP_BUS4);
    eval 'sub BUS_INTR_ESTABLISH_FASTTRAP () {1;}' unless defined(&BUS_INTR_ESTABLISH_FASTTRAP);
    eval 'sub BUS_INTR_ESTABLISH_SOFTINTR () {2;}' unless defined(&BUS_INTR_ESTABLISH_SOFTINTR);
    eval 'sub BUS_SPACE_BARRIER_READ () {0x01;}' unless defined(&BUS_SPACE_BARRIER_READ);
    eval 'sub BUS_SPACE_BARRIER_WRITE () {0x02;}' unless defined(&BUS_SPACE_BARRIER_WRITE);
    unless(defined(&BUS_SPACE_DEBUG)) {
	eval 'sub bus_space_read_1 {
	    local($t, $h, $o) = @_;
    	    eval q( &lduba(($h) + ($o),  $bus_type_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_1);
	eval 'sub bus_space_read_2 {
	    local($t, $h, $o) = @_;
    	    eval q( &lduha(($h) + ($o),  $bus_type_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_2);
	eval 'sub bus_space_read_4 {
	    local($t, $h, $o) = @_;
    	    eval q( &lda(($h) + ($o),  $bus_type_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_4);
	eval 'sub bus_space_read_8 {
	    local($t, $h, $o) = @_;
    	    eval q( &ldxa(($h) + ($o),  $bus_type_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_8);
    } else {
	eval 'sub bus_space_read_1 {
	    local($t, $h, $o) = @_;
    	    eval q(({ \'unsigned char __bv\' =  &lduba( + ,  $bus_type_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr1(%llx + %llx, %x) -> %x\\\\n\\", , ,  $bus_type_asi[-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_1);
	eval 'sub bus_space_read_2 {
	    local($t, $h, $o) = @_;
    	    eval q(({ \'unsigned short __bv\' =  &lduha( + ,  $bus_type_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr2(%llx + %llx, %x) -> %x\\\\n\\", , ,  $bus_type_asi[-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_2);
	eval 'sub bus_space_read_4 {
	    local($t, $h, $o) = @_;
    	    eval q(({ \'unsigned int __bv\' =  &lda( + ,  $bus_type_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr4(%llx + %llx, %x) -> %x\\\\n\\", , ($o),  $bus_type_asi[($t)-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_4);
	eval 'sub bus_space_read_8 {
	    local($t, $h, $o) = @_;
    	    eval q(({  &u_int64_t  &__bv =  &ldxa( + ,  $bus_type_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr8(%llx + %llx, %x) -> %llx\\\\n\\", , ,  $bus_type_asi[-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_8);
    }
    eval 'sub bus_space_read_multi_1 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int8_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_1($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_1);
    eval 'sub bus_space_read_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int16_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_2($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_2);
    eval 'sub bus_space_read_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int32_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_4($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_4);
    eval 'sub bus_space_read_multi_8 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int64_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_8($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_8);
    unless(defined(&BUS_SPACE_DEBUG)) {
	eval 'sub bus_space_write_1 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &stba(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_1);
	eval 'sub bus_space_write_2 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &stha(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_2);
	eval 'sub bus_space_write_4 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &sta(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_4);
	eval 'sub bus_space_write_8 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &stxa(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_8);
    } else {
	eval 'sub bus_space_write_1 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw1(%llx + %llx, %x) <- %x\\\\n\\", , ,  $bus_type_asi[-> &type], $v); (( &stba(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_1);
	eval 'sub bus_space_write_2 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw2(%llx + %llx, %x) <- %x\\\\n\\", , ,  $bus_type_asi[-> &type], $v); (( &stha(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_2);
	eval 'sub bus_space_write_4 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw4(%llx + %llx, %x) <- %x\\\\n\\", , ,  $bus_type_asi[-> &type], $v); (( &sta(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_4);
	eval 'sub bus_space_write_8 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw8(%llx + %llx, %x) <- %llx\\\\n\\", , ,  $bus_type_asi[-> &type], $v); (( &stxa(($h) + ($o),  $bus_type_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_8);
    }
    eval 'sub bus_space_write_multi_1 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int8_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_1($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_1);
    eval 'sub bus_space_write_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int16_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_2($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_2);
    eval 'sub bus_space_write_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int32_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_4($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_4);
    eval 'sub bus_space_write_multi_8 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int64_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_8($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_8);
    eval 'sub bus_space_set_multi_1 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_1($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_1);
    eval 'sub bus_space_set_multi_2 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_2($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_2);
    eval 'sub bus_space_set_multi_4 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_4($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_4);
    eval 'sub bus_space_set_multi_8 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_8($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_8);
    unless(defined(&BUS_SPACE_DEBUG)) {
	eval 'sub bus_space_read_stream_1 {
	    local($t, $h, $o) = @_;
    	    eval q( &lduba(($h) + ($o),  $bus_stream_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_stream_1);
	eval 'sub bus_space_read_stream_2 {
	    local($t, $h, $o) = @_;
    	    eval q( &lduha(($h) + ($o),  $bus_stream_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_stream_2);
	eval 'sub bus_space_read_stream_4 {
	    local($t, $h, $o) = @_;
    	    eval q( &lda(($h) + ($o),  $bus_stream_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_stream_4);
	eval 'sub bus_space_read_stream_8 {
	    local($t, $h, $o) = @_;
    	    eval q( &ldxa(($h) + ($o),  $bus_stream_asi[($t)-> &type]));
	}' unless defined(&bus_space_read_stream_8);
    } else {
	eval 'sub bus_space_read_stream_1 {
	    local($t, $h, $o) = @_;
    	    eval q(({ \'unsigned char __bv\' =  &lduba( + ,  $bus_stream_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr1(%llx + %llx, %x) -> %x\\\\n\\", , ,  $bus_stream_asi[-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_stream_1);
	eval 'sub bus_space_read_stream_2 {
	    local($t, $h, $o) = @_;
    	    eval q(({ \'unsigned short __bv\' =  &lduha( + ,  $bus_stream_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr2(%llx + %llx, %x) -> %x\\\\n\\", , ,  $bus_stream_asi[-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_stream_2);
	eval 'sub bus_space_read_stream_4 {
	    local($t, $h, $o) = @_;
    	    eval q(({ \'unsigned int __bv\' =  &lda( + ,  $bus_stream_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr4(%llx + %llx, %x) -> %x\\\\n\\", , ($o),  $bus_stream_asi[($t)-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_stream_4);
	eval 'sub bus_space_read_stream_8 {
	    local($t, $h, $o) = @_;
    	    eval q(({  &u_int64_t  &__bv =  &ldxa( + ,  $bus_stream_asi[-> &type]);  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsr8(%llx + %llx, %x) -> %llx\\\\n\\", , ,  $bus_stream_asi[-> &type],  &__bv);  &__bv; }));
	}' unless defined(&bus_space_read_stream_8);
    }
    eval 'sub bus_space_read_multi_stream_1 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int8_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_stream_1($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_stream_1);
    eval 'sub bus_space_read_multi_stream_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int16_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_stream_2($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_stream_2);
    eval 'sub bus_space_read_multi_stream_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int32_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_stream_4($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_stream_4);
    eval 'sub bus_space_read_multi_stream_8 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int64_t * &p = $a;  &while ( &i-- > 0) * &p++ =  &bus_space_read_stream_8($t, $h, $o); }  &while (0));
    }' unless defined(&bus_space_read_multi_stream_8);
    unless(defined(&BUS_SPACE_DEBUG)) {
	eval 'sub bus_space_write_stream_1 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &stba(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_stream_1);
	eval 'sub bus_space_write_stream_2 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &stha(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_stream_2);
	eval 'sub bus_space_write_stream_4 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &sta(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_stream_4);
	eval 'sub bus_space_write_stream_8 {
	    local($t, $h, $o, $v) = @_;
    	    eval q((( &stxa(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))));
	}' unless defined(&bus_space_write_stream_8);
    } else {
	eval 'sub bus_space_write_stream_1 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw1(%llx + %llx, %x) <- %x\\\\n\\", , ,  $bus_stream_asi[-> &type], $v); (( &stba(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_stream_1);
	eval 'sub bus_space_write_stream_2 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw2(%llx + %llx, %x) <- %x\\\\n\\", , ,  $bus_stream_asi[-> &type], $v); (( &stha(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_stream_2);
	eval 'sub bus_space_write_stream_4 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw4(%llx + %llx, %x) <- %x\\\\n\\", , ,  $bus_stream_asi[-> &type], $v); (( &sta(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_stream_4);
	eval 'sub bus_space_write_stream_8 {
	    local($t, $h, $o, $v) = @_;
    	    eval q(({  &if ( &bus_space_debug &  &BSDB_ACCESS)  &printf(\\"bsw8(%llx + %llx, %x) <- %llx\\\\n\\", , ,  $bus_stream_asi[-> &type], $v); (( &stxa(($h) + ($o),  $bus_stream_asi[($t)-> &type], ($v)))); }));
	}' unless defined(&bus_space_write_stream_8);
    }
    eval 'sub bus_space_write_multi_stream_1 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int8_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_stream_1($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_stream_1);
    eval 'sub bus_space_write_multi_stream_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int16_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_stream_2($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_stream_2);
    eval 'sub bus_space_write_multi_stream_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int32_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_stream_4($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_stream_4);
    eval 'sub bus_space_write_multi_stream_8 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &u_int64_t * &p = $a;  &while ( &i-- > 0)  &bus_space_write_stream_8($t, $h, $o, * &p++); }  &while (0));
    }' unless defined(&bus_space_write_multi_stream_8);
    eval 'sub bus_space_set_multi_stream_1 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_stream_1($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_stream_1);
    eval 'sub bus_space_set_multi_stream_2 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_stream_2($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_stream_2);
    eval 'sub bus_space_set_multi_stream_4 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_stream_4($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_stream_4);
    eval 'sub bus_space_set_multi_stream_8 {
        local($t, $h, $o, $v, $c) = @_;
	    eval q( &do { \'int\'  &i = $c;  &while ( &i-- > 0)  &bus_space_write_stream_8($t, $h, $o, $v); }  &while (0));
    }' unless defined(&bus_space_set_multi_stream_8);
    eval 'sub BUS_DMA_RAW () { &BUS_DMA_STREAMING;}' unless defined(&BUS_DMA_RAW);
    eval 'sub bus_space_read_raw_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_stream_2($t, $h, $o, ($a), $c/2));
    }' unless defined(&bus_space_read_raw_multi_2);
    eval 'sub bus_space_write_raw_multi_2 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_stream_2($t, $h, $o, ($a), $c/2));
    }' unless defined(&bus_space_write_raw_multi_2);
    eval 'sub bus_space_read_raw_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_read_multi_stream_4($t, $h, $o, ($a), $c/4));
    }' unless defined(&bus_space_read_raw_multi_4);
    eval 'sub bus_space_write_raw_multi_4 {
        local($t, $h, $o, $a, $c) = @_;
	    eval q( &bus_space_write_multi_stream_4($t, $h, $o, ($a), $c/4));
    }' unless defined(&bus_space_write_raw_multi_4);
    eval 'sub BUS_SPACE_ALIGNED_POINTER {
        local($p, $t) = @_;
	    eval q( &ALIGNED_POINTER($p, $t));
    }' unless defined(&BUS_SPACE_ALIGNED_POINTER);
    eval 'sub BUS_DMA_WAITOK () {0x000;}' unless defined(&BUS_DMA_WAITOK);
    eval 'sub BUS_DMA_NOWAIT () {0x001;}' unless defined(&BUS_DMA_NOWAIT);
    eval 'sub BUS_DMA_ALLOCNOW () {0x002;}' unless defined(&BUS_DMA_ALLOCNOW);
    eval 'sub BUS_DMA_COHERENT () {0x004;}' unless defined(&BUS_DMA_COHERENT);
    eval 'sub BUS_DMA_NOWRITE () {0x008;}' unless defined(&BUS_DMA_NOWRITE);
    eval 'sub BUS_DMA_BUS1 () {0x010;}' unless defined(&BUS_DMA_BUS1);
    eval 'sub BUS_DMA_BUS2 () {0x020;}' unless defined(&BUS_DMA_BUS2);
    eval 'sub BUS_DMA_BUS3 () {0x040;}' unless defined(&BUS_DMA_BUS3);
    eval 'sub BUS_DMA_BUS4 () {0x080;}' unless defined(&BUS_DMA_BUS4);
    eval 'sub BUS_DMA_STREAMING () {0x100;}' unless defined(&BUS_DMA_STREAMING);
    eval 'sub BUS_DMA_READ () {0x200;}' unless defined(&BUS_DMA_READ);
    eval 'sub BUS_DMA_WRITE () {0x400;}' unless defined(&BUS_DMA_WRITE);
    eval 'sub BUS_DMA_NOCACHE () { &BUS_DMA_BUS1;}' unless defined(&BUS_DMA_NOCACHE);
    eval 'sub BUS_DMA_DVMA () { &BUS_DMA_BUS2;}' unless defined(&BUS_DMA_DVMA);
    eval 'sub BUS_DMASYNC_PREREAD () {0x01;}' unless defined(&BUS_DMASYNC_PREREAD);
    eval 'sub BUS_DMASYNC_POSTREAD () {0x02;}' unless defined(&BUS_DMASYNC_POSTREAD);
    eval 'sub BUS_DMASYNC_PREWRITE () {0x04;}' unless defined(&BUS_DMASYNC_PREWRITE);
    eval 'sub BUS_DMASYNC_POSTWRITE () {0x08;}' unless defined(&BUS_DMASYNC_POSTWRITE);
    eval 'sub __HAVE_NEW_BUS_DMAMAP_SYNC () {1;}' unless defined(&__HAVE_NEW_BUS_DMAMAP_SYNC);
    eval 'sub bus_dmamap_create {
        local($t, $s, $n, $m, $b, $f, $p) = @_;
	    eval q((*($t)-> &_dmamap_create)(($t), ($s), ($n), ($m), ($b), ($f), ($p)));
    }' unless defined(&bus_dmamap_create);
    eval 'sub bus_dmamap_destroy {
        local($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_destroy)(($t), ($p)));
    }' unless defined(&bus_dmamap_destroy);
    eval 'sub bus_dmamap_load {
        local($t, $m, $b, $s, $p, $f) = @_;
	    eval q((*($t)-> &_dmamap_load)(($t), ($m), ($b), ($s), ($p), ($f)));
    }' unless defined(&bus_dmamap_load);
    eval 'sub bus_dmamap_load_mbuf {
        local($t, $m, $b, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_mbuf)(($t), ($m), ($b), ($f)));
    }' unless defined(&bus_dmamap_load_mbuf);
    eval 'sub bus_dmamap_load_uio {
        local($t, $m, $u, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_uio)(($t), ($m), ($u), ($f)));
    }' unless defined(&bus_dmamap_load_uio);
    eval 'sub bus_dmamap_load_raw {
        local($t, $m, $sg, $n, $s, $f) = @_;
	    eval q((*($t)-> &_dmamap_load_raw)(($t), ($m), ($sg), ($n), ($s), ($f)));
    }' unless defined(&bus_dmamap_load_raw);
    eval 'sub bus_dmamap_unload {
        local($t, $p) = @_;
	    eval q((*($t)-> &_dmamap_unload)(($t), ($p)));
    }' unless defined(&bus_dmamap_unload);
    eval 'sub bus_dmamap_sync {
        local($t, $p, $o, $l, $ops) = @_;
	    eval q((-> &_dmamap_sync ? (*-> &_dmamap_sync)(, , , , ) : 0));
    }' unless defined(&bus_dmamap_sync);
    eval 'sub bus_dmamem_alloc {
        local($t, $s, $a, $b, $sg, $n, $r, $f) = @_;
	    eval q((*($t)-> &_dmamem_alloc)(($t), ($s), ($a), ($b), ($sg), ($n), ($r), ($f)));
    }' unless defined(&bus_dmamem_alloc);
    eval 'sub bus_dmamem_free {
        local($t, $sg, $n) = @_;
	    eval q((*($t)-> &_dmamem_free)(($t), ($sg), ($n)));
    }' unless defined(&bus_dmamem_free);
    eval 'sub bus_dmamem_map {
        local($t, $sg, $n, $s, $k, $f) = @_;
	    eval q((*($t)-> &_dmamem_map)(($t), ($sg), ($n), ($s), ($k), ($f)));
    }' unless defined(&bus_dmamem_map);
    eval 'sub bus_dmamem_unmap {
        local($t, $k, $s) = @_;
	    eval q((*($t)-> &_dmamem_unmap)(($t), ($k), ($s)));
    }' unless defined(&bus_dmamem_unmap);
    eval 'sub bus_dmamem_mmap {
        local($t, $sg, $n, $o, $p, $f) = @_;
	    eval q((*($t)-> &_dmamem_mmap)(($t), ($sg), ($n), ($o), ($p), ($f)));
    }' unless defined(&bus_dmamem_mmap);
    eval 'sub _DM_TYPE_LOAD () {0;}' unless defined(&_DM_TYPE_LOAD);
    eval 'sub _DM_TYPE_SEGS () {1;}' unless defined(&_DM_TYPE_SEGS);
    eval 'sub _DM_TYPE_UIO () {2;}' unless defined(&_DM_TYPE_UIO);
    eval 'sub _DM_TYPE_MBUF () {3;}' unless defined(&_DM_TYPE_MBUF);
    if(defined(&_SPARC_BUS_DMA_PRIVATE)) {
    }
}
1;
