require '_h2ph_pre.ph';

unless(defined(&GX_LOCK)) {
    sub GX_LOCK {
	local($gx) = @_;
	eval q();
    }
}
unless(defined(&GX_UNLOCK)) {
    sub GX_UNLOCK {
	local($gx) = @_;
	eval q();
    }
}
unless(defined(&mtx_init)) {
    sub mtx_init {
	local($a, $b, $c) = @_;
	eval q();
    }
}
unless(defined(&mtx_destroy)) {
    sub mtx_destroy {
	local($a) = @_;
	eval q();
    }
}
unless(defined(&PCIM_CMD_MWIEN)) {
    eval 'sub PCIM_CMD_MWIEN () {0x0010;}' unless defined(&PCIM_CMD_MWIEN);
}
unless(defined(&ETHER_ALIGN)) {
    sub ETHER_ALIGN () {	2;}
}
unless(defined(&CSR_WRITE_8)) {
    sub CSR_WRITE_8 {
	local($gx, $reg, $val) = @_;
	eval q( &do {  &bus_space_write_4( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg, $val & 0xffffffff);  &bus_space_write_4( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg + 4, $val >> 32); }  &while (0));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($gx, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($gx, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($gx, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($gx, $reg) = @_;
	eval q( &bus_space_read_4( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($gx, $reg) = @_;
	eval q( &bus_space_read_2( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($gx, $reg) = @_;
	eval q( &bus_space_read_1( ($gx->{gx_btag}),  ($gx->{gx_bhandle}), $reg));
    }
}
unless(defined(&GX_SETBIT)) {
    sub GX_SETBIT {
	local($gx, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($gx, $reg, ( &CSR_READ_4($gx, $reg) | ($x))));
    }
}
unless(defined(&GX_CLRBIT)) {
    sub GX_CLRBIT {
	local($gx, $reg, $x) = @_;
	eval q( &CSR_WRITE_4($gx, $reg, ( &CSR_READ_4($gx, $reg) & ~($x))));
    }
}
unless(defined(&GX_TX_RING_CNT)) {
    sub GX_TX_RING_CNT () {	256;}
}
unless(defined(&GX_RX_RING_CNT)) {
    sub GX_RX_RING_CNT () {	256;}
}
unless(defined(&GX_INC)) {
    sub GX_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % $y);
    }
}
unless(defined(&GX_PREV)) {
    sub GX_PREV {
	local($x, $y) = @_;
	eval q(($x == 0? $y - 1: $x - 1));
    }
}
unless(defined(&GX_MAX_MTU)) {
    sub GX_MAX_MTU () {	(16* 1024);}
}
if(defined(&__alpha__)) {
    eval 'sub GX_NTXSEG () {30;}' unless defined(&GX_NTXSEG);
} else {
    eval 'sub GX_NTXSEG () {31;}' unless defined(&GX_NTXSEG);
}
unless(defined(&GX_NRXSEG)) {
    sub GX_NRXSEG () {	 &GX_NTXSEG;}
}
unless(defined(&GXF_FORCE_TBI)) {
    sub GXF_FORCE_TBI () {	0x0001;}
}
unless(defined(&GXF_DMA)) {
    sub GXF_DMA () {	0x0002;}
}
unless(defined(&GXF_ENABLE_MWI)) {
    sub GXF_ENABLE_MWI () {	0x0004;}
}
unless(defined(&GXF_OLD_REGS)) {
    sub GXF_OLD_REGS () {	0x0008;}
}
unless(defined(&GXF_CSUM)) {
    sub GXF_CSUM () {	0x0010;}
}
unless(defined(&GXF_WISEMAN)) {
    sub GXF_WISEMAN () {	0x0020;}
}
unless(defined(&GXF_LIVENGOOD)) {
    sub GXF_LIVENGOOD () {	0x0040;}
}
unless(defined(&GXF_CORDOVA)) {
    sub GXF_CORDOVA () {	0x0080;}
}
unless(defined(&GX_TXCONTEXT_NONE)) {
    sub GX_TXCONTEXT_NONE () {	0;}
}
unless(defined(&GX_TXCONTEXT_TCPIP)) {
    sub GX_TXCONTEXT_TCPIP () {	1;}
}
unless(defined(&GX_TXCONTEXT_UDPIP)) {
    sub GX_TXCONTEXT_UDPIP () {	2;}
}
1;
