require '_h2ph_pre.ph';

unless(defined(&PCIM_CMD_MWIEN)) {
    eval 'sub PCIM_CMD_MWIEN () {0x0010;}' unless defined(&PCIM_CMD_MWIEN);
}
unless(defined(&GX_CTRL)) {
    sub GX_CTRL () {	0x0000;}
}
unless(defined(&GX_STATUS)) {
    sub GX_STATUS () {	0x0008;}
}
unless(defined(&GX_EEPROM_CTRL)) {
    sub GX_EEPROM_CTRL () {	0x0010;}
}
unless(defined(&GX_CTRL_EXT)) {
    sub GX_CTRL_EXT () {	0x0018;}
}
unless(defined(&GX_MDIC)) {
    sub GX_MDIC () {	0x0020;}
}
unless(defined(&GX_FLOW_CTRL_BASE)) {
    sub GX_FLOW_CTRL_BASE () {	0x0028;}
}
unless(defined(&GX_FLOW_CTRL_TYPE)) {
    sub GX_FLOW_CTRL_TYPE () {	0x0030;}
}
unless(defined(&GX_VET)) {
    sub GX_VET () {	0x0038;}
}
unless(defined(&GX_RX_ADDR_BASE)) {
    sub GX_RX_ADDR_BASE () {	0x0040;}
}
unless(defined(&GX_INT_READ)) {
    sub GX_INT_READ () {	0x00c0;}
}
unless(defined(&GX_INT_FORCE)) {
    sub GX_INT_FORCE () {	0x00c8;}
}
unless(defined(&GX_INT_MASK_SET)) {
    sub GX_INT_MASK_SET () {	0x00d0;}
}
unless(defined(&GX_INT_MASK_CLR)) {
    sub GX_INT_MASK_CLR () {	0x00d8;}
}
unless(defined(&GX_RX_CONTROL)) {
    sub GX_RX_CONTROL () {	0x0100;}
}
unless(defined(&GX_RX_OLD_INTR_DELAY)) {
    sub GX_RX_OLD_INTR_DELAY () {	0x0108;}
}
unless(defined(&GX_RX_OLD_RING_BASE)) {
    sub GX_RX_OLD_RING_BASE () {	0x0110;}
}
unless(defined(&GX_RX_OLD_RING_LEN)) {
    sub GX_RX_OLD_RING_LEN () {	0x0118;}
}
unless(defined(&GX_RX_OLD_RING_HEAD)) {
    sub GX_RX_OLD_RING_HEAD () {	0x0120;}
}
unless(defined(&GX_RX_OLD_RING_TAIL)) {
    sub GX_RX_OLD_RING_TAIL () {	0x0128;}
}
unless(defined(&GX_OLD_FCRTH)) {
    sub GX_OLD_FCRTH () {	0x0160;}
}
unless(defined(&GX_OLD_FCRTL)) {
    sub GX_OLD_FCRTL () {	0x0168;}
}
unless(defined(&GX_FCTTV)) {
    sub GX_FCTTV () {	0x0170;}
}
unless(defined(&GX_TX_CONFIG)) {
    sub GX_TX_CONFIG () {	0x0178;}
}
unless(defined(&GX_RX_CONFIG)) {
    sub GX_RX_CONFIG () {	0x0180;}
}
unless(defined(&GX_MULTICAST_BASE)) {
    sub GX_MULTICAST_BASE () {	0x0200;}
}
unless(defined(&GX_TX_CONTROL)) {
    sub GX_TX_CONTROL () {	0x0400;}
}
unless(defined(&GX_TX_IPG)) {
    sub GX_TX_IPG () {	0x0410;}
}
unless(defined(&GX_TX_OLD_RING_BASE)) {
    sub GX_TX_OLD_RING_BASE () {	0x0420;}
}
unless(defined(&GX_TX_OLD_RING_LEN)) {
    sub GX_TX_OLD_RING_LEN () {	0x0428;}
}
unless(defined(&GX_TX_OLD_RING_HEAD)) {
    sub GX_TX_OLD_RING_HEAD () {	0x0430;}
}
unless(defined(&GX_TX_OLD_RING_TAIL)) {
    sub GX_TX_OLD_RING_TAIL () {	0x0438;}
}
unless(defined(&GX_TX_OLD_INTR_DELAY)) {
    sub GX_TX_OLD_INTR_DELAY () {	0x0440;}
}
unless(defined(&GX_TBT)) {
    sub GX_TBT () {	0x0448;}
}
unless(defined(&GX_AIT)) {
    sub GX_AIT () {	0x0458;}
}
unless(defined(&GX_VFTA_BASE)) {
    sub GX_VFTA_BASE () {	0x0600;}
}
unless(defined(&GX_PKT_BUFFER_ALLOC)) {
    sub GX_PKT_BUFFER_ALLOC () {	0x1000;}
}
unless(defined(&GX_ERT)) {
    sub GX_ERT () {	0x2000;}
}
unless(defined(&GX_RX_OLD_DMA_CTRL)) {
    sub GX_RX_OLD_DMA_CTRL () {	0x2028;}
}
unless(defined(&GX_FCRTH)) {
    sub GX_FCRTH () {	0x2160;}
}
unless(defined(&GX_FCRTL)) {
    sub GX_FCRTL () {	0x2168;}
}
unless(defined(&GX_RX_RING_BASE)) {
    sub GX_RX_RING_BASE () {	0x2800;}
}
unless(defined(&GX_RX_RING_LEN)) {
    sub GX_RX_RING_LEN () {	0x2808;}
}
unless(defined(&GX_RX_RING_HEAD)) {
    sub GX_RX_RING_HEAD () {	0x2810;}
}
unless(defined(&GX_RX_RING_TAIL)) {
    sub GX_RX_RING_TAIL () {	0x2818;}
}
unless(defined(&GX_RX_INTR_DELAY)) {
    sub GX_RX_INTR_DELAY () {	0x2820;}
}
unless(defined(&GX_RX_DMA_CTRL)) {
    sub GX_RX_DMA_CTRL () {	0x2828;}
}
unless(defined(&GX_EARLY_TX_THRESH)) {
    sub GX_EARLY_TX_THRESH () {	0x3000;}
}
unless(defined(&GX_TX_OLD_DMA_CTRL)) {
    sub GX_TX_OLD_DMA_CTRL () {	0x3028;}
}
unless(defined(&GX_TX_RING_BASE)) {
    sub GX_TX_RING_BASE () {	0x3800;}
}
unless(defined(&GX_TX_RING_LEN)) {
    sub GX_TX_RING_LEN () {	0x3808;}
}
unless(defined(&GX_TX_RING_HEAD)) {
    sub GX_TX_RING_HEAD () {	0x3810;}
}
unless(defined(&GX_TX_RING_TAIL)) {
    sub GX_TX_RING_TAIL () {	0x3818;}
}
unless(defined(&GX_TX_INTR_DELAY)) {
    sub GX_TX_INTR_DELAY () {	0x3820;}
}
unless(defined(&GX_TX_DMA_CTRL)) {
    sub GX_TX_DMA_CTRL () {	0x3828;}
}
unless(defined(&GX_CRCERRS)) {
    sub GX_CRCERRS () {	0x4000;}
}
unless(defined(&GX_ALGNERRC)) {
    sub GX_ALGNERRC () {	0x4004;}
}
unless(defined(&GX_SYMERRS)) {
    sub GX_SYMERRS () {	0x4008;}
}
unless(defined(&GX_RXERRC)) {
    sub GX_RXERRC () {	0x400c;}
}
unless(defined(&GX_MPC)) {
    sub GX_MPC () {	0x4010;}
}
unless(defined(&GX_SCC)) {
    sub GX_SCC () {	0x4014;}
}
unless(defined(&GX_ECOL)) {
    sub GX_ECOL () {	0x4018;}
}
unless(defined(&GX_MCC)) {
    sub GX_MCC () {	0x401c;}
}
unless(defined(&GX_LATECOL)) {
    sub GX_LATECOL () {	0x4020;}
}
unless(defined(&GX_COLC)) {
    sub GX_COLC () {	0x4020;}
}
unless(defined(&GX_TUC)) {
    sub GX_TUC () {	0x402c;}
}
unless(defined(&GX_DC)) {
    sub GX_DC () {	0x4030;}
}
unless(defined(&GX_TNCRS)) {
    sub GX_TNCRS () {	0x4034;}
}
unless(defined(&GX_SEC)) {
    sub GX_SEC () {	0x4038;}
}
unless(defined(&GX_CEXTERR)) {
    sub GX_CEXTERR () {	0x403c;}
}
unless(defined(&GX_RLEC)) {
    sub GX_RLEC () {	0x4040;}
}
unless(defined(&GX_RDMAUC)) {
    sub GX_RDMAUC () {	0x4044;}
}
unless(defined(&GX_XONRXC)) {
    sub GX_XONRXC () {	0x4048;}
}
unless(defined(&GX_XONTXC)) {
    sub GX_XONTXC () {	0x404c;}
}
unless(defined(&GX_XOFFRXC)) {
    sub GX_XOFFRXC () {	0x4050;}
}
unless(defined(&GX_XOFFTXC)) {
    sub GX_XOFFTXC () {	0x4054;}
}
unless(defined(&GX_FCRUC)) {
    sub GX_FCRUC () {	0x4058;}
}
unless(defined(&GX_PRC64)) {
    sub GX_PRC64 () {	0x405c;}
}
unless(defined(&GX_PRC127)) {
    sub GX_PRC127 () {	0x4060;}
}
unless(defined(&GX_PRC255)) {
    sub GX_PRC255 () {	0x4064;}
}
unless(defined(&GX_PRC511)) {
    sub GX_PRC511 () {	0x4068;}
}
unless(defined(&GX_PRC1023)) {
    sub GX_PRC1023 () {	0x406c;}
}
unless(defined(&GX_PRC1522)) {
    sub GX_PRC1522 () {	0x4070;}
}
unless(defined(&GX_GPRC)) {
    sub GX_GPRC () {	0x4074;}
}
unless(defined(&GX_BPRC)) {
    sub GX_BPRC () {	0x4078;}
}
unless(defined(&GX_MPRC)) {
    sub GX_MPRC () {	0x407c;}
}
unless(defined(&GX_GPTC)) {
    sub GX_GPTC () {	0x4080;}
}
unless(defined(&GX_GORC)) {
    sub GX_GORC () {	0x4088;}
}
unless(defined(&GX_GOTC)) {
    sub GX_GOTC () {	0x4090;}
}
unless(defined(&GX_RNBC)) {
    sub GX_RNBC () {	0x40a0;}
}
unless(defined(&GX_RUC)) {
    sub GX_RUC () {	0x40a4;}
}
unless(defined(&GX_RFC)) {
    sub GX_RFC () {	0x40a8;}
}
unless(defined(&GX_ROC)) {
    sub GX_ROC () {	0x40ac;}
}
unless(defined(&GX_RJC)) {
    sub GX_RJC () {	0x40b0;}
}
unless(defined(&GX_TOR)) {
    sub GX_TOR () {	0x40c0;}
}
unless(defined(&GX_TOT)) {
    sub GX_TOT () {	0x40c8;}
}
unless(defined(&GX_TPR)) {
    sub GX_TPR () {	0x40d0;}
}
unless(defined(&GX_TPT)) {
    sub GX_TPT () {	0x40d4;}
}
unless(defined(&GX_PTC64)) {
    sub GX_PTC64 () {	0x40d8;}
}
unless(defined(&GX_PTC127)) {
    sub GX_PTC127 () {	0x40dc;}
}
unless(defined(&GX_PTC255)) {
    sub GX_PTC255 () {	0x40e0;}
}
unless(defined(&GX_PTC511)) {
    sub GX_PTC511 () {	0x40e4;}
}
unless(defined(&GX_PTC1023)) {
    sub GX_PTC1023 () {	0x40e8;}
}
unless(defined(&GX_PTC1522)) {
    sub GX_PTC1522 () {	0x40ec;}
}
unless(defined(&GX_MPTC)) {
    sub GX_MPTC () {	0x40f0;}
}
unless(defined(&GX_BPTC)) {
    sub GX_BPTC () {	0x40f4;}
}
unless(defined(&GX_TSCTC)) {
    sub GX_TSCTC () {	0x40f8;}
}
unless(defined(&GX_TSCTFC)) {
    sub GX_TSCTFC () {	0x40fc;}
}
unless(defined(&GX_RX_CSUM_CONTROL)) {
    sub GX_RX_CSUM_CONTROL () {	0x5000;}
}
unless(defined(&GX_CORDOVA_MULTICAST_BASE)) {
    sub GX_CORDOVA_MULTICAST_BASE () {	0x5200;}
}
unless(defined(&GX_RX_CORDOVA_ADDR_BASE)) {
    sub GX_RX_CORDOVA_ADDR_BASE () {	0x5400;}
}
unless(defined(&GX_RDFH)) {
    sub GX_RDFH () {	0x8000;}
}
unless(defined(&GX_RDFT)) {
    sub GX_RDFT () {	0x8008;}
}
unless(defined(&GX_TDFH)) {
    sub GX_TDFH () {	0x8010;}
}
unless(defined(&GX_TDFT)) {
    sub GX_TDFT () {	0x8018;}
}
unless(defined(&GX_RBM_BASE)) {
    sub GX_RBM_BASE () {	0x10000;}
}
unless(defined(&GX_CSUM_START_MASK)) {
    sub GX_CSUM_START_MASK () {	0x000ff;}
}
unless(defined(&GX_CSUM_IP)) {
    sub GX_CSUM_IP () {	0x00100;}
}
unless(defined(&GX_CSUM_TCP)) {
    sub GX_CSUM_TCP () {	0x00200;}
}
unless(defined(&GX_CTRL_DUPLEX)) {
    sub GX_CTRL_DUPLEX () {	0x00000001;}
}
unless(defined(&GX_CTRL_BIGENDIAN)) {
    sub GX_CTRL_BIGENDIAN () {	0x00000002;}
}
unless(defined(&GX_CTRL_PCI_PRIORITY)) {
    sub GX_CTRL_PCI_PRIORITY () {	0x00000004;}
}
unless(defined(&GX_CTRL_LINK_RESET)) {
    sub GX_CTRL_LINK_RESET () {	0x00000008;}
}
unless(defined(&GX_CTRL_TEST_MODE)) {
    sub GX_CTRL_TEST_MODE () {	0x00000010;}
}
unless(defined(&GX_CTRL_AUTOSPEED)) {
    sub GX_CTRL_AUTOSPEED () {	0x00000020;}
}
unless(defined(&GX_CTRL_SET_LINK_UP)) {
    sub GX_CTRL_SET_LINK_UP () {	0x00000040;}
}
unless(defined(&GX_CTRL_INVERT_LOS)) {
    sub GX_CTRL_INVERT_LOS () {	0x00000080;}
}
unless(defined(&GX_CTRL_SPEEDMASK)) {
    sub GX_CTRL_SPEEDMASK () {	0x00000300;}
}
unless(defined(&GX_CTRL_FORCESPEED)) {
    sub GX_CTRL_FORCESPEED () {	0x00000800;}
}
unless(defined(&GX_CTRL_FORCEDUPLEX)) {
    sub GX_CTRL_FORCEDUPLEX () {	0x00001000;}
}
unless(defined(&GX_CTRL_GPIO_0)) {
    sub GX_CTRL_GPIO_0 () {	0x00040000;}
}
unless(defined(&GX_CTRL_GPIO_1)) {
    sub GX_CTRL_GPIO_1 () {	0x00080000;}
}
unless(defined(&GX_CTRL_GPIO_2)) {
    sub GX_CTRL_GPIO_2 () {	0x00100000;}
}
unless(defined(&GX_CTRL_GPIO_3)) {
    sub GX_CTRL_GPIO_3 () {	0x00200000;}
}
unless(defined(&GX_CTRL_GPIO_DIR_0)) {
    sub GX_CTRL_GPIO_DIR_0 () {	0x00400000;}
}
unless(defined(&GX_CTRL_GPIO_DIR_1)) {
    sub GX_CTRL_GPIO_DIR_1 () {	0x00800000;}
}
unless(defined(&GX_CTRL_GPIO_DIR_2)) {
    sub GX_CTRL_GPIO_DIR_2 () {	0x01000000;}
}
unless(defined(&GX_CTRL_GPIO_DIR_3)) {
    sub GX_CTRL_GPIO_DIR_3 () {	0x02000000;}
}
unless(defined(&GX_CTRL_DEVICE_RESET)) {
    sub GX_CTRL_DEVICE_RESET () {	0x04000000;}
}
unless(defined(&GX_CTRL_RX_FLOWCTRL)) {
    sub GX_CTRL_RX_FLOWCTRL () {	0x08000000;}
}
unless(defined(&GX_CTRL_TX_FLOWCTRL)) {
    sub GX_CTRL_TX_FLOWCTRL () {	0x10000000;}
}
unless(defined(&GX_CTRL_VLAN_ENABLE)) {
    sub GX_CTRL_VLAN_ENABLE () {	0x40000000;}
}
unless(defined(&GX_CTRL_PHY_RESET)) {
    sub GX_CTRL_PHY_RESET () {	0x80000000;}
}
unless(defined(&GX_STAT_DUPLEX)) {
    sub GX_STAT_DUPLEX () {	0x00000001;}
}
unless(defined(&GX_STAT_LINKUP)) {
    sub GX_STAT_LINKUP () {	0x00000002;}
}
unless(defined(&GX_STAT_XMITCLK_OK)) {
    sub GX_STAT_XMITCLK_OK () {	0x00000004;}
}
unless(defined(&GX_STAT_RECVCLK_OK)) {
    sub GX_STAT_RECVCLK_OK () {	0x00000008;}
}
unless(defined(&GX_STAT_XMIT_OFF)) {
    sub GX_STAT_XMIT_OFF () {	0x00000010;}
}
unless(defined(&GX_STAT_TBIMODE)) {
    sub GX_STAT_TBIMODE () {	0x00000020;}
}
unless(defined(&GX_STAT_SPEED_MASK)) {
    sub GX_STAT_SPEED_MASK () {	0x000000c0;}
}
unless(defined(&GX_STAT_AUTOSPEED_MASK)) {
    sub GX_STAT_AUTOSPEED_MASK () {	0x00000300;}
}
unless(defined(&GX_STAT_MTXCLK_OK)) {
    sub GX_STAT_MTXCLK_OK () {	0x00000400;}
}
unless(defined(&GX_STAT_PCI66)) {
    sub GX_STAT_PCI66 () {	0x00000800;}
}
unless(defined(&GX_STAT_BUS64)) {
    sub GX_STAT_BUS64 () {	0x00001000;}
}
unless(defined(&GX_SPEED_10MB)) {
    sub GX_SPEED_10MB () {	0x00000000;}
}
unless(defined(&GX_SPEED_100MB)) {
    sub GX_SPEED_100MB () {	0x00000040;}
}
unless(defined(&GX_SPEED_1000MB)) {
    sub GX_SPEED_1000MB () {	0x00000080;}
}
unless(defined(&GX_EE_CLOCK)) {
    sub GX_EE_CLOCK () {	0x0001;}
}
unless(defined(&GX_EE_SELECT)) {
    sub GX_EE_SELECT () {	0x0002;}
}
unless(defined(&GX_EE_DATA_IN)) {
    sub GX_EE_DATA_IN () {	0x0004;}
}
unless(defined(&GX_EE_DATA_OUT)) {
    sub GX_EE_DATA_OUT () {	0x0008;}
}
unless(defined(&GX_EE_FLASH_CTRL)) {
    sub GX_EE_FLASH_CTRL () {	0x0030;}
}
unless(defined(&GX_MDIC_OP_WRITE)) {
    sub GX_MDIC_OP_WRITE () {	0x04000000;}
}
unless(defined(&GX_MDIC_OP_READ)) {
    sub GX_MDIC_OP_READ () {	0x08000000;}
}
unless(defined(&GX_MDIC_READY)) {
    sub GX_MDIC_READY () {	0x10000000;}
}
unless(defined(&GX_MDIC_I)) {
    sub GX_MDIC_I () {	0x20000000;}
}
unless(defined(&GX_MDIC_E)) {
    sub GX_MDIC_E () {	0x40000000;}
}
unless(defined(&GX_MDIC_DATA)) {
    sub GX_MDIC_DATA {
	local($x) = @_;
	eval q((($x) & 0xffff));
    }
}
unless(defined(&GX_MDIC_REGADD)) {
    sub GX_MDIC_REGADD {
	local($x) = @_;
	eval q((($x) << 16));
    }
}
unless(defined(&GX_MDIC_PHYADD)) {
    sub GX_MDIC_PHYADD {
	local($x) = @_;
	eval q((($x) << 21));
    }
}
unless(defined(&GX_FLOW_CTRL_CONST)) {
    sub GX_FLOW_CTRL_CONST () {	0x00c28001;}
}
unless(defined(&GX_FLOW_CTRL_CONST_HIGH)) {
    sub GX_FLOW_CTRL_CONST_HIGH () {	0x00000100;}
}
unless(defined(&GX_FLOW_CTRL_TYPE_CONST)) {
    sub GX_FLOW_CTRL_TYPE_CONST () {	0x8808;}
}
unless(defined(&GX_EE_OPC_WRITE)) {
    sub GX_EE_OPC_WRITE () {	0x5;}
}
unless(defined(&GX_EE_OPC_READ)) {
    sub GX_EE_OPC_READ () {	0x6;}
}
unless(defined(&GX_EE_OPC_ERASE)) {
    sub GX_EE_OPC_ERASE () {	0x7;}
}
unless(defined(&GX_EE_OPC_SIZE)) {
    sub GX_EE_OPC_SIZE () {	3;}
}
unless(defined(&GX_EE_ADDR_SIZE)) {
    sub GX_EE_ADDR_SIZE () {	6;}
}
unless(defined(&GX_EEMAP_MAC)) {
    sub GX_EEMAP_MAC () {	0x00;}
}
unless(defined(&GX_EEMAP_INIT1)) {
    sub GX_EEMAP_INIT1 () {	0x0a;}
}
unless(defined(&GX_EEMAP_INIT2)) {
    sub GX_EEMAP_INIT2 () {	0x0f;}
}
unless(defined(&GX_EEMAP_SWDPIN)) {
    sub GX_EEMAP_SWDPIN () {	0x20;}
}
unless(defined(&GX_EEMAP_INIT1_LVDID)) {
    sub GX_EEMAP_INIT1_LVDID () {	0x0001;}
}
unless(defined(&GX_EEMAP_INIT1_LSSID)) {
    sub GX_EEMAP_INIT1_LSSID () {	0x0002;}
}
unless(defined(&GX_EEMAP_INIT1_PME_CLOCK)) {
    sub GX_EEMAP_INIT1_PME_CLOCK () {	0x0004;}
}
unless(defined(&GX_EEMAP_INIT1_PM)) {
    sub GX_EEMAP_INIT1_PM () {	0x0008;}
}
unless(defined(&GX_EEMAP_INIT1_ILOS)) {
    sub GX_EEMAP_INIT1_ILOS () {	0x0010;}
}
unless(defined(&GX_EEMAP_INIT1_SWDPIO_SHIFT)) {
    sub GX_EEMAP_INIT1_SWDPIO_SHIFT () {	5;}
}
unless(defined(&GX_EEMAP_INIT1_SWDPIO_MASK)) {
    sub GX_EEMAP_INIT1_SWDPIO_MASK () {	(0xf <<  &GX_EEMAP_INIT1_SWDPIO_SHIFT);}
}
unless(defined(&GX_EEMAP_INIT1_IPS1)) {
    sub GX_EEMAP_INIT1_IPS1 () {	0x0100;}
}
unless(defined(&GX_EEMAP_INIT1_LRST)) {
    sub GX_EEMAP_INIT1_LRST () {	0x0200;}
}
unless(defined(&GX_EEMAP_INIT1_FD)) {
    sub GX_EEMAP_INIT1_FD () {	0x0400;}
}
unless(defined(&GX_EEMAP_INIT1_FRCSPD)) {
    sub GX_EEMAP_INIT1_FRCSPD () {	0x0800;}
}
unless(defined(&GX_EEMAP_INIT1_IPS0)) {
    sub GX_EEMAP_INIT1_IPS0 () {	0x1000;}
}
unless(defined(&GX_EEMAP_INIT1_64_32_BAR)) {
    sub GX_EEMAP_INIT1_64_32_BAR () {	0x2000;}
}
unless(defined(&GX_EEMAP_INIT2_CSR_RD_SPLIT)) {
    sub GX_EEMAP_INIT2_CSR_RD_SPLIT () {	0x0002;}
}
unless(defined(&GX_EEMAP_INIT2_APM_EN)) {
    sub GX_EEMAP_INIT2_APM_EN () {	0x0004;}
}
unless(defined(&GX_EEMAP_INIT2_64_BIT)) {
    sub GX_EEMAP_INIT2_64_BIT () {	0x0008;}
}
unless(defined(&GX_EEMAP_INIT2_MAX_READ)) {
    sub GX_EEMAP_INIT2_MAX_READ () {	0x0010;}
}
unless(defined(&GX_EEMAP_INIT2_DMCR_MAP)) {
    sub GX_EEMAP_INIT2_DMCR_MAP () {	0x0020;}
}
unless(defined(&GX_EEMAP_INIT2_133_CAP)) {
    sub GX_EEMAP_INIT2_133_CAP () {	0x0040;}
}
unless(defined(&GX_EEMAP_INIT2_MSI_DIS)) {
    sub GX_EEMAP_INIT2_MSI_DIS () {	0x0080;}
}
unless(defined(&GX_EEMAP_INIT2_FLASH_DIS)) {
    sub GX_EEMAP_INIT2_FLASH_DIS () {	0x0100;}
}
unless(defined(&GX_EEMAP_INIT2_FLASH_SIZE)) {
    sub GX_EEMAP_INIT2_FLASH_SIZE {
	local($x) = @_;
	eval q(((($x) & 3) >> 9));
    }
}
unless(defined(&GX_EEMAP_INIT2_ANE)) {
    sub GX_EEMAP_INIT2_ANE () {	0x0800;}
}
unless(defined(&GX_EEMAP_INIT2_PAUSE)) {
    sub GX_EEMAP_INIT2_PAUSE {
	local($x) = @_;
	eval q(((($x) & 3) >> 12));
    }
}
unless(defined(&GX_EEMAP_INIT2_ASDE)) {
    sub GX_EEMAP_INIT2_ASDE () {	0x4000;}
}
unless(defined(&GX_EEMAP_INIT2_APM_PME)) {
    sub GX_EEMAP_INIT2_APM_PME () {	0x8000;}
}
unless(defined(&GX_EEMAP_INIT2_SWDPIO_SHIFT)) {
    sub GX_EEMAP_INIT2_SWDPIO_SHIFT () {	4;}
}
unless(defined(&GX_EEMAP_INIT2_SWDPIO_MASK)) {
    sub GX_EEMAP_INIT2_SWDPIO_MASK () {	(0xf <<  &GX_EEMAP_INIT2_SWDPIO_SHIFT);}
}
unless(defined(&GX_EEMAP_GPIO_MASK)) {
    sub GX_EEMAP_GPIO_MASK () {	0xdf;}
}
unless(defined(&GX_EEMAP_GPIO_SHIFT)) {
    sub GX_EEMAP_GPIO_SHIFT () {	0;}
}
unless(defined(&GX_EEMAP_GPIO_DIR_SHIFT)) {
    sub GX_EEMAP_GPIO_DIR_SHIFT () {	8;}
}
unless(defined(&GX_CTRLX_GPIO_4)) {
    sub GX_CTRLX_GPIO_4 () {	0x00000010;}
}
unless(defined(&GX_CTRLX_GPIO_5)) {
    sub GX_CTRLX_GPIO_5 () {	0x00000020;}
}
unless(defined(&GX_CTRLX_GPIO_6)) {
    sub GX_CTRLX_GPIO_6 () {	0x00000040;}
}
unless(defined(&GX_CTRLX_GPIO_7)) {
    sub GX_CTRLX_GPIO_7 () {	0x00000080;}
}
unless(defined(&GX_CTRLX_GPIO_DIR_4)) {
    sub GX_CTRLX_GPIO_DIR_4 () {	0x00000100;}
}
unless(defined(&GX_CTRLX_GPIO_DIR_5)) {
    sub GX_CTRLX_GPIO_DIR_5 () {	0x00000200;}
}
unless(defined(&GX_CTRLX_GPIO_DIR_6)) {
    sub GX_CTRLX_GPIO_DIR_6 () {	0x00000400;}
}
unless(defined(&GX_CTRLX_GPIO_DIR_7)) {
    sub GX_CTRLX_GPIO_DIR_7 () {	0x00000800;}
}
unless(defined(&GX_CTRLX_EEPROM_RESET)) {
    sub GX_CTRLX_EEPROM_RESET () {	0x00002000;}
}
unless(defined(&GX_CTRLX_SPEED_BYPASS)) {
    sub GX_CTRLX_SPEED_BYPASS () {	0x00008000;}
}
unless(defined(&GX_CTRL_GPIO_DIR_SHIFT)) {
    sub GX_CTRL_GPIO_DIR_SHIFT () {	22;}
}
unless(defined(&GX_CTRL_GPIO_SHIFT)) {
    sub GX_CTRL_GPIO_SHIFT () {	18;}
}
unless(defined(&GX_CTRL_GPIO_DIR)) {
    sub GX_CTRL_GPIO_DIR () {	( &GX_CTRL_GPIO_DIR_3);}
}
unless(defined(&GX_CTRL_GPIO_DIR_MASK)) {
    sub GX_CTRL_GPIO_DIR_MASK () {	( &GX_CTRL_GPIO_DIR_0 |  &GX_CTRL_GPIO_DIR_1 |  &GX_CTRL_GPIO_DIR_2 |  &GX_CTRL_GPIO_DIR_3);}
}
unless(defined(&GX_CTRL_PHY_IO)) {
    sub GX_CTRL_PHY_IO () {	 &GX_CTRL_GPIO_2;}
}
unless(defined(&GX_CTRL_PHY_IO_DIR)) {
    sub GX_CTRL_PHY_IO_DIR () {	 &GX_CTRL_GPIO_DIR_2;}
}
unless(defined(&GX_CTRL_PHY_CLK)) {
    sub GX_CTRL_PHY_CLK () {	 &GX_CTRL_GPIO_3;}
}
unless(defined(&GX_CTRLX_GPIO_DIR)) {
    sub GX_CTRLX_GPIO_DIR () {	( &GX_CTRLX_GPIO_DIR_4);}
}
unless(defined(&GX_CTRLX_GPIO_DIR_MASK)) {
    sub GX_CTRLX_GPIO_DIR_MASK () {	( &GX_CTRLX_GPIO_DIR_4 |  &GX_CTRLX_GPIO_DIR_5 |  &GX_CTRLX_GPIO_DIR_6 |  &GX_CTRLX_GPIO_DIR_7);}
}
unless(defined(&GX_CTRLX_PHY_RESET)) {
    sub GX_CTRLX_PHY_RESET () {	 &GX_CTRLX_GPIO_4;}
}
unless(defined(&GX_PHY_PREAMBLE)) {
    sub GX_PHY_PREAMBLE () {	0xffffffff;}
}
unless(defined(&GX_PHY_PREAMBLE_LEN)) {
    sub GX_PHY_PREAMBLE_LEN () {	32;}
}
unless(defined(&GX_PHY_SOF)) {
    sub GX_PHY_SOF () {	0x01;}
}
unless(defined(&GX_PHY_TURNAROUND)) {
    sub GX_PHY_TURNAROUND () {	0x02;}
}
unless(defined(&GX_PHY_OP_WRITE)) {
    sub GX_PHY_OP_WRITE () {	0x01;}
}
unless(defined(&GX_PHY_OP_READ)) {
    sub GX_PHY_OP_READ () {	0x02;}
}
unless(defined(&GX_PHY_READ_LEN)) {
    sub GX_PHY_READ_LEN () {	14;}
}
unless(defined(&GX_PHY_WRITE_LEN)) {
    sub GX_PHY_WRITE_LEN () {	32;}
}
unless(defined(&GX_RA_VALID)) {
    sub GX_RA_VALID () {	0x80000000;}
}
unless(defined(&GX_TXCFG_AUTONEG)) {
    sub GX_TXCFG_AUTONEG () {	0x80000000;}
}
unless(defined(&GX_TXCFG_SWCONFIG)) {
    sub GX_TXCFG_SWCONFIG () {	0x80000000;}
}
unless(defined(&GX_RXCFG_INVALID)) {
    sub GX_RXCFG_INVALID () {	0x08000000;}
}
unless(defined(&GX_RXC_RESET)) {
    sub GX_RXC_RESET () {	0x00000001;}
}
unless(defined(&GX_RXC_ENABLE)) {
    sub GX_RXC_ENABLE () {	0x00000002;}
}
unless(defined(&GX_RXC_STORE_BAD_PKT)) {
    sub GX_RXC_STORE_BAD_PKT () {	0x00000004;}
}
unless(defined(&GX_RXC_UNI_PROMISC)) {
    sub GX_RXC_UNI_PROMISC () {	0x00000008;}
}
unless(defined(&GX_RXC_MULTI_PROMISC)) {
    sub GX_RXC_MULTI_PROMISC () {	0x00000010;}
}
unless(defined(&GX_RXC_LONG_PKT_ENABLE)) {
    sub GX_RXC_LONG_PKT_ENABLE () {	0x00000020;}
}
unless(defined(&GX_RXC_LOOPBACK)) {
    sub GX_RXC_LOOPBACK () {	0x000000c0;}
}
unless(defined(&GX_RXC_RX_THOLD_MASK)) {
    sub GX_RXC_RX_THOLD_MASK () {	0x00000300;}
}
unless(defined(&GX_RXC_MCAST_OFF_MASK)) {
    sub GX_RXC_MCAST_OFF_MASK () {	0x00003000;}
}
unless(defined(&GX_RXC_BCAST_ACCEPT)) {
    sub GX_RXC_BCAST_ACCEPT () {	0x00008000;}
}
unless(defined(&GX_RXC_RX_BSIZE_MASK)) {
    sub GX_RXC_RX_BSIZE_MASK () {	0x00030000;}
}
unless(defined(&GX_RXC_VLAN_ENABLE)) {
    sub GX_RXC_VLAN_ENABLE () {	0x00040000;}
}
unless(defined(&GX_RXC_CFI_ENABLE)) {
    sub GX_RXC_CFI_ENABLE () {	0x00080000;}
}
unless(defined(&GX_RXC_CFI)) {
    sub GX_RXC_CFI () {	0x00100000;}
}
unless(defined(&GX_RXC_DISCARD_PAUSE)) {
    sub GX_RXC_DISCARD_PAUSE () {	0x00400000;}
}
unless(defined(&GX_RXC_PASS_MAC)) {
    sub GX_RXC_PASS_MAC () {	0x00800000;}
}
unless(defined(&GX_RXC_RX_BSIZE_SCALE)) {
    sub GX_RXC_RX_BSIZE_SCALE () {	0x02000000;}
}
unless(defined(&GX_RXC_STRIP_ETHERCRC)) {
    sub GX_RXC_STRIP_ETHERCRC () {	0x04000000;}
}
unless(defined(&GX_RXC_RX_THOLD_HALF)) {
    sub GX_RXC_RX_THOLD_HALF () {	0x00000000;}
}
unless(defined(&GX_RXC_RX_THOLD_QUARTER)) {
    sub GX_RXC_RX_THOLD_QUARTER () {	0x00000100;}
}
unless(defined(&GX_RXC_RX_THOLD_EIGHTH)) {
    sub GX_RXC_RX_THOLD_EIGHTH () {	0x00000200;}
}
unless(defined(&GX_RXC_RX_BSIZE_2K)) {
    sub GX_RXC_RX_BSIZE_2K () {	0x00000000;}
}
unless(defined(&GX_RXC_RX_BSIZE_1K)) {
    sub GX_RXC_RX_BSIZE_1K () {	0x00010000;}
}
unless(defined(&GX_RXC_RX_BSIZE_512)) {
    sub GX_RXC_RX_BSIZE_512 () {	0x00020000;}
}
unless(defined(&GX_RXC_RX_BSIZE_256)) {
    sub GX_RXC_RX_BSIZE_256 () {	0x00030000;}
}
unless(defined(&GX_TXC_RESET)) {
    sub GX_TXC_RESET () {	0x00000001;}
}
unless(defined(&GX_TXC_ENABLE)) {
    sub GX_TXC_ENABLE () {	0x00000002;}
}
unless(defined(&GX_TXC_PAD_SHORT_PKTS)) {
    sub GX_TXC_PAD_SHORT_PKTS () {	0x00000008;}
}
unless(defined(&GX_TXC_COLL_RETRY_MASK)) {
    sub GX_TXC_COLL_RETRY_MASK () {	0x00000ff0;}
}
unless(defined(&GX_TXC_COLL_TIME_MASK)) {
    sub GX_TXC_COLL_TIME_MASK () {	0x003ff000;}
}
unless(defined(&GX_TXC_XMIT_XOFF)) {
    sub GX_TXC_XMIT_XOFF () {	0x00400000;}
}
unless(defined(&GX_TXC_PKT_BURST_ENABLE)) {
    sub GX_TXC_PKT_BURST_ENABLE () {	0x00800000;}
}
unless(defined(&GX_TXC_REXMT_LATE_COLL)) {
    sub GX_TXC_REXMT_LATE_COLL () {	0x01000000;}
}
unless(defined(&GX_TXC_NO_REXMT_UNDERRN)) {
    sub GX_TXC_NO_REXMT_UNDERRN () {	0x02000000;}
}
unless(defined(&GX_TXC_COLL_RETRY_16)) {
    sub GX_TXC_COLL_RETRY_16 () {	0x000000f0;}
}
unless(defined(&GX_TXC_COLL_TIME_HDX)) {
    sub GX_TXC_COLL_TIME_HDX () {	0x00200000;}
}
unless(defined(&GX_TXC_COLL_TIME_FDX)) {
    sub GX_TXC_COLL_TIME_FDX () {	0x00040000;}
}
unless(defined(&GX_INT_XMIT_DONE)) {
    sub GX_INT_XMIT_DONE () {	0x00000001;}
}
unless(defined(&GX_INT_XMIT_EMPTY)) {
    sub GX_INT_XMIT_EMPTY () {	0x00000002;}
}
unless(defined(&GX_INT_LINK_CHANGE)) {
    sub GX_INT_LINK_CHANGE () {	0x00000004;}
}
unless(defined(&GX_INT_RCV_SEQ_ERR)) {
    sub GX_INT_RCV_SEQ_ERR () {	0x00000008;}
}
unless(defined(&GX_INT_RCV_THOLD)) {
    sub GX_INT_RCV_THOLD () {	0x00000010;}
}
unless(defined(&GX_INT_RCV_OVERRUN)) {
    sub GX_INT_RCV_OVERRUN () {	0x00000040;}
}
unless(defined(&GX_INT_RCV_TIMER)) {
    sub GX_INT_RCV_TIMER () {	0x00000080;}
}
unless(defined(&GX_INT_MDIO_DONE)) {
    sub GX_INT_MDIO_DONE () {	0x00000200;}
}
unless(defined(&GX_INT_C_SETS)) {
    sub GX_INT_C_SETS () {	0x00000400;}
}
unless(defined(&GX_INT_GPI_MASK)) {
    sub GX_INT_GPI_MASK () {	0x00007800;}
}
unless(defined(&GX_INT_ALL)) {
    sub GX_INT_ALL () {	( &GX_INT_XMIT_DONE |  &GX_INT_XMIT_EMPTY |  &GX_INT_LINK_CHANGE |  &GX_INT_RCV_SEQ_ERR |  &GX_INT_RCV_THOLD |  &GX_INT_RCV_OVERRUN |  &GX_INT_RCV_TIMER |  &GX_INT_MDIO_DONE |  &GX_INT_C_SETS |  &GX_INT_GPI_MASK);}
}
if(0) {
    eval 'sub GX_INT_WANTED () {( &GX_INT_XMIT_DONE |  &GX_INT_LINK_CHANGE |  &GX_INT_RCV_SEQ_ERR |  &GX_INT_RCV_THOLD |  &GX_INT_RCV_OVERRUN |  &GX_INT_RCV_TIMER |  &GX_INT_C_SETS);}' unless defined(&GX_INT_WANTED);
} else {
    eval 'sub GX_INT_WANTED () {( &GX_INT_XMIT_DONE |  &GX_INT_RCV_THOLD |  &GX_INT_RCV_TIMER |  &GX_INT_LINK_CHANGE);}' unless defined(&GX_INT_WANTED);
}
unless(defined(&GX_PCI_VENDOR_ID)) {
    sub GX_PCI_VENDOR_ID () {	0x0000;}
}
unless(defined(&GX_PCI_DEVICE_ID)) {
    sub GX_PCI_DEVICE_ID () {	0x0002;}
}
unless(defined(&GX_PCI_COMMAND)) {
    sub GX_PCI_COMMAND () {	0x0004;}
}
unless(defined(&GX_PCI_STATUS)) {
    sub GX_PCI_STATUS () {	0x0006;}
}
unless(defined(&GX_PCI_REVID)) {
    sub GX_PCI_REVID () {	0x0008;}
}
unless(defined(&GX_PCI_CLASSCODE)) {
    sub GX_PCI_CLASSCODE () {	0x0009;}
}
unless(defined(&GX_PCI_CACHELEN)) {
    sub GX_PCI_CACHELEN () {	0x000c;}
}
unless(defined(&GX_PCI_LATENCY_TIMER)) {
    sub GX_PCI_LATENCY_TIMER () {	0x000d;}
}
unless(defined(&GX_PCI_HEADER_TYPE)) {
    sub GX_PCI_HEADER_TYPE () {	0x000e;}
}
unless(defined(&GX_PCI_LOMEM)) {
    sub GX_PCI_LOMEM () {	0x0010;}
}
unless(defined(&GX_PCI_SUBVEN_ID)) {
    sub GX_PCI_SUBVEN_ID () {	0x002c;}
}
unless(defined(&GX_PCI_SYBSYS_ID)) {
    sub GX_PCI_SYBSYS_ID () {	0x002e;}
}
unless(defined(&GX_PCI_BIOSROM)) {
    sub GX_PCI_BIOSROM () {	0x0030;}
}
unless(defined(&GX_PCI_CAPABILITY_PTR)) {
    sub GX_PCI_CAPABILITY_PTR () {	0x0034;}
}
unless(defined(&GX_PCI_INTLINE)) {
    sub GX_PCI_INTLINE () {	0x003c;}
}
unless(defined(&GX_PCI_INTPIN)) {
    sub GX_PCI_INTPIN () {	0x003d;}
}
unless(defined(&GX_PCI_MINGNT)) {
    sub GX_PCI_MINGNT () {	0x003e;}
}
unless(defined(&GX_PCI_MINLAT)) {
    sub GX_PCI_MINLAT () {	0x003f;}
}
unless(defined(&GX_TXOLD_END_OF_PKT)) {
    sub GX_TXOLD_END_OF_PKT () {	0x01;}
}
unless(defined(&GX_TXOLD_ETHER_CRC)) {
    sub GX_TXOLD_ETHER_CRC () {	0x02;}
}
unless(defined(&GX_TXOLD_INSERT_CSUM)) {
    sub GX_TXOLD_INSERT_CSUM () {	0x04;}
}
unless(defined(&GX_TXOLD_REPORT_STATUS)) {
    sub GX_TXOLD_REPORT_STATUS () {	0x08;}
}
unless(defined(&GX_TXOLD_REPORT_SENT)) {
    sub GX_TXOLD_REPORT_SENT () {	0x10;}
}
unless(defined(&GX_TXOLD_EXTENSION)) {
    sub GX_TXOLD_EXTENSION () {	0x20;}
}
unless(defined(&GX_TXOLD_VLAN_ENABLE)) {
    sub GX_TXOLD_VLAN_ENABLE () {	0x40;}
}
unless(defined(&GX_TXOLD_INT_DELAY)) {
    sub GX_TXOLD_INT_DELAY () {	0x80;}
}
unless(defined(&GX_TXSTAT_DONE)) {
    sub GX_TXSTAT_DONE () {	0x01;}
}
unless(defined(&GX_TXSTAT_EXCESS_COLL)) {
    sub GX_TXSTAT_EXCESS_COLL () {	0x02;}
}
unless(defined(&GX_TXSTAT_LATE_COLL)) {
    sub GX_TXSTAT_LATE_COLL () {	0x04;}
}
unless(defined(&GX_TXSTAT_UNDERRUN)) {
    sub GX_TXSTAT_UNDERRUN () {	0x08;}
}
unless(defined(&GX_TXCTX_TCP_PKT)) {
    sub GX_TXCTX_TCP_PKT () {	0x01;}
}
unless(defined(&GX_TXCTX_IP_PKT)) {
    sub GX_TXCTX_IP_PKT () {	0x02;}
}
unless(defined(&GX_TXCTX_TCP_SEG_EN)) {
    sub GX_TXCTX_TCP_SEG_EN () {	0x04;}
}
unless(defined(&GX_TXCTX_REPORT_STATUS)) {
    sub GX_TXCTX_REPORT_STATUS () {	0x08;}
}
unless(defined(&GX_TXCTX_EXTENSION)) {
    sub GX_TXCTX_EXTENSION () {	0x20;}
}
unless(defined(&GX_TXCTX_INT_DELAY)) {
    sub GX_TXCTX_INT_DELAY () {	0x80;}
}
unless(defined(&GX_TXTCP_END_OF_PKT)) {
    sub GX_TXTCP_END_OF_PKT () {	0x01;}
}
unless(defined(&GX_TXTCP_ETHER_CRC)) {
    sub GX_TXTCP_ETHER_CRC () {	0x02;}
}
unless(defined(&GX_TXTCP_TCP_SEG_EN)) {
    sub GX_TXTCP_TCP_SEG_EN () {	0x04;}
}
unless(defined(&GX_TXTCP_REPORT_STATUS)) {
    sub GX_TXTCP_REPORT_STATUS () {	0x08;}
}
unless(defined(&GX_TXTCP_REPORT_SENT)) {
    sub GX_TXTCP_REPORT_SENT () {	0x10;}
}
unless(defined(&GX_TXTCP_EXTENSION)) {
    sub GX_TXTCP_EXTENSION () {	0x20;}
}
unless(defined(&GX_TXTCP_VLAN_ENABLE)) {
    sub GX_TXTCP_VLAN_ENABLE () {	0x40;}
}
unless(defined(&GX_TXTCP_INT_DELAY)) {
    sub GX_TXTCP_INT_DELAY () {	0x80;}
}
unless(defined(&GX_TXTCP_OPT_IP_CSUM)) {
    sub GX_TXTCP_OPT_IP_CSUM () {	0x01;}
}
unless(defined(&GX_TXTCP_OPT_TCP_CSUM)) {
    sub GX_TXTCP_OPT_TCP_CSUM () {	0x02;}
}
unless(defined(&GX_RXSTAT_COMPLETED)) {
    sub GX_RXSTAT_COMPLETED () {	0x01;}
}
unless(defined(&GX_RXSTAT_END_OF_PACKET)) {
    sub GX_RXSTAT_END_OF_PACKET () {	0x02;}
}
unless(defined(&GX_RXSTAT_IGNORE_CSUM)) {
    sub GX_RXSTAT_IGNORE_CSUM () {	0x04;}
}
unless(defined(&GX_RXSTAT_VLAN_PKT)) {
    sub GX_RXSTAT_VLAN_PKT () {	0x08;}
}
unless(defined(&GX_RXSTAT_HAS_TCP_CSUM)) {
    sub GX_RXSTAT_HAS_TCP_CSUM () {	0x20;}
}
unless(defined(&GX_RXSTAT_HAS_IP_CSUM)) {
    sub GX_RXSTAT_HAS_IP_CSUM () {	0x40;}
}
unless(defined(&GX_RXSTAT_INEXACT_MATCH)) {
    sub GX_RXSTAT_INEXACT_MATCH () {	0x80;}
}
unless(defined(&GX_RXERR_CRC)) {
    sub GX_RXERR_CRC () {	0x0100;}
}
unless(defined(&GX_RXERR_SYMBOL)) {
    sub GX_RXERR_SYMBOL () {	0x0200;}
}
unless(defined(&GX_RXERR_SEQUENCE)) {
    sub GX_RXERR_SEQUENCE () {	0x0400;}
}
unless(defined(&GX_RXERR_CARRIER)) {
    sub GX_RXERR_CARRIER () {	0x1000;}
}
unless(defined(&GX_RXERR_TCP_CSUM)) {
    sub GX_RXERR_TCP_CSUM () {	0x2000;}
}
unless(defined(&GX_RXERR_IP_CSUM)) {
    sub GX_RXERR_IP_CSUM () {	0x4000;}
}
unless(defined(&GX_RXERR_RX_DATA)) {
    sub GX_RXERR_RX_DATA () {	0x8000;}
}
unless(defined(&GX_INPUT_ERROR)) {
    sub GX_INPUT_ERROR () {	( &GX_RXERR_CRC |  &GX_RXERR_SYMBOL |  &GX_RXERR_SEQUENCE |  &GX_RXERR_CARRIER |  &GX_RXERR_RX_DATA);}
}
1;
