require '_h2ph_pre.ph';

unless(defined(&XL_EE_READ)) {
    sub XL_EE_READ () {	0x0080;}
}
unless(defined(&XL_EE_WRITE)) {
    sub XL_EE_WRITE () {	0x0040;}
}
unless(defined(&XL_EE_ERASE)) {
    sub XL_EE_ERASE () {	0x00c0;}
}
unless(defined(&XL_EE_EWEN)) {
    sub XL_EE_EWEN () {	0x0030;}
}
unless(defined(&XL_EE_BUSY)) {
    sub XL_EE_BUSY () {	0x8000;}
}
unless(defined(&XL_EE_EADDR0)) {
    sub XL_EE_EADDR0 () {	0x00;}
}
unless(defined(&XL_EE_EADDR1)) {
    sub XL_EE_EADDR1 () {	0x01;}
}
unless(defined(&XL_EE_EADDR2)) {
    sub XL_EE_EADDR2 () {	0x02;}
}
unless(defined(&XL_EE_PRODID)) {
    sub XL_EE_PRODID () {	0x03;}
}
unless(defined(&XL_EE_MDATA_DATE)) {
    sub XL_EE_MDATA_DATE () {	0x04;}
}
unless(defined(&XL_EE_MDATA_DIV)) {
    sub XL_EE_MDATA_DIV () {	0x05;}
}
unless(defined(&XL_EE_MDATA_PCODE)) {
    sub XL_EE_MDATA_PCODE () {	0x06;}
}
unless(defined(&XL_EE_MFG_ID)) {
    sub XL_EE_MFG_ID () {	0x07;}
}
unless(defined(&XL_EE_PCI_PARM)) {
    sub XL_EE_PCI_PARM () {	0x08;}
}
unless(defined(&XL_EE_ROM_ONFO)) {
    sub XL_EE_ROM_ONFO () {	0x09;}
}
unless(defined(&XL_EE_OEM_ADR0)) {
    sub XL_EE_OEM_ADR0 () {	0x0a;}
}
unless(defined(&XL_EE_OEM_ADR1)) {
    sub XL_EE_OEM_ADR1 () {	0x0b;}
}
unless(defined(&XL_EE_OEM_ADR2)) {
    sub XL_EE_OEM_ADR2 () {	0x0c;}
}
unless(defined(&XL_EE_SOFTINFO1)) {
    sub XL_EE_SOFTINFO1 () {	0x0d;}
}
unless(defined(&XL_EE_COMPAT)) {
    sub XL_EE_COMPAT () {	0x0e;}
}
unless(defined(&XL_EE_SOFTINFO2)) {
    sub XL_EE_SOFTINFO2 () {	0x0f;}
}
unless(defined(&XL_EE_CAPS)) {
    sub XL_EE_CAPS () {	0x10;}
}
unless(defined(&XL_EE_RSVD0)) {
    sub XL_EE_RSVD0 () {	0x11;}
}
unless(defined(&XL_EE_ICFG_0)) {
    sub XL_EE_ICFG_0 () {	0x12;}
}
unless(defined(&XL_EE_ICFG_1)) {
    sub XL_EE_ICFG_1 () {	0x13;}
}
unless(defined(&XL_EE_RSVD1)) {
    sub XL_EE_RSVD1 () {	0x14;}
}
unless(defined(&XL_EE_SOFTINFO3)) {
    sub XL_EE_SOFTINFO3 () {	0x15;}
}
unless(defined(&XL_EE_RSVD_2)) {
    sub XL_EE_RSVD_2 () {	0x16;}
}
unless(defined(&XL_CAPS_PNP)) {
    sub XL_CAPS_PNP () {	0x0001;}
}
unless(defined(&XL_CAPS_FULL_DUPLEX)) {
    sub XL_CAPS_FULL_DUPLEX () {	0x0002;}
}
unless(defined(&XL_CAPS_LARGE_PKTS)) {
    sub XL_CAPS_LARGE_PKTS () {	0x0004;}
}
unless(defined(&XL_CAPS_SLAVE_DMA)) {
    sub XL_CAPS_SLAVE_DMA () {	0x0008;}
}
unless(defined(&XL_CAPS_SECOND_DMA)) {
    sub XL_CAPS_SECOND_DMA () {	0x0010;}
}
unless(defined(&XL_CAPS_FULL_BM)) {
    sub XL_CAPS_FULL_BM () {	0x0020;}
}
unless(defined(&XL_CAPS_FRAG_BM)) {
    sub XL_CAPS_FRAG_BM () {	0x0040;}
}
unless(defined(&XL_CAPS_CRC_PASSTHRU)) {
    sub XL_CAPS_CRC_PASSTHRU () {	0x0080;}
}
unless(defined(&XL_CAPS_TXDONE)) {
    sub XL_CAPS_TXDONE () {	0x0100;}
}
unless(defined(&XL_CAPS_NO_TXLENGTH)) {
    sub XL_CAPS_NO_TXLENGTH () {	0x0200;}
}
unless(defined(&XL_CAPS_RX_REPEAT)) {
    sub XL_CAPS_RX_REPEAT () {	0x0400;}
}
unless(defined(&XL_CAPS_SNOOPING)) {
    sub XL_CAPS_SNOOPING () {	0x0800;}
}
unless(defined(&XL_CAPS_100MBPS)) {
    sub XL_CAPS_100MBPS () {	0x1000;}
}
unless(defined(&XL_CAPS_PWRMGMT)) {
    sub XL_CAPS_PWRMGMT () {	0x2000;}
}
unless(defined(&XL_PACKET_SIZE)) {
    sub XL_PACKET_SIZE () {	1536;}
}
unless(defined(&XL_COMMAND)) {
    sub XL_COMMAND () {	0x0e;}
}
unless(defined(&XL_STATUS)) {
    sub XL_STATUS () {	0x0e;}
}
unless(defined(&XL_TX_STATUS)) {
    sub XL_TX_STATUS () {	0x1b;}
}
unless(defined(&XL_TX_FREE)) {
    sub XL_TX_FREE () {	0x1c;}
}
unless(defined(&XL_DMACTL)) {
    sub XL_DMACTL () {	0x20;}
}
unless(defined(&XL_DOWNLIST_PTR)) {
    sub XL_DOWNLIST_PTR () {	0x24;}
}
unless(defined(&XL_DOWN_POLL)) {
    sub XL_DOWN_POLL () {	0x2d;}
}
unless(defined(&XL_TX_FREETHRESH)) {
    sub XL_TX_FREETHRESH () {	0x2f;}
}
unless(defined(&XL_UPLIST_PTR)) {
    sub XL_UPLIST_PTR () {	0x38;}
}
unless(defined(&XL_UPLIST_STATUS)) {
    sub XL_UPLIST_STATUS () {	0x30;}
}
unless(defined(&XL_UP_POLL)) {
    sub XL_UP_POLL () {	0x3d;}
}
unless(defined(&XL_PKTSTAT_UP_STALLED)) {
    sub XL_PKTSTAT_UP_STALLED () {	0x00002000;}
}
unless(defined(&XL_PKTSTAT_UP_ERROR)) {
    sub XL_PKTSTAT_UP_ERROR () {	0x00004000;}
}
unless(defined(&XL_PKTSTAT_UP_CMPLT)) {
    sub XL_PKTSTAT_UP_CMPLT () {	0x00008000;}
}
unless(defined(&XL_DMACTL_DN_CMPLT_REQ)) {
    sub XL_DMACTL_DN_CMPLT_REQ () {	0x00000002;}
}
unless(defined(&XL_DMACTL_DOWN_STALLED)) {
    sub XL_DMACTL_DOWN_STALLED () {	0x00000004;}
}
unless(defined(&XL_DMACTL_UP_CMPLT)) {
    sub XL_DMACTL_UP_CMPLT () {	0x00000008;}
}
unless(defined(&XL_DMACTL_DOWN_CMPLT)) {
    sub XL_DMACTL_DOWN_CMPLT () {	0x00000010;}
}
unless(defined(&XL_DMACTL_UP_RX_EARLY)) {
    sub XL_DMACTL_UP_RX_EARLY () {	0x00000020;}
}
unless(defined(&XL_DMACTL_ARM_COUNTDOWN)) {
    sub XL_DMACTL_ARM_COUNTDOWN () {	0x00000040;}
}
unless(defined(&XL_DMACTL_DOWN_INPROG)) {
    sub XL_DMACTL_DOWN_INPROG () {	0x00000080;}
}
unless(defined(&XL_DMACTL_COUNTER_SPEED)) {
    sub XL_DMACTL_COUNTER_SPEED () {	0x00000100;}
}
unless(defined(&XL_DMACTL_DOWNDOWN_MODE)) {
    sub XL_DMACTL_DOWNDOWN_MODE () {	0x00000200;}
}
unless(defined(&XL_DMACTL_TARGET_ABORT)) {
    sub XL_DMACTL_TARGET_ABORT () {	0x40000000;}
}
unless(defined(&XL_DMACTL_MASTER_ABORT)) {
    sub XL_DMACTL_MASTER_ABORT () {	0x80000000;}
}
unless(defined(&XL_CMD_RESET)) {
    sub XL_CMD_RESET () {	0x0000;}
}
unless(defined(&XL_CMD_WINSEL)) {
    sub XL_CMD_WINSEL () {	0x0800;}
}
unless(defined(&XL_CMD_COAX_START)) {
    sub XL_CMD_COAX_START () {	0x1000;}
}
unless(defined(&XL_CMD_RX_DISABLE)) {
    sub XL_CMD_RX_DISABLE () {	0x1800;}
}
unless(defined(&XL_CMD_RX_ENABLE)) {
    sub XL_CMD_RX_ENABLE () {	0x2000;}
}
unless(defined(&XL_CMD_RX_RESET)) {
    sub XL_CMD_RX_RESET () {	0x2800;}
}
unless(defined(&XL_CMD_UP_STALL)) {
    sub XL_CMD_UP_STALL () {	0x3000;}
}
unless(defined(&XL_CMD_UP_UNSTALL)) {
    sub XL_CMD_UP_UNSTALL () {	0x3001;}
}
unless(defined(&XL_CMD_DOWN_STALL)) {
    sub XL_CMD_DOWN_STALL () {	0x3002;}
}
unless(defined(&XL_CMD_DOWN_UNSTALL)) {
    sub XL_CMD_DOWN_UNSTALL () {	0x3003;}
}
unless(defined(&XL_CMD_RX_DISCARD)) {
    sub XL_CMD_RX_DISCARD () {	0x4000;}
}
unless(defined(&XL_CMD_TX_ENABLE)) {
    sub XL_CMD_TX_ENABLE () {	0x4800;}
}
unless(defined(&XL_CMD_TX_DISABLE)) {
    sub XL_CMD_TX_DISABLE () {	0x5000;}
}
unless(defined(&XL_CMD_TX_RESET)) {
    sub XL_CMD_TX_RESET () {	0x5800;}
}
unless(defined(&XL_CMD_INTR_FAKE)) {
    sub XL_CMD_INTR_FAKE () {	0x6000;}
}
unless(defined(&XL_CMD_INTR_ACK)) {
    sub XL_CMD_INTR_ACK () {	0x6800;}
}
unless(defined(&XL_CMD_INTR_ENB)) {
    sub XL_CMD_INTR_ENB () {	0x7000;}
}
unless(defined(&XL_CMD_STAT_ENB)) {
    sub XL_CMD_STAT_ENB () {	0x7800;}
}
unless(defined(&XL_CMD_RX_SET_FILT)) {
    sub XL_CMD_RX_SET_FILT () {	0x8000;}
}
unless(defined(&XL_CMD_RX_SET_THRESH)) {
    sub XL_CMD_RX_SET_THRESH () {	0x8800;}
}
unless(defined(&XL_CMD_TX_SET_THRESH)) {
    sub XL_CMD_TX_SET_THRESH () {	0x9000;}
}
unless(defined(&XL_CMD_TX_SET_START)) {
    sub XL_CMD_TX_SET_START () {	0x9800;}
}
unless(defined(&XL_CMD_DMA_UP)) {
    sub XL_CMD_DMA_UP () {	0xa000;}
}
unless(defined(&XL_CMD_DMA_STOP)) {
    sub XL_CMD_DMA_STOP () {	0xa001;}
}
unless(defined(&XL_CMD_STATS_ENABLE)) {
    sub XL_CMD_STATS_ENABLE () {	0xa800;}
}
unless(defined(&XL_CMD_STATS_DISABLE)) {
    sub XL_CMD_STATS_DISABLE () {	0xb000;}
}
unless(defined(&XL_CMD_COAX_STOP)) {
    sub XL_CMD_COAX_STOP () {	0xb800;}
}
unless(defined(&XL_CMD_SET_TX_RECLAIM)) {
    sub XL_CMD_SET_TX_RECLAIM () {	0xc000;}
}
unless(defined(&XL_CMD_RX_SET_HASH)) {
    sub XL_CMD_RX_SET_HASH () {	0xc800;}
}
unless(defined(&XL_HASH_SET)) {
    sub XL_HASH_SET () {	0x0400;}
}
unless(defined(&XL_HASHFILT_SIZE)) {
    sub XL_HASHFILT_SIZE () {	256;}
}
unless(defined(&XL_STAT_INTLATCH)) {
    sub XL_STAT_INTLATCH () {	0x0001;}
}
unless(defined(&XL_STAT_ADFAIL)) {
    sub XL_STAT_ADFAIL () {	0x0002;}
}
unless(defined(&XL_STAT_TX_COMPLETE)) {
    sub XL_STAT_TX_COMPLETE () {	0x0004;}
}
unless(defined(&XL_STAT_TX_AVAIL)) {
    sub XL_STAT_TX_AVAIL () {	0x0008;}
}
unless(defined(&XL_STAT_RX_COMPLETE)) {
    sub XL_STAT_RX_COMPLETE () {	0x0010;}
}
unless(defined(&XL_STAT_RX_EARLY)) {
    sub XL_STAT_RX_EARLY () {	0x0020;}
}
unless(defined(&XL_STAT_INTREQ)) {
    sub XL_STAT_INTREQ () {	0x0040;}
}
unless(defined(&XL_STAT_STATSOFLOW)) {
    sub XL_STAT_STATSOFLOW () {	0x0080;}
}
unless(defined(&XL_STAT_DMADONE)) {
    sub XL_STAT_DMADONE () {	0x0100;}
}
unless(defined(&XL_STAT_LINKSTAT)) {
    sub XL_STAT_LINKSTAT () {	0x0100;}
}
unless(defined(&XL_STAT_DOWN_COMPLETE)) {
    sub XL_STAT_DOWN_COMPLETE () {	0x0200;}
}
unless(defined(&XL_STAT_UP_COMPLETE)) {
    sub XL_STAT_UP_COMPLETE () {	0x0400;}
}
unless(defined(&XL_STAT_DMABUSY)) {
    sub XL_STAT_DMABUSY () {	0x0800;}
}
unless(defined(&XL_STAT_CMDBUSY)) {
    sub XL_STAT_CMDBUSY () {	0x1000;}
}
unless(defined(&XL_INTRS)) {
    sub XL_INTRS () {	( &XL_STAT_UP_COMPLETE| &XL_STAT_STATSOFLOW| &XL_STAT_ADFAIL|  &XL_STAT_DOWN_COMPLETE| &XL_STAT_TX_COMPLETE| &XL_STAT_INTLATCH);}
}
unless(defined(&XL_W0_EE_DATA)) {
    sub XL_W0_EE_DATA () {	0x0c;}
}
unless(defined(&XL_W0_EE_CMD)) {
    sub XL_W0_EE_CMD () {	0x0a;}
}
unless(defined(&XL_W0_RSRC_CFG)) {
    sub XL_W0_RSRC_CFG () {	0x08;}
}
unless(defined(&XL_W0_ADDR_CFG)) {
    sub XL_W0_ADDR_CFG () {	0x06;}
}
unless(defined(&XL_W0_CFG_CTRL)) {
    sub XL_W0_CFG_CTRL () {	0x04;}
}
unless(defined(&XL_W0_PROD_ID)) {
    sub XL_W0_PROD_ID () {	0x02;}
}
unless(defined(&XL_W0_MFG_ID)) {
    sub XL_W0_MFG_ID () {	0x00;}
}
unless(defined(&XL_W1_TX_FIFO)) {
    sub XL_W1_TX_FIFO () {	0x10;}
}
unless(defined(&XL_W1_FREE_TX)) {
    sub XL_W1_FREE_TX () {	0x0c;}
}
unless(defined(&XL_W1_TX_STATUS)) {
    sub XL_W1_TX_STATUS () {	0x0b;}
}
unless(defined(&XL_W1_TX_TIMER)) {
    sub XL_W1_TX_TIMER () {	0x0a;}
}
unless(defined(&XL_W1_RX_STATUS)) {
    sub XL_W1_RX_STATUS () {	0x08;}
}
unless(defined(&XL_W1_RX_FIFO)) {
    sub XL_W1_RX_FIFO () {	0x00;}
}
unless(defined(&XL_RXSTATUS_OVERRUN)) {
    sub XL_RXSTATUS_OVERRUN () {	0x01;}
}
unless(defined(&XL_RXSTATUS_RUNT)) {
    sub XL_RXSTATUS_RUNT () {	0x02;}
}
unless(defined(&XL_RXSTATUS_ALIGN)) {
    sub XL_RXSTATUS_ALIGN () {	0x04;}
}
unless(defined(&XL_RXSTATUS_CRC)) {
    sub XL_RXSTATUS_CRC () {	0x08;}
}
unless(defined(&XL_RXSTATUS_OVERSIZE)) {
    sub XL_RXSTATUS_OVERSIZE () {	0x10;}
}
unless(defined(&XL_RXSTATUS_DRIBBLE)) {
    sub XL_RXSTATUS_DRIBBLE () {	0x20;}
}
unless(defined(&XL_TXSTATUS_RECLAIM)) {
    sub XL_TXSTATUS_RECLAIM () {	0x02;}
}
unless(defined(&XL_TXSTATUS_OVERFLOW)) {
    sub XL_TXSTATUS_OVERFLOW () {	0x04;}
}
unless(defined(&XL_TXSTATUS_MAXCOLS)) {
    sub XL_TXSTATUS_MAXCOLS () {	0x08;}
}
unless(defined(&XL_TXSTATUS_UNDERRUN)) {
    sub XL_TXSTATUS_UNDERRUN () {	0x10;}
}
unless(defined(&XL_TXSTATUS_JABBER)) {
    sub XL_TXSTATUS_JABBER () {	0x20;}
}
unless(defined(&XL_TXSTATUS_INTREQ)) {
    sub XL_TXSTATUS_INTREQ () {	0x40;}
}
unless(defined(&XL_TXSTATUS_COMPLETE)) {
    sub XL_TXSTATUS_COMPLETE () {	0x80;}
}
unless(defined(&XL_W2_RESET_OPTIONS)) {
    sub XL_W2_RESET_OPTIONS () {	0x0c;}
}
unless(defined(&XL_W2_STATION_MASK_HI)) {
    sub XL_W2_STATION_MASK_HI () {	0x0a;}
}
unless(defined(&XL_W2_STATION_MASK_MID)) {
    sub XL_W2_STATION_MASK_MID () {	0x08;}
}
unless(defined(&XL_W2_STATION_MASK_LO)) {
    sub XL_W2_STATION_MASK_LO () {	0x06;}
}
unless(defined(&XL_W2_STATION_ADDR_HI)) {
    sub XL_W2_STATION_ADDR_HI () {	0x04;}
}
unless(defined(&XL_W2_STATION_ADDR_MID)) {
    sub XL_W2_STATION_ADDR_MID () {	0x02;}
}
unless(defined(&XL_W2_STATION_ADDR_LO)) {
    sub XL_W2_STATION_ADDR_LO () {	0x00;}
}
unless(defined(&XL_RESETOPT_FEATUREMASK)) {
    sub XL_RESETOPT_FEATUREMASK () {	0x0001|0x0002|0x004;}
}
unless(defined(&XL_RESETOPT_D3RESETDIS)) {
    sub XL_RESETOPT_D3RESETDIS () {	0x0008;}
}
unless(defined(&XL_RESETOPT_DISADVFD)) {
    sub XL_RESETOPT_DISADVFD () {	0x0010;}
}
unless(defined(&XL_RESETOPT_DISADV100)) {
    sub XL_RESETOPT_DISADV100 () {	0x0020;}
}
unless(defined(&XL_RESETOPT_DISAUTONEG)) {
    sub XL_RESETOPT_DISAUTONEG () {	0x0040;}
}
unless(defined(&XL_RESETOPT_DEBUGMODE)) {
    sub XL_RESETOPT_DEBUGMODE () {	0x0080;}
}
unless(defined(&XL_RESETOPT_FASTAUTO)) {
    sub XL_RESETOPT_FASTAUTO () {	0x0100;}
}
unless(defined(&XL_RESETOPT_FASTEE)) {
    sub XL_RESETOPT_FASTEE () {	0x0200;}
}
unless(defined(&XL_RESETOPT_FORCEDCONF)) {
    sub XL_RESETOPT_FORCEDCONF () {	0x0400;}
}
unless(defined(&XL_RESETOPT_TESTPDTPDR)) {
    sub XL_RESETOPT_TESTPDTPDR () {	0x0800;}
}
unless(defined(&XL_RESETOPT_TEST100TX)) {
    sub XL_RESETOPT_TEST100TX () {	0x1000;}
}
unless(defined(&XL_RESETOPT_TEST100RX)) {
    sub XL_RESETOPT_TEST100RX () {	0x2000;}
}
unless(defined(&XL_W3_INTERNAL_CFG)) {
    sub XL_W3_INTERNAL_CFG () {	0x00;}
}
unless(defined(&XL_W3_MAX_PKT_SIZE)) {
    sub XL_W3_MAX_PKT_SIZE () {	0x04;}
}
unless(defined(&XL_W3_RESET_OPT)) {
    sub XL_W3_RESET_OPT () {	0x08;}
}
unless(defined(&XL_W3_FREE_TX)) {
    sub XL_W3_FREE_TX () {	0x0c;}
}
unless(defined(&XL_W3_FREE_RX)) {
    sub XL_W3_FREE_RX () {	0x0a;}
}
unless(defined(&XL_W3_MAC_CTRL)) {
    sub XL_W3_MAC_CTRL () {	0x06;}
}
unless(defined(&XL_ICFG_CONNECTOR_MASK)) {
    sub XL_ICFG_CONNECTOR_MASK () {	0x00f00000;}
}
unless(defined(&XL_ICFG_CONNECTOR_BITS)) {
    sub XL_ICFG_CONNECTOR_BITS () {	20;}
}
unless(defined(&XL_ICFG_RAMSIZE_MASK)) {
    sub XL_ICFG_RAMSIZE_MASK () {	0x00000007;}
}
unless(defined(&XL_ICFG_RAMWIDTH)) {
    sub XL_ICFG_RAMWIDTH () {	0x00000008;}
}
unless(defined(&XL_ICFG_ROMSIZE_MASK)) {
    sub XL_ICFG_ROMSIZE_MASK () {	(0x00000040|0x00000080);}
}
unless(defined(&XL_ICFG_DISABLE_BASSD)) {
    sub XL_ICFG_DISABLE_BASSD () {	0x00000100;}
}
unless(defined(&XL_ICFG_RAMLOC)) {
    sub XL_ICFG_RAMLOC () {	0x00000200;}
}
unless(defined(&XL_ICFG_RAMPART)) {
    sub XL_ICFG_RAMPART () {	(0x00010000|0x00020000);}
}
unless(defined(&XL_ICFG_XCVRSEL)) {
    sub XL_ICFG_XCVRSEL () {	(0x00100000|0x00200000|0x00400000);}
}
unless(defined(&XL_ICFG_AUTOSEL)) {
    sub XL_ICFG_AUTOSEL () {	0x01000000;}
}
unless(defined(&XL_XCVR_10BT)) {
    sub XL_XCVR_10BT () {	0x00;}
}
unless(defined(&XL_XCVR_AUI)) {
    sub XL_XCVR_AUI () {	0x01;}
}
unless(defined(&XL_XCVR_RSVD_0)) {
    sub XL_XCVR_RSVD_0 () {	0x02;}
}
unless(defined(&XL_XCVR_COAX)) {
    sub XL_XCVR_COAX () {	0x03;}
}
unless(defined(&XL_XCVR_100BTX)) {
    sub XL_XCVR_100BTX () {	0x04;}
}
unless(defined(&XL_XCVR_100BFX)) {
    sub XL_XCVR_100BFX () {	0x05;}
}
unless(defined(&XL_XCVR_MII)) {
    sub XL_XCVR_MII () {	0x06;}
}
unless(defined(&XL_XCVR_RSVD_1)) {
    sub XL_XCVR_RSVD_1 () {	0x07;}
}
unless(defined(&XL_XCVR_AUTO)) {
    sub XL_XCVR_AUTO () {	0x08;}
}
unless(defined(&XL_XCVR_NWAY)) {
    sub XL_XCVR_NWAY () {	0x09;}
}
unless(defined(&XL_MACCTRL_DEFER_EXT_END)) {
    sub XL_MACCTRL_DEFER_EXT_END () {	0x0001;}
}
unless(defined(&XL_MACCTRL_DEFER_0)) {
    sub XL_MACCTRL_DEFER_0 () {	0x0002;}
}
unless(defined(&XL_MACCTRL_DEFER_1)) {
    sub XL_MACCTRL_DEFER_1 () {	0x0004;}
}
unless(defined(&XL_MACCTRL_DEFER_2)) {
    sub XL_MACCTRL_DEFER_2 () {	0x0008;}
}
unless(defined(&XL_MACCTRL_DEFER_3)) {
    sub XL_MACCTRL_DEFER_3 () {	0x0010;}
}
unless(defined(&XL_MACCTRL_DUPLEX)) {
    sub XL_MACCTRL_DUPLEX () {	0x0020;}
}
unless(defined(&XL_MACCTRL_ALLOW_LARGE_PACK)) {
    sub XL_MACCTRL_ALLOW_LARGE_PACK () {	0x0040;}
}
unless(defined(&XL_MACCTRL_EXTEND_AFTER_COL)) {
    sub XL_MACCTRL_EXTEND_AFTER_COL () {	0x0080 (3 &c905B  &only);}
}
unless(defined(&XL_MACCTRL_FLOW_CONTROL_ENB)) {
    sub XL_MACCTRL_FLOW_CONTROL_ENB () {	0x0100 (3 &c905B  &only);}
}
unless(defined(&XL_MACCTRL_VLT_END)) {
    sub XL_MACCTRL_VLT_END () {	0x0200 (3 &c905B  &only);}
}
unless(defined(&XL_W3_MEDIA_OPT)) {
    sub XL_W3_MEDIA_OPT () {	0x08;}
}
unless(defined(&XL_MEDIAOPT_BT4)) {
    sub XL_MEDIAOPT_BT4 () {	0x0001;}
}
unless(defined(&XL_MEDIAOPT_BTX)) {
    sub XL_MEDIAOPT_BTX () {	0x0002;}
}
unless(defined(&XL_MEDIAOPT_BFX)) {
    sub XL_MEDIAOPT_BFX () {	0x0004;}
}
unless(defined(&XL_MEDIAOPT_BT)) {
    sub XL_MEDIAOPT_BT () {	0x0008;}
}
unless(defined(&XL_MEDIAOPT_BNC)) {
    sub XL_MEDIAOPT_BNC () {	0x0010;}
}
unless(defined(&XL_MEDIAOPT_AUI)) {
    sub XL_MEDIAOPT_AUI () {	0x0020;}
}
unless(defined(&XL_MEDIAOPT_MII)) {
    sub XL_MEDIAOPT_MII () {	0x0040;}
}
unless(defined(&XL_MEDIAOPT_VCO)) {
    sub XL_MEDIAOPT_VCO () {	0x0100;}
}
unless(defined(&XL_MEDIAOPT_10FL)) {
    sub XL_MEDIAOPT_10FL () {	0x0100;}
}
unless(defined(&XL_MEDIAOPT_MASK)) {
    sub XL_MEDIAOPT_MASK () {	0x01ff;}
}
unless(defined(&XL_W4_UPPERBYTESOK)) {
    sub XL_W4_UPPERBYTESOK () {	0x0d;}
}
unless(defined(&XL_W4_BADSSD)) {
    sub XL_W4_BADSSD () {	0x0c;}
}
unless(defined(&XL_W4_MEDIA_STATUS)) {
    sub XL_W4_MEDIA_STATUS () {	0x0a;}
}
unless(defined(&XL_W4_PHY_MGMT)) {
    sub XL_W4_PHY_MGMT () {	0x08;}
}
unless(defined(&XL_W4_NET_DIAG)) {
    sub XL_W4_NET_DIAG () {	0x06;}
}
unless(defined(&XL_W4_FIFO_DIAG)) {
    sub XL_W4_FIFO_DIAG () {	0x04;}
}
unless(defined(&XL_W4_VCO_DIAG)) {
    sub XL_W4_VCO_DIAG () {	0x02;}
}
unless(defined(&XL_W4_CTRLR_STAT)) {
    sub XL_W4_CTRLR_STAT () {	0x08;}
}
unless(defined(&XL_W4_TX_DIAG)) {
    sub XL_W4_TX_DIAG () {	0x00;}
}
unless(defined(&XL_MII_CLK)) {
    sub XL_MII_CLK () {	0x01;}
}
unless(defined(&XL_MII_DATA)) {
    sub XL_MII_DATA () {	0x02;}
}
unless(defined(&XL_MII_DIR)) {
    sub XL_MII_DIR () {	0x04;}
}
unless(defined(&XL_MEDIA_SQE)) {
    sub XL_MEDIA_SQE () {	0x0008;}
}
unless(defined(&XL_MEDIA_10TP)) {
    sub XL_MEDIA_10TP () {	0x00c0;}
}
unless(defined(&XL_MEDIA_LNK)) {
    sub XL_MEDIA_LNK () {	0x0080;}
}
unless(defined(&XL_MEDIA_LNKBEAT)) {
    sub XL_MEDIA_LNKBEAT () {	0x0800;}
}
unless(defined(&XL_MEDIASTAT_CRCSTRIP)) {
    sub XL_MEDIASTAT_CRCSTRIP () {	0x0004;}
}
unless(defined(&XL_MEDIASTAT_SQEENB)) {
    sub XL_MEDIASTAT_SQEENB () {	0x0008;}
}
unless(defined(&XL_MEDIASTAT_COLDET)) {
    sub XL_MEDIASTAT_COLDET () {	0x0010;}
}
unless(defined(&XL_MEDIASTAT_CARRIER)) {
    sub XL_MEDIASTAT_CARRIER () {	0x0020;}
}
unless(defined(&XL_MEDIASTAT_JABGUARD)) {
    sub XL_MEDIASTAT_JABGUARD () {	0x0040;}
}
unless(defined(&XL_MEDIASTAT_LINKBEAT)) {
    sub XL_MEDIASTAT_LINKBEAT () {	0x0080;}
}
unless(defined(&XL_MEDIASTAT_JABDETECT)) {
    sub XL_MEDIASTAT_JABDETECT () {	0x0200;}
}
unless(defined(&XL_MEDIASTAT_POLREVERS)) {
    sub XL_MEDIASTAT_POLREVERS () {	0x0400;}
}
unless(defined(&XL_MEDIASTAT_LINKDETECT)) {
    sub XL_MEDIASTAT_LINKDETECT () {	0x0800;}
}
unless(defined(&XL_MEDIASTAT_TXINPROG)) {
    sub XL_MEDIASTAT_TXINPROG () {	0x1000;}
}
unless(defined(&XL_MEDIASTAT_DCENB)) {
    sub XL_MEDIASTAT_DCENB () {	0x4000;}
}
unless(defined(&XL_MEDIASTAT_AUIDIS)) {
    sub XL_MEDIASTAT_AUIDIS () {	0x8000;}
}
unless(defined(&XL_NETDIAG_TEST_LOWVOLT)) {
    sub XL_NETDIAG_TEST_LOWVOLT () {	0x0001;}
}
unless(defined(&XL_NETDIAG_ASIC_REVMASK)) {
    sub XL_NETDIAG_ASIC_REVMASK () {	(0x0002|0x0004|0x0008|0x0010|0x0020);}
}
unless(defined(&XL_NETDIAG_UPPER_BYTES_ENABLE)) {
    sub XL_NETDIAG_UPPER_BYTES_ENABLE () {	0x0040;}
}
unless(defined(&XL_NETDIAG_STATS_ENABLED)) {
    sub XL_NETDIAG_STATS_ENABLED () {	0x0080;}
}
unless(defined(&XL_NETDIAG_TX_FATALERR)) {
    sub XL_NETDIAG_TX_FATALERR () {	0x0100;}
}
unless(defined(&XL_NETDIAG_TRANSMITTING)) {
    sub XL_NETDIAG_TRANSMITTING () {	0x0200;}
}
unless(defined(&XL_NETDIAG_RX_ENABLED)) {
    sub XL_NETDIAG_RX_ENABLED () {	0x0400;}
}
unless(defined(&XL_NETDIAG_TX_ENABLED)) {
    sub XL_NETDIAG_TX_ENABLED () {	0x0800;}
}
unless(defined(&XL_NETDIAG_FIFO_LOOPBACK)) {
    sub XL_NETDIAG_FIFO_LOOPBACK () {	0x1000;}
}
unless(defined(&XL_NETDIAG_MAC_LOOPBACK)) {
    sub XL_NETDIAG_MAC_LOOPBACK () {	0x2000;}
}
unless(defined(&XL_NETDIAG_ENDEC_LOOPBACK)) {
    sub XL_NETDIAG_ENDEC_LOOPBACK () {	0x4000;}
}
unless(defined(&XL_NETDIAG_EXTERNAL_LOOP)) {
    sub XL_NETDIAG_EXTERNAL_LOOP () {	0x8000;}
}
unless(defined(&XL_W5_STAT_ENB)) {
    sub XL_W5_STAT_ENB () {	0x0c;}
}
unless(defined(&XL_W5_INTR_ENB)) {
    sub XL_W5_INTR_ENB () {	0x0a;}
}
unless(defined(&XL_W5_RECLAIM_THRESH)) {
    sub XL_W5_RECLAIM_THRESH () {	0x09;}
}
unless(defined(&XL_W5_RX_FILTER)) {
    sub XL_W5_RX_FILTER () {	0x08;}
}
unless(defined(&XL_W5_RX_EARLYTHRESH)) {
    sub XL_W5_RX_EARLYTHRESH () {	0x06;}
}
unless(defined(&XL_W5_TX_AVAILTHRESH)) {
    sub XL_W5_TX_AVAILTHRESH () {	0x02;}
}
unless(defined(&XL_W5_TX_STARTTHRESH)) {
    sub XL_W5_TX_STARTTHRESH () {	0x00;}
}
unless(defined(&XL_RXFILTER_INDIVIDUAL)) {
    sub XL_RXFILTER_INDIVIDUAL () {	0x01;}
}
unless(defined(&XL_RXFILTER_ALLMULTI)) {
    sub XL_RXFILTER_ALLMULTI () {	0x02;}
}
unless(defined(&XL_RXFILTER_BROADCAST)) {
    sub XL_RXFILTER_BROADCAST () {	0x04;}
}
unless(defined(&XL_RXFILTER_ALLFRAMES)) {
    sub XL_RXFILTER_ALLFRAMES () {	0x08;}
}
unless(defined(&XL_RXFILTER_MULTIHASH)) {
    sub XL_RXFILTER_MULTIHASH () {	0x10;}
}
unless(defined(&XL_W6_TX_BYTES_OK)) {
    sub XL_W6_TX_BYTES_OK () {	0x0c;}
}
unless(defined(&XL_W6_RX_BYTES_OK)) {
    sub XL_W6_RX_BYTES_OK () {	0x0a;}
}
unless(defined(&XL_W6_UPPER_FRAMES_OK)) {
    sub XL_W6_UPPER_FRAMES_OK () {	0x09;}
}
unless(defined(&XL_W6_DEFERRED)) {
    sub XL_W6_DEFERRED () {	0x08;}
}
unless(defined(&XL_W6_RX_OK)) {
    sub XL_W6_RX_OK () {	0x07;}
}
unless(defined(&XL_W6_TX_OK)) {
    sub XL_W6_TX_OK () {	0x06;}
}
unless(defined(&XL_W6_RX_OVERRUN)) {
    sub XL_W6_RX_OVERRUN () {	0x05;}
}
unless(defined(&XL_W6_COL_LATE)) {
    sub XL_W6_COL_LATE () {	0x04;}
}
unless(defined(&XL_W6_COL_SINGLE)) {
    sub XL_W6_COL_SINGLE () {	0x03;}
}
unless(defined(&XL_W6_COL_MULTIPLE)) {
    sub XL_W6_COL_MULTIPLE () {	0x02;}
}
unless(defined(&XL_W6_SQE_ERRORS)) {
    sub XL_W6_SQE_ERRORS () {	0x01;}
}
unless(defined(&XL_W6_CARRIER_LOST)) {
    sub XL_W6_CARRIER_LOST () {	0x00;}
}
unless(defined(&XL_W7_BM_ADDR)) {
    sub XL_W7_BM_ADDR () {	0x00;}
}
unless(defined(&XL_W7_BM_LEN)) {
    sub XL_W7_BM_LEN () {	0x06;}
}
unless(defined(&XL_W7_BM_STATUS)) {
    sub XL_W7_BM_STATUS () {	0x0b;}
}
unless(defined(&XL_W7_BM_TIMEr)) {
    sub XL_W7_BM_TIMEr () {	0x0a;}
}
unless(defined(&XL_BM_PKTSTAT)) {
    sub XL_BM_PKTSTAT () {	0x20;}
}
unless(defined(&XL_BM_DOWNLISTPTR)) {
    sub XL_BM_DOWNLISTPTR () {	0x24;}
}
unless(defined(&XL_BM_FRAGADDR)) {
    sub XL_BM_FRAGADDR () {	0x28;}
}
unless(defined(&XL_BM_FRAGLEN)) {
    sub XL_BM_FRAGLEN () {	0x2c;}
}
unless(defined(&XL_BM_TXFREETHRESH)) {
    sub XL_BM_TXFREETHRESH () {	0x2f;}
}
unless(defined(&XL_BM_UPPKTSTAT)) {
    sub XL_BM_UPPKTSTAT () {	0x30;}
}
unless(defined(&XL_BM_UPLISTPTR)) {
    sub XL_BM_UPLISTPTR () {	0x38;}
}
unless(defined(&XL_LAST_FRAG)) {
    sub XL_LAST_FRAG () {	0x80000000;}
}
unless(defined(&XL_MAXFRAGS)) {
    sub XL_MAXFRAGS () {	63;}
}
unless(defined(&XL_RX_LIST_CNT)) {
    sub XL_RX_LIST_CNT () {	32;}
}
unless(defined(&XL_TX_LIST_CNT)) {
    sub XL_TX_LIST_CNT () {	32;}
}
unless(defined(&XL_MIN_FRAMELEN)) {
    sub XL_MIN_FRAMELEN () {	60;}
}
unless(defined(&XL_INC)) {
    sub XL_INC {
	local($x, $y) = @_;
	eval q(($x) = ($x + 1) % ($y));
    }
}
unless(defined(&XL_RXSTAT_LENMASK)) {
    sub XL_RXSTAT_LENMASK () {	0x00001fff;}
}
unless(defined(&XL_RXSTAT_UP_ERROR)) {
    sub XL_RXSTAT_UP_ERROR () {	0x00004000;}
}
unless(defined(&XL_RXSTAT_UP_CMPLT)) {
    sub XL_RXSTAT_UP_CMPLT () {	0x00008000;}
}
unless(defined(&XL_RXSTAT_UP_OVERRUN)) {
    sub XL_RXSTAT_UP_OVERRUN () {	0x00010000;}
}
unless(defined(&XL_RXSTAT_RUNT)) {
    sub XL_RXSTAT_RUNT () {	0x00020000;}
}
unless(defined(&XL_RXSTAT_ALIGN)) {
    sub XL_RXSTAT_ALIGN () {	0x00040000;}
}
unless(defined(&XL_RXSTAT_CRC)) {
    sub XL_RXSTAT_CRC () {	0x00080000;}
}
unless(defined(&XL_RXSTAT_OVERSIZE)) {
    sub XL_RXSTAT_OVERSIZE () {	0x00100000;}
}
unless(defined(&XL_RXSTAT_DRIBBLE)) {
    sub XL_RXSTAT_DRIBBLE () {	0x00800000;}
}
unless(defined(&XL_RXSTAT_UP_OFLOW)) {
    sub XL_RXSTAT_UP_OFLOW () {	0x01000000;}
}
unless(defined(&XL_RXSTAT_IPCKERR)) {
    sub XL_RXSTAT_IPCKERR () {	0x02000000;}
}
unless(defined(&XL_RXSTAT_TCPCKERR)) {
    sub XL_RXSTAT_TCPCKERR () {	0x04000000;}
}
unless(defined(&XL_RXSTAT_UDPCKERR)) {
    sub XL_RXSTAT_UDPCKERR () {	0x08000000;}
}
unless(defined(&XL_RXSTAT_BUFEN)) {
    sub XL_RXSTAT_BUFEN () {	0x10000000;}
}
unless(defined(&XL_RXSTAT_IPCKOK)) {
    sub XL_RXSTAT_IPCKOK () {	0x20000000;}
}
unless(defined(&XL_RXSTAT_TCPCOK)) {
    sub XL_RXSTAT_TCPCOK () {	0x40000000;}
}
unless(defined(&XL_RXSTAT_UDPCKOK)) {
    sub XL_RXSTAT_UDPCKOK () {	0x80000000;}
}
unless(defined(&XL_TXSTAT_LENMASK)) {
    sub XL_TXSTAT_LENMASK () {	0x00001fff;}
}
unless(defined(&XL_TXSTAT_CRCDIS)) {
    sub XL_TXSTAT_CRCDIS () {	0x00002000;}
}
unless(defined(&XL_TXSTAT_TX_INTR)) {
    sub XL_TXSTAT_TX_INTR () {	0x00008000;}
}
unless(defined(&XL_TXSTAT_DL_COMPLETE)) {
    sub XL_TXSTAT_DL_COMPLETE () {	0x00010000;}
}
unless(defined(&XL_TXSTAT_IPCKSUM)) {
    sub XL_TXSTAT_IPCKSUM () {	0x02000000;}
}
unless(defined(&XL_TXSTAT_TCPCKSUM)) {
    sub XL_TXSTAT_TCPCKSUM () {	0x04000000;}
}
unless(defined(&XL_TXSTAT_UDPCKSUM)) {
    sub XL_TXSTAT_UDPCKSUM () {	0x08000000;}
}
unless(defined(&XL_TXSTAT_RND_DEFEAT)) {
    sub XL_TXSTAT_RND_DEFEAT () {	0x10000000;}
}
unless(defined(&XL_TXSTAT_EMPTY)) {
    sub XL_TXSTAT_EMPTY () {	0x20000000;}
}
unless(defined(&XL_TXSTAT_DL_INTR)) {
    sub XL_TXSTAT_DL_INTR () {	0x80000000;}
}
unless(defined(&XL_CAPABILITY_BM)) {
    sub XL_CAPABILITY_BM () {	0x20;}
}
unless(defined(&XL_MII_STARTDELIM)) {
    sub XL_MII_STARTDELIM () {	0x01;}
}
unless(defined(&XL_MII_READOP)) {
    sub XL_MII_READOP () {	0x02;}
}
unless(defined(&XL_MII_WRITEOP)) {
    sub XL_MII_WRITEOP () {	0x01;}
}
unless(defined(&XL_MII_TURNAROUND)) {
    sub XL_MII_TURNAROUND () {	0x02;}
}
unless(defined(&XL_TYPE_905B)) {
    sub XL_TYPE_905B () {	1;}
}
unless(defined(&XL_TYPE_90X)) {
    sub XL_TYPE_90X () {	2;}
}
unless(defined(&XL_FLAG_FUNCREG)) {
    sub XL_FLAG_FUNCREG () {	0x0001;}
}
unless(defined(&XL_FLAG_PHYOK)) {
    sub XL_FLAG_PHYOK () {	0x0002;}
}
unless(defined(&XL_FLAG_EEPROM_OFFSET_30)) {
    sub XL_FLAG_EEPROM_OFFSET_30 () {	0x0004;}
}
unless(defined(&XL_FLAG_WEIRDRESET)) {
    sub XL_FLAG_WEIRDRESET () {	0x0008;}
}
unless(defined(&XL_FLAG_8BITROM)) {
    sub XL_FLAG_8BITROM () {	0x0010;}
}
unless(defined(&XL_FLAG_INVERT_LED_PWR)) {
    sub XL_FLAG_INVERT_LED_PWR () {	0x0020;}
}
unless(defined(&XL_FLAG_INVERT_MII_PWR)) {
    sub XL_FLAG_INVERT_MII_PWR () {	0x0040;}
}
unless(defined(&xl_rx_goodframes)) {
    sub xl_rx_goodframes {
	local($x) = @_;
	eval q((( ($x->{xl_upper_frames_ok}) & 0x03) << 8) |  ($x->{xl_rx_frames_ok}));
    }
}
unless(defined(&xl_tx_goodframes)) {
    sub xl_tx_goodframes {
	local($x) = @_;
	eval q((( ($x->{xl_upper_frames_ok}) & 0x30) << 4) |  ($x->{xl_tx_frames_ok}));
    }
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{xl_btag}),  ($sc->{xl_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{xl_btag}),  ($sc->{xl_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{xl_btag}),  ($sc->{xl_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{xl_btag}),  ($sc->{xl_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{xl_btag}),  ($sc->{xl_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{xl_btag}),  ($sc->{xl_bhandle}), $reg));
    }
}
unless(defined(&XL_SEL_WIN)) {
    sub XL_SEL_WIN {
	local($x) = @_;
	eval q( &CSR_WRITE_2( &sc,  &XL_COMMAND,  &XL_CMD_WINSEL | $x));
    }
}
unless(defined(&XL_TIMEOUT)) {
    sub XL_TIMEOUT () {	1000;}
}
unless(defined(&TC_VENDORID)) {
    sub TC_VENDORID () {	0x10b7;}
}
unless(defined(&TC_DEVICEID_TORNADO_HOMECONNECT)) {
    sub TC_DEVICEID_TORNADO_HOMECONNECT () {	0x4500;}
}
unless(defined(&TC_DEVICEID_HURRICANE_555)) {
    sub TC_DEVICEID_HURRICANE_555 () {	0x5055;}
}
unless(defined(&TC_DEVICEID_HURRICANE_556)) {
    sub TC_DEVICEID_HURRICANE_556 () {	0x6055;}
}
unless(defined(&TC_DEVICEID_HURRICANE_556B)) {
    sub TC_DEVICEID_HURRICANE_556B () {	0x6056;}
}
unless(defined(&TC_DEVICEID_BOOMERANG_10BT)) {
    sub TC_DEVICEID_BOOMERANG_10BT () {	0x9000;}
}
unless(defined(&TC_DEVICEID_BOOMERANG_10BT_COMBO)) {
    sub TC_DEVICEID_BOOMERANG_10BT_COMBO () {	0x9001;}
}
unless(defined(&TC_DEVICEID_BOOMERANG_10_100BT)) {
    sub TC_DEVICEID_BOOMERANG_10_100BT () {	0x9050;}
}
unless(defined(&TC_DEVICEID_BOOMERANG_100BT4)) {
    sub TC_DEVICEID_BOOMERANG_100BT4 () {	0x9051;}
}
unless(defined(&TC_DEVICEID_KRAKATOA_10BT)) {
    sub TC_DEVICEID_KRAKATOA_10BT () {	0x9004;}
}
unless(defined(&TC_DEVICEID_KRAKATOA_10BT_COMBO)) {
    sub TC_DEVICEID_KRAKATOA_10BT_COMBO () {	0x9005;}
}
unless(defined(&TC_DEVICEID_KRAKATOA_10BT_TPC)) {
    sub TC_DEVICEID_KRAKATOA_10BT_TPC () {	0x9006;}
}
unless(defined(&TC_DEVICEID_CYCLONE_10FL)) {
    sub TC_DEVICEID_CYCLONE_10FL () {	0x900a;}
}
unless(defined(&TC_DEVICEID_HURRICANE_10_100BT)) {
    sub TC_DEVICEID_HURRICANE_10_100BT () {	0x9055;}
}
unless(defined(&TC_DEVICEID_CYCLONE_10_100BT4)) {
    sub TC_DEVICEID_CYCLONE_10_100BT4 () {	0x9056;}
}
unless(defined(&TC_DEVICEID_CYCLONE_10_100_COMBO)) {
    sub TC_DEVICEID_CYCLONE_10_100_COMBO () {	0x9058;}
}
unless(defined(&TC_DEVICEID_CYCLONE_10_100FX)) {
    sub TC_DEVICEID_CYCLONE_10_100FX () {	0x905a;}
}
unless(defined(&TC_DEVICEID_TORNADO_10_100BT)) {
    sub TC_DEVICEID_TORNADO_10_100BT () {	0x9200;}
}
unless(defined(&TC_DEVICEID_HURRICANE_10_100BT_SERV)) {
    sub TC_DEVICEID_HURRICANE_10_100BT_SERV () {	0x9800;}
}
unless(defined(&TC_DEVICEID_TORNADO_10_100BT_SERV)) {
    sub TC_DEVICEID_TORNADO_10_100BT_SERV () {	0x9805;}
}
unless(defined(&TC_DEVICEID_HURRICANE_SOHO100TX)) {
    sub TC_DEVICEID_HURRICANE_SOHO100TX () {	0x7646;}
}
unless(defined(&TC_DEVICEID_3C575_CARDBUS)) {
    sub TC_DEVICEID_3C575_CARDBUS () {	0x5057;}
}
unless(defined(&TC_DEVICEID_3CCFE575BT_CARDBUS)) {
    sub TC_DEVICEID_3CCFE575BT_CARDBUS () {	0x5157;}
}
unless(defined(&TC_DEVICEID_3CCFE575CT_CARDBUS)) {
    sub TC_DEVICEID_3CCFE575CT_CARDBUS () {	0x5257;}
}
unless(defined(&TC_DEVICEID_3CCFEM656_CARDBUS)) {
    sub TC_DEVICEID_3CCFEM656_CARDBUS () {	0x6560;}
}
unless(defined(&TC_DEVICEID_3CCFEM656B_CARDBUS)) {
    sub TC_DEVICEID_3CCFEM656B_CARDBUS () {	0x6562;}
}
unless(defined(&TC_DEVICEID_3CCFEM656C_CARDBUS)) {
    sub TC_DEVICEID_3CCFEM656C_CARDBUS () {	0x6564;}
}
unless(defined(&XL_CARDBUS_INTR)) {
    sub XL_CARDBUS_INTR () {	0x0004;}
}
unless(defined(&XL_CARDBUS_INTR_ACK)) {
    sub XL_CARDBUS_INTR_ACK () {	0x8000;}
}
unless(defined(&XL_PCI_VENDOR_ID)) {
    sub XL_PCI_VENDOR_ID () {	0x00;}
}
unless(defined(&XL_PCI_DEVICE_ID)) {
    sub XL_PCI_DEVICE_ID () {	0x02;}
}
unless(defined(&XL_PCI_COMMAND)) {
    sub XL_PCI_COMMAND () {	0x04;}
}
unless(defined(&XL_PCI_STATUS)) {
    sub XL_PCI_STATUS () {	0x06;}
}
unless(defined(&XL_PCI_CLASSCODE)) {
    sub XL_PCI_CLASSCODE () {	0x09;}
}
unless(defined(&XL_PCI_LATENCY_TIMER)) {
    sub XL_PCI_LATENCY_TIMER () {	0x0d;}
}
unless(defined(&XL_PCI_HEADER_TYPE)) {
    sub XL_PCI_HEADER_TYPE () {	0x0e;}
}
unless(defined(&XL_PCI_LOIO)) {
    sub XL_PCI_LOIO () {	0x10;}
}
unless(defined(&XL_PCI_LOMEM)) {
    sub XL_PCI_LOMEM () {	0x14;}
}
unless(defined(&XL_PCI_BIOSROM)) {
    sub XL_PCI_BIOSROM () {	0x30;}
}
unless(defined(&XL_PCI_INTLINE)) {
    sub XL_PCI_INTLINE () {	0x3c;}
}
unless(defined(&XL_PCI_INTPIN)) {
    sub XL_PCI_INTPIN () {	0x3d;}
}
unless(defined(&XL_PCI_MINGNT)) {
    sub XL_PCI_MINGNT () {	0x3e;}
}
unless(defined(&XL_PCI_MINLAT)) {
    sub XL_PCI_MINLAT () {	0x0f;}
}
unless(defined(&XL_PCI_RESETOPT)) {
    sub XL_PCI_RESETOPT () {	0x48;}
}
unless(defined(&XL_PCI_EEPROM_DATA)) {
    sub XL_PCI_EEPROM_DATA () {	0x4c;}
}
unless(defined(&XL_PCI_CAPID)) {
    sub XL_PCI_CAPID () {	0xdc;}
}
unless(defined(&XL_PCI_NEXTPTR)) {
    sub XL_PCI_NEXTPTR () {	0xdd;}
}
unless(defined(&XL_PCI_PWRMGMTCAP)) {
    sub XL_PCI_PWRMGMTCAP () {	0xde;}
}
unless(defined(&XL_PCI_PWRMGMTCTRL)) {
    sub XL_PCI_PWRMGMTCTRL () {	0xe0;}
}
unless(defined(&XL_PSTATE_MASK)) {
    sub XL_PSTATE_MASK () {	0x0003;}
}
unless(defined(&XL_PSTATE_D0)) {
    sub XL_PSTATE_D0 () {	0x0000;}
}
unless(defined(&XL_PSTATE_D1)) {
    sub XL_PSTATE_D1 () {	0x0002;}
}
unless(defined(&XL_PSTATE_D2)) {
    sub XL_PSTATE_D2 () {	0x0002;}
}
unless(defined(&XL_PSTATE_D3)) {
    sub XL_PSTATE_D3 () {	0x0003;}
}
unless(defined(&XL_PME_EN)) {
    sub XL_PME_EN () {	0x0010;}
}
unless(defined(&XL_PME_STATUS)) {
    sub XL_PME_STATUS () {	0x8000;}
}
if(defined(&__alpha__)) {
    undef(&vtophys) if defined(&vtophys);
    eval 'sub vtophys {
        local($va) = @_;
	    eval q( &alpha_XXX_dmamap($va));
    }' unless defined(&vtophys);
}
unless(defined(&ETHER_ALIGN)) {
    eval 'sub ETHER_ALIGN () {2;}' unless defined(&ETHER_ALIGN);
}
1;
