require '_h2ph_pre.ph';

if(defined(&_KERNEL)) {
    if(defined(&_LOCORE)) {
	require 'machine/psl.ph';
    } else {
	require 'machine/cpu.ph';
    }
}
unless(defined(&_MACHINE)) {
    sub _MACHINE () {	 &i386;}
}
unless(defined(&MACHINE)) {
    sub MACHINE () {	"i386";}
}
unless(defined(&_MACHINE_ARCH)) {
    sub _MACHINE_ARCH () {	 &i386;}
}
unless(defined(&MACHINE_ARCH)) {
    sub MACHINE_ARCH () {	"i386";}
}
unless(defined(&MID_MACHINE)) {
    sub MID_MACHINE () {	 &MID_I386;}
}
unless(defined(&ALIGNBYTES)) {
    sub ALIGNBYTES () {	($sizeof{'int'} - 1);}
}
unless(defined(&ALIGN)) {
    sub ALIGN {
	local($p) = @_;
	eval q(((($p) +  &ALIGNBYTES) &~  &ALIGNBYTES));
    }
}
unless(defined(&PGSHIFT)) {
    sub PGSHIFT () {	12;}
}
unless(defined(&NBPG)) {
    sub NBPG () {	(1<<  &PGSHIFT);}
}
unless(defined(&PGOFSET)) {
    sub PGOFSET () {	( &NBPG-1);}
}
unless(defined(&PAGE_SHIFT)) {
    sub PAGE_SHIFT () {	12;}
}
unless(defined(&PAGE_SIZE)) {
    sub PAGE_SIZE () {	(1<<  &PAGE_SHIFT);}
}
unless(defined(&PAGE_MASK)) {
    sub PAGE_MASK () {	( &PAGE_SIZE - 1);}
}
unless(defined(&NPTEPG)) {
    sub NPTEPG () {	( &NBPG/($sizeof{ &pt_entry_t}));}
}
unless(defined(&KERNBASE)) {
    sub KERNBASE () {	0xe0000000;}
}
unless(defined(&KERNTEXTOFF)) {
    sub KERNTEXTOFF () {	( &KERNBASE+0x100000);}
}
unless(defined(&BTOPKERNBASE)) {
    sub BTOPKERNBASE () {	( &KERNBASE >>  &PGSHIFT);}
}
unless(defined(&DEV_BSHIFT)) {
    sub DEV_BSHIFT () {	9;}
}
unless(defined(&DEV_BSIZE)) {
    sub DEV_BSIZE () {	(1<<  &DEV_BSHIFT);}
}
unless(defined(&BLKDEV_IOSIZE)) {
    sub BLKDEV_IOSIZE () {	2048;}
}
unless(defined(&MAXPHYS)) {
    eval 'sub MAXPHYS () {(64* 1024);}' unless defined(&MAXPHYS);
}
unless(defined(&SSIZE)) {
    sub SSIZE () {	1;}
}
unless(defined(&SINCR)) {
    sub SINCR () {	1;}
}
unless(defined(&UPAGES)) {
    sub UPAGES () {	2;}
}
unless(defined(&USPACE)) {
    sub USPACE () {	( &UPAGES *  &NBPG);}
}
unless(defined(&MSGBUFSIZE)) {
    eval 'sub MSGBUFSIZE () {2* &NBPG;}' unless defined(&MSGBUFSIZE);
}
unless(defined(&MSIZE)) {
    sub MSIZE () {	256;}
}
unless(defined(&MCLSHIFT)) {
    sub MCLSHIFT () {	11;}
}
unless(defined(&MCLBYTES)) {
    sub MCLBYTES () {	(1<<  &MCLSHIFT);}
}
unless(defined(&MCLOFSET)) {
    sub MCLOFSET () {	( &MCLBYTES - 1);}
}
unless(defined(&NMBCLUSTERS)) {
    eval 'sub NMBCLUSTERS () {2048;}' unless defined(&NMBCLUSTERS);
}
unless(defined(&NKMEMPAGES_MIN_DEFAULT)) {
    sub NKMEMPAGES_MIN_DEFAULT () {	((8* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&NKMEMPAGES_MAX_DEFAULT)) {
    sub NKMEMPAGES_MAX_DEFAULT () {	((64* 1024* 1024) >>  &PAGE_SHIFT);}
}
unless(defined(&ctod)) {
    sub ctod {
	local($x) = @_;
	eval q((($x) << ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&dtoc)) {
    sub dtoc {
	local($x) = @_;
	eval q((($x) >> ( &PGSHIFT -  &DEV_BSHIFT)));
    }
}
unless(defined(&ctob)) {
    sub ctob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
unless(defined(&btoc)) {
    sub btoc {
	local($x) = @_;
	eval q(((($x) +  &PGOFSET) >>  &PGSHIFT));
    }
}
unless(defined(&dbtob)) {
    sub dbtob {
	local($x) = @_;
	eval q((($x) <<  &DEV_BSHIFT));
    }
}
unless(defined(&btodb)) {
    sub btodb {
	local($x) = @_;
	eval q((($x) >>  &DEV_BSHIFT));
    }
}
unless(defined(&bdbtofsb)) {
    sub bdbtofsb {
	local($bn) = @_;
	eval q((($bn) / ( &BLKDEV_IOSIZE /  &DEV_BSIZE)));
    }
}
unless(defined(&i386_round_pdr)) {
    sub i386_round_pdr {
	local($x) = @_;
	eval q((((($x)) +  &PDOFSET) & ~ &PDOFSET));
    }
}
unless(defined(&i386_trunc_pdr)) {
    sub i386_trunc_pdr {
	local($x) = @_;
	eval q((($x) & ~ &PDOFSET));
    }
}
unless(defined(&i386_btod)) {
    sub i386_btod {
	local($x) = @_;
	eval q((($x) >>  &PDSHIFT));
    }
}
unless(defined(&i386_dtob)) {
    sub i386_dtob {
	local($x) = @_;
	eval q((($x) <<  &PDSHIFT));
    }
}
unless(defined(&i386_round_page)) {
    sub i386_round_page {
	local($x) = @_;
	eval q((((($x)) +  &PGOFSET) & ~ &PGOFSET));
    }
}
unless(defined(&i386_trunc_page)) {
    sub i386_trunc_page {
	local($x) = @_;
	eval q((($x) & ~ &PGOFSET));
    }
}
unless(defined(&i386_btop)) {
    sub i386_btop {
	local($x) = @_;
	eval q((($x) >>  &PGSHIFT));
    }
}
unless(defined(&i386_ptob)) {
    sub i386_ptob {
	local($x) = @_;
	eval q((($x) <<  &PGSHIFT));
    }
}
1;
