require '_h2ph_pre.ph';

unless(defined(&_DEV_ISA_ISAVAR_H_)) {
    eval 'sub _DEV_ISA_ISAVAR_H_ () {1;}' unless defined(&_DEV_ISA_ISAVAR_H_);
    require 'sys/queue.ph';
    require 'machine/bus.ph';
    unless(defined(&NISADMA)) {
	require 'isadma.ph';
    }
    if(((defined(&__alpha__) ? &__alpha__ : 0) + (defined(&amiga) ? &amiga : 0) + (defined(&__i386__) ? &__i386__ : 0) + (defined(&arc) ? &arc : 0) + (defined(&__wgrisc__) ? &__wgrisc__ : 0) + (defined(&__powerpc__) ? &__powerpc__ : 0) + (defined(&__hppa__) ? &__hppa__ : 0) != 1)) {
	die("COMPILING ISA FOR UNSUPPORTED MACHINE, OR MORE THAN ONE.");
    }
    if(defined(&__alpha__)) {
	require 'alpha/isa/isa_machdep.ph';
    }
    if(defined(&amiga)) {
	require 'amiga/isa/isa_machdep.ph';
    }
    if(defined(&__i386__)) {
	require 'i386/isa/isa_machdep.ph';
    }
    if(defined(&arc)) {
	require 'arc/isa/isa_machdep.ph';
    }
    if(defined(&__wgrisc__)) {
	require 'wgrisc/isa/isa_machdep.ph';
    }
    if(defined(&__powerpc__)) {
	if(defined(&__mvmeppc__)) {
	    require 'mvmeppc/isa/isa_machdep.ph';
	} else {
	    require 'powerpc/isa/isa_machdep.ph';
	}
    }
    if(defined(&__hppa__)) {
	require 'hppa/isa/isa_machdep.ph';
    }
    require 'isapnp.ph';
    if((defined(&NISAPNP) ? &NISAPNP : 0) > 0) {
	if(((defined(&__i386__) ? &__i386__ : 0) != 1 && (defined(&__alpha__) ? &__alpha__ : 0) != 1)) {
	}
	if((defined(&__i386__) ? &__i386__ : 0)) {
	    require 'i386/isa/isapnp_machdep.ph';
	}
	if((defined(&__alpha__) ? &__alpha__ : 0)) {
	    require 'alpha/isa/isapnp_machdep.ph';
	}
    }
    eval 'sub ISAPNP_WRITE_ADDR {
        local($sc, $v) = @_;
	    eval q( &bus_space_write_1( ($sc->{sc_iot}),  ($sc->{sc_addr_ioh}), 0, $v));
    }' unless defined(&ISAPNP_WRITE_ADDR);
    eval 'sub ISAPNP_WRITE_DATA {
        local($sc, $v) = @_;
	    eval q( &bus_space_write_1( ($sc->{sc_iot}),  ($sc->{sc_wrdata_ioh}), 0, $v));
    }' unless defined(&ISAPNP_WRITE_DATA);
    eval 'sub ISAPNP_READ_DATA {
        local($sc) = @_;
	    eval q( &bus_space_read_1( ($sc->{sc_iot}),  ($sc->{sc_read_ioh}), 0));
    }' unless defined(&ISAPNP_READ_DATA);
    eval 'sub ISAPNP_MALLOC {
        local($a) = @_;
	    eval q( &malloc($a,  &M_DEVBUF,  &M_WAITOK));
    }' unless defined(&ISAPNP_MALLOC);
    eval 'sub ISAPNP_FREE {
        local($a) = @_;
	    eval q( &free($a,  &M_DEVBUF));
    }' unless defined(&ISAPNP_FREE);
    unless(defined(&_DEV_ISA_ISAPNPREG_H_)) {
	eval 'sub ISAPNP_MAX_CARDS () {8;}' unless defined(&ISAPNP_MAX_CARDS);
	eval 'sub ISAPNP_MAX_IDENT () {32;}' unless defined(&ISAPNP_MAX_IDENT);
	eval 'sub ISAPNP_MAX_DEVCLASS () {16;}' unless defined(&ISAPNP_MAX_DEVCLASS);
	eval 'sub ISAPNP_SERIAL_SIZE () {9;}' unless defined(&ISAPNP_SERIAL_SIZE);
	eval 'sub ISAPNP_NUM_MEM () {4;}' unless defined(&ISAPNP_NUM_MEM);
	eval 'sub ISAPNP_NUM_IO () {8;}' unless defined(&ISAPNP_NUM_IO);
	eval 'sub ISAPNP_NUM_IRQ () {16;}' unless defined(&ISAPNP_NUM_IRQ);
	eval 'sub ISAPNP_NUM_DRQ () {8;}' unless defined(&ISAPNP_NUM_DRQ);
	eval 'sub ISAPNP_NUM_MEM32 () {4;}' unless defined(&ISAPNP_NUM_MEM32);
    }
    if((defined(&NISADMA) ? &NISADMA : 0) > 0) {
    }
    if((defined(&NISADMA) ? &NISADMA : 0) > 0) {
    }
    if((defined(&NISADMA) ? &NISADMA : 0) > 0) {
    }
    eval 'sub ia_iobase () { ($ipa_io[0]->{base});}' unless defined(&ia_iobase);
    eval 'sub ia_iosize () { ($ipa_io[0]->{length});}' unless defined(&ia_iosize);
    eval 'sub ia_ioh () { ($ipa_io[0]->{h});}' unless defined(&ia_ioh);
    eval 'sub ia_irq () { ($ipa_irq[0]->{num});}' unless defined(&ia_irq);
    eval 'sub ia_drq () { ($ipa_drq[0]->{num});}' unless defined(&ia_drq);
    eval 'sub ia_drq2 () { ($ipa_drq[1]->{num});}' unless defined(&ia_drq2);
    eval 'sub ia_maddr () { ($ipa_mem[0]->{base});}' unless defined(&ia_maddr);
    eval 'sub ia_msize () { ($ipa_mem[0]->{length});}' unless defined(&ia_msize);
    eval 'sub ia_memh () { ($ipa_mem[0]->{h});}' unless defined(&ia_memh);
    eval 'sub IOBASEUNK () {-1;}' unless defined(&IOBASEUNK);
    eval 'sub IRQUNK () {-1;}' unless defined(&IRQUNK);
    eval 'sub DRQUNK () {-1;}' unless defined(&DRQUNK);
    eval 'sub MADDRUNK () {-1;}' unless defined(&MADDRUNK);
    if((defined(&NISADMA) ? &NISADMA : 0) > 0) {
    }
    if((defined(&NISADMA) ? &NISADMA : 0) > 0) {
	eval 'sub sc_drq () { &sc_drqmap;}' unless defined(&sc_drq);
    }
    eval 'sub ISA_DRQ_ISFREE {
        local($isadev, $drq) = @_;
	    eval q((((($isadev))-> &sc_drqmap & (1<< ($drq))) == 0));
    }' unless defined(&ISA_DRQ_ISFREE);
    eval 'sub ISA_DRQ_ALLOC {
        local($isadev, $drq) = @_;
	    eval q((($isadev))-> &sc_drqmap |= (1<< ($drq)));
    }' unless defined(&ISA_DRQ_ALLOC);
    eval 'sub ISA_DRQ_FREE {
        local($isadev, $drq) = @_;
	    eval q((($isadev))-> &sc_drqmap &= ~(1<< ($drq)));
    }' unless defined(&ISA_DRQ_FREE);
    eval 'sub cf_iobase () { $cf_loc[0];}' unless defined(&cf_iobase);
    eval 'sub cf_iosize () { $cf_loc[1];}' unless defined(&cf_iosize);
    eval 'sub cf_maddr () { $cf_loc[2];}' unless defined(&cf_maddr);
    eval 'sub cf_msize () { $cf_loc[3];}' unless defined(&cf_msize);
    eval 'sub cf_irq () { $cf_loc[4];}' unless defined(&cf_irq);
    eval 'sub cf_drq () { $cf_loc[5];}' unless defined(&cf_drq);
    eval 'sub cf_drq2 () { $cf_loc[6];}' unless defined(&cf_drq2);
    eval 'sub ISABUS_DMA_32BIT () { &BUS_DMA_BUS1;}' unless defined(&ISABUS_DMA_32BIT);
    if(defined(&DEBUG_ISAPNP)) {
    }
}
1;
