require '_h2ph_pre.ph';

if(defined(&HAVE_CONFIG_H)) {
    require 'config.ph';
} else {
    require 'xfs/xfs_config.ph';
}
unless(defined(&RCSID)) {
    eval 'sub RCSID {
        local($x) = @_;
	    eval q();
    }' unless defined(&RCSID);
}
if(defined(&__osf__)) {
    if(defined(&__GNUC__)) {
	eval 'sub asm () { &__foo_asm;}' unless defined(&asm);
    }
    require 'sys/types.ph';
    require 'sys/errno.ph';
    require 'sys/uio.ph';
    require 'machine/cpu.ph';
    require 'sys/conf.ph';
    require 'sys/sysconfig.ph';
    require 'sys/file.ph';
    require 'sys/malloc.ph';
    require 'sys/poll.ph';
    require 'sys/ioctl.ph';
    require 'sys/fcntl.ph';
    require 'sys/vfs_proto.ph';
    require 'io/common/devdriver.ph';
    require 'vm/vm_page.ph';
    require 'vm/vm_vppage.ph';
    require 'vm/vm_ubc.ph';
    eval 'sub VT_AFS () { &VT_ADDON;}' unless defined(&VT_AFS);
    eval 'sub MOUNT_XFS () { &MOUNT_PC;}' unless defined(&MOUNT_XFS);
    if(0) {
	eval 'sub componentname () { &nameidata;}' unless defined(&componentname);
    }
    eval 'sub cn_nameptr () { &ni_ptr;}' unless defined(&cn_nameptr);
    eval 'sub cn_namelen () { &ni_namelen;}' unless defined(&cn_namelen);
    eval 'sub cn_hash () { &ni_hash;}' unless defined(&cn_hash);
    eval 'sub cn_cred () { &ni_cred;}' unless defined(&cn_cred);
    eval 'sub cn_nameiop () { &ni_nameiop;}' unless defined(&cn_nameiop);
    eval 'sub cn_flags () { &ni_flags;}' unless defined(&cn_flags);
    eval 'sub mnt_stat () { &m_stat;}' unless defined(&mnt_stat);
    eval 'sub mnt_flag () { &m_flag;}' unless defined(&mnt_flag);
    eval 'sub NDINIT {
        local($ndp, $op, $flags, $segflg, $namep, $p) = @_;
	    eval q(($ndp)-> &ni_nameiop = ($op) | ($flags); ($ndp)-> &ni_segflg = $segflg; ($ndp)-> &ni_dirp = $namep;);
    }' unless defined(&NDINIT);
    eval 'sub LOCKLEAF () {0;}' unless defined(&LOCKLEAF);
    eval 'sub FFLAGS {
        local($mode) = @_;
	    eval q((($mode) -  &FOPEN));
    }' unless defined(&FFLAGS);
    eval 'sub vput {
        local($VP) = @_;
	    eval q( &vrele($VP));
    }' unless defined(&vput);
    eval 'sub xfs_uio_to_proc {
        local($uiop) = @_;
	    eval q(( ($u->{u_procp})));
    }' unless defined(&xfs_uio_to_proc);
    eval 'sub xfs_cnp_to_proc {
        local($cnp) = @_;
	    eval q(( ($u->{u_procp})));
    }' unless defined(&xfs_cnp_to_proc);
    eval 'sub xfs_proc_to_cred {
        local($p) = @_;
	    eval q((($p)-> &p_rcred));
    }' unless defined(&xfs_proc_to_cred);
    eval 'sub xfs_proc_to_ruid {
        local($p) = @_;
	    eval q((($p)-> &p_ruid));
    }' unless defined(&xfs_proc_to_ruid);
    eval 'sub xfs_curproc () {
        eval q(( ($u->{u_procp})));
    }' unless defined(&xfs_curproc);
    eval 'sub xfs_vop_read () { &VOP_READ;}' unless defined(&xfs_vop_read);
    eval 'sub xfs_vop_write () { &VOP_WRITE;}' unless defined(&xfs_vop_write);
    eval 'sub xfs_vop_getattr {
        local($t, $attr, $cred, $proc, $error) = @_;
	    eval q( &VOP_GETATTR(($t), ($attr), ($cred), ($error)));
    }' unless defined(&xfs_vop_getattr);
    eval 'sub xfs_vop_access {
        local($dvp, $mode, $cred, $proc, $error) = @_;
	    eval q( &VOP_ACCESS(($dvp), ($mode), ($cred), ($error)));
    }' unless defined(&xfs_vop_access);
} else {
    require 'sys/types.ph';
    require 'sys/param.ph';
    if(0) {
	require 'sys/ioctl.ph';
    }
    require 'sys/proc.ph';
    require 'sys/filedesc.ph';
    require 'sys/kernel.ph';
    if(defined(&HAVE_SYS_MODULE_H)) {
	require 'sys/module.ph';
    }
    require 'sys/systm.ph';
    require 'sys/fcntl.ph';
    if(defined(&HAVE_SYS_SYSPROTO_H)) {
	require 'sys/sysproto.ph';
    }
    require 'sys/conf.ph';
    require 'sys/mount.ph';
    require 'sys/exec.ph';
    if(defined(&HAVE_SYS_SYSENT_H)) {
	require 'sys/sysent.ph';
    }
    if(defined(&HAVE_SYS_LKM_H)) {
	require 'sys/lkm.ph';
    }
    require 'sys/errno.ph';
    require 'sys/file.ph';
    require 'sys/namei.ph';
    require 'sys/dirent.ph';
    require 'sys/ucred.ph';
    require 'sys/select.ph';
    require 'sys/uio.ph';
    if(defined(&HAVE_SYS_POLL_H)) {
	require 'sys/poll.ph';
    }
    if(defined(&HAVE_SYS_SIGNALVAR_H)) {
	require 'sys/signalvar.ph';
    }
    require 'sys/syscall.ph';
    require 'sys/queue.ph';
    require 'sys/malloc.ph';
    if(defined(&HAVE_SYS_SYSCALLARGS_H)) {
	require 'sys/syscallargs.ph';
    }
    if(defined(&HAVE_SYS_ATTR_H)) {
	require 'sys/attr.ph';
    }
    if(defined(&HAVE_MISCFS_GENFS_GENFS_H)) {
	require 'miscfs/genfs/genfs.ph';
    }
    if(defined(&HAVE_VM_VM_H)) {
	require 'vm/vm.ph';
    }
    if(defined(&HAVE_VM_VM_EXTERN_H)) {
	require 'vm/vm_extern.ph';
    }
    if(defined(&HAVE_VM_VM_ZONE_H)) {
	require 'vm/vm_zone.ph';
    }
    if(defined(&HAVE_VM_VM_OBJECT_H)) {
	require 'vm/vm_object.ph';
    }
    if(defined(&HAVE_UVM_UVM_EXTERN_H)) {
	require 'uvm/uvm_extern.ph';
    }
    if(defined( &__APPLE__)) {
	require 'machine/machine_routines.ph';
	require 'mach/machine/vm_types.ph';
    }
    eval 'sub xfs_uio_to_proc {
        local($uiop) = @_;
	    eval q((($uiop)-> &uio_procp));
    }' unless defined(&xfs_uio_to_proc);
    eval 'sub xfs_cnp_to_proc {
        local($cnp) = @_;
	    eval q((($cnp)-> &cn_proc));
    }' unless defined(&xfs_cnp_to_proc);
    eval 'sub xfs_proc_to_cred {
        local($p) = @_;
	    eval q((($p)-> &p_ucred));
    }' unless defined(&xfs_proc_to_cred);
    eval 'sub xfs_proc_to_ruid {
        local($p) = @_;
	    eval q((($p)-> ($p_cred->{p_ruid})));
    }' unless defined(&xfs_proc_to_ruid);
    if(defined(&__APPLE__)) {
	eval 'sub xfs_curproc () {
	    eval q(( &current_proc()));
	}' unless defined(&xfs_curproc);
    } else {
	eval 'sub xfs_curproc () {
	    eval q(( &curproc));
	}' unless defined(&xfs_curproc);
    }
    eval 'sub xfs_vop_read {
        local($t, $uio, $ioflag, $cred, $error) = @_;
	    eval q(($error) =  &VOP_READ(($t), ($uio), ($ioflag), ($cred)));
    }' unless defined(&xfs_vop_read);
    eval 'sub xfs_vop_write {
        local($t, $uio, $ioflag, $cred, $error) = @_;
	    eval q(($error) =  &VOP_WRITE(($t), ($uio), ($ioflag), ($cred)));
    }' unless defined(&xfs_vop_write);
    eval 'sub xfs_vop_getattr {
        local($t, $attr, $cred, $proc, $error) = @_;
	    eval q(($error) =  &VOP_GETATTR(($t), ($attr), ($cred), ($proc)));
    }' unless defined(&xfs_vop_getattr);
    eval 'sub xfs_vop_access {
        local($dvp, $mode, $cred, $proc, $error) = @_;
	    eval q(($error) =  &VOP_ACCESS(($dvp), ($mode), ($cred), ($proc)));
    }' unless defined(&xfs_vop_access);
}
unless(defined(&SCARG)) {
    eval 'sub SCARG {
        local($a, $b) = @_;
	    eval q((($a)-> ($b->{d$atum})));
    }' unless defined(&SCARG);
    eval 'sub syscallarg {
        local($x) = @_;
	    eval q(\'union union\' { $x  &datum;  &register_t  &pad; });
    }' unless defined(&syscallarg);
}
unless(defined(&syscallarg)) {
    eval 'sub syscallarg {
        local($x) = @_;
	    eval q($x);
    }' unless defined(&syscallarg);
}
unless(defined(&HAVE_REGISTER_T)) {
}
if(defined( &HAVE_DEF_STRUCT_SETGROUPS_ARGS)) {
    eval 'sub xfs_setgroups_args () { &setgroups_args;}' unless defined(&xfs_setgroups_args);
}
 elsif(defined( &HAVE_DEF_STRUCT_SYS_SETGROUPS_ARGS)) {
    eval 'sub xfs_setgroups_args () { &sys_setgroups_args;}' unless defined(&xfs_setgroups_args);
}
 elsif((defined(&__osf__) ? &__osf__ : 0)) {
}
 elsif(defined( &__APPLE__)) {
} else {
    die("what\ is\ you\ setgroups\ named\ \?");
}
if(defined(&HAVE_KERNEL_VFS_GETVFS)) {
    eval 'sub xfs_vfs_getvfs () { &vfs_getvfs;}' unless defined(&xfs_vfs_getvfs);
} else {
    eval 'sub xfs_vfs_getvfs () { &getvfs;}' unless defined(&xfs_vfs_getvfs);
}
if(defined(&HAVE_FOUR_ARGUMENT_VFS_OBJECT_CREATE)) {
    eval 'sub xfs_vfs_object_create {
        local($vp,$proc,$ucred) = @_;
	    eval q( &vfs_object_create($vp,$proc,$ucred, &TRUE));
    }' unless defined(&xfs_vfs_object_create);
} else {
    eval 'sub xfs_vfs_object_create {
        local($vp,$proc,$ucred) = @_;
	    eval q( &vfs_object_create($vp,$proc,$ucred));
    }' unless defined(&xfs_vfs_object_create);
}
if(defined(&__OpenBSD__)) {
    eval 'sub xfs_set_vp_size {
        local($vp, $sz) = @_;
	    eval q( &uvm_vnp_setsize($vp, $sz));
    }' unless defined(&xfs_set_vp_size);
}
 elsif((defined(&HAVE_KERNEL_VNODE_PAGER_SETSIZE) ? &HAVE_KERNEL_VNODE_PAGER_SETSIZE : 0)) {
    eval 'sub xfs_set_vp_size {
        local($vp, $sz) = @_;
	    eval q( &vnode_pager_setsize($vp, $sz));
    }' unless defined(&xfs_set_vp_size);
} else {
    eval 'sub xfs_set_vp_size {
        local($vp, $sz) = @_;
	    eval q();
    }' unless defined(&xfs_set_vp_size);
}
require 'xfs/xfs_syscalls.ph';
require 'xfs/xfs_vopdefs.ph';
1;
