/*	$OpenBSD: plx9060var.h,v 1.1 2001/06/21 13:21:50 nate Exp $	*/
/*	$NetBSD$	*/

/*-
 * Copyright (c) 2000 Zembu Labs, Inc.
 * All rights reserved.
 *
 * Author: Jason R. Thorpe <thorpej@zembu.com>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by Zembu Labs, Inc.
 * 4. Neither the name of Zembu Labs nor the names of its employees may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ZEMBU LABS, INC. ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WAR-
 * RANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DIS-
 * CLAIMED.  IN NO EVENT SHALL ZEMBU LABS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * API definition for the PLX 9060-family of PCI bus controllers.
 */

#ifndef _DEV_PCI_PLX9060VAR_H_
#define	_DEV_PCI_PLX9060VAR_H_

struct plx9060_config {
	bus_space_tag_t plx_st;		/* bus space tag for runtime regs */
	bus_space_handle_t plx_sh;	/* bus space handle for runtime regs */
	pci_chipset_tag_t plx_pc;	/* PCI chipset we're on */
	pcitag_t plx_tag;		/* PCI tag for our b/d/f */
};

#ifdef notyet
void	plx9060_read_eeprom __P((struct plx9060_config *, int, int, void *));
void	plx9060_write_eeprom __P((struct plx9060_config *, int, int,
	    const void *));
#endif

#endif /* _DEV_PCI_PLX9060VAR_H_ */
