require '_h2ph_pre.ph';

unless(defined(&TR_SWITCH)) {
    sub TR_SWITCH () {	0;}
}
unless(defined(&TR_RESET)) {
    sub TR_RESET () {	1;}
}
unless(defined(&TR_RELEASE)) {
    sub TR_RELEASE () {	2;}
}
unless(defined(&TR_CLEARINT)) {
    sub TR_CLEARINT () {	3;}
}
unless(defined(&MM_OUTB)) {
    sub MM_OUTB {
	local($sc, $off, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_memt, ($sc)-> &sc_mmioh, ($off), ($val)));
    }
}
unless(defined(&MM_OUTW)) {
    sub MM_OUTW {
	local($sc, $off, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_memt, ($sc)-> &sc_mmioh, ($off),  &htons(($val))));
    }
}
unless(defined(&MM_INB)) {
    sub MM_INB {
	local($sc, $off) = @_;
	eval q( &bus_space_read_1(($sc)-> &sc_memt, ($sc)-> &sc_mmioh, ($off)));
    }
}
unless(defined(&MM_INW)) {
    sub MM_INW {
	local($sc, $off) = @_;
	eval q( &ntohs( &bus_space_read_2(($sc)-> &sc_memt, ($sc)-> &sc_mmioh, ($off))));
    }
}
unless(defined(&SR_INB)) {
    sub SR_INB {
	local($sc, $off) = @_;
	eval q( &bus_space_read_1( ($sc->{sc_memt}),  ($sc->{sc_sramh}), ($off)));
    }
}
unless(defined(&SR_INW)) {
    sub SR_INW {
	local($sc, $off) = @_;
	eval q( &htons( &bus_space_read_2( ($sc->{sc_memt}),  ($sc->{sc_sramh}), ($off))));
    }
}
unless(defined(&SR_OUTB)) {
    sub SR_OUTB {
	local($sc, $off, $val) = @_;
	eval q( &bus_space_write_1(($sc)-> &sc_memt, ($sc)-> &sc_sramh, ($off), ($val)));
    }
}
unless(defined(&SR_OUTW)) {
    sub SR_OUTW {
	local($sc, $off, $val) = @_;
	eval q( &bus_space_write_2(($sc)-> &sc_memt, ($sc)-> &sc_sramh, ($off),  &htons(($val))));
    }
}
unless(defined(&RB_INB)) {
    sub RB_INB {
	local($sc, $rb, $reg) = @_;
	eval q( &SR_INB($sc, ($rb)+($reg)));
    }
}
unless(defined(&RB_INW)) {
    sub RB_INW {
	local($sc, $rb, $reg) = @_;
	eval q( &SR_INW($sc, ($rb)+($reg)));
    }
}
unless(defined(&ACA_RDB)) {
    sub ACA_RDB {
	local($sc, $reg) = @_;
	eval q( &MM_INB($sc, (( ($sc->{sc_aca})+($reg))| &ACA_RW)));
    }
}
unless(defined(&ACA_RDW)) {
    sub ACA_RDW {
	local($sc, $reg) = @_;
	eval q( &MM_INW($sc, (( ($sc->{sc_aca})+($reg))| &ACA_RW)));
    }
}
unless(defined(&ACA_OUTB)) {
    sub ACA_OUTB {
	local($sc, $reg, $val) = @_;
	eval q( &MM_OUTB($sc, (( ($sc->{sc_aca})+($reg))| &ACA_RW), ($val)));
    }
}
unless(defined(&ACA_SETB)) {
    sub ACA_SETB {
	local($sc, $reg, $val) = @_;
	eval q( &MM_OUTB($sc, (( ($sc->{sc_aca})+($reg))| &ACA_SET), ($val)));
    }
}
unless(defined(&ACA_RSTB)) {
    sub ACA_RSTB {
	local($sc, $reg, $val) = @_;
	eval q( &MM_OUTB($sc, (( ($sc->{sc_aca})+($reg))| &ACA_RST), ($val)));
    }
}
unless(defined(&SSB_INB)) {
    sub SSB_INB {
	local($sc, $ssb, $reg) = @_;
	eval q( &SR_INB($sc, ($ssb)+($reg)));
    }
}
unless(defined(&ARB_INB)) {
    sub ARB_INB {
	local($sc, $arb, $reg) = @_;
	eval q( &SR_INB($sc, ($arb)+($reg)));
    }
}
unless(defined(&ARB_INW)) {
    sub ARB_INW {
	local($sc, $arb, $reg) = @_;
	eval q( &SR_INW($sc, ($arb)+($reg)));
    }
}
unless(defined(&SRB_INB)) {
    sub SRB_INB {
	local($sc, $srb, $reg) = @_;
	eval q( &SR_INB($sc, ($srb)+($reg)));
    }
}
unless(defined(&SRB_INW)) {
    sub SRB_INW {
	local($sc, $srb, $reg) = @_;
	eval q( &SR_INW($sc, ($srb)+($reg)));
    }
}
unless(defined(&SRB_OUTB)) {
    sub SRB_OUTB {
	local($sc, $srb, $reg, $val) = @_;
	eval q( &SR_OUTB($sc, ($srb)+($reg), ($val)));
    }
}
unless(defined(&SRB_OUTW)) {
    sub SRB_OUTW {
	local($sc, $srb, $reg, $val) = @_;
	eval q( &SR_OUTW($sc, ($srb)+($reg), ($val)));
    }
}
unless(defined(&ASB_INB)) {
    sub ASB_INB {
	local($sc, $asb, $reg) = @_;
	eval q( &SR_INB($sc, ($asb)+($reg)));
    }
}
unless(defined(&ASB_INW)) {
    sub ASB_INW {
	local($sc, $asb, $reg) = @_;
	eval q( &SR_INW($sc, ($asb)+($reg)));
    }
}
unless(defined(&ASB_OUTB)) {
    sub ASB_OUTB {
	local($sc, $asb, $reg, $val) = @_;
	eval q( &SR_OUTB($sc, ($asb)+($reg), ($val)));
    }
}
unless(defined(&ASB_OUTW)) {
    sub ASB_OUTW {
	local($sc, $asb, $reg, $val) = @_;
	eval q( &SR_OUTW($sc, ($asb)+($reg), ($val)));
    }
}
unless(defined(&TXCA_INW)) {
    sub TXCA_INW {
	local($sc, $reg) = @_;
	eval q( &SR_INW($sc,  ($sc->{sc_txca})+($reg)));
    }
}
unless(defined(&TXCA_OUTW)) {
    sub TXCA_OUTW {
	local($sc, $reg, $val) = @_;
	eval q( &SR_OUTW($sc,  ($sc->{sc_txca})+($reg), ($val)));
    }
}
unless(defined(&TXB_INB)) {
    sub TXB_INB {
	local($sc, $buf, $reg) = @_;
	eval q( &SR_INB($sc, ($buf)+($reg)));
    }
}
unless(defined(&TXB_INW)) {
    sub TXB_INW {
	local($sc, $buf, $reg) = @_;
	eval q( &SR_INW($sc, ($buf)+($reg)));
    }
}
unless(defined(&TXB_OUTB)) {
    sub TXB_OUTB {
	local($sc, $buf, $reg, $val) = @_;
	eval q( &SR_OUTB($sc, ($buf)+($reg), ($val)));
    }
}
unless(defined(&TXB_OUTW)) {
    sub TXB_OUTW {
	local($sc, $buf, $reg, $val) = @_;
	eval q( &SR_OUTW($sc, ($buf)+($reg), ($val)));
    }
}
unless(defined(&ACA_RRR)) {
    sub ACA_RRR () {	0;}
}
unless(defined(&ACA_RRR_e)) {
    sub ACA_RRR_e () {	 &ACA_RRR;}
}
unless(defined(&ACA_RRR_o)) {
    sub ACA_RRR_o () {	( &ACA_RRR+1);}
}
unless(defined(&ACA_WRBR)) {
    sub ACA_WRBR () {	2;}
}
unless(defined(&ACA_WRBR_e)) {
    sub ACA_WRBR_e () {	 &ACA_WRBR;}
}
unless(defined(&ACA_WRBR_o)) {
    sub ACA_WRBR_o () {	( &ACA_WRBR+1);}
}
unless(defined(&ACA_WWOR)) {
    sub ACA_WWOR () {	4;}
}
unless(defined(&ACA_WWOR_e)) {
    sub ACA_WWOR_e () {	 &ACA_WWOR;}
}
unless(defined(&ACA_WWOR_o)) {
    sub ACA_WWOR_o () {	( &ACA_WWOR+1);}
}
unless(defined(&ACA_WWCR)) {
    sub ACA_WWCR () {	6;}
}
unless(defined(&ACA_WWCR_e)) {
    sub ACA_WWCR_e () {	 &ACA_WWCR;}
}
unless(defined(&ACA_WWCR_o)) {
    sub ACA_WWCR_o () {	( &ACA_WWCR+1);}
}
unless(defined(&ACA_ISRP)) {
    sub ACA_ISRP () {	8;}
}
unless(defined(&ACA_ISRP_e)) {
    sub ACA_ISRP_e () {	 &ACA_ISRP;}
}
unless(defined(&ACA_ISRP_o)) {
    sub ACA_ISRP_o () {	( &ACA_ISRP+1);}
}
unless(defined(&ACA_ISRA)) {
    sub ACA_ISRA () {	10;}
}
unless(defined(&ACA_ISRA_e)) {
    sub ACA_ISRA_e () {	 &ACA_ISRA;}
}
unless(defined(&ACA_ISRA_o)) {
    sub ACA_ISRA_o () {	( &ACA_ISRA+1);}
}
unless(defined(&ACA_TCR)) {
    sub ACA_TCR () {	12;}
}
unless(defined(&ACA_TCR_e)) {
    sub ACA_TCR_e () {	 &ACA_TCR;}
}
unless(defined(&ACA_TCR_o)) {
    sub ACA_TCR_o () {	( &ACA_TCR+1);}
}
unless(defined(&ACA_TVR)) {
    sub ACA_TVR () {	14;}
}
unless(defined(&ACA_TVR_e)) {
    sub ACA_TVR_e () {	 &ACA_TVR;}
}
unless(defined(&ACA_TVR_o)) {
    sub ACA_TVR_o () {	( &ACA_TVR+1);}
}
unless(defined(&ACA_RW)) {
    sub ACA_RW () {	0;}
}
unless(defined(&ACA_RST)) {
    sub ACA_RST () {	0x20;}
}
unless(defined(&ACA_SET)) {
    sub ACA_SET () {	0x40;}
}
unless(defined(&CMD_CMD)) {
    sub CMD_CMD () {	0;}
}
unless(defined(&CMD_RETCODE)) {
    sub CMD_RETCODE () {	2;}
}
unless(defined(&SSB_SIZE)) {
    sub SSB_SIZE () {	20;}
}
unless(defined(&SSB_CMD)) {
    sub SSB_CMD () {	0;}
}
unless(defined(&SSB_CMDCORR)) {
    sub SSB_CMDCORR () {	1;}
}
unless(defined(&SSB_RETCODE)) {
    sub SSB_RETCODE () {	2;}
}
unless(defined(&SSB_STATIONID)) {
    sub SSB_STATIONID () {	4;}
}
unless(defined(&SSB_XMITERR)) {
    sub SSB_XMITERR () {	6;}
}
unless(defined(&ARB_SIZE)) {
    sub ARB_SIZE () {	28;}
}
unless(defined(&ARB_CMD)) {
    sub ARB_CMD () {	0;}
}
unless(defined(&ARB_STATIONID)) {
    sub ARB_STATIONID () {	4;}
}
unless(defined(&ARB_RXD_BUFADDR)) {
    sub ARB_RXD_BUFADDR () {	6;}
}
unless(defined(&ARB_RXD_LANHDRLEN)) {
    sub ARB_RXD_LANHDRLEN () {	8;}
}
unless(defined(&ARB_RXD_DLCHDRLEN)) {
    sub ARB_RXD_DLCHDRLEN () {	9;}
}
unless(defined(&ARB_RXD_FRAMELEN)) {
    sub ARB_RXD_FRAMELEN () {	10;}
}
unless(defined(&ARB_RXD_MSGTYPE)) {
    sub ARB_RXD_MSGTYPE () {	12;}
}
unless(defined(&ARB_XMT_CMDCORR)) {
    sub ARB_XMT_CMDCORR () {	1;}
}
unless(defined(&ARB_XMT_DHBADDR)) {
    sub ARB_XMT_DHBADDR () {	6;}
}
unless(defined(&ARB_RINGSTATUS)) {
    sub ARB_RINGSTATUS () {	6;}
}
unless(defined(&ARB_DLCSTAT_STATUS)) {
    sub ARB_DLCSTAT_STATUS () {	6;}
}
unless(defined(&ARB_DLCSTAT_FRMRDATA)) {
    sub ARB_DLCSTAT_FRMRDATA () {	8;}
}
unless(defined(&ARB_DLCSTAT_ACCPRIO)) {
    sub ARB_DLCSTAT_ACCPRIO () {	13;}
}
unless(defined(&ARB_DLCSTAT_REMADDR)) {
    sub ARB_DLCSTAT_REMADDR () {	14;}
}
unless(defined(&ARB_DLCSTAT_REMSAP)) {
    sub ARB_DLCSTAT_REMSAP () {	20;}
}
unless(defined(&SRB_SIZE)) {
    sub SRB_SIZE () {	28;}
}
unless(defined(&SRB_CMD)) {
    sub SRB_CMD () {	0;}
}
unless(defined(&SRB_RETCODE)) {
    sub SRB_RETCODE () {	2;}
}
unless(defined(&INIT_COMPL)) {
    sub INIT_COMPL () {	0x80;}
}
unless(defined(&SRB_INIT_STATUS)) {
    sub SRB_INIT_STATUS () {	1;}
}
unless(defined(&RSP_DETECT)) {
    sub RSP_DETECT () {	0x40;}
}
unless(defined(&FAST_PATH_TRANSMIT)) {
    sub FAST_PATH_TRANSMIT () {	0x20;}
}
unless(defined(&RING_MEASUREMENT)) {
    sub RING_MEASUREMENT () {	0x08;}
}
unless(defined(&RPL)) {
    sub RPL () {	0x02;}
}
unless(defined(&RSP_16)) {
    sub RSP_16 () {	0x01;}
}
unless(defined(&SRB_INIT_STATUS2)) {
    sub SRB_INIT_STATUS2 () {	2;}
}
unless(defined(&PNP)) {
    sub PNP () {	0x80;}
}
unless(defined(&SET_DEF_RSP)) {
    sub SET_DEF_RSP () {	0x40;}
}
unless(defined(&AUTO_DEF_RSP_UPDATE)) {
    sub AUTO_DEF_RSP_UPDATE () {	0x20;}
}
unless(defined(&SRB_INIT_BUC)) {
    sub SRB_INIT_BUC () {	6;}
}
unless(defined(&SRB_INIT_ENCADDR)) {
    sub SRB_INIT_ENCADDR () {	8;}
}
unless(defined(&SRB_INIT_LVLADDR)) {
    sub SRB_INIT_LVLADDR () {	10;}
}
unless(defined(&SRB_INIT_ADAPADDR)) {
    sub SRB_INIT_ADAPADDR () {	12;}
}
unless(defined(&SRB_INIT_PARMSADDR)) {
    sub SRB_INIT_PARMSADDR () {	14;}
}
unless(defined(&SRB_INIT_MACADDR)) {
    sub SRB_INIT_MACADDR () {	16;}
}
unless(defined(&SRB_INIT_UTILADDR)) {
    sub SRB_INIT_UTILADDR () {	18;}
}
unless(defined(&SRB_CFP_CMDSIZE)) {
    sub SRB_CFP_CMDSIZE () {	12;}
}
unless(defined(&SRB_CFP_RAMSIZE)) {
    sub SRB_CFP_RAMSIZE () {	8;}
}
unless(defined(&SRB_CFP_BUFSIZE)) {
    sub SRB_CFP_BUFSIZE () {	10;}
}
unless(defined(&SRB_CFPRESP_FPXMIT)) {
    sub SRB_CFPRESP_FPXMIT () {	8;}
}
unless(defined(&SRB_CFPRESP_SRBADDR)) {
    sub SRB_CFPRESP_SRBADDR () {	10;}
}
unless(defined(&SRB_OPEN_CMDSIZE)) {
    sub SRB_OPEN_CMDSIZE () {	60;}
}
unless(defined(&SRB_OPEN_OPTIONS)) {
    sub SRB_OPEN_OPTIONS () {	8;}
}
unless(defined(&SRB_OPEN_NODEADDR)) {
    sub SRB_OPEN_NODEADDR () {	10;}
}
unless(defined(&SRB_OPEN_GROUPADDR)) {
    sub SRB_OPEN_GROUPADDR () {	16;}
}
unless(defined(&SRB_OPEN_FUNCTADDR)) {
    sub SRB_OPEN_FUNCTADDR () {	20;}
}
unless(defined(&SRB_OPEN_NUMRCVBUF)) {
    sub SRB_OPEN_NUMRCVBUF () {	24;}
}
unless(defined(&SRB_OPEN_RCVBUFLEN)) {
    sub SRB_OPEN_RCVBUFLEN () {	26;}
}
unless(defined(&SRB_OPEN_DHBLEN)) {
    sub SRB_OPEN_DHBLEN () {	28;}
}
unless(defined(&SRB_OPEN_NUMDHB)) {
    sub SRB_OPEN_NUMDHB () {	30;}
}
unless(defined(&SRB_OPEN_DLCMAXSAP)) {
    sub SRB_OPEN_DLCMAXSAP () {	32;}
}
unless(defined(&SRB_OPEN_DLCMAXSTA)) {
    sub SRB_OPEN_DLCMAXSTA () {	33;}
}
unless(defined(&SRB_OPEN_DLCMAXGSAP)) {
    sub SRB_OPEN_DLCMAXGSAP () {	34;}
}
unless(defined(&SRB_OPEN_DLCMAXGMEM)) {
    sub SRB_OPEN_DLCMAXGMEM () {	35;}
}
unless(defined(&SRB_OPEN_DLCT1TICK1)) {
    sub SRB_OPEN_DLCT1TICK1 () {	36;}
}
unless(defined(&SRB_OPEN_DLCT2TICK1)) {
    sub SRB_OPEN_DLCT2TICK1 () {	37;}
}
unless(defined(&SRB_OPEN_DLCTITICK1)) {
    sub SRB_OPEN_DLCTITICK1 () {	38;}
}
unless(defined(&SRB_OPEN_DLCT1TICK2)) {
    sub SRB_OPEN_DLCT1TICK2 () {	39;}
}
unless(defined(&SRB_OPEN_DLCT2TICK2)) {
    sub SRB_OPEN_DLCT2TICK2 () {	40;}
}
unless(defined(&SRB_OPEN_DLCTITICK2)) {
    sub SRB_OPEN_DLCTITICK2 () {	41;}
}
unless(defined(&SRB_OPEN_PODUCTID)) {
    sub SRB_OPEN_PODUCTID () {	42;}
}
unless(defined(&SRB_OPENRESP_ERRCODE)) {
    sub SRB_OPENRESP_ERRCODE () {	6;}
}
unless(defined(&SRB_OPENRESP_ASBADDR)) {
    sub SRB_OPENRESP_ASBADDR () {	8;}
}
unless(defined(&SRB_OPENRESP_SRBADDR)) {
    sub SRB_OPENRESP_SRBADDR () {	10;}
}
unless(defined(&SRB_OPENRESP_ARBADDR)) {
    sub SRB_OPENRESP_ARBADDR () {	12;}
}
unless(defined(&SRB_OPENRESP_SSBADDR)) {
    sub SRB_OPENRESP_SSBADDR () {	14;}
}
unless(defined(&SRB_OPNSAP_STATIONID)) {
    sub SRB_OPNSAP_STATIONID () {	4;}
}
unless(defined(&SRB_OPNSAP_TIMERT1)) {
    sub SRB_OPNSAP_TIMERT1 () {	6;}
}
unless(defined(&SRB_OPNSAP_TIMERT2)) {
    sub SRB_OPNSAP_TIMERT2 () {	7;}
}
unless(defined(&SRB_OPNSAP_TIMERTI)) {
    sub SRB_OPNSAP_TIMERTI () {	8;}
}
unless(defined(&SRB_OPNSAP_MAXOUT)) {
    sub SRB_OPNSAP_MAXOUT () {	9;}
}
unless(defined(&SRB_OPNSAP_MAXIN)) {
    sub SRB_OPNSAP_MAXIN () {	10;}
}
unless(defined(&SRB_OPNSAP_MAXOUTINCR)) {
    sub SRB_OPNSAP_MAXOUTINCR () {	11;}
}
unless(defined(&SRB_OPNSAP_MAXRETRY)) {
    sub SRB_OPNSAP_MAXRETRY () {	12;}
}
unless(defined(&SRB_OPNSAP_GSAPMAXMEMB)) {
    sub SRB_OPNSAP_GSAPMAXMEMB () {	13;}
}
unless(defined(&SRB_OPNSAP_MAXIFIELD)) {
    sub SRB_OPNSAP_MAXIFIELD () {	14;}
}
unless(defined(&SRB_OPNSAP_SAPVALUE)) {
    sub SRB_OPNSAP_SAPVALUE () {	16;}
}
unless(defined(&SRB_OPNSAP_SAPOPTIONS)) {
    sub SRB_OPNSAP_SAPOPTIONS () {	17;}
}
unless(defined(&SRB_OPNSAP_STATIONCNT)) {
    sub SRB_OPNSAP_STATIONCNT () {	18;}
}
unless(defined(&SRB_OPNSAP_SAPGSAPMEMB)) {
    sub SRB_OPNSAP_SAPGSAPMEMB () {	19;}
}
unless(defined(&SRB_OPNSAP_GSAP1)) {
    sub SRB_OPNSAP_GSAP1 () {	20;}
}
unless(defined(&SRB_RLOG_LOGDATA)) {
    sub SRB_RLOG_LOGDATA () {	14;}
}
unless(defined(&SRB_LOG_LINEERRS)) {
    sub SRB_LOG_LINEERRS () {	( &SRB_RLOG_LOGDATA+0);}
}
unless(defined(&SRB_LOG_INTERRS)) {
    sub SRB_LOG_INTERRS () {	( &SRB_RLOG_LOGDATA+1);}
}
unless(defined(&SRB_LOG_BRSTERRS)) {
    sub SRB_LOG_BRSTERRS () {	( &SRB_RLOG_LOGDATA+2);}
}
unless(defined(&SRB_LOG_ACERRS)) {
    sub SRB_LOG_ACERRS () {	( &SRB_RLOG_LOGDATA+3);}
}
unless(defined(&SRB_LOG_ABRTERRS)) {
    sub SRB_LOG_ABRTERRS () {	( &SRB_RLOG_LOGDATA+4);}
}
unless(defined(&SRB_LOG_LOSTFRMS)) {
    sub SRB_LOG_LOSTFRMS () {	( &SRB_RLOG_LOGDATA+6);}
}
unless(defined(&SRB_LOG_RCVCONG)) {
    sub SRB_LOG_RCVCONG () {	( &SRB_RLOG_LOGDATA+7);}
}
unless(defined(&SRB_LOG_FCPYERRS)) {
    sub SRB_LOG_FCPYERRS () {	( &SRB_RLOG_LOGDATA+8);}
}
unless(defined(&SRB_LOG_FREQERRS)) {
    sub SRB_LOG_FREQERRS () {	( &SRB_RLOG_LOGDATA+9);}
}
unless(defined(&SRB_LOG_TOKENERRS)) {
    sub SRB_LOG_TOKENERRS () {	( &SRB_RLOG_LOGDATA+10);}
}
unless(defined(&SRB_SET_DEFRSP)) {
    sub SRB_SET_DEFRSP () {	6;}
}
unless(defined(&ASB_SIZE)) {
    sub ASB_SIZE () {	12;}
}
unless(defined(&RECV_CMD)) {
    sub RECV_CMD () {	0;}
}
unless(defined(&RECV_RETCODE)) {
    sub RECV_RETCODE () {	2;}
}
unless(defined(&RECV_STATIONID)) {
    sub RECV_STATIONID () {	4;}
}
unless(defined(&RECV_RESP_RECBUFADDR)) {
    sub RECV_RESP_RECBUFADDR () {	6;}
}
unless(defined(&XMIT_CMD)) {
    sub XMIT_CMD () {	0;}
}
unless(defined(&XMIT_CMDCORR)) {
    sub XMIT_CMDCORR () {	1;}
}
unless(defined(&XMIT_RETCODE)) {
    sub XMIT_RETCODE () {	2;}
}
unless(defined(&XMIT_STATIONID)) {
    sub XMIT_STATIONID () {	4;}
}
unless(defined(&XMIT_FRAMELEN)) {
    sub XMIT_FRAMELEN () {	6;}
}
unless(defined(&XMIT_HDRLEN)) {
    sub XMIT_HDRLEN () {	8;}
}
unless(defined(&XMIT_REMSAP)) {
    sub XMIT_REMSAP () {	9;}
}
unless(defined(&XMIT_DATA)) {
    sub XMIT_DATA () {	10;}
}
unless(defined(&XMIT_LASTBUF)) {
    sub XMIT_LASTBUF () {	12;}
}
unless(defined(&XMIT_FRAMEPTR)) {
    sub XMIT_FRAMEPTR () {	14;}
}
unless(defined(&XMIT_NEXTBUF)) {
    sub XMIT_NEXTBUF () {	16;}
}
unless(defined(&XMIT_STATUS)) {
    sub XMIT_STATUS () {	18;}
}
unless(defined(&XMIT_STRIPFS)) {
    sub XMIT_STRIPFS () {	19;}
}
unless(defined(&XMIT_BUFLEN)) {
    sub XMIT_BUFLEN () {	20;}
}
unless(defined(&XMIT_FP_DATA)) {
    sub XMIT_FP_DATA () {	22;}
}
if(0) {
}
unless(defined(&TXCA_BUFFER_COUNT)) {
    sub TXCA_BUFFER_COUNT () {	0;}
}
unless(defined(&TXCA_FREE_QUEUE_HEAD)) {
    sub TXCA_FREE_QUEUE_HEAD () {	2;}
}
unless(defined(&TXCA_FREE_QUEUE_TAIL)) {
    sub TXCA_FREE_QUEUE_TAIL () {	4;}
}
unless(defined(&TXCA_ADAPTER_QUEUE_HEAD)) {
    sub TXCA_ADAPTER_QUEUE_HEAD () {	6;}
}
unless(defined(&TXCA_BUFFER_SIZE)) {
    sub TXCA_BUFFER_SIZE () {	8;}
}
unless(defined(&TXCA_COMPLETION_QUEUE_TAIL)) {
    sub TXCA_COMPLETION_QUEUE_TAIL () {	10;}
}
unless(defined(&RB_NEXTBUF)) {
    sub RB_NEXTBUF () {	2;}
}
unless(defined(&RB_FS)) {
    sub RB_FS () {	5;}
}
unless(defined(&RB_BUFLEN)) {
    sub RB_BUFLEN () {	6;}
}
unless(defined(&RB_DATA)) {
    sub RB_DATA () {	8;}
}
unless(defined(&SAPCB_SIZE)) {
    sub SAPCB_SIZE () {	64;}
}
unless(defined(&LSCB_SIZE)) {
    sub LSCB_SIZE () {	144;}
}
unless(defined(&PRIVRAM_SIZE)) {
    sub PRIVRAM_SIZE () {	1416;}
}
unless(defined(&RESVDMEM_SIZE)) {
    sub RESVDMEM_SIZE () {	( &PRIVRAM_SIZE+ &ARB_SIZE+ &SSB_SIZE+ &SRB_SIZE+ &ASB_SIZE);}
}
unless(defined(&TR_SRAM_DEFAULT)) {
    sub TR_SRAM_DEFAULT () {	0xd8000;}
}
unless(defined(&TR_MMIO_OFFSET)) {
    sub TR_MMIO_OFFSET () {	0x80000;}
}
unless(defined(&TR_MMIO_MINADDR)) {
    sub TR_MMIO_MINADDR () {	0xc0000;}
}
unless(defined(&TR_MMIO_MAXADDR)) {
    sub TR_MMIO_MAXADDR () {	0xde000;}
}
unless(defined(&TR_MMIO_SIZE)) {
    sub TR_MMIO_SIZE () {	8192;}
}
unless(defined(&TR_ACA_OFFSET)) {
    sub TR_ACA_OFFSET () {	0x1e00;}
}
unless(defined(&TR_MAC_OFFSET)) {
    sub TR_MAC_OFFSET () {	0x1f00;}
}
unless(defined(&TR_ID_OFFSET)) {
    sub TR_ID_OFFSET () {	0x1f30;}
}
unless(defined(&TR_TYP_OFFSET)) {
    sub TR_TYP_OFFSET () {	0x1fa0;}
}
unless(defined(&TR_RATES_OFFSET)) {
    sub TR_RATES_OFFSET () {	0x1fa2;}
}
unless(defined(&TR_RAM_OFFSET)) {
    sub TR_RAM_OFFSET () {	0x1fa6;}
}
unless(defined(&TR_PAGE_OFFSET)) {
    sub TR_PAGE_OFFSET () {	0x1fa8;}
}
unless(defined(&TR_DHB4_OFFSET)) {
    sub TR_DHB4_OFFSET () {	0x1faa;}
}
unless(defined(&TR_DHB16_OFFSET)) {
    sub TR_DHB16_OFFSET () {	0x1fac;}
}
unless(defined(&TR_MEDIAS_OFFSET)) {
    sub TR_MEDIAS_OFFSET () {	0x1fb6;}
}
unless(defined(&TR_MEDIA_OFFSET)) {
    sub TR_MEDIA_OFFSET () {	0x1fb8;}
}
unless(defined(&TR_IRQ_OFFSET)) {
    sub TR_IRQ_OFFSET () {	0x1fba;}
}
unless(defined(&BUT_OK)) {
    sub BUT_OK () {	0x0000;}
}
unless(defined(&BUT_PROCESSOR_FAIL)) {
    sub BUT_PROCESSOR_FAIL () {	0x0020;}
}
unless(defined(&BUT_ROM_FAIL)) {
    sub BUT_ROM_FAIL () {	0x0022;}
}
unless(defined(&BUT_RAM_FAIL)) {
    sub BUT_RAM_FAIL () {	0x0024;}
}
unless(defined(&BUT_INST_FAIL)) {
    sub BUT_INST_FAIL () {	0x0026;}
}
unless(defined(&BUT_INTER_FAIL)) {
    sub BUT_INTER_FAIL () {	0x0028;}
}
unless(defined(&BUT_MEM_FAIL)) {
    sub BUT_MEM_FAIL () {	0x002a;}
}
unless(defined(&BUT_PROTOCOL_FAIL)) {
    sub BUT_PROTOCOL_FAIL () {	0x002c;}
}
unless(defined(&DIR_INTERRUPT)) {
    sub DIR_INTERRUPT () {	0x00;}
}
unless(defined(&DIR_MOD_OPEN_PARAMS)) {
    sub DIR_MOD_OPEN_PARAMS () {	0x01;}
}
unless(defined(&DIR_RESTORE_OPEN_PARMS)) {
    sub DIR_RESTORE_OPEN_PARMS () {	0x02;}
}
unless(defined(&DIR_OPEN_ADAPTER)) {
    sub DIR_OPEN_ADAPTER () {	0x03;}
}
unless(defined(&DIR_CLOSE)) {
    sub DIR_CLOSE () {	0x04;}
}
unless(defined(&DIR_SET_GRP_ADDR)) {
    sub DIR_SET_GRP_ADDR () {	0x06;}
}
unless(defined(&DIR_SET_FUNC_ADDR)) {
    sub DIR_SET_FUNC_ADDR () {	0x07;}
}
unless(defined(&DIR_READ_LOG)) {
    sub DIR_READ_LOG () {	0x08;}
}
unless(defined(&DIR_SET_BRIDGE_PARMS)) {
    sub DIR_SET_BRIDGE_PARMS () {	0x09;}
}
unless(defined(&DIR_CONFIG_BRIDGE_RAM)) {
    sub DIR_CONFIG_BRIDGE_RAM () {	0x0c;}
}
unless(defined(&DIR_CONFIG_FAST_PATH_RAM)) {
    sub DIR_CONFIG_FAST_PATH_RAM () {	0x12;}
}
unless(defined(&DIR_SINGLE_ROUTE_BROADCAST)) {
    sub DIR_SINGLE_ROUTE_BROADCAST () {	0x1f;}
}
unless(defined(&DIR_SET_DEFAULT_RING_SPEED)) {
    sub DIR_SET_DEFAULT_RING_SPEED () {	0x21;}
}
unless(defined(&XMIT_DIR_FRAME)) {
    sub XMIT_DIR_FRAME () {	0x0a;}
}
unless(defined(&XMIT_I_FRAME)) {
    sub XMIT_I_FRAME () {	0x0b;}
}
unless(defined(&XMIT_UI_FRM)) {
    sub XMIT_UI_FRM () {	0x0d;}
}
unless(defined(&XMIT_XID_CMD)) {
    sub XMIT_XID_CMD () {	0x0e;}
}
unless(defined(&XMIT_XID_RESP_FINAL)) {
    sub XMIT_XID_RESP_FINAL () {	0x0f;}
}
unless(defined(&XMIT_XID_RESP_NOT_FINAL)) {
    sub XMIT_XID_RESP_NOT_FINAL () {	0x10;}
}
unless(defined(&XMIT_TEST_CMD)) {
    sub XMIT_TEST_CMD () {	0x11;}
}
unless(defined(&REC_DATA)) {
    sub REC_DATA () {	0x81;}
}
unless(defined(&XMIT_DATA_REQ)) {
    sub XMIT_DATA_REQ () {	0x82;}
}
unless(defined(&DLC_STATUS)) {
    sub DLC_STATUS () {	0x83;}
}
unless(defined(&RING_STAT_CHANGE)) {
    sub RING_STAT_CHANGE () {	0x84;}
}
unless(defined(&REC_BRIDGE_DATA)) {
    sub REC_BRIDGE_DATA () {	0x85;}
}
unless(defined(&REXMIT_DATA_REQ)) {
    sub REXMIT_DATA_REQ () {	0x86;}
}
unless(defined(&OPEN_WRAP)) {
    sub OPEN_WRAP () {	0x8000;}
}
unless(defined(&OPEN_NO_HARD_ERR)) {
    sub OPEN_NO_HARD_ERR () {	0x4000;}
}
unless(defined(&OPEN_NO_SOFT_ERR)) {
    sub OPEN_NO_SOFT_ERR () {	0x2000;}
}
unless(defined(&OPEN_PASS_MAC)) {
    sub OPEN_PASS_MAC () {	0x1000;}
}
unless(defined(&OPEN_PASS_ATTN_MAC)) {
    sub OPEN_PASS_ATTN_MAC () {	0x0800;}
}
unless(defined(&OPEN_PASS_BCON_MAC)) {
    sub OPEN_PASS_BCON_MAC () {	0x0100;}
}
unless(defined(&OPEN_CONT)) {
    sub OPEN_CONT () {	0x0080;}
}
unless(defined(&NUM_RCV_BUF)) {
    sub NUM_RCV_BUF () {	4;}
}
unless(defined(&RCV_BUF_LEN)) {
    sub RCV_BUF_LEN () {	520;}
}
unless(defined(&RCV_BUF_DLEN)) {
    sub RCV_BUF_DLEN () {	 &RCV_BUF_LEN - 8;}
}
unless(defined(&DHB_LENGTH)) {
    sub DHB_LENGTH () {	512;}
}
unless(defined(&FP_BUF_LEN)) {
    sub FP_BUF_LEN () {	536;}
}
unless(defined(&NUM_DHB)) {
    sub NUM_DHB () {	1;}
}
unless(defined(&DLC_MAX_SAP)) {
    sub DLC_MAX_SAP () {	0;}
}
unless(defined(&DLC_MAX_STA)) {
    sub DLC_MAX_STA () {	0;}
}
unless(defined(&DLC_MAX_GSAP)) {
    sub DLC_MAX_GSAP () {	0;}
}
unless(defined(&DLC_MAX_GMEM)) {
    sub DLC_MAX_GMEM () {	0;}
}
unless(defined(&DLC_TICK)) {
    sub DLC_TICK () {	0;}
}
unless(defined(&OPEN_OK)) {
    sub OPEN_OK () {	0x00;}
}
unless(defined(&OPEN_BAD_COMMAND)) {
    sub OPEN_BAD_COMMAND () {	0x01;}
}
unless(defined(&OPEN_ALREADY)) {
    sub OPEN_ALREADY () {	0x03;}
}
unless(defined(&OPEN_MISSING_PARAMS)) {
    sub OPEN_MISSING_PARAMS () {	0x05;}
}
unless(defined(&OPEN_UNRECOV_FAIL)) {
    sub OPEN_UNRECOV_FAIL () {	0x07;}
}
unless(defined(&OPEN_INAD_REC_BUFS)) {
    sub OPEN_INAD_REC_BUFS () {	0x30;}
}
unless(defined(&OPEN_BAD_NODE_ADDR)) {
    sub OPEN_BAD_NODE_ADDR () {	0x32;}
}
unless(defined(&OPEN_BAD_REC_BUF_LEN)) {
    sub OPEN_BAD_REC_BUF_LEN () {	0x33;}
}
unless(defined(&OPEN_BAD_XMIT_BUF_LEN)) {
    sub OPEN_BAD_XMIT_BUF_LEN () {	0x43;}
}
unless(defined(&PARITY_ERROR)) {
    sub PARITY_ERROR () {	0x80;}
}
unless(defined(&TIMER_STAT)) {
    sub TIMER_STAT () {	0x40;}
}
unless(defined(&ACCESS_STAT)) {
    sub ACCESS_STAT () {	0x20;}
}
unless(defined(&DEADMAN_TIMER)) {
    sub DEADMAN_TIMER () {	0x10;}
}
unless(defined(&PROCESSOR_CK)) {
    sub PROCESSOR_CK () {	0x08;}
}
unless(defined(&H_INT_MASK)) {
    sub H_INT_MASK () {	0x02;}
}
unless(defined(&S_INT_MASK)) {
    sub S_INT_MASK () {	0x01;}
}
unless(defined(&XMIT_REQ)) {
    sub XMIT_REQ () {	0x40;}
}
unless(defined(&CMD_IN_SRB)) {
    sub CMD_IN_SRB () {	0x20;}
}
unless(defined(&RESP_IN_ASB)) {
    sub RESP_IN_ASB () {	0x10;}
}
unless(defined(&SRB_FREE)) {
    sub SRB_FREE () {	0x08;}
}
unless(defined(&ASB_FREE)) {
    sub ASB_FREE () {	0x04;}
}
unless(defined(&ARB_FREE)) {
    sub ARB_FREE () {	0x02;}
}
unless(defined(&SSB_FREE)) {
    sub SSB_FREE () {	0x01;}
}
unless(defined(&NMI_INT_CTL)) {
    sub NMI_INT_CTL () {	0x80;}
}
unless(defined(&INT_ENABLE)) {
    sub INT_ENABLE () {	0x40;}
}
unless(defined(&TCR_INT)) {
    sub TCR_INT () {	0x10;}
}
unless(defined(&ERR_INT)) {
    sub ERR_INT () {	0x08;}
}
unless(defined(&ACCESS_INT)) {
    sub ACCESS_INT () {	0x04;}
}
unless(defined(&SHARED_INT_BLK)) {
    sub SHARED_INT_BLK () {	0x02;}
}
unless(defined(&PRIM_ALT_ADDR)) {
    sub PRIM_ALT_ADDR () {	0x01;}
}
unless(defined(&ADAP_CHK_INT)) {
    sub ADAP_CHK_INT () {	0x40;}
}
unless(defined(&SRB_RESP_INT)) {
    sub SRB_RESP_INT () {	0x20;}
}
unless(defined(&ASB_FREE_INT)) {
    sub ASB_FREE_INT () {	0x10;}
}
unless(defined(&ARB_CMD_INT)) {
    sub ARB_CMD_INT () {	0x08;}
}
unless(defined(&SSB_RESP_INT)) {
    sub SSB_RESP_INT () {	0x04;}
}
unless(defined(&XMIT_COMPLETE)) {
    sub XMIT_COMPLETE () {	0x02;}
}
unless(defined(&DLC_HDR_LEN)) {
    sub DLC_HDR_LEN () {	0x3;}
}
unless(defined(&SNAP_LENGTH)) {
    sub SNAP_LENGTH () {	0x05;}
}
unless(defined(&HDR_LNGTH_NOROUTE)) {
    sub HDR_LNGTH_NOROUTE () {	14;}
}
unless(defined(&SKIP_DSAP_SSAP)) {
    sub SKIP_DSAP_SSAP () {	0x02;}
}
unless(defined(&TR_MAX_LINK_HDR)) {
    sub TR_MAX_LINK_HDR () {	46;}
}
unless(defined(&DLC_RESET)) {
    sub DLC_RESET () {	0x14;}
}
unless(defined(&DLC_OPEN_SAP)) {
    sub DLC_OPEN_SAP () {	0x15;}
}
unless(defined(&DLC_CLOSE_SAP)) {
    sub DLC_CLOSE_SAP () {	0x16;}
}
unless(defined(&DLC_REALLOCATE)) {
    sub DLC_REALLOCATE () {	0x17;}
}
unless(defined(&DLC_OPEN_STATION)) {
    sub DLC_OPEN_STATION () {	0x19;}
}
unless(defined(&DLC_CLOSE_STATION)) {
    sub DLC_CLOSE_STATION () {	0x1a;}
}
unless(defined(&DLC_CONNECT_STATION)) {
    sub DLC_CONNECT_STATION () {	0x1b;}
}
unless(defined(&DLC_MODIFY)) {
    sub DLC_MODIFY () {	0x1c;}
}
unless(defined(&DLC_FLOW_CONTROL)) {
    sub DLC_FLOW_CONTROL () {	0x1d;}
}
unless(defined(&DLC_STATISTICS)) {
    sub DLC_STATISTICS () {	0x1e;}
}
unless(defined(&SIGNAL_LOSS)) {
    sub SIGNAL_LOSS () {	0x8000;}
}
unless(defined(&HARD_ERR)) {
    sub HARD_ERR () {	0x4000;}
}
unless(defined(&SOFT_ERR)) {
    sub SOFT_ERR () {	0x2000;}
}
unless(defined(&LOBE_FAULT)) {
    sub LOBE_FAULT () {	0x0800;}
}
unless(defined(&LOG_OFLOW)) {
    sub LOG_OFLOW () {	0x0080;}
}
unless(defined(&SINGLE_STATION)) {
    sub SINGLE_STATION () {	0x0040;}
}
1;
