
/* my additions */
typedef word64 w64;
typedef uword64 uw64;

#if defined(SIM_MANIFESTS)
#define MIPSISA (4)
#define PROCESSOR_64BIT (1 == 1)
#define LOADDRMASK (0x00000007)
#define GPRLEN (64)
typedef word64 t_reg;
typedef uword64 ut_reg;
typedef word64 t_fpreg;
#define HASFPU (1 == 1)
#define WARN_STALL (1 == 1)
#define WARN_LOHI (1 == 1)
#define WARN_ZERO (1 == 1)
#define WARN_R31 (1 == 1)
#else /* simulator engine */
/* Engine generated by "<SHOW PROGRAM ARGS>" at <SHOW CURRENT DATE AND TIME> */
/* Main instruction decode for 64-bit MIPS ISA 4 (Table entry limit = 170) */
/* Single precision FP instructions included */
/* NOTE: "DSPC" is the delay slot PC address */
#if !defined(PROCESSOR_64BIT)
#error "Automatically constructed decoder has been built for a 64bit processor"
#endif
/* Actual instruction decoding block */
{
uw64 /*int*/ num = ((instruction >> 26) & 0x0000003F);
if (num == 0x00) num = (64 + ((instruction >> 0) & 0x0000003F));
else if (num == 0x01) num = (128 + ((instruction >> 16) & 0x0000001F));
else if (num == 0x11) {
 if ((instruction & (0x00000001 << 25)) == 0x02000000)
  if ((instruction & (0x00000003 << 4)) == 0x00000030)
   num = (160 + ((instruction >> 0) & 0x00000030));
  else
   num = (160 + ((instruction >> 0) & 0x0000003F));
 else
  num = (224 + (((instruction >> 21) & 0x0000000F) & ~0x00000004));
} else if (num == 0x13) num = (240 + ((instruction >> 0) & 0x0000003F));
/* Total possible switch entries: 304 */
switch (num)
{
case 165 : /* "ABS" 01000110mmm00000vvvvvrrrrr000101 */
 if ((instruction & 0xFF1F003F) != 0x46000005)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,AbsoluteValue(ValueFPR(fs,format),format));
  }
 }
 break ;
case 96 : /* "ADD" 000000sssssgggggddddd00000100000 */
 if ((instruction & 0xFC0007FF) != 0x00000020)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   unsigned int temp = (unsigned int)(op1 + op2);
   signed int tempS = (signed int)temp;
   if (((op1 < 0) == (op2 < 0)) && ((tempS < 0) != (op1 < 0)))
    SignalException(IntegerOverflow);
   else
   GPR[destreg] = SIGNEXTEND(((uword64)temp),32);
  }
 }
 break ;
case 160 : /* "ADD" 01000110mmmkkkkkvvvvvrrrrr000000 */
 if ((instruction & 0xFF00003F) != 0x46000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Add(ValueFPR(fs,format),ValueFPR(ft,format),format));
  }
 }
 break ;
case 8 : /* "ADDI" 001000ssssstttttiiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   unsigned int temp = (unsigned int)(op1 + op2);
   signed int tempS = (signed int)temp;
   if (((op1 < 0) == (op2 < 0)) && ((tempS < 0) != (op1 < 0)))
    SignalException(IntegerOverflow);
   else
   GPR[destreg] = SIGNEXTEND(((uword64)temp),32);
  }
 }
 break ;
case 97 : /* "ADDU" 000000sssssgggggddddd00000100001 */
 if ((instruction & 0xFC0007FF) != 0x00000021)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   unsigned int temp = (unsigned int)(op1 + op2);
   signed int tempS = (signed int)temp;
   GPR[destreg] = SIGNEXTEND(((uword64)temp),32);
  }
 }
 break ;
case 9 : /* "ADDIU" 001001ssssstttttiiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   unsigned int temp = (unsigned int)(op1 + op2);
   signed int tempS = (signed int)temp;
   GPR[destreg] = SIGNEXTEND(((uword64)temp),32);
  }
 }
 break ;
case 100 : /* "AND" 000000sssssgggggddddd00000100100 */
 if ((instruction & 0xFC0007FF) != 0x00000024)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   GPR[destreg] = (op1 & op2);
  }
 }
 break ;
case 12 : /* "ANDI" 001100ssssstttttzzzzzzzzzzzzzzzz */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  ut_reg op2 = ((instruction >> 0) & 0x0000FFFF);
  {
   GPR[destreg] = (op1 & op2);
  }
 }
 break ;
case 232 : /* "BC1" 01000101000qqqfcllllllllllllllll */
 if ((instruction & 0xFFE00000) != 0x45000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ boolean = ((instruction >> 16) & 0x00000001);
  uw64 /*int*/ likely = ((instruction >> 17) & 0x00000001);
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  uw64 /*int*/ condition_code = ((instruction >> 18) & 0x00000007);
  {
   int condition = (GETFCC(condition_code) == boolean);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else if (likely) {
    NULLIFY();
   }
  }
 }
 break ;
case 4 : /* "BEQ" 000100sssssgggggllllllllllllllll */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 == op2);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 20 : /* "BEQL" 010100sssssgggggllllllllllllllll */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 == op2);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 129 : /* "BGEZ" 000001sssss00001llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 >= 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 145 : /* "BGEZAL" 000001sssss10001llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 >= 0);
   if (((instruction >> 21) & 0x0000001F) == 31)
    sim_warning("Branch with link using r31 as source operand");
   GPR[31] = (PC + 4); /* NOTE: PC is already 8 ahead */
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 147 : /* "BGEZALL" 000001sssss10011llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 >= 0);
   if (((instruction >> 21) & 0x0000001F) == 31)
    sim_warning("Branch with link using r31 as source operand");
   GPR[31] = (PC + 4); /* NOTE: PC is already 8 ahead */
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 131 : /* "BGEZL" 000001sssss00011llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 >= 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 7 : /* "BGTZ" 000111sssss00000llllllllllllllll */
 if ((instruction & 0xFC1F0000) != 0x1C000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 > 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 23 : /* "BGTZL" 010111sssss00000llllllllllllllll */
 if ((instruction & 0xFC1F0000) != 0x5C000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 > 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 6 : /* "BLEZ" 000110sssss00000llllllllllllllll */
 if ((instruction & 0xFC1F0000) != 0x18000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 <= 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 22 : /* "BLEZL" 010110sssss00000llllllllllllllll */
 if ((instruction & 0xFC1F0000) != 0x58000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 <= 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 128 : /* "BLTZ" 000001sssss00000llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 < 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 144 : /* "BLTZAL" 000001sssss10000llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 < 0);
   if (((instruction >> 21) & 0x0000001F) == 31)
    sim_warning("Branch with link using r31 as source operand");
   GPR[31] = (PC + 4); /* NOTE: PC is already 8 ahead */
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 146 : /* "BLTZALL" 000001sssss10010llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 < 0);
   if (((instruction >> 21) & 0x0000001F) == 31)
    sim_warning("Branch with link using r31 as source operand");
   GPR[31] = (PC + 4); /* NOTE: PC is already 8 ahead */
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 130 : /* "BLTZL" 000001sssss00010llllllllllllllll */
 {
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 < 0);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 5 : /* "BNE" 000101sssssgggggllllllllllllllll */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 != op2);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
  }
 }
 break ;
case 21 : /* "BNEL" 010101sssssgggggllllllllllllllll */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)(((instruction >> 0) & 0x0000FFFF) << 2),18);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   int condition = (op1 != op2);
   /* NOTE: The branch occurs AFTER the next instruction has been executed */
   if (condition) {
    DSPC = (PC + offset);
    DELAYSLOT();
   }
   else
    NULLIFY();
  }
 }
 break ;
case 77 : /* "BREAK" 000000????????????????????001101 */
 {
  {
   SignalException(BreakPoint,instruction);
  }
 }
 break ;
case 170 : /* "CEIL.L" 01000110mmm00000vvvvvrrrrr001010 */
 if ((instruction & 0xFF1F003F) != 0x4600000A)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_long,Convert(FP_RM_TOPINF,ValueFPR(fs,format),format,fmt_long));
  }
 }
 break ;
case 174 : /* "CEIL.W" 01000110mmm00000vvvvvrrrrr001110 */
 if ((instruction & 0xFF1F003F) != 0x4600000E)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_word,Convert(FP_RM_TOPINF,ValueFPR(fs,format),format,fmt_word));
  }
 }
 break ;
case 16 : /* "COP0" 010000?????????????????????????? */
 {
  {
   decode_coproc(instruction);
  }
 }
 break ;
case 18 : /* "COP2" 010010?????????????????????????? */
 {
  {
   decode_coproc(instruction);
  }
 }
 break ;
case 193 : /* "CVT.D" 01000110mmm00000vvvvvrrrrr100001 */
 if ((instruction & 0xFF1F003F) != 0x46000021)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   if ((format == fmt_double) | 0)
    SignalException(ReservedInstruction,instruction);
   else
    StoreFPR(destreg,fmt_double,Convert(GETRM(),ValueFPR(fs,format),format,fmt_double));
  }
 }
 break ;
case 197 : /* "CVT.L" 01000110mmm00000vvvvvrrrrr100101 */
 if ((instruction & 0xFF1F003F) != 0x46000025)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   if ((format == fmt_long) | ((format == fmt_long) || (format == fmt_word)))
    SignalException(ReservedInstruction,instruction);
   else
    StoreFPR(destreg,fmt_long,Convert(GETRM(),ValueFPR(fs,format),format,fmt_long));
  }
 }
 break ;
case 192 : /* "CVT.S" 01000110mmm00000vvvvvrrrrr100000 */
 if ((instruction & 0xFF1F003F) != 0x46000020)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   if ((format == fmt_single) | 0)
    SignalException(ReservedInstruction,instruction);
   else
    StoreFPR(destreg,fmt_single,Convert(GETRM(),ValueFPR(fs,format),format,fmt_single));
  }
 }
 break ;
case 196 : /* "CVT.W" 01000110mmm00000vvvvvrrrrr100100 */
 if ((instruction & 0xFF1F003F) != 0x46000024)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   if ((format == fmt_word) | ((format == fmt_long) || (format == fmt_word)))
    SignalException(ReservedInstruction,instruction);
   else
    StoreFPR(destreg,fmt_word,Convert(GETRM(),ValueFPR(fs,format),format,fmt_word));
  }
 }
 break ;
case 208 : /* "C.%s" 01000110mmmkkkkkvvvvvppp0011uuuu */
 if ((instruction & 0xFF0000F0) != 0x46000030)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ condition_code = ((instruction >> 8) & 0x00000007);
  uw64 /*int*/ cmpflags = ((instruction >> 0) & 0x0000000F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   if ((format != fmt_single) && (format != fmt_double))
    SignalException(ReservedInstruction,instruction);
   else {
     {
      int ignore = 0;
      int less = 0;
      int equal = 0;
      int unordered = 1;
      uword64 ofs = ValueFPR(fs,format);
      uword64 oft = ValueFPR(ft,format);
      if (NaN(ofs,format) || NaN(oft,format)) {
      if (FCSR & FP_ENABLE(IO)) {
       FCSR |= FP_CAUSE(IO);
       SignalException(FPE);
       ignore = 1;
      }
     } else {
      less = Less(ofs,oft,format);
      equal = Equal(ofs,oft,format);
      unordered = 0;
     }
     if (!ignore) {
      uw64 /*int FIXME*/ condition = (((cmpflags & (1 << 2)) && less) || ((cmpflags & (1 << 1)) && equal) || ((cmpflags & (1 << 0)) && unordered));
      SETFCC(condition_code,condition);
     }
    }
   }
  }
 }
 break ;
case 226 : /* "CxC1" 01000100x10kkkkkvvvvv00000000000 */
 if ((instruction & 0xFF6007FF) != 0x44400000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  uw64 /*int*/ to = ((instruction >> 23) & 0x00000001);
  {
    if (to) {
     if (fs == 0) {
      FCR0 = WORD64LO(GPR[ft]);
     } else if (fs == 31) {
      FCR31 = WORD64LO(GPR[ft]);
     } /* else NOP */
     SETFCC(0,((FCR31 & (1 << 23)) ? 1 : 0)); /* COC[1] */
    } else { /* control from */
     if (fs == 0) {
      GPR[ft] = SIGNEXTEND(FCR0,32);
     } else if (fs == 31) {
      GPR[ft] = SIGNEXTEND(FCR31,32);
     } /* else NOP */
    }
  }
 }
 break ;
case 108 : /* "DADD" 000000sssssgggggddddd00000101100 */
 if ((instruction & 0xFC0007FF) != 0x0000002C)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 temp = (uword64)(op1 + op2);
   word64 tempS = (word64)temp;
   if (((op1 < 0) == (op2 < 0)) && ((tempS < 0) != (op1 < 0)))
    SignalException(IntegerOverflow);
   else
   GPR[destreg] = (uword64)temp;
  }
 }
 break ;
case 24 : /* "DADDI" 011000ssssstttttiiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 temp = (uword64)(op1 + op2);
   word64 tempS = (word64)temp;
   if (((op1 < 0) == (op2 < 0)) && ((tempS < 0) != (op1 < 0)))
    SignalException(IntegerOverflow);
   else
   GPR[destreg] = (uword64)temp;
  }
 }
 break ;
case 109 : /* "DADDU" 000000sssssgggggddddd00000101101 */
 if ((instruction & 0xFC0007FF) != 0x0000002D)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 temp = (uword64)(op1 + op2);
   word64 tempS = (word64)temp;
   GPR[destreg] = (uword64)temp;
  }
 }
 break ;
case 25 : /* "DADDIU" 011001ssssstttttiiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 temp = (uword64)(op1 + op2);
   word64 tempS = (word64)temp;
   GPR[destreg] = (uword64)temp;
  }
 }
 break ;
case 94 : /* "DDIV" 000000sssssggggg0000000000011110 */
 if ((instruction & 0xFC00FFFF) != 0x0000001E)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Division");
   {
   LO = ((word64)op1 / (word64)op2);
   HI = ((word64)op1 % (word64)op2);
   }
  }
 }
 break ;
case 95 : /* "DDIVU" 000000sssssggggg0000000000011111 */
 if ((instruction & 0xFC00FFFF) != 0x0000001F)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Division");
   {
   LO = ((uword64)op1 / (uword64)op2);
   HI = ((uword64)op1 % (uword64)op2);
   }
  }
 }
 break ;
case 90 : /* "DIV" 000000sssssggggg0000000000011010 */
 if ((instruction & 0xFC00FFFF) != 0x0000001A)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Division");
   {
   LO = SIGNEXTEND(((int)op1 / (int)op2),32);
   HI = SIGNEXTEND(((int)op1 % (int)op2),32);
   }
  }
 }
 break ;
case 163 : /* "DIV" 01000110mmmkkkkkvvvvvrrrrr000011 */
 if ((instruction & 0xFF00003F) != 0x46000003)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Divide(ValueFPR(fs,format),ValueFPR(ft,format),format));
  }
 }
 break ;
case 91 : /* "DIVU" 000000sssssggggg0000000000011011 */
 if ((instruction & 0xFC00FFFF) != 0x0000001B)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Division");
   {
   LO = SIGNEXTEND(((unsigned int)op1 / (unsigned int)op2),32);
   HI = SIGNEXTEND(((unsigned int)op1 % (unsigned int)op2),32);
   }
  }
 }
 break ;
case 92 : /* "DMULT" 000000sssssggggg0000000000011100 */
 if ((instruction & 0xFC00FFFF) != 0x0000001C)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Multiplication");
   {
   uword64 mid;
   uword64 midhi;
   uword64 temp;
   int sign = 0;
   if (op1 < 0) { op1 = - op1; ++sign; }
   if (op2 < 0) { op2 = - op2; ++sign; }
   LO = ((uword64)WORD64LO(op1) * WORD64LO(op2));
   HI = ((uword64)WORD64HI(op1) * WORD64HI(op2));
   mid = ((uword64)WORD64HI(op1) * WORD64LO(op2));
   midhi = SET64HI(WORD64LO(mid));
   temp = (LO + midhi);
   if ((temp == midhi) ? (LO != 0) : (temp < midhi))
    HI += 1;
   HI += WORD64HI(mid);
   mid = ((uword64)WORD64LO(op1) * WORD64HI(op2));
   midhi = SET64HI(WORD64LO(mid));
   LO = (temp + midhi);
   if ((LO == midhi) ? (temp != 0) : (LO < midhi))
    HI += 1;
   HI += WORD64HI(mid);
   if (sign & 1) { LO = 0 - LO; HI = (LO == 0 ? 0 : ((uword64)-1)) - HI; }
   }
  }
 }
 break ;
case 93 : /* "DMULTU" 000000sssssggggg0000000000011101 */
 if ((instruction & 0xFC00FFFF) != 0x0000001D)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Multiplication");
   {
   uword64 mid;
   uword64 midhi;
   uword64 temp;
   LO = ((uword64)WORD64LO(op1) * WORD64LO(op2));
   HI = ((uword64)WORD64HI(op1) * WORD64HI(op2));
   mid = ((uword64)WORD64HI(op1) * WORD64LO(op2));
   midhi = SET64HI(WORD64LO(mid));
   temp = (LO + midhi);
   if ((temp == midhi) ? (LO != 0) : (temp < midhi))
    HI += 1;
   HI += WORD64HI(mid);
   mid = ((uword64)WORD64LO(op1) * WORD64HI(op2));
   midhi = SET64HI(WORD64LO(mid));
   LO = (temp + midhi);
   if ((LO == midhi) ? (temp != 0) : (LO < midhi))
    HI += 1;
   HI += WORD64HI(mid);
   }
  }
 }
 break ;
case 225 : /* "DMxC1" 01000100x01kkkkkvvvvv00000000000 */
 if ((instruction & 0xFF6007FF) != 0x44200000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  uw64 /*int*/ to = ((instruction >> 23) & 0x00000001);
  {
    if (to) {
     if (SizeFGR() == 64) {
      FGR[fs] = GPR[ft];
      fpr_state[fs] = fmt_uninterpreted;
     } else
      if ((fs & 0x1) == 0)
       {
        FGR[fs + 1] = WORD64HI(GPR[ft]);
        FGR[fs] = WORD64LO(GPR[ft]);
        fpr_state[fs + 1] = fmt_uninterpreted;
        fpr_state[fs] = fmt_uninterpreted;
       }
    } else {
     if (SizeFGR() == 64)
      GPR[ft] = FGR[fs];
     else
      if ((fs & 0x1) == 0)
       GPR[ft] = (SET64HI(FGR[fs + 1]) | FGR[fs]);
      else {
       GPR[ft] = (SET64HI(0xDEADC0DE) | 0xBAD0BAD0);
      }
    }
  }
 }
 break ;
case 120 : /* "DSLL" 00000000000gggggdddddaaaaa111000 */
 if ((instruction & 0xFFE0003F) != 0x00000038)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   GPR[destreg] = ((uword64)op2 << op1);
  }
 }
 break ;
case 84 : /* "DSLLV" 000000sssssgggggddddd00000010100 */
 if ((instruction & 0xFC0007FF) != 0x00000014)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   op1 &= 0x3F;
   GPR[destreg] = ((uword64)op2 << op1);
  }
 }
 break ;
case 124 : /* "DSLL32" 00000000000gggggdddddaaaaa111100 */
 if ((instruction & 0xFFE0003F) != 0x0000003C)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   op1 |= (1 << 5);
   GPR[destreg] = ((uword64)op2 << op1);
  }
 }
 break ;
case 123 : /* "DSRA" 00000000000gggggdddddaaaaa111011 */
 if ((instruction & 0xFFE0003F) != 0x0000003B)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   GPR[destreg] = ((uword64)(op2) >> op1);
   GPR[destreg] |= (op1 != 0 && (op2 & ((uword64)1 << 63)) ? ((((uword64)1 << op1) - 1) << (64 - op1)) : 0);
  }
 }
 break ;
case 87 : /* "DSRAV" 000000sssssgggggddddd00000010111 */
 if ((instruction & 0xFC0007FF) != 0x00000017)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   op1 &= 0x3F;
   GPR[destreg] = ((uword64)(op2) >> op1);
   GPR[destreg] |= (op1 != 0 && (op2 & ((uword64)1 << 63)) ? ((((uword64)1 << op1) - 1) << (64 - op1)) : 0);
  }
 }
 break ;
case 127 : /* "DSRA32" 00000000000gggggdddddaaaaa111111 */
 if ((instruction & 0xFFE0003F) != 0x0000003F)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   op1 |= (1 << 5);
   GPR[destreg] = ((uword64)(op2) >> op1);
   GPR[destreg] |= (op1 != 0 && (op2 & ((uword64)1 << 63)) ? ((((uword64)1 << op1) - 1) << (64 - op1)) : 0);
  }
 }
 break ;
case 122 : /* "DSRL" 00000000000gggggdddddaaaaa111010 */
 if ((instruction & 0xFFE0003F) != 0x0000003A)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   GPR[destreg] = ((uword64)(op2) >> op1);
  }
 }
 break ;
case 86 : /* "DSRLV" 000000sssssgggggddddd00000010110 */
 if ((instruction & 0xFC0007FF) != 0x00000016)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   op1 &= 0x3F;
   GPR[destreg] = ((uword64)(op2) >> op1);
  }
 }
 break ;
case 126 : /* "DSRL32" 00000000000gggggdddddaaaaa111110 */
 if ((instruction & 0xFFE0003F) != 0x0000003E)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   op1 |= (1 << 5);
   GPR[destreg] = ((uword64)(op2) >> op1);
  }
 }
 break ;
case 110 : /* "DSUB" 000000sssssgggggddddd00000101110 */
 if ((instruction & 0xFC0007FF) != 0x0000002E)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 temp = (uword64)(op1 - op2);
   word64 tempS = (word64)temp;
   GPR[destreg] = (uword64)temp;
  }
 }
 break ;
case 111 : /* "DSUBU" 000000sssssgggggddddd00000101111 */
 if ((instruction & 0xFC0007FF) != 0x0000002F)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 temp = (uword64)(op1 - op2);
   word64 tempS = (word64)temp;
   GPR[destreg] = (uword64)temp;
  }
 }
 break ;
case 171 : /* "FLOOR.L" 01000110mmm00000vvvvvrrrrr001011 */
 if ((instruction & 0xFF1F003F) != 0x4600000B)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_long,Convert(FP_RM_TOMINF,ValueFPR(fs,format),format,fmt_long));
  }
 }
 break ;
case 175 : /* "FLOOR.W" 01000110mmm00000vvvvvrrrrr001111 */
 if ((instruction & 0xFF1F003F) != 0x4600000F)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_word,Convert(FP_RM_TOMINF,ValueFPR(fs,format),format,fmt_word));
  }
 }
 break ;
case 2 : /* "J" 000010jjjjjjjjjjjjjjjjjjjjjjjjjj */
 {
  ut_reg op1 = (((instruction >> 0) & 0x03FFFFFF) << 2);
  op1 |= (PC & ~0x0FFFFFFF); /* address of instruction in delay slot for the jump */
  {
   /* NOTE: The jump occurs AFTER the next instruction has been executed */
   DSPC = op1;
   DELAYSLOT();
  }
 }
 break ;
case 3 : /* "JAL" 000011jjjjjjjjjjjjjjjjjjjjjjjjjj */
 {
  ut_reg op1 = (((instruction >> 0) & 0x03FFFFFF) << 2);
  op1 |= (PC & ~0x0FFFFFFF); /* address of instruction in delay slot for the jump */
  {
   uw64 /*int*/ destreg = 31;
   GPR[destreg] = (PC + 4); /* NOTE: The PC is already 4 ahead within the simulator */
   /* NOTE: The jump occurs AFTER the next instruction has been executed */
   DSPC = op1;
   DELAYSLOT();
  }
 }
 break ;
case 73 : /* "JALR" 000000sssss00000ddddd00000001001 */
 if ((instruction & 0xFC1F07FF) != 0x00000009)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   GPR[destreg] = (PC + 4); /* NOTE: The PC is already 4 ahead within the simulator */
   /* NOTE: The jump occurs AFTER the next instruction has been executed */
   DSPC = op1;
   DELAYSLOT();
  }
 }
 break ;
case 72 : /* "JR" 000000sssss000000000000000001000 */
 if ((instruction & 0xFC1FFFFF) != 0x00000008)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   /* NOTE: The jump occurs AFTER the next instruction has been executed */
   DSPC = op1;
   DELAYSLOT();
  }
 }
 break ;
case 32 : /* "LB" 100000ssssstttttyyyyyyyyyyyyyyyy */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 0;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_BYTE,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (SIGNEXTEND(((memval >> (8 * byte)) & 0x000000FF),8));
    }
   }
  }
 }
 break ;
case 36 : /* "LBU" 100100ssssstttttyyyyyyyyyyyyyyyy */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 0;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_BYTE,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (((memval >> (8 * byte)) & 0x000000FF));
    }
   }
  }
 }
 break ;
case 55 : /* "LD" 110111sssssttttteeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 4;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     memval = LoadMemory(uncached,AccessLength_DOUBLEWORD,paddr,vaddr,isDATA,isREAL);
     GPR[destreg] = memval;
    }
   }
  }
 }
 break ;
case 53 : /* "LDC1" 110101sssssttttteeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 4;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     memval = LoadMemory(uncached,AccessLength_DOUBLEWORD,paddr,vaddr,isDATA,isREAL);
     COP_LD(((instruction >> 26) & 0x3),destreg,memval);;
    }
   }
  }
 }
 break ;
case 54 : /* "LDC2" 110110sssssttttteeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 4;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     memval = LoadMemory(uncached,AccessLength_DOUBLEWORD,paddr,vaddr,isDATA,isREAL);
     COP_LD(((instruction >> 26) & 0x3),destreg,memval);;
    }
   }
  }
 }
 break ;
case 26 : /* "LDL" 011010ssssstttttyyyyyyyyyyyyyyyy */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 7;
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     //uw64 /*int*/ byte;
     int byte; /* FIXME */
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (!BigEndianMem)
      paddr &= ~mask;
     memval = LoadMemory(uncached,byte,paddr,vaddr,isDATA,isREAL);
     GPR[destreg] = ((memval << ((7 - byte) * 8)) | (GPR[destreg] & (((uword64)1 << ((7 - byte) * 8)) - 1)));
    }
   }
  }
 }
 break ;
case 27 : /* "LDR" 011011ssssstttttyyyyyyyyyyyyyyyy */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 7;
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     int /*FIXME*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (BigEndianMem)
      paddr &= ~mask;
     memval = LoadMemory(uncached,(7 - byte),paddr,vaddr,isDATA,isREAL);
     {
      uword64 srcmask;
      if (byte == 0)
       srcmask = 0;
      else
       srcmask = ((uword64)-1 << (8 * (8 - byte)));
      GPR[destreg] = ((GPR[destreg] & srcmask) | (memval >> (8 * byte)));
     }
    }
   }
  }
 }
 break ;
case 241 : /* "LDXC1" 010011sssssggggg00000rrrrr000001 */
 if ((instruction & 0xFC00F83F) != 0x4C000001)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 vaddr = ((uword64)op1 + op2);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 4;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     memval = LoadMemory(uncached,AccessLength_DOUBLEWORD,paddr,vaddr,isDATA,isREAL);
     COP_LD(1,destreg,memval);;
    }
   }
  }
 }
 break ;
case 33 : /* "LH" 100001sssssttttthhhhhhhhhhhhhhhh */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 1) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 1;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_HALFWORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (SIGNEXTEND(((memval >> (8 * byte)) & 0x0000FFFF),16));
    }
   }
  }
 }
 break ;
case 37 : /* "LHU" 100101sssssttttthhhhhhhhhhhhhhhh */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 1) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 1;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_HALFWORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (((memval >> (8 * byte)) & 0x0000FFFF));
    }
   }
  }
 }
 break ;
case 48 : /* "LL" 110000ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 2;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_WORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (SIGNEXTEND(((memval >> (8 * byte)) & 0xFFFFFFFF),32));
     LLBIT = 1;
    }
   }
  }
 }
 break ;
case 52 : /* "LLD" 110100sssssttttteeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 4;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     memval = LoadMemory(uncached,AccessLength_DOUBLEWORD,paddr,vaddr,isDATA,isREAL);
     GPR[destreg] = memval;
     LLBIT = 1;
    }
   }
  }
 }
 break ;
case 15 : /* "LUI" 00111100000tttttiiiiiiiiiiiiiiii */
 if ((instruction & 0xFFE00000) != 0x3C000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   GPR[destreg] = (op2 << 16);
  }
 }
 break ;
case 35 : /* "LW" 100011ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 2;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_WORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (SIGNEXTEND(((memval >> (8 * byte)) & 0xFFFFFFFF),32));
    }
   }
  }
 }
 break ;
case 49 : /* "LWC1" 110001ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 2;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_WORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     COP_LW(((instruction >> 26) & 0x3),destreg,(unsigned int)((memval >> (8 * byte)) & 0xFFFFFFFF));
    }
   }
  }
 }
 break ;
case 50 : /* "LWC2" 110010ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 2;
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_WORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     COP_LW(((instruction >> 26) & 0x3),destreg,(unsigned int)((memval >> (8 * byte)) & 0xFFFFFFFF));
    }
   }
  }
 }
 break ;
case 34 : /* "LWL" 100010ssssstttttyyyyyyyyyyyyyyyy */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 3;
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     int /*FIXME*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (!BigEndianMem)
      paddr &= ~mask;
     memval = LoadMemory(uncached,byte,paddr,vaddr,isDATA,isREAL);
    if ((vaddr & (1 << 2)) ^ (BigEndianCPU << 2)) {
     memval >>= 32;
    }
     GPR[destreg] = ((memval << ((3 - byte) * 8)) | (GPR[destreg] & (((uword64)1 << ((3 - byte) * 8)) - 1)));
     GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
    }
   }
  }
 }
 break ;
case 38 : /* "LWR" 100110ssssstttttyyyyyyyyyyyyyyyy */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 3;
     //uword64 reverse = (ReverseEndian ? mask : 0);
     //uword64 bigend = (BigEndianCPU ? mask : 0);
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     int /*FIXME*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (BigEndianMem)
      paddr &= ~mask;
     memval = LoadMemory(uncached,(3 - byte),paddr,vaddr,isDATA,isREAL);
    if ((vaddr & (1 << 2)) ^ (BigEndianCPU << 2)) {
     memval >>= 32;
    }
     {
      uword64 srcmask;
      if (byte == 0)
       srcmask = 0;
      else
       srcmask = ((uword64)-1 << (8 * (4 - byte)));
      GPR[destreg] = ((GPR[destreg] & srcmask) | (memval >> (8 * byte)));
     }
     GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
    }
   }
  }
 }
 break ;
case 39 : /* "LWU" 100111ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 2;
     //uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     //uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_WORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     GPR[destreg] = (((memval >> (8 * byte)) & 0xFFFFFFFF));
    }
   }
  }
 }
 break ;
case 240 : /* "LWXC1" 010011sssssggggg00000rrrrr000000 */
 if ((instruction & 0xFC00F83F) != 0x4C000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 vaddr = ((uword64)op1 + op2);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressLoad);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 2;
     //uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     //uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     memval = LoadMemory(uncached,AccessLength_WORD,paddr,vaddr,isDATA,isREAL);
     byte = ((vaddr & mask) ^ (bigend << shift));
     COP_LW(1,destreg,(unsigned int)((memval >> (8 * byte)) & 0xFFFFFFFF));
    }
   }
  }
 }
 break ;
case 273 : /* "MADD.D" 010011bbbbbkkkkkvvvvvrrrrr100001 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_double,Add(Multiply(ValueFPR(fs,fmt_double),ValueFPR(ft,fmt_double),fmt_double),ValueFPR(fr,fmt_double),fmt_double));
  }
 }
 break ;
case 272 : /* "MADD.S" 010011bbbbbkkkkkvvvvvrrrrr100000 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_single,Add(Multiply(ValueFPR(fs,fmt_single),ValueFPR(ft,fmt_single),fmt_single),ValueFPR(fr,fmt_single),fmt_single));
  }
 }
 break ;
case 80 : /* "MFHI" 0000000000000000ddddd00000010000 */
 if ((instruction & 0xFFFF07FF) != 0x00000010)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  {
   GPR[destreg] = HI;
   HIACCESS = 3; /* 3rd instruction will be safe */
  }
 }
 break ;
case 82 : /* "MFLO" 0000000000000000ddddd00000010010 */
 if ((instruction & 0xFFFF07FF) != 0x00000012)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  {
   GPR[destreg] = LO;
   LOACCESS = 3; /* 3rd instruction will be safe */
  }
 }
 break ;
case 81 : /* "MTHI" 000000sssss000000000000000010001 */
 if ((instruction & 0xFC1FFFFF) != 0x00000011)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if (HIACCESS != 0)
     sim_warning("MT (move-to) over-writing HI register value");
   HI = op1;
   HIACCESS = 3; /* 3rd instruction will be safe */
  }
 }
 break ;
case 83 : /* "MTLO" 000000sssss000000000000000010011 */
 if ((instruction & 0xFC1FFFFF) != 0x00000013)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if (LOACCESS != 0)
     sim_warning("MT (move-to) over-writing LO register value");
   LO = op1;
   LOACCESS = 3; /* 3rd instruction will be safe */
  }
 }
 break ;
case 166 : /* "MOV" 01000110mmm00000vvvvvrrrrr000110 */
 if ((instruction & 0xFF1F003F) != 0x46000006)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,format,ValueFPR(fs,format));
  }
 }
 break ;
case 75 : /* "MOVN" 000000sssssgggggddddd00000001011 */
 if ((instruction & 0xFC0007FF) != 0x0000000B)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if (op2 != 0)
    GPR[destreg] = op1;
  }
 }
 break ;
case 179 : /* "MOVN" 01000110mmmgggggvvvvvrrrrr010011 */
 if ((instruction & 0xFF00003F) != 0x46000013)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,format,ValueFPR(fs,format));
  }
 }
 break ;
case 65 : /* "MOV%c" 000000sssssqqq0cddddd00000000001 */
 if ((instruction & 0xFC0207FF) != 0x00000001)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ boolean = ((instruction >> 16) & 0x00000001);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  uw64 /*int*/ condition_code = ((instruction >> 18) & 0x00000007);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if (GETFCC(condition_code) == boolean)
    GPR[destreg] = op1;
  }
 }
 break ;
case 177 : /* "MOV%c" 01000110mmmqqq0cvvvvvrrrrr010001 */
 if ((instruction & 0xFF02003F) != 0x46000011)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ boolean = ((instruction >> 16) & 0x00000001);
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ condition_code = ((instruction >> 18) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   if (GETFCC(condition_code) == boolean)
    StoreFPR(destreg,format,ValueFPR(fs,format));
   else
    StoreFPR(destreg,format,ValueFPR(destreg,format));
  }
 }
 break ;
case 74 : /* "MOVZ" 000000sssssgggggddddd00000001010 */
 if ((instruction & 0xFC0007FF) != 0x0000000A)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if (op2 == 0)
    GPR[destreg] = op1;
  }
 }
 break ;
case 178 : /* "MOVZ" 01000110mmmgggggvvvvvrrrrr010010 */
 if ((instruction & 0xFF00003F) != 0x46000012)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,format,ValueFPR(fs,format));
  }
 }
 break ;
case 281 : /* "MSUB.D" 010011bbbbbkkkkkvvvvvrrrrr101001 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_double,(Sub(Multiply(ValueFPR(fs,fmt_double),ValueFPR(ft,fmt_double),fmt_double),ValueFPR(fr,fmt_double),fmt_double),fmt_double));
  }
 }
 break ;
case 280 : /* "MSUB.S" 010011bbbbbkkkkkvvvvvrrrrr101000 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_single,(Sub(Multiply(ValueFPR(fs,fmt_single),ValueFPR(ft,fmt_single),fmt_single),ValueFPR(fr,fmt_single),fmt_single),fmt_single));
  }
 }
 break ;
case 162 : /* "MUL" 01000110mmmkkkkkvvvvvrrrrr000010 */
 if ((instruction & 0xFF00003F) != 0x46000002)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Multiply(ValueFPR(fs,format),ValueFPR(ft,format),format));
  }
 }
 break ;
case 88 : /* "MULT" 000000sssssggggg0000000000011000 */
 if ((instruction & 0xFC00FFFF) != 0x00000018)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Multiplication");
   {
   uword64 temp = (op1 * op2);
   LO = SIGNEXTEND((uword64)WORD64LO(temp),32);
   HI = SIGNEXTEND((uword64)WORD64HI(temp),32);
   }
  }
 }
 break ;
case 89 : /* "MULTU" 000000sssssggggg0000000000011001 */
 if ((instruction & 0xFC00FFFF) != 0x00000019)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   CHECKHILO("Multiplication");
   {
   uword64 temp = ((uword64)(op1 & 0xffffffff) * (uword64)(op2 & 0xffffffff));
   LO = SIGNEXTEND((uword64)WORD64LO(temp),32);
   HI = SIGNEXTEND((uword64)WORD64HI(temp),32);
   }
  }
 }
 break ;
case 224 : /* "MxC1" 01000100x00kkkkkvvvvv00000000000 */
 if ((instruction & 0xFF6007FF) != 0x44000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  uw64 /*int*/ to = ((instruction >> 23) & 0x00000001);
  {
    if (to) {
     if (SizeFGR() == 64)
      FGR[fs] = (SET64HI(0xDEADC0DE) | WORD64LO(GPR[ft]));
     else
      FGR[fs] = WORD64LO(GPR[ft]);
     fpr_state[fs] = fmt_uninterpreted;
    } else {
     GPR[ft] = SIGNEXTEND(FGR[fs],32);
    }
  }
 }
 break ;
case 167 : /* "NEG" 01000110mmm00000vvvvvrrrrr000111 */
 if ((instruction & 0xFF1F003F) != 0x46000007)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Negate(ValueFPR(fs,format),format));
  }
 }
 break ;
case 289 : /* "NMADD.D" 010011bbbbbkkkkkvvvvvrrrrr110001 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_double,Negate(Add(Multiply(ValueFPR(fs,fmt_double),ValueFPR(ft,fmt_double),fmt_double),ValueFPR(fr,fmt_double),fmt_double),fmt_double));
  }
 }
 break ;
case 288 : /* "NMADD.S" 010011bbbbbkkkkkvvvvvrrrrr110000 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_single,Negate(Add(Multiply(ValueFPR(fs,fmt_single),ValueFPR(ft,fmt_single),fmt_single),ValueFPR(fr,fmt_single),fmt_single),fmt_single));
  }
 }
 break ;
case 297 : /* "NMSUB.D" 010011bbbbbkkkkkvvvvvrrrrr111001 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_double,Negate(Sub(Multiply(ValueFPR(fs,fmt_double),ValueFPR(ft,fmt_double),fmt_double),ValueFPR(fr,fmt_double),fmt_double),fmt_double));
  }
 }
 break ;
case 296 : /* "NMSUB.S" 010011bbbbbkkkkkvvvvvrrrrr111000 */
 {
  uw64 /*int*/ fr = ((instruction >> 21) & 0x0000001F);
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   StoreFPR(destreg,fmt_single,Negate(Sub(Multiply(ValueFPR(fs,fmt_single),ValueFPR(ft,fmt_single),fmt_single),ValueFPR(fr,fmt_single),fmt_single),fmt_single));
  }
 }
 break ;
case 103 : /* "NOR" 000000sssssgggggddddd00000100111 */
 if ((instruction & 0xFC0007FF) != 0x00000027)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   GPR[destreg] = ~(op1 | op2);
  }
 }
 break ;
case 101 : /* "OR" 000000sssssgggggddddd00000100101 */
 if ((instruction & 0xFC0007FF) != 0x00000025)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   GPR[destreg] = (op1 | op2);
  }
 }
 break ;
case 13 : /* "ORI" 001101ssssstttttzzzzzzzzzzzzzzzz */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  ut_reg op2 = ((instruction >> 0) & 0x0000FFFF);
  {
   GPR[destreg] = (op1 | op2);
  }
 }
 break ;
case 51 : /* "PREF" 110011sssssnnnnnyyyyyyyyyyyyyyyy */
 {
  uw64 /*int*/ hint = ((instruction >> 16) & 0x0000001F);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
     Prefetch(uncached,paddr,vaddr,isDATA,hint);
   }
  }
 }
 break ;
case 255 : /* "PREFX" 010011sssssgggggvvvvv00000001111 */
 if ((instruction & 0xFC0007FF) != 0x4C00000F)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + (uword64)op2);
   uword64 paddr;
   int uncached;
   if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
    Prefetch(uncached,paddr,vaddr,isDATA,fs);
  }
 }
 break ;
case 181 : /* "RECIP" 01000110mmm00000vvvvvrrrrr010101 */
 if ((instruction & 0xFF1F003F) != 0x46000015)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Recip(ValueFPR(fs,format),format));
  }
 }
 break ;
case 168 : /* "ROUND.L" 01000110mmm00000vvvvvrrrrr001000 */
 if ((instruction & 0xFF1F003F) != 0x46000008)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_long,Convert(FP_RM_NEAREST,ValueFPR(fs,format),format,fmt_long));
  }
 }
 break ;
case 172 : /* "ROUND.W" 01000110mmm00000vvvvvrrrrr001100 */
 if ((instruction & 0xFF1F003F) != 0x4600000C)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_word,Convert(FP_RM_NEAREST,ValueFPR(fs,format),format,fmt_word));
  }
 }
 break ;
case 182 : /* "RSQRT" 01000110mmm00000vvvvvrrrrr010110 */
 if ((instruction & 0xFF1F003F) != 0x46000016)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Recip(SquareRoot(ValueFPR(fs,format),format)));
  }
 }
 break ;
case 40 : /* "SB" 101000sssssgggggyyyyyyyyyyyyyyyy */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 0;
     //uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     //uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     byte = ((vaddr & mask) ^ (bigend << shift));
     memval = (op2 << (8 * byte));
      {
       StoreMemory(uncached,AccessLength_BYTE,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 56 : /* "SC" 111000sssssgggggwwwwwwwwwwwwwwww */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (ReverseEndian << 2)));
     byte = ((vaddr & mask) ^ (BigEndianCPU << 2));
     memval = (op2 << (8 * byte));
      if (LLBIT)
      {
       StoreMemory(uncached,AccessLength_WORD,memval,paddr,vaddr,isREAL);
      }
     GPR[(instruction >> 16) & 0x0000001F] = LLBIT;
    }
   }
  }
 }
 break ;
case 60 : /* "SCD" 111100sssssgggggeeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     memval = op2;
      if (LLBIT)
      {
       StoreMemory(uncached,AccessLength_DOUBLEWORD,memval,paddr,vaddr,isREAL);
      }
     GPR[(instruction >> 16) & 0x0000001F] = LLBIT;
    }
   }
  }
 }
 break ;
case 63 : /* "SD" 111111sssssgggggeeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     memval = op2;
      {
       StoreMemory(uncached,AccessLength_DOUBLEWORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 61 : /* "SDC1" 111101sssssttttteeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     memval = (uword64)COP_SD(((instruction >> 26) & 0x3),destreg);
      {
       StoreMemory(uncached,AccessLength_DOUBLEWORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 62 : /* "SDC2" 111110sssssttttteeeeeeeeeeeeeeee */
 {
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     memval = (uword64)COP_SD(((instruction >> 26) & 0x3),destreg);
      {
       StoreMemory(uncached,AccessLength_DOUBLEWORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 44 : /* "SDL" 101100sssssgggggyyyyyyyyyyyyyyyy */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 7;
     //uword64 reverse = (ReverseEndian ? mask : 0);
     //uword64 bigend = (BigEndianCPU ? mask : 0);
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     int/*FIXME*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (!BigEndianMem)
      paddr &= ~mask;
     memval = (op2 >> (8 * (7 - byte)));
     StoreMemory(uncached,byte,memval,paddr,vaddr,isREAL);
    }
   }
  }
 }
 break ;
case 45 : /* "SDR" 101101sssssgggggyyyyyyyyyyyyyyyy */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 7;
     //uword64 reverse = (ReverseEndian ? mask : 0);
     //uword64 bigend = (BigEndianCPU ? mask : 0);
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     int /*FIXME*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (BigEndianMem)
      paddr &= ~mask;
     memval = (op2 << (byte * 8));
     StoreMemory(uncached,(AccessLength_DOUBLEWORD - byte),memval,paddr,vaddr,isREAL);
    }
   }
  }
 }
 break ;
case 249 : /* "SDXC1" 010011sssssgggggvvvvv00000001001 */
 if ((instruction & 0xFC0007FF) != 0x4C000009)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + op2);
   uword64 paddr;
   int uncached;
   if ((vaddr & 7) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     memval = (uword64)COP_SD(1,fs);
      {
       StoreMemory(uncached,AccessLength_DOUBLEWORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 41 : /* "SH" 101001sssssggggghhhhhhhhhhhhhhhh */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 1) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     unsigned int shift = 1;
     //uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     //uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uword64 reverse = (ReverseEndian ? (mask >> shift) : 0);
     uword64 bigend = (BigEndianCPU ? (mask >> shift) : 0);
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (reverse << shift)));
     byte = ((vaddr & mask) ^ (bigend << shift));
     memval = (op2 << (8 * byte));
      {
       StoreMemory(uncached,AccessLength_HALFWORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 64 : /* "SLL" 00000000000gggggdddddaaaaa000000 */
 if ((instruction & 0xFFE0003F) != 0x00000000)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   GPR[destreg] = ((uword64)op2 << op1);
   GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
  }
 }
 break ;
case 68 : /* "SLLV" 000000ooooogggggddddd00000000100 */
 if ((instruction & 0xFC0007FF) != 0x00000004)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)]&0x1F;
  {
   GPR[destreg] = ((uword64)op2 << op1);
   GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
  }
 }
 break ;
case 106 : /* "SLT" 000000sssssgggggddddd00000101010 */
 if ((instruction & 0xFC0007FF) != 0x0000002A)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if ((word64)op1 < (word64)op2)
    GPR[destreg] = 1;
   else
    GPR[destreg] = 0;
  }
 }
 break ;
case 10 : /* "SLTI" 001010ssssstttttiiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   if ((word64)op1 < (word64)op2)
    GPR[destreg] = 1;
   else
    GPR[destreg] = 0;
  }
 }
 break ;
case 107 : /* "SLTU" 000000sssssgggggddddd00000101011 */
 if ((instruction & 0xFC0007FF) != 0x0000002B)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   if ((uword64)op1 < (uword64)op2)
    GPR[destreg] = 1;
   else
    GPR[destreg] = 0;
  }
 }
 break ;
case 11 : /* "SLTIU" 001011ssssstttttiiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  {
   if ((uword64)op1 < (uword64)op2)
    GPR[destreg] = 1;
   else
    GPR[destreg] = 0;
  }
 }
 break ;
case 164 : /* "SQRT" 01000110mmm00000vvvvvrrrrr000100 */
 if ((instruction & 0xFF1F003F) != 0x46000004)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,(SquareRoot(ValueFPR(fs,format),format)));
  }
 }
 break ;
case 67 : /* "SRA" 00000000000gggggdddddaaaaa000011 */
 if ((instruction & 0xFFE0003F) != 0x00000003)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   GPR[destreg] = ((uword64)(op2 & 0xFFFFFFFF) >> op1);
   GPR[destreg] |= (op1 != 0 && (op2 & ((unsigned int)1 << 31)) ? ((((unsigned int)1 << op1) - 1) << (32 - op1)) : 0);
   GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
  }
 }
 break ;
case 71 : /* "SRAV" 000000ooooogggggddddd00000000111 */
 if ((instruction & 0xFC0007FF) != 0x00000007)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)]&0x1F;
  {
   GPR[destreg] = ((uword64)(op2 & 0xFFFFFFFF) >> op1);
   GPR[destreg] |= (op1 != 0 && (op2 & ((unsigned int)1 << 31)) ? ((((unsigned int)1 << op1) - 1) << (32 - op1)) : 0);
   GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
  }
 }
 break ;
case 66 : /* "SRL" 00000000000gggggdddddaaaaa000010 */
 if ((instruction & 0xFFE0003F) != 0x00000002)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg /*int*/ op1 = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  {
   GPR[destreg] = ((uword64)(op2 & 0xFFFFFFFF) >> op1);
   GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
  }
 }
 break ;
case 70 : /* "SRLV" 000000ooooogggggddddd00000000110 */
 if ((instruction & 0xFC0007FF) != 0x00000006)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)]&0x1F;
  {
   GPR[destreg] = ((uword64)(op2 & 0xFFFFFFFF) >> op1);
   GPR[destreg] = SIGNEXTEND(GPR[destreg],32);
  }
 }
 break ;
case 98 : /* "SUB" 000000sssssgggggddddd00000100010 */
 if ((instruction & 0xFC0007FF) != 0x00000022)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   unsigned int temp = (unsigned int)(op1 - op2);
   signed int tempS = (signed int)temp;
   if (((op1 < 0) != (op2 < 0)) && ((tempS < 0) == (op1 < 0)))
    SignalException(IntegerOverflow);
   else
   GPR[destreg] = SIGNEXTEND(((uword64)temp),32);
  }
 }
 break ;
case 161 : /* "SUB" 01000110mmmkkkkkvvvvvrrrrr000001 */
 if ((instruction & 0xFF00003F) != 0x46000001)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ ft = ((instruction >> 16) & 0x0000001F);
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,format,Sub(ValueFPR(fs,format),ValueFPR(ft,format),format));
  }
 }
 break ;
case 99 : /* "SUBU" 000000sssssgggggddddd00000100011 */
 if ((instruction & 0xFC0007FF) != 0x00000023)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   unsigned int temp = (unsigned int)(op1 - op2);
   signed int tempS = (signed int)temp;
   GPR[destreg] = SIGNEXTEND(((uword64)temp),32);
  }
 }
 break ;
case 43 : /* "SW" 101011sssssgggggwwwwwwwwwwwwwwww */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (ReverseEndian << 2)));
     byte = ((vaddr & mask) ^ (BigEndianCPU << 2));
     memval = (op2 << (8 * byte));
      {
       StoreMemory(uncached,AccessLength_WORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 57 : /* "SWC1" 111001ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (ReverseEndian << 2)));
     byte = ((vaddr & mask) ^ (BigEndianCPU << 2));
     memval = (((uword64)COP_SW(((instruction >> 26) & 0x3),destreg)) << (8 * byte));
      {
       StoreMemory(uncached,AccessLength_WORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 58 : /* "SWC2" 111010ssssstttttwwwwwwwwwwwwwwww */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (ReverseEndian << 2)));
     byte = ((vaddr & mask) ^ (BigEndianCPU << 2));
     memval = (((uword64)COP_SW(((instruction >> 26) & 0x3),destreg)) << (8 * byte));
      {
       StoreMemory(uncached,AccessLength_WORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 42 : /* "SWL" 101010sssssgggggyyyyyyyyyyyyyyyy */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 3;
     //uword64 reverse = (ReverseEndian ? mask : 0);
     //uword64 bigend = (BigEndianCPU ? mask : 0);
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     int /*FIXME*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (!BigEndianMem)
      paddr &= ~mask;
     memval = (op2 >> (8 * (3 - byte)));
    if ((vaddr & (1 << 2)) ^ (BigEndianCPU << 2)) {
     memval <<= 32;
    }
     StoreMemory(uncached,byte,memval,paddr,vaddr,isREAL);
    }
   }
  }
 }
 break ;
case 46 : /* "SWR" 101110sssssgggggyyyyyyyyyyyyyyyy */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   uword64 vaddr = ((uword64)op1 + offset);
   uword64 paddr;
   int uncached;
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 3;
     uword64 reverse = (ReverseEndian ? mask : 0);
     uword64 bigend = (BigEndianCPU ? mask : 0);
     //uw64 /*int*/ byte;
     int byte; /*FIXME*/
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ reverse));
     byte = (int)((vaddr & mask) ^ bigend);
     if (BigEndianMem)
      paddr &= ~mask;
     memval = (op2 << (byte * 8));
    if ((vaddr & (1 << 2)) ^ (BigEndianCPU << 2)) {
     memval <<= 32;
    }
     StoreMemory(uncached,(AccessLength_WORD - byte),memval,paddr,vaddr,isREAL);
    }
   }
  }
 }
 break ;
case 248 : /* "SWXC1" 010011sssssgggggvvvvv00000001000 */
 if ((instruction & 0xFC0007FF) != 0x4C000008)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
   uword64 vaddr = ((uword64)op1 + op2);
   uword64 paddr;
   int uncached;
   if ((vaddr & 3) != 0)
    SignalException(AddressStore);
   else
   {
    if (AddressTranslation(vaddr,isDATA,isSTORE,&paddr,&uncached,isTARGET,isREAL))
    {
     uword64 memval;
     uword64 mask = 0x7;
     uw64 /*unsigned int*/ byte;
     paddr = ((paddr & ~mask) | ((paddr & mask) ^ (ReverseEndian << 2)));
     byte = ((vaddr & mask) ^ (BigEndianCPU << 2));
     memval = (((uword64)COP_SW(1,fs)) << (8 * byte));
      {
       StoreMemory(uncached,AccessLength_WORD,memval,paddr,vaddr,isREAL);
      }
    }
   }
  }
 }
 break ;
case 79 : /* "SYNC" 000000000000000000000aaaaa001111 */
 if ((instruction & 0xFFFFF83F) != 0x0000000F)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  /* FIXME was int */
  uword64 op1 = ((instruction >> 6) & 0x0000001F);
  {
   SyncOperation(op1);
  }
 }
 break ;
case 76 : /* "SYSCALL" 000000????????????????????001100 */
 {
  {
   SignalException(SystemCall,instruction);
  }
 }
 break ;
case 116 : /* "TEQ" 000000sssssggggg??????????110100 */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 == (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 140 : /* "TEQI" 000001sssss01100iiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 == (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 112 : /* "TGE" 000000sssssggggg??????????110000 */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 >= (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 136 : /* "TGEI" 000001sssss01000iiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 >= (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 137 : /* "TGEIU" 000001sssss01001iiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((uword64)op1 >= (uword64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 113 : /* "TGEU" 000000sssssggggg??????????110001 */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((uword64)op1 >= (uword64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 114 : /* "TLT" 000000sssssggggg??????????110010 */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 < (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 138 : /* "TLTI" 000001sssss01010iiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 < (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 139 : /* "TLTIU" 000001sssss01011iiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((uword64)op1 < (uword64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 115 : /* "TLTU" 000000sssssggggg??????????110011 */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((uword64)op1 < (uword64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 118 : /* "TNE" 000000sssssggggg??????????110110 */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 != (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 142 : /* "TNEI" 000001sssss01110iiiiiiiiiiiiiiii */
 {
  t_reg op2 = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
  if ((word64)op1 != (word64)op2)
   SignalException(Trap,instruction);
  }
 }
 break ;
case 169 : /* "TRUNC.L" 01000110mmm00000vvvvvrrrrr001001 */
 if ((instruction & 0xFF1F003F) != 0x46000009)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_long,Convert(FP_RM_TOZERO,ValueFPR(fs,format),format,fmt_long));
  }
 }
 break ;
case 173 : /* "TRUNC.W" 01000110mmm00000vvvvvrrrrr001101 */
 if ((instruction & 0xFF1F003F) != 0x4600000D)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ format = ((instruction >> 21) & 0x00000007);
  uw64 /*int*/ destreg = ((instruction >> 6) & 0x0000001F);
  uw64 /*int*/ fs = ((instruction >> 11) & 0x0000001F);
  {
  if ((format != fmt_single) && (format != fmt_double))
   SignalException(ReservedInstruction,instruction);
  else
   StoreFPR(destreg,fmt_word,Convert(FP_RM_TOZERO,ValueFPR(fs,format),format,fmt_word));
  }
 }
 break ;
case 102 : /* "XOR" 000000sssssgggggddddd00000100110 */
 if ((instruction & 0xFC0007FF) != 0x00000026)
 {
  SignalException(ReservedInstruction,instruction);
 }
 else
 {
  uw64 /*int*/ destreg = ((instruction >> 11) & 0x0000001F);
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  {
   GPR[destreg] = (op1 ^ op2);
  }
 }
 break ;
case 14 : /* "XORI" 001110ssssstttttzzzzzzzzzzzzzzzz */
 {
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  uw64 /*int*/ destreg = ((instruction >> 16) & 0x0000001F);
  ut_reg op2 = ((instruction >> 0) & 0x0000FFFF);
  {
   GPR[destreg] = (op1 ^ op2);
  }
 }
 break ;
case 47 : /* "CACHE" 101111sssssnnnnnyyyyyyyyyyyyyyyy */
 {
  uw64 /*int*/ hint = ((instruction >> 16) & 0x0000001F);
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
    uword64 vaddr = (op1 + offset);
    uword64 paddr;
    int uncached;
    if (AddressTranslation(vaddr,isDATA,isLOAD,&paddr,&uncached,isTARGET,isREAL))
      CacheOp(hint,vaddr,paddr,instruction);
  }
 }
 break ;
case 59 : /* "<INT>" 111011sssssgggggyyyyyyyyyyyyyyyy */
 {
  t_reg op2 = GPR[((instruction >> 16) & 0x0000001F)];
  t_reg op1 = GPR[((instruction >> 21) & 0x0000001F)];
  t_reg offset = SIGNEXTEND((t_reg)((instruction >> 0) & 0x0000FFFF),16);
  {
   SignalException(ReservedInstruction,instruction);
  }
 }
 break ;
default : /* Unrecognised instruction */
 SignalException(ReservedInstruction,instruction);
 break ;
}
}
#endif /* simulator engine */
