/* A lexical scanner generated by flex */

/* scanner skeleton version:
 * $Header: /cvs/src/gnu/usr.bin/bc/bc/scan.c,v 1.1.1.1 1998/06/29 00:19:05 millert Exp $
 */

#define FLEX_SCANNER

#include <stdio.h>


/* cfront 1.2 defines "c_plusplus" instead of "__cplusplus" */
#ifdef c_plusplus
#ifndef __cplusplus
#define __cplusplus
#endif
#endif


#ifdef __cplusplus

#include <stdlib.h>
#include <osfcn.h>

/* use prototypes in function declarations */
#define YY_USE_PROTOS

/* the "const" storage-class-modifier is valid */
#define YY_USE_CONST

#else	/* ! __cplusplus */

#ifdef __STDC__

#ifdef __GNUC__
#include <stddef.h>
void *malloc( size_t );
void free( void* );
#else
#include <stdlib.h>
#endif	/* __GNUC__ */

#define YY_USE_PROTOS
#define YY_USE_CONST

#endif	/* __STDC__ */
#endif	/* ! __cplusplus */


#ifdef __TURBOC__
#define YY_USE_CONST
#endif


#ifndef YY_USE_CONST
#define const
#endif


#ifdef YY_USE_PROTOS
#define YY_PROTO(proto) proto
#else
#define YY_PROTO(proto) ()
/* we can't get here if it's an ANSI C compiler, or a C++ compiler,
 * so it's got to be a K&R compiler, and therefore there's no standard
 * place from which to include these definitions
 */
/* char *malloc();
int free(); */
int read();
#endif


/* amount of stuff to slurp up with each read */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* returned upon end-of-file */
#define YY_END_TOK 0

/* copy whatever the last rule matched to the standard output */

/* cast to (char *) is because for 8-bit chars, yytext is (unsigned char *) */
/* this used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite()
 */
#define ECHO (void) fwrite( (char *) yytext, yyleng, 1, yyout )

/* gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#define YY_INPUT(buf,result,max_size) \
	if ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
	    YY_FATAL_ERROR( "read() in flex scanner failed" );
#define YY_NULL 0

/* no semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#define yyterminate() return ( YY_NULL )

/* report a fatal error */

/* The funky do-while is used to turn this macro definition into
 * a single C statement (which needs a semi-colon terminator).
 * This avoids problems with code like:
 *
 * 	if ( something_happens )
 *		YY_FATAL_ERROR( "oops, the something happened" );
 *	else
 *		everything_okay();
 *
 * Prior to using the do-while the compiler would get upset at the
 * "else" because it interpreted the "if" statement as being all
 * done when it reached the ';' after the YY_FATAL_ERROR() call.
 */

#define YY_FATAL_ERROR(msg) \
	do \
		{ \
		(void) fputs( msg, stderr ); \
		(void) putc( '\n', stderr ); \
		exit( 1 ); \
		} \
	while ( 0 )

/* default yywrap function - always treat EOF as an EOF */
#define yywrap() 1

/* enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN
 */
#define BEGIN yy_start = 1 + 2 *

/* action number for EOF rule of a given start state */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* special action meaning "start processing a new file" */
#define YY_NEW_FILE \
	do \
		{ \
		yy_init_buffer( yy_current_buffer, yyin ); \
		yy_load_buffer_state(); \
		} \
	while ( 0 )

/* default declaration of generated scanner - a define so the user can
 * easily add parameters
 */
#define YY_DECL int yylex YY_PROTO(( void )) 

/* code executed at the end of each rule */
#define YY_BREAK break;

#define YY_END_OF_BUFFER_CHAR 0

#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE (YY_READ_BUF_SIZE * 2) /* size of default input buffer */
#endif

typedef struct yy_buffer_state *YY_BUFFER_STATE;

#define YY_CHAR unsigned char
# line 1 "scan.l"
#define INITIAL 0
# line 2 "scan.l"
/* scan.l: the (f)lex description file for the scanner. */

/*  This file is part of GNU bc.
    Copyright (C) 1991, 1992, 1993, 1994, 1997 Free Software Foundation, Inc.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License , or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; see the file COPYING.  If not, write to
    the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

    You may contact the author by:
       e-mail:  phil@cs.wwu.edu
      us-mail:  Philip A. Nelson
                Computer Science Department, 9062
                Western Washington University
                Bellingham, WA 98226-9062
       
*************************************************************************/

#include "bcdefs.h"
#include "bc.h"
#include "global.h"
#include "proto.h"
#include <errno.h>

/* Using flex, we can ask for a smaller input buffer.  With lex, this
   does nothing! */

#ifdef SMALL_BUF
#undef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 512
#endif

/* Force . as last for now. */
#define DOT_IS_LAST

/* We want to define our own yywrap. */
#undef yywrap
_PROTOTYPE(int yywrap, (void));

#ifdef READLINE
/* Support for the readline and history libraries.  This allows
   nicer input on the interactive part of input. */

/* Have input call the following function. */
#undef  YY_INPUT
#define YY_INPUT(buf,result,max_size) \
		rl_input((char *)buf, &result, max_size)

/* Variables to help interface readline with bc. */
static char *rl_line = (char *)NULL;
static char *rl_start = (char *)NULL;
static char  rl_len = 0;

/* Definitions for readline access. */
extern FILE *rl_instream;
_PROTOTYPE(char *readline, (char *));

/* Needed here? */
extern FILE *yyin;

/* rl_input puts upto MAX characters into BUF with the number put in
   BUF placed in *RESULT.  If the yy input file is the same as
   rl_instream (stdin), use readline.  Otherwise, just read it.
*/

static void
rl_input (buf, result, max)
	char *buf;
	int  *result;
	int   max;
{
  if (yyin != rl_instream)
    {
      while ( (*result = read( fileno(yyin), buf, max )) < 0 )
        if (errno != EINTR)
	  {
	    yyerror( "read() in flex scanner failed" );
	    exit (1);
	  }
      return;
    }

  /* Do we need a new string? */
  if (rl_len == 0)
    {
      if (rl_line)
	free(rl_line);
      rl_line = readline ("");
      if (rl_line == NULL) {
	/* end of file */
	*result = 0;
	rl_len = 0;
	return;
      }
      rl_len = strlen (rl_line)+1;
      if (rl_len != 1)
	add_history (rl_line); 
      rl_line[rl_len-1] = '\n';
      printf ("\r");
      fflush (stdout);
    }

  if (rl_len <= max)
    {
      strncpy (buf, rl_line, rl_len);
      *result = rl_len;
      rl_len = 0;
    }
  else
    {
      strncpy (buf, rl_line, max);
      *result = max;
      rl_len -= max;
    }
}
#else
/* MINIX returns from read with < 0 if SIGINT is  encountered.
   In flex, we can redefine YY_INPUT to the following.  In lex, this
   does nothing! */
#undef  YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	while ( (result = read( fileno(yyin), (char *) buf, max_size )) < 0 ) \
	    if (errno != EINTR) \
		YY_FATAL_ERROR( "read() in flex scanner failed" );
#endif
#define slcomment 1
# line 141 "scan.l"

/* done after the current pattern has been matched and before the
 * corresponding action - sets up yytext
 */
#define YY_DO_BEFORE_ACTION \
	yytext = yy_bp; \
	yyleng = yy_cp - yy_bp; \
	yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yy_c_buf_p = yy_cp;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

/* return all but the first 'n' matched characters back to the input stream */
#define yyless(n) \
	do \
		{ \
		/* undo effects of setting up yytext */ \
		*yy_cp = yy_hold_char; \
		yy_c_buf_p = yy_cp = yy_bp + n; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, yytext )


struct yy_buffer_state
    {
    FILE *yy_input_file;

    YY_CHAR *yy_ch_buf;		/* input buffer */
    YY_CHAR *yy_buf_pos;	/* current position in input buffer */

    /* size of input buffer in bytes, not including room for EOB characters*/
    int yy_buf_size;	

    /* number of characters read into yy_ch_buf, not including EOB characters */
    int yy_n_chars;

    int yy_eof_status;		/* whether we've seen an EOF on this buffer */
#define EOF_NOT_SEEN 0
    /* "pending" happens when the EOF has been seen but there's still
     * some text process
     */
#define EOF_PENDING 1
#define EOF_DONE 2
    };

static YY_BUFFER_STATE yy_current_buffer;

/* we provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state"
 */
#define YY_CURRENT_BUFFER yy_current_buffer


/* yy_hold_char holds the character lost when yytext is formed */
static YY_CHAR yy_hold_char;

static int yy_n_chars;		/* number of characters read into yy_ch_buf */



#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

#ifndef YY_USER_INIT
#define YY_USER_INIT
#endif

extern YY_CHAR *yytext;
extern int yyleng;
extern FILE *yyin, *yyout;

YY_CHAR *yytext;
int yyleng;

FILE *yyin = (FILE *) 0, *yyout = (FILE *) 0;

#define YY_END_OF_BUFFER 45
typedef int yy_state_type;
static const short int yy_accept[298] =
    {   0,
        0,    0,    2,    2,   45,   43,   38,   36,   30,   43,
        1,   31,   43,   27,   31,   27,   27,   26,   31,   42,
       34,   32,   34,   43,   27,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
       40,   43,    2,    2,    3,    2,    2,    1,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,   38,
       34,    0,   41,   32,   28,   35,   42,    0,   39,   42,
       42,    0,   33,   37,   40,   40,   40,   40,   40,   40,

       40,   40,   40,   40,   10,   40,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   29,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,   42,    0,    0,   42,    0,
       40,   40,   40,   40,   40,    9,   40,   40,   40,   40,
       40,   40,   40,   40,   40,   40,   40,   40,   40,   40,
       40,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,

        2,    2,    2,    2,    2,    2,   16,   40,   40,   40,
       17,   19,   40,   40,   20,   40,   40,   40,   40,    6,
       18,   40,   40,   12,   40,   40,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,    2,    2,    2,    2,    5,   40,   40,   40,
       14,   40,   40,   15,   24,   40,   13,   40,   11,    2,
        2,    2,    2,    2,    2,    2,    2,    2,    2,    2,
        2,    2,   40,    4,   40,    7,   25,    8,   40,    2,
        2,    2,    2,    2,    2,    2,   40,   21,   40,    2,
        2,    2,   23,   22,    2,    2,    0

    } ;

static const YY_CHAR yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    4,    5,    6,    1,    7,    8,    1,    9,
       10,   11,   12,   13,   14,   15,   16,   17,   17,   17,
       17,   17,   17,   17,   17,   17,   17,    1,   18,   19,
       20,   21,    1,    1,   22,   22,   22,   22,   22,   22,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
       23,   24,   25,   26,   27,    1,   28,   29,   30,   31,

       32,   33,   34,   35,   36,   37,   38,   39,   40,   41,
       42,   43,   44,   45,   46,   47,   48,   37,   49,   37,
       50,   37,   51,   52,   53,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,

        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1
    } ;

static const YY_CHAR yy_meta[54] =
    {   0,
        1,    1,    2,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        1,    1,    1
    } ;

static const short int yy_base[302] =
    {   0,
        0,    0,   53,    0,  525,  526,  522,  526,  503,  517,
      526,  501,  512,  526,  499,   95,   94,   94,   99,  105,
      498,  114,  497,  513,  495,  466,  468,  470,  479,  471,
      467,    0,   81,  102,  105,  479,  462,  458,  473,   94,
      104,  452,    0,  501,  526,  482,  139,    0,  481,  492,
        0,  479,  131,  132,  131,  125,  132,  478,  150,  477,
      493,  475,  160,  115,  117,  126,  130,  125,  446,  183,
      184,  186,  187,  123,  445,  180,  185,  192,  440,  489,
      526,  485,  526,  526,  526,  526,  158,  486,  526,  162,
      221,  485,  526,  526,    0,  440,  454,  444,  451,  437,

      437,  442,  434,  451,    0,  432,  436,  436,  447,  438,
      437,  195,  444,  426,  425,  433,  526,    0,  466,    0,
      178,    0,    0,    0,    0,  222,  464,    0,  230,  233,
      463,    0,  417,   65,  189,  208,  193,  205,  213,  220,
      214,  235,  416,  218,  224,  227,  241,  234,  237,  243,
      246,  231,  232,  245,    0,  275,  460,  278,  279,  459,
      419,  432,  412,  422,  425,    0,  409,  408,  408,  406,
      418,  415,  404,  408,  401,  416,  398,  406,  397,  398,
      403,  287,  438,  288,  437,  182,  250,  239,  270,  275,
      391,  266,  268,  271,  273,  274,  288,  279,  285,  281,

      299,  390,  292,  287,  293,  298,    0,  399,  400,  394,
        0,    0,  392,  401,    0,  385,  384,  398,  382,    0,
        0,  383,  395,    0,  398,  393,  376,  294,  303,  302,
      375,  374,  306,  312,  373,  305,  308,  313,  310,  372,
      371,  314,  317,  370,  335,  332,    0,  376,  384,  370,
        0,  379,  367,    0,    0,  371,    0,  370,    0,  362,
      325,  336,  322,  361,  137,  323,  360,  359,  331,  358,
      333,  357,  356,    0,  353,    0,    0,    0,  355,  349,
      343,  327,  342,  340,  334,  338,  346,    0,  238,  344,
      236,  339,    0,    0,  177,  102,  526,  392,  120,  395,

      398
    } ;

static const short int yy_def[302] =
    {   0,
      297,    1,  297,    3,  297,  297,  297,  297,  297,  298,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  297,  300,  300,  297,  300,  301,  300,  300,  300,
      300,  300,  300,  300,  300,  300,  300,  300,  300,  300,
      300,  300,  300,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,  300,  297,
      297,  298,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  299,  299,  299,  299,  299,  299,

      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  297,  300,  300,  300,
      301,  300,  300,  300,  300,  300,  300,  300,  300,  300,
      300,  300,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,  300,  297,  297,  297,  297,  297,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  300,  300,  300,  300,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,

       63,   63,   63,   63,   63,   63,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,  299,  299,  299,  299,
      299,  299,  299,  299,  299,  299,  299,  299,  299,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       63,   63,  299,  299,  299,  299,  299,  299,  299,   63,
       63,   63,   63,   63,   63,   63,  299,  299,  299,   63,
       63,   63,  299,  299,   63,   63,    0,  297,  297,  297,

      297
    } ;

static const short int yy_nxt[580] =
    {   0,
        6,    7,    8,    9,   10,   11,   12,   13,   14,   14,
       15,   16,   14,   17,   18,   19,   20,   14,   21,   22,
       23,   20,   14,   24,   14,   25,    6,   26,   27,   28,
       29,   30,   31,   32,   33,   34,   32,   32,   35,   32,
       32,   36,   37,   38,   39,   40,   32,   32,   41,   32,
       14,   42,   14,   43,   44,   45,   46,   47,   48,   49,
       50,   51,   51,   52,   53,   51,   54,   55,   56,   57,
       51,   58,   59,   60,   57,   51,   61,   51,   62,   43,
       63,   64,   65,   66,   67,   68,   69,   70,   71,   69,
       69,   72,   69,   69,   73,   74,   75,   76,   77,   69,

       69,   78,   69,   51,   79,   51,   86,   86,  102,   89,
       87,  186,  133,   84,   84,   87,  103,   88,   84,   90,
       93,   91,   95,  113,   93,   93,   91,   93,   92,   93,
      104,  115,  106,   81,  105,  128,  107,  114,  116,   93,
      108,   82,  125,  122,  123,  125,  129,  126,  130,  133,
      123,  123,  126,  130,  127,  131,  132,  137,  136,  135,
      132,  132,  133,  132,  133,  132,  139,  148,  138,  120,
      133,  283,  133,  133,  156,  132,  133,  133,  159,  156,
       82,  157,  122,  159,  133,  160,  133,  133,  133,  133,
      133,  133,  133,  133,  133,  133,  133,  133,  133,  133,

      133,  133,  133,  133,  133,  133,  133,  134,  133,  133,
      140,  150,  142,  144,  151,  147,  143,  145,  141,  153,
      187,  146,  176,  227,  133,  189,  154,  133,  152,  133,
      133,  133,  133,  133,  133,   90,  133,   91,  182,  133,
      133,  177,   91,  182,   92,  183,  184,  129,  188,  130,
      190,  184,  133,  185,  130,  133,  131,  191,  192,  193,
      133,  133,  194,  195,  196,  133,  197,  133,  198,  199,
      201,  133,  200,  203,  133,  204,  205,  228,  133,  133,
      206,  133,  133,  133,  133,  229,  133,  294,  133,  202,
      133,  156,  133,  133,   87,  159,  156,  133,  157,   87,

      159,   88,  160,  182,  184,  230,  231,  236,  182,  184,
      183,  185,  232,  133,  233,  133,  234,  133,  133,  235,
      133,  133,  133,  237,  238,  239,  133,  240,  133,  241,
      243,  260,  133,  244,  133,  133,  246,  245,  261,  133,
      133,  133,  262,  264,  267,  133,  133,  263,  270,  133,
      133,  265,  133,  133,  266,  133,  268,  133,  269,  133,
      133,  133,  271,  272,  133,  280,  282,  281,  284,  133,
      133,  285,  133,  286,  133,  295,  291,  293,  133,  133,
      133,  133,  133,  133,  292,  133,  133,  133,  296,  133,
      133,  133,   82,   82,   82,  118,  290,  118,  121,  121,

      121,  289,  288,  287,  133,  133,  133,  133,  133,  133,
      279,  278,  277,  276,  275,  274,  273,  133,  133,  133,
      133,  133,  133,  133,  259,  258,  257,  256,  255,  254,
      253,  252,  251,  250,  249,  248,  247,  242,  133,  159,
      156,  226,  225,  224,  223,  222,  221,  220,  219,  218,
      217,  216,  215,  214,  213,  212,  211,  210,  209,  208,
      207,  159,  156,  133,  133,   91,  158,  119,  181,  180,
      179,  178,  175,  174,  173,  172,  171,  170,  169,  168,
      167,  166,  165,  164,  163,  162,  161,   91,  158,   83,
       80,  155,  149,  133,  123,   94,  120,  120,  123,  124,

      123,  120,  119,  117,  112,  111,  110,  109,  101,  100,
       99,   98,   97,   96,   84,   94,   81,   81,   84,   85,
       84,   83,   81,   80,  297,    5,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297
    } ;

static const short int yy_chk[580] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,
        3,    3,    3,    3,    3,    3,    3,    3,    3,    3,

        3,    3,    3,    3,    3,    3,   16,   17,   33,   19,
       18,  134,  134,   17,   16,   18,   33,   18,   19,   20,
       22,   20,  299,   40,   22,   22,   20,   22,   20,   22,
       34,   41,   35,   22,   34,   56,   35,   40,   41,   22,
       35,   47,   53,   47,   56,   54,   57,   55,   57,  296,
       53,   54,   55,   57,   55,   57,   59,   66,   65,   64,
       59,   59,   64,   59,   65,   59,   68,   74,   67,   59,
       74,  265,   68,   66,   87,   59,   63,   67,   90,   87,
      121,   87,  121,   90,  265,   90,   63,   63,   63,   63,
       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,

       63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
       70,   76,   71,   72,   77,   73,   71,   72,   70,   78,
      135,   72,  112,  186,  295,  137,   78,   76,   77,  186,
       70,   71,   77,   72,   73,   91,  135,   91,  126,   78,
      137,  112,   91,  126,   91,  126,  129,  130,  136,  130,
      138,  129,  138,  129,  130,  136,  130,  139,  140,  141,
      139,  141,  142,  144,  145,  144,  146,  140,  147,  148,
      150,  145,  149,  151,  146,  152,  153,  187,  152,  153,
      154,  148,  142,  291,  149,  188,  188,  289,  147,  150,
      150,  156,  154,  151,  158,  159,  156,  187,  156,  158,

      159,  158,  159,  182,  184,  189,  190,  196,  182,  184,
      182,  184,  192,  192,  193,  193,  194,  189,  194,  195,
      195,  196,  190,  197,  198,  199,  198,  200,  200,  201,
      203,  228,  199,  204,  204,  197,  206,  205,  229,  203,
      205,  228,  230,  234,  238,  206,  201,  233,  243,  230,
      229,  236,  236,  233,  237,  237,  239,  239,  242,  234,
      238,  242,  245,  246,  243,  261,  263,  262,  266,  263,
      266,  269,  261,  271,  282,  290,  282,  287,  269,  246,
      271,  285,  245,  262,  286,  286,  292,  284,  292,  283,
      281,  290,  298,  298,  298,  300,  280,  300,  301,  301,

      301,  279,  275,  273,  272,  270,  268,  267,  264,  260,
      258,  256,  253,  252,  250,  249,  248,  244,  241,  240,
      235,  232,  231,  227,  226,  225,  223,  222,  219,  218,
      217,  216,  214,  213,  210,  209,  208,  202,  191,  185,
      183,  181,  180,  179,  178,  177,  176,  175,  174,  173,
      172,  171,  170,  169,  168,  167,  165,  164,  163,  162,
      161,  160,  157,  143,  133,  131,  127,  119,  116,  115,
      114,  113,  111,  110,  109,  108,  107,  106,  104,  103,
      102,  101,  100,   99,   98,   97,   96,   92,   88,   82,
       80,   79,   75,   69,   62,   61,   60,   58,   52,   50,

       49,   46,   44,   42,   39,   38,   37,   36,   31,   30,
       29,   28,   27,   26,   25,   24,   23,   21,   15,   13,
       12,   10,    9,    7,    5,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297,  297,
      297,  297,  297,  297,  297,  297,  297,  297,  297
    } ;

static yy_state_type yy_last_accepting_state;
static YY_CHAR *yy_last_accepting_cpos;

/* the intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0

/* these variables are all declared out here so that section 3 code can
 * manipulate them
 */
/* points to current character in buffer */
static YY_CHAR *yy_c_buf_p = (YY_CHAR *) 0;
static int yy_init = 1;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* flag which is used to allow yywrap()'s to do buffer switches
 * instead of setting up a fresh yyin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

static yy_state_type yy_get_previous_state YY_PROTO(( void ));
static yy_state_type yy_try_NUL_trans YY_PROTO(( yy_state_type current_state ));
static int yy_get_next_buffer YY_PROTO(( void ));
static void yyunput YY_PROTO(( YY_CHAR c, YY_CHAR *buf_ptr ));
void yyrestart YY_PROTO(( FILE *input_file ));
void yy_switch_to_buffer YY_PROTO(( YY_BUFFER_STATE new_buffer ));
void yy_load_buffer_state YY_PROTO(( void ));
YY_BUFFER_STATE yy_create_buffer YY_PROTO(( FILE *file, int size ));
void yy_delete_buffer YY_PROTO(( YY_BUFFER_STATE b ));
void yy_init_buffer YY_PROTO(( YY_BUFFER_STATE b, FILE *file ));

#define yy_new_buffer yy_create_buffer

#ifdef __cplusplus
static int yyinput YY_PROTO(( void ));
#else
static int input YY_PROTO(( void ));
#endif

YY_DECL
    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp, *yy_bp;
    register int yy_act;



    if ( yy_init )
	{
	YY_USER_INIT;

	if ( ! yy_start )
	    yy_start = 1;	/* first start state */

	if ( ! yyin )
	    yyin = stdin;

	if ( ! yyout )
	    yyout = stdout;

	if ( yy_current_buffer )
	    yy_init_buffer( yy_current_buffer, yyin );
	else
	    yy_current_buffer = yy_create_buffer( yyin, YY_BUF_SIZE );

	yy_load_buffer_state();

	yy_init = 0;
	}

    while ( 1 )		/* loops until end-of-file is reached */
	{
	yy_cp = yy_c_buf_p;

	/* support of yytext */
	*yy_cp = yy_hold_char;

	/* yy_bp points to the position in yy_ch_buf of the start of the
	 * current run.
	 */
	yy_bp = yy_cp;

	yy_current_state = yy_start;
yy_match:
	do
	    {
	    register YY_CHAR yy_c = yy_ec[*yy_cp];
	    if ( yy_accept[yy_current_state] )
		{
		yy_last_accepting_state = yy_current_state;
		yy_last_accepting_cpos = yy_cp;
		}
	    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = yy_def[yy_current_state];
		if ( yy_current_state >= 298 )
		    yy_c = yy_meta[yy_c];
		}
	    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	    ++yy_cp;
	    }
	while ( yy_base[yy_current_state] != 526 );

yy_find_action:
	yy_act = yy_accept[yy_current_state];

	YY_DO_BEFORE_ACTION;
	YY_USER_ACTION;

do_action:	/* this label is used only to access EOF actions */


	switch ( yy_act )
	    {
	    case 0: /* must backtrack */
	    /* undo the effects of YY_DO_BEFORE_ACTION */
	    *yy_cp = yy_hold_char;
	    yy_cp = yy_last_accepting_cpos;
	    yy_current_state = yy_last_accepting_state;
	    goto yy_find_action;

case 1:
# line 142 "scan.l"
{
 		  if (!std_only)
		    BEGIN(slcomment);
 		  else
		    yyerror ("illegal character: #");
		}
	YY_BREAK
case 2:
# line 148 "scan.l"
{ BEGIN(INITIAL); }
	YY_BREAK
case 3:
# line 149 "scan.l"
{ line_no++; BEGIN(INITIAL); return(NEWLINE); }
	YY_BREAK
case 4:
# line 150 "scan.l"
return(Define);
	YY_BREAK
case 5:
# line 151 "scan.l"
return(Break);
	YY_BREAK
case 6:
# line 152 "scan.l"
return(Quit);
	YY_BREAK
case 7:
# line 153 "scan.l"
return(Length);
	YY_BREAK
case 8:
# line 154 "scan.l"
return(Return);
	YY_BREAK
case 9:
# line 155 "scan.l"
return(For);
	YY_BREAK
case 10:
# line 156 "scan.l"
return(If);
	YY_BREAK
case 11:
# line 157 "scan.l"
return(While);
	YY_BREAK
case 12:
# line 158 "scan.l"
return(Sqrt);
	YY_BREAK
case 13:
# line 159 "scan.l"
return(Scale);
	YY_BREAK
case 14:
# line 160 "scan.l"
return(Ibase);
	YY_BREAK
case 15:
# line 161 "scan.l"
return(Obase);
	YY_BREAK
case 16:
# line 162 "scan.l"
return(Auto);
	YY_BREAK
case 17:
# line 163 "scan.l"
return(Else);
	YY_BREAK
case 18:
# line 164 "scan.l"
return(Read);
	YY_BREAK
case 19:
# line 165 "scan.l"
return(Halt);
	YY_BREAK
case 20:
# line 166 "scan.l"
return(Last);
	YY_BREAK
case 21:
# line 167 "scan.l"
{
#ifdef READLINE
	  return(History);
#else
	  yylval.s_value = strcopyof(yytext); return(NAME);
#endif
	}
	YY_BREAK
case 22:
# line 175 "scan.l"
return(Warranty);
	YY_BREAK
case 23:
# line 176 "scan.l"
return(Continue);
	YY_BREAK
case 24:
# line 177 "scan.l"
return(Print);
	YY_BREAK
case 25:
# line 178 "scan.l"
return(Limits);
	YY_BREAK
case 26:
# line 179 "scan.l"
{
#ifdef DOT_IS_LAST
       return(Last);
#else
       yyerror ("illegal character: %s",yytext);
#endif
    }
	YY_BREAK
case 27:
# line 186 "scan.l"
{ yylval.c_value = yytext[0]; 
					      return((int)yytext[0]); }
	YY_BREAK
case 28:
# line 188 "scan.l"
{ return(AND); }
	YY_BREAK
case 29:
# line 189 "scan.l"
{ return(OR); }
	YY_BREAK
case 30:
# line 190 "scan.l"
{ return(NOT); }
	YY_BREAK
case 31:
# line 191 "scan.l"
{ yylval.c_value = yytext[0]; return((int)yytext[0]); }
	YY_BREAK
case 32:
# line 192 "scan.l"
{ yylval.c_value = yytext[0]; return(ASSIGN_OP); }
	YY_BREAK
case 33:
# line 193 "scan.l"
{ 
#ifdef OLD_EQ_OP
			 char warn_save;
			 warn_save = warn_not_std;
			 warn_not_std = TRUE;
			 warn ("Old fashioned =<op>");
			 warn_not_std = warn_save;
			 yylval.c_value = yytext[1];
#else
			 yylval.c_value = '=';
			 yyless (1);
#endif
			 return(ASSIGN_OP);
		       }
	YY_BREAK
case 34:
# line 207 "scan.l"
{ yylval.s_value = strcopyof(yytext); return(REL_OP); }
	YY_BREAK
case 35:
# line 208 "scan.l"
{ yylval.c_value = yytext[0]; return(INCR_DECR); }
	YY_BREAK
case 36:
# line 209 "scan.l"
{ line_no++; return(NEWLINE); }
	YY_BREAK
case 37:
# line 210 "scan.l"
{  line_no++;  /* ignore a "quoted" newline */ }
	YY_BREAK
case 38:
# line 211 "scan.l"
{ /* ignore spaces and tabs */ }
	YY_BREAK
case 39:
# line 212 "scan.l"
{
	int c;

	for (;;)
	  {
	    while ( ((c=input()) != '*') && (c != EOF)) 
	      /* eat it */
	      if (c == '\n') line_no++;
	    if (c == '*')
 	      {
		while ( (c=input()) == '*') /* eat it*/;
		if (c == '/') break; /* at end of comment */
		if (c == '\n') line_no++;
	      }
	    if (c == EOF)
	      {
		fprintf (stderr,"EOF encountered in a comment.\n");
		break;
	      }
	  }
      }
	YY_BREAK
case 40:
# line 233 "scan.l"
{ yylval.s_value = strcopyof(yytext); return(NAME); }
	YY_BREAK
case 41:
# line 234 "scan.l"
{
 	      unsigned char *look;
	      int count = 0;
	      yylval.s_value = strcopyof(yytext);
	      for (look = yytext; *look != 0; look++)
		{
		  if (*look == '\n') line_no++;
		  if (*look == '"')  count++;
		}
	      if (count != 2) yyerror ("NUL character in string.");
	      return(STRING);
	    }
	YY_BREAK
case 42:
# line 246 "scan.l"
{
	      unsigned char *src, *dst;
	      int len;
	      /* remove a trailing decimal point. */
	      len = strlen(yytext);
	      if (yytext[len-1] == '.')
	        yytext[len-1] = 0;
	      /* remove leading zeros. */
	      src = yytext;
	      dst = yytext;
	      while (*src == '0') src++;
	      if (*src == 0) src--;
	      /* Copy strings removing the newlines. */
	      while (*src != 0)
		{
	          if (*src == '\\')
		    {
		      src++; src++;
		      line_no++;
		    }
		  else
		    *dst++ = *src++;
	        }
	      *dst = 0;
	      yylval.s_value = strcopyof(yytext); 
	      return(NUMBER);
	    }
	YY_BREAK
case 43:
# line 273 "scan.l"
{
	  if (yytext[0] < ' ')
	    yyerror ("illegal character: ^%c",yytext[0] + '@');
	  else
	    if (yytext[0] > '~')
	      yyerror ("illegal character: \\%3d", (int) yytext[0]);
	    else
	      yyerror ("illegal character: %s",yytext);
	}
	YY_BREAK
case 44:
# line 282 "scan.l"
ECHO;
	YY_BREAK
case YY_STATE_EOF(INITIAL):
case YY_STATE_EOF(slcomment):
    yyterminate();

	    case YY_END_OF_BUFFER:
		{
		/* amount of text matched not including the EOB char */
		int yy_amount_of_matched_text = yy_cp - yytext - 1;

		/* undo the effects of YY_DO_BEFORE_ACTION */
		*yy_cp = yy_hold_char;

		/* note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the end-
		 * of-buffer state).  Contrast this with the test in yyinput().
		 */
		if ( yy_c_buf_p <= &yy_current_buffer->yy_ch_buf[yy_n_chars] )
		    /* this was really a NUL */
		    {
		    yy_state_type yy_next_state;

		    yy_c_buf_p = yytext + yy_amount_of_matched_text;

		    yy_current_state = yy_get_previous_state();

		    /* okay, we're now positioned to make the
		     * NUL transition.  We couldn't have
		     * yy_get_previous_state() go ahead and do it
		     * for us because it doesn't know how to deal
		     * with the possibility of jamming (and we
		     * don't want to build jamming into it because
		     * then it will run more slowly)
		     */

		    yy_next_state = yy_try_NUL_trans( yy_current_state );

		    yy_bp = yytext + YY_MORE_ADJ;

		    if ( yy_next_state )
			{
			/* consume the NUL */
			yy_cp = ++yy_c_buf_p;
			yy_current_state = yy_next_state;
			goto yy_match;
			}

		    else
			{
			goto yy_find_action;
			}
		    }

		else switch ( yy_get_next_buffer() )
		    {
		    case EOB_ACT_END_OF_FILE:
			{
			yy_did_buffer_switch_on_eof = 0;

			if ( yywrap() )
			    {
			    /* note: because we've taken care in
			     * yy_get_next_buffer() to have set up yytext,
			     * we can now set up yy_c_buf_p so that if some
			     * total hoser (like flex itself) wants
			     * to call the scanner after we return the
			     * YY_NULL, it'll still work - another YY_NULL
			     * will get returned.
			     */
			    yy_c_buf_p = yytext + YY_MORE_ADJ;

			    yy_act = YY_STATE_EOF((yy_start - 1) / 2);
			    goto do_action;
			    }

			else
			    {
			    if ( ! yy_did_buffer_switch_on_eof )
				YY_NEW_FILE;
			    }
			}
			break;

		    case EOB_ACT_CONTINUE_SCAN:
			yy_c_buf_p = yytext + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_match;

		    case EOB_ACT_LAST_MATCH:
			yy_c_buf_p =
			    &yy_current_buffer->yy_ch_buf[yy_n_chars];

			yy_current_state = yy_get_previous_state();

			yy_cp = yy_c_buf_p;
			yy_bp = yytext + YY_MORE_ADJ;
			goto yy_find_action;
		    }
		break;
		}

	    default:
#ifdef FLEX_DEBUG
		printf( "action # %d\n", yy_act );
#endif
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	    }
	}
    }


/* yy_get_next_buffer - try to read in a new buffer
 *
 * synopsis
 *     int yy_get_next_buffer();
 *     
 * returns a code representing an action
 *     EOB_ACT_LAST_MATCH - 
 *     EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *     EOB_ACT_END_OF_FILE - end of file
 */

static int yy_get_next_buffer()

    {
    register YY_CHAR *dest = yy_current_buffer->yy_ch_buf;
    register YY_CHAR *source = yytext - 1; /* copy prev. char, too */
    register int number_to_move, i;
    int ret_val;

    if ( yy_c_buf_p > &yy_current_buffer->yy_ch_buf[yy_n_chars + 1] )
	YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

    /* try to read more data */

    /* first move last chars to start of buffer */
    number_to_move = yy_c_buf_p - yytext;

    for ( i = 0; i < number_to_move; ++i )
	*(dest++) = *(source++);

    if ( yy_current_buffer->yy_eof_status != EOF_NOT_SEEN )
	/* don't do the read, it's not guaranteed to return an EOF,
	 * just force an EOF
	 */
	yy_n_chars = 0;

    else
	{
	int num_to_read = yy_current_buffer->yy_buf_size - number_to_move - 1;

	if ( num_to_read > YY_READ_BUF_SIZE )
	    num_to_read = YY_READ_BUF_SIZE;

	else if ( num_to_read <= 0 )
	    YY_FATAL_ERROR( "fatal error - scanner input buffer overflow" );

	/* read in more data */
	YY_INPUT( (&yy_current_buffer->yy_ch_buf[number_to_move]),
		  yy_n_chars, num_to_read );
	}

    if ( yy_n_chars == 0 )
	{
	if ( number_to_move == 1 )
	    {
	    ret_val = EOB_ACT_END_OF_FILE;
	    yy_current_buffer->yy_eof_status = EOF_DONE;
	    }

	else
	    {
	    ret_val = EOB_ACT_LAST_MATCH;
	    yy_current_buffer->yy_eof_status = EOF_PENDING;
	    }
	}

    else
	ret_val = EOB_ACT_CONTINUE_SCAN;

    yy_n_chars += number_to_move;
    yy_current_buffer->yy_ch_buf[yy_n_chars] = YY_END_OF_BUFFER_CHAR;
    yy_current_buffer->yy_ch_buf[yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

    /* yytext begins at the second character in yy_ch_buf; the first
     * character is the one which preceded it before reading in the latest
     * buffer; it needs to be kept around in case it's a newline, so
     * yy_get_previous_state() will have with '^' rules active
     */

    yytext = &yy_current_buffer->yy_ch_buf[1];

    return ( ret_val );
    }


/* yy_get_previous_state - get the state just before the EOB char was reached
 *
 * synopsis
 *     yy_state_type yy_get_previous_state();
 */

static yy_state_type yy_get_previous_state()

    {
    register yy_state_type yy_current_state;
    register YY_CHAR *yy_cp;

    yy_current_state = yy_start;

    for ( yy_cp = yytext + YY_MORE_ADJ; yy_cp < yy_c_buf_p; ++yy_cp )
	{
	register YY_CHAR yy_c = (*yy_cp ? yy_ec[*yy_cp] : 1);
	if ( yy_accept[yy_current_state] )
	    {
	    yy_last_accepting_state = yy_current_state;
	    yy_last_accepting_cpos = yy_cp;
	    }
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	    {
	    yy_current_state = yy_def[yy_current_state];
	    if ( yy_current_state >= 298 )
		yy_c = yy_meta[yy_c];
	    }
	yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
	}

    return ( yy_current_state );
    }


/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *     next_state = yy_try_NUL_trans( current_state );
 */

#ifdef YY_USE_PROTOS
static yy_state_type yy_try_NUL_trans( register yy_state_type yy_current_state )
#else
static yy_state_type yy_try_NUL_trans( yy_current_state )
register yy_state_type yy_current_state;
#endif

    {
    register int yy_is_jam;
    register YY_CHAR *yy_cp = yy_c_buf_p;

    register YY_CHAR yy_c = 1;
    if ( yy_accept[yy_current_state] )
	{
	yy_last_accepting_state = yy_current_state;
	yy_last_accepting_cpos = yy_cp;
	}
    while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
	{
	yy_current_state = yy_def[yy_current_state];
	if ( yy_current_state >= 298 )
	    yy_c = yy_meta[yy_c];
	}
    yy_current_state = yy_nxt[yy_base[yy_current_state] + yy_c];
    yy_is_jam = (yy_current_state == 297);

    return ( yy_is_jam ? 0 : yy_current_state );
    }


#ifdef YY_USE_PROTOS
static void yyunput( YY_CHAR c, register YY_CHAR *yy_bp )
#else
static void yyunput( c, yy_bp )
YY_CHAR c;
register YY_CHAR *yy_bp;
#endif

    {
    register YY_CHAR *yy_cp = yy_c_buf_p;

    /* undo effects of setting up yytext */
    *yy_cp = yy_hold_char;

    if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	{ /* need to shift things up to make room */
	register int number_to_move = yy_n_chars + 2; /* +2 for EOB chars */
	register YY_CHAR *dest =
	    &yy_current_buffer->yy_ch_buf[yy_current_buffer->yy_buf_size + 2];
	register YY_CHAR *source =
	    &yy_current_buffer->yy_ch_buf[number_to_move];

	while ( source > yy_current_buffer->yy_ch_buf )
	    *--dest = *--source;

	yy_cp += dest - source;
	yy_bp += dest - source;
	yy_n_chars = yy_current_buffer->yy_buf_size;

	if ( yy_cp < yy_current_buffer->yy_ch_buf + 2 )
	    YY_FATAL_ERROR( "flex scanner push-back overflow" );
	}

    if ( yy_cp > yy_bp && yy_cp[-1] == '\n' )
	yy_cp[-2] = '\n';

    *--yy_cp = c;

    /* note: the formal parameter *must* be called "yy_bp" for this
     *       macro to now work correctly
     */
    YY_DO_BEFORE_ACTION; /* set up yytext again */
    }


#ifdef __cplusplus
static int yyinput()
#else
static int input()
#endif

    {
    int c;
    YY_CHAR *yy_cp = yy_c_buf_p;

    *yy_cp = yy_hold_char;

    if ( *yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
	{
	/* yy_c_buf_p now points to the character we want to return.
	 * If this occurs *before* the EOB characters, then it's a
	 * valid NUL; if not, then we've hit the end of the buffer.
	 */
	if ( yy_c_buf_p < &yy_current_buffer->yy_ch_buf[yy_n_chars] )
	    /* this was really a NUL */
	    *yy_c_buf_p = '\0';

	else
	    { /* need more input */
	    yytext = yy_c_buf_p;
	    ++yy_c_buf_p;

	    switch ( yy_get_next_buffer() )
		{
		case EOB_ACT_END_OF_FILE:
		    {
		    if ( yywrap() )
			{
			yy_c_buf_p = yytext + YY_MORE_ADJ;
			return ( EOF );
			}

		    YY_NEW_FILE;

#ifdef __cplusplus
		    return ( yyinput() );
#else
		    return ( input() );
#endif
		    }
		    break;

		case EOB_ACT_CONTINUE_SCAN:
		    yy_c_buf_p = yytext + YY_MORE_ADJ;
		    break;

		case EOB_ACT_LAST_MATCH:
#ifdef __cplusplus
		    YY_FATAL_ERROR( "unexpected last match in yyinput()" );
#else
		    YY_FATAL_ERROR( "unexpected last match in input()" );
#endif
		}
	    }
	}

    c = *yy_c_buf_p;
    yy_hold_char = *++yy_c_buf_p;

    return ( c );
    }


#ifdef YY_USE_PROTOS
void yyrestart( FILE *input_file )
#else
void yyrestart( input_file )
FILE *input_file;
#endif

    {
    yy_init_buffer( yy_current_buffer, input_file );
    yy_load_buffer_state();
    }


#ifdef YY_USE_PROTOS
void yy_switch_to_buffer( YY_BUFFER_STATE new_buffer )
#else
void yy_switch_to_buffer( new_buffer )
YY_BUFFER_STATE new_buffer;
#endif

    {
    if ( yy_current_buffer == new_buffer )
	return;

    if ( yy_current_buffer )
	{
	/* flush out information for old buffer */
	*yy_c_buf_p = yy_hold_char;
	yy_current_buffer->yy_buf_pos = yy_c_buf_p;
	yy_current_buffer->yy_n_chars = yy_n_chars;
	}

    yy_current_buffer = new_buffer;
    yy_load_buffer_state();

    /* we don't actually know whether we did this switch during
     * EOF (yywrap()) processing, but the only time this flag
     * is looked at is after yywrap() is called, so it's safe
     * to go ahead and always set it.
     */
    yy_did_buffer_switch_on_eof = 1;
    }


#ifdef YY_USE_PROTOS
void yy_load_buffer_state( void )
#else
void yy_load_buffer_state()
#endif

    {
    yy_n_chars = yy_current_buffer->yy_n_chars;
    yytext = yy_c_buf_p = yy_current_buffer->yy_buf_pos;
    yyin = yy_current_buffer->yy_input_file;
    yy_hold_char = *yy_c_buf_p;
    }


#ifdef YY_USE_PROTOS
YY_BUFFER_STATE yy_create_buffer( FILE *file, int size )
#else
YY_BUFFER_STATE yy_create_buffer( file, size )
FILE *file;
int size;
#endif

    {
    YY_BUFFER_STATE b;

    b = (YY_BUFFER_STATE) malloc( sizeof( struct yy_buffer_state ) );

    if ( ! b )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    b->yy_buf_size = size;

    /* yy_ch_buf has to be 2 characters longer than the size given because
     * we need to put in 2 end-of-buffer characters.
     */
    b->yy_ch_buf = (YY_CHAR *) malloc( (unsigned) (b->yy_buf_size + 2) );

    if ( ! b->yy_ch_buf )
	YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

    yy_init_buffer( b, file );

    return ( b );
    }


#ifdef YY_USE_PROTOS
void yy_delete_buffer( YY_BUFFER_STATE b )
#else
void yy_delete_buffer( b )
YY_BUFFER_STATE b;
#endif

    {
    if ( b == yy_current_buffer )
	yy_current_buffer = (YY_BUFFER_STATE) 0;

    free( (char *) b->yy_ch_buf );
    free( (char *) b );
    }


#ifdef YY_USE_PROTOS
void yy_init_buffer( YY_BUFFER_STATE b, FILE *file )
#else
void yy_init_buffer( b, file )
YY_BUFFER_STATE b;
FILE *file;
#endif

    {
    b->yy_input_file = file;

    /* we put in the '\n' and start reading from [1] so that an
     * initial match-at-newline will be true.
     */

    b->yy_ch_buf[0] = '\n';
    b->yy_n_chars = 1;

    /* we always need two end-of-buffer characters.  The first causes
     * a transition to the end-of-buffer state.  The second causes
     * a jam in that state.
     */
    b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;
    b->yy_ch_buf[2] = YY_END_OF_BUFFER_CHAR;

    b->yy_buf_pos = &b->yy_ch_buf[1];

    b->yy_eof_status = EOF_NOT_SEEN;
    }
# line 282 "scan.l"




/* This is the way to get multiple files input into lex. */

int
yywrap()
{
  if (!open_new_file ()) return (1);	/* EOF on standard in. */
  return (0);				/* We have more input. */
}
