/*	$OpenBSD: gallant12x22.h,v 1.1 2001/03/18 04:30:23 nate Exp $ */
/* 	$NetBSD: gallant12x22.h,v 1.2 1999/05/18 21:51:58 ad Exp $ */

/*
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to the Computer Systems
 * Engineering Group at Lawrence Berkeley Laboratory and to the University
 * of California at Berkeley by Jef Poskanzer.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Derived from: @(#)gallant19.h	8.1 (Berkeley) 6/11/93
 */
 
extern u_char gallant12x22_data[];

struct wsdisplay_font gallant12x22 = { 
	"Gallant",			/* typeface name */
	0,				/* index */
	' ',				/* firstchar */
	'~' - ' ' + 1,			/* numchars */
	WSDISPLAY_FONTENC_ISO,		/* encoding */
	12,				/* width */
	22,				/* height */
	2,				/* stride */
	WSDISPLAY_FONTORDER_L2R,	/* bit order */
	WSDISPLAY_FONTORDER_L2R,	/* byte order */
	NULL,				/* cookie */
	gallant12x22_data		/* data */
};
 
static u_char gallant12x22_data[] = {
	/*   */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ! */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* " */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* # */
	0x00, 0x00, 	/* ............ */
	0x03, 0x30, 	/* ......**..** */
	0x03, 0x30, 	/* ......**..** */
	0x03, 0x30, 	/* ......**..** */
	0x06, 0x60, 	/* .....**..**. */
	0x1f, 0xf0, 	/* ...********* */
	0x1f, 0xf0, 	/* ...********* */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x0c, 0xc0, 	/* ....**..**.. */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x33, 0x00, 	/* ..**..**.... */
	0x66, 0x00, 	/* .**..**..... */
	0x66, 0x00, 	/* .**..**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* $ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x3f, 0xc0, 	/* ..********.. */
	0x66, 0xe0, 	/* .**..**.***. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x00, 	/* .**..**..... */
	0x3e, 0x00, 	/* ..*****..... */
	0x1f, 0x80, 	/* ...******... */
	0x07, 0xc0, 	/* .....*****.. */
	0x06, 0x60, 	/* .....**..**. */
	0x06, 0x60, 	/* .....**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x7f, 0xc0, 	/* .*********.. */
	0x3f, 0x80, 	/* ..*******... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* % */
	0x00, 0x00, 	/* ............ */
	0x38, 0x60, 	/* ..***....**. */
	0x44, 0xc0, 	/* .*...*..**.. */
	0x44, 0xc0, 	/* .*...*..**.. */
	0x45, 0x80, 	/* .*...*.**... */
	0x39, 0x80, 	/* ..***..**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x19, 0xc0, 	/* ...**..***.. */
	0x1a, 0x20, 	/* ...**.*...*. */
	0x32, 0x20, 	/* ..**..*...*. */
	0x32, 0x20, 	/* ..**..*...*. */
	0x61, 0xc0, 	/* .**....***.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* & */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x18, 0xc0, 	/* ...**...**.. */
	0x18, 0xc0, 	/* ...**...**.. */
	0x0f, 0x80, 	/* ....*****... */
	0x1e, 0x00, 	/* ...****..... */
	0x3e, 0x00, 	/* ..*****..... */
	0x77, 0x00, 	/* .***.***.... */
	0x63, 0x60, 	/* .**...**.**. */
	0x61, 0xe0, 	/* .**....****. */
	0x61, 0xc0, 	/* .**....***.. */
	0x61, 0x80, 	/* .**....**... */
	0x3f, 0xe0, 	/* ..*********. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ' */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x10, 0x00, 	/* ...*........ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ( */
	0x00, 0x00, 	/* ............ */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x80, 	/* ......***... */
	0x03, 0x00, 	/* ......**.... */
	0x07, 0x00, 	/* .....***.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0x00, 	/* .....***.... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x80, 	/* ......***... */
	0x01, 0x80, 	/* .......**... */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ) */
	0x00, 0x00, 	/* ............ */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x00, 	/* ...**....... */
	0x1c, 0x00, 	/* ...***...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0e, 0x00, 	/* ....***..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0e, 0x00, 	/* ....***..... */
	0x0c, 0x00, 	/* ....**...... */
	0x1c, 0x00, 	/* ...***...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* * */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x06, 0x00, 	/* .....**..... */
	0x66, 0x60, 	/* .**..**..**. */
	0x76, 0xe0, 	/* .***.**.***. */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x19, 0x80, 	/* ...**..**... */
	0x76, 0xe0, 	/* .***.**.***. */
	0x66, 0x60, 	/* .**..**..**. */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* + */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* , */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x10, 0x00, 	/* ...*........ */
	0x00, 0x00, 	/* ............ */

	/* - */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* . */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* / */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x60, 0x00, 	/* .**......... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 0 */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0xc0, 	/* ...*....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x80, 	/* ..**....*... */
	0x18, 0x80, 	/* ...**...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x0e, 0x00, 	/* ....***..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 1 */
	0x00, 0x00, 	/* ............ */
	0x02, 0x00, 	/* ......*..... */
	0x06, 0x00, 	/* .....**..... */
	0x0e, 0x00, 	/* ....***..... */
	0x1e, 0x00, 	/* ...****..... */
	0x36, 0x00, 	/* ..**.**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x3f, 0xc0, 	/* ..********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 2 */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x00, 	/* ...*****.... */
	0x3f, 0x80, 	/* ..*******... */
	0x61, 0xc0, 	/* .**....***.. */
	0x40, 0xc0, 	/* .*......**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 3 */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x1f, 0xc0, 	/* ...*******.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x40, 0x60, 	/* .*.......**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xe0, 	/* ........***. */
	0x07, 0xc0, 	/* .....*****.. */
	0x0f, 0xc0, 	/* ....******.. */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x40, 0x60, 	/* .*.......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x3f, 0x80, 	/* ..*******... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 4 */
	0x00, 0x00, 	/* ............ */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x80, 	/* ......***... */
	0x03, 0x80, 	/* ......***... */
	0x05, 0x80, 	/* .....*.**... */
	0x05, 0x80, 	/* .....*.**... */
	0x09, 0x80, 	/* ....*..**... */
	0x09, 0x80, 	/* ....*..**... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x21, 0x80, 	/* ..*....**... */
	0x3f, 0xe0, 	/* ..*********. */
	0x7f, 0xe0, 	/* .**********. */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 5 */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x00, 	/* ...*........ */
	0x10, 0x00, 	/* ...*........ */
	0x20, 0x00, 	/* ..*......... */
	0x3f, 0x80, 	/* ..*******... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x40, 0x60, 	/* .*.......**. */
	0x60, 0x60, 	/* .**......**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 6 */
	0x00, 0x00, 	/* ............ */
	0x07, 0x00, 	/* .....***.... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x60, 0x00, 	/* .**......... */
	0x67, 0x80, 	/* .**..****... */
	0x6f, 0xc0, 	/* .**.******.. */
	0x70, 0xe0, 	/* .***....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0x80, 	/* ..*******... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 7 */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xe0, 	/* ...********. */
	0x3f, 0xe0, 	/* ..*********. */
	0x60, 0x40, 	/* .**......*.. */
	0x00, 0x40, 	/* .........*.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x80, 	/* ........*... */
	0x00, 0x80, 	/* ........*... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x00, 	/* .......*.... */
	0x01, 0x00, 	/* .......*.... */
	0x03, 0x00, 	/* ......**.... */
	0x02, 0x00, 	/* ......*..... */
	0x02, 0x00, 	/* ......*..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 8 */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0x80, 	/* ...*...**... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x11, 0x80, 	/* ...*...**... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* 9 */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0xe0, 	/* .***....***. */
	0x3f, 0x60, 	/* ..******.**. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x07, 0x00, 	/* .....***.... */
	0x3c, 0x00, 	/* ..****...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* : */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ; */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x10, 0x00, 	/* ...*........ */
	0x00, 0x00, 	/* ............ */

	/* < */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x01, 0xc0, 	/* .......***.. */
	0x07, 0x00, 	/* .....***.... */
	0x1e, 0x00, 	/* ...****..... */
	0x78, 0x00, 	/* .****....... */
	0x78, 0x00, 	/* .****....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x00, 	/* .....***.... */
	0x01, 0xc0, 	/* .......***.. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* = */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x7f, 0xc0, 	/* .*********.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* > */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x00, 	/* .**......... */
	0x38, 0x00, 	/* ..***....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xe0, 	/* .......****. */
	0x01, 0xe0, 	/* .......****. */
	0x07, 0x80, 	/* .....****... */
	0x1e, 0x00, 	/* ...****..... */
	0x38, 0x00, 	/* ..***....... */
	0x60, 0x00, 	/* .**......... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ? */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x1f, 0x80, 	/* ...******... */
	0x39, 0xc0, 	/* ..***..***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* @ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x3f, 0xc0, 	/* ..********.. */
	0x30, 0x60, 	/* ..**.....**. */
	0x60, 0x60, 	/* .**......**. */
	0x67, 0x20, 	/* .**..***..*. */
	0x6f, 0xa0, 	/* .**.*****.*. */
	0x6c, 0xa0, 	/* .**.**..*.*. */
	0x6c, 0xa0, 	/* .**.**..*.*. */
	0x67, 0xe0, 	/* .**..******. */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x3f, 0xe0, 	/* ..*********. */
	0x0f, 0xe0, 	/* ....*******. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* A */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x09, 0x00, 	/* ....*..*.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0x80, 	/* ...*...**... */
	0x10, 0x80, 	/* ...*....*... */
	0x3f, 0xc0, 	/* ..********.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x40, 	/* ..*......*.. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* B */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x60, 0x80, 	/* .**.....*... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x61, 0x80, 	/* .**....**... */
	0x7f, 0x80, 	/* .********... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0xc0, 	/* .**.....**.. */
	0xff, 0x80, 	/* *********... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* C */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x60, 	/* ...*.....**. */
	0x20, 0x20, 	/* ..*.......*. */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x20, 0x00, 	/* ..*......... */
	0x30, 0x20, 	/* ..**......*. */
	0x18, 0x40, 	/* ...**....*.. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* D */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x61, 0x80, 	/* .**....**... */
	0xfe, 0x00, 	/* *******..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* E */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* F */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xc0, 	/* .*********.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x80, 	/* ..**....*... */
	0x3f, 0x80, 	/* ..*******... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* G */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0xc0, 	/* ....******.. */
	0x10, 0x60, 	/* ...*.....**. */
	0x20, 0x20, 	/* ..*.......*. */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x61, 0xf0, 	/* .**....***** */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x60, 	/* ..*......**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* H */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xf0, 	/* ****....**** */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0xf0, 0xf0, 	/* ****....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* I */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* J */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x38, 0x00, 	/* ..***....... */
	0x30, 0x00, 	/* ..**........ */
	0x00, 0x00, 	/* ............ */

	/* K */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xe0, 	/* ****....***. */
	0x61, 0x80, 	/* .**....**... */
	0x63, 0x00, 	/* .**...**.... */
	0x66, 0x00, 	/* .**..**..... */
	0x6c, 0x00, 	/* .**.**...... */
	0x78, 0x00, 	/* .****....... */
	0x78, 0x00, 	/* .****....... */
	0x7c, 0x00, 	/* .*****...... */
	0x6e, 0x00, 	/* .**.***..... */
	0x67, 0x00, 	/* .**..***.... */
	0x63, 0x80, 	/* .**...***... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0xf0, 0x70, 	/* ****.....*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* L */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x78, 0x00, 	/* .****....... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x20, 	/* ..**......*. */
	0x30, 0x20, 	/* ..**......*. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* M */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xe0, 0x70, 	/* ***......*** */
	0x60, 0xe0, 	/* .**.....***. */
	0x70, 0xe0, 	/* .***....***. */
	0x70, 0xe0, 	/* .***....***. */
	0x70, 0xe0, 	/* .***....***. */
	0x59, 0x60, 	/* .*.**..*.**. */
	0x59, 0x60, 	/* .*.**..*.**. */
	0x59, 0x60, 	/* .*.**..*.**. */
	0x4d, 0x60, 	/* .*..**.*.**. */
	0x4e, 0x60, 	/* .*..***..**. */
	0x4e, 0x60, 	/* .*..***..**. */
	0x44, 0x60, 	/* .*...*...**. */
	0x44, 0x60, 	/* .*...*...**. */
	0xe4, 0xf0, 	/* ***..*..**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* N */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xc0, 0x70, 	/* **.......*** */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x20, 	/* .***......*. */
	0x78, 0x20, 	/* .****.....*. */
	0x58, 0x20, 	/* .*.**.....*. */
	0x4c, 0x20, 	/* .*..**....*. */
	0x46, 0x20, 	/* .*...**...*. */
	0x47, 0x20, 	/* .*...***..*. */
	0x43, 0x20, 	/* .*....**..*. */
	0x41, 0xa0, 	/* .*.....**.*. */
	0x40, 0xe0, 	/* .*......***. */
	0x40, 0xe0, 	/* .*......***. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0x30, 	/* ***.......** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* O */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x20, 0x40, 	/* ..*......*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* P */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0x80, 	/* .********... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0x60, 	/* ..**.....**. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x37, 0x80, 	/* ..**.****... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* Q */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x20, 0x60, 	/* ..*......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x40, 	/* ..***....*.. */
	0x1f, 0x80, 	/* ...******... */
	0x0e, 0x00, 	/* ....***..... */
	0x1f, 0x00, 	/* ...*****.... */
	0x23, 0x90, 	/* ..*...***..* */
	0x01, 0xe0, 	/* .......****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* R */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x00, 	/* ********.... */
	0x61, 0x80, 	/* .**....**... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0x80, 	/* .**.....*... */
	0x7f, 0x00, 	/* .*******.... */
	0x7c, 0x00, 	/* .*****...... */
	0x6e, 0x00, 	/* .**.***..... */
	0x67, 0x00, 	/* .**..***.... */
	0x63, 0x80, 	/* .**...***... */
	0x61, 0xc0, 	/* .**....***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0xf0, 0x70, 	/* ****.....*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* S */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xe0, 	/* ...********. */
	0x30, 0x60, 	/* ..**.....**. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x00, 	/* .***........ */
	0x3c, 0x00, 	/* ..****...... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xc0, 	/* .......***.. */
	0x00, 0xe0, 	/* ........***. */
	0x40, 0x60, 	/* .*.......**. */
	0x40, 0x60, 	/* .*.......**. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x7f, 0x80, 	/* .********... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* T */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x46, 0x20, 	/* .*...**...*. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* U */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x60, 0x20, 	/* .**.......*. */
	0x70, 0x40, 	/* .***.....*.. */
	0x3f, 0xc0, 	/* ..********.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* V */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xe0, 0xe0, 	/* ***.....***. */
	0x60, 0x40, 	/* .**......*.. */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x80, 	/* ..**....*... */
	0x30, 0x80, 	/* ..**....*... */
	0x19, 0x00, 	/* ...**..*.... */
	0x19, 0x00, 	/* ...**..*.... */
	0x19, 0x00, 	/* ...**..*.... */
	0x0c, 0x00, 	/* ....**...... */
	0x0e, 0x00, 	/* ....***..... */
	0x0e, 0x00, 	/* ....***..... */
	0x04, 0x00, 	/* .....*...... */
	0x04, 0x00, 	/* .....*...... */
	0x04, 0x00, 	/* .....*...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* W */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xfe, 0xf0, 	/* *******.**** */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x76, 0x20, 	/* .***.**...*. */
	0x77, 0x40, 	/* .***.***.*.. */
	0x33, 0x40, 	/* ..**..**.*.. */
	0x37, 0x40, 	/* ..**.***.*.. */
	0x3b, 0xc0, 	/* ..***.****.. */
	0x3b, 0x80, 	/* ..***.***... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* X */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0b, 0x00, 	/* ....*.**.... */
	0x11, 0x80, 	/* ...*...**... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x40, 0x60, 	/* .*.......**. */
	0xe0, 0xf0, 	/* ***.....**** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* Y */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0f, 0x00, 	/* ....****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* Z */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x3f, 0xe0, 	/* ..*********. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x20, 	/* ...**.....*. */
	0x3f, 0xe0, 	/* ..*********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* [ */
	0x00, 0x00, 	/* ............ */
	0x07, 0xc0, 	/* .....*****.. */
	0x07, 0xc0, 	/* .....*****.. */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0xc0, 	/* .....*****.. */
	0x07, 0xc0, 	/* .....*****.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* \ */
	0x00, 0x00, 	/* ............ */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x06, 0x00, 	/* .....**..... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ] */
	0x00, 0x00, 	/* ............ */
	0x7c, 0x00, 	/* .*****...... */
	0x7c, 0x00, 	/* .*****...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x7c, 0x00, 	/* .*****...... */
	0x7c, 0x00, 	/* .*****...... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ^ */
	0x00, 0x00, 	/* ............ */
	0x04, 0x00, 	/* .....*...... */
	0x0e, 0x00, 	/* ....***..... */
	0x1b, 0x00, 	/* ...**.**.... */
	0x31, 0x80, 	/* ..**...**... */
	0x60, 0xc0, 	/* .**.....**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* _ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0xf0, 	/* ************ */
	0xff, 0xf0, 	/* ************ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ` */
	0x00, 0x00, 	/* ............ */
	0x01, 0x00, 	/* .......*.... */
	0x03, 0x00, 	/* ......**.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x07, 0x80, 	/* .....****... */
	0x07, 0x80, 	/* .....****... */
	0x03, 0x00, 	/* ......**.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* a */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x18, 0xc0, 	/* ...**...**.. */
	0x10, 0xc0, 	/* ...*....**.. */
	0x03, 0xc0, 	/* ......****.. */
	0x1c, 0xc0, 	/* ...***..**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0xe0, 	/* ...****.***. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* b */
	0x00, 0x00, 	/* ............ */
	0x20, 0x00, 	/* ..*......... */
	0x60, 0x00, 	/* .**......... */
	0xe0, 0x00, 	/* ***......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x67, 0x80, 	/* .**..****... */
	0x6f, 0xc0, 	/* .**.******.. */
	0x70, 0xe0, 	/* .***....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x60, 	/* .***.....**. */
	0x78, 0xc0, 	/* .****...**.. */
	0x4f, 0x80, 	/* .*..*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* c */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x80, 	/* ...******... */
	0x31, 0xc0, 	/* ..**...***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x70, 0x40, 	/* .***.....*.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* d */
	0x00, 0x00, 	/* ............ */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xe0, 	/* ........***. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x0f, 0x60, 	/* ....****.**. */
	0x31, 0xe0, 	/* ..**...****. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0xe0, 	/* .***....***. */
	0x39, 0x60, 	/* ..***..*.**. */
	0x1e, 0x70, 	/* ...****..*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* e */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x00, 	/* ....****.... */
	0x30, 0xc0, 	/* ..**....**.. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x30, 0x00, 	/* ..**........ */
	0x18, 0x60, 	/* ...**....**. */
	0x0f, 0x80, 	/* ....*****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* f */
	0x00, 0x00, 	/* ............ */
	0x03, 0x80, 	/* ......***... */
	0x04, 0xc0, 	/* .....*..**.. */
	0x04, 0xc0, 	/* .....*..**.. */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x1f, 0x80, 	/* ...******... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x1e, 0x00, 	/* ...****..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* g */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0x20, 	/* ...*****..*. */
	0x31, 0xe0, 	/* ..**...****. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x60, 0xc0, 	/* .**.....**.. */
	0x31, 0x80, 	/* ..**...**... */
	0x3f, 0x00, 	/* ..******.... */
	0x60, 0x00, 	/* .**......... */
	0x7f, 0xc0, 	/* .*********.. */
	0x3f, 0xe0, 	/* ..*********. */
	0x20, 0x60, 	/* ..*......**. */
	0x40, 0x20, 	/* .*........*. */
	0x40, 0x20, 	/* .*........*. */
	0x7f, 0xc0, 	/* .*********.. */
	0x3f, 0x80, 	/* ..*******... */
	0x00, 0x00, 	/* ............ */

	/* h */
	0x00, 0x00, 	/* ............ */
	0x10, 0x00, 	/* ...*........ */
	0x30, 0x00, 	/* ..**........ */
	0x70, 0x00, 	/* .***........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x37, 0x80, 	/* ..**.****... */
	0x39, 0xc0, 	/* ..***..***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x79, 0xe0, 	/* .****..****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* i */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* j */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x03, 0xc0, 	/* ......****.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x00, 0xc0, 	/* ........**.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x0e, 0x00, 	/* ....***..... */
	0x00, 0x00, 	/* ............ */

	/* k */
	0x00, 0x00, 	/* ............ */
	0x60, 0x00, 	/* .**......... */
	0xe0, 0x00, 	/* ***......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x61, 0xc0, 	/* .**....***.. */
	0x63, 0x00, 	/* .**...**.... */
	0x66, 0x00, 	/* .**..**..... */
	0x7c, 0x00, 	/* .*****...... */
	0x78, 0x00, 	/* .****....... */
	0x7c, 0x00, 	/* .*****...... */
	0x6e, 0x00, 	/* .**.***..... */
	0x67, 0x00, 	/* .**..***.... */
	0x63, 0x80, 	/* .**...***... */
	0xf1, 0xe0, 	/* ****...****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* l */
	0x00, 0x00, 	/* ............ */
	0x1e, 0x00, 	/* ...****..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x1f, 0x80, 	/* ...******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* m */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xdd, 0xc0, 	/* **.***.***.. */
	0x6e, 0xe0, 	/* .**.***.***. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0x66, 0x60, 	/* .**..**..**. */
	0xef, 0x70, 	/* ***.****.*** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* n */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x27, 0x80, 	/* ..*..****... */
	0x79, 0xc0, 	/* .****..***.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x79, 0xe0, 	/* .****..****. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* o */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x80, 	/* ....*****... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1f, 0x00, 	/* ...*****.... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* p */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xef, 0x80, 	/* ***.*****... */
	0x71, 0xc0, 	/* .***...***.. */
	0x60, 0xe0, 	/* .**.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x40, 	/* .**......*.. */
	0x70, 0x80, 	/* .***....*... */
	0x7f, 0x00, 	/* .*******.... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0x60, 0x00, 	/* .**......... */
	0xf0, 0x00, 	/* ****........ */
	0x00, 0x00, 	/* ............ */

	/* q */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x0f, 0x20, 	/* ....****..*. */
	0x11, 0xe0, 	/* ...*...****. */
	0x20, 0xe0, 	/* ..*.....***. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x60, 0x60, 	/* .**......**. */
	0x70, 0x60, 	/* .***.....**. */
	0x38, 0xe0, 	/* ..***...***. */
	0x1f, 0xe0, 	/* ...********. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0x60, 	/* .........**. */
	0x00, 0xf0, 	/* ........**** */
	0x00, 0x00, 	/* ............ */

	/* r */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x73, 0x80, 	/* .***..***... */
	0x34, 0xc0, 	/* ..**.*..**.. */
	0x38, 0xc0, 	/* ..***...**.. */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x30, 0x00, 	/* ..**........ */
	0x78, 0x00, 	/* .****....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* s */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1f, 0xc0, 	/* ...*******.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x38, 0x00, 	/* ..***....... */
	0x1e, 0x00, 	/* ...****..... */
	0x07, 0x80, 	/* .....****... */
	0x01, 0xc0, 	/* .......***.. */
	0x20, 0xc0, 	/* ..*.....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x3f, 0x80, 	/* ..*******... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* t */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x04, 0x00, 	/* .....*...... */
	0x04, 0x00, 	/* .....*...... */
	0x0c, 0x00, 	/* ....**...... */
	0x7f, 0xc0, 	/* .*********.. */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x20, 	/* ....**....*. */
	0x0e, 0x40, 	/* ....***..*.. */
	0x07, 0x80, 	/* .....****... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* u */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x79, 0xe0, 	/* .****..****. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x30, 0xc0, 	/* ..**....**.. */
	0x39, 0xc0, 	/* ..***..***.. */
	0x1e, 0x60, 	/* ...****..**. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* v */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0x70, 	/* ****.....*** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* w */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xff, 0x70, 	/* ********.*** */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x66, 0x20, 	/* .**..**...*. */
	0x37, 0x40, 	/* ..**.***.*.. */
	0x3b, 0x40, 	/* ..***.**.*.. */
	0x3b, 0x40, 	/* ..***.**.*.. */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x19, 0x80, 	/* ...**..**... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* x */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf8, 0xf0, 	/* *****...**** */
	0x70, 0x40, 	/* .***.....*.. */
	0x38, 0x80, 	/* ..***...*... */
	0x1d, 0x00, 	/* ...***.*.... */
	0x0e, 0x00, 	/* ....***..... */
	0x07, 0x00, 	/* .....***.... */
	0x0b, 0x80, 	/* ....*.***... */
	0x11, 0xc0, 	/* ...*...***.. */
	0x20, 0xe0, 	/* ..*.....***. */
	0xf1, 0xf0, 	/* ****...***** */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* y */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0xf0, 0xf0, 	/* ****....**** */
	0x60, 0x20, 	/* .**.......*. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x30, 0x40, 	/* ..**.....*.. */
	0x18, 0x80, 	/* ...**...*... */
	0x18, 0x80, 	/* ...**...*... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x0d, 0x00, 	/* ....**.*.... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x04, 0x00, 	/* .....*...... */
	0x0c, 0x00, 	/* ....**...... */
	0x08, 0x00, 	/* ....*....... */
	0x78, 0x00, 	/* .****....... */
	0x70, 0x00, 	/* .***........ */
	0x00, 0x00, 	/* ............ */

	/* z */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x7f, 0xe0, 	/* .**********. */
	0x60, 0xe0, 	/* .**.....***. */
	0x41, 0xc0, 	/* .*.....***.. */
	0x03, 0x80, 	/* ......***... */
	0x07, 0x00, 	/* .....***.... */
	0x0e, 0x00, 	/* ....***..... */
	0x1c, 0x00, 	/* ...***...... */
	0x38, 0x20, 	/* ..***.....*. */
	0x70, 0x60, 	/* .***.....**. */
	0x7f, 0xe0, 	/* .**********. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* { */
	0x00, 0x00, 	/* ............ */
	0x01, 0xc0, 	/* .......***.. */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x07, 0x00, 	/* .....***.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x01, 0x80, 	/* .......**... */
	0x03, 0x00, 	/* ......**.... */
	0x03, 0x00, 	/* ......**.... */
	0x01, 0xc0, 	/* .......***.. */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* | */
	0x00, 0x00, 	/* ............ */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x06, 0x00, 	/* .....**..... */
	0x00, 0x00, 	/* ............ */

	/* } */
	0x00, 0x00, 	/* ............ */
	0x38, 0x00, 	/* ..***....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0e, 0x00, 	/* ....***..... */
	0x0c, 0x00, 	/* ....**...... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x18, 0x00, 	/* ...**....... */
	0x0c, 0x00, 	/* ....**...... */
	0x0c, 0x00, 	/* ....**...... */
	0x38, 0x00, 	/* ..***....... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */

	/* ~ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x1c, 0x20, 	/* ...***....*. */
	0x3e, 0x60, 	/* ..*****..**. */
	0x36, 0xc0, 	/* ..**.**.**.. */
	0x67, 0xc0, 	/* .**..*****.. */
	0x43, 0x80, 	/* .*....***... */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
	0x00, 0x00, 	/* ............ */
};
