require '_h2ph_pre.ph';

unless(defined(&WI_TIMEOUT)) {
    sub WI_TIMEOUT () {	50000;}
}
unless(defined(&WI_PORT0)) {
    sub WI_PORT0 () {	0;}
}
unless(defined(&WI_PORT1)) {
    sub WI_PORT1 () {	1;}
}
unless(defined(&WI_PORT2)) {
    sub WI_PORT2 () {	2;}
}
unless(defined(&WI_PORT3)) {
    sub WI_PORT3 () {	3;}
}
unless(defined(&WI_PORT4)) {
    sub WI_PORT4 () {	4;}
}
unless(defined(&WI_PORT5)) {
    sub WI_PORT5 () {	5;}
}
unless(defined(&WI_DEFAULT_PORT)) {
    sub WI_DEFAULT_PORT () {	( &WI_PORT0 << 8);}
}
unless(defined(&WI_DEFAULT_TX_RATE)) {
    sub WI_DEFAULT_TX_RATE () {	3;}
}
unless(defined(&WI_DEFAULT_NETNAME)) {
    sub WI_DEFAULT_NETNAME () {	"";}
}
unless(defined(&WI_DEFAULT_AP_DENSITY)) {
    sub WI_DEFAULT_AP_DENSITY () {	1;}
}
unless(defined(&WI_DEFAULT_RTS_THRESH)) {
    sub WI_DEFAULT_RTS_THRESH () {	2347;}
}
unless(defined(&WI_DEFAULT_DATALEN)) {
    sub WI_DEFAULT_DATALEN () {	2304;}
}
unless(defined(&WI_DEFAULT_CREATE_IBSS)) {
    sub WI_DEFAULT_CREATE_IBSS () {	0;}
}
unless(defined(&WI_DEFAULT_PM_ENABLED)) {
    sub WI_DEFAULT_PM_ENABLED () {	0;}
}
unless(defined(&WI_DEFAULT_MAX_SLEEP)) {
    sub WI_DEFAULT_MAX_SLEEP () {	100;}
}
unless(defined(&WI_DEFAULT_NODENAME)) {
    sub WI_DEFAULT_NODENAME () {	"WaveLAN/IEEE node";}
}
unless(defined(&WI_DEFAULT_IBSS)) {
    sub WI_DEFAULT_IBSS () {	"IBSS";}
}
unless(defined(&WI_DEFAULT_CHAN)) {
    sub WI_DEFAULT_CHAN () {	3;}
}
unless(defined(&WI_DEFAULT_ROAMING)) {
    sub WI_DEFAULT_ROAMING () {	1;}
}
unless(defined(&WI_DEFAULT_AUTHTYPE)) {
    sub WI_DEFAULT_AUTHTYPE () {	1;}
}
unless(defined(&CSR_WRITE_4)) {
    sub CSR_WRITE_4 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_4( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_2)) {
    sub CSR_WRITE_2 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_2( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_WRITE_1)) {
    sub CSR_WRITE_1 {
	local($sc, $reg, $val) = @_;
	eval q( &bus_space_write_1( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), $reg, $val));
    }
}
unless(defined(&CSR_READ_4)) {
    sub CSR_READ_4 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_4( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_2)) {
    sub CSR_READ_2 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_2( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_1)) {
    sub CSR_READ_1 {
	local($sc, $reg) = @_;
	eval q( &bus_space_read_1( ($sc->{wi_btag}),  ($sc->{wi_bhandle}), $reg));
    }
}
unless(defined(&CSR_READ_RAW_2)) {
    sub CSR_READ_RAW_2 {
	local($sc, $ba, $dst, $sz) = @_;
	eval q( &bus_space_read_raw_multi_2(($sc)-> &wi_btag, ($sc)-> &wi_bhandle, ($ba), ($dst), ($sz)));
    }
}
unless(defined(&CSR_WRITE_RAW_2)) {
    sub CSR_WRITE_RAW_2 {
	local($sc, $ba, $dst, $sz) = @_;
	eval q( &bus_space_write_raw_multi_2(($sc)-> &wi_btag, ($sc)-> &wi_bhandle, ($ba), ($dst), ($sz)));
    }
}
unless(defined(&WI_IOSIZ)) {
    sub WI_IOSIZ () {	0x40;}
}
unless(defined(&WI_COMMAND)) {
    sub WI_COMMAND () {	0x00;}
}
unless(defined(&WI_PARAM0)) {
    sub WI_PARAM0 () {	0x02;}
}
unless(defined(&WI_PARAM1)) {
    sub WI_PARAM1 () {	0x04;}
}
unless(defined(&WI_PARAM2)) {
    sub WI_PARAM2 () {	0x06;}
}
unless(defined(&WI_STATUS)) {
    sub WI_STATUS () {	0x08;}
}
unless(defined(&WI_RESP0)) {
    sub WI_RESP0 () {	0x0a;}
}
unless(defined(&WI_RESP1)) {
    sub WI_RESP1 () {	0x0c;}
}
unless(defined(&WI_RESP2)) {
    sub WI_RESP2 () {	0x0e;}
}
unless(defined(&WI_CMD_BUSY)) {
    sub WI_CMD_BUSY () {	0x8000;}
}
unless(defined(&WI_CMD_INI)) {
    sub WI_CMD_INI () {	0x0000;}
}
unless(defined(&WI_CMD_ENABLE)) {
    sub WI_CMD_ENABLE () {	0x0001;}
}
unless(defined(&WI_CMD_DISABLE)) {
    sub WI_CMD_DISABLE () {	0x0002;}
}
unless(defined(&WI_CMD_DIAG)) {
    sub WI_CMD_DIAG () {	0x0003;}
}
unless(defined(&WI_CMD_ALLOC_MEM)) {
    sub WI_CMD_ALLOC_MEM () {	0x000a;}
}
unless(defined(&WI_CMD_TX)) {
    sub WI_CMD_TX () {	0x000b;}
}
unless(defined(&WI_CMD_NOTIFY)) {
    sub WI_CMD_NOTIFY () {	0x0010;}
}
unless(defined(&WI_CMD_INQUIRE)) {
    sub WI_CMD_INQUIRE () {	0x0011;}
}
unless(defined(&WI_CMD_ACCESS)) {
    sub WI_CMD_ACCESS () {	0x0021;}
}
unless(defined(&WI_CMD_PROGRAM)) {
    sub WI_CMD_PROGRAM () {	0x0022;}
}
unless(defined(&WI_CMD_CODE_MASK)) {
    sub WI_CMD_CODE_MASK () {	0x003f;}
}
unless(defined(&WI_RECLAIM)) {
    sub WI_RECLAIM () {	0x0100;}
}
unless(defined(&WI_ACCESS_READ)) {
    sub WI_ACCESS_READ () {	0x0000;}
}
unless(defined(&WI_ACCESS_WRITE)) {
    sub WI_ACCESS_WRITE () {	0x0100;}
}
unless(defined(&WI_PROGRAM_DISABLE)) {
    sub WI_PROGRAM_DISABLE () {	0x0000;}
}
unless(defined(&WI_PROGRAM_ENABLE_RAM)) {
    sub WI_PROGRAM_ENABLE_RAM () {	0x0100;}
}
unless(defined(&WI_PROGRAM_ENABLE_NVRAM)) {
    sub WI_PROGRAM_ENABLE_NVRAM () {	0x0200;}
}
unless(defined(&WI_PROGRAM_NVRAM)) {
    sub WI_PROGRAM_NVRAM () {	0x0300;}
}
unless(defined(&WI_STAT_CMD_CODE)) {
    sub WI_STAT_CMD_CODE () {	0x003f;}
}
unless(defined(&WI_STAT_DIAG_ERR)) {
    sub WI_STAT_DIAG_ERR () {	0x0100;}
}
unless(defined(&WI_STAT_INQ_ERR)) {
    sub WI_STAT_INQ_ERR () {	0x0500;}
}
unless(defined(&WI_STAT_CMD_RESULT)) {
    sub WI_STAT_CMD_RESULT () {	0x7f00;}
}
unless(defined(&WI_INFO_FID)) {
    sub WI_INFO_FID () {	0x10;}
}
unless(defined(&WI_RX_FID)) {
    sub WI_RX_FID () {	0x20;}
}
unless(defined(&WI_ALLOC_FID)) {
    sub WI_ALLOC_FID () {	0x22;}
}
unless(defined(&WI_TX_CMP_FID)) {
    sub WI_TX_CMP_FID () {	0x24;}
}
unless(defined(&WI_SEL0)) {
    sub WI_SEL0 () {	0x18;}
}
unless(defined(&WI_SEL1)) {
    sub WI_SEL1 () {	0x1a;}
}
unless(defined(&WI_OFF0)) {
    sub WI_OFF0 () {	0x1c;}
}
unless(defined(&WI_OFF1)) {
    sub WI_OFF1 () {	0x1e;}
}
unless(defined(&WI_DATA0)) {
    sub WI_DATA0 () {	0x36;}
}
unless(defined(&WI_DATA1)) {
    sub WI_DATA1 () {	0x38;}
}
unless(defined(&WI_BAP0)) {
    sub WI_BAP0 () {	 &WI_DATA0;}
}
unless(defined(&WI_BAP1)) {
    sub WI_BAP1 () {	 &WI_DATA1;}
}
unless(defined(&WI_OFF_BUSY)) {
    sub WI_OFF_BUSY () {	0x8000;}
}
unless(defined(&WI_OFF_ERR)) {
    sub WI_OFF_ERR () {	0x4000;}
}
unless(defined(&WI_OFF_DATAOFF)) {
    sub WI_OFF_DATAOFF () {	0x0fff;}
}
unless(defined(&WI_EVENT_STAT)) {
    sub WI_EVENT_STAT () {	0x30;}
}
unless(defined(&WI_INT_EN)) {
    sub WI_INT_EN () {	0x32;}
}
unless(defined(&WI_EVENT_ACK)) {
    sub WI_EVENT_ACK () {	0x34;}
}
unless(defined(&WI_EV_TICK)) {
    sub WI_EV_TICK () {	0x8000;}
}
unless(defined(&WI_EV_RES)) {
    sub WI_EV_RES () {	0x4000;}
}
unless(defined(&WI_EV_INFO_DROP)) {
    sub WI_EV_INFO_DROP () {	0x2000;}
}
unless(defined(&WI_EV_NO_CARD)) {
    sub WI_EV_NO_CARD () {	0x0800;}
}
unless(defined(&WI_EV_DUIF_RX)) {
    sub WI_EV_DUIF_RX () {	0x0400;}
}
unless(defined(&WI_EV_INFO)) {
    sub WI_EV_INFO () {	0x0080;}
}
unless(defined(&WI_EV_CMD)) {
    sub WI_EV_CMD () {	0x0010;}
}
unless(defined(&WI_EV_ALLOC)) {
    sub WI_EV_ALLOC () {	0x0008;}
}
unless(defined(&WI_EV_TX_EXC)) {
    sub WI_EV_TX_EXC () {	0x0004;}
}
unless(defined(&WI_EV_TX)) {
    sub WI_EV_TX () {	0x0002;}
}
unless(defined(&WI_EV_RX)) {
    sub WI_EV_RX () {	0x0001;}
}
unless(defined(&WI_INTRS)) {
    sub WI_INTRS () {	( &WI_EV_RX| &WI_EV_TX| &WI_EV_TX_EXC| &WI_EV_ALLOC| &WI_EV_INFO| &WI_EV_INFO_DROP);}
}
unless(defined(&WI_SW0)) {
    sub WI_SW0 () {	0x28;}
}
unless(defined(&WI_SW1)) {
    sub WI_SW1 () {	0x2a;}
}
unless(defined(&WI_SW2)) {
    sub WI_SW2 () {	0x2c;}
}
unless(defined(&WI_SW3)) {
    sub WI_SW3 () {	0x2e;}
}
unless(defined(&WI_CNTL)) {
    sub WI_CNTL () {	0x14;}
}
unless(defined(&WI_CNTL_AUX_ENA)) {
    sub WI_CNTL_AUX_ENA () {	0xc000;}
}
unless(defined(&WI_CNTL_AUX_ENA_STAT)) {
    sub WI_CNTL_AUX_ENA_STAT () {	0xc000;}
}
unless(defined(&WI_CNTL_AUX_DIS_STAT)) {
    sub WI_CNTL_AUX_DIS_STAT () {	0x0000;}
}
unless(defined(&WI_CNTL_AUX_ENA_CNTL)) {
    sub WI_CNTL_AUX_ENA_CNTL () {	0x8000;}
}
unless(defined(&WI_CNTL_AUX_DIS_CNTL)) {
    sub WI_CNTL_AUX_DIS_CNTL () {	0x4000;}
}
unless(defined(&WI_AUX_PAGE)) {
    sub WI_AUX_PAGE () {	0x3a;}
}
unless(defined(&WI_AUX_OFFSET)) {
    sub WI_AUX_OFFSET () {	0x3c;}
}
unless(defined(&WI_AUX_DATA)) {
    sub WI_AUX_DATA () {	0x3e;}
}
unless(defined(&WI_COR_OFFSET)) {
    sub WI_COR_OFFSET () {	0x3e0;}
}
unless(defined(&WI_COR_VALUE)) {
    sub WI_COR_VALUE () {	0x41;}
}
unless(defined(&WI_SETVAL)) {
    sub WI_SETVAL {
	local($recno, $val) = @_;
	eval q( &do { 'struct wi_ltv_gen'  &g;  ($g->{wi_len}) = 2;  ($g->{wi_type}) = $recno;  ($g->{wi_val}) =  &htole16($val);  &wi_write_record( &sc,  &g); }  &while (0));
    }
}
unless(defined(&WI_SETSTR)) {
    sub WI_SETSTR {
	local($recno, $str) = @_;
	eval q( &do { 'struct wi_ltv_str'  &s; 'int'  &l;  &l = ( &strlen($str) + 1) & ~0x1;  &bzero( &s, $sizeof{ &s});  ($s->{wi_len}) = ( &l / 2) + 2;  ($s->{wi_type}) = $recno;  ($s->{wi_str[0]}) =  &htole16( &strlen($str));  &bcopy($str,  ($s->{wi_str[1]}),  &strlen($str));  &wi_write_record( &sc,  &s); }  &while (0));
    }
}
unless(defined(&WI_RID_DNLD_BUF)) {
    sub WI_RID_DNLD_BUF () {	0xfd01;}
}
unless(defined(&WI_RID_MEMSZ)) {
    sub WI_RID_MEMSZ () {	0xfd02;}
}
unless(defined(&WI_NIC_EVB2)) {
    sub WI_NIC_EVB2 () {	0x8000;}
}
unless(defined(&WI_NIC_HWB3763)) {
    sub WI_NIC_HWB3763 () {	0x8001;}
}
unless(defined(&WI_NIC_HWB3163)) {
    sub WI_NIC_HWB3163 () {	0x8002;}
}
unless(defined(&WI_NIC_HWB3163B)) {
    sub WI_NIC_HWB3163B () {	0x8003;}
}
unless(defined(&WI_NIC_EVB3)) {
    sub WI_NIC_EVB3 () {	0x8004;}
}
unless(defined(&WI_NIC_HWB1153)) {
    sub WI_NIC_HWB1153 () {	0x8007;}
}
unless(defined(&WI_NIC_P2_SST)) {
    sub WI_NIC_P2_SST () {	0x8008;}
}
unless(defined(&WI_NIC_PRISM2_5)) {
    sub WI_NIC_PRISM2_5 () {	0x800c;}
}
unless(defined(&WI_PORTTYPE_BSS)) {
    sub WI_PORTTYPE_BSS () {	0x1;}
}
unless(defined(&WI_PORTTYPE_WDS)) {
    sub WI_PORTTYPE_WDS () {	0x2;}
}
unless(defined(&WI_PORTTYPE_ADHOC)) {
    sub WI_PORTTYPE_ADHOC () {	0x3;}
}
unless(defined(&WI_INFO_NOTIFY)) {
    sub WI_INFO_NOTIFY () {	0xf000;}
}
unless(defined(&WI_INFO_COUNTERS)) {
    sub WI_INFO_COUNTERS () {	0xf100;}
}
unless(defined(&WI_INFO_SCAN_RESULTS)) {
    sub WI_INFO_SCAN_RESULTS () {	0xf101;}
}
unless(defined(&WI_INFO_LINK_STAT)) {
    sub WI_INFO_LINK_STAT () {	0xf200;}
}
unless(defined(&WI_INFO_ASSOC_STAT)) {
    sub WI_INFO_ASSOC_STAT () {	0xf201;}
}
unless(defined(&WI_802_3_OFFSET)) {
    sub WI_802_3_OFFSET () {	0x2e;}
}
unless(defined(&WI_802_11_OFFSET)) {
    sub WI_802_11_OFFSET () {	0x44;}
}
unless(defined(&WI_802_11_OFFSET_RAW)) {
    sub WI_802_11_OFFSET_RAW () {	0x3c;}
}
unless(defined(&WI_STAT_BADCRC)) {
    sub WI_STAT_BADCRC () {	0x0001;}
}
unless(defined(&WI_STAT_UNDECRYPTABLE)) {
    sub WI_STAT_UNDECRYPTABLE () {	0x0002;}
}
unless(defined(&WI_STAT_ERRSTAT)) {
    sub WI_STAT_ERRSTAT () {	0x0003;}
}
unless(defined(&WI_STAT_MAC_PORT)) {
    sub WI_STAT_MAC_PORT () {	0x0700;}
}
unless(defined(&WI_STAT_1042)) {
    sub WI_STAT_1042 () {	0x2000;}
}
unless(defined(&WI_STAT_TUNNEL)) {
    sub WI_STAT_TUNNEL () {	0x4000;}
}
unless(defined(&WI_STAT_WMP_MSG)) {
    sub WI_STAT_WMP_MSG () {	0x6000;}
}
unless(defined(&WI_RXSTAT_MSG_TYPE)) {
    sub WI_RXSTAT_MSG_TYPE () {	0xe000;}
}
unless(defined(&WI_ENC_TX_802_3)) {
    sub WI_ENC_TX_802_3 () {	0x00;}
}
unless(defined(&WI_ENC_TX_802_11)) {
    sub WI_ENC_TX_802_11 () {	0x11;}
}
unless(defined(&WI_ENC_TX_E_II)) {
    sub WI_ENC_TX_E_II () {	0x0e;}
}
unless(defined(&WI_ENC_TX_1042)) {
    sub WI_ENC_TX_1042 () {	0x00;}
}
unless(defined(&WI_ENC_TX_TUNNEL)) {
    sub WI_ENC_TX_TUNNEL () {	0xf8;}
}
unless(defined(&WI_TXCNTL_MACPORT)) {
    sub WI_TXCNTL_MACPORT () {	0x00ff;}
}
unless(defined(&WI_TXCNTL_STRUCTTYPE)) {
    sub WI_TXCNTL_STRUCTTYPE () {	0xff00;}
}
unless(defined(&WI_SNAP_K1)) {
    sub WI_SNAP_K1 () {	0xaa;}
}
unless(defined(&WI_SNAP_K2)) {
    sub WI_SNAP_K2 () {	0x00;}
}
unless(defined(&WI_SNAP_CONTROL)) {
    sub WI_SNAP_CONTROL () {	0x03;}
}
unless(defined(&WI_SNAP_WORD0)) {
    sub WI_SNAP_WORD0 () {	( &WI_SNAP_K1 | ( &WI_SNAP_K1 << 8));}
}
unless(defined(&WI_SNAP_WORD1)) {
    sub WI_SNAP_WORD1 () {	( &WI_SNAP_K2 | ( &WI_SNAP_CONTROL << 8));}
}
unless(defined(&WI_SNAPHDR_LEN)) {
    sub WI_SNAPHDR_LEN () {	0x6;}
}
1;
