require '_h2ph_pre.ph';

unless(defined(&HEADER_PKCS12_H)) {
    eval 'sub HEADER_PKCS12_H () {1;}' unless defined(&HEADER_PKCS12_H);
    require 'ssl/bio.ph';
    require 'ssl/x509.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub PKCS12_KEY_ID () {1;}' unless defined(&PKCS12_KEY_ID);
    eval 'sub PKCS12_IV_ID () {2;}' unless defined(&PKCS12_IV_ID);
    eval 'sub PKCS12_MAC_ID () {3;}' unless defined(&PKCS12_MAC_ID);
    unless(defined(&PKCS12_DEFAULT_ITER)) {
	eval 'sub PKCS12_DEFAULT_ITER () { &PKCS5_DEFAULT_ITER;}' unless defined(&PKCS12_DEFAULT_ITER);
    }
    eval 'sub PKCS12_MAC_KEY_LENGTH () {20;}' unless defined(&PKCS12_MAC_KEY_LENGTH);
    eval 'sub PKCS12_SALT_LEN () {8;}' unless defined(&PKCS12_SALT_LEN);
    if(defined(&PBE_UNICODE)) {
	eval 'sub PKCS12_key_gen () { &PKCS12_key_gen_uni;}' unless defined(&PKCS12_key_gen);
	eval 'sub PKCS12_add_friendlyname () { &PKCS12_add_friendlyname_uni;}' unless defined(&PKCS12_add_friendlyname);
    } else {
	eval 'sub PKCS12_key_gen () { &PKCS12_key_gen_asc;}' unless defined(&PKCS12_key_gen);
	eval 'sub PKCS12_add_friendlyname () { &PKCS12_add_friendlyname_asc;}' unless defined(&PKCS12_add_friendlyname);
    }
    eval 'sub KEY_EX () {0x10;}' unless defined(&KEY_EX);
    eval 'sub KEY_SIG () {0x80;}' unless defined(&KEY_SIG);
    eval 'sub PKCS12_ERROR () {0;}' unless defined(&PKCS12_ERROR);
    eval 'sub PKCS12_OK () {1;}' unless defined(&PKCS12_OK);
    eval 'sub M_PKCS12_bag_type {
        local($bag) = @_;
	    eval q( &OBJ_obj2nid( ($bag->{type})));
    }' unless defined(&M_PKCS12_bag_type);
    eval 'sub M_PKCS12_cert_bag_type {
        local($bag) = @_;
	    eval q( &OBJ_obj2nid( ($bag->{value}->{bag}->{type})));
    }' unless defined(&M_PKCS12_cert_bag_type);
    eval 'sub M_PKCS12_crl_bag_type () { &M_PKCS12_cert_bag_type;}' unless defined(&M_PKCS12_crl_bag_type);
    eval 'sub M_PKCS12_x5092certbag {
        local($x509) = @_;
	    eval q( &PKCS12_pack_safebag(($x509),  &i2d_X509,  &NID_x509Certificate,  &NID_certBag));
    }' unless defined(&M_PKCS12_x5092certbag);
    eval 'sub M_PKCS12_x509crl2certbag {
        local($crl) = @_;
	    eval q( &PKCS12_pack_safebag(($crl),  &i2d_X509CRL,  &NID_x509Crl,  &NID_crlBag));
    }' unless defined(&M_PKCS12_x509crl2certbag);
    eval 'sub M_PKCS12_certbag2x509 {
        local($bg) = @_;
	    eval q(  &ASN1_unpack_string(($bg)-> ($value->{bag}->{value}->{octet}), (\'char\' *(*)()) &d2i_X509));
    }' unless defined(&M_PKCS12_certbag2x509);
    eval 'sub M_PKCS12_certbag2x509crl {
        local($bg) = @_;
	    eval q(  &ASN1_unpack_string(($bg)-> ($value->{bag}->{value}->{octet}), (\'char\' *(*)()) &d2i_X509CRL));
    }' unless defined(&M_PKCS12_certbag2x509crl);
    eval 'sub M_PKCS12_unpack_p7data {
        local($p7) = @_;
	    eval q( &ASN1_seq_unpack_PKCS12_SAFEBAG(($p7)-> ($d->{data}->{data}),  ($p7->{d}->{data}->{length}),  &d2i_PKCS12_SAFEBAG,  &PKCS12_SAFEBAG_free));
    }' unless defined(&M_PKCS12_unpack_p7data);
    eval 'sub M_PKCS12_pack_authsafes {
        local($p12, $safes) = @_;
	    eval q( &ASN1_seq_pack_PKCS7(($safes),  &i2d_PKCS7, ($p12)-> ($authsafes->{d}->{data}->{data}), ($p12)-> ($authsafes->{d}->{data}->{length})));
    }' unless defined(&M_PKCS12_pack_authsafes);
    eval 'sub M_PKCS12_unpack_authsafes {
        local($p12) = @_;
	    eval q( &ASN1_seq_unpack_PKCS7(($p12)-> ($authsafes->{d}->{data}->{data}), ($p12)-> ($authsafes->{d}->{data}->{length}),  &d2i_PKCS7,  &PKCS7_free));
    }' unless defined(&M_PKCS12_unpack_authsafes);
    eval 'sub M_PKCS12_unpack_p7encdata {
        local($p7, $pass, $passlen) = @_;
	    eval q( &PKCS12_decrypt_d2i_PKCS12_SAFEBAG(($p7)-> ($d->{encrypted}->{enc_data}->{algorithm}),  &d2i_PKCS12_SAFEBAG,  &PKCS12_SAFEBAG_free, ($pass), ($passlen), ($p7)-> ($d->{encrypted}->{enc_data}->{enc_data}), 3));
    }' unless defined(&M_PKCS12_unpack_p7encdata);
    eval 'sub M_PKCS12_decrypt_skey {
        local($bag, $pass, $passlen) = @_;
	    eval q(  &PKCS12_decrypt_d2i(($bag)-> ($value->{shkeybag}->{algor}), (\'char\' *(*)()) &d2i_PKCS8_PRIV_KEY_INFO, ( &void (*)( &void *)) &PKCS8_PRIV_KEY_INFO_free, ($pass), ($passlen), ($bag)-> ($value->{shkeybag}->{digest}), 2));
    }' unless defined(&M_PKCS12_decrypt_skey);
    eval 'sub M_PKCS8_decrypt {
        local($p8, $pass, $passlen) = @_;
	    eval q(  &PKCS12_decrypt_d2i(($p8)-> &algor, (\'char\' *(*)()) &d2i_PKCS8_PRIV_KEY_INFO, ( &void (*)( &void *)) &PKCS8_PRIV_KEY_INFO_free, ($pass), ($passlen), ($p8)-> &digest, 2));
    }' unless defined(&M_PKCS8_decrypt);
    eval 'sub PKCS12_get_attr {
        local($bag, $attr_nid) = @_;
	    eval q( &PKCS12_get_attr_gen( ($bag->{attrib}), $attr_nid));
    }' unless defined(&PKCS12_get_attr);
    eval 'sub PKCS8_get_attr {
        local($p8, $attr_nid) = @_;
	    eval q( &PKCS12_get_attr_gen( ($p8->{attributes}), $attr_nid));
    }' unless defined(&PKCS8_get_attr);
    eval 'sub PKCS12_mac_present {
        local($p12) = @_;
	    eval q((($p12)-> &mac ? 1: 0));
    }' unless defined(&PKCS12_mac_present);
    eval 'sub PKCS12_F_PARSE_BAGS () {103;}' unless defined(&PKCS12_F_PARSE_BAGS);
    eval 'sub PKCS12_F_PKCS12_ADD_FRIENDLYNAME () {100;}' unless defined(&PKCS12_F_PKCS12_ADD_FRIENDLYNAME);
    eval 'sub PKCS12_F_PKCS12_ADD_FRIENDLYNAME_ASC () {127;}' unless defined(&PKCS12_F_PKCS12_ADD_FRIENDLYNAME_ASC);
    eval 'sub PKCS12_F_PKCS12_ADD_FRIENDLYNAME_UNI () {102;}' unless defined(&PKCS12_F_PKCS12_ADD_FRIENDLYNAME_UNI);
    eval 'sub PKCS12_F_PKCS12_ADD_LOCALKEYID () {104;}' unless defined(&PKCS12_F_PKCS12_ADD_LOCALKEYID);
    eval 'sub PKCS12_F_PKCS12_CREATE () {105;}' unless defined(&PKCS12_F_PKCS12_CREATE);
    eval 'sub PKCS12_F_PKCS12_DECRYPT_D2I () {106;}' unless defined(&PKCS12_F_PKCS12_DECRYPT_D2I);
    eval 'sub PKCS12_F_PKCS12_GEN_MAC () {107;}' unless defined(&PKCS12_F_PKCS12_GEN_MAC);
    eval 'sub PKCS12_F_PKCS12_I2D_ENCRYPT () {108;}' unless defined(&PKCS12_F_PKCS12_I2D_ENCRYPT);
    eval 'sub PKCS12_F_PKCS12_INIT () {109;}' unless defined(&PKCS12_F_PKCS12_INIT);
    eval 'sub PKCS12_F_PKCS12_KEY_GEN_ASC () {110;}' unless defined(&PKCS12_F_PKCS12_KEY_GEN_ASC);
    eval 'sub PKCS12_F_PKCS12_KEY_GEN_UNI () {111;}' unless defined(&PKCS12_F_PKCS12_KEY_GEN_UNI);
    eval 'sub PKCS12_F_PKCS12_MAKE_KEYBAG () {112;}' unless defined(&PKCS12_F_PKCS12_MAKE_KEYBAG);
    eval 'sub PKCS12_F_PKCS12_MAKE_SHKEYBAG () {113;}' unless defined(&PKCS12_F_PKCS12_MAKE_SHKEYBAG);
    eval 'sub PKCS12_F_PKCS12_NEWPASS () {128;}' unless defined(&PKCS12_F_PKCS12_NEWPASS);
    eval 'sub PKCS12_F_PKCS12_PACK_P7DATA () {114;}' unless defined(&PKCS12_F_PKCS12_PACK_P7DATA);
    eval 'sub PKCS12_F_PKCS12_PACK_P7ENCDATA () {115;}' unless defined(&PKCS12_F_PKCS12_PACK_P7ENCDATA);
    eval 'sub PKCS12_F_PKCS12_PACK_SAFEBAG () {117;}' unless defined(&PKCS12_F_PKCS12_PACK_SAFEBAG);
    eval 'sub PKCS12_F_PKCS12_PARSE () {118;}' unless defined(&PKCS12_F_PKCS12_PARSE);
    eval 'sub PKCS12_F_PKCS12_PBE_CRYPT () {119;}' unless defined(&PKCS12_F_PKCS12_PBE_CRYPT);
    eval 'sub PKCS12_F_PKCS12_PBE_KEYIVGEN () {120;}' unless defined(&PKCS12_F_PKCS12_PBE_KEYIVGEN);
    eval 'sub PKCS12_F_PKCS12_SETUP_MAC () {122;}' unless defined(&PKCS12_F_PKCS12_SETUP_MAC);
    eval 'sub PKCS12_F_PKCS12_SET_MAC () {123;}' unless defined(&PKCS12_F_PKCS12_SET_MAC);
    eval 'sub PKCS12_F_PKCS8_ADD_KEYUSAGE () {124;}' unless defined(&PKCS12_F_PKCS8_ADD_KEYUSAGE);
    eval 'sub PKCS12_F_PKCS8_ENCRYPT () {125;}' unless defined(&PKCS12_F_PKCS8_ENCRYPT);
    eval 'sub PKCS12_F_VERIFY_MAC () {126;}' unless defined(&PKCS12_F_VERIFY_MAC);
    eval 'sub PKCS12_R_CANT_PACK_STRUCTURE () {100;}' unless defined(&PKCS12_R_CANT_PACK_STRUCTURE);
    eval 'sub PKCS12_R_DECODE_ERROR () {101;}' unless defined(&PKCS12_R_DECODE_ERROR);
    eval 'sub PKCS12_R_ENCODE_ERROR () {102;}' unless defined(&PKCS12_R_ENCODE_ERROR);
    eval 'sub PKCS12_R_ENCRYPT_ERROR () {103;}' unless defined(&PKCS12_R_ENCRYPT_ERROR);
    eval 'sub PKCS12_R_ERROR_SETTING_ENCRYPTED_DATA_TYPE () {120;}' unless defined(&PKCS12_R_ERROR_SETTING_ENCRYPTED_DATA_TYPE);
    eval 'sub PKCS12_R_INVALID_NULL_ARGUMENT () {104;}' unless defined(&PKCS12_R_INVALID_NULL_ARGUMENT);
    eval 'sub PKCS12_R_INVALID_NULL_PKCS12_POINTER () {105;}' unless defined(&PKCS12_R_INVALID_NULL_PKCS12_POINTER);
    eval 'sub PKCS12_R_IV_GEN_ERROR () {106;}' unless defined(&PKCS12_R_IV_GEN_ERROR);
    eval 'sub PKCS12_R_KEY_GEN_ERROR () {107;}' unless defined(&PKCS12_R_KEY_GEN_ERROR);
    eval 'sub PKCS12_R_MAC_ABSENT () {108;}' unless defined(&PKCS12_R_MAC_ABSENT);
    eval 'sub PKCS12_R_MAC_GENERATION_ERROR () {109;}' unless defined(&PKCS12_R_MAC_GENERATION_ERROR);
    eval 'sub PKCS12_R_MAC_SETUP_ERROR () {110;}' unless defined(&PKCS12_R_MAC_SETUP_ERROR);
    eval 'sub PKCS12_R_MAC_STRING_SET_ERROR () {111;}' unless defined(&PKCS12_R_MAC_STRING_SET_ERROR);
    eval 'sub PKCS12_R_MAC_VERIFY_ERROR () {112;}' unless defined(&PKCS12_R_MAC_VERIFY_ERROR);
    eval 'sub PKCS12_R_MAC_VERIFY_FAILURE () {113;}' unless defined(&PKCS12_R_MAC_VERIFY_FAILURE);
    eval 'sub PKCS12_R_PARSE_ERROR () {114;}' unless defined(&PKCS12_R_PARSE_ERROR);
    eval 'sub PKCS12_R_PKCS12_ALGOR_CIPHERINIT_ERROR () {115;}' unless defined(&PKCS12_R_PKCS12_ALGOR_CIPHERINIT_ERROR);
    eval 'sub PKCS12_R_PKCS12_CIPHERFINAL_ERROR () {116;}' unless defined(&PKCS12_R_PKCS12_CIPHERFINAL_ERROR);
    eval 'sub PKCS12_R_PKCS12_PBE_CRYPT_ERROR () {117;}' unless defined(&PKCS12_R_PKCS12_PBE_CRYPT_ERROR);
    eval 'sub PKCS12_R_UNKNOWN_DIGEST_ALGORITHM () {118;}' unless defined(&PKCS12_R_UNKNOWN_DIGEST_ALGORITHM);
    eval 'sub PKCS12_R_UNSUPPORTED_PKCS12_MODE () {119;}' unless defined(&PKCS12_R_UNSUPPORTED_PKCS12_MODE);
    if(defined(&__cplusplus)) {
    }
}
1;
