require '_h2ph_pre.ph';

unless(defined(&_PDQ_OS_H)) {
    eval 'sub _PDQ_OS_H () {1;}' unless defined(&_PDQ_OS_H);
    eval 'sub PDQ_OS_TX_TIMEOUT () {5;}' unless defined(&PDQ_OS_TX_TIMEOUT);
    eval("sub PDQ_DEFPA () { 0; }") unless defined(&PDQ_DEFPA);
    eval("sub PDQ_DEFEA () { 1; }") unless defined(&PDQ_DEFEA);
    eval("sub PDQ_DEFTA () { 2; }") unless defined(&PDQ_DEFTA);
    eval("sub PDQ_DEFAA () { 3; }") unless defined(&PDQ_DEFAA);
    eval("sub PDQ_DEFQA () { 4; }") unless defined(&PDQ_DEFQA);
    if(defined( &PDQTEST)) {
	require 'pdq_os_test.ph';
    }
 elsif(defined( &__FreeBSD__) || defined( &__bsdi__) || defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	require 'sys/param.ph';
	require 'sys/systm.ph';
	unless(defined(&M_MCAST)) {
	    require 'sys/mbuf.ph';
	}
	require 'sys/malloc.ph';
	require 'vm/vm.ph';
	require 'uvm/uvm_extern.ph';
	eval 'sub PDQ_USE_MBUFS () {1;}' unless defined(&PDQ_USE_MBUFS);
	if(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	    eval 'sub PDQ_OS_PREFIX () {"%s: ";}' unless defined(&PDQ_OS_PREFIX);
	    eval 'sub PDQ_OS_PREFIX_ARGS () { ($pdq->{pdq_os_name});}' unless defined(&PDQ_OS_PREFIX_ARGS);
	} else {
	    eval 'sub PDQ_OS_PREFIX () {"%s%d: ";}' unless defined(&PDQ_OS_PREFIX);
	    eval 'sub PDQ_OS_PREFIX_ARGS () { ($pdq->{pdq_os_name}),  ($pdq->{pdq_unit});}' unless defined(&PDQ_OS_PREFIX_ARGS);
	}
	eval 'sub PDQ_OS_PAGESIZE () { &NBPG;}' unless defined(&PDQ_OS_PAGESIZE);
	eval 'sub PDQ_OS_USEC_DELAY {
	    local($n) = @_;
    	    eval q( &DELAY($n));
	}' unless defined(&PDQ_OS_USEC_DELAY);
	eval 'sub PDQ_OS_MEMZERO {
	    local($p, $n) = @_;
    	    eval q( &bzero(($p), ($n)));
	}' unless defined(&PDQ_OS_MEMZERO);
	if((defined( &__NetBSD__) || defined( &__OpenBSD__))  && defined( &__alpha__)) {
	    eval 'sub PDQ_OS_VA_TO_PA {
	        local($pdq, $p) = @_;
    		eval q(( &alpha_XXX_dmamap($p)));
	    }' unless defined(&PDQ_OS_VA_TO_PA);
	} else {
	    eval 'sub PDQ_OS_VA_TO_PA {
	        local($pdq, $p) = @_;
    		eval q( &vtophys($p));
	    }' unless defined(&PDQ_OS_VA_TO_PA);
	}
	eval 'sub PDQ_OS_MEMALLOC {
	    local($n) = @_;
    	    eval q( &malloc($n,  &M_DEVBUF,  &M_NOWAIT));
	}' unless defined(&PDQ_OS_MEMALLOC);
	eval 'sub PDQ_OS_MEMFREE {
	    local($p, $n) = @_;
    	    eval q( &free( $p,  &M_DEVBUF));
	}' unless defined(&PDQ_OS_MEMFREE);
	if(defined(&__FreeBSD__)) {
	    eval 'sub PDQ_OS_MEMALLOC_CONTIG {
	        local($n) = @_;
    		eval q( &vm_page_alloc_contig($n, 0, 0xffffffff,  &PAGE_SIZE));
	    }' unless defined(&PDQ_OS_MEMALLOC_CONTIG);
	    eval 'sub PDQ_OS_MEMFREE_CONTIG {
	        local($p, $n) = @_;
    		eval q( &kmem_free( &kernel_map, $p, $n));
	    }' unless defined(&PDQ_OS_MEMFREE_CONTIG);
	} else {
	    eval 'sub PDQ_OS_MEMALLOC_CONTIG {
	        local($n) = @_;
    		eval q( &uvm_km_alloc( &kernel_map,  &round_page($n)));
	    }' unless defined(&PDQ_OS_MEMALLOC_CONTIG);
	    eval 'sub PDQ_OS_MEMFREE_CONTIG {
	        local($p, $n) = @_;
    		eval q( &uvm_km_free( &kernel_map, $p, $n));
	    }' unless defined(&PDQ_OS_MEMFREE_CONTIG);
	}
	if(defined( &__FreeBSD__)) {
	    require 'vm/pmap.ph';
	    require 'vm/vm_extern.ph';
	    require 'machine/cpufunc.ph';
	    require 'machine/clock.ph';
	    eval("sub PDQ_BUS_EISA () { 0; }") unless defined(&PDQ_BUS_EISA);
	    eval("sub PDQ_BUS_PCI () { 1; }") unless defined(&PDQ_BUS_PCI);
	    if((defined(&BSD) ? &BSD : 0) >= 199506) {
		eval 'sub PDQ_BPF_MTAP {
		    local($sc, $m) = @_;
    		    eval q( &bpf_mtap(($sc)-> &sc_if, $m));
		}' unless defined(&PDQ_BPF_MTAP);
		eval 'sub PDQ_BPFATTACH {
		    local($sc, $t, $s) = @_;
    		    eval q( &bpfattach(($sc)-> &sc_if, $t, $s));
		}' unless defined(&PDQ_BPFATTACH);
	    }
	}
 elsif(defined( &__bsdi__)) {
	    require 'machine/inline.ph';
	    eval("sub PDQ_BUS_EISA () { 0; }") unless defined(&PDQ_BUS_EISA);
	    eval("sub PDQ_BUS_PCI () { 1; }") unless defined(&PDQ_BUS_PCI);
	}
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
	    require 'machine/bus.ph';
	    require 'machine/intr.ph';
	    eval 'sub PDQ_OS_PTR_FMT () {"%p";}' unless defined(&PDQ_OS_PTR_FMT);
	    eval 'sub PDQ_OS_IOMEM () {1;}' unless defined(&PDQ_OS_IOMEM);
	    eval 'sub PDQ_OS_IORD_32 {
	        local($t, $base, $offset) = @_;
    		eval q( &bus_space_read_4 ($t, $base, $offset));
	    }' unless defined(&PDQ_OS_IORD_32);
	    eval 'sub PDQ_OS_IOWR_32 {
	        local($t, $base, $offset, $data) = @_;
    		eval q( &bus_space_write_4 ($t, $base, $offset, $data));
	    }' unless defined(&PDQ_OS_IOWR_32);
	    eval 'sub PDQ_OS_IORD_8 {
	        local($t, $base, $offset) = @_;
    		eval q( &bus_space_read_1 ($t, $base, $offset));
	    }' unless defined(&PDQ_OS_IORD_8);
	    eval 'sub PDQ_OS_IOWR_8 {
	        local($t, $base, $offset, $data) = @_;
    		eval q( &bus_space_write_1 ($t, $base, $offset, $data));
	    }' unless defined(&PDQ_OS_IOWR_8);
	    eval 'sub PDQ_OS_MEMRD_32 {
	        local($t, $base, $offset) = @_;
    		eval q( &bus_space_read_4($t, $base, $offset));
	    }' unless defined(&PDQ_OS_MEMRD_32);
	    eval 'sub PDQ_OS_MEMWR_32 {
	        local($t, $base, $offset, $data) = @_;
    		eval q( &bus_space_write_4($t, $base, $offset, $data));
	    }' unless defined(&PDQ_OS_MEMWR_32);
	    eval 'sub PDQ_CSR_OFFSET {
	        local($base, $offset) = @_;
    		eval q((0+ ($offset)*$sizeof{ &pdq_uint32_t}));
	    }' unless defined(&PDQ_CSR_OFFSET);
	    if(defined( &PDQ_IOMAPPED)) {
		eval 'sub PDQ_CSR_WRITE {
		    local($csr, $name, $data) = @_;
    		    eval q( &PDQ_OS_IOWR_32(($csr)-> &csr_bus, ($csr)-> &csr_base, ($csr)->$name, $data));
		}' unless defined(&PDQ_CSR_WRITE);
		eval 'sub PDQ_CSR_READ {
		    local($csr, $name) = @_;
    		    eval q( &PDQ_OS_IORD_32(($csr)-> &csr_bus, ($csr)-> &csr_base, ($csr)->$name));
		}' unless defined(&PDQ_CSR_READ);
	    } else {
		eval 'sub PDQ_CSR_WRITE {
		    local($csr, $name, $data) = @_;
    		    eval q( &PDQ_OS_MEMWR_32(($csr)-> &csr_bus, ($csr)-> &csr_base, ($csr)->$name, $data));
		}' unless defined(&PDQ_CSR_WRITE);
		eval 'sub PDQ_CSR_READ {
		    local($csr, $name) = @_;
    		    eval q( &PDQ_OS_MEMRD_32(($csr)-> &csr_bus, ($csr)-> &csr_base, ($csr)->$name));
		}' unless defined(&PDQ_CSR_READ);
	    }
	}
	if(!defined( &PDQ_BPF_MTAP)) {
	    eval 'sub PDQ_BPF_MTAP {
	        local($sc, $m) = @_;
    		eval q( &bpf_mtap(($sc)-> &sc_bpf, $m));
	    }' unless defined(&PDQ_BPF_MTAP);
	}
	if(!defined( &PDQ_BPFATTACH)) {
	    eval 'sub PDQ_BPFATTACH {
	        local($sc, $t, $s) = @_;
    		eval q( &bpfattach(($sc)-> &sc_bpf, ($sc)-> &sc_if, $t, $s));
	    }' unless defined(&PDQ_BPFATTACH);
	}
	if(!defined( &PDQ_OS_PTR_FMT)) {
	    eval 'sub PDQ_OS_PTR_FMT () {"0x%x";}' unless defined(&PDQ_OS_PTR_FMT);
	}
	if(!defined( &PDQ_OS_IOMEM)) {
	    eval 'sub PDQ_OS_IORD_32 {
	        local($t, $base, $offset) = @_;
    		eval q( &inl(($base) + ($offset)));
	    }' unless defined(&PDQ_OS_IORD_32);
	    eval 'sub PDQ_OS_IOWR_32 {
	        local($t, $base, $offset, $data) = @_;
    		eval q( &outl(($base) + ($offset), $data));
	    }' unless defined(&PDQ_OS_IOWR_32);
	    eval 'sub PDQ_OS_IORD_8 {
	        local($t, $base, $offset) = @_;
    		eval q( &inb(($base) + ($offset)));
	    }' unless defined(&PDQ_OS_IORD_8);
	    eval 'sub PDQ_OS_IOWR_8 {
	        local($t, $base, $offset, $data) = @_;
    		eval q( &outb(($base) + ($offset), $data));
	    }' unless defined(&PDQ_OS_IOWR_8);
	    eval 'sub PDQ_OS_MEMRD_32 {
	        local($t, $base, $offset) = @_;
    		eval q((0+ *(($base) + ($offset))));
	    }' unless defined(&PDQ_OS_MEMRD_32);
	    eval 'sub PDQ_OS_MEMWR_32 {
	        local($t, $base, $offset, $data) = @_;
    		eval q( &do *(($base) + ($offset)) = ($data);  &while (0));
	    }' unless defined(&PDQ_OS_MEMWR_32);
	}
	unless(defined(&PDQ_CSR_OFFSET)) {
	    eval 'sub PDQ_CSR_OFFSET {
	        local($base, $offset) = @_;
    		eval q((0+ ($base) + ($offset)));
	    }' unless defined(&PDQ_CSR_OFFSET);
	}
	unless(defined(&PDQ_CSR_WRITE)) {
	    eval 'sub PDQ_CSR_WRITE {
	        local($csr, $name, $data) = @_;
    		eval q( &PDQ_OS_MEMWR_32(($csr)-> &csr_bus, ($csr)->$name, 0, $data));
	    }' unless defined(&PDQ_CSR_WRITE);
	    eval 'sub PDQ_CSR_READ {
	        local($csr, $name) = @_;
    		eval q( &PDQ_OS_MEMRD_32(($csr)-> &csr_bus, ($csr)->$name, 0));
	    }' unless defined(&PDQ_CSR_READ);
	}
	if(!defined( &PDQ_HWSUPPORT)) {
	    if(defined( &__bsdi__)) {
	    }
 elsif(defined( &__NetBSD__) || defined( &__OpenBSD__)) {
		eval 'sub sc_bc () { &sc_csrtag;}' unless defined(&sc_bc);
		eval 'sub sc_membase () { &sc_csrhandle;}' unless defined(&sc_membase);
	    }
 elsif(defined( &__FreeBSD__)) {
	    }
	    eval 'sub sc_if () { ($sc_ac->{ac_if});}' unless defined(&sc_if);
	    if(!defined( &__NetBSD__)  && !defined( &__OpenBSD__)) {
		if(defined(&PDQ_IOMAPPED)) {
		    eval 'sub sc_membase () { &sc_iobase;}' unless defined(&sc_membase);
		} else {
		}
	    }
	    if(!defined( &__bsdi__) || (defined(&_BSDI_VERSION) ? &_BSDI_VERSION : 0) >= 199401) {
		eval 'sub sc_bpf () { ($sc_if->{if_bpf});}' unless defined(&sc_bpf);
	    } else {
	    }
	}
    }
 elsif(defined( &DLPI_PDQ)) {
	require 'sys/param.ph';
	require 'sys/kmem.ph';
	require 'sys/ddi.ph';
	require 'sys/stream.ph';
	eval 'sub PDQ_USE_STREAMS () {1;}' unless defined(&PDQ_USE_STREAMS);
	eval 'sub PDQ_OS_PREFIX () {"%s board %d ";}' unless defined(&PDQ_OS_PREFIX);
	eval 'sub PDQ_OS_PREFIX_ARGS () { ($pdq->{pdq_os_name}),  ($pdq->{pdq_unit});}' unless defined(&PDQ_OS_PREFIX_ARGS);
	eval 'sub PDQ_OS_PAGESIZE () { &PAGESIZE;}' unless defined(&PDQ_OS_PAGESIZE);
	eval 'sub PDQ_OS_USEC_DELAY {
	    local($n) = @_;
    	    eval q( &drv_usecwait($n));
	}' unless defined(&PDQ_OS_USEC_DELAY);
	eval 'sub PDQ_OS_MEMZERO {
	    local($p, $n) = @_;
    	    eval q( &bzero(($p), ($n)));
	}' unless defined(&PDQ_OS_MEMZERO);
	eval 'sub PDQ_OS_VA_TO_PA {
	    local($pdq, $p) = @_;
    	    eval q( &vtop($p,  &NULL));
	}' unless defined(&PDQ_OS_VA_TO_PA);
	eval 'sub PDQ_OS_MEMALLOC {
	    local($n) = @_;
    	    eval q( &kmem_zalloc($n,  &KM_NOSLEEP));
	}' unless defined(&PDQ_OS_MEMALLOC);
	eval 'sub PDQ_OS_MEMFREE {
	    local($p, $n) = @_;
    	    eval q( &kmem_free( $p, $n));
	}' unless defined(&PDQ_OS_MEMFREE);
	eval 'sub PDQ_OS_MEMALLOC_CONTIG {
	    local($n) = @_;
    	    eval q( &kmem_zalloc_physreq($n,  &decfddiphysreq_db,  &KM_NOSLEEP));
	}' unless defined(&PDQ_OS_MEMALLOC_CONTIG);
	eval 'sub PDQ_OS_MEMFREE_CONTIG {
	    local($p, $n) = @_;
    	    eval q( &PDQ_OS_MEMFREE($p, $n));
	}' unless defined(&PDQ_OS_MEMFREE_CONTIG);
	eval 'sub PDQ_OS_DATABUF_ALLOC {
	    local($b) = @_;
    	    eval q(( ((($b) =  &allocb_physreq( &PDQ_OS_DATABUF_SIZE,  &BPRI_MED,  &decfddiphysreq_mblk))  && (($b)-> &b_wptr = ($b)-> &b_rptr +  &PDQ_OS_DATABUF_SIZE))));
	}' unless defined(&PDQ_OS_DATABUF_ALLOC);
	eval 'sub PDQ_OS_IORD_8 {
	    local($port) = @_;
    	    eval q( &inb($port));
	}' unless defined(&PDQ_OS_IORD_8);
	eval 'sub PDQ_OS_IOWR_8 {
	    local($port, $data) = @_;
    	    eval q( &outb($port, $data));
	}' unless defined(&PDQ_OS_IOWR_8);
    }
    if(defined(&PDQ_USE_MBUFS)) {
	eval 'sub PDQ_OS_DATABUF_SIZE () {( &MCLBYTES);}' unless defined(&PDQ_OS_DATABUF_SIZE);
	eval 'sub PDQ_OS_DATABUF_FREE {
	    local($b) = @_;
    	    eval q(( &m_freem($b)));
	}' unless defined(&PDQ_OS_DATABUF_FREE);
	eval 'sub PDQ_OS_DATABUF_NEXT {
	    local($b) = @_;
    	    eval q((($b)-> &m_next));
	}' unless defined(&PDQ_OS_DATABUF_NEXT);
	eval 'sub PDQ_OS_DATABUF_NEXT_SET {
	    local($b, $b1) = @_;
    	    eval q((($b)-> &m_next = ($b1)));
	}' unless defined(&PDQ_OS_DATABUF_NEXT_SET);
	eval 'sub PDQ_OS_DATABUF_NEXTPKT {
	    local($b) = @_;
    	    eval q((($b)-> &m_nextpkt));
	}' unless defined(&PDQ_OS_DATABUF_NEXTPKT);
	eval 'sub PDQ_OS_DATABUF_NEXTPKT_SET {
	    local($b, $b1) = @_;
    	    eval q((($b)-> &m_nextpkt = ($b1)));
	}' unless defined(&PDQ_OS_DATABUF_NEXTPKT_SET);
	eval 'sub PDQ_OS_DATABUF_LEN {
	    local($b) = @_;
    	    eval q((($b)-> &m_len));
	}' unless defined(&PDQ_OS_DATABUF_LEN);
	eval 'sub PDQ_OS_DATABUF_LEN_SET {
	    local($b, $n) = @_;
    	    eval q((($b)-> &m_len = ($n)));
	}' unless defined(&PDQ_OS_DATABUF_LEN_SET);
	eval 'sub PDQ_OS_DATABUF_PTR {
	    local($b) = @_;
    	    eval q(( &mtod(($b),  &pdq_uint8_t *)));
	}' unless defined(&PDQ_OS_DATABUF_PTR);
	eval 'sub PDQ_OS_DATABUF_ADJ {
	    local($b, $n) = @_;
    	    eval q((($b)-> &m_data += ($n), ($b)-> &m_len -= ($n)));
	}' unless defined(&PDQ_OS_DATABUF_ADJ);
	eval 'sub PDQ_OS_DATABUF_ALLOC {
	    local($b) = @_;
    	    eval q( &do {  &PDQ_OS_DATABUF_T * &x_m0;  &MGETHDR( &x_m0,  &M_DONTWAIT,  &MT_DATA);  &if ( &x_m0 !=  &NULL) {  &MCLGET( &x_m0,  &M_DONTWAIT);  &if (( ($x_m0->{m_flags}) &  &M_EXT) == 0) {  &m_free( &x_m0); ($b) =  &NULL; }  &else { ($b) =  &x_m0;  ($x_m0->{m_len}) =  &PDQ_OS_DATABUF_SIZE; } }  &else { ($b) =  &NULL; } }  &while (0));
	}' unless defined(&PDQ_OS_DATABUF_ALLOC);
	eval 'sub PDQ_OS_DATABUF_RESET {
	    local($b) = @_;
    	    eval q((($b)-> &m_data = ($b)-> ($m_ext->{ext_buf}), ($b)-> &m_len =  &MCLBYTES));
	}' unless defined(&PDQ_OS_DATABUF_RESET);
    }
    if(defined(&PDQ_USE_STREAMS)) {
	eval 'sub PDQ_OS_DATABUF_SIZE () {(2048);}' unless defined(&PDQ_OS_DATABUF_SIZE);
	eval 'sub PDQ_OS_DATABUF_FREE {
	    local($b) = @_;
    	    eval q(( &freemsg($b)));
	}' unless defined(&PDQ_OS_DATABUF_FREE);
	eval 'sub PDQ_OS_DATABUF_NEXT {
	    local($b) = @_;
    	    eval q((($b)-> &b_cont));
	}' unless defined(&PDQ_OS_DATABUF_NEXT);
	eval 'sub PDQ_OS_DATABUF_NEXT_SET {
	    local($b, $b1) = @_;
    	    eval q((($b)-> &b_cont = ($b1)));
	}' unless defined(&PDQ_OS_DATABUF_NEXT_SET);
	eval 'sub PDQ_OS_DATABUF_NEXTPKT {
	    local($b) = @_;
    	    eval q((($b)-> &b_next));
	}' unless defined(&PDQ_OS_DATABUF_NEXTPKT);
	eval 'sub PDQ_OS_DATABUF_NEXTPKT_SET {
	    local($b, $b1) = @_;
    	    eval q((($b)-> &b_next = ($b1)));
	}' unless defined(&PDQ_OS_DATABUF_NEXTPKT_SET);
	eval 'sub PDQ_OS_DATABUF_LEN {
	    local($b) = @_;
    	    eval q((($b)-> &b_wptr - ($b)-> &b_rptr));
	}' unless defined(&PDQ_OS_DATABUF_LEN);
	eval 'sub PDQ_OS_DATABUF_LEN_SET {
	    local($b, $n) = @_;
    	    eval q((($b)-> &b_wptr = ($b)-> &b_rptr + ($n)));
	}' unless defined(&PDQ_OS_DATABUF_LEN_SET);
	eval 'sub PDQ_OS_DATABUF_PTR {
	    local($b) = @_;
    	    eval q(( ($b)-> &b_rptr));
	}' unless defined(&PDQ_OS_DATABUF_PTR);
	eval 'sub PDQ_OS_DATABUF_ADJ {
	    local($b, $n) = @_;
    	    eval q((($b)-> &b_rptr += ($n)));
	}' unless defined(&PDQ_OS_DATABUF_ADJ);
	unless(defined(&PDQ_OS_DATABUF_ALLOC)) {
	    eval 'sub PDQ_OS_DATABUF_ALLOC {
	        local($b) = @_;
    		eval q(( ((($b) =  &allocb( &PDQ_OS_DATABUF_SIZE,  &BPRI_MED))  && (($b)-> &b_wptr = ($b)-> &b_rptr +  &PDQ_OS_DATABUF_SIZE))));
	    }' unless defined(&PDQ_OS_DATABUF_ALLOC);
	}
    }
    eval 'sub PDQ_OS_TX_TRANSMIT () {5;}' unless defined(&PDQ_OS_TX_TRANSMIT);
    eval 'sub PDQ_OS_DATABUF_ENQUEUE {
        local($q, $b) = @_;
	    eval q( &do {  &PDQ_OS_DATABUF_NEXTPKT_SET($b,  &NULL);  &if (-> &q_tail ==  &NULL) -> &q_head = ;  &else  &PDQ_OS_DATABUF_NEXTPKT_SET((($q)-> &q_tail), $b); ($q)-> &q_tail = ($b); }  &while (0));
    }' unless defined(&PDQ_OS_DATABUF_ENQUEUE);
    eval 'sub PDQ_OS_DATABUF_DEQUEUE {
        local($q, $b) = @_;
	    eval q( &do {  &if (( = ($q)-> &q_head) !=  &NULL) {  &if ((($q)-> &q_head =  &PDQ_OS_DATABUF_NEXTPKT($b)) ==  &NULL) ($q)-> &q_tail =  &NULL;  &PDQ_OS_DATABUF_NEXTPKT_SET($b,  &NULL); } }  &while (0));
    }' unless defined(&PDQ_OS_DATABUF_DEQUEUE);
}
1;
