require '_h2ph_pre.ph';

unless(defined(&_ALTQ_ALTQ_WFQ_H_)) {
    eval 'sub _ALTQ_ALTQ_WFQ_H_ () {1;}' unless defined(&_ALTQ_ALTQ_WFQ_H_);
    require 'altq/altq.ph';
    eval 'sub DEFAULT_QSIZE () {256;}' unless defined(&DEFAULT_QSIZE);
    eval 'sub MAX_QSIZE () {2048;}' unless defined(&MAX_QSIZE);
    eval 'sub WFQ_HASH_DSTADDR () {0;}' unless defined(&WFQ_HASH_DSTADDR);
    eval 'sub WFQ_HASH_SRCPORT () {1;}' unless defined(&WFQ_HASH_SRCPORT);
    eval 'sub WFQ_HASH_FULL () {2;}' unless defined(&WFQ_HASH_FULL);
    eval 'sub WFQ_IF_ATTACH () { &_IOW(ord(\'Q\'), 1, \'struct wfq_interface\');}' unless defined(&WFQ_IF_ATTACH);
    eval 'sub WFQ_IF_DETACH () { &_IOW(ord(\'Q\'), 2, \'struct wfq_interface\');}' unless defined(&WFQ_IF_DETACH);
    eval 'sub WFQ_ENABLE () { &_IOW(ord(\'Q\'), 3, \'struct wfq_interface\');}' unless defined(&WFQ_ENABLE);
    eval 'sub WFQ_DISABLE () { &_IOW(ord(\'Q\'), 4, \'struct wfq_interface\');}' unless defined(&WFQ_DISABLE);
    eval 'sub WFQ_CONFIG () { &_IOWR(ord(\'Q\'), 6, \'struct wfq_conf\');}' unless defined(&WFQ_CONFIG);
    eval 'sub WFQ_GET_STATS () { &_IOWR(ord(\'Q\'), 12, \'struct wfq_getstats\');}' unless defined(&WFQ_GET_STATS);
    eval 'sub WFQ_GET_QID () { &_IOWR(ord(\'Q\'), 30, \'struct wfq_getqid\');}' unless defined(&WFQ_GET_QID);
    eval 'sub WFQ_SET_WEIGHT () { &_IOWR(ord(\'Q\'), 31, \'struct wfq_setweight\');}' unless defined(&WFQ_SET_WEIGHT);
    if(defined(&_KERNEL)) {
	eval 'sub HWM () {(64* 1024);}' unless defined(&HWM);
	eval 'sub WFQ_QUOTA () {512;}' unless defined(&WFQ_QUOTA);
	eval 'sub WFQ_ADDQUOTA {
	    local($q) = @_;
    	    eval q((($q)-> &quota +=  &WFQ_QUOTA * ($q)-> &weight / 100));
	}' unless defined(&WFQ_ADDQUOTA);
	eval 'sub ENABLE () {0;}' unless defined(&ENABLE);
	eval 'sub DISABLE () {1;}' unless defined(&DISABLE);
    }
}
1;
