# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 1839 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/hash_of_lists.al)"
# ----------------------------------------------------------------------


sub hash_of_lists {
  my ($class, @args) = @_;
  my $static = 0;

  foreach (@args) {
    if ( substr ($_, 0, 1) eq '-' ) {
      my $option = substr $_, 1;
      if ( $option eq 'static' ) {
	$static = 1;
      } else {
	croak "Unrecognized option to hash_of_lists: $option\n";
      }
    } else {
      my %methods;
      my $field = $_;

      $methods{$field} =
	q{sub {
	  my $self = shift;
	  my @list = @_;
	  my @Result;

	  if ( @list ) {
	    if ( @list == 1 and ref ($list[0]) eq 'ARRAY' ) {
	      @Result = map @$_, @{__STORAGE__}{@{$list[0]}};
	    } else {
	      my @keys =
		map ref ($_) eq 'ARRAY' ? @$_: $_,
		  grep exists __STORAGE__->{$_}, @list;
	      @Result = map @$_, @{__STORAGE__}{@keys};
	    }
	  } else {
	    @Result = map @$_, values %{__STORAGE__};
	  }

	  return wantarray ? @Result : \@Result;
	}};

      $methods{$field . "_keys"} =
	q{sub {
	  my ($self) = shift;
	  my @Result = keys %{__STORAGE__};
	  return wantarray ? @Result : \@Result;
	}};

      $methods{$field . "_exists"} =
	q{sub {
	  my ($self) = shift;
	  my (@keys) = @_;
	  my $found = 1;
	  for (@keys) {
	    $found &&= exists __STORAGE__->{$_};
	  }
	  return $found;
	}};

      $methods{$field . "_delete"} =
	q{sub {
	  my ($self, @keys) = @_;
	  delete @{__STORAGE__}{@keys};
	}};

      $methods{$field . "_push"} =
	q{sub {
	  my ($self, $key, @values) = @_;
	  my @keys = ref ($key) eq 'ARRAY' ? @$key : $key;
	  for (@keys) {
	    push @{__STORAGE__->{$_}}, @values;
	  }
	}};

      $methods{$field . "_unshift"} =
	q{sub {
	  my ($self, $key, @values) = @_;
	  my @keys = ref ($key) eq 'ARRAY' ? @$key : $key;
	  for (@keys) {
	    unshift @{__STORAGE__->{$_}}, @values;
	  }
	}};

      $methods{$field . "_pop"} =
	q{sub {
	  my ($self, @keys) = @_;
	  my @old;
	  for (@keys) {
	    push @old, pop @{__STORAGE__->{$_}};
	  }
	  return @old;
	}};

      $methods{$field . "_last"} =
	q{sub {
	  my ($self, @keys) = @_;
	  my @old;
	  for (@keys) {
	    push @old, __STORAGE__->{$_}->[-1];
	  }
	  return @old;
	}};

      $methods{$field . "_shift"} =
	q{sub {
	  my ($self, @keys) = @_;
	  my @old;
	  for (@keys) {
	    push @old, shift @{__STORAGE__->{$_}};
	  }
	  return @old;
	}};

      $methods{$field . "_splice"} =
	q{sub {
	  my ($self, $key, $offset, $length, @values) = @_;
	  splice @{__STORAGE__->{$key}}, $offset, $length, @values;
	}};

      my $method_name = "${field}_set";
      $methods{$method_name} =
	q{sub{
	    my $self = shift;
	    croak "__METHOD_NAME__ expects a key and then index => " .
	      "value pairs.\n"
		unless @_ % 2;
	    my ($key, @args) = @_;
	    while ( my ($index, $value) = splice @args, 0, 2 ) {
	      __STORAGE__->{$key}->[$index] = $value;
	    }
	    return;
	  }};
      $methods{$method_name} =~ s!__METHOD_NAME__!$method_name!gs;

      $methods{$field . "_clear"} =
	q{sub {
	  my ($self, @keys) = @_;
	  for (@keys) {
	    __STORAGE__->{$_} = [];
	  }
	}};

      $methods{$field . "_count"} =
	q{sub {
	  my ($self, @keys) = @_;
	  my $Result = 0;
	  # Avoid autovivifying additional entries.
	  for (@keys) {
	    $Result +=
	      exists __STORAGE__->{$_} ?
		scalar @{__STORAGE__->{$_}} : 0;
	  }
	  return $Result;
	}};

      $methods{"${field}_index"} =
	q{sub {
	  my ($self, $key_r, @indices) = @_;
	  my (@Result, $index, $key);
	  my @keys = ref ($key_r) eq 'ARRAY' ? @$key_r : $key_r;
	  foreach $key (@keys) {
	    my $ary = __STORAGE__->{$key};
	    foreach $index (@indices) {
	      push @Result,
		( @{$ary} > $index ) ? $ary->[$index] : undef;
	    }
	  }
	  return wantarray ? @Result : \@Result;
	}};

      $methods{"${field}_remove"} =
	q{sub {
	  my ($self, $key_r, @indices) = @_;
	  my ($index, $key);
	  my @keys = ref ($key_r) eq 'ARRAY' ? @$key_r : $key_r;
	  foreach $key (@keys) {
	    my $ary = __STORAGE__->{$key};
	    foreach $index (sort {$b<=>$a} grep $_ < @$ary, @indices) {
	      splice (@$ary, $index, 1);
	    }
	  }
	  return;
	}};

      $methods{"${field}_sift"} =
	q{sub {
	  my $self = shift;
	  my %args;
	  if ( @_ == 1 and ref $_[0] eq 'HASH' ) {
	    %args = %{$_[0]};
	  } else {
	    %args = @_;
	  }
	  my $filter_sr = $args{'filter'}  || sub { $_[0] == $_[1] };
	  my $keys_ar   = $args{'keys'}    || [ keys %{__STORAGE__} ];
	  my $values_ar = $args{'values'}  || [undef];
  # This is harder than it looks; reverse means we want to grep out only
  # if *none* of the values matches.  I guess an evaled block, or closure
  # or somesuch is called for.
  #       my $reverse   = $args{'reverse'} || 0;

	  my ($key, $i, $value);
	KEY:
	  foreach $key (@$keys_ar) {
	    next KEY
	      unless exists __STORAGE__->{$key};
	  INDEX:
	    for ($i = $#{__STORAGE__->{$key}}; $i >= 0; $i--) {
	      foreach $value (@$values_ar) {
		if ( $filter_sr->($value, __STORAGE__->{$key}[$i]) ) {
		  splice @{__STORAGE__->{$key}}, $i, 1;
		  next INDEX;
		}
	      }
	    }
	  }
	}};

      my $replace = $static ? '$store' : "\$self->{$field}";
      foreach (@methods{keys %methods}) {
	s!__STORAGE__!$replace!gm
	  unless ref $_;
	;
      }

      if ( $static ) {
	my $store;
	for (@methods{keys %methods}) {
	  $code = eval $_;
	  croak "Compilation of \n$_\n failed: $@\n"
	    if $@;
	  croak "Compilation of \n$_\n did not return a coderef: $code\n"
	    unless ref $code eq 'CODE';
	  $_ = $code;
	}
      }

      $class->install_methods (%methods);
    }
  }
}

# end of Class::MethodMaker::hash_of_lists
1;
