.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "SET TRANSACTION" "" "2000-11-24" "SQL - Language Statements" "SQL Commands"
.SH NAME
SET TRANSACTION \- Set the characteristics of the current SQL-transaction
.SH SYNOPSIS
.sp
.nf
SET TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }
SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }
  
.sp
.fi
.SH "DESCRIPTION"
.PP
This command sets the transaction isolation level. The
\fBSET TRANSACTION\fR command sets the characteristics
for the current SQL-transaction. It has no effect on any subsequent
transactions. This command cannot be used after the first DML
statement (\fBSELECT\fR, \fBINSERT\fR,
\fBDELETE\fR, \fBUPDATE\fR,
\fBFETCH\fR, \fBCOPY\fR) of a transaction
has been executed. \fBSET SESSION CHARACTERISTICS\fR
sets the default transaction isolation level for each transaction
for a session. \fBSET TRANSACTION\fR can override it
for an individual transaction.
.PP
The isolation level of a transaction determines what data the
transaction can see when other transactions are running concurrently.
.TP
\fBREAD COMMITTED\fR
A statement can only see rows committed before it began. This
is the default.
.TP
\fBSERIALIZABLE\fR
The current transaction can only see rows committed before
first DML statement was executed in this transaction.
.sp
.RS
.B "Tip:"
Intuitively, serializable means that two concurrent
transactions will leave the database in the same state as if
the two has been executed strictly after one another in either
order.
.RE
.sp
.PP
.SH "COMPATIBILITY"
.SS "SQL92, SQL99"
.PP
SERIALIZABLE is the default level in SQL.
Postgres does not provide the isolation levels \fBREAD
UNCOMMITTED\fR and \fBREPEATABLE READ\fR. Because
of multi-version concurrency control, the serializable level is not
truly serializable. See the \fIUser's Guide\fR for
details.
.PP
In SQL there are two other transaction
characteristics that can be set with these commands: whether the
transaction is read-only and the size of the diagnostics area.
Neither of these concepts are supported in Postgres.
