.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "ALTER TABLE" "" "29 March 2001" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER TABLE \- Modifies table properties
.SH SYNOPSIS
.sp
.nf
ALTER TABLE [ ONLY ] \fItable\fR [ * ]
    ADD [ COLUMN ] \fIcolumn\fR \fItype\fR
ALTER TABLE [ ONLY ] \fItable\fR [ * ]
    ALTER [ COLUMN ] \fIcolumn\fR { SET DEFAULT \fIvalue\fR | DROP DEFAULT }
ALTER TABLE \fItable\fR [ * ]
    RENAME [ COLUMN ] \fIcolumn\fR TO \fInewcolumn\fR
ALTER TABLE \fItable\fR
    RENAME TO \fInewtable\fR
ALTER TABLE \fItable\fR
    ADD \fItable constraint definition\fR
ALTER TABLE \fItable\fR
	OWNER TO \fInew owner\fR 
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fItable \fB\fR
The name of an existing table to alter.
.TP
\fB\fIcolumn \fB\fR
Name of a new or existing column.
.TP
\fB\fItype \fB\fR
Type of the new column.
.TP
\fB\fInewcolumn \fB\fR
New name for an existing column.
.TP
\fB\fInewtable \fB\fR
New name for the table.
.TP
\fB\fItable constraint definition \fB\fR
New table constraint for the table
.TP
\fB\fINew user \fB\fR
The user name of the new owner of the table.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBALTER\fR
Message returned from column or table renaming.
.TP
\fBERROR\fR
Message returned if table or column is not available.
.PP
.SH "DESCRIPTION"
.PP
\fBALTER TABLE\fR changes the definition of an existing table.
The ADD COLUMN form adds a new column to the table
using the same syntax as CREATE TABLE [\fBcreate_table\fR(l)]. The ALTER COLUMN form
allows you to set or remove the default for the column. Note that defaults
only apply to newly inserted rows.
The RENAME clause causes the name of a table or column
to change without changing any of the data contained in
the affected table. Thus, the table or column will
remain of the same type and size after this command is
executed.
The ADD \fItable constraint definition\fR clause 
adds a new constraint to the table using the same syntax as CREATE TABLE [\fBcreate_table\fR(l)]. 
The OWNER clause chnages the owner of the table to the user \fI new user\fR.
.PP
You must own the table in order to change its schema.
.SS "NOTES"
.PP
The keyword COLUMN is noise and can be omitted.
.PP
In the current implementation, default and constraint clauses for the
new column will be ignored. You can use the SET DEFAULT
form of \fBALTER TABLE\fR to set the default later.
(You will also have to update the already existing rows to the
new default value, using UPDATE [\fBupdate\fR(l)].)
.PP
In the current implementation, only FOREIGN KEY constraints can
be added to a table. To create or remove a unique constraint, create 
a unique index (see CREATE INDEX [\fBcreate_index\fR(l)]). To add check constraints
you need to recreate and reload the table, using other 
parameters to the CREATE TABLE [\fBcreate_table\fR(l)] command.
.PP
You must own the table in order to change it.
Renaming any part of the schema of a system
catalog is not permitted.
The \fIPostgreSQL User's Guide\fR has further
information on inheritance.
.PP
Refer to \fBCREATE TABLE\fR for a further description
of valid arguments.
.SH "USAGE"
.PP
To add a column of type VARCHAR to a table:
.sp
.nf
ALTER TABLE distributors ADD COLUMN address VARCHAR(30);
   
.sp
.fi
.PP
To rename an existing column:
.sp
.nf
ALTER TABLE distributors RENAME COLUMN address TO city;
   
.sp
.fi
.PP
To rename an existing table:
.sp
.nf
ALTER TABLE distributors RENAME TO suppliers;
   
.sp
.fi
.PP
To add a foreign key constraint to a table:
.sp
.nf
ALTER TABLE distributors ADD CONSTRAINT distfk FOREIGN KEY (address) REFERENCES addresses(address) MATCH FULL
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
The ADD COLUMN form is compliant with the exception that
it does not support defaults and constraints, as explained above.
The ALTER COLUMN form is in full compliance.
.PP
SQL92 specifies some additional capabilities for \fBALTER TABLE\fR
statement which are not yet directly supported by Postgres:
.TP
\fB.sp\fR
Removes a table constraint (such as a check constraint,
unique constraint, or foreign key constraint). To 
remove a unique constraint, drop a unique index.
To remove other kinds of constraints you need to recreate
and reload the table, using other parameters to the
CREATE TABLE [\fBcreate_table\fR(l)]
command.

For example, to drop any constraints on a table distributors:
.sp
.nf
CREATE TABLE temp AS SELECT * FROM distributors;
DROP TABLE distributors;
CREATE TABLE distributors AS SELECT * FROM temp;
DROP TABLE temp;
       
.sp
.fi
.TP
\fB.sp\fR
Removes a column from a table.
Currently, to remove an existing column the table must be
recreated and reloaded:
.sp
.nf
CREATE TABLE temp AS SELECT did, city FROM distributors;    
DROP TABLE distributors;
CREATE TABLE distributors (
    did      DECIMAL(3)  DEFAULT 1,
    name     VARCHAR(40) NOT NULL
);
INSERT INTO distributors SELECT * FROM temp;
DROP TABLE temp;
       
.sp
.fi
.PP
.PP
The clauses to rename columns and tables are Postgres
extensions from SQL92.
