# NOTE: Derived from blib/lib/Class/MethodMaker.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package Class::MethodMaker;

#line 2115 "blib/lib/Class/MethodMaker.pm (autosplit into blib/lib/auto/Class/MethodMaker/tie_hash.al)"
# ----------------------------------------------------------------------


sub tie_hash {
  my ($class, @args) = @_;
  my %methods;

  while ( my ($fieldr, $args) = splice (@args, 0, 2)) {
    my $field;
    foreach $field (ref $fieldr ? @$fieldr : $fieldr) {
      $methods{$field} =
        sub {
          my ($self, @list) = @_;

          if ( ! defined $self->{$field} ) {
            my %hash;
            tie %hash, $args->{'tie'}, @{$args->{'args'}};
            $self->{$field} = \%hash;
          }

          if (scalar @list == 1) {
            my $key = shift @list;
            if (ref $key eq 'ARRAY') {
              return @{$self->{$field}}{@$key};
            } else {
              return $self->{$field}->{$key};
            }
          } else {
            while (1) {
              my $key = shift @list;
              defined $key or last;
              my $value = shift @list;
              defined $value or carp "No value for key $key.";
              $self->{$field}->{$key} = $value;
            }
            wantarray ? %{$self->{$field}} : $self->{$field};
          }
        };

      $methods{$field . "_keys"} =
        sub {
          my ($self) = @_;
          keys %{$self->{$field}};
        };

      $methods{$field . "_values"} =
        sub {
          my ($self) = @_;
          values %{$self->{$field}};
        };

      $methods{$field . "_exists"} =
        sub {
          my ($self) = shift;
          my ($key) = @_;
          return
            exists $self->{$field} && exists $self->{$field}->{$key};
        };

      $methods{$field . "_tally"} =
        sub {
          my ($self, @list) = @_;
          defined $self->{$field} or $self->{$field} = {};
          map { ++$self->{$field}->{$_} } @list;
        };

      $methods{$field . "_delete"} =
        sub {
          my ($self, @keys) = @_;
          delete @{$self->{$field}}{@keys};
        };
    }
  }
  $class->install_methods(%methods);
}

# end of Class::MethodMaker::tie_hash
1;
