'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1995 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
'\" @(#) options.n 1.40 95/10/03 08:40:46
'\" 
.so STk-man.macros
.TH options n 3.1 STk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
options \- Standard options supported by widgets
.BE

.SH DESCRIPTION
This manual entry describes the common configuration options supported
by widgets in the Tk toolkit.  Every widget does not necessarily support
every option (see the manual entries for individual widgets for a list
of the standard options supported by that widget), but if a widget does
support an option with one of the names listed below, then the option
has exactly the effect described below.
.PP
In the descriptions below, ``Command-Line Name'' refers to the
switch used in class commands and \fBconfigure\fR widget commands to
set this value.  For example, if an option's command-line switch is
\fB:foreground\fR and there exists a widget \fB.a.b.c\fR, then the
command
.CS
\&\fB(.a.b.c\0\0'configure\0\0:foreground "black"\fR)
.CE
may be used to specify the value \fBblack\fR for the option in the
the widget \fB.a.b.c\fR.  Command-line switches may be abbreviated,
as long as the abbreviation is unambiguous.
``Name'' refers to the option's name in the option database (e.g.
in .Xdefaults files).  ``Class'' refers to the option's class value
in the option database. For each option, the \fBSTklos\fR name is also 
specified. The \fBSTklos\fR name is usually the same as the option 
name, except when it is a composite word, in which case words 
are separated with a dash.


.OP :activebackground activeBackground Foreground active-background
Specifies background color to use when drawing active elements.
An element (a widget or portion of a widget) is active if the
mouse cursor is positioned over the element and pressing a mouse button
will cause some action to occur.
If strict Motif compliance has been requested by setting the
\fB*tk-strict-motif*\fR variable, this option will normally be
ignored;  the normal background color will be used instead.
.OP :activeborderwidth activeBorderWidth BorderWidth active-border-width
Specifies a non-negative value indicating
the width of the 3-D border drawn around active elements.  See above for
definition of active elements.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
This option is typically only available in widgets displaying more
than one element at a time (e.g. menus but not buttons).
.OP :activeforeground activeForeground Background active-foreground
Specifies foreground color to use when drawing active elements.
See above for definition of active elements.
.OP :anchor anchor Anchor anchor
Specifies how the information in a widget (e.g. text or a bitmap)
is to be displayed in the widget.
Must be one of the values \fBn\fR, \fBne\fR, \fBe\fR, \fBse\fR,
\fBs\fR, \fBsw\fR, \fBw\fR, \fBnw\fR, or \fBcenter\fR.
For example, \fBnw\fR means display the information such that its
top-left corner is at the top-left corner of the widget.
.OP :background background Background background
Specifies the normal background color to use when displaying the
widget. This option can also be specified as \fB:bg\fR.
.OP :bitmap bitmap Bitmap bitmap
Specifies a bitmap to display in the widget, in any of the forms
acceptable to \fBTk_GetBitmap\fR.
The exact way in which the bitmap is displayed may be affected by
other options such as \fBanchor\fR or \fBjustify\fR.
Typically, if this option is specified then it overrides other
options that specify a textual value to display in the widget;
the \fBbitmap\fR option may be reset to an empty string to re-enable
a text display.
In widgets that support both \fBbitmap\fR and \fBimage\fR options,
\fBimage\fR will usually override \fBbitmap\fR.
.OP :borderwidth borderWidth BorderWidth :border-width
Specifies a non-negative value indicating the width
of the 3-D border to draw around the outside of the widget (if such a
border is being drawn;  the \fBrelief\fR option typically determines
this).  The value may also be used when drawing 3-D effects in the
interior of the widget.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
This option can also be specified as \fB:bd\fR.
.OP :cursor cursor Cursor cursor
Specifies the mouse cursor to be used for the widget.
The value may have any of the forms acceptable to \fBTk_GetCursor\fR.
.OP :disabledforeground disabledForeground DisabledForeground disabled-foreground
Specifies foreground color to use when drawing a disabled element.
If the option is specified as an empty string (which is typically the
case on monochrome displays), disabled elements are drawn with the
normal foreground color but they are dimmed by drawing them
with a stippled fill pattern.
.OP :exportselection exportSelection ExportSelection export-selection
Specifies whether or not a selection in the widget should also be the
X selection.  The value must be a boolean value. If the selection is
exported, then selecting in the widget deselects the current X
selection, selecting outside the widget deselects any widget
selection, and the widget will respond to selection retrieval requests
when it has a selection.  The default is usually for widgets to export
selections.
.OP :font font Font font
Specifies the font to use when drawing text inside the widget.
.OP :foreground foreground Foreground foreground
Specifies the normal foreground color to use when displaying the widget.
This option can also be specified as \fB:fg\fR.
.OP :geometry geometry Geometry geometry
Specifies the desired geometry for the widget's window, in the
form \fIwidth\fBx\fIheight\fR, where \fIwidth\fR is the desired
width of the window and \fIheight\fR is the desired height.  The
units for \fIwidth\fR and \fIheight\fR depend on the particular
widget.  For widgets displaying text the units are usually the
size of the characters in the font being displayed;  for other
widgets the units are usually pixels.
.OP :highlightbackground highlightBackground HighlightBackground highlight-background
Specifies the color to display in the traversal highlight region when
the widget does not have the input focus.
.OP :highlightcolor highlightColor HighlightColor highlight-color
Specifies the color to use for the traversal highlight rectangle that is
drawn around the widget when it has the input focus.
.OP :highlightthickness highlightThickness HighlightThickness highlight-thickness
Specifies a non-negative value indicating the width of the highlight
rectangle to draw around the outside of the widget when it has the
input focus.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
If the value is zero, no focus highlight is drawn around the widget.
.OP :image image Image image
Specifies an image to display in the widget, which must have been
created with the \fBimage create\fR command.
Typically, if the \fBimage\fR option is specified then it overrides other
options that specify a bitmap or textual value to display in the widget;
the \fBimage\fR option may be reset to an empty string to re-enable
a bitmap or text display.
.OP :insertbackground insertBackground Foreground insert-background
Specifies the color to use as background in the area covered by the
insertion cursor.  This color will normally override either the normal
background for the widget (or the selection background if the insertion
cursor happens to fall in the selection).
.OP :insertborderwidth insertBorderWidth BorderWidth insert-border-width
Specifies a non-negative value indicating the width
of the 3-D border to draw around the insertion cursor.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.OP :insertofftime insertOffTime OffTime insert-off-time
Specifies a non-negative integer value indicating the number of
milliseconds the insertion cursor should remain ``off'' in each blink cycle.
If this option is zero then the cursor doesn't blink:  it is on
all the time.
.OP :insertontime insertOnTime OnTime insert-on-time
Specifies a non-negative integer value indicating the number of
milliseconds the insertion cursor should remain ``on'' in each blink cycle.
.OP :insertwidth insertWidth InsertWidth insert-width
Specifies a  value indicating the total width of the insertion cursor.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
If a border has been specified for the insertion
cursor (using the \fBinsertBorderWidth\fR option), the border
will be drawn inside the width specified by the \fBinsertWidth\fR
option.
.OP :jump jump Jump jump
For widgets with a slider that can be dragged to adjust a value,
such as scrollbars, this option determines when
notifications are made about changes in the value.
The option's value must be a boolean of the form accepted by
\fBTcl_GetBoolean\fR.
If the value is false, updates are made continuously as the
slider is dragged.
If the value is true, updates are delayed until the mouse button
is released to end the drag;  at that point a single notification
is made (the value ``jumps'' rather than changing smoothly).
.OP :justify justify Justify justify
When there are multiple lines of text displayed in a widget, this
option determines how the lines line up with each other.
Must be one of \fBleft\fR, \fBcenter\fR, or \fBright\fR.
\fBLeft\fR means that the lines' left edges all line up, \fBcenter\fR
means that the lines' centers are aligned, and \fBright\fR means
that the lines' right edges line up.
.OP :orient orient Orient orientation
For widgets that can lay themselves out with either a horizontal
or vertical orientation, such as scrollbars, this option specifies
which orientation should be used.  Must be either \fBhorizontal\fR
or \fBvertical\fR or an abbreviation of one of these.
.OP :padx padX Pad padx
Specifies a non-negative value indicating how much extra space
to request for the widget in the X-direction.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
When computing how large a window it needs, the widget will
add this amount to the width it would normally need (as determined
by the width of the things displayed in the widget);  if the geometry
manager can satisfy this request, the widget will end up with extra
internal space to the left and/or right of what it displays inside.
Most widgets only use this option for padding text:  if they are
displaying a bitmap or image, then they usually ignore padding
options.
.OP :pady padY Pad pady
Specifies a non-negative value indicating how much extra space
to request for the widget in the Y-direction.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
When computing how large a window it needs, the widget will add
this amount to the height it would normally need (as determined by
the height of the things displayed in the widget);  if the geometry
manager can satisfy this request, the widget will end up with extra
internal space above and/or below what it displays inside.
Most widgets only use this option for padding text:  if they are
displaying a bitmap or image, then they usually ignore padding
options.
.OP :relief relief Relief relief
Specifies the 3-D effect desired for the widget.  Acceptable
values are \fBraised\fR, \fBsunken\fR, \fBflat\fR, \fBridge\fR,
and \fBgroove\fR.
The value
indicates how the interior of the widget should appear relative
to its exterior;  for example, \fBraised\fR means the interior of
the widget should appear to protrude from the screen, relative to
the exterior of the widget.
.OP :repeatdelay repeatDelay RepeatDelay repeat-delay
Specifies the number of milliseconds a button or key must be held
down before it begins to auto-repeat.  Used, for example, on the
up- and down-arrows in scrollbars.
.OP :repeatinterval repeatInterval RepeatInterval repeat-interval
Used in conjunction with \fBrepeatDelay\fR:  once auto-repeat
begins, this option determines the number of milliseconds between
auto-repeats.
.OP :selectbackground selectBackground Foreground select-background
Specifies the background color to use when displaying selected
items.
.OP :selectborderwidth selectBorderWidth BorderWidth select-border-width
Specifies a non-negative value indicating the width
of the 3-D border to draw around selected items.
The value may have any of the forms acceptable to \fBTk_GetPixels\fR.
.OP :selectforeground selectForeground Background select-foreground
Specifies the foreground color to use when displaying selected
items.
.OP :setgrid setGrid SetGrid set-grid
Specifies a boolean value that determines whether this widget controls the
resizing grid for its top-level window.
This option is typically used in text widgets, where the information
in the widget has a natural size (the size of a character) and it makes
sense for the window's dimensions to be integral numbers of these units.
These natural window sizes form a grid.
If the \fBsetGrid\fR option is set to true then the widget will
communicate with the window manager so that when the user interactively
resizes the top-level window that contains the widget, the dimensions of
the window will be displayed to the user in grid units and the window
size will be constrained to integral numbers of grid units.
See the section GRIDDED GEOMETRY MANAGEMENT in the \fBwm\fR manual
entry for more details.
.OP :takefocus takeFocus TakeFocus take-focus
Determines whether the window accepts the focus during keyboard
traversal (e.g., Tab and Shift-Tab).
Before setting the focus to a window, the traversal scripts
consult the value of the \fBtakeFocus\fR option.
A value of \fB#f\fR means that the window should be skipped entirely
during keyboard traversal. 
\fB#t\fR means that the window should receive the input
focus as long as it is viewable (it and all of its ancestors are mapped).
An empty string for the option means that the traversal scripts make
the decision about whether or not to focus on the window:  the current
algorithm is to skip the window if it is
disabled, if it has no key bindings, or if it is not viewable.
Value can also be a one parameter procedure. This procedure is called
by the traversal algorithm with the window as parameter. The 
value retuned by he procedure must be \fB#f\fR, \fB#t\fR, or an empty string:  a 
\fB#f\fR or \fB#t\fR value specifies whether the window will receive
the input focus, and an empty string results in the default decision
described above. See the \fBfocus-next\fR page for the \fBfocus-on\fR
and \fBfocus-off\fR procedures.
\fBNote\fR: this interpretation of the option is defined entirely by
the STk scripts that implement traversal:  the widget implementations
ignore the option entirely, so you can change its meaning if you
redefine the keyboard traversal scripts.
.OP :text text Text text
Specifies a string to be displayed inside the widget.  The way in which
the string is displayed depends on the particular widget and may be
determined by other options, such as \fBanchor\fR or \fBjustify\fR.
.OP :textvariable textVariable Variable text-variable
Specifies the name of a variable.  The value of the variable is a text
string to be displayed inside the widget;  if the variable value changes
then the widget will automatically update itself to reflect the new value.
The way in which the string is displayed in the widget depends on the
particular widget and may be determined by other options, such as
\fBanchor\fR or \fBjustify\fR.
.OP :troughcolor troughColor Background trough-color
Specifies the color to use for the rectangular trough areas
in widgets such as scrollbars and scales.
.OP :underline underline Underline underline
Specifies the integer index of a character to underline in the widget.
This option is used by the default bindings to implement keyboard
traversal for menu buttons and menu entries.
0 corresponds to the first character of the text displayed in the
widget, 1 to the next character, and so on.
.OP :wraplength wrapLength WrapLength wrap-length
For widgets that can perform word-wrapping, this option specifies
the maximum line length.
Lines that would exceed this length are wrapped onto the next line,
so that no line is longer than the specified length.
The value may be specified in any of the standard forms for
screen distances.
If this value is less than or equal to 0 then no wrapping is done:  lines
will break only at newline characters in the text.
.OP :xscrollcommand xScrollCommand ScrollCommand x-scroll-command
Specifies the procedure used to communicate with horizontal scrollbars.
When the view in the widget's window changes (or
whenever anything else occurs that could change the display in a
scrollbar, such as a change in the total size of the widget's
contents), the widget call this procedure with two numbers as parameters.
Each of the numbers is a fraction between 0 and 1, which indicates
a position in the document.  0 indicates the beginning of the document,
1 indicates the end, .333 indicates a position one third the way through
the document, and so on.
The first fraction indicates the first information in the document
that is visible in the window, and the second fraction indicates
the information just after the last portion that is visible.
Typically the
\fBxScrollCommand\fR option consists of a procedure of the form
.CS
(lambda l (apply .x.scrollbar 'set l))
.CE
this will cause the scrollbar to be updated whenever the view in the
window changes.  If this option is not specified, then no command will
be executed.
.OP :yscrollcommand yScrollCommand ScrollCommand y-scroll-command
Specifies the prefix for a command used to communicate with vertical
scrollbars.  This option is treated in the same way as the
\fBxScrollCommand\fR option, except that it is used for vertical
scrollbars and is provided by widgets that support vertical scrolling.
See the description of \fBxScrollCommand\fR for details
on how this option is used.

