require '_h2ph_pre.ph';

require 'sys/queue.ph';
require 'sys/time.ph';
unless(defined(&LINK_STATE_UNKNOWN)) {
    sub LINK_STATE_UNKNOWN () {	0;}
}
unless(defined(&LINK_STATE_DOWN)) {
    sub LINK_STATE_DOWN () {	1;}
}
unless(defined(&LINK_STATE_UP)) {
    sub LINK_STATE_UP () {	2;}
}
unless(defined(&IFNAMSIZ)) {
    sub IFNAMSIZ () {	16;}
}
unless(defined(&IF_NAMESIZE)) {
    sub IF_NAMESIZE () {	 &IFNAMSIZ;}
}
unless(defined(&if_mtu)) {
    sub if_mtu () {	 ($if_data->{ifi_mtu});}
}
unless(defined(&if_type)) {
    sub if_type () {	 ($if_data->{ifi_type});}
}
unless(defined(&if_addrlen)) {
    sub if_addrlen () {	 ($if_data->{ifi_addrlen});}
}
unless(defined(&if_hdrlen)) {
    sub if_hdrlen () {	 ($if_data->{ifi_hdrlen});}
}
unless(defined(&if_metric)) {
    sub if_metric () {	 ($if_data->{ifi_metric});}
}
unless(defined(&if_link_state)) {
    sub if_link_state () {	 ($if_data->{ifi_link_state});}
}
unless(defined(&if_baudrate)) {
    sub if_baudrate () {	 ($if_data->{ifi_baudrate});}
}
unless(defined(&if_ipackets)) {
    sub if_ipackets () {	 ($if_data->{ifi_ipackets});}
}
unless(defined(&if_ierrors)) {
    sub if_ierrors () {	 ($if_data->{ifi_ierrors});}
}
unless(defined(&if_opackets)) {
    sub if_opackets () {	 ($if_data->{ifi_opackets});}
}
unless(defined(&if_oerrors)) {
    sub if_oerrors () {	 ($if_data->{ifi_oerrors});}
}
unless(defined(&if_collisions)) {
    sub if_collisions () {	 ($if_data->{ifi_collisions});}
}
unless(defined(&if_ibytes)) {
    sub if_ibytes () {	 ($if_data->{ifi_ibytes});}
}
unless(defined(&if_obytes)) {
    sub if_obytes () {	 ($if_data->{ifi_obytes});}
}
unless(defined(&if_imcasts)) {
    sub if_imcasts () {	 ($if_data->{ifi_imcasts});}
}
unless(defined(&if_omcasts)) {
    sub if_omcasts () {	 ($if_data->{ifi_omcasts});}
}
unless(defined(&if_iqdrops)) {
    sub if_iqdrops () {	 ($if_data->{ifi_iqdrops});}
}
unless(defined(&if_noproto)) {
    sub if_noproto () {	 ($if_data->{ifi_noproto});}
}
unless(defined(&if_lastchange)) {
    sub if_lastchange () {	 ($if_data->{ifi_lastchange});}
}
unless(defined(&IFF_UP)) {
    sub IFF_UP () {	0x1;}
}
unless(defined(&IFF_BROADCAST)) {
    sub IFF_BROADCAST () {	0x2;}
}
unless(defined(&IFF_DEBUG)) {
    sub IFF_DEBUG () {	0x4;}
}
unless(defined(&IFF_LOOPBACK)) {
    sub IFF_LOOPBACK () {	0x8;}
}
unless(defined(&IFF_POINTOPOINT)) {
    sub IFF_POINTOPOINT () {	0x10;}
}
unless(defined(&IFF_NOTRAILERS)) {
    sub IFF_NOTRAILERS () {	0x20;}
}
unless(defined(&IFF_RUNNING)) {
    sub IFF_RUNNING () {	0x40;}
}
unless(defined(&IFF_NOARP)) {
    sub IFF_NOARP () {	0x80;}
}
unless(defined(&IFF_PROMISC)) {
    sub IFF_PROMISC () {	0x100;}
}
unless(defined(&IFF_ALLMULTI)) {
    sub IFF_ALLMULTI () {	0x200;}
}
unless(defined(&IFF_OACTIVE)) {
    sub IFF_OACTIVE () {	0x400;}
}
unless(defined(&IFF_SIMPLEX)) {
    sub IFF_SIMPLEX () {	0x800;}
}
unless(defined(&IFF_LINK0)) {
    sub IFF_LINK0 () {	0x1000;}
}
unless(defined(&IFF_LINK1)) {
    sub IFF_LINK1 () {	0x2000;}
}
unless(defined(&IFF_LINK2)) {
    sub IFF_LINK2 () {	0x4000;}
}
unless(defined(&IFF_MULTICAST)) {
    sub IFF_MULTICAST () {	0x8000;}
}
unless(defined(&IFF_CANTCHANGE)) {
    sub IFF_CANTCHANGE () {	( &IFF_BROADCAST| &IFF_POINTOPOINT| &IFF_RUNNING| &IFF_OACTIVE|  &IFF_SIMPLEX| &IFF_MULTICAST| &IFF_ALLMULTI);}
}
unless(defined(&IF_Kbps)) {
    sub IF_Kbps {
	local($x) = @_;
	eval q((($x) * 1000));
    }
}
unless(defined(&IF_Mbps)) {
    sub IF_Mbps {
	local($x) = @_;
	eval q(( &IF_Kbps(($x) * 1000)));
    }
}
unless(defined(&IF_Gbps)) {
    sub IF_Gbps {
	local($x) = @_;
	eval q(( &IF_Mbps(($x) * 1000)));
    }
}
unless(defined(&IF_QFULL)) {
    sub IF_QFULL {
	local($ifq) = @_;
	eval q((($ifq)-> &ifq_len >= ($ifq)-> &ifq_maxlen));
    }
}
unless(defined(&IF_DROP)) {
    sub IF_DROP {
	local($ifq) = @_;
	eval q((($ifq)-> &ifq_drops++));
    }
}
unless(defined(&IF_ENQUEUE)) {
    sub IF_ENQUEUE {
	local($ifq, $m) = @_;
	eval q({ ($m)-> &m_nextpkt = 0;  &if (($ifq)-> &ifq_tail == 0) ($ifq)-> &ifq_head = $m;  &else ($ifq)-> ($ifq_tail->{m_nextpkt}) = $m; ($ifq)-> &ifq_tail = $m; ($ifq)-> &ifq_len++; });
    }
}
unless(defined(&IF_PREPEND)) {
    sub IF_PREPEND {
	local($ifq, $m) = @_;
	eval q({ ($m)-> &m_nextpkt = ($ifq)-> &ifq_head;  &if (($ifq)-> &ifq_tail == 0) ($ifq)-> &ifq_tail = ($m); ($ifq)-> &ifq_head = ($m); ($ifq)-> &ifq_len++; });
    }
}
unless(defined(&IF_DEQUEUE)) {
    sub IF_DEQUEUE {
	local($ifq, $m) = @_;
	eval q({ ($m) = ($ifq)-> &ifq_head;  &if ($m) {  &if ((($ifq)-> &ifq_head = ($m)-> &m_nextpkt) == 0) ($ifq)-> &ifq_tail = 0; ($m)-> &m_nextpkt = 0; ($ifq)-> &ifq_len--; } });
    }
}
unless(defined(&IFQ_MAXLEN)) {
    sub IFQ_MAXLEN () {	50;}
}
unless(defined(&IFNET_SLOWHZ)) {
    sub IFNET_SLOWHZ () {	1;}
}
unless(defined(&ifa_broadaddr)) {
    sub ifa_broadaddr () {	 &ifa_dstaddr;}
}
unless(defined(&IFA_ROUTE)) {
    sub IFA_ROUTE () {	 &RTF_UP;}
}
unless(defined(&ifr_addr)) {
    sub ifr_addr () {	 ($ifr_ifru->{ifru_addr});}
}
unless(defined(&ifr_dstaddr)) {
    sub ifr_dstaddr () {	 ($ifr_ifru->{ifru_dstaddr});}
}
unless(defined(&ifr_broadaddr)) {
    sub ifr_broadaddr () {	 ($ifr_ifru->{ifru_broadaddr});}
}
unless(defined(&ifr_flags)) {
    sub ifr_flags () {	 ($ifr_ifru->{ifru_flags});}
}
unless(defined(&ifr_metric)) {
    sub ifr_metric () {	 ($ifr_ifru->{ifru_metric});}
}
unless(defined(&ifr_mtu)) {
    sub ifr_mtu () {	 ($ifr_ifru->{ifru_metric});}
}
unless(defined(&ifr_media)) {
    sub ifr_media () {	 ($ifr_ifru->{ifru_metric});}
}
unless(defined(&ifr_data)) {
    sub ifr_data () {	 ($ifr_ifru->{ifru_data});}
}
unless(defined(&ifra_broadaddr)) {
    sub ifra_broadaddr () {	 &ifra_dstaddr;}
}
unless(defined(&ifc_buf)) {
    sub ifc_buf () {	 ($ifc_ifcu->{ifcu_buf});}
}
unless(defined(&ifc_req)) {
    sub ifc_req () {	 ($ifc_ifcu->{ifcu_req});}
}
unless(defined(&IFLR_PREFIX)) {
    sub IFLR_PREFIX () {	0x8000;}
}
unless(defined(&_KERNEL)) {
    eval 'sub if_freenameindex {
        local($x) = @_;
	    eval q( &free($x));
    }' unless defined(&if_freenameindex);
}
require 'net/if_arp.ph';
if(defined(&_KERNEL)) {
    eval 'sub IFAFREE {
        local($ifa) = @_;
	    eval q( &do {  &if (($ifa)-> &ifa_refcnt <= 0)  &ifafree($ifa);  &else ($ifa)-> &ifa_refcnt--; }  &while (0));
    }' unless defined(&IFAFREE);
    if(0) {
    }
}
1;
