require '_h2ph_pre.ph';

unless(defined(&AMD756_CHIPREV_D2)) {
    sub AMD756_CHIPREV_D2 () {	3;}
}
unless(defined(&AMD756_CHIPREV_DISABLEDMA)) {
    sub AMD756_CHIPREV_DISABLEDMA {
	local($rev) = @_;
	eval q((($rev) <=  &AMD756_CHIPREV_D2));
    }
}
unless(defined(&AMD756_CHANSTATUS_EN)) {
    sub AMD756_CHANSTATUS_EN () {	0x40;}
}
unless(defined(&AMD756_CHAN_EN)) {
    sub AMD756_CHAN_EN {
	local($chan) = @_;
	eval q((0x01 << (1- ($chan))));
    }
}
unless(defined(&AMD756_DATATIM)) {
    sub AMD756_DATATIM () {	0x48;}
}
unless(defined(&AMD756_DATATIM_MASK)) {
    sub AMD756_DATATIM_MASK {
	local($channel) = @_;
	eval q((0xffff << ((1- ($channel)) << 4)));
    }
}
unless(defined(&AMD756_DATATIM_RECOV)) {
    sub AMD756_DATATIM_RECOV {
	local($channel, $drive, $x) = @_;
	eval q(((($x) & 0xf) << (((1- ($channel)) << 4) + ((1- ($drive)) << 3))));
    }
}
unless(defined(&AMD756_DATATIM_PULSE)) {
    sub AMD756_DATATIM_PULSE {
	local($channel, $drive, $x) = @_;
	eval q(((($x) & 0xf) << (((1- ($channel)) << 4) + ((1- ($drive)) << 3) + 4)));
    }
}
unless(defined(&AMD756_UDMA)) {
    sub AMD756_UDMA () {	0x50;}
}
unless(defined(&AMD756_UDMA_MASK)) {
    sub AMD756_UDMA_MASK {
	local($channel) = @_;
	eval q((0xffff << ((1- ($channel)) << 4)));
    }
}
unless(defined(&AMD756_UDMA_TIME)) {
    sub AMD756_UDMA_TIME {
	local($channel, $drive, $x) = @_;
	eval q(((($x) & 0x7) << (((1- ($channel)) << 4) + ((1- ($drive)) << 3))));
    }
}
unless(defined(&AMD756_UDMA_EN)) {
    sub AMD756_UDMA_EN {
	local($channel, $drive) = @_;
	eval q((0x40 << (((1- ($channel)) << 4) + ((1- ($drive)) << 3))));
    }
}
unless(defined(&AMD756_UDMA_EN_MTH)) {
    sub AMD756_UDMA_EN_MTH {
	local($channel, $drive) = @_;
	eval q((0x80 << (((1- ($channel)) << 4) + ((1- ($drive)) << 3))));
    }
}
1;
