/*	$NetBSD: qvss.h,v 1.4 1996/04/07 19:54:37 jonathan Exp $	*/

/* 
 * Copyright (c) 1992, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Ralph Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)font.c	8.1 (Berkeley) 6/10/93
 *
 *  font.c --
 *
 *     	The font table for the pmax.
 *
 *	Copyright (C) 1989 Digital Equipment Corporation.
 *	Permission to use, copy, modify, and distribute this software and
 *	its documentation for any purpose and without fee is hereby granted,
 *	provided that the above copyright notice appears in all copies.  
 *	Digital Equipment Corporation makes no representations about the
 *	suitability of this software for any purpose.  It is provided "as is"
 *	without express or implied warranty.
 */

/*
 * QVSS font table of displayable characters.
 */
static u_int32_t qvss_32_pixels [] = {
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
	0x00, /* 0x00000000	   */
      };
static struct raster qvss_32 = { 8, 15, 1, 1, qvss_32_pixels, 0 };

static u_int32_t qvss_33_pixels [] = {
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x08, /* 0x00001000	  ! */
	0x00, /* 0x00000000	  ! */
	0x08, /* 0x00001000	  ! */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
	0x00, /* 0x00000000	  ! */
      };
static struct raster qvss_33 = { 8, 15, 1, 1, qvss_33_pixels, 0 };

static u_int32_t qvss_34_pixels [] = {
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x24, /* 0x00100100	  " */
	0x24, /* 0x00100100	  " */
	0x24, /* 0x00100100	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
	0x00, /* 0x00000000	  " */
      };
static struct raster qvss_34 = { 8, 15, 1, 1, qvss_34_pixels, 0 };

static u_int32_t qvss_35_pixels [] = {
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x3f, /* 0x00111111	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x3f, /* 0x00111111	  # */
	0x12, /* 0x00010010	  # */
	0x12, /* 0x00010010	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
	0x00, /* 0x00000000	  # */
      };
static struct raster qvss_35 = { 8, 15, 1, 1, qvss_35_pixels, 0 };

static u_int32_t qvss_36_pixels [] = {
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x08, /* 0x00001000	  $ */
	0x3e, /* 0x00111110	  $ */
	0x09, /* 0x00001001	  $ */
	0x09, /* 0x00001001	  $ */
	0x3e, /* 0x00111110	  $ */
	0x48, /* 0x01001000	  $ */
	0x48, /* 0x01001000	  $ */
	0x3e, /* 0x00111110	  $ */
	0x08, /* 0x00001000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
	0x00, /* 0x00000000	  $ */
      };
static struct raster qvss_36 = { 8, 15, 1, 1, qvss_36_pixels, 0 };

static u_int32_t qvss_37_pixels [] = {
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
	0x42, /* 0x01000010	  % */
	0x25, /* 0x00100101	  % */
	0x25, /* 0x00100101	  % */
	0x12, /* 0x00010010	  % */
	0x08, /* 0x00001000	  % */
	0x08, /* 0x00001000	  % */
	0x24, /* 0x00100100	  % */
	0x52, /* 0x01010010	  % */
	0x52, /* 0x01010010	  % */
	0x21, /* 0x00100001	  % */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
	0x00, /* 0x00000000	  % */
      };
static struct raster qvss_37 = { 8, 15, 1, 1, qvss_37_pixels, 0 };

static u_int32_t qvss_38_pixels [] = {
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
	0x0e, /* 0x00001110	  & */
	0x11, /* 0x00010001	  & */
	0x11, /* 0x00010001	  & */
	0x11, /* 0x00010001	  & */
	0x0e, /* 0x00001110	  & */
	0x11, /* 0x00010001	  & */
	0x51, /* 0x01010001	  & */
	0x21, /* 0x00100001	  & */
	0x31, /* 0x00110001	  & */
	0x4e, /* 0x01001110	  & */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
	0x00, /* 0x00000000	  & */
      };
static struct raster qvss_38 = { 8, 15, 1, 1, qvss_38_pixels, 0 };

static u_int32_t qvss_39_pixels [] = {
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x38, /* 0x00111000	  ' */
	0x18, /* 0x00011000	  ' */
	0x04, /* 0x00000100	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
	0x00, /* 0x00000000	  ' */
      };
static struct raster qvss_39 = { 8, 15, 1, 1, qvss_39_pixels, 0 };

static u_int32_t qvss_40_pixels [] = {
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
	0x10, /* 0x00010000	  ( */
	0x08, /* 0x00001000	  ( */
	0x08, /* 0x00001000	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x04, /* 0x00000100	  ( */
	0x08, /* 0x00001000	  ( */
	0x08, /* 0x00001000	  ( */
	0x10, /* 0x00010000	  ( */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
	0x00, /* 0x00000000	  ( */
      };
static struct raster qvss_40 = { 8, 15, 1, 1, qvss_40_pixels, 0 };

static u_int32_t qvss_41_pixels [] = {
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
	0x04, /* 0x00000100	  ) */
	0x08, /* 0x00001000	  ) */
	0x08, /* 0x00001000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x10, /* 0x00010000	  ) */
	0x08, /* 0x00001000	  ) */
	0x08, /* 0x00001000	  ) */
	0x04, /* 0x00000100	  ) */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
	0x00, /* 0x00000000	  ) */
      };
static struct raster qvss_41 = { 8, 15, 1, 1, qvss_41_pixels, 0 };

static u_int32_t qvss_42_pixels [] = {
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x22, /* 0x00100010	  * */
	0x14, /* 0x00010100	  * */
	0x7f, /* 0x01111111	  * */
	0x14, /* 0x00010100	  * */
	0x22, /* 0x00100010	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
	0x00, /* 0x00000000	  * */
      };
static struct raster qvss_42 = { 8, 15, 1, 1, qvss_42_pixels, 0 };

static u_int32_t qvss_43_pixels [] = {
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x7f, /* 0x01111111	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x08, /* 0x00001000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
	0x00, /* 0x00000000	  + */
      };
static struct raster qvss_43 = { 8, 15, 1, 1, qvss_43_pixels, 0 };

static u_int32_t qvss_44_pixels [] = {
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
	0x1c, /* 0x00011100	  , */
	0x0c, /* 0x00001100	  , */
	0x02, /* 0x00000010	  , */
	0x00, /* 0x00000000	  , */
	0x00, /* 0x00000000	  , */
      };
static struct raster qvss_44 = { 8, 15, 1, 1, qvss_44_pixels, 0 };

static u_int32_t qvss_45_pixels [] = {
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x7f, /* 0x01111111	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
	0x00, /* 0x00000000	  - */
      };
static struct raster qvss_45 = { 8, 15, 1, 1, qvss_45_pixels, 0 };

static u_int32_t qvss_46_pixels [] = {
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
	0x08, /* 0x00001000	  . */
	0x1c, /* 0x00011100	  . */
	0x08, /* 0x00001000	  . */
	0x00, /* 0x00000000	  . */
	0x00, /* 0x00000000	  . */
      };
static struct raster qvss_46 = { 8, 15, 1, 1, qvss_46_pixels, 0 };

static u_int32_t qvss_47_pixels [] = {
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
	0x40, /* 0x01000000	  / */
	0x40, /* 0x01000000	  / */
	0x20, /* 0x00100000	  / */
	0x10, /* 0x00010000	  / */
	0x08, /* 0x00001000	  / */
	0x04, /* 0x00000100	  / */
	0x02, /* 0x00000010	  / */
	0x01, /* 0x00000001	  / */
	0x01, /* 0x00000001	  / */
	0x01, /* 0x00000001	  / */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
	0x00, /* 0x00000000	  / */
      };
static struct raster qvss_47 = { 8, 15, 1, 1, qvss_47_pixels, 0 };

static u_int32_t qvss_48_pixels [] = {
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
	0x0c, /* 0x00001100	  0 */
	0x12, /* 0x00010010	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x21, /* 0x00100001	  0 */
	0x12, /* 0x00010010	  0 */
	0x0c, /* 0x00001100	  0 */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
	0x00, /* 0x00000000	  0 */
      };
static struct raster qvss_48 = { 8, 15, 1, 1, qvss_48_pixels, 0 };

static u_int32_t qvss_49_pixels [] = {
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
	0x08, /* 0x00001000	  1 */
	0x0c, /* 0x00001100	  1 */
	0x0a, /* 0x00001010	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x08, /* 0x00001000	  1 */
	0x3e, /* 0x00111110	  1 */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
	0x00, /* 0x00000000	  1 */
      };
static struct raster qvss_49 = { 8, 15, 1, 1, qvss_49_pixels, 0 };

static u_int32_t qvss_50_pixels [] = {
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
	0x3e, /* 0x00111110	  2 */
	0x41, /* 0x01000001	  2 */
	0x41, /* 0x01000001	  2 */
	0x40, /* 0x01000000	  2 */
	0x20, /* 0x00100000	  2 */
	0x10, /* 0x00010000	  2 */
	0x0c, /* 0x00001100	  2 */
	0x02, /* 0x00000010	  2 */
	0x01, /* 0x00000001	  2 */
	0x7f, /* 0x01111111	  2 */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
	0x00, /* 0x00000000	  2 */
      };
static struct raster qvss_50 = { 8, 15, 1, 1, qvss_50_pixels, 0 };

static u_int32_t qvss_51_pixels [] = {
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
	0x7f, /* 0x01111111	  3 */
	0x40, /* 0x01000000	  3 */
	0x20, /* 0x00100000	  3 */
	0x10, /* 0x00010000	  3 */
	0x38, /* 0x00111000	  3 */
	0x40, /* 0x01000000	  3 */
	0x40, /* 0x01000000	  3 */
	0x40, /* 0x01000000	  3 */
	0x41, /* 0x01000001	  3 */
	0x3e, /* 0x00111110	  3 */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
	0x00, /* 0x00000000	  3 */
      };
static struct raster qvss_51 = { 8, 15, 1, 1, qvss_51_pixels, 0 };

static u_int32_t qvss_52_pixels [] = {
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
	0x20, /* 0x00100000	  4 */
	0x30, /* 0x00110000	  4 */
	0x28, /* 0x00101000	  4 */
	0x24, /* 0x00100100	  4 */
	0x22, /* 0x00100010	  4 */
	0x21, /* 0x00100001	  4 */
	0x7f, /* 0x01111111	  4 */
	0x20, /* 0x00100000	  4 */
	0x20, /* 0x00100000	  4 */
	0x20, /* 0x00100000	  4 */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
	0x00, /* 0x00000000	  4 */
      };
static struct raster qvss_52 = { 8, 15, 1, 1, qvss_52_pixels, 0 };

static u_int32_t qvss_53_pixels [] = {
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
	0x7f, /* 0x01111111	  5 */
	0x01, /* 0x00000001	  5 */
	0x01, /* 0x00000001	  5 */
	0x3d, /* 0x00111101	  5 */
	0x43, /* 0x01000011	  5 */
	0x40, /* 0x01000000	  5 */
	0x40, /* 0x01000000	  5 */
	0x40, /* 0x01000000	  5 */
	0x41, /* 0x01000001	  5 */
	0x3e, /* 0x00111110	  5 */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
	0x00, /* 0x00000000	  5 */
      };
static struct raster qvss_53 = { 8, 15, 1, 1, qvss_53_pixels, 0 };

static u_int32_t qvss_54_pixels [] = {
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
	0x3c, /* 0x00111100	  6 */
	0x02, /* 0x00000010	  6 */
	0x01, /* 0x00000001	  6 */
	0x01, /* 0x00000001	  6 */
	0x3d, /* 0x00111101	  6 */
	0x43, /* 0x01000011	  6 */
	0x41, /* 0x01000001	  6 */
	0x41, /* 0x01000001	  6 */
	0x41, /* 0x01000001	  6 */
	0x3e, /* 0x00111110	  6 */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
	0x00, /* 0x00000000	  6 */
      };
static struct raster qvss_54 = { 8, 15, 1, 1, qvss_54_pixels, 0 };

static u_int32_t qvss_55_pixels [] = {
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
	0x7f, /* 0x01111111	  7 */
	0x40, /* 0x01000000	  7 */
	0x40, /* 0x01000000	  7 */
	0x20, /* 0x00100000	  7 */
	0x10, /* 0x00010000	  7 */
	0x08, /* 0x00001000	  7 */
	0x04, /* 0x00000100	  7 */
	0x04, /* 0x00000100	  7 */
	0x02, /* 0x00000010	  7 */
	0x02, /* 0x00000010	  7 */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
	0x00, /* 0x00000000	  7 */
      };
static struct raster qvss_55 = { 8, 15, 1, 1, qvss_55_pixels, 0 };

static u_int32_t qvss_56_pixels [] = {
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
	0x3e, /* 0x00111110	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x3e, /* 0x00111110	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x41, /* 0x01000001	  8 */
	0x3e, /* 0x00111110	  8 */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
	0x00, /* 0x00000000	  8 */
      };
static struct raster qvss_56 = { 8, 15, 1, 1, qvss_56_pixels, 0 };

static u_int32_t qvss_57_pixels [] = {
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
	0x3e, /* 0x00111110	  9 */
	0x41, /* 0x01000001	  9 */
	0x41, /* 0x01000001	  9 */
	0x41, /* 0x01000001	  9 */
	0x61, /* 0x01100001	  9 */
	0x5e, /* 0x01011110	  9 */
	0x40, /* 0x01000000	  9 */
	0x40, /* 0x01000000	  9 */
	0x20, /* 0x00100000	  9 */
	0x1e, /* 0x00011110	  9 */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
	0x00, /* 0x00000000	  9 */
      };
static struct raster qvss_57 = { 8, 15, 1, 1, qvss_57_pixels, 0 };

static u_int32_t qvss_58_pixels [] = {
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x08, /* 0x00001000	  : */
	0x1c, /* 0x00011100	  : */
	0x08, /* 0x00001000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
	0x08, /* 0x00001000	  : */
	0x1c, /* 0x00011100	  : */
	0x08, /* 0x00001000	  : */
	0x00, /* 0x00000000	  : */
	0x00, /* 0x00000000	  : */
      };
static struct raster qvss_58 = { 8, 15, 1, 1, qvss_58_pixels, 0 };

static u_int32_t qvss_59_pixels [] = {
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x08, /* 0x00001000	  ; */
	0x1c, /* 0x00011100	  ; */
	0x08, /* 0x00001000	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
	0x1c, /* 0x00011100	  ; */
	0x0c, /* 0x00001100	  ; */
	0x02, /* 0x00000010	  ; */
	0x00, /* 0x00000000	  ; */
	0x00, /* 0x00000000	  ; */
      };
static struct raster qvss_59 = { 8, 15, 1, 1, qvss_59_pixels, 0 };

static u_int32_t qvss_60_pixels [] = {
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
	0x20, /* 0x00100000	  < */
	0x10, /* 0x00010000	  < */
	0x08, /* 0x00001000	  < */
	0x04, /* 0x00000100	  < */
	0x02, /* 0x00000010	  < */
	0x02, /* 0x00000010	  < */
	0x04, /* 0x00000100	  < */
	0x08, /* 0x00001000	  < */
	0x10, /* 0x00010000	  < */
	0x20, /* 0x00100000	  < */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
	0x00, /* 0x00000000	  < */
      };
static struct raster qvss_60 = { 8, 15, 1, 1, qvss_60_pixels, 0 };

static u_int32_t qvss_61_pixels [] = {
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x7f, /* 0x01111111	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x7f, /* 0x01111111	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
	0x00, /* 0x00000000	  = */
      };
static struct raster qvss_61 = { 8, 15, 1, 1, qvss_61_pixels, 0 };

static u_int32_t qvss_62_pixels [] = {
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
	0x02, /* 0x00000010	  > */
	0x04, /* 0x00000100	  > */
	0x08, /* 0x00001000	  > */
	0x10, /* 0x00010000	  > */
	0x20, /* 0x00100000	  > */
	0x20, /* 0x00100000	  > */
	0x10, /* 0x00010000	  > */
	0x08, /* 0x00001000	  > */
	0x04, /* 0x00000100	  > */
	0x02, /* 0x00000010	  > */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
	0x00, /* 0x00000000	  > */
      };
static struct raster qvss_62 = { 8, 15, 1, 1, qvss_62_pixels, 0 };

static u_int32_t qvss_63_pixels [] = {
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
	0x3e, /* 0x00111110	  ? */
	0x41, /* 0x01000001	  ? */
	0x41, /* 0x01000001	  ? */
	0x40, /* 0x01000000	  ? */
	0x20, /* 0x00100000	  ? */
	0x10, /* 0x00010000	  ? */
	0x08, /* 0x00001000	  ? */
	0x08, /* 0x00001000	  ? */
	0x00, /* 0x00000000	  ? */
	0x08, /* 0x00001000	  ? */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
	0x00, /* 0x00000000	  ? */
      };
static struct raster qvss_63 = { 8, 15, 1, 1, qvss_63_pixels, 0 };

static u_int32_t qvss_64_pixels [] = {
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
	0x3e, /* 0x00111110	  @ */
	0x41, /* 0x01000001	  @ */
	0x41, /* 0x01000001	  @ */
	0x79, /* 0x01111001	  @ */
	0x45, /* 0x01000101	  @ */
	0x65, /* 0x01100101	  @ */
	0x59, /* 0x01011001	  @ */
	0x01, /* 0x00000001	  @ */
	0x01, /* 0x00000001	  @ */
	0x3e, /* 0x00111110	  @ */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
	0x00, /* 0x00000000	  @ */
      };
static struct raster qvss_64 = { 8, 15, 1, 1, qvss_64_pixels, 0 };

static u_int32_t qvss_65_pixels [] = {
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
	0x08, /* 0x00001000	  A */
	0x14, /* 0x00010100	  A */
	0x22, /* 0x00100010	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x7f, /* 0x01111111	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x41, /* 0x01000001	  A */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
	0x00, /* 0x00000000	  A */
      };
static struct raster qvss_65 = { 8, 15, 1, 1, qvss_65_pixels, 0 };

static u_int32_t qvss_66_pixels [] = {
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
	0x3f, /* 0x00111111	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x3e, /* 0x00111110	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x42, /* 0x01000010	  B */
	0x3f, /* 0x00111111	  B */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
	0x00, /* 0x00000000	  B */
      };
static struct raster qvss_66 = { 8, 15, 1, 1, qvss_66_pixels, 0 };

static u_int32_t qvss_67_pixels [] = {
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
	0x3e, /* 0x00111110	  C */
	0x41, /* 0x01000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x01, /* 0x00000001	  C */
	0x41, /* 0x01000001	  C */
	0x3e, /* 0x00111110	  C */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
	0x00, /* 0x00000000	  C */
      };
static struct raster qvss_67 = { 8, 15, 1, 1, qvss_67_pixels, 0 };

static u_int32_t qvss_68_pixels [] = {
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
	0x3f, /* 0x00111111	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x42, /* 0x01000010	  D */
	0x3f, /* 0x00111111	  D */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
	0x00, /* 0x00000000	  D */
      };
static struct raster qvss_68 = { 8, 15, 1, 1, qvss_68_pixels, 0 };

static u_int32_t qvss_69_pixels [] = {
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
	0x7e, /* 0x01111110	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x1e, /* 0x00011110	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x02, /* 0x00000010	  E */
	0x7e, /* 0x01111110	  E */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
	0x00, /* 0x00000000	  E */
      };
static struct raster qvss_69 = { 8, 15, 1, 1, qvss_69_pixels, 0 };

static u_int32_t qvss_70_pixels [] = {
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
	0x7e, /* 0x01111110	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x1e, /* 0x00011110	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x02, /* 0x00000010	  F */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
	0x00, /* 0x00000000	  F */
      };
static struct raster qvss_70 = { 8, 15, 1, 1, qvss_70_pixels, 0 };

static u_int32_t qvss_71_pixels [] = {
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
	0x3e, /* 0x00111110	  G */
	0x41, /* 0x01000001	  G */
	0x01, /* 0x00000001	  G */
	0x01, /* 0x00000001	  G */
	0x01, /* 0x00000001	  G */
	0x71, /* 0x01110001	  G */
	0x41, /* 0x01000001	  G */
	0x41, /* 0x01000001	  G */
	0x41, /* 0x01000001	  G */
	0x3e, /* 0x00111110	  G */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
	0x00, /* 0x00000000	  G */
      };
static struct raster qvss_71 = { 8, 15, 1, 1, qvss_71_pixels, 0 };

static u_int32_t qvss_72_pixels [] = {
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x7f, /* 0x01111111	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x41, /* 0x01000001	  H */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
	0x00, /* 0x00000000	  H */
      };
static struct raster qvss_72 = { 8, 15, 1, 1, qvss_72_pixels, 0 };

static u_int32_t qvss_73_pixels [] = {
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
	0x3e, /* 0x00111110	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x08, /* 0x00001000	  I */
	0x3e, /* 0x00111110	  I */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
	0x00, /* 0x00000000	  I */
      };
static struct raster qvss_73 = { 8, 15, 1, 1, qvss_73_pixels, 0 };

static u_int32_t qvss_74_pixels [] = {
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
	0x78, /* 0x01111000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x20, /* 0x00100000	  J */
	0x21, /* 0x00100001	  J */
	0x1e, /* 0x00011110	  J */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
	0x00, /* 0x00000000	  J */
      };
static struct raster qvss_74 = { 8, 15, 1, 1, qvss_74_pixels, 0 };

static u_int32_t qvss_75_pixels [] = {
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
	0x41, /* 0x01000001	  K */
	0x21, /* 0x00100001	  K */
	0x11, /* 0x00010001	  K */
	0x09, /* 0x00001001	  K */
	0x07, /* 0x00000111	  K */
	0x05, /* 0x00000101	  K */
	0x09, /* 0x00001001	  K */
	0x11, /* 0x00010001	  K */
	0x21, /* 0x00100001	  K */
	0x41, /* 0x01000001	  K */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
	0x00, /* 0x00000000	  K */
      };
static struct raster qvss_75 = { 8, 15, 1, 1, qvss_75_pixels, 0 };

static u_int32_t qvss_76_pixels [] = {
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x01, /* 0x00000001	  L */
	0x7f, /* 0x01111111	  L */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
	0x00, /* 0x00000000	  L */
      };
static struct raster qvss_76 = { 8, 15, 1, 1, qvss_76_pixels, 0 };

static u_int32_t qvss_77_pixels [] = {
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x63, /* 0x01100011	  M */
	0x55, /* 0x01010101	  M */
	0x55, /* 0x01010101	  M */
	0x49, /* 0x01001001	  M */
	0x49, /* 0x01001001	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x41, /* 0x01000001	  M */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
	0x00, /* 0x00000000	  M */
      };
static struct raster qvss_77 = { 8, 15, 1, 1, qvss_77_pixels, 0 };

static u_int32_t qvss_78_pixels [] = {
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x43, /* 0x01000011	  N */
	0x45, /* 0x01000101	  N */
	0x49, /* 0x01001001	  N */
	0x51, /* 0x01010001	  N */
	0x61, /* 0x01100001	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x41, /* 0x01000001	  N */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
	0x00, /* 0x00000000	  N */
      };
static struct raster qvss_78 = { 8, 15, 1, 1, qvss_78_pixels, 0 };

static u_int32_t qvss_79_pixels [] = {
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
	0x3e, /* 0x00111110	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x41, /* 0x01000001	  O */
	0x3e, /* 0x00111110	  O */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
	0x00, /* 0x00000000	  O */
      };
static struct raster qvss_79 = { 8, 15, 1, 1, qvss_79_pixels, 0 };

static u_int32_t qvss_80_pixels [] = {
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
	0x3f, /* 0x00111111	  P */
	0x41, /* 0x01000001	  P */
	0x41, /* 0x01000001	  P */
	0x41, /* 0x01000001	  P */
	0x3f, /* 0x00111111	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x01, /* 0x00000001	  P */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
	0x00, /* 0x00000000	  P */
      };
static struct raster qvss_80 = { 8, 15, 1, 1, qvss_80_pixels, 0 };

static u_int32_t qvss_81_pixels [] = {
	0x00, /* 0x00000000	  Q */
	0x00, /* 0x00000000	  Q */
	0x3e, /* 0x00111110	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x41, /* 0x01000001	  Q */
	0x49, /* 0x01001001	  Q */
	0x51, /* 0x01010001	  Q */
	0x3e, /* 0x00111110	  Q */
	0x40, /* 0x01000000	  Q */
	0x00, /* 0x00000000	  Q */
	0x00, /* 0x00000000	  Q */
      };
static struct raster qvss_81 = { 8, 15, 1, 1, qvss_81_pixels, 0 };

static u_int32_t qvss_82_pixels [] = {
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
	0x3f, /* 0x00111111	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x3f, /* 0x00111111	  R */
	0x09, /* 0x00001001	  R */
	0x11, /* 0x00010001	  R */
	0x21, /* 0x00100001	  R */
	0x41, /* 0x01000001	  R */
	0x41, /* 0x01000001	  R */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
	0x00, /* 0x00000000	  R */
      };
static struct raster qvss_82 = { 8, 15, 1, 1, qvss_82_pixels, 0 };

static u_int32_t qvss_83_pixels [] = {
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
	0x3e, /* 0x00111110	  S */
	0x41, /* 0x01000001	  S */
	0x01, /* 0x00000001	  S */
	0x01, /* 0x00000001	  S */
	0x3e, /* 0x00111110	  S */
	0x40, /* 0x01000000	  S */
	0x40, /* 0x01000000	  S */
	0x40, /* 0x01000000	  S */
	0x41, /* 0x01000001	  S */
	0x3e, /* 0x00111110	  S */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
	0x00, /* 0x00000000	  S */
      };
static struct raster qvss_83 = { 8, 15, 1, 1, qvss_83_pixels, 0 };

static u_int32_t qvss_84_pixels [] = {
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
	0x7f, /* 0x01111111	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x08, /* 0x00001000	  T */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
	0x00, /* 0x00000000	  T */
      };
static struct raster qvss_84 = { 8, 15, 1, 1, qvss_84_pixels, 0 };

static u_int32_t qvss_85_pixels [] = {
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x41, /* 0x01000001	  U */
	0x3e, /* 0x00111110	  U */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
	0x00, /* 0x00000000	  U */
      };
static struct raster qvss_85 = { 8, 15, 1, 1, qvss_85_pixels, 0 };

static u_int32_t qvss_86_pixels [] = {
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
	0x41, /* 0x01000001	  V */
	0x41, /* 0x01000001	  V */
	0x41, /* 0x01000001	  V */
	0x22, /* 0x00100010	  V */
	0x22, /* 0x00100010	  V */
	0x22, /* 0x00100010	  V */
	0x14, /* 0x00010100	  V */
	0x14, /* 0x00010100	  V */
	0x14, /* 0x00010100	  V */
	0x08, /* 0x00001000	  V */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
	0x00, /* 0x00000000	  V */
      };
static struct raster qvss_86 = { 8, 15, 1, 1, qvss_86_pixels, 0 };

static u_int32_t qvss_87_pixels [] = {
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x41, /* 0x01000001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x49, /* 0x01001001	  W */
	0x55, /* 0x01010101	  W */
	0x22, /* 0x00100010	  W */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
	0x00, /* 0x00000000	  W */
      };
static struct raster qvss_87 = { 8, 15, 1, 1, qvss_87_pixels, 0 };

static u_int32_t qvss_88_pixels [] = {
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
	0x41, /* 0x01000001	  X */
	0x41, /* 0x01000001	  X */
	0x22, /* 0x00100010	  X */
	0x14, /* 0x00010100	  X */
	0x08, /* 0x00001000	  X */
	0x08, /* 0x00001000	  X */
	0x14, /* 0x00010100	  X */
	0x22, /* 0x00100010	  X */
	0x41, /* 0x01000001	  X */
	0x41, /* 0x01000001	  X */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
	0x00, /* 0x00000000	  X */
      };
static struct raster qvss_88 = { 8, 15, 1, 1, qvss_88_pixels, 0 };

static u_int32_t qvss_89_pixels [] = {
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
	0x41, /* 0x01000001	  Y */
	0x41, /* 0x01000001	  Y */
	0x22, /* 0x00100010	  Y */
	0x14, /* 0x00010100	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x08, /* 0x00001000	  Y */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
	0x00, /* 0x00000000	  Y */
      };
static struct raster qvss_89 = { 8, 15, 1, 1, qvss_89_pixels, 0 };

static u_int32_t qvss_90_pixels [] = {
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
	0x7f, /* 0x01111111	  Z */
	0x40, /* 0x01000000	  Z */
	0x20, /* 0x00100000	  Z */
	0x10, /* 0x00010000	  Z */
	0x08, /* 0x00001000	  Z */
	0x04, /* 0x00000100	  Z */
	0x02, /* 0x00000010	  Z */
	0x01, /* 0x00000001	  Z */
	0x01, /* 0x00000001	  Z */
	0x7f, /* 0x01111111	  Z */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
	0x00, /* 0x00000000	  Z */
      };
static struct raster qvss_90 = { 8, 15, 1, 1, qvss_90_pixels, 0 };

static u_int32_t qvss_91_pixels [] = {
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
	0x3c, /* 0x00111100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x04, /* 0x00000100	  [ */
	0x3c, /* 0x00111100	  [ */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
	0x00, /* 0x00000000	  [ */
      };
static struct raster qvss_91 = { 8, 15, 1, 1, qvss_91_pixels, 0 };

static u_int32_t qvss_92_pixels [] = {
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x01, /* 0x00000001	  \ */
	0x02, /* 0x00000010	  \ */
	0x02, /* 0x00000010	  \ */
	0x04, /* 0x00000100	  \ */
	0x08, /* 0x00001000	  \ */
	0x08, /* 0x00001000	  \ */
	0x10, /* 0x00010000	  \ */
	0x20, /* 0x00100000	  \ */
	0x20, /* 0x00100000	  \ */
	0x40, /* 0x01000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
	0x00, /* 0x00000000	  \ */
      };
static struct raster qvss_92 = { 8, 15, 1, 1, qvss_92_pixels, 0 };

static u_int32_t qvss_93_pixels [] = {
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
	0x1e, /* 0x00011110	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x10, /* 0x00010000	  ] */
	0x1e, /* 0x00011110	  ] */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
	0x00, /* 0x00000000	  ] */
      };
static struct raster qvss_93 = { 8, 15, 1, 1, qvss_93_pixels, 0 };

static u_int32_t qvss_94_pixels [] = {
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x08, /* 0x00001000	  ^ */
	0x14, /* 0x00010100	  ^ */
	0x22, /* 0x00100010	  ^ */
	0x41, /* 0x01000001	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
	0x00, /* 0x00000000	  ^ */
      };
static struct raster qvss_94 = { 8, 15, 1, 1, qvss_94_pixels, 0 };

static u_int32_t qvss_95_pixels [] = {
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
	0x7f, /* 0x01111111	  _ */
	0x00, /* 0x00000000	  _ */
	0x00, /* 0x00000000	  _ */
      };
static struct raster qvss_95 = { 8, 15, 1, 1, qvss_95_pixels, 0 };

static u_int32_t qvss_96_pixels [] = {
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x0e, /* 0x00001110	  ` */
	0x0c, /* 0x00001100	  ` */
	0x10, /* 0x00010000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
	0x00, /* 0x00000000	  ` */
      };
static struct raster qvss_96 = { 8, 15, 1, 1, qvss_96_pixels, 0 };

static u_int32_t qvss_97_pixels [] = {
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x3e, /* 0x00111110	  a */
	0x40, /* 0x01000000	  a */
	0x40, /* 0x01000000	  a */
	0x7e, /* 0x01111110	  a */
	0x41, /* 0x01000001	  a */
	0x61, /* 0x01100001	  a */
	0x5e, /* 0x01011110	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
	0x00, /* 0x00000000	  a */
      };
static struct raster qvss_97 = { 8, 15, 1, 1, qvss_97_pixels, 0 };

static u_int32_t qvss_98_pixels [] = {
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
	0x01, /* 0x00000001	  b */
	0x01, /* 0x00000001	  b */
	0x01, /* 0x00000001	  b */
	0x3d, /* 0x00111101	  b */
	0x43, /* 0x01000011	  b */
	0x41, /* 0x01000001	  b */
	0x41, /* 0x01000001	  b */
	0x41, /* 0x01000001	  b */
	0x43, /* 0x01000011	  b */
	0x3d, /* 0x00111101	  b */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
	0x00, /* 0x00000000	  b */
      };
static struct raster qvss_98 = { 8, 15, 1, 1, qvss_98_pixels, 0 };

static u_int32_t qvss_99_pixels [] = {
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x3e, /* 0x00111110	  c */
	0x41, /* 0x01000001	  c */
	0x01, /* 0x00000001	  c */
	0x01, /* 0x00000001	  c */
	0x01, /* 0x00000001	  c */
	0x41, /* 0x01000001	  c */
	0x3e, /* 0x00111110	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
	0x00, /* 0x00000000	  c */
      };
static struct raster qvss_99 = { 8, 15, 1, 1, qvss_99_pixels, 0 };

static u_int32_t qvss_100_pixels [] = {
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
	0x40, /* 0x01000000	  d */
	0x40, /* 0x01000000	  d */
	0x40, /* 0x01000000	  d */
	0x5e, /* 0x01011110	  d */
	0x61, /* 0x01100001	  d */
	0x41, /* 0x01000001	  d */
	0x41, /* 0x01000001	  d */
	0x41, /* 0x01000001	  d */
	0x61, /* 0x01100001	  d */
	0x5e, /* 0x01011110	  d */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
	0x00, /* 0x00000000	  d */
      };
static struct raster qvss_100 = { 8, 15, 1, 1, qvss_100_pixels, 0 };

static u_int32_t qvss_101_pixels [] = {
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x3e, /* 0x00111110	  e */
	0x41, /* 0x01000001	  e */
	0x41, /* 0x01000001	  e */
	0x7f, /* 0x01111111	  e */
	0x01, /* 0x00000001	  e */
	0x01, /* 0x00000001	  e */
	0x3e, /* 0x00111110	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
	0x00, /* 0x00000000	  e */
      };
static struct raster qvss_101 = { 8, 15, 1, 1, qvss_101_pixels, 0 };

static u_int32_t qvss_102_pixels [] = {
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
	0x38, /* 0x00111000	  f */
	0x44, /* 0x01000100	  f */
	0x44, /* 0x01000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x1f, /* 0x00011111	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x04, /* 0x00000100	  f */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
	0x00, /* 0x00000000	  f */
      };
static struct raster qvss_102 = { 8, 15, 1, 1, qvss_102_pixels, 0 };

static u_int32_t qvss_103_pixels [] = {
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x00, /* 0x00000000	  g */
	0x5e, /* 0x01011110	  g */
	0x21, /* 0x00100001	  g */
	0x21, /* 0x00100001	  g */
	0x21, /* 0x00100001	  g */
	0x1e, /* 0x00011110	  g */
	0x01, /* 0x00000001	  g */
	0x3e, /* 0x00111110	  g */
	0x41, /* 0x01000001	  g */
	0x41, /* 0x01000001	  g */
	0x3e, /* 0x00111110	  g */
      };
static struct raster qvss_103 = { 8, 15, 1, 1, qvss_103_pixels, 0 };

static u_int32_t qvss_104_pixels [] = {
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
	0x01, /* 0x00000001	  h */
	0x01, /* 0x00000001	  h */
	0x01, /* 0x00000001	  h */
	0x3d, /* 0x00111101	  h */
	0x43, /* 0x01000011	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x41, /* 0x01000001	  h */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
	0x00, /* 0x00000000	  h */
      };
static struct raster qvss_104 = { 8, 15, 1, 1, qvss_104_pixels, 0 };

static u_int32_t qvss_105_pixels [] = {
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x08, /* 0x00001000	  i */
	0x00, /* 0x00000000	  i */
	0x0c, /* 0x00001100	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x08, /* 0x00001000	  i */
	0x3e, /* 0x00111110	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
	0x00, /* 0x00000000	  i */
      };
static struct raster qvss_105 = { 8, 15, 1, 1, qvss_105_pixels, 0 };

static u_int32_t qvss_106_pixels [] = {
	0x00, /* 0x00000000	  j */
	0x00, /* 0x00000000	  j */
	0x00, /* 0x00000000	  j */
	0x20, /* 0x00100000	  j */
	0x00, /* 0x00000000	  j */
	0x38, /* 0x00111000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x20, /* 0x00100000	  j */
	0x21, /* 0x00100001	  j */
	0x21, /* 0x00100001	  j */
	0x21, /* 0x00100001	  j */
	0x1e, /* 0x00011110	  j */
      };
static struct raster qvss_106 = { 8, 15, 1, 1, qvss_106_pixels, 0 };

static u_int32_t qvss_107_pixels [] = {
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
	0x01, /* 0x00000001	  k */
	0x01, /* 0x00000001	  k */
	0x01, /* 0x00000001	  k */
	0x41, /* 0x01000001	  k */
	0x31, /* 0x00110001	  k */
	0x0d, /* 0x00001101	  k */
	0x03, /* 0x00000011	  k */
	0x0d, /* 0x00001101	  k */
	0x31, /* 0x00110001	  k */
	0x41, /* 0x01000001	  k */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
	0x00, /* 0x00000000	  k */
      };
static struct raster qvss_107 = { 8, 15, 1, 1, qvss_107_pixels, 0 };

static u_int32_t qvss_108_pixels [] = {
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
	0x0c, /* 0x00001100	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x08, /* 0x00001000	  l */
	0x3e, /* 0x00111110	  l */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
	0x00, /* 0x00000000	  l */
      };
static struct raster qvss_108 = { 8, 15, 1, 1, qvss_108_pixels, 0 };

static u_int32_t qvss_109_pixels [] = {
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x37, /* 0x00110111	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x49, /* 0x01001001	  m */
	0x41, /* 0x01000001	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
	0x00, /* 0x00000000	  m */
      };
static struct raster qvss_109 = { 8, 15, 1, 1, qvss_109_pixels, 0 };

static u_int32_t qvss_110_pixels [] = {
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x3d, /* 0x00111101	  n */
	0x43, /* 0x01000011	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x41, /* 0x01000001	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
	0x00, /* 0x00000000	  n */
      };
static struct raster qvss_110 = { 8, 15, 1, 1, qvss_110_pixels, 0 };

static u_int32_t qvss_111_pixels [] = {
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x3e, /* 0x00111110	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x41, /* 0x01000001	  o */
	0x3e, /* 0x00111110	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
	0x00, /* 0x00000000	  o */
      };
static struct raster qvss_111 = { 8, 15, 1, 1, qvss_111_pixels, 0 };

static u_int32_t qvss_112_pixels [] = {
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x00, /* 0x00000000	  p */
	0x3d, /* 0x00111101	  p */
	0x43, /* 0x01000011	  p */
	0x41, /* 0x01000001	  p */
	0x41, /* 0x01000001	  p */
	0x41, /* 0x01000001	  p */
	0x43, /* 0x01000011	  p */
	0x3d, /* 0x00111101	  p */
	0x01, /* 0x00000001	  p */
	0x01, /* 0x00000001	  p */
	0x01, /* 0x00000001	  p */
      };
static struct raster qvss_112 = { 8, 15, 1, 1, qvss_112_pixels, 0 };

static u_int32_t qvss_113_pixels [] = {
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x00, /* 0x00000000	  q */
	0x5e, /* 0x01011110	  q */
	0x61, /* 0x01100001	  q */
	0x41, /* 0x01000001	  q */
	0x41, /* 0x01000001	  q */
	0x41, /* 0x01000001	  q */
	0x61, /* 0x01100001	  q */
	0x5e, /* 0x01011110	  q */
	0x40, /* 0x01000000	  q */
	0x40, /* 0x01000000	  q */
	0x40, /* 0x01000000	  q */
      };
static struct raster qvss_113 = { 8, 15, 1, 1, qvss_113_pixels, 0 };

static u_int32_t qvss_114_pixels [] = {
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x39, /* 0x00111001	  r */
	0x46, /* 0x01000110	  r */
	0x42, /* 0x01000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x02, /* 0x00000010	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
	0x00, /* 0x00000000	  r */
      };
static struct raster qvss_114 = { 8, 15, 1, 1, qvss_114_pixels, 0 };

static u_int32_t qvss_115_pixels [] = {
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x3e, /* 0x00111110	  s */
	0x41, /* 0x01000001	  s */
	0x01, /* 0x00000001	  s */
	0x3e, /* 0x00111110	  s */
	0x40, /* 0x01000000	  s */
	0x41, /* 0x01000001	  s */
	0x3e, /* 0x00111110	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
	0x00, /* 0x00000000	  s */
      };
static struct raster qvss_115 = { 8, 15, 1, 1, qvss_115_pixels, 0 };

static u_int32_t qvss_116_pixels [] = {
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x3f, /* 0x00111111	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x04, /* 0x00000100	  t */
	0x44, /* 0x01000100	  t */
	0x38, /* 0x00111000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
	0x00, /* 0x00000000	  t */
      };
static struct raster qvss_116 = { 8, 15, 1, 1, qvss_116_pixels, 0 };

static u_int32_t qvss_117_pixels [] = {
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x21, /* 0x00100001	  u */
	0x5e, /* 0x01011110	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
	0x00, /* 0x00000000	  u */
      };
static struct raster qvss_117 = { 8, 15, 1, 1, qvss_117_pixels, 0 };

static u_int32_t qvss_118_pixels [] = {
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x41, /* 0x01000001	  v */
	0x41, /* 0x01000001	  v */
	0x22, /* 0x00100010	  v */
	0x22, /* 0x00100010	  v */
	0x14, /* 0x00010100	  v */
	0x14, /* 0x00010100	  v */
	0x08, /* 0x00001000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
	0x00, /* 0x00000000	  v */
      };
static struct raster qvss_118 = { 8, 15, 1, 1, qvss_118_pixels, 0 };

static u_int32_t qvss_119_pixels [] = {
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x41, /* 0x01000001	  w */
	0x41, /* 0x01000001	  w */
	0x49, /* 0x01001001	  w */
	0x49, /* 0x01001001	  w */
	0x49, /* 0x01001001	  w */
	0x55, /* 0x01010101	  w */
	0x22, /* 0x00100010	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
	0x00, /* 0x00000000	  w */
      };
static struct raster qvss_119 = { 8, 15, 1, 1, qvss_119_pixels, 0 };

static u_int32_t qvss_120_pixels [] = {
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x41, /* 0x01000001	  x */
	0x22, /* 0x00100010	  x */
	0x14, /* 0x00010100	  x */
	0x08, /* 0x00001000	  x */
	0x14, /* 0x00010100	  x */
	0x22, /* 0x00100010	  x */
	0x41, /* 0x01000001	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
	0x00, /* 0x00000000	  x */
      };
static struct raster qvss_120 = { 8, 15, 1, 1, qvss_120_pixels, 0 };

static u_int32_t qvss_121_pixels [] = {
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x00, /* 0x00000000	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x21, /* 0x00100001	  y */
	0x31, /* 0x00110001	  y */
	0x2e, /* 0x00101110	  y */
	0x20, /* 0x00100000	  y */
	0x21, /* 0x00100001	  y */
	0x1e, /* 0x00011110	  y */
      };
static struct raster qvss_121 = { 8, 15, 1, 1, qvss_121_pixels, 0 };

static u_int32_t qvss_122_pixels [] = {
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x7f, /* 0x01111111	  z */
	0x20, /* 0x00100000	  z */
	0x10, /* 0x00010000	  z */
	0x08, /* 0x00001000	  z */
	0x04, /* 0x00000100	  z */
	0x02, /* 0x00000010	  z */
	0x7f, /* 0x01111111	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
	0x00, /* 0x00000000	  z */
      };
static struct raster qvss_122 = { 8, 15, 1, 1, qvss_122_pixels, 0 };

static u_int32_t qvss_123_pixels [] = {
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
	0x70, /* 0x01110000	  { */
	0x08, /* 0x00001000	  { */
	0x08, /* 0x00001000	  { */
	0x10, /* 0x00010000	  { */
	0x0c, /* 0x00001100	  { */
	0x0c, /* 0x00001100	  { */
	0x10, /* 0x00010000	  { */
	0x08, /* 0x00001000	  { */
	0x08, /* 0x00001000	  { */
	0x70, /* 0x01110000	  { */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
	0x00, /* 0x00000000	  { */
      };
static struct raster qvss_123 = { 8, 15, 1, 1, qvss_123_pixels, 0 };

static u_int32_t qvss_124_pixels [] = {
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x08, /* 0x00001000	  | */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
	0x00, /* 0x00000000	  | */
      };
static struct raster qvss_124 = { 8, 15, 1, 1, qvss_124_pixels, 0 };

static u_int32_t qvss_125_pixels [] = {
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
	0x07, /* 0x00000111	  } */
	0x08, /* 0x00001000	  } */
	0x08, /* 0x00001000	  } */
	0x04, /* 0x00000100	  } */
	0x18, /* 0x00011000	  } */
	0x18, /* 0x00011000	  } */
	0x04, /* 0x00000100	  } */
	0x08, /* 0x00001000	  } */
	0x08, /* 0x00001000	  } */
	0x07, /* 0x00000111	  } */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
	0x00, /* 0x00000000	  } */
      };
static struct raster qvss_125 = { 8, 15, 1, 1, qvss_125_pixels, 0 };

static u_int32_t qvss_126_pixels [] = {
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x46, /* 0x01000110	  ~ */
	0x49, /* 0x01001001	  ~ */
	0x31, /* 0x00110001	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
	0x00, /* 0x00000000	  ~ */
      };
static struct raster qvss_126 = { 8, 15, 1, 1, qvss_126_pixels, 0 };

#define	null2 {0}, {0}
#define	null4 null2, null2
#define	null8 null4, null4
#define	null16 null8, null8
#define	null32 null16, null16
#define	null64 null32, null32
#define	null128 null64, null64

struct raster_font qvss = {
    8, 15,
    0, /* ascent */
    RASFONT_FIXEDWIDTH|RASFONT_NOVERTICALMOVEMENT,
    {
	null32,
	{ &qvss_32, 0, -13, 8, 0 },
	{ &qvss_33, 0, -13, 8, 0 },
	{ &qvss_34, 0, -13, 8, 0 },
	{ &qvss_35, 0, -13, 8, 0 },
	{ &qvss_36, 0, -13, 8, 0 },
	{ &qvss_37, 0, -13, 8, 0 },
	{ &qvss_38, 0, -13, 8, 0 },
	{ &qvss_39, 0, -13, 8, 0 },
	{ &qvss_40, 0, -13, 8, 0 },
	{ &qvss_41, 0, -13, 8, 0 },
	{ &qvss_42, 0, -13, 8, 0 },
	{ &qvss_43, 0, -13, 8, 0 },
	{ &qvss_44, 0, -13, 8, 0 },
	{ &qvss_45, 0, -13, 8, 0 },
	{ &qvss_46, 0, -13, 8, 0 },
	{ &qvss_47, 0, -13, 8, 0 },
	{ &qvss_48, 0, -13, 8, 0 },
	{ &qvss_49, 0, -13, 8, 0 },
	{ &qvss_50, 0, -13, 8, 0 },
	{ &qvss_51, 0, -13, 8, 0 },
	{ &qvss_52, 0, -13, 8, 0 },
	{ &qvss_53, 0, -13, 8, 0 },
	{ &qvss_54, 0, -13, 8, 0 },
	{ &qvss_55, 0, -13, 8, 0 },
	{ &qvss_56, 0, -13, 8, 0 },
	{ &qvss_57, 0, -13, 8, 0 },
	{ &qvss_58, 0, -13, 8, 0 },
	{ &qvss_59, 0, -13, 8, 0 },
	{ &qvss_60, 0, -13, 8, 0 },
	{ &qvss_61, 0, -13, 8, 0 },
	{ &qvss_62, 0, -13, 8, 0 },
	{ &qvss_63, 0, -13, 8, 0 },
	{ &qvss_64, 0, -13, 8, 0 },
	{ &qvss_65, 0, -13, 8, 0 },
	{ &qvss_66, 0, -13, 8, 0 },
	{ &qvss_67, 0, -13, 8, 0 },
	{ &qvss_68, 0, -13, 8, 0 },
	{ &qvss_69, 0, -13, 8, 0 },
	{ &qvss_70, 0, -13, 8, 0 },
	{ &qvss_71, 0, -13, 8, 0 },
	{ &qvss_72, 0, -13, 8, 0 },
	{ &qvss_73, 0, -13, 8, 0 },
	{ &qvss_74, 0, -13, 8, 0 },
	{ &qvss_75, 0, -13, 8, 0 },
	{ &qvss_76, 0, -13, 8, 0 },
	{ &qvss_77, 0, -13, 8, 0 },
	{ &qvss_78, 0, -13, 8, 0 },
	{ &qvss_79, 0, -13, 8, 0 },
	{ &qvss_80, 0, -13, 8, 0 },
	{ &qvss_81, 0, -13, 8, 0 },
	{ &qvss_82, 0, -13, 8, 0 },
	{ &qvss_83, 0, -13, 8, 0 },
	{ &qvss_84, 0, -13, 8, 0 },
	{ &qvss_85, 0, -13, 8, 0 },
	{ &qvss_86, 0, -13, 8, 0 },
	{ &qvss_87, 0, -13, 8, 0 },
	{ &qvss_88, 0, -13, 8, 0 },
	{ &qvss_89, 0, -13, 8, 0 },
	{ &qvss_90, 0, -13, 8, 0 },
	{ &qvss_91, 0, -13, 8, 0 },
	{ &qvss_92, 0, -13, 8, 0 },
	{ &qvss_93, 0, -13, 8, 0 },
	{ &qvss_94, 0, -13, 8, 0 },
	{ &qvss_95, 0, -13, 8, 0 },
	{ &qvss_96, 0, -13, 8, 0 },
	{ &qvss_97, 0, -13, 8, 0 },
	{ &qvss_98, 0, -13, 8, 0 },
	{ &qvss_99, 0, -13, 8, 0 },
	{ &qvss_100, 0, -13, 8, 0 },
	{ &qvss_101, 0, -13, 8, 0 },
	{ &qvss_102, 0, -13, 8, 0 },
	{ &qvss_103, 0, -13, 8, 0 },
	{ &qvss_104, 0, -13, 8, 0 },
	{ &qvss_105, 0, -13, 8, 0 },
	{ &qvss_106, 0, -13, 8, 0 },
	{ &qvss_107, 0, -13, 8, 0 },
	{ &qvss_108, 0, -13, 8, 0 },
	{ &qvss_109, 0, -13, 8, 0 },
	{ &qvss_110, 0, -13, 8, 0 },
	{ &qvss_111, 0, -13, 8, 0 },
	{ &qvss_112, 0, -13, 8, 0 },
	{ &qvss_113, 0, -13, 8, 0 },
	{ &qvss_114, 0, -13, 8, 0 },
	{ &qvss_115, 0, -13, 8, 0 },
	{ &qvss_116, 0, -13, 8, 0 },
	{ &qvss_117, 0, -13, 8, 0 },
	{ &qvss_118, 0, -13, 8, 0 },
	{ &qvss_119, 0, -13, 8, 0 },
	{ &qvss_120, 0, -13, 8, 0 },
	{ &qvss_121, 0, -13, 8, 0 },
	{ &qvss_122, 0, -13, 8, 0 },
	{ &qvss_123, 0, -13, 8, 0 },
	{ &qvss_124, 0, -13, 8, 0 },
	{ &qvss_125, 0, -13, 8, 0 },
	{ &qvss_126, 0, -13, 8, 0 },
	{ 0 },
	null128
    },
#ifdef COLORFONT_CACHE
    (struct raster_fontcache*) -1
#endif /*COLORFONT_CACHE*/
};
